/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.sql.ResultSet;
//import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
//import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.VoInterface;
//import jp.mosp.common.common.PoiUtility;

//import jp.mosp.human.dao.MKihonDao;
//import jp.mosp.human.dto.MKihonDto;

//import jp.mosp.payroll.dao.MKintaiDao;
//import jp.mosp.payroll.dto.MKintaiDto;

import jp.mosp.report.dao.ExportDataDao;

//import jp.mosp.system.dao.MExportKintaiDao;
//import jp.mosp.system.dto.MExportKintaiDto;
import jp.mosp.system.dao.MExportDao;
import jp.mosp.system.dto.MExportDto;
import jp.mosp.system.vo.ExportCardVo;

public class ExportCardAction extends MosPAction {

	// R}h
	private static final String CMD_EXPORT_SHOW 	= "S1200";
	//private static final String CMD_EXPORT_OUT 		= "S1205";
	private static final String CMD_EXPORT_DATA	= "S1206";

	// tB[h
	//private List<MKintaiDto>			mKintaiList;
	//private List<MExportKintaiDto>	mExportList;
	//private List<MKihonDto>			mKihonList;

	/**
	 * RXgN^
	 */
	public ExportCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {		
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		// VO̎擾
		ExportCardVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_EXPORT_SHOW)) {
			// \
			show(vo);
		} else if (cmd.equals(CMD_EXPORT_DATA)) {
			// GNX|[g
			export(vo);
		} 
		/*
		else if (cmd.equals(CMD_EXPORT_OUT)) {
			vo = (ExportCardVo)getStoredVo(CommonConst.VO_EXPORT_CARD);
			if (vo == null) {
				vo = new ExportCardVo();
			}
			vo.initVo(cfg, msg, cmd, aspUser, user);
			vo.clearMessage();
			vo.clearErrField();
			storeVo(CommonConst.VO_EXPORT_CARD, vo);
			// p[^擾
			vo.setParams(request);
			Date targetMonth = utility.getYearMonth(vo.getPltYear(), vo.getPltMonth());			
			mExportList = new ArrayList<MExportKintaiDto>();
			mKihonList  = new ArrayList<MKihonDto>();
			mKintaiList = new ArrayList<MKintaiDto>();
			// ΑӃGNX|[gf[^擾
			getMExportKintaiList();			
			// ΑӃf[^擾
			getMKintaiList(targetMonth);
			// l{擾
			getMKihonList(mKintaiList);			
			// [쐬
			PoiUtility poi = makeMKintai(mExportList, mKihonList, mKintaiList, targetMonth);
			// [ݒ
			StringBuffer fileName = new StringBuffer();
			fileName.append(utility.convDateToStringYearMonth(targetMonth));
			fileName.append(CommonConst.FILE_NAME_SEPARATOR);
			fileName.append(CommonConst.FILE_SAMP_M_KINTAI);
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
			request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
			// V[PX𔭍sȂBGNZt@CĂ΂Ȃ߁B
			setNeedProcSeq(false);
		} 
		 */
		else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	protected ExportCardVo getInitVo() {
		return new ExportCardVo();
	}

	/**
	 * 
	 * @param vo	ΏVO
	 */
	protected void init(ExportCardVo vo) {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// v_EXg
		Date date = util.getSystemDate();
		vo.aryPltYear 	= util.getYearArray(MospUtility.getYear (date), 4, 1);
		vo.aryPltMonth	= util.getMonthArray();
	}

	/**
	 * \
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void show(ExportCardVo vo) throws Exception {
		Date date = util.getSystemDate();
		vo.setPltYear(String.valueOf(MospUtility.getYear(date)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(date)));
		// 
		session.removeAttribute(MospConst.ATT_DTO);
		searchExportCard(vo);
		vo.setPageButton();
		sortList(vo);
	}

	/**
	 * GNX|[g
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void export(ExportCardVo vo) throws Exception {
		// p[^擾
		vo.setParams(request);
		// VOɏZbg
		// Export
		vo.setTxtEName(key1);
		// Ώۃt@CID
		vo.setTxtEFile(key2);	
		// o
		StringBuffer fileName = new StringBuffer();
		fileName.append(vo.getPltYear());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(vo.getPltMonth());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(vo.getTxtEFile());
		fileName.append(CommonConst.FILE_COMMON_CSV);
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Iڎ擾
		MExportDao mExportDao = new MExportDao();
		mExportDao.initDao(cfg, cmd, aspUser, user, conn);
		List<MExportDto> listSelected = mExportDao.findForCondition(vo.getTxtEName(), vo.getTxtEFile());
		request.setAttribute(MospConst.ATT_FILE_NAME  , fileName.toString());
		request.setAttribute(MospConst.ATT_FILE_OBJECT, makeHumanData(listSelected, vo.getTxtEFile(), vo.getPltYear(), vo.getPltMonth(), vo));
		// V[PX𔭍sȂB
		setNeedProcSeq(false);
	}

	/**
	 * l쐬
	 * @param vo ΏVO
	 * @return l񕶎
	 * @throws Exception 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws Exception
	 */
	protected StringBuffer makeHumanData(
			List<MExportDto> listSelected,
			String txtEFile,
			String pltYear,
			String pltMonth,
			VoInterface vo
	) throws Exception {
		// [쐬
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		sb.append(appendHeader(listSelected));
		// f[^ǋL
		sb.append(appendData(listSelected, txtEFile, pltYear, pltMonth, vo));
		return sb;
	}

	/**
	 * wb_[ݒ
	 * @param listSelected		ΏۑI}X^
	 * @param sb				Ώۃf[^
	 * @return
	 * <p>
	 * I}X^̃wb_[
	 * <p>
	 * @throws Exception
	 */
	private StringBuffer appendHeader(
			List<MExportDto> listSelected
	) throws Exception {
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		for (int i = 0; i < listSelected.size(); i++) {
			MExportDto ExportDto = (MExportDto)listSelected.get(i);
			// wb_[ݒ
			sb.append(getCsvData(getEFnameItem(ExportDto.getEFname(), 3)));
			// Zp[^ݒ
			if (i == listSelected.size() - 1) {
				sb.append(CommonConst.STR_CSV_NEW_LINE);
			} else {
				sb.append(CommonConst.STR_CSV_SEPARATOR);
			}
		}
		return sb;
	}

	/**
	 * f[^擾
	 * @param txtEFile		Ώۃe[u
	 * @param pltYear		Ώ۔N
	 * @param pltMonth		Ώی
	 * @return
	 * <p>
	 * ɂe[uf[^
	 * </p>
	 * @throws Exception
	 */
	protected StringBuffer appendData(
			List<MExportDto> listSelected,
			String txtEFile,
			String pltYear,
			String pltMonth,
			VoInterface vo
	) throws Exception {
		StringBuffer sb = new StringBuffer();
		// ͈͎擾
		Date startDate = util.getFirstDateOfMonth(pltYear, pltMonth);
		Date endDate   = util.getLastDateOfMonth(pltYear, pltMonth);
		// {AΑӏ擾
		ExportDataDao dao = new ExportDataDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		ResultSet rs = null;
		// l{̏ꍇ
		if (txtEFile.equals(CommonConst.CODE_TABLE_M_KIHON)) {
			rs = dao.findForConditionKihon();
		} 
		// Αӏ̏ꍇ
		else if (txtEFile.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			rs = dao.findForConditionKintai(pltYear + "-" + pltMonth);
		} 
		// oΕ̏ꍇ
		else if (txtEFile.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			rs = dao.findForConditionSyukkinbo(
					util.convDateFormatted(startDate),
					util.convDateFormatted(endDate)
			);
		} 
		// Lx̏ꍇ
		else if (txtEFile.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			rs = dao.findForConditionYukyu(
					util.convDateToInteger(startDate), 
					util.convDateToInteger(endDate)
			);
		}
		// LȊO
		if (rs == null) {
			vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_NO_TARGET_CODE, ""));
			return sb;
		}
		sb.append(appendData(rs, listSelected));
		// I
		dao.closers();
		return sb;
	}

	/**
	 * f[^ǋL
	 * @param sb
	 * @param rs
	 * @param listSelected
	 * @return
	 * @throws Exception
	 */
	protected StringBuffer appendData(
			ResultSet rs,
			List<MExportDto> listSelected
	) throws Exception {
		StringBuffer sb = new StringBuffer();
		while (rs.next()) {
			for (int i = 0; i < listSelected.size(); i++) {
				MExportDto ExportDto = (MExportDto)listSelected.get(i);
				sb.append(getCsvData(rs.getString(getEFnameItem(ExportDto.getEFname(), 2))));
				// Zp[^ݒ
				if (i == listSelected.size() - 1) {
					sb.append(CommonConst.STR_CSV_NEW_LINE);
				} else {
					sb.append(CommonConst.STR_CSV_SEPARATOR);
				}
			}
		}
		return sb;
	}

	/**
	 * Xg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	protected void searchExportCard(ExportCardVo vo) throws Exception {
		//DBRlNV擾
		getConnection();
		MExportDao dao = new MExportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition());
		//ΏۂȂꍇ̃bZ[Wݒ
		if (vo.getEscAryEName().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	protected void sortList(ExportCardVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	protected Comparator<Object> getComparator(String key, ExportCardVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_E_NAME)) {
			comp = new CompExportName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ̂ɂrNX
	 */
	protected static class CompExportName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5375772027347639889L;
		public int compare(Object obj1, Object obj2) {
			MExportDto dto1 = (MExportDto)obj1;
			MExportDto dto2 = (MExportDto)obj2;
			return dto1.getEName().compareTo(dto2.getEName());
		}
	}

	/**
	 * GNX|[gꗗ쐬
	 * @param mExportKintai
	 * @param mKintai
	 * @param targetMonth
	 * @return PoiUtilityCX^X
	 * @throws Exception 
	 */
	/*	
	private PoiUtility makeMKintai(
			List<MExportKintaiDto>mExport,
			List<MKihonDto>mKihon,
			List<MKintaiDto>mKintai,
			Date targetMonth
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + CommonConst.TEMPLATE_SAMP_M_KIHON);
		// wb_[ݒ
		poi.prtItem(0, 0, CommonConst.FILE_SAMP_M_KINTAI);
		poi.prtItem(1, 0, MospUtility.getDateString(targetMonth, CommonConst.FORMAT_YEAR_MONTH));
		int readcnt = 0;
		int row = 3;
		int col = 4;
		// J\
		Iterator<MExportKintaiDto> ite = mExport.iterator();
		while(ite.hasNext()){
			MExportKintaiDto dto = (MExportKintaiDto)ite.next();
			poi.prtItem(row - 1, col, dto.getField());
			poi.prtItem(row, col, dto.getComment());
			col++;
		}
		// Јl
		Iterator<MKihonDto> itMkihon = mKihon.iterator();
		while (itMkihon.hasNext()) {
			MKihonDto dto = (MKihonDto)itMkihon.next();
			if (chkExistDto(dto)) {
				readcnt += 1;
				row += 1;
				// \
				poi.prtItem(row, 0, "");
				// X^C̕
				if((row % 2) == 0) {
					poi.clnCellStyle(0, 4, row, 0);
				} else {
					poi.clnCellStyle(1, 4, row, 0);
				}

				// No.\
				poi.prtItem(row, 1, readcnt);
				// X^C̕
				if((row % 2) == 0) {
					poi.clnCellStyle(0, 4, row, 1);
				} else {
					poi.clnCellStyle(1, 4, row, 1);
				}

				// ЈR[h\
				poi.prtItem(row, 2,  dto.getKCode());
				// X^C̕
				if((row % 2) == 0) {
					poi.clnCellStyle(0, 4, row, 2);
				} else {
					poi.clnCellStyle(1, 4, row, 2);
				}

				// Ј\			
				poi.prtItem(row, 3,  dto.getSimei());
				// X^C̕
				if((row % 2) == 0) {
					poi.clnCellStyle(0, 4, row, 3);
				} else {
					poi.clnCellStyle(1, 4, row, 3);
				}
			}
		}
		// f[^\		
		Iterator<MKintaiDto> it = mKintai.iterator();
		row = 4;		
		while(it.hasNext()){
			MKintaiDto dto = (MKintaiDto)it.next();
			poi.prtItem(row, 4,  dto.getKCode());
			getClnCellStyle(poi, row, 4);
			poi.prtItem(row, 5,  dto.getSikyuYM());
			getClnCellStyle(poi, row, 5);
			poi.prtItem(row, 6,  dto.getSNen());
			getClnCellStyle(poi, row, 6);
			poi.prtItem(row, 7,  dto.getSTuki());
			getClnCellStyle(poi, row, 7);
			poi.prtItem(row, 8,  dto.getSHi());
			getClnCellStyle(poi, row, 8);
			poi.prtItem(row, 9,  dto.getSNissu());
			getClnCellStyle(poi, row, 9);
			poi.prtItem(row, 10, dto.getSKaisu());
			getClnCellStyle(poi, row, 10);
			poi.prtItem(row, 11, dto.getKinmuJi());
			getClnCellStyle(poi, row, 11);
			poi.prtItem(row, 12, dto.getKyukeiJi());
			getClnCellStyle(poi, row, 12);
			poi.prtItem(row, 13, dto.getYukyu());
			getClnCellStyle(poi, row, 13);
			poi.prtItem(row, 14, dto.getTokuKyu());
			getClnCellStyle(poi, row, 14);
			poi.prtItem(row, 15, dto.getKekkin());
			getClnCellStyle(poi, row, 15);
			poi.prtItem(row, 16, dto.getSKekkin());
			getClnCellStyle(poi, row, 16);
			poi.prtItem(row, 17, dto.getSonota());
			getClnCellStyle(poi, row, 17);
			poi.prtItem(row, 18, dto.getTiSoKai());
			getClnCellStyle(poi, row, 18);
			poi.prtItem(row, 19, dto.getTiJikan());
			getClnCellStyle(poi, row, 19);
			poi.prtItem(row, 20, dto.getZaJikan());
			getClnCellStyle(poi, row, 20);
			poi.prtItem(row, 21, dto.getKsJikan());
			getClnCellStyle(poi, row, 21);
			poi.prtItem(row, 22, dto.getSnJikan());
			getClnCellStyle(poi, row, 22);
			poi.prtItem(row, 23, dto.getKaikin());
			getClnCellStyle(poi, row, 23);
			poi.prtItem(row, 24, dto.getSyokujiKaisu());
			getClnCellStyle(poi, row, 24);
			poi.prtItem(row, 25, dto.getCyokuKaisu1());
			getClnCellStyle(poi, row, 25);
			poi.prtItem(row, 26, dto.getCyokuKaisu2());
			getClnCellStyle(poi, row, 26);
			poi.prtItem(row, 27, dto.getCyokuKaisu3());
			getClnCellStyle(poi, row, 27);
			poi.prtItem(row, 28, dto.getHokaKaisu1());
			getClnCellStyle(poi, row, 28);
			poi.prtItem(row, 29, dto.getHokaKaisu2());
			getClnCellStyle(poi, row, 29);
			poi.prtItem(row, 30, dto.getHokaKaisu3());
			getClnCellStyle(poi, row, 30);
			poi.prtItem(row, 31, dto.getHokaKaisu4());
			getClnCellStyle(poi, row, 31);
			poi.prtItem(row, 32, dto.getHokaKaisu5());
			getClnCellStyle(poi, row, 32);
			poi.prtItem(row, 33, dto.getSinseiGaku());
			getClnCellStyle(poi, row, 33);
			row++;
		}
		return poi;
	}
	 */

	/**
	 * ʃ\bh
	 * @param poi
	 * @param row
	 * @param cc
	 * @throws Exception
	 */
	/*	
	private void getClnCellStyle(PoiUtility poi, int row , int cc) throws Exception {
		if((row % 2) == 0) {
			poi.clnCellStyle(0, 4, row, cc);
		} else {
			poi.clnCellStyle(1, 4, row, cc);
		}
	}
	 */

	/**
	 * ΑӃf[^擾
	 * @param targetMonth Ώی
	 * @throws Exception
	 */
	/*	
	private void getMKintaiList(Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// p[^ݒ
		String target = MospUtility.getYear(targetMonth) + CommonConst.STR_SEPARATOR + MospUtility.getMonth(targetMonth);
		// ͈͎擾
		// 
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		mKintaiList = dao.findForExport(target);
	}
	 */

	/**
	 * m_kintai񖼎擾
	 * 
	 * @throws Exception
	 */
	/*	
	private void getMExportKintaiList() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// 
		MExportKintaiDao dao = new MExportKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		mExportList = dao.findForCondition();
	}
	 */

	/**
	 * {f[^擾
	 * 
	 * @throws Exception
	 */
	/*	
	private void getMKihonList(List<MKintaiDto> mKintai) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		MKihonDto mKihonDto = new MKihonDto();
		Iterator<MKintaiDto> it = mKintai.iterator();
		while (it.hasNext()) {
			MKintaiDto mKintaiDto = (MKintaiDto)it.next();
			mKihonDto = dao.findForKey(mKintaiDto.getKCode());
			mKihonList.add(mKihonDto);
		}
	}
	 */

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	/*	
	private void sortList(String key, ExportCardVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}
	 */

}
