/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

import jp.mosp.payroll.dto.MKintaiDto;

public class CompileAmendmentCardVo extends AttendanceCalculateMenuVo {

	private static final long serialVersionUID = 604403997889114402L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/payroll/compileAmendmentCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/js/compileAmendmentCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/css/compileAmendmentCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ATT_CALCULATE_AMENDMENT;

	// 萔
	public static final int MODE_EDIT 		= 1;
	public static final int MODE_IMPOSSIBLE 	= 2;

	// p[^
	public static final String PRM_HID_K_CODE 		= "hidKCode";
	public static final String PRM_HID_YEAR			= "hidYear";
	public static final String PRM_HID_MONTH 			= "hidMonth";

	public static final String PRM_TXT_PRESENCE 				= "txtPresence"			;
	public static final String PRM_TXT_PRESENCE_NUMBER		= "txtPresenceNumber"	;
	public static final String PRM_TXT_WORK_HOUR 				= "txtWorkHour"			;
	public static final String PRM_TXT_WORK_MIN 				= "txtWorkMin"			;
	public static final String PRM_TXT_BREAK_HOUR 			= "txtBreakHour"		;
	public static final String PRM_TXT_BREAK_MIN 				= "txtBreakMin"			;
	public static final String PRM_TXT_PAID_HOLIDAY			= "txtPaidHoliday"		;
	public static final String PRM_TXT_PARTICULAR_HOLIDAY 	= "txtParticularHoliday";
	public static final String PRM_TXT_ABSENCE				= "txtAbsence"			;
	public static final String PRM_TXT_SICK					= "txtSick"				;
	public static final String PRM_TXT_COMPENSATION_DAY		= "txtCompensationDay"	;
	public static final String PRM_TXT_TRANSFER				= "txtTransfer"			;
	public static final String PRM_TXT_OTHER					= "txtOther"			;
	public static final String PRM_TXT_LEAVE_AND_LATE			= "txtLeaveAndLate"		;
	public static final String PRM_TXT_LEAVE_AND_LATE_HOUR	= "txtLeaveAndLateHour"	;
	public static final String PRM_TXT_LEAVE_AND_LATE_MIN		= "txtLeaveAndLateMin"	;
	public static final String PRM_TXT_OVER_HOUR 				= "txtOverHour"			;
	public static final String PRM_TXT_OVER_MIN 				= "txtOverMin"			;
	public static final String PRM_TXT_WORK_ON_HOLIDAY_HOUR 	= "txtWorkOnHolidayHour";
	public static final String PRM_TXT_WORK_ON_HOLIDAY_MIN 	= "txtWorkOnHolidayMin"	;
	public static final String PRM_TXT_LATE_NIGHT_HOUR		= "txtLateNightHour"	;
	public static final String PRM_TXT_LATE_NIGHT_MIN			= "txtLateNightMin"		;
	public static final String PRM_PLT_PERFECT_ATTENDANCE		= "pltPerfectAttendance";
	public static final String PRM_TXT_SYOKUJI 				= "txtSyokuji"			;
	public static final String PRM_TXT_CYOKU1 				= "txtCyoku1"			;	
	public static final String PRM_TXT_CYOKU2 				= "txtCyoku2"			;
	public static final String PRM_TXT_CYOKU3 				= "txtCyoku3"			;
	public static final String PRM_TXT_HOKA1					= "txtHoka1"			;
	public static final String PRM_TXT_HOKA2					= "txtHoka2"			;
	public static final String PRM_TXT_HOKA3	 				= "txtHoka3"			;
	public static final String PRM_TXT_HOKA4					= "txtHoka4"			;
	public static final String PRM_TXT_HOKA5					= "txtHoka5"			;

	public static final String PRM_TXT_2HOUR_HOLIDAY	= "txt2HourHoliday"	;

	// tB[h
	private String	hidKCode;
	private String	hidYear;
	private String	hidMonth;
	private String txtPresence;
	private String txtPresenceNumber;
	private String txtWorkHour;
	private String txtWorkMin;
	private String txtBreakHour;
	private String txtBreakMin;
	private String txtPaidHoliday;
	private String txtParticularHoliday;
	private String txtAbsence;
	private String txtSick;
	private String txtCompensationDay;
	private String txtTransfer;
	private String txtOther;
	private String txtLeaveAndLate;
	private String txtLeaveAndLateHour;
	private String txtLeaveAndLateMin;
	private String txtOverHour;
	private String txtOverMin;
	private String txtWorkOnHolidayHour;
	private String txtWorkOnHolidayMin;
	private String txtLateNightHour;
	private String txtLateNightMin;
	private String pltPerfectAttendance;
	private String txtSyokuji;
	private String txtCyoku1;
	private String txtCyoku2;
	private String txtCyoku3;
	private String txtHoka1;
	private String txtHoka2;
	private String txtHoka3;
	private String txtHoka4;
	private String txtHoka5;

	private String lblKCode;
	private String lblKName;
	private String lblSection;
	private String lblSelectDate;

	private String txt2HourHoliday;

	// [h(1FXVA2F\)
	private int mode;

	// tB[hyѐ
	public static final String NAM_K_CODE 				= CommonConst.NAM_K_CODE;
	public static final String NAM_K_NAME 				= CommonConst.NAM_K_NAME;	
	public static final String NAM_SECTION				= CommonConst.NAM_STATION;
	public static final String NAM_CALCULATE_TARGET 		= CommonConst.NAM_TARGET_MONTH;

	public static final String NAM_PRESENCE 				= CommonConst.NAM_PRESENCE + CommonConst.NAM_NUMBER_OF_DAYS;
	public static final String NAM_PRESENCE_NUMBER 		= CommonConst.NAM_PRESENCE + CommonConst.NAM_NUMBER_OF_TIMES;
	public static final String NAM_WORK_TIME 				= CommonConst.TOTAL_WORK;
	public static final String NAM_BREAK_TIME 			= CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_TIME;
	public static final String NAM_LEAVE_REASON 			= CommonConst.NAM_LEAVE_REASON;
	public static final String NAM_OTHER 					= CommonConst.NAM_OTHER_SHORT + CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_NUMBER_OF_DAYS;

	public static final String NAM_LEAVE_AND_LATE			= CommonConst.NAM_LATE_AND_LEAVE_EARLY + CommonConst.NAM_NUMBER_OF_TIMES;
	public static final String NAM_LEAVE_AND_LATE_TIME	= CommonConst.NAM_LATE_AND_LEAVE_EARLY + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_OVER_TIME 				= CommonConst.NAM_OVERTIME + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_WORK_ON_HOLIDAY_TIME	= CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LATE_NIGHT_TIME		= CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_PERFECT_ATTENDANCE 	= CommonConst.NAM_PERFECT_ATTENDANCE + CommonConst.NAM_ALLOWANCE;

	public static final int    LEN_TIME 			= 2;
	public static final int    LEN_WORK_HOUR 		= 3;
	public static final int    LEN_NUMBER 		= 2;
	public static final int    LEN_DOUBLE_DAYS 	= 4;

	public static final String NAM_2HOUR_HOLIDAY	= CommonConst.NAM_2HOUR_HOLIDAY;

	// 蓖
	public String[][] aryAllowance;

	// xɗR
	public String[][] aryHolidayReason;

	// FΎ蓖L
	public String[][] aryPerfectAttendanceFlag;

	/**
	 * RXgN^
	 */
	public CompileAmendmentCardVo() {
		super();
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		mode = MODE_EDIT;
		lblKCode = "";
		lblKName = "";
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtPresence("0");
		setTxtPresenceNumber("0");
		setTxtWorkHour("0");
		setTxtWorkMin("0");
		setTxtBreakHour("0");
		setTxtBreakMin("0");
		setTxtPaidHoliday("0");
		setTxtParticularHoliday("0");
		setTxtAbsence("0");
		setTxtSick("0");
		setTxtOther("0");
		setTxtLeaveAndLate("0");
		setTxtLeaveAndLateHour("0");
		setTxtLeaveAndLateMin("0");
		setTxtOverHour("0");
		setTxtOverMin("0");
		setTxtWorkOnHolidayHour("0");
		setTxtWorkOnHolidayMin("0");
		setTxtLateNightHour("0");
		setTxtLateNightMin("0");
		setPltPerfectAttendance("0");
		setTxtSyokuji("0");
		setTxtCyoku1("0");
		setTxtCyoku2("0");
		setTxtCyoku3("0");
		setTxtHoka1("0");
		setTxtHoka2("0");
		setTxtHoka3("0");
		setTxtHoka4("0");
		setTxtHoka5("0");

		setTxt2HourHoliday("0");
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		hidKCode 			= request.getParameter(PRM_HID_K_CODE);
		hidYear 			= request.getParameter(PRM_HID_YEAR);
		hidMonth 			= request.getParameter(PRM_HID_MONTH);
		txtPresence 		= request.getParameter(PRM_TXT_PRESENCE);
		txtPresenceNumber	= request.getParameter(PRM_TXT_PRESENCE_NUMBER);
		txtWorkHour 		= request.getParameter(PRM_TXT_WORK_HOUR);
		txtWorkMin 			= request.getParameter(PRM_TXT_WORK_MIN);
		txtBreakHour 		= request.getParameter(PRM_TXT_BREAK_HOUR);
		txtBreakMin 		= request.getParameter(PRM_TXT_BREAK_MIN);
		txtPaidHoliday 		= request.getParameter(PRM_TXT_PAID_HOLIDAY);
		txtParticularHoliday= request.getParameter(PRM_TXT_PARTICULAR_HOLIDAY);
		txtAbsence 			= request.getParameter(PRM_TXT_ABSENCE);
		txtSick 			= request.getParameter(PRM_TXT_SICK);
		txtCompensationDay	= request.getParameter(PRM_TXT_COMPENSATION_DAY);
		txtTransfer			= request.getParameter(PRM_TXT_TRANSFER);
		txtOther 			= request.getParameter(PRM_TXT_OTHER);
		txtLeaveAndLate 	= request.getParameter(PRM_TXT_LEAVE_AND_LATE);
		txtLeaveAndLateHour = request.getParameter(PRM_TXT_LEAVE_AND_LATE_HOUR);
		txtLeaveAndLateMin 	= request.getParameter(PRM_TXT_LEAVE_AND_LATE_MIN);
		txtOverHour 		= request.getParameter(PRM_TXT_OVER_HOUR);
		txtOverMin 			= request.getParameter(PRM_TXT_OVER_MIN);
		txtWorkOnHolidayHour= request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		txtWorkOnHolidayMin = request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_MIN);
		txtLateNightHour 	= request.getParameter(PRM_TXT_LATE_NIGHT_HOUR);
		txtLateNightMin 	= request.getParameter(PRM_TXT_LATE_NIGHT_MIN);
		pltPerfectAttendance= request.getParameter(PRM_PLT_PERFECT_ATTENDANCE);
		txtSyokuji 			= request.getParameter(PRM_TXT_SYOKUJI);
		txtCyoku1 			= request.getParameter(PRM_TXT_CYOKU1);
		txtCyoku2 			= request.getParameter(PRM_TXT_CYOKU2);
		txtCyoku3 			= request.getParameter(PRM_TXT_CYOKU3);
		txtHoka1 			= request.getParameter(PRM_TXT_HOKA1);
		txtHoka2 			= request.getParameter(PRM_TXT_HOKA2);
		txtHoka3 			= request.getParameter(PRM_TXT_HOKA3);
		txtHoka4 			= request.getParameter(PRM_TXT_HOKA4);
		txtHoka5 			= request.getParameter(PRM_TXT_HOKA5);

		txt2HourHoliday = request.getParameter(PRM_TXT_2HOUR_HOLIDAY);
	}

	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(MKintaiDto dto) {
		txtPresence 		= String.valueOf(dto.getSNissu());
		txtPresenceNumber	= String.valueOf(dto.getSKaisu());
		txtWorkHour 		= util.convIntegerTimeToStringHour(dto.getKinmuJi()); 
		txtWorkMin 			= util.convIntegerTimeToStringMinutes(dto.getKinmuJi()); 
		txtBreakHour 		= util.convIntegerTimeToStringHour(dto.getKyukeiJi()); 
		txtBreakMin 		= util.convIntegerTimeToStringMinutes(dto.getKyukeiJi()); 
		txtPaidHoliday 		= String.valueOf(dto.getYukyu()); 
		txtParticularHoliday= String.valueOf(dto.getTokuKyu()); 
		txtAbsence 			= String.valueOf(dto.getKekkin()); 
		txtSick 			= String.valueOf(dto.getSKekkin());
		txtCompensationDay	= String.valueOf(dto.getDaiKyu());
		txtTransfer			= String.valueOf(dto.getFurikae());
		txtOther 			= String.valueOf(dto.getSonota());
		txtLeaveAndLate 	= String.valueOf(dto.getTiSoKai()); 
		txtLeaveAndLateHour = util.convIntegerTimeToStringHour(dto.getTiJikan()); 
		txtLeaveAndLateMin 	= util.convIntegerTimeToStringMinutes(dto.getTiJikan()); 
		txtOverHour 		= util.convIntegerTimeToStringHour(dto.getZaJikan()); 
		txtOverMin 			= util.convIntegerTimeToStringMinutes(dto.getZaJikan()); 
		txtWorkOnHolidayHour= util.convIntegerTimeToStringHour(dto.getKsJikan()); 
		txtWorkOnHolidayMin = util.convIntegerTimeToStringMinutes(dto.getKsJikan()); 
		txtLateNightHour 	= util.convIntegerTimeToStringHour(dto.getSnJikan()); 
		txtLateNightMin 	= util.convIntegerTimeToStringMinutes(dto.getSnJikan()); 
		pltPerfectAttendance= String.valueOf(dto.getKaikin());
		txtSyokuji 			= String.valueOf(dto.getSyokujiKaisu()); 
		txtCyoku1 			= String.valueOf(dto.getCyokuKaisu1()); 
		txtCyoku2 			= String.valueOf(dto.getCyokuKaisu2()); 
		txtCyoku3 			= String.valueOf(dto.getCyokuKaisu3()); 
		txtHoka1 			= String.valueOf(dto.getHokaKaisu1()); 
		txtHoka2 			= String.valueOf(dto.getHokaKaisu2()); 
		txtHoka3 			= String.valueOf(dto.getHokaKaisu3()); 
		txtHoka4 			= String.valueOf(dto.getHokaKaisu4()); 
		txtHoka5 			= String.valueOf(dto.getHokaKaisu5());

		txt2HourHoliday = String.valueOf(dto.getNijiKyu());
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MKintaiDto dto) {
		dto.setKCode		(hidKCode);
		dto.setSNen			(getIntParam(hidYear));
		dto.setSTuki		(getIntParam(hidMonth));
		dto.setSNissu		(getDoubleParam(txtPresence));
		dto.setSKaisu		(getIntParam(txtPresenceNumber));
		dto.setKinmuJi		(util.convStringTimeToIntegerTime(txtWorkHour, txtWorkMin));
		dto.setKyukeiJi		(util.convStringTimeToIntegerTime(txtBreakHour, txtBreakMin));
		dto.setYukyu		(getDoubleParam(txtPaidHoliday));
		dto.setTokuKyu		(getDoubleParam(txtParticularHoliday));
		dto.setKekkin		(getDoubleParam(txtAbsence));
		dto.setSKekkin		(getDoubleParam(txtSick));
		dto.setDaiKyu		(getDoubleParam(txtCompensationDay));
		dto.setFurikae		(getDoubleParam(txtTransfer));
		dto.setSonota		(getIntParam(txtOther));
		dto.setTiSoKai		(getIntParam(txtLeaveAndLate));
		dto.setTiJikan		(util.convStringTimeToIntegerTime(txtLeaveAndLateHour, txtLeaveAndLateMin));
		dto.setZaJikan		(util.convStringTimeToIntegerTime(txtOverHour, txtOverMin));
		dto.setKsJikan		(util.convStringTimeToIntegerTime(txtWorkOnHolidayMin, txtWorkOnHolidayMin));
		dto.setSnJikan		(util.convStringTimeToIntegerTime(txtLateNightHour, txtLateNightMin));
		dto.setKaikin		(getIntParam(pltPerfectAttendance));
		dto.setSyokujiKaisu	(getIntParam(txtSyokuji));
		dto.setCyokuKaisu1	(getIntParam(txtCyoku1));
		dto.setCyokuKaisu2	(getIntParam(txtCyoku2));
		dto.setCyokuKaisu3	(getIntParam(txtCyoku3));
		dto.setHokaKaisu1	(getIntParam(txtHoka1));
		dto.setHokaKaisu2	(getIntParam(txtHoka2));
		dto.setHokaKaisu3	(getIntParam(txtHoka3));
		dto.setHokaKaisu4	(getIntParam(txtHoka4));
		dto.setHokaKaisu5	(getIntParam(txtHoka5));

		dto.setNijiKyu(getIntParam(txt2HourHoliday));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtPresence			, NAM_PRESENCE				, PRM_TXT_PRESENCE);
		checkRequired(txtPresenceNumber		, NAM_PRESENCE_NUMBER		, PRM_TXT_PRESENCE_NUMBER);
		checkRequired(txtWorkHour			, NAM_WORK_TIME				, PRM_TXT_WORK_HOUR);
		checkRequired(txtWorkMin			, NAM_WORK_TIME				, PRM_TXT_WORK_MIN);
		checkRequired(txtBreakHour			, NAM_BREAK_TIME			, PRM_TXT_BREAK_HOUR);
		checkRequired(txtBreakMin			, NAM_BREAK_TIME			, PRM_TXT_BREAK_MIN);
		checkRequired(txtPaidHoliday		, aryHolidayReason[0][1]	, PRM_TXT_PAID_HOLIDAY);
		checkRequired(txtParticularHoliday	, aryHolidayReason[1][1]	, PRM_TXT_PARTICULAR_HOLIDAY);
		checkRequired(txtAbsence			, aryHolidayReason[2][1]	, PRM_TXT_ABSENCE);
		checkRequired(txtSick				, aryHolidayReason[3][1]	, PRM_TXT_SICK);
		checkRequired(txtCompensationDay	, aryHolidayReason[4][1]	, PRM_TXT_COMPENSATION_DAY);
		checkRequired(txtTransfer			, aryHolidayReason[5][1]	, PRM_TXT_TRANSFER);
		checkRequired(txtOther				, NAM_OTHER					, PRM_TXT_OTHER);
		checkRequired(txtLeaveAndLate		, NAM_LEAVE_AND_LATE		, PRM_TXT_LEAVE_AND_LATE);
		checkRequired(txtLeaveAndLateHour	, NAM_LEAVE_AND_LATE_TIME	, PRM_TXT_LEAVE_AND_LATE_HOUR);
		checkRequired(txtLeaveAndLateMin	, NAM_LEAVE_AND_LATE_TIME	, PRM_TXT_LEAVE_AND_LATE_MIN);
		checkRequired(txtOverHour			, NAM_OVER_TIME				, PRM_TXT_OVER_HOUR);
		checkRequired(txtOverMin			, NAM_OVER_TIME				, PRM_TXT_OVER_MIN);
		checkRequired(txtWorkOnHolidayHour	, NAM_WORK_ON_HOLIDAY_TIME	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkRequired(txtWorkOnHolidayMin	, NAM_WORK_ON_HOLIDAY_TIME	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkRequired(txtLateNightHour		, NAM_LATE_NIGHT_TIME		, PRM_TXT_LATE_NIGHT_HOUR);
		checkRequired(txtLateNightMin		, NAM_LATE_NIGHT_TIME		, PRM_TXT_LATE_NIGHT_MIN);
		checkRequired(txtSyokuji			, aryAllowance[8 ][1]		, PRM_TXT_SYOKUJI);
		checkRequired(txtCyoku1				, aryAllowance[9 ][1]		, PRM_TXT_CYOKU1);
		checkRequired(txtCyoku2				, aryAllowance[10][1]		, PRM_TXT_CYOKU2);
		checkRequired(txtCyoku3				, aryAllowance[11][1]		, PRM_TXT_CYOKU3);
		checkRequired(txtHoka1				, aryAllowance[12][1]		, PRM_TXT_HOKA1);
		checkRequired(txtHoka2				, aryAllowance[13][1]		, PRM_TXT_HOKA2);
		checkRequired(txtHoka3				, aryAllowance[14][1]		, PRM_TXT_HOKA3);
		checkRequired(txtHoka4				, aryAllowance[15][1]		, PRM_TXT_HOKA4);
		checkRequired(txtHoka5				, aryAllowance[16][1]		, PRM_TXT_HOKA5);
		/*						
		 *  	2008/10/16	m.yoshida	2ԔNx	VersionΉ
		 */	
		//checkRequired(txt2HourHoliday		, NAM_2HOUR_HOLIDAY		, PRM_TXT_2HOUR_HOLIDAY);
		// 񒷊mF
		checkLength(txtPresence			, LEN_DOUBLE_DAYS	, NAM_PRESENCE				, PRM_TXT_PRESENCE);
		checkLength(txtPresenceNumber	, LEN_DOUBLE_DAYS	, NAM_PRESENCE_NUMBER		, PRM_TXT_PRESENCE_NUMBER);
		checkLength(txtWorkHour			, LEN_WORK_HOUR		, NAM_WORK_TIME				, PRM_TXT_WORK_HOUR);
		checkLength(txtWorkMin			, LEN_TIME			, NAM_WORK_TIME				, PRM_TXT_WORK_MIN);
		checkLength(txtBreakHour		, LEN_TIME			, NAM_BREAK_TIME			, PRM_TXT_BREAK_HOUR);
		checkLength(txtBreakMin			, LEN_TIME			, NAM_BREAK_TIME			, PRM_TXT_BREAK_MIN);
		checkLength(txtPaidHoliday		, LEN_DOUBLE_DAYS	, aryHolidayReason[0][1]	, PRM_TXT_PAID_HOLIDAY);
		checkLength(txtParticularHoliday, LEN_DOUBLE_DAYS	, aryHolidayReason[1][1]	, PRM_TXT_PARTICULAR_HOLIDAY);
		checkLength(txtAbsence			, LEN_DOUBLE_DAYS	, aryHolidayReason[2][1]	, PRM_TXT_ABSENCE);
		checkLength(txtSick				, LEN_DOUBLE_DAYS	, aryHolidayReason[3][1]	, PRM_TXT_SICK);
		checkLength(txtCompensationDay	, LEN_DOUBLE_DAYS	, aryHolidayReason[4][1]	, PRM_TXT_COMPENSATION_DAY);
		checkLength(txtTransfer			, LEN_DOUBLE_DAYS	, aryHolidayReason[5][1]	, PRM_TXT_TRANSFER);
		checkLength(txtOther			, LEN_DOUBLE_DAYS	, NAM_OTHER					, PRM_TXT_OTHER);
		checkLength(txtLeaveAndLate		, LEN_NUMBER		, NAM_LEAVE_AND_LATE		, PRM_TXT_LEAVE_AND_LATE);
		checkLength(txtLeaveAndLateHour	, LEN_TIME			, NAM_LEAVE_AND_LATE_TIME	, PRM_TXT_LEAVE_AND_LATE_HOUR);
		checkLength(txtLeaveAndLateMin	, LEN_TIME			, NAM_LEAVE_AND_LATE_TIME	, PRM_TXT_LEAVE_AND_LATE_MIN);
		checkLength(txtOverHour			, LEN_TIME			, NAM_OVER_TIME				, PRM_TXT_OVER_HOUR);
		checkLength(txtOverMin			, LEN_TIME			, NAM_OVER_TIME				, PRM_TXT_OVER_MIN);
		checkLength(txtWorkOnHolidayHour, LEN_TIME			, NAM_WORK_ON_HOLIDAY_TIME	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkLength(txtWorkOnHolidayMin	, LEN_TIME			, NAM_WORK_ON_HOLIDAY_TIME	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkLength(txtLateNightHour	, LEN_TIME			, NAM_LATE_NIGHT_TIME		, PRM_TXT_LATE_NIGHT_HOUR);
		checkLength(txtLateNightMin		, LEN_TIME			, NAM_LATE_NIGHT_TIME		, PRM_TXT_LATE_NIGHT_MIN);
		checkLength(txtSyokuji			, LEN_NUMBER		, aryAllowance[8 ][1]		, PRM_TXT_SYOKUJI);
		checkLength(txtCyoku1			, LEN_NUMBER		, aryAllowance[9 ][1]		, PRM_TXT_CYOKU1);
		checkLength(txtCyoku2			, LEN_NUMBER		, aryAllowance[10][1]		, PRM_TXT_CYOKU2);
		checkLength(txtCyoku3			, LEN_NUMBER		, aryAllowance[11][1]		, PRM_TXT_CYOKU3);
		checkLength(txtHoka1			, LEN_NUMBER		, aryAllowance[12][1]		, PRM_TXT_HOKA1);
		checkLength(txtHoka2			, LEN_NUMBER		, aryAllowance[13][1]		, PRM_TXT_HOKA2);
		checkLength(txtHoka3			, LEN_NUMBER		, aryAllowance[14][1]		, PRM_TXT_HOKA3);
		checkLength(txtHoka4			, LEN_NUMBER		, aryAllowance[15][1]		, PRM_TXT_HOKA4);
		checkLength(txtHoka5			, LEN_NUMBER		, aryAllowance[16][1]		, PRM_TXT_HOKA5);
		/*						
		 *  	2008/10/16	m.yoshida	2ԔNx	VersionΉ
		 */	
		//checkLength(txt2HourHoliday		, LEN_NUMBER , NAM_2HOUR_HOLIDAY		, PRM_TXT_2HOUR_HOLIDAY);
		// ^CvmF
		checkNumeric(txtPresence			, NAM_PRESENCE				, PRM_TXT_PRESENCE);
		checkNumber(txtPresenceNumber		, NAM_PRESENCE_NUMBER		, PRM_TXT_PRESENCE_NUMBER);
		checkNumber(txtWorkHour				, NAM_WORK_TIME				, PRM_TXT_WORK_HOUR);
		checkNumber(txtWorkMin				, NAM_WORK_TIME				, PRM_TXT_WORK_MIN);
		checkNumber(txtBreakHour			, NAM_BREAK_TIME			, PRM_TXT_BREAK_HOUR);
		checkNumber(txtBreakMin				, NAM_BREAK_TIME			, PRM_TXT_BREAK_MIN);
		checkNumeric(txtPaidHoliday			, aryHolidayReason[0][1]	, PRM_TXT_PAID_HOLIDAY);
		checkNumeric(txtParticularHoliday	, aryHolidayReason[1][1]	, PRM_TXT_PARTICULAR_HOLIDAY);
		checkNumeric(txtAbsence				, aryHolidayReason[2][1]	, PRM_TXT_ABSENCE);
		checkNumeric(txtSick				, aryHolidayReason[3][1]	, PRM_TXT_SICK);
		checkNumeric(txtCompensationDay		, aryHolidayReason[4][1]	, PRM_TXT_COMPENSATION_DAY);
		checkNumeric(txtTransfer			, aryHolidayReason[5][1]	, PRM_TXT_TRANSFER);
		checkNumber(txtOther				, NAM_OTHER					, PRM_TXT_OTHER);
		checkNumber(txtLeaveAndLate			, NAM_LEAVE_AND_LATE		, PRM_TXT_LEAVE_AND_LATE);
		checkNumber(txtLeaveAndLateHour		, NAM_LEAVE_AND_LATE_TIME	, PRM_TXT_LEAVE_AND_LATE_HOUR);
		checkNumber(txtLeaveAndLateMin		, NAM_LEAVE_AND_LATE_TIME	, PRM_TXT_LEAVE_AND_LATE_MIN);
		checkNumber(txtOverHour				, NAM_OVER_TIME				, PRM_TXT_OVER_HOUR);
		checkNumber(txtOverMin				, NAM_OVER_TIME				, PRM_TXT_OVER_MIN);
		checkNumber(txtWorkOnHolidayHour	, NAM_WORK_ON_HOLIDAY_TIME	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkNumber(txtWorkOnHolidayMin		, NAM_WORK_ON_HOLIDAY_TIME	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkNumber(txtLateNightHour		, NAM_LATE_NIGHT_TIME		, PRM_TXT_LATE_NIGHT_HOUR);
		checkNumber(txtLateNightMin			, NAM_LATE_NIGHT_TIME		, PRM_TXT_LATE_NIGHT_MIN);
		checkNumber(txtSyokuji				, aryAllowance[8 ][1]		, PRM_TXT_SYOKUJI);
		checkNumber(txtCyoku1				, aryAllowance[9 ][1]		, PRM_TXT_CYOKU1);
		checkNumber(txtCyoku2				, aryAllowance[10][1]		, PRM_TXT_CYOKU2);
		checkNumber(txtCyoku3				, aryAllowance[11][1]		, PRM_TXT_CYOKU3);
		checkNumber(txtHoka1				, aryAllowance[12][1]		, PRM_TXT_HOKA1);
		checkNumber(txtHoka2				, aryAllowance[13][1]		, PRM_TXT_HOKA2);
		checkNumber(txtHoka3				, aryAllowance[14][1]		, PRM_TXT_HOKA3);
		checkNumber(txtHoka4				, aryAllowance[15][1]		, PRM_TXT_HOKA4);
		checkNumber(txtHoka5				, aryAllowance[16][1]		, PRM_TXT_HOKA5);
		/*						
		 *  	2008/10/16	m.yoshida	2ԔNx	VersionΉ
		 */	
		//checkNumber(txt2HourHoliday		, NAM_2HOUR_HOLIDAY		, PRM_TXT_2HOUR_HOLIDAY);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append(getSettingJs("ARY_ALLOWANCE"		, aryAllowance		));
		sb.append(getSettingJs("ARY_HOLIDAY_REASON"	, aryHolidayReason	));
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtPresence			() { return txtPresence				; }
	public String getTxtPresenceNumber		() { return txtPresenceNumber		; }
	public String getTxtWorkHour			() { return txtWorkHour				; }
	public String getTxtWorkMin				() { return txtWorkMin				; }
	public String getTxtBreakHour			() { return txtBreakHour			; }
	public String getTxtBreakMin			() { return txtBreakMin				; }
	public String getTxtPaidHoliday			() { return txtPaidHoliday			; }
	public String getTxtParticularHoliday	() { return txtParticularHoliday	; }
	public String getTxtAbsence				() { return txtAbsence				; }
	public String getTxtSick				() { return txtSick					; }
	public String getTxtCompensationDay		() { return txtCompensationDay		; }
	public String getTxtTransfer			() { return txtTransfer				; }
	public String getTxtOther				() { return txtOther				; }
	public String getTxtLeaveAndLate		() { return txtLeaveAndLate			; }
	public String getTxtLeaveAndLateHour	() { return txtLeaveAndLateHour		; }
	public String getTxtLeaveAndLateMin		() { return txtLeaveAndLateMin		; }
	public String getTxtOverHour			() { return txtOverHour				; }
	public String getTxtOverMin				() { return txtOverMin				; }
	public String getTxtWorkOnHolidayHour	() { return txtWorkOnHolidayHour	; }
	public String getTxtWorkOnHolidayMin	() { return txtWorkOnHolidayMin		; }
	public String getTxtLateNightHour		() { return txtLateNightHour		; }
	public String getTxtLateNightMin		() { return txtLateNightMin			; }
	public String getPltPerfectAttendance	() { return pltPerfectAttendance	; }
	public String getTxtSyokuji				() { return txtSyokuji				; }
	public String getTxtCyoku1				() { return txtCyoku1				; }
	public String getTxtCyoku2				() { return txtCyoku2				; }
	public String getTxtCyoku3				() { return txtCyoku3				; }
	public String getTxtHoka1				() { return txtHoka1				; }
	public String getTxtHoka2				() { return txtHoka2				; }
	public String getTxtHoka3				() { return txtHoka3				; }
	public String getTxtHoka4				() { return txtHoka4				; }
	public String getTxtHoka5				() { return txtHoka5				; }

	public String getEscTxtPresence				() { return escapeHTML(txtPresence			); }
	public String getEscTxtPresenceNumber		() { return escapeHTML(txtPresenceNumber	); }
	public String getEscTxtWorkHour				() { return escapeHTML(txtWorkHour			); }
	public String getEscTxtWorkMin				() { return escapeHTML(txtWorkMin			); }
	public String getEscTxtBreakHour			() { return escapeHTML(txtBreakHour			); }
	public String getEscTxtBreakMin				() { return escapeHTML(txtBreakMin			); }
	public String getEscTxtPaidHoliday			() { return escapeHTML(txtPaidHoliday		); }
	public String getEscTxtParticularHoliday	() { return escapeHTML(txtParticularHoliday	); }
	public String getEscTxtAbsence				() { return escapeHTML(txtAbsence			); }
	public String getEscTxtSick					() { return escapeHTML(txtSick				); }
	public String getEscTxtCompensationDay		() { return escapeHTML(txtCompensationDay	); }
	public String getEscTxtTransfer				() { return escapeHTML(txtTransfer			); }
	public String getEscTxtOther				() { return escapeHTML(txtOther				); }
	public String getEscTxtLeaveAndLate			() { return escapeHTML(txtLeaveAndLate		); }
	public String getEscTxtLeaveAndLateHour		() { return escapeHTML(txtLeaveAndLateHour	); }
	public String getEscTxtLeaveAndLateMin		() { return escapeHTML(txtLeaveAndLateMin	); }
	public String getEscTxtOverHour				() { return escapeHTML(txtOverHour			); }
	public String getEscTxtOverMin				() { return escapeHTML(txtOverMin			); }
	public String getEscTxtWorkOnHolidayHour	() { return escapeHTML(txtWorkOnHolidayHour	); }
	public String getEscTxtWorkOnHolidayMin		() { return escapeHTML(txtWorkOnHolidayMin	); }
	public String getEscTxtLateNightHour		() { return escapeHTML(txtLateNightHour		); }
	public String getEscTxtLateNightMin			() { return escapeHTML(txtLateNightMin		); }
	public String getEscTxtSyokuji				() { return escapeHTML(txtSyokuji			); }
	public String getEscTxtCyoku1				() { return escapeHTML(txtCyoku1			); }
	public String getEscTxtCyoku2				() { return escapeHTML(txtCyoku2			); }
	public String getEscTxtCyoku3				() { return escapeHTML(txtCyoku3			); }
	public String getEscTxtHoka1				() { return escapeHTML(txtHoka1				); }
	public String getEscTxtHoka2				() { return escapeHTML(txtHoka2				); }
	public String getEscTxtHoka3				() { return escapeHTML(txtHoka3				); }
	public String getEscTxtHoka4				() { return escapeHTML(txtHoka4				); }
	public String getEscTxtHoka5				() { return escapeHTML(txtHoka5				); }

	public void setTxtPresence				(String txtPresence			) { this.txtPresence 			= txtPresence			; }
	public void setTxtPresenceNumber		(String txtPresenceNumber	) { this.txtPresenceNumber 		= txtPresenceNumber		; }
	public void setTxtWorkHour				(String txtWorkHour			) { this.txtWorkHour 			= txtWorkHour			; }
	public void setTxtWorkMin				(String txtWorkMin			) { this.txtWorkMin 			= txtWorkMin			; }
	public void setTxtBreakHour			(String txtBreakHour		) { this.txtBreakHour 			= txtBreakHour			; }
	public void setTxtBreakMin				(String txtBreakMin			) { this.txtBreakMin 			= txtBreakMin			; }
	public void setTxtPaidHoliday			(String txtPaidHoliday		) { this.txtPaidHoliday 		= txtPaidHoliday		; }
	public void setTxtParticularHoliday	(String txtParticularHoliday) { this.txtParticularHoliday	= txtParticularHoliday	; }
	public void setTxtAbsence				(String txtAbsence			) { this.txtAbsence 			= txtAbsence			; }
	public void setTxtSick					(String txtSick				) { this.txtSick 				= txtSick				; }
	public void setTxtCompensationDay		(String txtCompensationDay	) { this.txtCompensationDay 	= txtCompensationDay	; }
	public void setTxtTransfer				(String txtTransfer			) { this.txtTransfer 			= txtTransfer			; }
	public void setTxtOther				(String txtOther			) { this.txtOther 				= txtOther				; }	
	public void setTxtLeaveAndLate			(String txtLeaveAndLate		) { this.txtLeaveAndLate 		= txtLeaveAndLate		; }
	public void setTxtLeaveAndLateHour		(String txtLeaveAndLateHour	) { this.txtLeaveAndLateHour 	= txtLeaveAndLateHour	; }
	public void setTxtLeaveAndLateMin		(String txtLeaveAndLateMin	) { this.txtLeaveAndLateMin 	= txtLeaveAndLateMin	; }
	public void setTxtOverHour				(String txtOverHour			) { this.txtOverHour 			= txtOverHour			; }
	public void setTxtOverMin				(String txtOverMin			) { this.txtOverMin 			= txtOverMin			; }
	public void setTxtWorkOnHolidayHour	(String txtWorkOnHolidayHour) { this.txtWorkOnHolidayHour	= txtWorkOnHolidayHour	; }
	public void setTxtWorkOnHolidayMin		(String txtWorkOnHolidayMin	) { this.txtWorkOnHolidayMin 	= txtWorkOnHolidayMin	; }
	public void setTxtLateNightHour		(String txtLateNightHour	) { this.txtLateNightHour 		= txtLateNightHour		; }
	public void setTxtLateNightMin			(String txtLateNightMin		) { this.txtLateNightMin 		= txtLateNightMin		; }
	public void setPltPerfectAttendance	(String pltPerfectAttendance) { this.pltPerfectAttendance	= pltPerfectAttendance	; }
	public void setTxtSyokuji				(String txtSyokuji			) { this.txtSyokuji 			= txtSyokuji			; }
	public void setTxtCyoku1				(String txtCyoku1			) { this.txtCyoku1 				= txtCyoku1				; }
	public void setTxtCyoku2				(String txtCyoku2			) { this.txtCyoku2 				= txtCyoku2				; }
	public void setTxtCyoku3				(String txtCyoku3			) { this.txtCyoku3 				= txtCyoku3				; }
	public void setTxtHoka1				(String txtHoka1			) { this.txtHoka1 				= txtHoka1				; }
	public void setTxtHoka2				(String txtHoka2			) { this.txtHoka2 				= txtHoka2				; }
	public void setTxtHoka3				(String txtHoka3			) { this.txtHoka3 				= txtHoka3				; }
	public void setTxtHoka4				(String txtHoka4			) { this.txtHoka4 				= txtHoka4				; }
	public void setTxtHoka5				(String txtHoka5			) { this.txtHoka5 				= txtHoka5				; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

	public String getEscLblKCode		() { return escapeHTML(lblKCode)		; }
	public String getEscLblKName		() { return escapeHTML(lblKName)		; }
	public String getEscLblSection		() { return escapeHTML(lblSection)		; }
	public String getEscLblSelectDate	() { return escapeHTML(lblSelectDate)	; }

	public void setLblKCode		(String lblKCode) 		{ this.lblKCode 		= lblKCode		; }
	public void setLblKName		(String lblKName) 		{ this.lblKName 		= lblKName		; }
	public void setLblSection		(String lblSection) 	{ this.lblSection 		= lblSection	; }
	public void setLblSelectDate	(String lblSelectDate)	{ this.lblSelectDate	= lblSelectDate	; }

	public String getHidKCode	() { return hidKCode	; }
	public String getHidYear	() { return hidYear		; }
	public String getHidMonth	() { return hidMonth	; }

	public void setHidKCode	(String hidKCode) 	{ this.hidKCode 	= hidKCode	; }
	public void setHidYear		(String hidYear) 	{ this.hidYear 		= hidYear	; }
	public void setHidMonth	(String hidMonth) 	{ this.hidMonth 	= hidMonth	; }

	public String[][] getAryAllowance		() { return aryAllowance.clone()		; }
	public String[][] getAryHolidayReason	() { return aryHolidayReason.clone()	; }

	public String getTxt2HourHoliday() { return txt2HourHoliday; }
	public String getEscTxt2HourHoliday() { return escapeHTML(txt2HourHoliday); }

	public void setTxt2HourHoliday(String txt2HourHoliday) { this.txt2HourHoliday = txt2HourHoliday; }

}
