/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.report.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;


import jp.mosp.common.MosPVo;
import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.common.vo.AdjustmentCalcVo;
import jp.mosp.payroll.common.vo.AdjustmentListVo;
import jp.mosp.payroll.common.vo.AdjustmentReferVo;
import jp.mosp.payroll.dao.CdAdjustmentDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.report.dto.PaymentLedgerDto;

public class PaymentLedgerAction extends AdjustmentAction{

	
	// R}h
	private static final String CMD_PAYMENT_LEDGER_ALL = "P3070";
	private static final String CMD_PAYMENT_LEDGER_ONE = "P3071";
	private static final String CMD_PAYMENT_LEDGER_ALL2= "P3072";
	
	public String[][] aryGender  ;
	// ݒe[u
	public List<MosPConfDto> listConf;
	public String[][] aryEra;
	public String[][] aryStation ;
	public String[][] aryPltIncomeTaxType;
	public String[][] aryPltAdjustmentType;
	public String[][] aryPltHandicapType  ;
	public String[][] aryPltWidowType      ;
	public String[][] aryPltStudentType    ;
	public String[][] aryPltSpouseIntendType;
	public String[][] aryPltLiveWithType    ;
	public String[][] aryPltSpouseType      ;
	public String[][] aryPltDependentType   ;
	
	/**
	 * RXgN^
	 */
	public PaymentLedgerAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// DAO
		prepareDao();
		// 擾ϊmF
		if (aryStation != null) {
			return;
		}
		// z擾
		aryStation  = getStationArrayAll() ;
		aryPosition = getPositionArrayAll();
		aryEra      = getCodeArray(PayrollConst.TID_JAPANESE);
		aryPltIncomeTaxType     = LegalConst.INCOME_TAX_ARRAY              ;
		aryPltAdjustmentType    = LegalConst.ADJUSTMENT_ARRAY              ;
		aryPltHandicapType      = LegalConst.HANDICAP_ARRAY                ;
		aryPltWidowType         = LegalConst.WIDOW_ARRAY                   ;
		aryPltStudentType       = LegalConst.STUDENT_ARRAY                 ;
		aryPltSpouseIntendType  = LegalConst.SPOUSE_INTEND_ARRAY           ;
		aryPltLiveWithType      = LegalConst.LIVE_WITH_ARRAY               ;
		aryPltSpouseType        = LegalConst.SPOUSE_ARRAY                  ;
		aryPltDependentType     = LegalConst.DEPENDENT_ARRAY               ;

		
		
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// Ǖw(v) Up
		aryGender  = getCodeArray(PayrollConst.TID_GENDER);
		if (cmd.equals(CMD_PAYMENT_LEDGER_ALL)) {
			// VO̎擾
			AdjustmentListVo vo = (AdjustmentListVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear   = vo.getPltAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate     = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			Date date = vo.getDate(String.valueOf(vo.getPltAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH),  String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<PaymentLedgerDto> list = getPaymentLedger(date, null, vo);
			// [쐬
//			String fileName = vo.getPltAdjustYear ()
//							+ PayrollConst.FILE_PAYMENT_LEDGER;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
//			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else if (cmd.equals(CMD_PAYMENT_LEDGER_ONE)) {
			// VO̎擾
			AdjustmentReferVo vo = (AdjustmentReferVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear   = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate     = getLastDateOfYear(adjustYear);
			// ЈR[hNULL
			vo.setLblChangeKCode(vo.getHidKCode());
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<PaymentLedgerDto> list = getPaymentLedgerOne(date, vo.getHidKCode(), vo);
			for(int i= 0; i < list.size(); i++){
				PaymentLedgerDto dto_tmp = list.get(i);
				if (cfg.getProperty(PayrollConst.PPT_PAY_USEXLS) == null) {
					report(vo, dto_tmp);
				} else {
					reportXls(vo, dto_tmp);
				}
			}
		} else if (cmd.equals(CMD_PAYMENT_LEDGER_ALL2)) {
			// VO̎擾
			AdjustmentCalcVo vo = (AdjustmentCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear   = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate     = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾(Ώ۔N12/1)
//			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH),  String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
//			List<PaymentLedgerDto> list = getPaymentLedger(date, null, vo);
//			// [쐬
//			String fileName = vo.getHidAdjustYear ()
//							+ PayrollConst.FILE_PAYMENT_LEDGER;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
//			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);	
		}
	}
	
	/**
	 * 򒥎[f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<PaymentLedgerDto> getPaymentLedger(
			Date targetMonth, String kCode, AdjustmentListVo vo
	) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao   dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<PaymentLedgerDto> list = new ArrayList<PaymentLedgerDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
			// lݒ
			setHumanInfo(cdAdjustmentDto);
			// ^Aܗ^擾
			setPaymentBonusInfo();
			PaymentLedgerDto dto = new PaymentLedgerDto();
			if (phPaymentDto != null && mKihonDto != null) {
				phBonusDto.setKCode(kCode);
//				phBonusDto.setEmploymentType(phPaymentDto.getEmploymentType());
//				phBonusDto.setPositionCode(phPaymentDto.getPositionCode());
				// Nf[^ݒ
				dto = new PaymentLedgerDto(
						getMapDetail_Pa(),
						getMapDetail_Pd(),
						getMapDetail_Ps(),
						getMapDetail_Pt(),
						getMapDetail_Ba(),
						getMapDetail_Bd(),
						getMapDetail_Bs(),
						cmIncomeTaxDto,
						mKojinDto,
						mKihonDto,
						cmSocInsuranceDto,
						cmCompanyDto,
						cdAdjustmentDto,
						listPaymentData,
						listBonusData,
						pdPayAllowanceDao,	// ^T׃f[^
						pdPayDeductionDao,	// ^x׃f[^
						pdPaySumDao,				// ^׍v
						pdPayTimeDao,
						pdBonAllowanceDao,	// ܗ^T׃f[^
						pdBonDeductionDao,	// ܗ^x׃f[^
						pdBonSumDao			// ܗ^׍v
				);
				// Nژaݒ
				setJapanDate(dto);
				// R[h̐ݒ
				setDtoCodeName(dto);
				
			}
			// Xgɐݒ
			list.add(dto);
		}
		// ^f[^mF
		if (list.size() == 0) {
			setVo(vo);
			setUrl(vo.getRetUrl());
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_ADJUST_REPORT, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_NO_PAYMENT_DETAIL, errMessage);
		}
		
		return list;
	}
	
	
	/**
	 * 򒥎[f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<PaymentLedgerDto> getPaymentLedgerOne(
			Date targetMonth, String kCode, MosPVo vo
	) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao   dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<PaymentLedgerDto> list = new ArrayList<PaymentLedgerDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
		}
		if (listAdjustment.size() == 0) {
			// 
			cdAdjustmentDto = new CdAdjustmentDto();
			// ЈR[hݒ
			cdAdjustmentDto.setKCode(kCode);
		}
		setVo(vo);
		setUrl(vo.getRetUrl());

		// lݒ
		setHumanInfo(cdAdjustmentDto);
		// ^Aܗ^擾
		setPaymentBonusInfo();
		PaymentLedgerDto dto = new PaymentLedgerDto();
		if (phPaymentDto != null && mKihonDto != null) {
			phBonusDto.setKCode(kCode);
//			phBonusDto.setEmploymentType(phPaymentDto.getEmploymentType());
//			phBonusDto.setPositionCode(phPaymentDto.getPositionCode());

			// Nf[^ݒ
			dto = new PaymentLedgerDto(
					getMapDetail_Pa(),
					getMapDetail_Pd(),
					getMapDetail_Ps(),
					getMapDetail_Pt(),
					getMapDetail_Ba(),
					getMapDetail_Bd(),
					getMapDetail_Bs(),
					cmIncomeTaxDto,
					mKojinDto,
					mKihonDto,
					cmSocInsuranceDto,
					cmCompanyDto,
					cdAdjustmentDto,
					listPaymentData,
					listBonusData,
					pdPayAllowanceDao,	// ^T׃f[^
					pdPayDeductionDao,	// ^x׃f[^
					pdPaySumDao,		// ^׍v
					pdPayTimeDao,
					pdBonAllowanceDao,	// ܗ^T׃f[^
					pdBonDeductionDao,	// ܗ^x׃f[^
					pdBonSumDao			// ܗ^׍v
			);
			// Nژaݒ
			setJapanDate(dto);
			// R[h̐ݒ
			setDtoCodeName(dto);
			
		}
		// Xgɐݒ
		list.add(dto);
		return list;
	}
	
	/**
	 * ^Aܗ^擾
	 * @param vo
	 * @throws Exception 
	 */
	private void setPaymentBonusInfo() throws Exception {
		// vZΏۋ^f[^擾
		listPaymentData = phPaymentDao.findForConditionDate(kCode,targetBefDate, targetAffDate);
		// vZΏۏܗ^f[^擾
		listBonusData = phBonusDao.findForConditionDate(kCode, startAdjDate, lastDate);
		
		// ^f[^mF
		setTargetPaymentData();
		phBonusDto = new PhBounsDto();
		if (phPaymentDto == null) {
			if (listPaymentData.size() != 0) {
				phPaymentDto = listPaymentData.get(listPaymentData.size() -1);
			}
		}

		// Ώۃf[^ŌvZ(o^Ȃ)
		calcTargetIncomeTax(false);
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 * @throws MospException 
	 */
	private void setHumanInfo(
			CdAdjustmentDto dto
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		if (dto != null) {
			// ЈR[hݒ
			kCode = dto.getKCode();
			// NŏI𗚗擾ΏیƂĎgp
			Date targetDate = getLastDateOfYear(adjustYear);
			// l{擾
			mKihonDto = mKihonPayrollDao.findForKey(kCode);
			if (mKihonDto == null) {
				// l{񂪖ꍇ
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
				addErrMessage(errMessage);
			}
			// l{ݒ
			// lǗ擾
			mKojinDto       = mKojinDao.findForKey(kCode);
			
			// l^擾
			cmIncomeTaxDto   = cmIncomeTaxDao  .findForEmployeeDate(kCode, targetDate);
			cmMidwayEnterDto = cmMidwayEnterDao.findForKey         (kCode          );
			cmSocInsuranceDto = cmSocInsuranceDao.findForHumanDataOnly(kCode, targetDate);
			// Ƒ擾
//			listFamily = cmFamilyDao.findForAdjustment(kCode);
			
		}
	}
		
	/**
	 * Џݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setCompanyDataInfo() throws SQLException, IllegalAccessException, NoSuchFieldException {
			CmCompanyDao dao = new CmCompanyDao();
			dao.initDao(cfg, cmd, aspUser, user, conn);
			cmCompanyDto = dao.findAll();
	}
	
	/**
	 * at擾
	 * @param dto
	 * @throws MospException
	 */
	private void setJapanDate(PaymentLedgerDto dto) throws MospException {
		String strDate[];
		// \pN擾(Ώ۔N)
		if (targetAffDate != null) {
			strDate = getJpImperialCal(listConf, targetAffDate);
			strDate[0]       = getCodeName(strDate[0], aryEra);
			dto.setOutputYear(strDate[0] + " " + strDate[1]);
			
		}
		// o͓
		strDate          = getJpImperialCal(listConf, getSystemDate());
		strDate[0]       = getCodeName(strDate[0], aryEra);
		dto.setOutputDate(strDate[0]+strDate[1]+ PayrollConst.NAM_YEAR + strDate[2]
		                  + PayrollConst.NAM_MONTH+ strDate[3] + PayrollConst.NAM_DAY);
		if (mKojinDto != null) {
			if (mKojinDto.getSeinenbi() != 0) {
				// N
				strDate          = 
					getJpImperialCal(listConf, DatePart.convIntegerDateToDate(mKojinDto.getSeinenbi()));
				strDate[0]       = getCodeName(strDate[0], aryEra);
				dto.setBirthDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " +  strDate[2]
				                 + " " + PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
			} else {
				dto.setBirthDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " +  " "
	                    + " " + PayrollConst.NAM_MONTH + " " + " " + PayrollConst.NAM_DAY);

			}
		}
		if (mKihonDto.getNyDate() != 0) {
			// Г
			strDate          = 
				getJpImperialCal(listConf, DatePart.convIntegerDateToDate(mKihonDto.getNyDate()));
			strDate[0]       = getCodeName(strDate[0], aryEra);
			dto.setEntranceDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " +  strDate[2]
			                 + " " + PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
		} else {
			dto.setEntranceDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " +  " "
			                    + " " + PayrollConst.NAM_MONTH + " " + " " + PayrollConst.NAM_DAY);
		}
		if (mKihonDto.getTsDate() != 0) {
			// ގГ
			strDate          =
				getJpImperialCal(listConf, DatePart.convIntegerDateToDate(mKihonDto.getTsDate()));
			strDate[0]       = getCodeName(strDate[0], aryEra);
			dto.setRetirementDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " +  strDate[2]
			                 + " " + PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
		} else {
			dto.setRetirementDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " +  " "
                    + " " + PayrollConst.NAM_MONTH + " " + " " + PayrollConst.NAM_DAY);
			
		}
	}
	
	private void setDtoCodeName(PaymentLedgerDto dto) {
		if (cmIncomeTaxDto != null) {
			// ېŋ敪
			dto.setIncomeTaxType(getCodeName(dto.getIncomeTaxType(), aryPltIncomeTaxType));
			// N敪
			dto.setAdjustmentType(getCodeName(dto.getAdjustmentType(), aryPltAdjustmentType));
			// {l敪1
			dto.setSelfWidowType(getCodeName(dto.getSelfWidowType(), aryPltWidowType));
			// {l敪2
			dto.setSelfHandicapType(getCodeName(dto.getSelfHandicapType(), aryPltHandicapType));
			// {l敪3
			dto.setSelfStudentType(getCodeName(dto.getSelfStudentType  (), aryPltStudentType));
			// zҋ敪
			dto.setSpouseIntendType(getCodeName(dto.getSpouseIntendType(), aryPltSpouseIntendType));
		}
		if (mKojinDto != null) {
			// 
			dto.setGender(getCodeName(dto.getGender   (), aryGender));
		}
		if (mKihonDto != null ) {
			// R[h
			String stationCode = dto.getPositionCode() + " - " + dto.getStationCode();
			// 
			String stationName = getCodeName(dto.getPositionCode(), aryPosition) + getCodeName(dto.getStationCode(), aryStation);
			// 
			dto.setStationCode(stationCode + "  " + stationName);
		}
		// EsȂ̂ŋ
		dto.setPositionCode("");
		
	}

	/**
	 * [o͏sB(Excel)<br><br>
	 * @throws Exception 
	 */
	private void reportXls(AdjustmentReferVo vo , PaymentLedgerDto dto) throws Exception {
		int Line;
		int Column;

		// RlNV擾
		getConnection();
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_PAYMENTLEDGER_XLS);

		// wb_[
		Line   =  0;
		Column = 13;
		poi.prtItem( Line +   0, Column +  0, dto.getOutputYear());			// ΏۘaNx(^Cg)
		poi.prtItem( Line +  73, Column +  0, dto.getOutputYear());			// ΏۘaNx(^Cg)

		Line   =  2;
		Column =  0;
		poi.prtItem( Line +   0, Column +  0, dto.getCompanyName());			// Ж
		poi.prtItem( Line +  73, Column +  0, dto.getCompanyName());			// Ж

		Line   =  2;
		Column = 38;
		poi.prtItem( Line +   0, Column +  0, dto.getOutputDate());			// o͓t
		poi.prtItem( Line +  73, Column +  0, dto.getOutputDate());			// o͓t

		Line   =  4;
		Column =  2;
		poi.prtItem( Line +   0, Column +  0, vo.getEscLblStationName());	// 
		prtItem_chk( poi, Line +  73, Column +  0, vo.getEscLblStationName());	// 
		prtItem_chk( poi, Line + 130, Column +  0, vo.getEscLblStationName());	// 

		Line   =  4;
		Column = 10;
		prtItem_chk( poi, Line +   0, Column +  0, vo.getEscLblPositionName());	// Eʖ		
		prtItem_chk( poi, Line +  73, Column +  0, vo.getEscLblPositionName());	// Eʖ
		prtItem_chk( poi, Line + 131,           2, vo.getEscLblPositionName());	// Eʖ

		Line   =  4;
		Column = 19;
		prtItem_chk( poi, Line +   0, Column +  0, dto.getKCode());				// ЈR[h
		prtItem_chk( poi, Line +  73, Column +  0, dto.getKCode());				// ЈR[h
		prtItem_chk( poi, Line + 132,           2, dto.getKCode());				// ЈR[h

		Line   =  4;
		Column = 24;
		prtItem_chk( poi, Line +   0, Column +  0, dto.getKName());				// 
		prtItem_chk( poi, Line +  73, Column +  0, dto.getKName());				// 
		prtItem_chk( poi, Line + 133,           2, dto.getKName());				// 
				
		/** ^ڏo **/
		// ږo
		Line   =  8;
		Column =  0;
		prtItem_chk( poi, Line +   0, Column +  0, dto.getTitleAllowanceItem());		// xږ^Cg
		prtItem_chk( poi, Line +   1, Column +  0, dto.getTitlePayAllowance_01());	// ^x01^Cg
		prtItem_chk( poi, Line +   2, Column +  0, dto.getTitlePayAllowance_02());	// ^x02^Cg
		prtItem_chk( poi, Line +   3, Column +  0, dto.getTitlePayAllowance_03());	// ^x03^Cg
		prtItem_chk( poi, Line +   4, Column +  0, dto.getTitlePayAllowance_04());	// ^x04^Cg
		prtItem_chk( poi, Line +   5, Column +  0, dto.getTitlePayAllowance_05());	// ^x05^Cg
		prtItem_chk( poi, Line +   6, Column +  0, dto.getTitlePayAllowance_06());	// ^x06^Cg
		prtItem_chk( poi, Line +   7, Column +  0, dto.getTitlePayAllowance_07());	// ^x07^Cg
		prtItem_chk( poi, Line +   8, Column +  0, dto.getTitlePayAllowance_08());	// ^x08^Cg
		prtItem_chk( poi, Line +   9, Column +  0, dto.getTitlePayAllowance_09());	// ^x09^Cg
		prtItem_chk( poi, Line +  10, Column +  0, dto.getTitlePayAllowance_10());	// ^x10^Cg
		prtItem_chk( poi, Line +  11, Column +  0, dto.getTitlePayAllowance_11());	// ^x11^Cg
		prtItem_chk( poi, Line +  12, Column +  0, dto.getTitlePayAllowance_12());	// ^x12^Cg
		prtItem_chk( poi, Line +  13, Column +  0, dto.getTitlePayAllowance_13());	// ^x13^Cg
		prtItem_chk( poi, Line +  14, Column +  0, dto.getTitlePayAllowance_14());	// ^x14^Cg
		prtItem_chk( poi, Line +  15, Column +  0, dto.getTitlePayAllowance_15());	// ^x15^Cg
		prtItem_chk( poi, Line +  16, Column +  0, dto.getTitlePayAllowance_16());	// ^x16^Cg
		prtItem_chk( poi, Line +  17, Column +  0, dto.getTitlePayAllowance_17());	// ^x17^Cg
		prtItem_chk( poi, Line +  18, Column +  0, dto.getTitlePayAllowance_18());	// ^x18^Cg
		prtItem_chk( poi, Line +  19, Column +  0, dto.getTitlePayAllowance_19());	// ^x19^Cg
		prtItem_chk( poi, Line +  20, Column +  0, dto.getTitlePayAllowance_20());	// ^x20^Cg
		prtItem_chk( poi, Line +  21, Column +  0, dto.getTitlePayAllowance_21());	// ^x21^Cg
		prtItem_chk( poi, Line +  22, Column +  0, dto.getTitlePayAllowance_22());	// ^x22^Cg
		prtItem_chk( poi, Line +  23, Column +  0, dto.getTitlePayAllowance_23());	// ^x23^Cg
		prtItem_chk( poi, Line +  24, Column +  0, dto.getTitlePayAllowance_24());	// ^x24^Cg
		prtItem_chk( poi, Line +  25, Column +  0, dto.getTitlePayAllowance_25());	// ^x25^Cg
		prtItem_chk( poi, Line +  26, Column +  0, dto.getTitlePayAllowance_26());	// ^x26^Cg
		prtItem_chk( poi, Line +  27, Column +  0, dto.getTitlePayAllowance_27());	// ^x27^Cg
		prtItem_chk( poi, Line +  28, Column +  0, dto.getTitlePayAllowance_28());	// ^x28^Cg
		prtItem_chk( poi, Line +  29, Column +  0, dto.getTitlePayAllowance_29());	// ^x29^Cg
		prtItem_chk( poi, Line +  30, Column +  0, dto.getTitlePayAllowance_30());	// ^x30^Cg
		prtItem_chk( poi, Line +  31, Column +  0, dto.getTitleAllowanceTotal());	// xz^Cg		

		Line   =  40;
		prtItem_chk( poi, Line +   0, Column +  0, "" + dto.getTitleDeductionItem() + "");	// Tڃ^Cg  
		prtItem_chk( poi, Line +   1, Column +  0, dto.getTitlePayDeduction_01());	// ^T01^Cg
		prtItem_chk( poi, Line +   2, Column +  0, dto.getTitlePayDeduction_02());	// ^T02^Cg
		prtItem_chk( poi, Line +   3, Column +  0, dto.getTitlePayDeduction_03());	// ^T03^Cg
		prtItem_chk( poi, Line +   4, Column +  0, dto.getTitlePayDeduction_04());	// ^T04^Cg
		prtItem_chk( poi, Line +   5, Column +  0, dto.getTitlePayDeduction_05());	// ^T05^Cg
		prtItem_chk( poi, Line +   6, Column +  0, dto.getTitlePayDeduction_06());	// ^T06^Cg
		prtItem_chk( poi, Line +   7, Column +  0, dto.getTitlePayDeduction_07());	// ^T07^Cg
		prtItem_chk( poi, Line +   8, Column +  0, dto.getTitlePayDeduction_08());	// ^T08^Cg
		prtItem_chk( poi, Line +   9, Column +  0, dto.getTitlePayDeduction_09());	// ^T09^Cg
		prtItem_chk( poi, Line +  10, Column +  0, dto.getTitlePayDeduction_10());	// ^T10^Cg
		prtItem_chk( poi, Line +  11, Column +  0, dto.getTitlePayDeduction_11());	// ^T11^Cg
		prtItem_chk( poi, Line +  12, Column +  0, dto.getTitlePayDeduction_12());	// ^T12^Cg
		prtItem_chk( poi, Line +  13, Column +  0, dto.getTitlePayDeduction_14());	// ^T14^Cg
		prtItem_chk( poi, Line +  14, Column +  0, dto.getTitlePayDeduction_15());	// ^T15^Cg
		prtItem_chk( poi, Line +  15, Column +  0, dto.getTitlePayDeduction_16());	// ^T16^Cg
		prtItem_chk( poi, Line +  16, Column +  0, dto.getTitlePayDeduction_17());	// ^T17^Cg
		prtItem_chk( poi, Line +  17, Column +  0, dto.getTitlePayDeduction_18());	// ^T18^Cg
		prtItem_chk( poi, Line +  18, Column +  0, dto.getTitlePayDeduction_19());	// ^T19^Cg
		prtItem_chk( poi, Line +  19, Column +  0, dto.getTitlePayDeduction_20());	// ^T20^Cg
		prtItem_chk( poi, Line +  20, Column +  0, dto.getTitlePayDeduction_21());	// ^T21^Cg
		prtItem_chk( poi, Line +  21, Column +  0, dto.getTitlePayDeduction_22());	// ^T22^Cg
		prtItem_chk( poi, Line +  22, Column +  0, dto.getTitlePayDeduction_23());	// ^T23^Cg
		prtItem_chk( poi, Line +  23, Column +  0, dto.getTitlePayDeduction_24());	// ^T24^Cg
		prtItem_chk( poi, Line +  24, Column +  0, dto.getTitlePayDeduction_25());	// ^T25^Cg
		prtItem_chk( poi, Line +  25, Column +  0, dto.getTitleDeductionTotal());    // Tz^Cg
		prtItem_chk( poi, Line +  26, Column +  0, dto.getTitlePayDeduction_26());	// ^T26^Cg
		prtItem_chk( poi, Line +  27, Column +  0, dto.getTitlePaymentTotal());		// xz^Cg
		prtItem_chk( poi, Line +  28, Column +  0, dto.getTitleBank1PayAmount());	// s1Uz
		prtItem_chk( poi, Line +  29, Column +  0, dto.getTitleBank2PayAmount());	// s2Uz
		prtItem_chk( poi, Line +  30, Column +  0, dto.getTitleCashPayAmount());		// xz
		prtItem_chk( poi, Line +  31, Column +  0, dto.getTitlePayDeduction_27());	// ^T27^Cg

		// ^׏o
		Line   =  8;
		Column =  3; // 1
		if( null != dto.getPayPayday_01())       prtItem_chk( poi,   Line -   1, Column, dto.getPayPayday_01());	 	// ^x_01
		if( null != dto.getPayAllowance_01_01()) prtItem_chk( poi,   Line +   1, Column, dto.getPayAllowance_01_01()); 	// ^x01_01
		if( null != dto.getPayAllowance_02_01()) prtItem_chk( poi,   Line +   2, Column, dto.getPayAllowance_02_01()); 	// ^x02_01
		if( null != dto.getPayAllowance_03_01()) prtItem_chk( poi,   Line +   3, Column, dto.getPayAllowance_03_01()); 	// ^x03_01
		if( null != dto.getPayAllowance_04_01()) prtItem_chk( poi,   Line +   4, Column, dto.getPayAllowance_04_01()); 	// ^x04_01
		if( null != dto.getPayAllowance_05_01()) prtItem_chk( poi,   Line +   5, Column, dto.getPayAllowance_05_01()); 	// ^x05_01
		if( null != dto.getPayAllowance_06_01()) prtItem_chk( poi,   Line +   6, Column, dto.getPayAllowance_06_01()); 	// ^x06_01
		if( null != dto.getPayAllowance_07_01()) prtItem_chk( poi,   Line +   7, Column, dto.getPayAllowance_07_01()); 	// ^x07_01
		if( null != dto.getPayAllowance_08_01()) prtItem_chk( poi,   Line +   8, Column, dto.getPayAllowance_08_01()); 	// ^x08_01
		if( null != dto.getPayAllowance_09_01()) prtItem_chk( poi,   Line +   9, Column, dto.getPayAllowance_09_01()); 	// ^x09_01
		if( null != dto.getPayAllowance_10_01()) prtItem_chk( poi,   Line +  10, Column, dto.getPayAllowance_10_01()); 	// ^x10_01
		if( null != dto.getPayAllowance_11_01()) prtItem_chk( poi,   Line +  11, Column, dto.getPayAllowance_11_01()); 	// ^x11_01
		if( null != dto.getPayAllowance_12_01()) prtItem_chk( poi,   Line +  12, Column, dto.getPayAllowance_12_01()); 	// ^x12_01
		if( null != dto.getPayAllowance_13_01()) prtItem_chk( poi,   Line +  13, Column, dto.getPayAllowance_13_01()); 	// ^x13_01
		if( null != dto.getPayAllowance_14_01()) prtItem_chk( poi,   Line +  14, Column, dto.getPayAllowance_14_01()); 	// ^x14_01
		if( null != dto.getPayAllowance_15_01()) prtItem_chk( poi,   Line +  15, Column, dto.getPayAllowance_15_01()); 	// ^x15_01
		if( null != dto.getPayAllowance_16_01()) prtItem_chk( poi,   Line +  16, Column, dto.getPayAllowance_16_01()); 	// ^x16_01
		if( null != dto.getPayAllowance_17_01()) prtItem_chk( poi,   Line +  17, Column, dto.getPayAllowance_17_01()); 	// ^x17_01
		if( null != dto.getPayAllowance_18_01()) prtItem_chk( poi,   Line +  18, Column, dto.getPayAllowance_18_01()); 	// ^x18_01
		if( null != dto.getPayAllowance_19_01()) prtItem_chk( poi,   Line +  19, Column, dto.getPayAllowance_19_01()); 	// ^x19_01
		if( null != dto.getPayAllowance_20_01()) prtItem_chk( poi,   Line +  20, Column, dto.getPayAllowance_20_01()); 	// ^x20_01
		if( null != dto.getPayAllowance_21_01()) prtItem_chk( poi,   Line +  21, Column, dto.getPayAllowance_21_01()); 	// ^x21_01
		if( null != dto.getPayAllowance_22_01()) prtItem_chk( poi,   Line +  22, Column, dto.getPayAllowance_22_01()); 	// ^x22_01
		if( null != dto.getPayAllowance_23_01()) prtItem_chk( poi,   Line +  23, Column, dto.getPayAllowance_23_01()); 	// ^x23_01
		if( null != dto.getPayAllowance_24_01()) prtItem_chk( poi,   Line +  24, Column, dto.getPayAllowance_24_01()); 	// ^x24_01
		if( null != dto.getPayAllowance_25_01()) prtItem_chk( poi,   Line +  25, Column, dto.getPayAllowance_25_01()); 	// ^x25_01
		if( null != dto.getPayAllowance_26_01()) prtItem_chk( poi,   Line +  26, Column, dto.getPayAllowance_26_01()); 	// ^x26_01
		if( null != dto.getPayAllowance_27_01()) prtItem_chk( poi,   Line +  27, Column, dto.getPayAllowance_27_01()); 	// ^x27_01
		if( null != dto.getPayAllowance_28_01()) prtItem_chk( poi,   Line +  28, Column, dto.getPayAllowance_28_01()); 	// ^x28_01
		if( null != dto.getPayAllowance_29_01()) prtItem_chk( poi,   Line +  29, Column, dto.getPayAllowance_29_01()); 	// ^x29_01
		if( null != dto.getPayAllowance_30_01()) prtItem_chk( poi,   Line +  30, Column, dto.getPayAllowance_30_01()); 	// ^x30_01
		if( null != dto.getPayAllowanceTotal_01()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_01()); // ^xz_01
		Line   =  40;
		if( null != dto.getPayDeduction_01_01()) prtItem_chk( poi,   Line +   1, Column, dto.getPayDeduction_01_01()); 	// ^T01_01
		if( null != dto.getPayDeduction_02_01()) prtItem_chk( poi,   Line +   2, Column, dto.getPayDeduction_02_01()); 	// ^T02_01
		if( null != dto.getPayDeduction_03_01()) prtItem_chk( poi,   Line +   3, Column, dto.getPayDeduction_03_01()); 	// ^T03_01
		if( null != dto.getPayDeduction_04_01()) prtItem_chk( poi,   Line +   4, Column, dto.getPayDeduction_04_01()); 	// ^T04_01
		if( null != dto.getPayDeduction_05_01()) prtItem_chk( poi,   Line +   5, Column, dto.getPayDeduction_05_01()); 	// ^T05_01
		if( null != dto.getPayDeduction_06_01()) prtItem_chk( poi,   Line +   6, Column, dto.getPayDeduction_06_01()); 	// ^T06_01
		if( null != dto.getPayDeduction_07_01()) prtItem_chk( poi,   Line +   7, Column, dto.getPayDeduction_07_01()); 	// ^T07_01
		if( null != dto.getPayDeduction_08_01()) prtItem_chk( poi,   Line +   8, Column, dto.getPayDeduction_08_01()); 	// ^T08_01
		if( null != dto.getPayDeduction_09_01()) prtItem_chk( poi,   Line +   9, Column, dto.getPayDeduction_09_01()); 	// ^T09_01
		if( null != dto.getPayDeduction_10_01()) prtItem_chk( poi,   Line +  10, Column, dto.getPayDeduction_10_01()); 	// ^T10_01
		if( null != dto.getPayDeduction_11_01()) prtItem_chk( poi,   Line +  11, Column, dto.getPayDeduction_11_01()); 	// ^T11_01
		if( null != dto.getPayDeduction_12_01()) prtItem_chk( poi,   Line +  12, Column, dto.getPayDeduction_12_01()); 	// ^T12_01
		if( null != dto.getPayDeduction_14_01()) prtItem_chk( poi,   Line +  13, Column, dto.getPayDeduction_14_01()); 	// ^T14_01
		if( null != dto.getPayDeduction_15_01()) prtItem_chk( poi,   Line +  14, Column, dto.getPayDeduction_15_01()); 	// ^T15_01
		if( null != dto.getPayDeduction_16_01()) prtItem_chk( poi,   Line +  15, Column, dto.getPayDeduction_16_01()); 	// ^T16_01
		if( null != dto.getPayDeduction_17_01()) prtItem_chk( poi,   Line +  16, Column, dto.getPayDeduction_17_01()); 	// ^T17_01
		if( null != dto.getPayDeduction_18_01()) prtItem_chk( poi,   Line +  17, Column, dto.getPayDeduction_18_01()); 	// ^T18_01
		if( null != dto.getPayDeduction_19_01()) prtItem_chk( poi,   Line +  18, Column, dto.getPayDeduction_19_01()); 	// ^T19_01
		if( null != dto.getPayDeduction_20_01()) prtItem_chk( poi,   Line +  19, Column, dto.getPayDeduction_20_01()); 	// ^T20_01
		if( null != dto.getPayDeduction_21_01()) prtItem_chk( poi,   Line +  20, Column, dto.getPayDeduction_21_01()); 	// ^T21_01
		if( null != dto.getPayDeduction_22_01()) prtItem_chk( poi,   Line +  21, Column, dto.getPayDeduction_22_01()); 	// ^T22_01
		if( null != dto.getPayDeduction_23_01()) prtItem_chk( poi,   Line +  22, Column, dto.getPayDeduction_23_01()); 	// ^T23_01
		if( null != dto.getPayDeduction_24_01()) prtItem_chk( poi,   Line +  23, Column, dto.getPayDeduction_24_01()); 	// ^T24_01
		if( null != dto.getPayDeduction_25_01()) prtItem_chk( poi,   Line +  24, Column, dto.getPayDeduction_25_01()); 	// ^T25_01
		if( null != dto.getPayDeductionTotal_01()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_01()); 	// ^Tz_01
		if( null != dto.getPayDeduction_26_01()) prtItem_chk( poi,   Line +  26, Column, dto.getPayDeduction_26_01()); 	// ^T26_01
		if( null != dto.getPayPaymentTotal_01()) prtItem_chk( poi,   Line +  27, Column, dto.getPayPaymentTotal_01()); 	// ^xz_01
		if( null != dto.getPayBank1PayAmount_01()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_01()); 	// ^s1Uz_01
		if( null != dto.getPayBank2PayAmount_01()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_01()); 	// ^s2Uz_01
		if( null != dto.getPayCashPayAmount_01()) prtItem_chk( poi,  Line +  30, Column, dto.getPayCashPayAmount_01());		// xz_01
		if( null != dto.getPayDeduction_27_01()) prtItem_chk( poi,   Line +  31, Column, dto.getPayDeduction_27_01());		// ^T27_01

		Line   =  8;
		Column =  6; // 2
		if( null != dto.getPayPayday_02()) prtItem_chk( poi,           Line - 1, Column, dto.getPayPayday_02()); 		// ^x_02
		if( null != dto.getPayAllowance_01_02()) prtItem_chk( poi,   Line +   1, Column, dto.getPayAllowance_01_02()); 	// ^x01_02
		if( null != dto.getPayAllowance_02_02()) prtItem_chk( poi,   Line +   2, Column, dto.getPayAllowance_02_02()); 	// ^x02_02
		if( null != dto.getPayAllowance_03_02()) prtItem_chk( poi,   Line +   3, Column, dto.getPayAllowance_03_02()); 	// ^x03_02
		if( null != dto.getPayAllowance_04_02()) prtItem_chk( poi,   Line +   4, Column, dto.getPayAllowance_04_02()); 	// ^x04_02
		if( null != dto.getPayAllowance_05_02()) prtItem_chk( poi,   Line +   5, Column, dto.getPayAllowance_05_02()); 	// ^x05_02
		if( null != dto.getPayAllowance_06_02()) prtItem_chk( poi,   Line +   6, Column, dto.getPayAllowance_06_02()); 	// ^x06_02
		if( null != dto.getPayAllowance_07_02()) prtItem_chk( poi,   Line +   7, Column, dto.getPayAllowance_07_02()); 	// ^x07_02
		if( null != dto.getPayAllowance_08_02()) prtItem_chk( poi,   Line +   8, Column, dto.getPayAllowance_08_02()); 	// ^x08_02
		if( null != dto.getPayAllowance_09_02()) prtItem_chk( poi,   Line +   9, Column, dto.getPayAllowance_09_02()); 	// ^x09_02
		if( null != dto.getPayAllowance_10_02()) prtItem_chk( poi,   Line +  10, Column, dto.getPayAllowance_10_02()); 	// ^x10_02
		if( null != dto.getPayAllowance_11_02()) prtItem_chk( poi,   Line +  11, Column, dto.getPayAllowance_11_02()); 	// ^x11_02
		if( null != dto.getPayAllowance_12_02()) prtItem_chk( poi,   Line +  12, Column, dto.getPayAllowance_12_02()); 	// ^x12_02
		if( null != dto.getPayAllowance_13_02()) prtItem_chk( poi,   Line +  13, Column, dto.getPayAllowance_13_02()); 	// ^x13_02
		if( null != dto.getPayAllowance_14_02()) prtItem_chk( poi,   Line +  14, Column, dto.getPayAllowance_14_02()); 	// ^x14_02
		if( null != dto.getPayAllowance_15_02()) prtItem_chk( poi,   Line +  15, Column, dto.getPayAllowance_15_02()); 	// ^x15_02
		if( null != dto.getPayAllowance_16_02()) prtItem_chk( poi,   Line +  16, Column, dto.getPayAllowance_16_02()); 	// ^x16_02
		if( null != dto.getPayAllowance_17_02()) prtItem_chk( poi,   Line +  17, Column, dto.getPayAllowance_17_02()); 	// ^x17_02
		if( null != dto.getPayAllowance_18_02()) prtItem_chk( poi,   Line +  18, Column, dto.getPayAllowance_18_02()); 	// ^x18_02
		if( null != dto.getPayAllowance_19_02()) prtItem_chk( poi,   Line +  19, Column, dto.getPayAllowance_19_02()); 	// ^x19_02
		if( null != dto.getPayAllowance_20_02()) prtItem_chk( poi,   Line +  20, Column, dto.getPayAllowance_20_02()); 	// ^x20_02
		if( null != dto.getPayAllowance_21_02()) prtItem_chk( poi,   Line +  21, Column, dto.getPayAllowance_21_02()); 	// ^x21_02
		if( null != dto.getPayAllowance_22_02()) prtItem_chk( poi,   Line +  22, Column, dto.getPayAllowance_22_02()); 	// ^x22_02
		if( null != dto.getPayAllowance_23_02()) prtItem_chk( poi,   Line +  23, Column, dto.getPayAllowance_23_02()); 	// ^x23_02
		if( null != dto.getPayAllowance_24_02()) prtItem_chk( poi,   Line +  24, Column, dto.getPayAllowance_24_02()); 	// ^x24_02
		if( null != dto.getPayAllowance_25_02()) prtItem_chk( poi,   Line +  25, Column, dto.getPayAllowance_25_02()); 	// ^x25_02
		if( null != dto.getPayAllowance_26_02()) prtItem_chk( poi,   Line +  26, Column, dto.getPayAllowance_26_02()); 	// ^x26_02
		if( null != dto.getPayAllowance_27_02()) prtItem_chk( poi,   Line +  27, Column, dto.getPayAllowance_27_02()); 	// ^x27_02
		if( null != dto.getPayAllowance_28_02()) prtItem_chk( poi,   Line +  28, Column, dto.getPayAllowance_28_02()); 	// ^x28_02
		if( null != dto.getPayAllowance_29_02()) prtItem_chk( poi,   Line +  29, Column, dto.getPayAllowance_29_02()); 	// ^x29_02
		if( null != dto.getPayAllowance_30_02()) prtItem_chk( poi,   Line +  30, Column, dto.getPayAllowance_30_02()); 	// ^x30_02
		if( null != dto.getPayAllowanceTotal_02()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_02()); // ^xz_02
		Line   =  40;
		if( null != dto.getPayDeduction_01_02()) prtItem_chk( poi,   Line +   1, Column, dto.getPayDeduction_01_02()); 	// ^T01_02
		if( null != dto.getPayDeduction_02_02()) prtItem_chk( poi,   Line +   2, Column, dto.getPayDeduction_02_02()); 	// ^T02_02
		if( null != dto.getPayDeduction_03_02()) prtItem_chk( poi,   Line +   3, Column, dto.getPayDeduction_03_02()); 	// ^T03_02
		if( null != dto.getPayDeduction_04_02()) prtItem_chk( poi,   Line +   4, Column, dto.getPayDeduction_04_02()); 	// ^T04_02
		if( null != dto.getPayDeduction_05_02()) prtItem_chk( poi,   Line +   5, Column, dto.getPayDeduction_05_02()); 	// ^T05_02
		if( null != dto.getPayDeduction_06_02()) prtItem_chk( poi,   Line +   6, Column, dto.getPayDeduction_06_02()); 	// ^T06_02
		if( null != dto.getPayDeduction_07_02()) prtItem_chk( poi,   Line +   7, Column, dto.getPayDeduction_07_02()); 	// ^T07_02
		if( null != dto.getPayDeduction_08_02()) prtItem_chk( poi,   Line +   8, Column, dto.getPayDeduction_08_02()); 	// ^T08_02
		if( null != dto.getPayDeduction_09_02()) prtItem_chk( poi,   Line +   9, Column, dto.getPayDeduction_09_02()); 	// ^T09_02
		if( null != dto.getPayDeduction_10_02()) prtItem_chk( poi,   Line +  10, Column, dto.getPayDeduction_10_02()); 	// ^T10_02
		if( null != dto.getPayDeduction_11_02()) prtItem_chk( poi,   Line +  11, Column, dto.getPayDeduction_11_02()); 	// ^T11_02
		if( null != dto.getPayDeduction_12_02()) prtItem_chk( poi,   Line +  12, Column, dto.getPayDeduction_12_02()); 	// ^T12_02
		if( null != dto.getPayDeduction_14_02()) prtItem_chk( poi,   Line +  13, Column, dto.getPayDeduction_14_02()); 	// ^T14_02
		if( null != dto.getPayDeduction_15_02()) prtItem_chk( poi,   Line +  14, Column, dto.getPayDeduction_15_02()); 	// ^T15_02
		if( null != dto.getPayDeduction_16_02()) prtItem_chk( poi,   Line +  15, Column, dto.getPayDeduction_16_02()); 	// ^T16_02
		if( null != dto.getPayDeduction_17_02()) prtItem_chk( poi,   Line +  16, Column, dto.getPayDeduction_17_02()); 	// ^T17_02
		if( null != dto.getPayDeduction_18_02()) prtItem_chk( poi,   Line +  17, Column, dto.getPayDeduction_18_02()); 	// ^T18_02
		if( null != dto.getPayDeduction_19_02()) prtItem_chk( poi,   Line +  18, Column, dto.getPayDeduction_19_02()); 	// ^T19_02
		if( null != dto.getPayDeduction_20_02()) prtItem_chk( poi,   Line +  19, Column, dto.getPayDeduction_20_02()); 	// ^T20_02
		if( null != dto.getPayDeduction_21_02()) prtItem_chk( poi,   Line +  20, Column, dto.getPayDeduction_21_02()); 	// ^T21_02
		if( null != dto.getPayDeduction_22_02()) prtItem_chk( poi,   Line +  21, Column, dto.getPayDeduction_22_02()); 	// ^T22_02
		if( null != dto.getPayDeduction_23_02()) prtItem_chk( poi,   Line +  22, Column, dto.getPayDeduction_23_02()); 	// ^T23_02
		if( null != dto.getPayDeduction_24_02()) prtItem_chk( poi,   Line +  23, Column, dto.getPayDeduction_24_02()); 	// ^T24_02
		if( null != dto.getPayDeduction_25_02()) prtItem_chk( poi,   Line +  24, Column, dto.getPayDeduction_25_02()); 	// ^T25_02
		if( null != dto.getPayDeductionTotal_02()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_02()); 	// ^Tz_02
		if( null != dto.getPayDeduction_26_02()) prtItem_chk( poi,   Line +  26, Column, dto.getPayDeduction_26_02()); 	// ^T26_02
		if( null != dto.getPayPaymentTotal_02()) prtItem_chk( poi,   Line +  27, Column, dto.getPayPaymentTotal_02()); 	// ^xz_02
		if( null != dto.getPayBank1PayAmount_02()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_02()); 	// ^s1Uz_02
		if( null != dto.getPayBank2PayAmount_02()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_02()); 	// ^s2Uz_02
		if( null != dto.getPayCashPayAmount_02()) prtItem_chk( poi,  Line +  30, Column, dto.getPayCashPayAmount_02()); 		// xz_02
		if( null != dto.getPayDeduction_27_02()) prtItem_chk( poi,   Line +  31, Column, dto.getPayDeduction_27_02()); 	// ^T27_02

		Line   =  8;
		Column =  9; // 3
		if( null != dto.getPayPayday_03()) prtItem_chk( poi,           Line - 1, Column, dto.getPayPayday_03()); 		// ^x_03
		if( null != dto.getPayAllowance_01_03()) prtItem_chk( poi,   Line +   1, Column, dto.getPayAllowance_01_03()); 	// ^x01_03
		if( null != dto.getPayAllowance_02_03()) prtItem_chk( poi,   Line +   2, Column, dto.getPayAllowance_02_03()); 	// ^x02_03
		if( null != dto.getPayAllowance_03_03()) prtItem_chk( poi,   Line +   3, Column, dto.getPayAllowance_03_03()); 	// ^x03_03
		if( null != dto.getPayAllowance_04_03()) prtItem_chk( poi,   Line +   4, Column, dto.getPayAllowance_04_03()); 	// ^x04_03
		if( null != dto.getPayAllowance_05_03()) prtItem_chk( poi,   Line +   5, Column, dto.getPayAllowance_05_03()); 	// ^x05_03
		if( null != dto.getPayAllowance_06_03()) prtItem_chk( poi,   Line +   6, Column, dto.getPayAllowance_06_03()); 	// ^x06_03
		if( null != dto.getPayAllowance_07_03()) prtItem_chk( poi,   Line +   7, Column, dto.getPayAllowance_07_03()); 	// ^x07_03
		if( null != dto.getPayAllowance_08_03()) prtItem_chk( poi,   Line +   8, Column, dto.getPayAllowance_08_03()); 	// ^x08_03
		if( null != dto.getPayAllowance_09_03()) prtItem_chk( poi,   Line +   9, Column, dto.getPayAllowance_09_03()); 	// ^x09_03
		if( null != dto.getPayAllowance_10_03()) prtItem_chk( poi,   Line +  10, Column, dto.getPayAllowance_10_03()); 	// ^x10_03
		if( null != dto.getPayAllowance_11_03()) prtItem_chk( poi,   Line +  11, Column, dto.getPayAllowance_11_03()); 	// ^x11_03
		if( null != dto.getPayAllowance_12_03()) prtItem_chk( poi,   Line +  12, Column, dto.getPayAllowance_12_03()); 	// ^x12_03
		if( null != dto.getPayAllowance_13_03()) prtItem_chk( poi,   Line +  13, Column, dto.getPayAllowance_13_03()); 	// ^x13_03
		if( null != dto.getPayAllowance_14_03()) prtItem_chk( poi,   Line +  14, Column, dto.getPayAllowance_14_03()); 	// ^x14_03
		if( null != dto.getPayAllowance_15_03()) prtItem_chk( poi,   Line +  15, Column, dto.getPayAllowance_15_03()); 	// ^x15_03
		if( null != dto.getPayAllowance_16_03()) prtItem_chk( poi,   Line +  16, Column, dto.getPayAllowance_16_03()); 	// ^x16_03
		if( null != dto.getPayAllowance_17_03()) prtItem_chk( poi,   Line +  17, Column, dto.getPayAllowance_17_03()); 	// ^x17_03
		if( null != dto.getPayAllowance_18_03()) prtItem_chk( poi,   Line +  18, Column, dto.getPayAllowance_18_03()); 	// ^x18_03
		if( null != dto.getPayAllowance_19_03()) prtItem_chk( poi,   Line +  19, Column, dto.getPayAllowance_19_03()); 	// ^x19_03
		if( null != dto.getPayAllowance_20_03()) prtItem_chk( poi,   Line +  20, Column, dto.getPayAllowance_20_03()); 	// ^x20_03
		if( null != dto.getPayAllowance_21_03()) prtItem_chk( poi,   Line +  21, Column, dto.getPayAllowance_21_03()); 	// ^x21_03
		if( null != dto.getPayAllowance_22_03()) prtItem_chk( poi,   Line +  22, Column, dto.getPayAllowance_22_03()); 	// ^x22_03
		if( null != dto.getPayAllowance_23_03()) prtItem_chk( poi,   Line +  23, Column, dto.getPayAllowance_23_03()); 	// ^x23_03
		if( null != dto.getPayAllowance_24_03()) prtItem_chk( poi,   Line +  24, Column, dto.getPayAllowance_24_03()); 	// ^x24_03
		if( null != dto.getPayAllowance_25_03()) prtItem_chk( poi,   Line +  25, Column, dto.getPayAllowance_25_03()); 	// ^x25_03
		if( null != dto.getPayAllowance_26_03()) prtItem_chk( poi,   Line +  26, Column, dto.getPayAllowance_26_03()); 	// ^x26_03
		if( null != dto.getPayAllowance_27_03()) prtItem_chk( poi,   Line +  27, Column, dto.getPayAllowance_27_03()); 	// ^x27_03
		if( null != dto.getPayAllowance_28_03()) prtItem_chk( poi,   Line +  28, Column, dto.getPayAllowance_28_03()); 	// ^x28_03
		if( null != dto.getPayAllowance_29_03()) prtItem_chk( poi,   Line +  29, Column, dto.getPayAllowance_29_03()); 	// ^x29_03
		if( null != dto.getPayAllowance_30_03()) prtItem_chk( poi,   Line +  30, Column, dto.getPayAllowance_30_03()); 	// ^x30_03
		if( null != dto.getPayAllowanceTotal_03()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_03()); // ^xz_03
		Line   =  40;
		if( null != dto.getPayDeduction_01_03()) prtItem_chk( poi,   Line +   1, Column, dto.getPayDeduction_01_03()); 	// ^T01_03
		if( null != dto.getPayDeduction_02_03()) prtItem_chk( poi,   Line +   2, Column, dto.getPayDeduction_02_03()); 	// ^T02_03
		if( null != dto.getPayDeduction_03_03()) prtItem_chk( poi,   Line +   3, Column, dto.getPayDeduction_03_03()); 	// ^T03_03
		if( null != dto.getPayDeduction_04_03()) prtItem_chk( poi,   Line +   4, Column, dto.getPayDeduction_04_03()); 	// ^T04_03
		if( null != dto.getPayDeduction_05_03()) prtItem_chk( poi,   Line +   5, Column, dto.getPayDeduction_05_03()); 	// ^T05_03
		if( null != dto.getPayDeduction_06_03()) prtItem_chk( poi,   Line +   6, Column, dto.getPayDeduction_06_03()); 	// ^T06_03
		if( null != dto.getPayDeduction_07_03()) prtItem_chk( poi,   Line +   7, Column, dto.getPayDeduction_07_03()); 	// ^T07_03
		if( null != dto.getPayDeduction_08_03()) prtItem_chk( poi,   Line +   8, Column, dto.getPayDeduction_08_03()); 	// ^T08_03
		if( null != dto.getPayDeduction_09_03()) prtItem_chk( poi,   Line +   9, Column, dto.getPayDeduction_09_03()); 	// ^T09_03
		if( null != dto.getPayDeduction_10_03()) prtItem_chk( poi,   Line +  10, Column, dto.getPayDeduction_10_03()); 	// ^T10_03
		if( null != dto.getPayDeduction_11_03()) prtItem_chk( poi,   Line +  11, Column, dto.getPayDeduction_11_03()); 	// ^T11_03
		if( null != dto.getPayDeduction_12_03()) prtItem_chk( poi,   Line +  12, Column, dto.getPayDeduction_12_03()); 	// ^T12_03
		if( null != dto.getPayDeduction_14_03()) prtItem_chk( poi,   Line +  13, Column, dto.getPayDeduction_14_03()); 	// ^T14_03
		if( null != dto.getPayDeduction_15_03()) prtItem_chk( poi,   Line +  14, Column, dto.getPayDeduction_15_03()); 	// ^T15_03
		if( null != dto.getPayDeduction_16_03()) prtItem_chk( poi,   Line +  15, Column, dto.getPayDeduction_16_03()); 	// ^T16_03
		if( null != dto.getPayDeduction_17_03()) prtItem_chk( poi,   Line +  16, Column, dto.getPayDeduction_17_03()); 	// ^T17_03
		if( null != dto.getPayDeduction_18_03()) prtItem_chk( poi,   Line +  17, Column, dto.getPayDeduction_18_03()); 	// ^T18_03
		if( null != dto.getPayDeduction_19_03()) prtItem_chk( poi,   Line +  18, Column, dto.getPayDeduction_19_03()); 	// ^T19_03
		if( null != dto.getPayDeduction_20_03()) prtItem_chk( poi,   Line +  19, Column, dto.getPayDeduction_20_03()); 	// ^T20_03
		if( null != dto.getPayDeduction_21_03()) prtItem_chk( poi,   Line +  20, Column, dto.getPayDeduction_21_03()); 	// ^T21_03
		if( null != dto.getPayDeduction_22_03()) prtItem_chk( poi,   Line +  21, Column, dto.getPayDeduction_22_03()); 	// ^T22_03
		if( null != dto.getPayDeduction_23_03()) prtItem_chk( poi,   Line +  22, Column, dto.getPayDeduction_23_03()); 	// ^T23_03
		if( null != dto.getPayDeduction_24_03()) prtItem_chk( poi,   Line +  23, Column, dto.getPayDeduction_24_03()); 	// ^T24_03
		if( null != dto.getPayDeduction_25_03()) prtItem_chk( poi,   Line +  24, Column, dto.getPayDeduction_25_03()); 	// ^T25_03
		if( null != dto.getPayDeductionTotal_03()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_03()); 	// ^Tz_03
		if( null != dto.getPayDeduction_26_03()) prtItem_chk( poi,   Line +  26, Column, dto.getPayDeduction_26_03()); 	// ^T26_03
		if( null != dto.getPayPaymentTotal_03()) prtItem_chk( poi,   Line +  27, Column, dto.getPayPaymentTotal_03()); 	// ^xz_03
		if( null != dto.getPayBank1PayAmount_03()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_03()); 	// ^s1Uz_03
		if( null != dto.getPayBank2PayAmount_03()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_03()); 	// ^s2Uz_03
		if( null != dto.getPayCashPayAmount_03()) prtItem_chk( poi,  Line +  30, Column, dto.getPayCashPayAmount_03());		// xz_03
		if( null != dto.getPayDeduction_27_03()) prtItem_chk( poi,   Line +  31, Column, dto.getPayDeduction_27_03()); 	// ^T27_03

		Line   =  8;
		Column =  12; // 4
		if( null != dto.getPayPayday_04())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_04()); 		// ^x_04
		if( null != dto.getPayAllowance_01_04())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_04()); 	// ^x01_04
		if( null != dto.getPayAllowance_02_04())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_04()); 	// ^x02_04
		if( null != dto.getPayAllowance_03_04())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_04()); 	// ^x03_04
		if( null != dto.getPayAllowance_04_04())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_04()); 	// ^x04_04
		if( null != dto.getPayAllowance_05_04())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_04()); 	// ^x05_04
		if( null != dto.getPayAllowance_06_04())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_04()); 	// ^x06_04
		if( null != dto.getPayAllowance_07_04())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_04()); 	// ^x07_04
		if( null != dto.getPayAllowance_08_04())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_04()); 	// ^x08_04
		if( null != dto.getPayAllowance_09_04())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_04()); 	// ^x09_04
		if( null != dto.getPayAllowance_10_04())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_04()); 	// ^x10_04
		if( null != dto.getPayAllowance_11_04())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_04()); 	// ^x11_04
		if( null != dto.getPayAllowance_12_04())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_04()); 	// ^x12_04
		if( null != dto.getPayAllowance_13_04())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_04()); 	// ^x13_04
		if( null != dto.getPayAllowance_14_04())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_04()); 	// ^x14_04
		if( null != dto.getPayAllowance_15_04())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_04()); 	// ^x15_04
		if( null != dto.getPayAllowance_16_04())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_04()); 	// ^x16_04
		if( null != dto.getPayAllowance_17_04())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_04()); 	// ^x17_04
		if( null != dto.getPayAllowance_18_04())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_04()); 	// ^x18_04
		if( null != dto.getPayAllowance_19_04())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_04()); 	// ^x19_04
		if( null != dto.getPayAllowance_20_04())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_04()); 	// ^x20_04
		if( null != dto.getPayAllowance_21_04())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_04()); 	// ^x21_04
		if( null != dto.getPayAllowance_22_04())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_04()); 	// ^x22_04
		if( null != dto.getPayAllowance_23_04())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_04()); 	// ^x23_04
		if( null != dto.getPayAllowance_24_04())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_04()); 	// ^x24_04
		if( null != dto.getPayAllowance_25_04())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_04()); 	// ^x25_04
		if( null != dto.getPayAllowance_26_04())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_04()); 	// ^x26_04
		if( null != dto.getPayAllowance_27_04())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_04()); 	// ^x27_04
		if( null != dto.getPayAllowance_28_04())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_04()); 	// ^x28_04
		if( null != dto.getPayAllowance_29_04())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_04()); 	// ^x29_04
		if( null != dto.getPayAllowance_30_04())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_04()); 	// ^x30_04
		if( null != dto.getPayAllowanceTotal_04()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_04()); // ^xz_04
		Line   =  40;
		if( null != dto.getPayDeduction_01_04())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_04()); 	// ^T01_04
		if( null != dto.getPayDeduction_02_04())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_04()); 	// ^T02_04
		if( null != dto.getPayDeduction_03_04())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_04()); 	// ^T03_04
		if( null != dto.getPayDeduction_04_04())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_04()); 	// ^T04_04
		if( null != dto.getPayDeduction_05_04())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_04()); 	// ^T05_04
		if( null != dto.getPayDeduction_06_04())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_04()); 	// ^T06_04
		if( null != dto.getPayDeduction_07_04())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_04()); 	// ^T07_04
		if( null != dto.getPayDeduction_08_04())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_04()); 	// ^T08_04
		if( null != dto.getPayDeduction_09_04())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_04()); 	// ^T09_04
		if( null != dto.getPayDeduction_10_04())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_04()); 	// ^T10_04
		if( null != dto.getPayDeduction_11_04())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_04()); 	// ^T11_04
		if( null != dto.getPayDeduction_12_04())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_04()); 	// ^T12_04
		if( null != dto.getPayDeduction_14_04())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_04()); 	// ^T14_04
		if( null != dto.getPayDeduction_15_04())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_04()); 	// ^T15_04
		if( null != dto.getPayDeduction_16_04())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_04()); 	// ^T16_04
		if( null != dto.getPayDeduction_17_04())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_04()); 	// ^T17_04
		if( null != dto.getPayDeduction_18_04())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_04()); 	// ^T18_04
		if( null != dto.getPayDeduction_19_04())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_04()); 	// ^T19_04
		if( null != dto.getPayDeduction_20_04())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_04()); 	// ^T20_04
		if( null != dto.getPayDeduction_21_04())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_04()); 	// ^T21_04
		if( null != dto.getPayDeduction_22_04())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_04()); 	// ^T22_04
		if( null != dto.getPayDeduction_23_04())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_04()); 	// ^T23_04
		if( null != dto.getPayDeduction_24_04())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_04()); 	// ^T24_04
		if( null != dto.getPayDeduction_25_04())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_04()); 	// ^T25_04
		if( null != dto.getPayDeductionTotal_04()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_04()); // ^Tz_04
		if( null != dto.getPayDeduction_26_04())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_04()); 	// ^T26_04
		if( null != dto.getPayPaymentTotal_04())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_04()); 	// ^xz_04
		if( null != dto.getPayBank1PayAmount_04()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_04()); // ^s1Uz_04
		if( null != dto.getPayBank2PayAmount_04()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_04()); // ^s2Uz_04
		if( null != dto.getPayCashPayAmount_04())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_04());	// xz_04
		if( null != dto.getPayDeduction_27_04())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_04()); 	// ^T27_04

		Line   =  8;
		Column =  15; // 5
		if( null != dto.getPayPayday_05())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_05()); 		// ^x_05
		if( null != dto.getPayAllowance_01_05())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_05()); 	// ^x01_05
		if( null != dto.getPayAllowance_02_05())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_05()); 	// ^x02_05
		if( null != dto.getPayAllowance_03_05())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_05()); 	// ^x03_05
		if( null != dto.getPayAllowance_04_05())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_05()); 	// ^x04_05
		if( null != dto.getPayAllowance_05_05())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_05()); 	// ^x05_05
		if( null != dto.getPayAllowance_06_05())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_05()); 	// ^x06_05
		if( null != dto.getPayAllowance_07_05())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_05()); 	// ^x07_05
		if( null != dto.getPayAllowance_08_05())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_05()); 	// ^x08_05
		if( null != dto.getPayAllowance_09_05())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_05()); 	// ^x09_05
		if( null != dto.getPayAllowance_10_05())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_05()); 	// ^x10_05
		if( null != dto.getPayAllowance_11_05())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_05()); 	// ^x11_05
		if( null != dto.getPayAllowance_12_05())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_05()); 	// ^x12_05
		if( null != dto.getPayAllowance_13_05())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_05()); 	// ^x13_05
		if( null != dto.getPayAllowance_14_05())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_05()); 	// ^x14_05
		if( null != dto.getPayAllowance_15_05())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_05()); 	// ^x15_05
		if( null != dto.getPayAllowance_16_05())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_05()); 	// ^x16_05
		if( null != dto.getPayAllowance_17_05())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_05()); 	// ^x17_05
		if( null != dto.getPayAllowance_18_05())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_05()); 	// ^x18_05
		if( null != dto.getPayAllowance_19_05())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_05()); 	// ^x19_05
		if( null != dto.getPayAllowance_20_05())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_05()); 	// ^x20_05
		if( null != dto.getPayAllowance_21_05())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_05()); 	// ^x21_05
		if( null != dto.getPayAllowance_22_05())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_05()); 	// ^x22_05
		if( null != dto.getPayAllowance_23_05())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_05()); 	// ^x23_05
		if( null != dto.getPayAllowance_24_05())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_05()); 	// ^x24_05
		if( null != dto.getPayAllowance_25_05())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_05()); 	// ^x25_05
		if( null != dto.getPayAllowance_26_05())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_05()); 	// ^x26_05
		if( null != dto.getPayAllowance_27_05())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_05()); 	// ^x27_05
		if( null != dto.getPayAllowance_28_05())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_05()); 	// ^x28_05
		if( null != dto.getPayAllowance_29_05())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_05()); 	// ^x29_05
		if( null != dto.getPayAllowance_30_05())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_05()); 	// ^x30_05
		if( null != dto.getPayAllowanceTotal_05()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_05()); // ^xz_05
		Line   =  40;
		if( null != dto.getPayDeduction_01_05())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_05()); 	// ^T01_05
		if( null != dto.getPayDeduction_02_05())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_05()); 	// ^T02_05
		if( null != dto.getPayDeduction_03_05())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_05()); 	// ^T03_05
		if( null != dto.getPayDeduction_04_05())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_05()); 	// ^T04_05
		if( null != dto.getPayDeduction_05_05())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_05()); 	// ^T05_05
		if( null != dto.getPayDeduction_06_05())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_05()); 	// ^T06_05
		if( null != dto.getPayDeduction_07_05())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_05()); 	// ^T07_05
		if( null != dto.getPayDeduction_08_05())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_05()); 	// ^T08_05
		if( null != dto.getPayDeduction_09_05())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_05()); 	// ^T09_05
		if( null != dto.getPayDeduction_10_05())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_05()); 	// ^T10_05
		if( null != dto.getPayDeduction_11_05())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_05()); 	// ^T11_05
		if( null != dto.getPayDeduction_12_05())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_05()); 	// ^T12_05
		if( null != dto.getPayDeduction_14_05())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_05()); 	// ^T14_05
		if( null != dto.getPayDeduction_15_05())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_05()); 	// ^T15_05
		if( null != dto.getPayDeduction_16_05())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_05()); 	// ^T16_05
		if( null != dto.getPayDeduction_17_05())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_05()); 	// ^T17_05
		if( null != dto.getPayDeduction_18_05())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_05()); 	// ^T18_05
		if( null != dto.getPayDeduction_19_05())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_05()); 	// ^T19_05
		if( null != dto.getPayDeduction_20_05())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_05()); 	// ^T20_05
		if( null != dto.getPayDeduction_21_05())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_05()); 	// ^T21_05
		if( null != dto.getPayDeduction_22_05())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_05()); 	// ^T22_05
		if( null != dto.getPayDeduction_23_05())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_05()); 	// ^T23_05
		if( null != dto.getPayDeduction_24_05())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_05()); 	// ^T24_05
		if( null != dto.getPayDeduction_25_05())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_05()); 	// ^T25_05
		if( null != dto.getPayDeductionTotal_05()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_05()); // ^Tz_05
		if( null != dto.getPayDeduction_26_05())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_05()); 	// ^T26_05
		if( null != dto.getPayPaymentTotal_05())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_05()); 	// ^xz_05
		if( null != dto.getPayBank1PayAmount_05()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_05()); // ^s1Uz_05
		if( null != dto.getPayBank2PayAmount_05()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_05()); // ^s2Uz_05
		if( null != dto.getPayCashPayAmount_05())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_05());	// xz_05
		if( null != dto.getPayDeduction_27_05())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_05()); 	// ^T27_05

		Line   =  8;
		Column =  18; // 6
		if( null != dto.getPayPayday_06())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_06()); 		// ^x_06
		if( null != dto.getPayAllowance_01_06())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_06()); 	// ^x01_06
		if( null != dto.getPayAllowance_02_06())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_06()); 	// ^x02_06
		if( null != dto.getPayAllowance_03_06())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_06()); 	// ^x03_06
		if( null != dto.getPayAllowance_04_06())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_06()); 	// ^x04_06
		if( null != dto.getPayAllowance_05_06())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_06()); 	// ^x05_06
		if( null != dto.getPayAllowance_06_06())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_06()); 	// ^x06_06
		if( null != dto.getPayAllowance_07_06())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_06()); 	// ^x07_06
		if( null != dto.getPayAllowance_08_06())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_06()); 	// ^x08_06
		if( null != dto.getPayAllowance_09_06())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_06()); 	// ^x09_06
		if( null != dto.getPayAllowance_10_06())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_06()); 	// ^x10_06
		if( null != dto.getPayAllowance_11_06())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_06()); 	// ^x11_06
		if( null != dto.getPayAllowance_12_06())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_06()); 	// ^x12_06
		if( null != dto.getPayAllowance_13_06())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_06()); 	// ^x13_06
		if( null != dto.getPayAllowance_14_06())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_06()); 	// ^x14_06
		if( null != dto.getPayAllowance_15_06())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_06()); 	// ^x15_06
		if( null != dto.getPayAllowance_16_06())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_06()); 	// ^x16_06
		if( null != dto.getPayAllowance_17_06())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_06()); 	// ^x17_06
		if( null != dto.getPayAllowance_18_06())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_06()); 	// ^x18_06
		if( null != dto.getPayAllowance_19_06())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_06()); 	// ^x19_06
		if( null != dto.getPayAllowance_20_06())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_06()); 	// ^x20_06
		if( null != dto.getPayAllowance_21_06())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_06()); 	// ^x21_06
		if( null != dto.getPayAllowance_22_06())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_06()); 	// ^x22_06
		if( null != dto.getPayAllowance_23_06())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_06()); 	// ^x23_06
		if( null != dto.getPayAllowance_24_06())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_06()); 	// ^x24_06
		if( null != dto.getPayAllowance_25_06())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_06()); 	// ^x25_06
		if( null != dto.getPayAllowance_26_06())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_06()); 	// ^x26_06
		if( null != dto.getPayAllowance_27_06())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_06()); 	// ^x27_06
		if( null != dto.getPayAllowance_28_06())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_06()); 	// ^x28_06
		if( null != dto.getPayAllowance_29_06())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_06()); 	// ^x29_06
		if( null != dto.getPayAllowance_30_06())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_06()); 	// ^x30_06
		if( null != dto.getPayAllowanceTotal_06()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_06()); // ^xz_06
		Line   =  40;
		if( null != dto.getPayDeduction_01_06())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_06()); 	// ^T01_06
		if( null != dto.getPayDeduction_02_06())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_06()); 	// ^T02_06
		if( null != dto.getPayDeduction_03_06())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_06()); 	// ^T03_06
		if( null != dto.getPayDeduction_04_06())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_06()); 	// ^T04_06
		if( null != dto.getPayDeduction_05_06())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_06()); 	// ^T05_06
		if( null != dto.getPayDeduction_06_06())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_06()); 	// ^T06_06
		if( null != dto.getPayDeduction_07_06())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_06()); 	// ^T07_06
		if( null != dto.getPayDeduction_08_06())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_06()); 	// ^T08_06
		if( null != dto.getPayDeduction_09_06())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_06()); 	// ^T09_06
		if( null != dto.getPayDeduction_10_06())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_06()); 	// ^T10_06
		if( null != dto.getPayDeduction_11_06())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_06()); 	// ^T11_06
		if( null != dto.getPayDeduction_12_06())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_06()); 	// ^T12_06
		if( null != dto.getPayDeduction_14_06())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_06()); 	// ^T14_06
		if( null != dto.getPayDeduction_15_06())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_06()); 	// ^T15_06
		if( null != dto.getPayDeduction_16_06())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_06()); 	// ^T16_06
		if( null != dto.getPayDeduction_17_06())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_06()); 	// ^T17_06
		if( null != dto.getPayDeduction_18_06())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_06()); 	// ^T18_06
		if( null != dto.getPayDeduction_19_06())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_06()); 	// ^T19_06
		if( null != dto.getPayDeduction_20_06())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_06()); 	// ^T20_06
		if( null != dto.getPayDeduction_21_06())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_06()); 	// ^T21_06
		if( null != dto.getPayDeduction_22_06())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_06()); 	// ^T22_06
		if( null != dto.getPayDeduction_23_06())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_06()); 	// ^T23_06
		if( null != dto.getPayDeduction_24_06())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_06()); 	// ^T24_06
		if( null != dto.getPayDeduction_25_06())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_06()); 	// ^T25_06
		if( null != dto.getPayDeductionTotal_06()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_06()); // ^Tz_06
		if( null != dto.getPayDeduction_26_06())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_06()); 	// ^T26_06
		if( null != dto.getPayPaymentTotal_06())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_06()); 	// ^xz_06
		if( null != dto.getPayBank1PayAmount_06()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_06()); // ^s1Uz_06
		if( null != dto.getPayBank2PayAmount_06()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_06()); // ^s2Uz_06
		if( null != dto.getPayCashPayAmount_06())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_06());	// xz_06
		if( null != dto.getPayDeduction_27_06())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_06()); 	// ^T27_06

		Line   =  8;
		Column =  21; // 7
		if( null != dto.getPayPayday_07())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_07()); 		// ^x_07
		if( null != dto.getPayAllowance_01_07())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_07()); 	// ^x01_07
		if( null != dto.getPayAllowance_02_07())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_07()); 	// ^x02_07
		if( null != dto.getPayAllowance_03_07())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_07()); 	// ^x03_07
		if( null != dto.getPayAllowance_04_07())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_07()); 	// ^x04_07
		if( null != dto.getPayAllowance_05_07())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_07()); 	// ^x05_07
		if( null != dto.getPayAllowance_06_07())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_07()); 	// ^x06_07
		if( null != dto.getPayAllowance_07_07())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_07()); 	// ^x07_07
		if( null != dto.getPayAllowance_08_07())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_07()); 	// ^x08_07
		if( null != dto.getPayAllowance_09_07())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_07()); 	// ^x09_07
		if( null != dto.getPayAllowance_10_07())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_07()); 	// ^x10_07
		if( null != dto.getPayAllowance_11_07())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_07()); 	// ^x11_07
		if( null != dto.getPayAllowance_12_07())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_07()); 	// ^x12_07
		if( null != dto.getPayAllowance_13_07())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_07()); 	// ^x13_07
		if( null != dto.getPayAllowance_14_07())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_07()); 	// ^x14_07
		if( null != dto.getPayAllowance_15_07())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_07()); 	// ^x15_07
		if( null != dto.getPayAllowance_16_07())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_07()); 	// ^x16_07
		if( null != dto.getPayAllowance_17_07())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_07()); 	// ^x17_07
		if( null != dto.getPayAllowance_18_07())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_07()); 	// ^x18_07
		if( null != dto.getPayAllowance_19_07())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_07()); 	// ^x19_07
		if( null != dto.getPayAllowance_20_07())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_07()); 	// ^x20_07
		if( null != dto.getPayAllowance_21_07())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_07()); 	// ^x21_07
		if( null != dto.getPayAllowance_22_07())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_07()); 	// ^x22_07
		if( null != dto.getPayAllowance_23_07())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_07()); 	// ^x23_07
		if( null != dto.getPayAllowance_24_07())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_07()); 	// ^x24_07
		if( null != dto.getPayAllowance_25_07())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_07()); 	// ^x25_07
		if( null != dto.getPayAllowance_26_07())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_07()); 	// ^x26_07
		if( null != dto.getPayAllowance_27_07())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_07()); 	// ^x27_07
		if( null != dto.getPayAllowance_28_07())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_07()); 	// ^x28_07
		if( null != dto.getPayAllowance_29_07())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_07()); 	// ^x29_07
		if( null != dto.getPayAllowance_30_07())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_07()); 	// ^x30_07
		if( null != dto.getPayAllowanceTotal_07()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_07()); // ^xz_07
		Line   =  40;
		if( null != dto.getPayDeduction_01_07())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_07()); 	// ^T01_07
		if( null != dto.getPayDeduction_02_07())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_07()); 	// ^T02_07
		if( null != dto.getPayDeduction_03_07())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_07()); 	// ^T03_07
		if( null != dto.getPayDeduction_04_07())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_07()); 	// ^T04_07
		if( null != dto.getPayDeduction_05_07())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_07()); 	// ^T05_07
		if( null != dto.getPayDeduction_06_07())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_07()); 	// ^T06_07
		if( null != dto.getPayDeduction_07_07())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_07()); 	// ^T07_07
		if( null != dto.getPayDeduction_08_07())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_07()); 	// ^T08_07
		if( null != dto.getPayDeduction_09_07())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_07()); 	// ^T09_07
		if( null != dto.getPayDeduction_10_07())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_07()); 	// ^T10_07
		if( null != dto.getPayDeduction_11_07())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_07()); 	// ^T11_07
		if( null != dto.getPayDeduction_12_07())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_07()); 	// ^T12_07
		if( null != dto.getPayDeduction_14_07())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_07()); 	// ^T14_07
		if( null != dto.getPayDeduction_15_07())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_07()); 	// ^T15_07
		if( null != dto.getPayDeduction_16_07())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_07()); 	// ^T16_07
		if( null != dto.getPayDeduction_17_07())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_07()); 	// ^T17_07
		if( null != dto.getPayDeduction_18_07())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_07()); 	// ^T18_07
		if( null != dto.getPayDeduction_19_07())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_07()); 	// ^T19_07
		if( null != dto.getPayDeduction_20_07())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_07()); 	// ^T20_07
		if( null != dto.getPayDeduction_21_07())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_07()); 	// ^T21_07
		if( null != dto.getPayDeduction_22_07())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_07()); 	// ^T22_07
		if( null != dto.getPayDeduction_23_07())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_07()); 	// ^T23_07
		if( null != dto.getPayDeduction_24_07())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_07()); 	// ^T24_07
		if( null != dto.getPayDeduction_25_07())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_07()); 	// ^T25_07
		if( null != dto.getPayDeductionTotal_07()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_07()); // ^Tz_07
		if( null != dto.getPayDeduction_26_07())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_07()); 	// ^T26_07
		if( null != dto.getPayPaymentTotal_07())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_07()); 	// ^xz_07
		if( null != dto.getPayBank1PayAmount_07()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_07()); // ^s1Uz_07
		if( null != dto.getPayBank2PayAmount_07()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_07()); // ^s2Uz_07
		if( null != dto.getPayCashPayAmount_07())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_07());	// xz_07
		if( null != dto.getPayDeduction_27_07())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_07()); 	// ^T27_07

		Line   =  8;
		Column =  24; // 8
		if( null != dto.getPayPayday_08())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_08()); 		// ^x_08
		if( null != dto.getPayAllowance_01_08())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_08()); 	// ^x01_08
		if( null != dto.getPayAllowance_02_08())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_08()); 	// ^x02_08
		if( null != dto.getPayAllowance_03_08())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_08()); 	// ^x03_08
		if( null != dto.getPayAllowance_04_08())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_08()); 	// ^x04_08
		if( null != dto.getPayAllowance_05_08())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_08()); 	// ^x05_08
		if( null != dto.getPayAllowance_06_08())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_08()); 	// ^x06_08
		if( null != dto.getPayAllowance_07_08())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_08()); 	// ^x07_08
		if( null != dto.getPayAllowance_08_08())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_08()); 	// ^x08_08
		if( null != dto.getPayAllowance_09_08())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_08()); 	// ^x09_08
		if( null != dto.getPayAllowance_10_08())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_08()); 	// ^x10_08
		if( null != dto.getPayAllowance_11_08())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_08()); 	// ^x11_08
		if( null != dto.getPayAllowance_12_08())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_08()); 	// ^x12_08
		if( null != dto.getPayAllowance_13_08())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_08()); 	// ^x13_08
		if( null != dto.getPayAllowance_14_08())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_08()); 	// ^x14_08
		if( null != dto.getPayAllowance_15_08())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_08()); 	// ^x15_08
		if( null != dto.getPayAllowance_16_08())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_08()); 	// ^x16_08
		if( null != dto.getPayAllowance_17_08())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_08()); 	// ^x17_08
		if( null != dto.getPayAllowance_18_08())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_08()); 	// ^x18_08
		if( null != dto.getPayAllowance_19_08())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_08()); 	// ^x19_08
		if( null != dto.getPayAllowance_20_08())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_08()); 	// ^x20_08
		if( null != dto.getPayAllowance_21_08())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_08()); 	// ^x21_08
		if( null != dto.getPayAllowance_22_08())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_08()); 	// ^x22_08
		if( null != dto.getPayAllowance_23_08())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_08()); 	// ^x23_08
		if( null != dto.getPayAllowance_24_08())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_08()); 	// ^x24_08
		if( null != dto.getPayAllowance_25_08())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_08()); 	// ^x25_08
		if( null != dto.getPayAllowance_26_08())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_08()); 	// ^x26_08
		if( null != dto.getPayAllowance_27_08())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_08()); 	// ^x27_08
		if( null != dto.getPayAllowance_28_08())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_08()); 	// ^x28_08
		if( null != dto.getPayAllowance_29_08())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_08()); 	// ^x29_08
		if( null != dto.getPayAllowance_30_08())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_08()); 	// ^x30_08
		if( null != dto.getPayAllowanceTotal_08()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_08()); // ^xz_08
		Line   =  40;
		if( null != dto.getPayDeduction_01_08())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_08()); 	// ^T01_08
		if( null != dto.getPayDeduction_02_08())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_08()); 	// ^T02_08
		if( null != dto.getPayDeduction_03_08())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_08()); 	// ^T03_08
		if( null != dto.getPayDeduction_04_08())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_08()); 	// ^T04_08
		if( null != dto.getPayDeduction_05_08())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_08()); 	// ^T05_08
		if( null != dto.getPayDeduction_06_08())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_08()); 	// ^T06_08
		if( null != dto.getPayDeduction_07_08())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_08()); 	// ^T07_08
		if( null != dto.getPayDeduction_08_08())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_08()); 	// ^T08_08
		if( null != dto.getPayDeduction_09_08())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_08()); 	// ^T09_08
		if( null != dto.getPayDeduction_10_08())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_08()); 	// ^T10_08
		if( null != dto.getPayDeduction_11_08())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_08()); 	// ^T11_08
		if( null != dto.getPayDeduction_12_08())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_08()); 	// ^T12_08
		if( null != dto.getPayDeduction_14_08())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_08()); 	// ^T14_08
		if( null != dto.getPayDeduction_15_08())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_08()); 	// ^T15_08
		if( null != dto.getPayDeduction_16_08())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_08()); 	// ^T16_08
		if( null != dto.getPayDeduction_17_08())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_08()); 	// ^T17_08
		if( null != dto.getPayDeduction_18_08())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_08()); 	// ^T18_08
		if( null != dto.getPayDeduction_19_08())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_08()); 	// ^T19_08
		if( null != dto.getPayDeduction_20_08())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_08()); 	// ^T20_08
		if( null != dto.getPayDeduction_21_08())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_08()); 	// ^T21_08
		if( null != dto.getPayDeduction_22_08())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_08()); 	// ^T22_08
		if( null != dto.getPayDeduction_23_08())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_08()); 	// ^T23_08
		if( null != dto.getPayDeduction_24_08())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_08()); 	// ^T24_08
		if( null != dto.getPayDeduction_25_08())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_08()); 	// ^T25_08
		if( null != dto.getPayDeductionTotal_08()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_08()); // ^Tz_08
		if( null != dto.getPayDeduction_26_08())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_08()); 	// ^T26_08
		if( null != dto.getPayPaymentTotal_08())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_08()); 	// ^xz_08
		if( null != dto.getPayBank1PayAmount_08()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_08()); // ^s1Uz_08
		if( null != dto.getPayBank2PayAmount_08()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_08()); // ^s2Uz_08
		if( null != dto.getPayCashPayAmount_08())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_08());	// xz_08
		if( null != dto.getPayDeduction_27_08())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_08()); 	// ^T27_08

		Line   =  8;
		Column =  27; // 9
		if( null != dto.getPayPayday_09())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_09()); 		// ^x_09
		if( null != dto.getPayAllowance_01_09())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_09()); 	// ^x01_09
		if( null != dto.getPayAllowance_02_09())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_09()); 	// ^x02_09
		if( null != dto.getPayAllowance_03_09())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_09()); 	// ^x03_09
		if( null != dto.getPayAllowance_04_09())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_09()); 	// ^x04_09
		if( null != dto.getPayAllowance_05_09())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_09()); 	// ^x05_09
		if( null != dto.getPayAllowance_06_09())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_09()); 	// ^x06_09
		if( null != dto.getPayAllowance_07_09())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_09()); 	// ^x07_09
		if( null != dto.getPayAllowance_08_09())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_09()); 	// ^x08_09
		if( null != dto.getPayAllowance_09_09())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_09()); 	// ^x09_09
		if( null != dto.getPayAllowance_10_09())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_09()); 	// ^x10_09
		if( null != dto.getPayAllowance_11_09())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_09()); 	// ^x11_09
		if( null != dto.getPayAllowance_12_09())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_09()); 	// ^x12_09
		if( null != dto.getPayAllowance_13_09())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_09()); 	// ^x13_09
		if( null != dto.getPayAllowance_14_09())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_09()); 	// ^x14_09
		if( null != dto.getPayAllowance_15_09())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_09()); 	// ^x15_09
		if( null != dto.getPayAllowance_16_09())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_09()); 	// ^x16_09
		if( null != dto.getPayAllowance_17_09())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_09()); 	// ^x17_09
		if( null != dto.getPayAllowance_18_09())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_09()); 	// ^x18_09
		if( null != dto.getPayAllowance_19_09())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_09()); 	// ^x19_09
		if( null != dto.getPayAllowance_20_09())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_09()); 	// ^x20_09
		if( null != dto.getPayAllowance_21_09())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_09()); 	// ^x21_09
		if( null != dto.getPayAllowance_22_09())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_09()); 	// ^x22_09
		if( null != dto.getPayAllowance_23_09())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_09()); 	// ^x23_09
		if( null != dto.getPayAllowance_24_09())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_09()); 	// ^x24_09
		if( null != dto.getPayAllowance_25_09())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_09()); 	// ^x25_09
		if( null != dto.getPayAllowance_26_09())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_09()); 	// ^x26_09
		if( null != dto.getPayAllowance_27_09())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_09()); 	// ^x27_09
		if( null != dto.getPayAllowance_28_09())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_09()); 	// ^x28_09
		if( null != dto.getPayAllowance_29_09())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_09()); 	// ^x29_09
		if( null != dto.getPayAllowance_30_09())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_09()); 	// ^x30_09
		if( null != dto.getPayAllowanceTotal_09()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_09()); // ^xz_09
		Line   =  40;
		if( null != dto.getPayDeduction_01_09())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_09()); 	// ^T01_09
		if( null != dto.getPayDeduction_02_09())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_09()); 	// ^T02_09
		if( null != dto.getPayDeduction_03_09())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_09()); 	// ^T03_09
		if( null != dto.getPayDeduction_04_09())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_09()); 	// ^T04_09
		if( null != dto.getPayDeduction_05_09())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_09()); 	// ^T05_09
		if( null != dto.getPayDeduction_06_09())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_09()); 	// ^T06_09
		if( null != dto.getPayDeduction_07_09())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_09()); 	// ^T07_09
		if( null != dto.getPayDeduction_08_09())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_09()); 	// ^T08_09
		if( null != dto.getPayDeduction_09_09())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_09()); 	// ^T09_09
		if( null != dto.getPayDeduction_10_09())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_09()); 	// ^T10_09
		if( null != dto.getPayDeduction_11_09())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_09()); 	// ^T11_09
		if( null != dto.getPayDeduction_12_09())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_09()); 	// ^T12_09
		if( null != dto.getPayDeduction_14_09())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_09()); 	// ^T14_09
		if( null != dto.getPayDeduction_15_09())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_09()); 	// ^T15_09
		if( null != dto.getPayDeduction_16_09())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_09()); 	// ^T16_09
		if( null != dto.getPayDeduction_17_09())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_09()); 	// ^T17_09
		if( null != dto.getPayDeduction_18_09())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_09()); 	// ^T18_09
		if( null != dto.getPayDeduction_19_09())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_09()); 	// ^T19_09
		if( null != dto.getPayDeduction_20_09())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_09()); 	// ^T20_09
		if( null != dto.getPayDeduction_21_09())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_09()); 	// ^T21_09
		if( null != dto.getPayDeduction_22_09())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_09()); 	// ^T22_09
		if( null != dto.getPayDeduction_23_09())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_09()); 	// ^T23_09
		if( null != dto.getPayDeduction_24_09())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_09()); 	// ^T24_09
		if( null != dto.getPayDeduction_25_09())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_09()); 	// ^T25_09
		if( null != dto.getPayDeductionTotal_09()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_09()); // ^Tz_09
		if( null != dto.getPayDeduction_26_09())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_09()); 	// ^T26_09
		if( null != dto.getPayPaymentTotal_09())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_09()); 	// ^xz_09
		if( null != dto.getPayBank1PayAmount_09()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_09()); // ^s1Uz_09
		if( null != dto.getPayBank2PayAmount_09()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_09()); // ^s2Uz_09
		if( null != dto.getPayCashPayAmount_09())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_09());	// xz_09
		if( null != dto.getPayDeduction_27_09())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_09()); 	// ^T27_09

		Line   =  8;
		Column =  30; // 10
		if( null != dto.getPayPayday_10())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_10()); 		// ^x_10
		if( null != dto.getPayAllowance_01_10())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_10()); 	// ^x01_10
		if( null != dto.getPayAllowance_02_10())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_10()); 	// ^x02_10
		if( null != dto.getPayAllowance_03_10())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_10()); 	// ^x03_10
		if( null != dto.getPayAllowance_04_10())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_10()); 	// ^x04_10
		if( null != dto.getPayAllowance_05_10())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_10()); 	// ^x05_10
		if( null != dto.getPayAllowance_06_10())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_10()); 	// ^x06_10
		if( null != dto.getPayAllowance_07_10())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_10()); 	// ^x07_10
		if( null != dto.getPayAllowance_08_10())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_10()); 	// ^x08_10
		if( null != dto.getPayAllowance_09_10())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_10()); 	// ^x09_10
		if( null != dto.getPayAllowance_10_10())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_10()); 	// ^x10_10
		if( null != dto.getPayAllowance_11_10())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_10()); 	// ^x11_10
		if( null != dto.getPayAllowance_12_10())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_10()); 	// ^x12_10
		if( null != dto.getPayAllowance_13_10())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_10()); 	// ^x13_10
		if( null != dto.getPayAllowance_14_10())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_10()); 	// ^x14_10
		if( null != dto.getPayAllowance_15_10())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_10()); 	// ^x15_10
		if( null != dto.getPayAllowance_16_10())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_10()); 	// ^x16_10
		if( null != dto.getPayAllowance_17_10())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_10()); 	// ^x17_10
		if( null != dto.getPayAllowance_18_10())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_10()); 	// ^x18_10
		if( null != dto.getPayAllowance_19_10())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_10()); 	// ^x19_10
		if( null != dto.getPayAllowance_20_10())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_10()); 	// ^x20_10
		if( null != dto.getPayAllowance_21_10())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_10()); 	// ^x21_10
		if( null != dto.getPayAllowance_22_10())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_10()); 	// ^x22_10
		if( null != dto.getPayAllowance_23_10())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_10()); 	// ^x23_10
		if( null != dto.getPayAllowance_24_10())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_10()); 	// ^x24_10
		if( null != dto.getPayAllowance_25_10())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_10()); 	// ^x25_10
		if( null != dto.getPayAllowance_26_10())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_10()); 	// ^x26_10
		if( null != dto.getPayAllowance_27_10())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_10()); 	// ^x27_10
		if( null != dto.getPayAllowance_28_10())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_10()); 	// ^x28_10
		if( null != dto.getPayAllowance_29_10())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_10()); 	// ^x29_10
		if( null != dto.getPayAllowance_30_10())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_10()); 	// ^x30_10
		if( null != dto.getPayAllowanceTotal_10()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_10()); // ^xz_10
		Line   =  40;
		if( null != dto.getPayDeduction_01_10())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_10()); 	// ^T01_10
		if( null != dto.getPayDeduction_02_10())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_10()); 	// ^T02_10
		if( null != dto.getPayDeduction_03_10())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_10()); 	// ^T03_10
		if( null != dto.getPayDeduction_04_10())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_10()); 	// ^T04_10
		if( null != dto.getPayDeduction_05_10())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_10()); 	// ^T05_10
		if( null != dto.getPayDeduction_06_10())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_10()); 	// ^T06_10
		if( null != dto.getPayDeduction_07_10())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_10()); 	// ^T07_10
		if( null != dto.getPayDeduction_08_10())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_10()); 	// ^T08_10
		if( null != dto.getPayDeduction_09_10())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_10()); 	// ^T09_10
		if( null != dto.getPayDeduction_10_10())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_10()); 	// ^T10_10
		if( null != dto.getPayDeduction_11_10())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_10()); 	// ^T11_10
		if( null != dto.getPayDeduction_12_10())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_10()); 	// ^T12_10
		if( null != dto.getPayDeduction_14_10())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_10()); 	// ^T14_10
		if( null != dto.getPayDeduction_15_10())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_10()); 	// ^T15_10
		if( null != dto.getPayDeduction_16_10())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_10()); 	// ^T16_10
		if( null != dto.getPayDeduction_17_10())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_10()); 	// ^T17_10
		if( null != dto.getPayDeduction_18_10())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_10()); 	// ^T18_10
		if( null != dto.getPayDeduction_19_10())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_10()); 	// ^T19_10
		if( null != dto.getPayDeduction_20_10())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_10()); 	// ^T20_10
		if( null != dto.getPayDeduction_21_10())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_10()); 	// ^T21_10
		if( null != dto.getPayDeduction_22_10())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_10()); 	// ^T22_10
		if( null != dto.getPayDeduction_23_10())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_10()); 	// ^T23_10
		if( null != dto.getPayDeduction_24_10())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_10()); 	// ^T24_10
		if( null != dto.getPayDeduction_25_10())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_10()); 	// ^T25_10
		if( null != dto.getPayDeductionTotal_10()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_10()); // ^Tz_10
		if( null != dto.getPayDeduction_26_10())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_10()); 	// ^T26_10
		if( null != dto.getPayPaymentTotal_10())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_10()); 	// ^xz_10
		if( null != dto.getPayBank1PayAmount_10()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_10()); // ^s1Uz_10
		if( null != dto.getPayBank2PayAmount_10()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_10()); // ^s2Uz_10
		if( null != dto.getPayCashPayAmount_10())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_10());	// xz_10
		if( null != dto.getPayDeduction_27_10())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_10()); 	// ^T27_10

		Line   =  8;
		Column =  33; // 11
		if( null != dto.getPayPayday_11())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_11()); 		// ^x_11
		if( null != dto.getPayAllowance_01_11())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_11()); 	// ^x01_11
		if( null != dto.getPayAllowance_02_11())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_11()); 	// ^x02_11
		if( null != dto.getPayAllowance_03_11())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_11()); 	// ^x03_11
		if( null != dto.getPayAllowance_04_11())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_11()); 	// ^x04_11
		if( null != dto.getPayAllowance_05_11())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_11()); 	// ^x05_11
		if( null != dto.getPayAllowance_06_11())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_11()); 	// ^x06_11
		if( null != dto.getPayAllowance_07_11())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_11()); 	// ^x07_11
		if( null != dto.getPayAllowance_08_11())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_11()); 	// ^x08_11
		if( null != dto.getPayAllowance_09_11())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_11()); 	// ^x09_11
		if( null != dto.getPayAllowance_10_11())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_11()); 	// ^x10_11
		if( null != dto.getPayAllowance_11_11())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_11()); 	// ^x11_11
		if( null != dto.getPayAllowance_12_11())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_11()); 	// ^x12_11
		if( null != dto.getPayAllowance_13_11())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_11()); 	// ^x13_11
		if( null != dto.getPayAllowance_14_11())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_11()); 	// ^x14_11
		if( null != dto.getPayAllowance_15_11())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_11()); 	// ^x15_11
		if( null != dto.getPayAllowance_16_11())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_11()); 	// ^x16_11
		if( null != dto.getPayAllowance_17_11())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_11()); 	// ^x17_11
		if( null != dto.getPayAllowance_18_11())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_11()); 	// ^x18_11
		if( null != dto.getPayAllowance_19_11())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_11()); 	// ^x19_11
		if( null != dto.getPayAllowance_20_11())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_11()); 	// ^x20_11
		if( null != dto.getPayAllowance_21_11())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_11()); 	// ^x21_11
		if( null != dto.getPayAllowance_22_11())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_11()); 	// ^x22_11
		if( null != dto.getPayAllowance_23_11())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_11()); 	// ^x23_11
		if( null != dto.getPayAllowance_24_11())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_11()); 	// ^x24_11
		if( null != dto.getPayAllowance_25_11())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_11()); 	// ^x25_11
		if( null != dto.getPayAllowance_26_11())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_11()); 	// ^x26_11
		if( null != dto.getPayAllowance_27_11())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_11()); 	// ^x27_11
		if( null != dto.getPayAllowance_28_11())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_11()); 	// ^x28_11
		if( null != dto.getPayAllowance_29_11())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_11()); 	// ^x29_11
		if( null != dto.getPayAllowance_30_11())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_11()); 	// ^x30_11
		if( null != dto.getPayAllowanceTotal_11()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_11()); // ^xz_11
		Line   =  40;
		if( null != dto.getPayDeduction_01_11())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_11()); 	// ^T01_11
		if( null != dto.getPayDeduction_02_11())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_11()); 	// ^T02_11
		if( null != dto.getPayDeduction_03_11())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_11()); 	// ^T03_11
		if( null != dto.getPayDeduction_04_11())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_11()); 	// ^T04_11
		if( null != dto.getPayDeduction_05_11())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_11()); 	// ^T05_11
		if( null != dto.getPayDeduction_06_11())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_11()); 	// ^T06_11
		if( null != dto.getPayDeduction_07_11())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_11()); 	// ^T07_11
		if( null != dto.getPayDeduction_08_11())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_11()); 	// ^T08_11
		if( null != dto.getPayDeduction_09_11())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_11()); 	// ^T09_11
		if( null != dto.getPayDeduction_10_11())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_11()); 	// ^T10_11
		if( null != dto.getPayDeduction_11_11())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_11()); 	// ^T11_11
		if( null != dto.getPayDeduction_12_11())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_11()); 	// ^T12_11
		if( null != dto.getPayDeduction_14_11())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_11()); 	// ^T14_11
		if( null != dto.getPayDeduction_15_11())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_11()); 	// ^T15_11
		if( null != dto.getPayDeduction_16_11())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_11()); 	// ^T16_11
		if( null != dto.getPayDeduction_17_11())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_11()); 	// ^T17_11
		if( null != dto.getPayDeduction_18_11())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_11()); 	// ^T18_11
		if( null != dto.getPayDeduction_19_11())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_11()); 	// ^T19_11
		if( null != dto.getPayDeduction_20_11())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_11()); 	// ^T20_11
		if( null != dto.getPayDeduction_21_11())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_11()); 	// ^T21_11
		if( null != dto.getPayDeduction_22_11())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_11()); 	// ^T22_11
		if( null != dto.getPayDeduction_23_11())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_11()); 	// ^T23_11
		if( null != dto.getPayDeduction_24_11())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_11()); 	// ^T24_11
		if( null != dto.getPayDeduction_25_11())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_11()); 	// ^T25_11
		if( null != dto.getPayDeductionTotal_11()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_11()); // ^Tz_11
		if( null != dto.getPayDeduction_26_11())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_11()); 	// ^T26_11
		if( null != dto.getPayPaymentTotal_11())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_11()); 	// ^xz_11
		if( null != dto.getPayBank1PayAmount_11()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_11()); // ^s1Uz_11
		if( null != dto.getPayBank2PayAmount_11()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_11()); // ^s2Uz_11
		if( null != dto.getPayCashPayAmount_11())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_11());	// xz_11
		if( null != dto.getPayDeduction_27_11())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_11()); 	// ^T27_11

		Line   =  8;
		Column =  36; // 12
		if( null != dto.getPayPayday_12())         prtItem_chk( poi, Line -   1, Column, dto.getPayPayday_12()); 		// ^x_12
		if( null != dto.getPayAllowance_01_12())   prtItem_chk( poi, Line +   1, Column, dto.getPayAllowance_01_12()); 	// ^x01_12
		if( null != dto.getPayAllowance_02_12())   prtItem_chk( poi, Line +   2, Column, dto.getPayAllowance_02_12()); 	// ^x02_12
		if( null != dto.getPayAllowance_03_12())   prtItem_chk( poi, Line +   3, Column, dto.getPayAllowance_03_12()); 	// ^x03_12
		if( null != dto.getPayAllowance_04_12())   prtItem_chk( poi, Line +   4, Column, dto.getPayAllowance_04_12()); 	// ^x04_12
		if( null != dto.getPayAllowance_05_12())   prtItem_chk( poi, Line +   5, Column, dto.getPayAllowance_05_12()); 	// ^x05_12
		if( null != dto.getPayAllowance_06_12())   prtItem_chk( poi, Line +   6, Column, dto.getPayAllowance_06_12()); 	// ^x06_12
		if( null != dto.getPayAllowance_07_12())   prtItem_chk( poi, Line +   7, Column, dto.getPayAllowance_07_12()); 	// ^x07_12
		if( null != dto.getPayAllowance_08_12())   prtItem_chk( poi, Line +   8, Column, dto.getPayAllowance_08_12()); 	// ^x08_12
		if( null != dto.getPayAllowance_09_12())   prtItem_chk( poi, Line +   9, Column, dto.getPayAllowance_09_12()); 	// ^x09_12
		if( null != dto.getPayAllowance_10_12())   prtItem_chk( poi, Line +  10, Column, dto.getPayAllowance_10_12()); 	// ^x10_12
		if( null != dto.getPayAllowance_11_12())   prtItem_chk( poi, Line +  11, Column, dto.getPayAllowance_11_12()); 	// ^x11_12
		if( null != dto.getPayAllowance_12_12())   prtItem_chk( poi, Line +  12, Column, dto.getPayAllowance_12_12()); 	// ^x12_12
		if( null != dto.getPayAllowance_13_12())   prtItem_chk( poi, Line +  13, Column, dto.getPayAllowance_13_12()); 	// ^x13_12
		if( null != dto.getPayAllowance_14_12())   prtItem_chk( poi, Line +  14, Column, dto.getPayAllowance_14_12()); 	// ^x14_12
		if( null != dto.getPayAllowance_15_12())   prtItem_chk( poi, Line +  15, Column, dto.getPayAllowance_15_12()); 	// ^x15_12
		if( null != dto.getPayAllowance_16_12())   prtItem_chk( poi, Line +  16, Column, dto.getPayAllowance_16_12()); 	// ^x16_12
		if( null != dto.getPayAllowance_17_12())   prtItem_chk( poi, Line +  17, Column, dto.getPayAllowance_17_12()); 	// ^x17_12
		if( null != dto.getPayAllowance_18_12())   prtItem_chk( poi, Line +  18, Column, dto.getPayAllowance_18_12()); 	// ^x18_12
		if( null != dto.getPayAllowance_19_12())   prtItem_chk( poi, Line +  19, Column, dto.getPayAllowance_19_12()); 	// ^x19_12
		if( null != dto.getPayAllowance_20_12())   prtItem_chk( poi, Line +  20, Column, dto.getPayAllowance_20_12()); 	// ^x20_12
		if( null != dto.getPayAllowance_21_12())   prtItem_chk( poi, Line +  21, Column, dto.getPayAllowance_21_12()); 	// ^x21_12
		if( null != dto.getPayAllowance_22_12())   prtItem_chk( poi, Line +  22, Column, dto.getPayAllowance_22_12()); 	// ^x22_12
		if( null != dto.getPayAllowance_23_12())   prtItem_chk( poi, Line +  23, Column, dto.getPayAllowance_23_12()); 	// ^x23_12
		if( null != dto.getPayAllowance_24_12())   prtItem_chk( poi, Line +  24, Column, dto.getPayAllowance_24_12()); 	// ^x24_12
		if( null != dto.getPayAllowance_25_12())   prtItem_chk( poi, Line +  25, Column, dto.getPayAllowance_25_12()); 	// ^x25_12
		if( null != dto.getPayAllowance_26_12())   prtItem_chk( poi, Line +  26, Column, dto.getPayAllowance_26_12()); 	// ^x26_12
		if( null != dto.getPayAllowance_27_12())   prtItem_chk( poi, Line +  27, Column, dto.getPayAllowance_27_12()); 	// ^x27_12
		if( null != dto.getPayAllowance_28_12())   prtItem_chk( poi, Line +  28, Column, dto.getPayAllowance_28_12()); 	// ^x28_12
		if( null != dto.getPayAllowance_29_12())   prtItem_chk( poi, Line +  29, Column, dto.getPayAllowance_29_12()); 	// ^x29_12
		if( null != dto.getPayAllowance_30_12())   prtItem_chk( poi, Line +  30, Column, dto.getPayAllowance_30_12()); 	// ^x30_12
		if( null != dto.getPayAllowanceTotal_12()) prtItem_chk( poi, Line +  31, Column, dto.getPayAllowanceTotal_12()); // ^xz_12
		Line   =  40;
		if( null != dto.getPayDeduction_01_12())   prtItem_chk( poi, Line +   1, Column, dto.getPayDeduction_01_12()); 	// ^T01_12
		if( null != dto.getPayDeduction_02_12())   prtItem_chk( poi, Line +   2, Column, dto.getPayDeduction_02_12()); 	// ^T02_12
		if( null != dto.getPayDeduction_03_12())   prtItem_chk( poi, Line +   3, Column, dto.getPayDeduction_03_12()); 	// ^T03_12
		if( null != dto.getPayDeduction_04_12())   prtItem_chk( poi, Line +   4, Column, dto.getPayDeduction_04_12()); 	// ^T04_12
		if( null != dto.getPayDeduction_05_12())   prtItem_chk( poi, Line +   5, Column, dto.getPayDeduction_05_12()); 	// ^T05_12
		if( null != dto.getPayDeduction_06_12())   prtItem_chk( poi, Line +   6, Column, dto.getPayDeduction_06_12()); 	// ^T06_12
		if( null != dto.getPayDeduction_07_12())   prtItem_chk( poi, Line +   7, Column, dto.getPayDeduction_07_12()); 	// ^T07_12
		if( null != dto.getPayDeduction_08_12())   prtItem_chk( poi, Line +   8, Column, dto.getPayDeduction_08_12()); 	// ^T08_12
		if( null != dto.getPayDeduction_09_12())   prtItem_chk( poi, Line +   9, Column, dto.getPayDeduction_09_12()); 	// ^T09_12
		if( null != dto.getPayDeduction_10_12())   prtItem_chk( poi, Line +  10, Column, dto.getPayDeduction_10_12()); 	// ^T10_12
		if( null != dto.getPayDeduction_11_12())   prtItem_chk( poi, Line +  11, Column, dto.getPayDeduction_11_12()); 	// ^T11_12
		if( null != dto.getPayDeduction_12_12())   prtItem_chk( poi, Line +  12, Column, dto.getPayDeduction_12_12()); 	// ^T12_12
		if( null != dto.getPayDeduction_14_12())   prtItem_chk( poi, Line +  13, Column, dto.getPayDeduction_14_12()); 	// ^T14_12
		if( null != dto.getPayDeduction_15_12())   prtItem_chk( poi, Line +  14, Column, dto.getPayDeduction_15_12()); 	// ^T15_12
		if( null != dto.getPayDeduction_16_12())   prtItem_chk( poi, Line +  15, Column, dto.getPayDeduction_16_12()); 	// ^T16_12
		if( null != dto.getPayDeduction_17_12())   prtItem_chk( poi, Line +  16, Column, dto.getPayDeduction_17_12()); 	// ^T17_12
		if( null != dto.getPayDeduction_18_12())   prtItem_chk( poi, Line +  17, Column, dto.getPayDeduction_18_12()); 	// ^T18_12
		if( null != dto.getPayDeduction_19_12())   prtItem_chk( poi, Line +  18, Column, dto.getPayDeduction_19_12()); 	// ^T19_12
		if( null != dto.getPayDeduction_20_12())   prtItem_chk( poi, Line +  19, Column, dto.getPayDeduction_20_12()); 	// ^T20_12
		if( null != dto.getPayDeduction_21_12())   prtItem_chk( poi, Line +  20, Column, dto.getPayDeduction_21_12()); 	// ^T21_12
		if( null != dto.getPayDeduction_22_12())   prtItem_chk( poi, Line +  21, Column, dto.getPayDeduction_22_12()); 	// ^T22_12
		if( null != dto.getPayDeduction_23_12())   prtItem_chk( poi, Line +  22, Column, dto.getPayDeduction_23_12()); 	// ^T23_12
		if( null != dto.getPayDeduction_24_12())   prtItem_chk( poi, Line +  23, Column, dto.getPayDeduction_24_12()); 	// ^T24_12
		if( null != dto.getPayDeduction_25_12())   prtItem_chk( poi, Line +  24, Column, dto.getPayDeduction_25_12()); 	// ^T25_12
		if( null != dto.getPayDeductionTotal_12()) prtItem_chk( poi, Line +  25, Column, dto.getPayDeductionTotal_12()); // ^Tz_12
		if( null != dto.getPayDeduction_26_12())   prtItem_chk( poi, Line +  26, Column, dto.getPayDeduction_26_12()); 	// ^T26_12
		if( null != dto.getPayPaymentTotal_12())   prtItem_chk( poi, Line +  27, Column, dto.getPayPaymentTotal_12()); 	// ^xz_12
		if( null != dto.getPayBank1PayAmount_12()) prtItem_chk( poi, Line +  28, Column, dto.getPayBank1PayAmount_12()); // ^s1Uz_12
		if( null != dto.getPayBank2PayAmount_12()) prtItem_chk( poi, Line +  29, Column, dto.getPayBank2PayAmount_12()); // ^s2Uz_12
		if( null != dto.getPayCashPayAmount_12())  prtItem_chk( poi, Line +  30, Column, dto.getPayCashPayAmount_12());	// xz_12
		if( null != dto.getPayDeduction_27_12())   prtItem_chk( poi, Line +  31, Column, dto.getPayDeduction_27_12()); 	// ^T27_12
		
		Line   =  8;
		Column =  39; // Nԍv
		if( null != dto.getPayTotalAllowance_01())   prtItem_chk( poi, Line +   1, Column, dto.getPayTotalAllowance_01()); 	// ^x01v
		if( null != dto.getPayTotalAllowance_02())   prtItem_chk( poi, Line +   2, Column, dto.getPayTotalAllowance_02()); 	// ^x02v
		if( null != dto.getPayTotalAllowance_03())   prtItem_chk( poi, Line +   3, Column, dto.getPayTotalAllowance_03()); 	// ^x03v
		if( null != dto.getPayTotalAllowance_04())   prtItem_chk( poi, Line +   4, Column, dto.getPayTotalAllowance_04()); 	// ^x04v
		if( null != dto.getPayTotalAllowance_05())   prtItem_chk( poi, Line +   5, Column, dto.getPayTotalAllowance_05()); 	// ^x05v
		if( null != dto.getPayTotalAllowance_06())   prtItem_chk( poi, Line +   6, Column, dto.getPayTotalAllowance_06()); 	// ^x06v
		if( null != dto.getPayTotalAllowance_07())   prtItem_chk( poi, Line +   7, Column, dto.getPayTotalAllowance_07()); 	// ^x07v
		if( null != dto.getPayTotalAllowance_08())   prtItem_chk( poi, Line +   8, Column, dto.getPayTotalAllowance_08()); 	// ^x08v
		if( null != dto.getPayTotalAllowance_09())   prtItem_chk( poi, Line +   9, Column, dto.getPayTotalAllowance_09()); 	// ^x09v
		if( null != dto.getPayTotalAllowance_10())   prtItem_chk( poi, Line +  10, Column, dto.getPayTotalAllowance_10()); 	// ^x10v
		if( null != dto.getPayTotalAllowance_11())   prtItem_chk( poi, Line +  11, Column, dto.getPayTotalAllowance_11()); 	// ^x11v
		if( null != dto.getPayTotalAllowance_12())   prtItem_chk( poi, Line +  12, Column, dto.getPayTotalAllowance_12()); 	// ^x12v
		if( null != dto.getPayTotalAllowance_13())   prtItem_chk( poi, Line +  13, Column, dto.getPayTotalAllowance_13()); 	// ^x13v
		if( null != dto.getPayTotalAllowance_14())   prtItem_chk( poi, Line +  14, Column, dto.getPayTotalAllowance_14()); 	// ^x14v
		if( null != dto.getPayTotalAllowance_15())   prtItem_chk( poi, Line +  15, Column, dto.getPayTotalAllowance_15()); 	// ^x15v
		if( null != dto.getPayTotalAllowance_16())   prtItem_chk( poi, Line +  16, Column, dto.getPayTotalAllowance_16()); 	// ^x16v
		if( null != dto.getPayTotalAllowance_17())   prtItem_chk( poi, Line +  17, Column, dto.getPayTotalAllowance_17()); 	// ^x17v
		if( null != dto.getPayTotalAllowance_18())   prtItem_chk( poi, Line +  18, Column, dto.getPayTotalAllowance_18()); 	// ^x18v
		if( null != dto.getPayTotalAllowance_19())   prtItem_chk( poi, Line +  19, Column, dto.getPayTotalAllowance_19()); 	// ^x19v
		if( null != dto.getPayTotalAllowance_20())   prtItem_chk( poi, Line +  20, Column, dto.getPayTotalAllowance_20()); 	// ^x20v
		if( null != dto.getPayTotalAllowance_21())   prtItem_chk( poi, Line +  21, Column, dto.getPayTotalAllowance_21()); 	// ^x21v
		if( null != dto.getPayTotalAllowance_22())   prtItem_chk( poi, Line +  22, Column, dto.getPayTotalAllowance_22()); 	// ^x22v
		if( null != dto.getPayTotalAllowance_23())   prtItem_chk( poi, Line +  23, Column, dto.getPayTotalAllowance_23()); 	// ^x23v
		if( null != dto.getPayTotalAllowance_24())   prtItem_chk( poi, Line +  24, Column, dto.getPayTotalAllowance_24()); 	// ^x24v
		if( null != dto.getPayTotalAllowance_25())   prtItem_chk( poi, Line +  25, Column, dto.getPayTotalAllowance_25()); 	// ^x25v
		if( null != dto.getPayTotalAllowance_26())   prtItem_chk( poi, Line +  26, Column, dto.getPayTotalAllowance_26()); 	// ^x26v
		if( null != dto.getPayTotalAllowance_27())   prtItem_chk( poi, Line +  27, Column, dto.getPayTotalAllowance_27()); 	// ^x27v
		if( null != dto.getPayTotalAllowance_28())   prtItem_chk( poi, Line +  28, Column, dto.getPayTotalAllowance_28()); 	// ^x28v
		if( null != dto.getPayTotalAllowance_29())   prtItem_chk( poi, Line +  29, Column, dto.getPayTotalAllowance_29()); 	// ^x29v
		if( null != dto.getPayTotalAllowance_30())   prtItem_chk( poi, Line +  30, Column, dto.getPayTotalAllowance_30()); 	// ^x30v
		if( null != dto.getPayTotalAllowanceTotal()) prtItem_chk( poi, Line +  31, Column, dto.getPayTotalAllowanceTotal()); // ^xzv
		Line   =  40;
		if( null != dto.getPayTotalDeduction_01())   prtItem_chk( poi, Line +   1, Column, dto.getPayTotalDeduction_01()); 	// ^T01v
		if( null != dto.getPayTotalDeduction_02())   prtItem_chk( poi, Line +   2, Column, dto.getPayTotalDeduction_02()); 	// ^T02v
		if( null != dto.getPayTotalDeduction_03())   prtItem_chk( poi, Line +   3, Column, dto.getPayTotalDeduction_03()); 	// ^T03v
		if( null != dto.getPayTotalDeduction_04())   prtItem_chk( poi, Line +   4, Column, dto.getPayTotalDeduction_04()); 	// ^T04v
		if( null != dto.getPayTotalDeduction_05())   prtItem_chk( poi, Line +   5, Column, dto.getPayTotalDeduction_05()); 	// ^T05v
		if( null != dto.getPayTotalDeduction_06())   prtItem_chk( poi, Line +   6, Column, dto.getPayTotalDeduction_06()); 	// ^T06v
		if( null != dto.getPayTotalDeduction_07())   prtItem_chk( poi, Line +   7, Column, dto.getPayTotalDeduction_07()); 	// ^T07v
		if( null != dto.getPayTotalDeduction_08())   prtItem_chk( poi, Line +   8, Column, dto.getPayTotalDeduction_08()); 	// ^T08v
		if( null != dto.getPayTotalDeduction_09())   prtItem_chk( poi, Line +   9, Column, dto.getPayTotalDeduction_09()); 	// ^T09v
		if( null != dto.getPayTotalDeduction_10())   prtItem_chk( poi, Line +  10, Column, dto.getPayTotalDeduction_10()); 	// ^T10v
		if( null != dto.getPayTotalDeduction_11())   prtItem_chk( poi, Line +  11, Column, dto.getPayTotalDeduction_11()); 	// ^T11v
		if( null != dto.getPayTotalDeduction_12())   prtItem_chk( poi, Line +  12, Column, dto.getPayTotalDeduction_12()); 	// ^T12v
		if( null != dto.getPayTotalDeduction_14())   prtItem_chk( poi, Line +  13, Column, dto.getPayTotalDeduction_14()); 	// ^T14v
		if( null != dto.getPayTotalDeduction_15())   prtItem_chk( poi, Line +  14, Column, dto.getPayTotalDeduction_15()); 	// ^T15v
		if( null != dto.getPayTotalDeduction_16())   prtItem_chk( poi, Line +  15, Column, dto.getPayTotalDeduction_16()); 	// ^T16v
		if( null != dto.getPayTotalDeduction_17())   prtItem_chk( poi, Line +  16, Column, dto.getPayTotalDeduction_17()); 	// ^T17v
		if( null != dto.getPayTotalDeduction_18())   prtItem_chk( poi, Line +  17, Column, dto.getPayTotalDeduction_18()); 	// ^T18v
		if( null != dto.getPayTotalDeduction_19())   prtItem_chk( poi, Line +  18, Column, dto.getPayTotalDeduction_19()); 	// ^T19v
		if( null != dto.getPayTotalDeduction_20())   prtItem_chk( poi, Line +  19, Column, dto.getPayTotalDeduction_20()); 	// ^T20v
		if( null != dto.getPayTotalDeduction_21())   prtItem_chk( poi, Line +  20, Column, dto.getPayTotalDeduction_21()); 	// ^T21v
		if( null != dto.getPayTotalDeduction_22())   prtItem_chk( poi, Line +  21, Column, dto.getPayTotalDeduction_22()); 	// ^T22v
		if( null != dto.getPayTotalDeduction_23())   prtItem_chk( poi, Line +  22, Column, dto.getPayTotalDeduction_23()); 	// ^T23v
		if( null != dto.getPayTotalDeduction_24())   prtItem_chk( poi, Line +  23, Column, dto.getPayTotalDeduction_24()); 	// ^T24v
		if( null != dto.getPayTotalDeduction_25())   prtItem_chk( poi, Line +  24, Column, dto.getPayTotalDeduction_25()); 	// ^T25v
		if( null != dto.getPayTotalDeductionTotal()) prtItem_chk( poi, Line +  25, Column, dto.getPayTotalDeductionTotal()); // ^Tzv
		if( null != dto.getPayTotalDeduction_26())   prtItem_chk( poi, Line +  26, Column, dto.getPayTotalDeduction_26()); 	// ^T26v
		if( null != dto.getPayTotalPaymentTotal())   prtItem_chk( poi, Line +  27, Column, dto.getPayTotalPaymentTotal()); 	// ^xzv
		if( null != dto.getPayTotalBank1PayAmount()) prtItem_chk( poi, Line +  28, Column, dto.getPayTotalBank1PayAmount()); // ^s1Uzv
		if( null != dto.getPayTotalBank2PayAmount()) prtItem_chk( poi, Line +  29, Column, dto.getPayTotalBank2PayAmount()); // ^s2Uzv
		if( null != dto.getPayTotalCashPayAmount())  prtItem_chk( poi, Line +  30, Column, dto.getPayTotalCashPayAmount());	// xzv
		if( null != dto.getPayTotalDeduction_27())   prtItem_chk( poi, Line +  31, Column, dto.getPayTotalDeduction_27()); 	// ^T27v
		
		/** ΑӍڏo **/
		// ږo
		Line   =  80;
		Column =  0;
		prtItem_chk( poi, Line +   1, Column +  0, dto.getTitleAttendance_01());		// ΑӍ01^Cg
		prtItem_chk( poi, Line +   2, Column +  0, dto.getTitleAttendance_02());		// ΑӍ02^Cg
		prtItem_chk( poi, Line +   3, Column +  0, dto.getTitleAttendance_03());		// ΑӍ03^Cg
		prtItem_chk( poi, Line +   4, Column +  0, dto.getTitleAttendance_04());		// ΑӍ04^Cg
		prtItem_chk( poi, Line +   5, Column +  0, dto.getTitleAttendance_05());		// ΑӍ05^Cg
		prtItem_chk( poi, Line +   6, Column +  0, dto.getTitleAttendance_06());		// ΑӍ06^Cg
		prtItem_chk( poi, Line +   7, Column +  0, dto.getTitleAttendance_07());		// ΑӍ07^Cg
		prtItem_chk( poi, Line +   8, Column +  0, dto.getTitleAttendance_08());		// ΑӍ08^Cg
		prtItem_chk( poi, Line +   9, Column +  0, dto.getTitleAttendance_09());		// ΑӍ09^Cg
		prtItem_chk( poi, Line +  10, Column +  0, dto.getTitleAttendance_10());		// ΑӍ10^Cg

		// ΑӖ׏o
		Line   =  80;
		Column =  3; // 1
		if( null != dto.getPayPayday_01())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_01());	 		// ^x_01
		if( null != dto.getAttendance_01_01()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_01()); 	// ΑӍ01_01
		if( null != dto.getAttendance_02_01()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_01()); 	// ΑӍ02_01
		if( null != dto.getAttendance_03_01()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_01()); 	// ΑӍ03_01
		if( null != dto.getAttendance_04_01()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_01()); 	// ΑӍ04_01
		if( null != dto.getAttendance_05_01()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_01()); 	// ΑӍ05_01
		if( null != dto.getAttendance_06_01()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_01()); 	// ΑӍ06_01
		if( null != dto.getAttendance_07_01()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_01()); 	// ΑӍ07_01
		if( null != dto.getAttendance_08_01()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_01()); 	// ΑӍ08_01
		if( null != dto.getAttendance_09_01()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_01()); 	// ΑӍ09_01
		if( null != dto.getAttendance_10_01()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_01()); 	// ΑӍ00_01
		if( null != dto.getAttendance_11_01()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_01()); 	// ΑӍ01_01
		if( null != dto.getAttendance_12_01()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_01()); 	// ΑӍ02_01
		if( null != dto.getAttendance_13_01()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_01()); 	// ΑӍ03_01
		if( null != dto.getAttendance_14_01()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_01()); 	// ΑӍ04_01

		Line   =  80;
		Column =  6; // 2
		if( null != dto.getPayPayday_02())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_02());	 		// ^x_02
		if( null != dto.getAttendance_01_02()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_02()); 	// ΑӍ01_02
		if( null != dto.getAttendance_02_02()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_02()); 	// ΑӍ02_02
		if( null != dto.getAttendance_03_02()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_02()); 	// ΑӍ03_02
		if( null != dto.getAttendance_04_02()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_02()); 	// ΑӍ04_02
		if( null != dto.getAttendance_05_02()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_02()); 	// ΑӍ05_02
		if( null != dto.getAttendance_06_02()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_02()); 	// ΑӍ06_02
		if( null != dto.getAttendance_07_02()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_02()); 	// ΑӍ07_02
		if( null != dto.getAttendance_08_02()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_02()); 	// ΑӍ08_02
		if( null != dto.getAttendance_09_02()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_02()); 	// ΑӍ09_02
		if( null != dto.getAttendance_10_02()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_02()); 	// ΑӍ00_02
		if( null != dto.getAttendance_11_02()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_02()); 	// ΑӍ01_02
		if( null != dto.getAttendance_12_02()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_02()); 	// ΑӍ02_02
		if( null != dto.getAttendance_13_02()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_02()); 	// ΑӍ03_02
		if( null != dto.getAttendance_14_02()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_02()); 	// ΑӍ04_02

		Line   =  80;
		Column =  9; // 3
		if( null != dto.getPayPayday_03())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_03());	 		// ^x_03
		if( null != dto.getAttendance_01_03()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_03()); 	// ΑӍ01_03
		if( null != dto.getAttendance_02_03()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_03()); 	// ΑӍ02_03
		if( null != dto.getAttendance_03_03()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_03()); 	// ΑӍ03_03
		if( null != dto.getAttendance_04_03()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_03()); 	// ΑӍ04_03
		if( null != dto.getAttendance_05_03()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_03()); 	// ΑӍ05_03
		if( null != dto.getAttendance_06_03()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_03()); 	// ΑӍ06_03
		if( null != dto.getAttendance_07_03()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_03()); 	// ΑӍ07_03
		if( null != dto.getAttendance_08_03()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_03()); 	// ΑӍ08_03
		if( null != dto.getAttendance_09_03()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_03()); 	// ΑӍ09_03
		if( null != dto.getAttendance_10_03()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_03()); 	// ΑӍ00_03
		if( null != dto.getAttendance_11_03()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_03()); 	// ΑӍ01_03
		if( null != dto.getAttendance_12_03()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_03()); 	// ΑӍ02_03
		if( null != dto.getAttendance_13_03()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_03()); 	// ΑӍ03_03
		if( null != dto.getAttendance_14_03()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_03()); 	// ΑӍ04_03


		Line   =  80;
		Column =  12; // 4
		if( null != dto.getPayPayday_04())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_04());	 		// ^x_04
		if( null != dto.getAttendance_01_04()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_04()); 	// ΑӍ01_04
		if( null != dto.getAttendance_02_04()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_04()); 	// ΑӍ02_04
		if( null != dto.getAttendance_03_04()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_04()); 	// ΑӍ03_04
		if( null != dto.getAttendance_04_04()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_04()); 	// ΑӍ04_04
		if( null != dto.getAttendance_05_04()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_04()); 	// ΑӍ05_04
		if( null != dto.getAttendance_06_04()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_04()); 	// ΑӍ06_04
		if( null != dto.getAttendance_07_04()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_04()); 	// ΑӍ07_04
		if( null != dto.getAttendance_08_04()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_04()); 	// ΑӍ08_04
		if( null != dto.getAttendance_09_04()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_04()); 	// ΑӍ09_04
		if( null != dto.getAttendance_10_04()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_04()); 	// ΑӍ00_04
		if( null != dto.getAttendance_11_04()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_04()); 	// ΑӍ01_04
		if( null != dto.getAttendance_12_04()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_04()); 	// ΑӍ02_04
		if( null != dto.getAttendance_13_04()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_04()); 	// ΑӍ03_04
		if( null != dto.getAttendance_14_04()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_04()); 	// ΑӍ04_04

		Line   =  80;
		Column =  15; // 5
		if( null != dto.getPayPayday_05())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_05());	 		// ^x_05
		if( null != dto.getAttendance_01_05()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_05()); 	// ΑӍ01_05
		if( null != dto.getAttendance_02_05()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_05()); 	// ΑӍ02_05
		if( null != dto.getAttendance_03_05()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_05()); 	// ΑӍ03_05
		if( null != dto.getAttendance_04_05()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_05()); 	// ΑӍ04_05
		if( null != dto.getAttendance_05_05()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_05()); 	// ΑӍ05_05
		if( null != dto.getAttendance_06_05()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_05()); 	// ΑӍ06_05
		if( null != dto.getAttendance_07_05()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_05()); 	// ΑӍ07_05
		if( null != dto.getAttendance_08_05()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_05()); 	// ΑӍ08_05
		if( null != dto.getAttendance_09_05()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_05()); 	// ΑӍ09_05
		if( null != dto.getAttendance_10_05()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_05()); 	// ΑӍ00_05
		if( null != dto.getAttendance_11_05()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_05()); 	// ΑӍ01_05
		if( null != dto.getAttendance_12_05()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_05()); 	// ΑӍ02_05
		if( null != dto.getAttendance_13_05()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_05()); 	// ΑӍ03_05
		if( null != dto.getAttendance_14_05()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_05()); 	// ΑӍ04_05

		Line   =  80;
		Column =  18; // 6
		if( null != dto.getPayPayday_06())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_06());	 		// ^x_06
		if( null != dto.getAttendance_01_06()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_06()); 	// ΑӍ01_06
		if( null != dto.getAttendance_02_06()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_06()); 	// ΑӍ02_06
		if( null != dto.getAttendance_03_06()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_06()); 	// ΑӍ03_06
		if( null != dto.getAttendance_04_06()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_06()); 	// ΑӍ04_06
		if( null != dto.getAttendance_05_06()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_06()); 	// ΑӍ05_06
		if( null != dto.getAttendance_06_06()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_06()); 	// ΑӍ06_06
		if( null != dto.getAttendance_07_06()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_06()); 	// ΑӍ07_06
		if( null != dto.getAttendance_08_06()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_06()); 	// ΑӍ08_06
		if( null != dto.getAttendance_09_06()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_06()); 	// ΑӍ09_06
		if( null != dto.getAttendance_10_06()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_06()); 	// ΑӍ00_06
		if( null != dto.getAttendance_11_06()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_06()); 	// ΑӍ01_06
		if( null != dto.getAttendance_12_06()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_06()); 	// ΑӍ02_06
		if( null != dto.getAttendance_13_06()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_06()); 	// ΑӍ03_06
		if( null != dto.getAttendance_14_06()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_06()); 	// ΑӍ04_06

		Line   =  80;
		Column =  21; // 7
		if( null != dto.getPayPayday_07())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_07());	 		// ^x_07
		if( null != dto.getAttendance_01_07()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_07()); 	// ΑӍ01_07
		if( null != dto.getAttendance_02_07()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_07()); 	// ΑӍ02_07
		if( null != dto.getAttendance_03_07()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_07()); 	// ΑӍ03_07
		if( null != dto.getAttendance_04_07()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_07()); 	// ΑӍ04_07
		if( null != dto.getAttendance_05_07()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_07()); 	// ΑӍ05_07
		if( null != dto.getAttendance_06_07()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_07()); 	// ΑӍ06_07
		if( null != dto.getAttendance_07_07()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_07()); 	// ΑӍ07_07
		if( null != dto.getAttendance_08_07()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_07()); 	// ΑӍ08_07
		if( null != dto.getAttendance_09_07()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_07()); 	// ΑӍ09_07
		if( null != dto.getAttendance_10_07()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_07()); 	// ΑӍ00_07
		if( null != dto.getAttendance_11_07()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_07()); 	// ΑӍ01_07
		if( null != dto.getAttendance_12_07()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_07()); 	// ΑӍ02_07
		if( null != dto.getAttendance_13_07()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_07()); 	// ΑӍ03_07
		if( null != dto.getAttendance_14_07()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_07()); 	// ΑӍ04_07

		Line   =  80;
		Column =  24; // 8
		if( null != dto.getPayPayday_08())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_08());	 		// ^x_08
		if( null != dto.getAttendance_01_08()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_08()); 	// ΑӍ01_08
		if( null != dto.getAttendance_02_08()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_08()); 	// ΑӍ02_08
		if( null != dto.getAttendance_03_08()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_08()); 	// ΑӍ03_08
		if( null != dto.getAttendance_04_08()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_08()); 	// ΑӍ04_08
		if( null != dto.getAttendance_05_08()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_08()); 	// ΑӍ05_08
		if( null != dto.getAttendance_06_08()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_08()); 	// ΑӍ06_08
		if( null != dto.getAttendance_07_08()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_08()); 	// ΑӍ07_08
		if( null != dto.getAttendance_08_08()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_08()); 	// ΑӍ08_08
		if( null != dto.getAttendance_09_08()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_08()); 	// ΑӍ09_08
		if( null != dto.getAttendance_10_08()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_08()); 	// ΑӍ00_08
		if( null != dto.getAttendance_11_08()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_08()); 	// ΑӍ01_08
		if( null != dto.getAttendance_12_08()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_08()); 	// ΑӍ02_08
		if( null != dto.getAttendance_13_08()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_08()); 	// ΑӍ03_08
		if( null != dto.getAttendance_14_08()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_08()); 	// ΑӍ04_08

		Line   =  80;
		Column =  27; // 9
		if( null != dto.getPayPayday_09())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_09());	 		// ^x_09
		if( null != dto.getAttendance_01_09()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_09()); 	// ΑӍ01_09
		if( null != dto.getAttendance_02_09()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_09()); 	// ΑӍ02_09
		if( null != dto.getAttendance_03_09()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_09()); 	// ΑӍ03_09
		if( null != dto.getAttendance_04_09()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_09()); 	// ΑӍ04_09
		if( null != dto.getAttendance_05_09()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_09()); 	// ΑӍ05_09
		if( null != dto.getAttendance_06_09()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_09()); 	// ΑӍ06_09
		if( null != dto.getAttendance_07_09()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_09()); 	// ΑӍ07_09
		if( null != dto.getAttendance_08_09()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_09()); 	// ΑӍ08_09
		if( null != dto.getAttendance_09_09()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_09()); 	// ΑӍ09_09
		if( null != dto.getAttendance_10_09()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_09()); 	// ΑӍ00_09
		if( null != dto.getAttendance_11_09()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_09()); 	// ΑӍ01_09
		if( null != dto.getAttendance_12_09()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_09()); 	// ΑӍ02_09
		if( null != dto.getAttendance_13_09()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_09()); 	// ΑӍ03_09
		if( null != dto.getAttendance_14_09()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_09()); 	// ΑӍ04_09

		Line   =  80;
		Column =  30; //10
		if( null != dto.getPayPayday_10())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_10());	 		// ^x_10
		if( null != dto.getAttendance_01_10()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_10()); 	// ΑӍ01_10
		if( null != dto.getAttendance_02_10()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_10()); 	// ΑӍ02_10
		if( null != dto.getAttendance_03_10()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_10()); 	// ΑӍ03_10
		if( null != dto.getAttendance_04_10()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_10()); 	// ΑӍ04_10
		if( null != dto.getAttendance_05_10()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_10()); 	// ΑӍ05_10
		if( null != dto.getAttendance_06_10()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_10()); 	// ΑӍ06_10
		if( null != dto.getAttendance_07_10()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_10()); 	// ΑӍ07_10
		if( null != dto.getAttendance_08_10()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_10()); 	// ΑӍ08_10
		if( null != dto.getAttendance_09_10()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_10()); 	// ΑӍ09_10
		if( null != dto.getAttendance_10_10()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_10()); 	// ΑӍ00_10
		if( null != dto.getAttendance_11_10()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_10()); 	// ΑӍ01_10
		if( null != dto.getAttendance_12_10()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_10()); 	// ΑӍ02_10
		if( null != dto.getAttendance_13_10()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_10()); 	// ΑӍ03_10
		if( null != dto.getAttendance_14_10()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_10()); 	// ΑӍ04_10

		Line   =  80;
		Column =  33; // 11
		if( null != dto.getPayPayday_11())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_11());	 		// ^x_11
		if( null != dto.getAttendance_01_11()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_11()); 	// ΑӍ01_11
		if( null != dto.getAttendance_02_11()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_11()); 	// ΑӍ02_11
		if( null != dto.getAttendance_03_11()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_11()); 	// ΑӍ03_11
		if( null != dto.getAttendance_04_11()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_11()); 	// ΑӍ04_11
		if( null != dto.getAttendance_05_11()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_11()); 	// ΑӍ05_11
		if( null != dto.getAttendance_06_11()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_11()); 	// ΑӍ06_11
		if( null != dto.getAttendance_07_11()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_11()); 	// ΑӍ07_11
		if( null != dto.getAttendance_08_11()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_11()); 	// ΑӍ08_11
		if( null != dto.getAttendance_09_11()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_11()); 	// ΑӍ09_11
		if( null != dto.getAttendance_10_11()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_11()); 	// ΑӍ00_11
		if( null != dto.getAttendance_11_11()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_11()); 	// ΑӍ01_11
		if( null != dto.getAttendance_12_11()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_11()); 	// ΑӍ02_11
		if( null != dto.getAttendance_13_11()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_11()); 	// ΑӍ03_11
		if( null != dto.getAttendance_14_11()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_11()); 	// ΑӍ04_11

		Line   =  80;
		Column =  36; // 12
		if( null != dto.getPayPayday_12())     prtItem_chk( poi, Line +   0, Column, dto.getPayPayday_12());	 		// ^x_12
		if( null != dto.getAttendance_01_12()) prtItem_chk( poi, Line +   1, Column, dto.getAttendance_01_12()); 	// ΑӍ01_12
		if( null != dto.getAttendance_02_12()) prtItem_chk( poi, Line +   2, Column, dto.getAttendance_02_12()); 	// ΑӍ02_12
		if( null != dto.getAttendance_03_12()) prtItem_chk( poi, Line +   3, Column, dto.getAttendance_03_12()); 	// ΑӍ03_12
		if( null != dto.getAttendance_04_12()) prtItem_chk( poi, Line +   4, Column, dto.getAttendance_04_12()); 	// ΑӍ04_12
		if( null != dto.getAttendance_05_12()) prtItem_chk( poi, Line +   5, Column, dto.getAttendance_05_12()); 	// ΑӍ05_12
		if( null != dto.getAttendance_06_12()) prtItem_chk( poi, Line +   6, Column, dto.getAttendance_06_12()); 	// ΑӍ06_12
		if( null != dto.getAttendance_07_12()) prtItem_chk( poi, Line +   7, Column, dto.getAttendance_07_12()); 	// ΑӍ07_12
		if( null != dto.getAttendance_08_12()) prtItem_chk( poi, Line +   8, Column, dto.getAttendance_08_12()); 	// ΑӍ08_12
		if( null != dto.getAttendance_09_12()) prtItem_chk( poi, Line +   9, Column, dto.getAttendance_09_12()); 	// ΑӍ09_12
		if( null != dto.getAttendance_10_12()) prtItem_chk( poi, Line +  10, Column, dto.getAttendance_10_12()); 	// ΑӍ00_12
		if( null != dto.getAttendance_11_12()) prtItem_chk( poi, Line +  11, Column, dto.getAttendance_11_12()); 	// ΑӍ01_12
		if( null != dto.getAttendance_12_12()) prtItem_chk( poi, Line +  12, Column, dto.getAttendance_12_12()); 	// ΑӍ02_12
		if( null != dto.getAttendance_13_12()) prtItem_chk( poi, Line +  13, Column, dto.getAttendance_13_12()); 	// ΑӍ03_12
		if( null != dto.getAttendance_14_12()) prtItem_chk( poi, Line +  14, Column, dto.getAttendance_14_12()); 	// ΑӍ04_12
		
		Line   =  80;
		Column =  39; // Nԍv
		if( null != dto.getTotalAttendance_01()) prtItem_chk( poi, Line +   1, Column, dto.getTotalAttendance_01()); 	// ΑӍ01v
		if( null != dto.getTotalAttendance_02()) prtItem_chk( poi, Line +   2, Column, dto.getTotalAttendance_02()); 	// ΑӍ02v
		if( null != dto.getTotalAttendance_03()) prtItem_chk( poi, Line +   3, Column, dto.getTotalAttendance_03()); 	// ΑӍ03v
		if( null != dto.getTotalAttendance_04()) prtItem_chk( poi, Line +   4, Column, dto.getTotalAttendance_04()); 	// ΑӍ04v
		if( null != dto.getTotalAttendance_05()) prtItem_chk( poi, Line +   5, Column, dto.getTotalAttendance_05()); 	// ΑӍ05v
		if( null != dto.getTotalAttendance_06()) prtItem_chk( poi, Line +   6, Column, dto.getTotalAttendance_06()); 	// ΑӍ06v
		if( null != dto.getTotalAttendance_07()) prtItem_chk( poi, Line +   7, Column, dto.getTotalAttendance_07()); 	// ΑӍ07v
		if( null != dto.getTotalAttendance_08()) prtItem_chk( poi, Line +   8, Column, dto.getTotalAttendance_08()); 	// ΑӍ08v
		if( null != dto.getTotalAttendance_09()) prtItem_chk( poi, Line +   9, Column, dto.getTotalAttendance_09()); 	// ΑӍ09v
		if( null != dto.getTotalAttendance_10()) prtItem_chk( poi, Line +  10, Column, dto.getTotalAttendance_10()); 	// ΑӍ00v
		if( null != dto.getTotalAttendance_11()) prtItem_chk( poi, Line +  11, Column, dto.getTotalAttendance_11()); 	// ΑӍ01v
		if( null != dto.getTotalAttendance_12()) prtItem_chk( poi, Line +  12, Column, dto.getTotalAttendance_12()); 	// ΑӍ02v
		if( null != dto.getTotalAttendance_13()) prtItem_chk( poi, Line +  13, Column, dto.getTotalAttendance_13()); 	// ΑӍ03v
		if( null != dto.getTotalAttendance_14()) prtItem_chk( poi, Line +  14, Column, dto.getTotalAttendance_14()); 	// ΑӍ04v
		
		/** ܗ^ڏo **/
		// ږo
		Line   =  98;
		Column =  0;
		prtItem_chk( poi, Line +   0, Column +  0, dto.getTitleAllowanceItem());		// xږ^Cg
		prtItem_chk( poi, Line +   1, Column +  0, dto.getTitleBonAllowance_01());	// ܗ^x01^Cg
		prtItem_chk( poi, Line +   2, Column +  0, dto.getTitleBonAllowance_02());	// ܗ^x02^Cg
		prtItem_chk( poi, Line +   3, Column +  0, dto.getTitleBonAllowance_03());	// ܗ^x03^Cg
		prtItem_chk( poi, Line +   4, Column +  0, dto.getTitleBonAllowance_04());	// ܗ^x04^Cg
		prtItem_chk( poi, Line +   5, Column +  0, dto.getTitleBonAllowance_05());	// ܗ^x05^Cg
		prtItem_chk( poi, Line +   6, Column +  0, dto.getTitleBonAllowance_06());	// ܗ^x06^Cg
		prtItem_chk( poi, Line +   7, Column +  0, dto.getTitleBonAllowance_07());	// ܗ^x07^Cg
		prtItem_chk( poi, Line +   8, Column +  0, dto.getTitleBonAllowance_08());	// ܗ^x08^Cg
		prtItem_chk( poi, Line +   9, Column +  0, dto.getTitleBonAllowance_09());	// ܗ^x09^Cg
		prtItem_chk( poi, Line +  10, Column +  0, dto.getTitleBonAllowance_10());	// ܗ^x10^Cg
		prtItem_chk( poi, Line +  11, Column +  0, dto.getTitleAllowanceTotal());	// xz^Cg		
		prtItem_chk( poi, Line +  12, Column +  0, "" + dto.getTitleDeductionItem() + "");	// Tڃ^Cg  
		prtItem_chk( poi, Line +  13, Column +  0, dto.getTitleBonDeduction_01());	// ܗ^T01^Cg
		prtItem_chk( poi, Line +  14, Column +  0, dto.getTitleBonDeduction_02());	// ܗ^T02^Cg
		prtItem_chk( poi, Line +  15, Column +  0, dto.getTitleBonDeduction_03());	// ܗ^T03^Cg
		prtItem_chk( poi, Line +  16, Column +  0, dto.getTitleBonDeduction_04());	// ܗ^T04^Cg
		prtItem_chk( poi, Line +  17, Column +  0, dto.getTitleBonDeduction_05());	// ܗ^T05^Cg
		prtItem_chk( poi, Line +  18, Column +  0, dto.getTitleBonDeduction_06());	// ܗ^T06^Cg
		prtItem_chk( poi, Line +  19, Column +  0, dto.getTitleBonDeduction_07());	// ܗ^T07^Cg
		prtItem_chk( poi, Line +  20, Column +  0, dto.getTitleBonDeduction_08());	// ܗ^T08^Cg
		prtItem_chk( poi, Line +  21, Column +  0, dto.getTitleBonDeduction_09());	// ܗ^T09^Cg
		prtItem_chk( poi, Line +  22, Column +  0, dto.getTitleBonDeduction_10());	// ܗ^T10^Cg
		prtItem_chk( poi, Line +  23, Column +  0, dto.getTitleBonDeduction_11());	// ܗ^T11^Cg
		prtItem_chk( poi, Line +  24, Column +  0, dto.getTitleBonDeduction_12());	// ܗ^T12^Cg
		prtItem_chk( poi, Line +  25, Column +  0, dto.getTitleBonDeduction_14());	// ܗ^T14^Cg
		prtItem_chk( poi, Line +  26, Column +  0, dto.getTitleBonDeduction_15());	// ܗ^T15^Cg
		prtItem_chk( poi, Line +  27, Column +  0, dto.getTitleBonDeduction_16());	// ܗ^T16^Cg
		prtItem_chk( poi, Line +  28, Column +  0, dto.getTitleDeductionTotal());    // Tz^Cg
		prtItem_chk( poi, Line +  29, Column +  0, dto.getTitlePaymentTotal());		// xz^Cg
		prtItem_chk( poi, Line +  30, Column +  0, dto.getTitleBank1PayAmount());	// s1Uz
		prtItem_chk( poi, Line +  31, Column +  0, dto.getTitleBank2PayAmount());	// s2Uz
		prtItem_chk( poi, Line +  32, Column +  0, dto.getTitleCashPayAmount());		// xz
		prtItem_chk( poi, Line +  33, Column +  0, dto.getTitleBonDeduction_17());	// ܗ^T17^Cg

		// ܗ^x׏o
		Line   = 97;
		Column =  3; // 1
		if( null != dto.getBonPayday_01())       prtItem_chk( poi,   Line +   0, Column, dto.getBonPayday_01());	 		// ܗ^x_01
		if( null != dto.getBonAllowance_01_01()) prtItem_chk( poi,   Line +   1, Column, dto.getBonAllowance_01_01()); 	// ܗ^x01_01
		if( null != dto.getBonAllowance_02_01()) prtItem_chk( poi,   Line +   2, Column, dto.getBonAllowance_02_01()); 	// ܗ^x02_01
		if( null != dto.getBonAllowance_03_01()) prtItem_chk( poi,   Line +   3, Column, dto.getBonAllowance_03_01()); 	// ܗ^x03_01
		if( null != dto.getBonAllowance_04_01()) prtItem_chk( poi,   Line +   4, Column, dto.getBonAllowance_04_01()); 	// ܗ^x04_01
		if( null != dto.getBonAllowance_05_01()) prtItem_chk( poi,   Line +   5, Column, dto.getBonAllowance_05_01()); 	// ܗ^x05_01
		if( null != dto.getBonAllowance_06_01()) prtItem_chk( poi,   Line +   6, Column, dto.getBonAllowance_06_01()); 	// ܗ^x06_01
		if( null != dto.getBonAllowance_07_01()) prtItem_chk( poi,   Line +   7, Column, dto.getBonAllowance_07_01()); 	// ܗ^x07_01
		if( null != dto.getBonAllowance_08_01()) prtItem_chk( poi,   Line +   8, Column, dto.getBonAllowance_08_01()); 	// ܗ^x08_01
		if( null != dto.getBonAllowance_09_01()) prtItem_chk( poi,   Line +   9, Column, dto.getBonAllowance_09_01()); 	// ܗ^x09_01
		if( null != dto.getBonAllowance_10_01()) prtItem_chk( poi,   Line +  10, Column, dto.getBonAllowance_10_01()); 	// ܗ^x10_01
		if( null != dto. getBonAllowanceTotal_01()) prtItem_chk( poi,   Line +  11, Column, dto. getBonAllowanceTotal_01()); 	// ܗ^x1ڌv

		Line   = 97;
		Column =  6; // 2
		if( null != dto.getBonPayday_02())       prtItem_chk( poi,   Line +   0, Column, dto.getBonPayday_02());	 		// ܗ^x_02
		if( null != dto.getBonAllowance_01_02()) prtItem_chk( poi,   Line +   1, Column, dto.getBonAllowance_01_02()); 	// ܗ^x01_02
		if( null != dto.getBonAllowance_02_02()) prtItem_chk( poi,   Line +   2, Column, dto.getBonAllowance_02_02()); 	// ܗ^x02_02
		if( null != dto.getBonAllowance_03_02()) prtItem_chk( poi,   Line +   3, Column, dto.getBonAllowance_03_02()); 	// ܗ^x03_02
		if( null != dto.getBonAllowance_04_02()) prtItem_chk( poi,   Line +   4, Column, dto.getBonAllowance_04_02()); 	// ܗ^x04_02
		if( null != dto.getBonAllowance_05_02()) prtItem_chk( poi,   Line +   5, Column, dto.getBonAllowance_05_02()); 	// ܗ^x05_02
		if( null != dto.getBonAllowance_06_02()) prtItem_chk( poi,   Line +   6, Column, dto.getBonAllowance_06_02()); 	// ܗ^x06_02
		if( null != dto.getBonAllowance_07_02()) prtItem_chk( poi,   Line +   7, Column, dto.getBonAllowance_07_02()); 	// ܗ^x07_02
		if( null != dto.getBonAllowance_08_02()) prtItem_chk( poi,   Line +   8, Column, dto.getBonAllowance_08_02()); 	// ܗ^x08_02
		if( null != dto.getBonAllowance_09_02()) prtItem_chk( poi,   Line +   9, Column, dto.getBonAllowance_09_02()); 	// ܗ^x09_02
		if( null != dto.getBonAllowance_10_02()) prtItem_chk( poi,   Line +  10, Column, dto.getBonAllowance_10_02()); 	// ܗ^x10_02
		if( null != dto. getBonAllowanceTotal_02()) prtItem_chk( poi,   Line +  11, Column, dto. getBonAllowanceTotal_02()); 	// ܗ^x2ڌv

		
		Line   = 97;
		Column =  9; // 3
		if( null != dto.getBonPayday_03())       prtItem_chk( poi,   Line +   0, Column, dto.getBonPayday_03());			// ܗ^x_03
		if( null != dto.getBonAllowance_01_03()) prtItem_chk( poi,   Line +   1, Column, dto.getBonAllowance_01_03()); 	// ܗ^x01_03
		if( null != dto.getBonAllowance_02_03()) prtItem_chk( poi,   Line +   2, Column, dto.getBonAllowance_02_03()); 	// ܗ^x02_03
		if( null != dto.getBonAllowance_03_03()) prtItem_chk( poi,   Line +   3, Column, dto.getBonAllowance_03_03()); 	// ܗ^x03_03
		if( null != dto.getBonAllowance_04_03()) prtItem_chk( poi,   Line +   4, Column, dto.getBonAllowance_04_03()); 	// ܗ^x04_03
		if( null != dto.getBonAllowance_05_03()) prtItem_chk( poi,   Line +   5, Column, dto.getBonAllowance_05_03()); 	// ܗ^x05_03
		if( null != dto.getBonAllowance_06_03()) prtItem_chk( poi,   Line +   6, Column, dto.getBonAllowance_06_03()); 	// ܗ^x06_03
		if( null != dto.getBonAllowance_07_03()) prtItem_chk( poi,   Line +   7, Column, dto.getBonAllowance_07_03()); 	// ܗ^x07_03
		if( null != dto.getBonAllowance_08_03()) prtItem_chk( poi,   Line +   8, Column, dto.getBonAllowance_08_03()); 	// ܗ^x08_03
		if( null != dto.getBonAllowance_09_03()) prtItem_chk( poi,   Line +   9, Column, dto.getBonAllowance_09_03()); 	// ܗ^x09_03
		if( null != dto.getBonAllowance_10_03()) prtItem_chk( poi,   Line +  10, Column, dto.getBonAllowance_10_03()); 	// ܗ^x10_03
		if( null != dto. getBonAllowanceTotal_03()) prtItem_chk( poi,   Line +  11, Column, dto. getBonAllowanceTotal_03()); 	// ܗ^x3ڌv

		Line   = 97;
		Column = 12; // 4
		if( null != dto.getBonPayday_04())       prtItem_chk( poi,   Line +   0, Column, dto.getBonPayday_04());		 	// ܗ^x_04
		if( null != dto.getBonAllowance_01_04()) prtItem_chk( poi,   Line +   1, Column, dto.getBonAllowance_01_04()); 	// ܗ^x01_04
		if( null != dto.getBonAllowance_02_04()) prtItem_chk( poi,   Line +   2, Column, dto.getBonAllowance_02_04()); 	// ܗ^x02_04
		if( null != dto.getBonAllowance_03_04()) prtItem_chk( poi,   Line +   3, Column, dto.getBonAllowance_03_04()); 	// ܗ^x03_04
		if( null != dto.getBonAllowance_04_04()) prtItem_chk( poi,   Line +   4, Column, dto.getBonAllowance_04_04()); 	// ܗ^x04_04
		if( null != dto.getBonAllowance_05_04()) prtItem_chk( poi,   Line +   5, Column, dto.getBonAllowance_05_04()); 	// ܗ^x05_04
		if( null != dto.getBonAllowance_06_04()) prtItem_chk( poi,   Line +   6, Column, dto.getBonAllowance_06_04()); 	// ܗ^x06_04
		if( null != dto.getBonAllowance_07_04()) prtItem_chk( poi,   Line +   7, Column, dto.getBonAllowance_07_04()); 	// ܗ^x07_04
		if( null != dto.getBonAllowance_08_04()) prtItem_chk( poi,   Line +   8, Column, dto.getBonAllowance_08_04()); 	// ܗ^x08_04
		if( null != dto.getBonAllowance_09_04()) prtItem_chk( poi,   Line +   9, Column, dto.getBonAllowance_09_04()); 	// ܗ^x09_04
		if( null != dto.getBonAllowance_10_04()) prtItem_chk( poi,   Line +  10, Column, dto.getBonAllowance_10_04()); 	// ܗ^x10_04
		if( null != dto. getBonAllowanceTotal_04()) prtItem_chk( poi,   Line +  11, Column, dto. getBonAllowanceTotal_04()); 	// ܗ^x4ڌv

		
		Line   = 97;
		Column = 15; // 5
		if( null != dto.getBonPayday_05())       prtItem_chk( poi,   Line +   0, Column, dto.getBonPayday_05());	 		// ܗ^x_05
		if( null != dto.getBonAllowance_01_05()) prtItem_chk( poi,   Line +   1, Column, dto.getBonAllowance_01_05()); 	// ܗ^x01_05
		if( null != dto.getBonAllowance_02_05()) prtItem_chk( poi,   Line +   2, Column, dto.getBonAllowance_02_05()); 	// ܗ^x02_05
		if( null != dto.getBonAllowance_03_05()) prtItem_chk( poi,   Line +   3, Column, dto.getBonAllowance_03_05()); 	// ܗ^x03_05
		if( null != dto.getBonAllowance_04_05()) prtItem_chk( poi,   Line +   4, Column, dto.getBonAllowance_04_05()); 	// ܗ^x04_05
		if( null != dto.getBonAllowance_05_05()) prtItem_chk( poi,   Line +   5, Column, dto.getBonAllowance_05_05()); 	// ܗ^x05_05
		if( null != dto.getBonAllowance_06_05()) prtItem_chk( poi,   Line +   6, Column, dto.getBonAllowance_06_05()); 	// ܗ^x06_05
		if( null != dto.getBonAllowance_07_05()) prtItem_chk( poi,   Line +   7, Column, dto.getBonAllowance_07_05()); 	// ܗ^x07_05
		if( null != dto.getBonAllowance_08_05()) prtItem_chk( poi,   Line +   8, Column, dto.getBonAllowance_08_05()); 	// ܗ^x08_05
		if( null != dto.getBonAllowance_09_05()) prtItem_chk( poi,   Line +   9, Column, dto.getBonAllowance_09_05()); 	// ܗ^x09_05
		if( null != dto.getBonAllowance_10_05()) prtItem_chk( poi,   Line +  10, Column, dto.getBonAllowance_10_05()); 	// ܗ^x10_05
		if( null != dto. getBonAllowanceTotal_05()) prtItem_chk( poi,   Line +  11, Column, dto. getBonAllowanceTotal_05()); 	// ܗ^x5ڌv

		Line   = 97;
		Column = 18; // 6
		if( null != dto.getBonPayday_06())       prtItem_chk( poi,   Line +   0, Column, dto.getBonPayday_06());	 		// ܗ^x_06
		if( null != dto.getBonAllowance_01_06()) prtItem_chk( poi,   Line +   1, Column, dto.getBonAllowance_01_06()); 	// ܗ^x01_06
		if( null != dto.getBonAllowance_02_06()) prtItem_chk( poi,   Line +   2, Column, dto.getBonAllowance_02_06()); 	// ܗ^x02_06
		if( null != dto.getBonAllowance_03_06()) prtItem_chk( poi,   Line +   3, Column, dto.getBonAllowance_03_06()); 	// ܗ^x03_06
		if( null != dto.getBonAllowance_04_06()) prtItem_chk( poi,   Line +   4, Column, dto.getBonAllowance_04_06()); 	// ܗ^x04_06
		if( null != dto.getBonAllowance_05_06()) prtItem_chk( poi,   Line +   5, Column, dto.getBonAllowance_05_06()); 	// ܗ^x05_06
		if( null != dto.getBonAllowance_06_06()) prtItem_chk( poi,   Line +   6, Column, dto.getBonAllowance_06_06()); 	// ܗ^x06_06
		if( null != dto.getBonAllowance_07_06()) prtItem_chk( poi,   Line +   7, Column, dto.getBonAllowance_07_06()); 	// ܗ^x07_06
		if( null != dto.getBonAllowance_08_06()) prtItem_chk( poi,   Line +   8, Column, dto.getBonAllowance_08_06()); 	// ܗ^x08_06
		if( null != dto.getBonAllowance_09_06()) prtItem_chk( poi,   Line +   9, Column, dto.getBonAllowance_09_06()); 	// ܗ^x09_06
		if( null != dto.getBonAllowance_10_06()) prtItem_chk( poi,   Line +  10, Column, dto.getBonAllowance_10_06()); 	// ܗ^x10_06
		if( null != dto. getBonAllowanceTotal_06()) prtItem_chk( poi,   Line +  11, Column, dto. getBonAllowanceTotal_06()); 	// ܗ^x6ڌv

		
		Line   = 97;
		Column = 21; // Nԍv
		if( null != dto.getBonTotalAllowance_01()) prtItem_chk( poi,   Line +   1, Column, dto.getBonTotalAllowance_01()); 	// ܗ^x01v
		if( null != dto.getBonTotalAllowance_02()) prtItem_chk( poi,   Line +   2, Column, dto.getBonTotalAllowance_02()); 	// ܗ^x02v
		if( null != dto.getBonTotalAllowance_03()) prtItem_chk( poi,   Line +   3, Column, dto.getBonTotalAllowance_03()); 	// ܗ^x03v
		if( null != dto.getBonTotalAllowance_04()) prtItem_chk( poi,   Line +   4, Column, dto.getBonTotalAllowance_04()); 	// ܗ^x04v
		if( null != dto.getBonTotalAllowance_05()) prtItem_chk( poi,   Line +   5, Column, dto.getBonTotalAllowance_05()); 	// ܗ^x05v
		if( null != dto.getBonTotalAllowance_06()) prtItem_chk( poi,   Line +   6, Column, dto.getBonTotalAllowance_06()); 	// ܗ^x06v
		if( null != dto.getBonTotalAllowance_07()) prtItem_chk( poi,   Line +   7, Column, dto.getBonTotalAllowance_07()); 	// ܗ^x07v
		if( null != dto.getBonTotalAllowance_08()) prtItem_chk( poi,   Line +   8, Column, dto.getBonTotalAllowance_08()); 	// ܗ^x08v
		if( null != dto.getBonTotalAllowance_09()) prtItem_chk( poi,   Line +   9, Column, dto.getBonTotalAllowance_09()); 	// ܗ^x09v
		if( null != dto.getBonTotalAllowance_10()) prtItem_chk( poi,   Line +  10, Column, dto.getBonTotalAllowance_10()); 	// ܗ^x10v
		if( null != dto.getBonTotalAllowanceTotal()) prtItem_chk( poi,   Line +  11, Column, dto.getBonTotalAllowanceTotal()); 	// ܗ^xڍv

		// ܗ^T׏o
		Line   = 110;
		Column =   3; // 1
		if( null != dto.getBonDeduction_01_01()) prtItem_chk( poi,   Line +   1, Column, dto.getBonDeduction_01_01());	// ܗ^T01_01
		if( null != dto.getBonDeduction_02_01()) prtItem_chk( poi,   Line +   2, Column, dto.getBonDeduction_02_01());	// ܗ^T02_01
		if( null != dto.getBonDeduction_03_01()) prtItem_chk( poi,   Line +   3, Column, dto.getBonDeduction_03_01());	// ܗ^T03_01
		if( null != dto.getBonDeduction_04_01()) prtItem_chk( poi,   Line +   4, Column, dto.getBonDeduction_04_01());	// ܗ^T04_01
		if( null != dto.getBonDeduction_05_01()) prtItem_chk( poi,   Line +   5, Column, dto.getBonDeduction_05_01());	// ܗ^T05_01
		if( null != dto.getBonDeduction_06_01()) prtItem_chk( poi,   Line +   6, Column, dto.getBonDeduction_06_01());	// ܗ^T06_01
		if( null != dto.getBonDeduction_07_01()) prtItem_chk( poi,   Line +   7, Column, dto.getBonDeduction_07_01());	// ܗ^T07_01
		if( null != dto.getBonDeduction_08_01()) prtItem_chk( poi,   Line +   8, Column, dto.getBonDeduction_08_01());	// ܗ^T08_01
		if( null != dto.getBonDeduction_09_01()) prtItem_chk( poi,   Line +   9, Column, dto.getBonDeduction_09_01());	// ܗ^T09_01
		if( null != dto.getBonDeduction_10_01()) prtItem_chk( poi,   Line +  10, Column, dto.getBonDeduction_10_01());	// ܗ^T10_01
		if( null != dto.getBonDeduction_11_01()) prtItem_chk( poi,   Line +  11, Column, dto.getBonDeduction_11_01());	// ܗ^T11_01
		if( null != dto.getBonDeduction_12_01()) prtItem_chk( poi,   Line +  12, Column, dto.getBonDeduction_12_01());	// ܗ^T12_01
		if( null != dto.getBonDeduction_14_01()) prtItem_chk( poi,   Line +  13, Column, dto.getBonDeduction_14_01());	// ܗ^T14_01
		if( null != dto.getBonDeduction_15_01()) prtItem_chk( poi,   Line +  14, Column, dto.getBonDeduction_15_01());	// ܗ^T15_01
		if( null != dto.getBonDeduction_16_01()) prtItem_chk( poi,   Line +  15, Column, dto.getBonDeduction_16_01());	// ܗ^T16_01
		if( null != dto.getBonDeduction_17_01()) prtItem_chk( poi,   Line +  16, Column, dto.getBonDeduction_17_01());	// ܗ^T17_01
		if( null != dto.getBonDeductionTotal_01()) prtItem_chk( poi, Line +  17, Column, dto.getBonDeductionTotal_01());	// ܗ^1ڍTڌv
		if( null != dto.getBonPaymentTotal_01())   prtItem_chk( poi, Line +  18, Column, dto.getBonPaymentTotal_01());	// ܗ^1ڍxzv
		if( null != dto.getBonBank1PayAmount_01()) prtItem_chk( poi, Line +  19, Column, dto.getBonBank1PayAmount_01());	// ܗ^1ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_01()) prtItem_chk( poi, Line +  20, Column, dto.getBonBank2PayAmount_01());	// ܗ^1ڋs2Uzv
		if( null != dto.getBonCashPayAmount_01())  prtItem_chk( poi, Line +  21, Column, dto.getBonCashPayAmount_01());	// ܗ^1ڌxzv

		Line   = 110;
		Column =   6; // 2
		if( null != dto.getBonDeduction_01_02()) prtItem_chk( poi,   Line +   1, Column, dto.getBonDeduction_01_02());	// ܗ^T01_02
		if( null != dto.getBonDeduction_02_02()) prtItem_chk( poi,   Line +   2, Column, dto.getBonDeduction_02_02());	// ܗ^T02_02
		if( null != dto.getBonDeduction_03_02()) prtItem_chk( poi,   Line +   3, Column, dto.getBonDeduction_03_02());	// ܗ^T03_02
		if( null != dto.getBonDeduction_04_02()) prtItem_chk( poi,   Line +   4, Column, dto.getBonDeduction_04_02());	// ܗ^T04_02
		if( null != dto.getBonDeduction_05_02()) prtItem_chk( poi,   Line +   5, Column, dto.getBonDeduction_05_02());	// ܗ^T05_02
		if( null != dto.getBonDeduction_06_02()) prtItem_chk( poi,   Line +   6, Column, dto.getBonDeduction_06_02());	// ܗ^T06_02
		if( null != dto.getBonDeduction_07_02()) prtItem_chk( poi,   Line +   7, Column, dto.getBonDeduction_07_02());	// ܗ^T07_02
		if( null != dto.getBonDeduction_08_02()) prtItem_chk( poi,   Line +   8, Column, dto.getBonDeduction_08_02());	// ܗ^T08_02
		if( null != dto.getBonDeduction_09_02()) prtItem_chk( poi,   Line +   9, Column, dto.getBonDeduction_09_02());	// ܗ^T09_02
		if( null != dto.getBonDeduction_10_02()) prtItem_chk( poi,   Line +  10, Column, dto.getBonDeduction_10_02());	// ܗ^T10_02
		if( null != dto.getBonDeduction_11_02()) prtItem_chk( poi,   Line +  11, Column, dto.getBonDeduction_11_02());	// ܗ^T11_02
		if( null != dto.getBonDeduction_12_02()) prtItem_chk( poi,   Line +  12, Column, dto.getBonDeduction_12_02());	// ܗ^T12_02
		if( null != dto.getBonDeduction_14_02()) prtItem_chk( poi,   Line +  13, Column, dto.getBonDeduction_14_02());	// ܗ^T14_02
		if( null != dto.getBonDeduction_15_02()) prtItem_chk( poi,   Line +  14, Column, dto.getBonDeduction_15_02());	// ܗ^T15_02
		if( null != dto.getBonDeduction_16_02()) prtItem_chk( poi,   Line +  15, Column, dto.getBonDeduction_16_02());	// ܗ^T16_02
		if( null != dto.getBonDeduction_17_02()) prtItem_chk( poi,   Line +  16, Column, dto.getBonDeduction_17_02());	// ܗ^T17_02
		if( null != dto.getBonDeductionTotal_02()) prtItem_chk( poi, Line +  17, Column, dto.getBonDeductionTotal_02());	// ܗ^2ڍTڌv
		if( null != dto.getBonPaymentTotal_02())   prtItem_chk( poi, Line +  18, Column, dto.getBonPaymentTotal_02());	// ܗ^2ڍxzv
		if( null != dto.getBonBank1PayAmount_02()) prtItem_chk( poi, Line +  19, Column, dto.getBonBank1PayAmount_02());	// ܗ^2ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_02()) prtItem_chk( poi, Line +  20, Column, dto.getBonBank2PayAmount_02());	// ܗ^2ڋs2Uzv
		if( null != dto.getBonCashPayAmount_02())  prtItem_chk( poi, Line +  21, Column, dto.getBonCashPayAmount_02());	// ܗ^2ڌxzv

		Line   = 110;
		Column =   9; // 3
		if( null != dto.getBonDeduction_01_03()) prtItem_chk( poi,   Line +   1, Column, dto.getBonDeduction_01_03());	// ܗ^T01_03
		if( null != dto.getBonDeduction_02_03()) prtItem_chk( poi,   Line +   2, Column, dto.getBonDeduction_02_03());	// ܗ^T02_03
		if( null != dto.getBonDeduction_03_03()) prtItem_chk( poi,   Line +   3, Column, dto.getBonDeduction_03_03());	// ܗ^T03_03
		if( null != dto.getBonDeduction_04_03()) prtItem_chk( poi,   Line +   4, Column, dto.getBonDeduction_04_03());	// ܗ^T04_03
		if( null != dto.getBonDeduction_05_03()) prtItem_chk( poi,   Line +   5, Column, dto.getBonDeduction_05_03());	// ܗ^T05_03
		if( null != dto.getBonDeduction_06_03()) prtItem_chk( poi,   Line +   6, Column, dto.getBonDeduction_06_03());	// ܗ^T06_03
		if( null != dto.getBonDeduction_07_03()) prtItem_chk( poi,   Line +   7, Column, dto.getBonDeduction_07_03());	// ܗ^T07_03
		if( null != dto.getBonDeduction_08_03()) prtItem_chk( poi,   Line +   8, Column, dto.getBonDeduction_08_03());	// ܗ^T08_03
		if( null != dto.getBonDeduction_09_03()) prtItem_chk( poi,   Line +   9, Column, dto.getBonDeduction_09_03());	// ܗ^T09_03
		if( null != dto.getBonDeduction_10_03()) prtItem_chk( poi,   Line +  10, Column, dto.getBonDeduction_10_03());	// ܗ^T10_03
		if( null != dto.getBonDeduction_11_03()) prtItem_chk( poi,   Line +  11, Column, dto.getBonDeduction_11_03());	// ܗ^T11_03
		if( null != dto.getBonDeduction_12_03()) prtItem_chk( poi,   Line +  12, Column, dto.getBonDeduction_12_03());	// ܗ^T12_03
		if( null != dto.getBonDeduction_14_03()) prtItem_chk( poi,   Line +  13, Column, dto.getBonDeduction_14_03());	// ܗ^T14_03
		if( null != dto.getBonDeduction_15_03()) prtItem_chk( poi,   Line +  14, Column, dto.getBonDeduction_15_03());	// ܗ^T15_03
		if( null != dto.getBonDeduction_16_03()) prtItem_chk( poi,   Line +  15, Column, dto.getBonDeduction_16_03());	// ܗ^T16_03
		if( null != dto.getBonDeduction_17_03()) prtItem_chk( poi,   Line +  16, Column, dto.getBonDeduction_17_03());	// ܗ^T17_03
		if( null != dto.getBonDeductionTotal_03()) prtItem_chk( poi, Line +  17, Column, dto.getBonDeductionTotal_03());	// ܗ^3ڍTڌv
		if( null != dto.getBonPaymentTotal_03())   prtItem_chk( poi, Line +  18, Column, dto.getBonPaymentTotal_03());	// ܗ^3ڍxzv
		if( null != dto.getBonBank1PayAmount_03()) prtItem_chk( poi, Line +  19, Column, dto.getBonBank1PayAmount_03());	// ܗ^3ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_03()) prtItem_chk( poi, Line +  20, Column, dto.getBonBank2PayAmount_03());	// ܗ^3ڋs2Uzv
		if( null != dto.getBonCashPayAmount_03())  prtItem_chk( poi, Line +  21, Column, dto.getBonCashPayAmount_03());	// ܗ^3ڌxzv

		Line   = 110;
		Column =  12; // 4
		if( null != dto.getBonDeduction_01_04()) prtItem_chk( poi,   Line +   1, Column, dto.getBonDeduction_01_04());	// ܗ^T01_04
		if( null != dto.getBonDeduction_02_04()) prtItem_chk( poi,   Line +   2, Column, dto.getBonDeduction_02_04());	// ܗ^T02_04
		if( null != dto.getBonDeduction_03_04()) prtItem_chk( poi,   Line +   3, Column, dto.getBonDeduction_03_04());	// ܗ^T03_04
		if( null != dto.getBonDeduction_04_04()) prtItem_chk( poi,   Line +   4, Column, dto.getBonDeduction_04_04());	// ܗ^T04_04
		if( null != dto.getBonDeduction_05_04()) prtItem_chk( poi,   Line +   5, Column, dto.getBonDeduction_05_04());	// ܗ^T05_04
		if( null != dto.getBonDeduction_06_04()) prtItem_chk( poi,   Line +   6, Column, dto.getBonDeduction_06_04());	// ܗ^T06_04
		if( null != dto.getBonDeduction_07_04()) prtItem_chk( poi,   Line +   7, Column, dto.getBonDeduction_07_04());	// ܗ^T07_04
		if( null != dto.getBonDeduction_08_04()) prtItem_chk( poi,   Line +   8, Column, dto.getBonDeduction_08_04());	// ܗ^T08_04
		if( null != dto.getBonDeduction_09_04()) prtItem_chk( poi,   Line +   9, Column, dto.getBonDeduction_09_04());	// ܗ^T09_04
		if( null != dto.getBonDeduction_10_04()) prtItem_chk( poi,   Line +  10, Column, dto.getBonDeduction_10_04());	// ܗ^T10_04
		if( null != dto.getBonDeduction_11_04()) prtItem_chk( poi,   Line +  11, Column, dto.getBonDeduction_11_04());	// ܗ^T11_04
		if( null != dto.getBonDeduction_12_04()) prtItem_chk( poi,   Line +  12, Column, dto.getBonDeduction_12_04());	// ܗ^T12_04
		if( null != dto.getBonDeduction_14_04()) prtItem_chk( poi,   Line +  13, Column, dto.getBonDeduction_14_04());	// ܗ^T14_04
		if( null != dto.getBonDeduction_15_04()) prtItem_chk( poi,   Line +  14, Column, dto.getBonDeduction_15_04());	// ܗ^T15_04
		if( null != dto.getBonDeduction_16_04()) prtItem_chk( poi,   Line +  15, Column, dto.getBonDeduction_16_04());	// ܗ^T16_04
		if( null != dto.getBonDeduction_17_04()) prtItem_chk( poi,   Line +  16, Column, dto.getBonDeduction_17_04());	// ܗ^T17_04
		if( null != dto.getBonDeductionTotal_04()) prtItem_chk( poi, Line +  17, Column, dto.getBonDeductionTotal_04());	// ܗ^4ڍTڌv
		if( null != dto.getBonPaymentTotal_04())   prtItem_chk( poi, Line +  18, Column, dto.getBonPaymentTotal_04());	// ܗ^4ڍxzv
		if( null != dto.getBonBank1PayAmount_04()) prtItem_chk( poi, Line +  19, Column, dto.getBonBank1PayAmount_04());	// ܗ^4ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_04()) prtItem_chk( poi, Line +  20, Column, dto.getBonBank2PayAmount_04());	// ܗ^4ڋs2Uzv
		if( null != dto.getBonCashPayAmount_04())  prtItem_chk( poi, Line +  21, Column, dto.getBonCashPayAmount_04());	// ܗ^4ڌxzv

		Line   = 110;
		Column =  15; // 5
		if( null != dto.getBonDeduction_01_05()) prtItem_chk( poi,   Line +   1, Column, dto.getBonDeduction_01_05());	// ܗ^T01_05
		if( null != dto.getBonDeduction_02_05()) prtItem_chk( poi,   Line +   2, Column, dto.getBonDeduction_02_05());	// ܗ^T02_05
		if( null != dto.getBonDeduction_03_05()) prtItem_chk( poi,   Line +   3, Column, dto.getBonDeduction_03_05());	// ܗ^T03_05
		if( null != dto.getBonDeduction_04_05()) prtItem_chk( poi,   Line +   4, Column, dto.getBonDeduction_04_05());	// ܗ^T04_05
		if( null != dto.getBonDeduction_05_05()) prtItem_chk( poi,   Line +   5, Column, dto.getBonDeduction_05_05());	// ܗ^T05_05
		if( null != dto.getBonDeduction_06_05()) prtItem_chk( poi,   Line +   6, Column, dto.getBonDeduction_06_05());	// ܗ^T06_05
		if( null != dto.getBonDeduction_07_05()) prtItem_chk( poi,   Line +   7, Column, dto.getBonDeduction_07_05());	// ܗ^T07_05
		if( null != dto.getBonDeduction_08_05()) prtItem_chk( poi,   Line +   8, Column, dto.getBonDeduction_08_05());	// ܗ^T08_05
		if( null != dto.getBonDeduction_09_05()) prtItem_chk( poi,   Line +   9, Column, dto.getBonDeduction_09_05());	// ܗ^T09_05
		if( null != dto.getBonDeduction_10_05()) prtItem_chk( poi,   Line +  10, Column, dto.getBonDeduction_10_05());	// ܗ^T10_05
		if( null != dto.getBonDeduction_11_05()) prtItem_chk( poi,   Line +  11, Column, dto.getBonDeduction_11_05());	// ܗ^T11_05
		if( null != dto.getBonDeduction_12_05()) prtItem_chk( poi,   Line +  12, Column, dto.getBonDeduction_12_05());	// ܗ^T12_05
		if( null != dto.getBonDeduction_14_05()) prtItem_chk( poi,   Line +  13, Column, dto.getBonDeduction_14_05());	// ܗ^T14_05
		if( null != dto.getBonDeduction_15_05()) prtItem_chk( poi,   Line +  14, Column, dto.getBonDeduction_15_05());	// ܗ^T15_05
		if( null != dto.getBonDeduction_16_05()) prtItem_chk( poi,   Line +  15, Column, dto.getBonDeduction_16_05());	// ܗ^T16_05
		if( null != dto.getBonDeduction_17_05()) prtItem_chk( poi,   Line +  16, Column, dto.getBonDeduction_17_05());	// ܗ^T17_05
		if( null != dto.getBonDeductionTotal_05()) prtItem_chk( poi, Line +  17, Column, dto.getBonDeductionTotal_05());	// ܗ^5ڍTڌv
		if( null != dto.getBonPaymentTotal_05())   prtItem_chk( poi, Line +  18, Column, dto.getBonPaymentTotal_05());	// ܗ^5ڍxzv
		if( null != dto.getBonBank1PayAmount_05()) prtItem_chk( poi, Line +  19, Column, dto.getBonBank1PayAmount_05());	// ܗ^5ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_05()) prtItem_chk( poi, Line +  20, Column, dto.getBonBank2PayAmount_05());	// ܗ^5ڋs2Uzv
		if( null != dto.getBonCashPayAmount_05())  prtItem_chk( poi, Line +  21, Column, dto.getBonCashPayAmount_05());	// ܗ^5ڌxzv

		Line   = 110;
		Column =  18; // 6
		if( null != dto.getBonDeduction_01_06()) prtItem_chk( poi,   Line +   1, Column, dto.getBonDeduction_01_06());	// ܗ^T01_06
		if( null != dto.getBonDeduction_02_06()) prtItem_chk( poi,   Line +   2, Column, dto.getBonDeduction_02_06());	// ܗ^T02_06
		if( null != dto.getBonDeduction_03_06()) prtItem_chk( poi,   Line +   3, Column, dto.getBonDeduction_03_06());	// ܗ^T03_06
		if( null != dto.getBonDeduction_04_06()) prtItem_chk( poi,   Line +   4, Column, dto.getBonDeduction_04_06());	// ܗ^T04_06
		if( null != dto.getBonDeduction_05_06()) prtItem_chk( poi,   Line +   5, Column, dto.getBonDeduction_05_06());	// ܗ^T05_06
		if( null != dto.getBonDeduction_06_06()) prtItem_chk( poi,   Line +   6, Column, dto.getBonDeduction_06_06());	// ܗ^T06_06
		if( null != dto.getBonDeduction_07_06()) prtItem_chk( poi,   Line +   7, Column, dto.getBonDeduction_07_06());	// ܗ^T07_06
		if( null != dto.getBonDeduction_08_06()) prtItem_chk( poi,   Line +   8, Column, dto.getBonDeduction_08_06());	// ܗ^T08_06
		if( null != dto.getBonDeduction_09_06()) prtItem_chk( poi,   Line +   9, Column, dto.getBonDeduction_09_06());	// ܗ^T09_06
		if( null != dto.getBonDeduction_10_06()) prtItem_chk( poi,   Line +  10, Column, dto.getBonDeduction_10_06());	// ܗ^T10_06
		if( null != dto.getBonDeduction_11_06()) prtItem_chk( poi,   Line +  11, Column, dto.getBonDeduction_11_06());	// ܗ^T11_06
		if( null != dto.getBonDeduction_12_06()) prtItem_chk( poi,   Line +  12, Column, dto.getBonDeduction_12_06());	// ܗ^T12_06
		if( null != dto.getBonDeduction_14_06()) prtItem_chk( poi,   Line +  13, Column, dto.getBonDeduction_14_06());	// ܗ^T14_06
		if( null != dto.getBonDeduction_15_06()) prtItem_chk( poi,   Line +  14, Column, dto.getBonDeduction_15_06());	// ܗ^T15_06
		if( null != dto.getBonDeduction_16_06()) prtItem_chk( poi,   Line +  15, Column, dto.getBonDeduction_16_06());	// ܗ^T16_06
		if( null != dto.getBonDeduction_17_06()) prtItem_chk( poi,   Line +  16, Column, dto.getBonDeduction_17_06());	// ܗ^T17_06
		if( null != dto.getBonDeductionTotal_06()) prtItem_chk( poi, Line +  17, Column, dto.getBonDeductionTotal_06());	// ܗ^6ڍTڌv
		if( null != dto.getBonPaymentTotal_06())   prtItem_chk( poi, Line +  18, Column, dto.getBonPaymentTotal_06());	// ܗ^6ڍxzv
		if( null != dto.getBonBank1PayAmount_06()) prtItem_chk( poi, Line +  19, Column, dto.getBonBank1PayAmount_06());	// ܗ^6ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_06()) prtItem_chk( poi, Line +  20, Column, dto.getBonBank2PayAmount_06());	// ܗ^6ڋs2Uzv
		if( null != dto.getBonCashPayAmount_06())  prtItem_chk( poi, Line +  21, Column, dto.getBonCashPayAmount_06());	// ܗ^6ڌxzv

		Line   = 110;
		Column =  21; // Nԍv
		if( null != dto.getBonTotalDeduction_01())   prtItem_chk( poi, Line +   1, Column, dto.getBonTotalDeduction_01());	// ܗ^T01NԌv
		if( null != dto.getBonTotalDeduction_02())   prtItem_chk( poi, Line +   2, Column, dto.getBonTotalDeduction_02());	// ܗ^T02NԌv
		if( null != dto.getBonTotalDeduction_03())   prtItem_chk( poi, Line +   3, Column, dto.getBonTotalDeduction_03());	// ܗ^T03NԌv
		if( null != dto.getBonTotalDeduction_04())   prtItem_chk( poi, Line +   4, Column, dto.getBonTotalDeduction_04());	// ܗ^T04NԌv
		if( null != dto.getBonTotalDeduction_05())   prtItem_chk( poi, Line +   5, Column, dto.getBonTotalDeduction_05());	// ܗ^T05NԌv
		if( null != dto.getBonTotalDeduction_06())   prtItem_chk( poi, Line +   6, Column, dto.getBonTotalDeduction_06());	// ܗ^T06NԌv
		if( null != dto.getBonTotalDeduction_07())   prtItem_chk( poi, Line +   7, Column, dto.getBonTotalDeduction_07());	// ܗ^T07NԌv
		if( null != dto.getBonTotalDeduction_08())   prtItem_chk( poi, Line +   8, Column, dto.getBonTotalDeduction_08());	// ܗ^T08NԌv
		if( null != dto.getBonTotalDeduction_09())   prtItem_chk( poi, Line +   9, Column, dto.getBonTotalDeduction_09());	// ܗ^T09NԌv
		if( null != dto.getBonTotalDeduction_10())   prtItem_chk( poi, Line +  10, Column, dto.getBonTotalDeduction_10());	// ܗ^T10NԌv
		if( null != dto.getBonTotalDeduction_11())   prtItem_chk( poi, Line +  11, Column, dto.getBonTotalDeduction_11());	// ܗ^T11NԌv
		if( null != dto.getBonTotalDeduction_12())   prtItem_chk( poi, Line +  12, Column, dto.getBonTotalDeduction_12());	// ܗ^T12NԌv
		if( null != dto.getBonTotalDeduction_14())   prtItem_chk( poi, Line +  13, Column, dto.getBonTotalDeduction_14());	// ܗ^T14NԌv
		if( null != dto.getBonTotalDeduction_15())   prtItem_chk( poi, Line +  14, Column, dto.getBonTotalDeduction_15());	// ܗ^T15NԌv
		if( null != dto.getBonTotalDeduction_16())   prtItem_chk( poi, Line +  15, Column, dto.getBonTotalDeduction_16());	// ܗ^T16NԌv
		if( null != dto.getBonTotalDeduction_17())   prtItem_chk( poi, Line +  16, Column, dto.getBonTotalDeduction_17());	// ܗ^T17NԌv
		if( null != dto.getBonTotalDeductionTotal()) prtItem_chk( poi, Line +  17, Column, dto.getBonTotalDeductionTotal());	// ܗ^Tڍv
		if( null != dto.getBonTotalPaymentTotal())   prtItem_chk( poi, Line +  18, Column, dto.getBonTotalPaymentTotal());	// ܗ^xzvv
		if( null != dto.getBonTotalBank1PayAmount()) prtItem_chk( poi, Line +  19, Column, dto.getBonTotalBank1PayAmount());	// ܗ^s1Uzvv
		if( null != dto.getBonTotalBank2PayAmount()) prtItem_chk( poi, Line +  20, Column, dto.getBonTotalBank2PayAmount());	// ܗ^s2Uzvv
		if( null != dto.getBonTotalCashPayAmount())  prtItem_chk( poi, Line +  21, Column, dto.getBonTotalCashPayAmount());	// ܗ^xzvv

		// }{T\
		Line   = 126;
		Column =  28;
		if( null != dto.getIncomeTaxType())     prtItem_chk( poi, Line +   0, Column +   0, dto.getIncomeTaxType());		// ېŋ敪
		if( null != dto.getAdjustmentType())    prtItem_chk( poi, Line +   1, Column +   0, dto.getAdjustmentType());	// N敪
		if( null != dto.getSelfWidowType())     prtItem_chk( poi, Line +   2, Column +   0, dto.getSelfWidowType());		// {l敪PF{lǕw敪
		if( null != dto.getSelfHandicapType())  prtItem_chk( poi, Line +   3, Column +   0, dto.getSelfHandicapType());	// {l敪QF{lQ敪
		if( null != dto.getSelfStudentType())   prtItem_chk( poi, Line +   4, Column +   0, dto.getSelfStudentType());	// {l敪RF{lw敪
		if( null != dto.getSpouseIntendType())  prtItem_chk( poi, Line +   5, Column +   0, dto.getSpouseIntendType());	// zҋ敪
		if( null != dto.getGeneralDependent())  prtItem_chk( poi, Line +   0, Column +   6, dto.getGeneralDependent());	// ʕ}{e
		if( null != dto.getSpecificDependent()) prtItem_chk( poi, Line +   1, Column +   6, dto.getSpecificDependent());	// }{e
		if( null != dto.getElderlyDependent())  prtItem_chk( poi, Line +   2, Column +   6, dto.getElderlyDependent());	// Vl}{e
		if( null != dto.getLiveWithEldRel())    prtItem_chk( poi, Line +   3, Column +   6, dto.getLiveWithEldRel());	// Vle
		if( null != dto.getGeneralHandicap())   prtItem_chk( poi, Line +   5, Column +   6, dto.getGeneralHandicap());	// ʏQ
		if( null != dto.getLiveWithHandiGe())   prtItem_chk( poi, Line +   0, Column +  12, dto.getLiveWithHandiGe());	// 
		if( null != dto.getLiveWithHandiSp())   prtItem_chk( poi, Line +   1, Column +  12, dto.getLiveWithHandiSp());	// 
		if( null != dto.getLiveWithHandiEl())   prtItem_chk( poi, Line +   2, Column +  12, dto.getLiveWithHandiEl());	// Vl
		if( null != dto.getLiveWithHandiEr())   prtItem_chk( poi, Line +   3, Column +  12, dto.getLiveWithHandiEr());	// Ve
		if( null != dto.getSpecificHandicap())  prtItem_chk( poi, Line +   5, Column +  12, dto.getSpecificHandicap());	// ʏQ

		// l
		if((null != dto.getGender()) && (dto.getGender().equals("2"))){
			prtItem_chk( poi, 134, 13, "");									// 
		}else{
			prtItem_chk( poi, 134, 13, "j");									// 
		}
		Line   = 135;
		Column =  13;
		prtItem_chk( poi, Line +   0, Column + 0, dto.getBirthDate());			// N		
		prtItem_chk( poi, Line +   1, Column + 0, dto.getEntranceDate());		// Г		
		prtItem_chk( poi, Line +   2, Column + 0, dto.getRetirementDate());		// ގГ		

		
		Line   = 134;
		Column =  21;
		prtItem_chk( poi, Line +   0, Column + 0, dto.getPostalCode());			// ZiX֔ԍj
		prtItem_chk( poi, Line +   1, Column + 0, dto.getAddress());				// Z
		prtItem_chk( poi, Line +   3, Column + 0, dto.getPhoneNumber());			// dbԍ		

		Line   = 134;
		Column =  32;
		prtItem_chk( poi, Line +   0, Column + 0, dto.getHealthNo());			// Nیԍ
		prtItem_chk( poi, Line +   0, Column + 6, dto.getFundNo());				// ԍ
		prtItem_chk( poi, Line +   2, Column + 0, dto.getPensionNo());			// bNԍ
		prtItem_chk( poi, Line +   2, Column + 6, dto.getUnemployNo());			// ٗpیԍ

		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + 
										PayrollConst.FILE_NAME_SEPARATOR +
										dto.getKCode()	+
										PayrollConst.FILE_NAME_SEPARATOR +
										PayrollConst.FILE_PAYMENTLEDGER_XLS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}


	/**
	 * [o͏sB(OpenOffice Calc)<br><br>
	 * @throws Exception 
	 */
	private void report(AdjustmentReferVo vo , PaymentLedgerDto dto) throws Exception {
		int Line;
		int Column;

		// RlNV擾
		getConnection();
		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_PAYMENTLEDGER_ODS);

		// wb_[
		Line   =  0;
		Column = 13;
		setValue_chk( odsBean,  Column +  0,Line +   0, dto.getOutputYear());			// ΏۘaNx(^Cg)
		setValue_chk( odsBean,  Column +  0,Line +  73, dto.getOutputYear());			// ΏۘaNx(^Cg)

		Line   =  2;
		Column =  0;
		setValue_chk( odsBean, Column +  0, Line +   0, dto.getCompanyName());			// Ж
		setValue_chk( odsBean, Column +  0, Line +  73, dto.getCompanyName());			// Ж

		Line   =  2;
		Column = 38;
		setValue_chk( odsBean, Column +  0, Line +   0, dto.getOutputDate());			// o͓t
		setValue_chk( odsBean, Column +  0, Line +  73, dto.getOutputDate());			// o͓t

		Line   =  4;
		Column =  2;
		setValue_chk( odsBean, Column +  0, Line +   0, vo.getEscLblStationName());	// 
		setValue_chk( odsBean, Column +  0, Line +  73, vo.getEscLblStationName());	// 
		setValue_chk( odsBean, Column +  0, Line + 130, vo.getEscLblStationName());	// 

		Line   =  4;
		Column = 10;
		setValue_chk( odsBean, Column +  0, Line +   0, vo.getEscLblPositionName());	// Eʖ		
		setValue_chk( odsBean, Column +  0, Line +  73, vo.getEscLblPositionName());	// Eʖ
		setValue_chk( odsBean,           2, Line + 131, vo.getEscLblPositionName());	// Eʖ

		Line   =  4;
		Column = 19;
		setValue_chk( odsBean, Column +  0, Line +   0, dto.getKCode());				// ЈR[h
		setValue_chk( odsBean, Column +  0, Line +  73, dto.getKCode());				// ЈR[h
		setValue_chk( odsBean,           2, Line + 132, dto.getKCode());				// ЈR[h

		Line   =  4;
		Column = 24;
		setValue_chk( odsBean, Column +  0, Line +   0, dto.getKName());				// 
		setValue_chk( odsBean, Column +  0, Line +  73, dto.getKName());				// 
		setValue_chk( odsBean,           2, Line + 133, dto.getKName());				// 
				
		/** ^ڏo **/
		// ږo
		Line   =  8;
		Column =  0;
		setValue_chk( odsBean, Column +  0, Line +   0, dto.getTitleAllowanceItem());		// xږ^Cg
		setValue_chk( odsBean, Column +  0, Line +   1, dto.getTitlePayAllowance_01());	// ^x01^Cg
		setValue_chk( odsBean, Column +  0, Line +   2, dto.getTitlePayAllowance_02());	// ^x02^Cg
		setValue_chk( odsBean, Column +  0, Line +   3, dto.getTitlePayAllowance_03());	// ^x03^Cg
		setValue_chk( odsBean, Column +  0, Line +   4, dto.getTitlePayAllowance_04());	// ^x04^Cg
		setValue_chk( odsBean, Column +  0, Line +   5, dto.getTitlePayAllowance_05());	// ^x05^Cg
		setValue_chk( odsBean, Column +  0, Line +   6, dto.getTitlePayAllowance_06());	// ^x06^Cg
		setValue_chk( odsBean, Column +  0, Line +   7, dto.getTitlePayAllowance_07());	// ^x07^Cg
		setValue_chk( odsBean, Column +  0, Line +   8, dto.getTitlePayAllowance_08());	// ^x08^Cg
		setValue_chk( odsBean, Column +  0, Line +   9, dto.getTitlePayAllowance_09());	// ^x09^Cg
		setValue_chk( odsBean, Column +  0, Line +  10, dto.getTitlePayAllowance_10());	// ^x10^Cg
		setValue_chk( odsBean, Column +  0, Line +  11, dto.getTitlePayAllowance_11());	// ^x11^Cg
		setValue_chk( odsBean, Column +  0, Line +  12, dto.getTitlePayAllowance_12());	// ^x12^Cg
		setValue_chk( odsBean, Column +  0, Line +  13, dto.getTitlePayAllowance_13());	// ^x13^Cg
		setValue_chk( odsBean, Column +  0, Line +  14, dto.getTitlePayAllowance_14());	// ^x14^Cg
		setValue_chk( odsBean, Column +  0, Line +  15, dto.getTitlePayAllowance_15());	// ^x15^Cg
		setValue_chk( odsBean, Column +  0, Line +  16, dto.getTitlePayAllowance_16());	// ^x16^Cg
		setValue_chk( odsBean, Column +  0, Line +  17, dto.getTitlePayAllowance_17());	// ^x17^Cg
		setValue_chk( odsBean, Column +  0, Line +  18, dto.getTitlePayAllowance_18());	// ^x18^Cg
		setValue_chk( odsBean, Column +  0, Line +  19, dto.getTitlePayAllowance_19());	// ^x19^Cg
		setValue_chk( odsBean, Column +  0, Line +  20, dto.getTitlePayAllowance_20());	// ^x20^Cg
		setValue_chk( odsBean, Column +  0, Line +  21, dto.getTitlePayAllowance_21());	// ^x21^Cg
		setValue_chk( odsBean, Column +  0, Line +  22, dto.getTitlePayAllowance_22());	// ^x22^Cg
		setValue_chk( odsBean, Column +  0, Line +  23, dto.getTitlePayAllowance_23());	// ^x23^Cg
		setValue_chk( odsBean, Column +  0, Line +  24, dto.getTitlePayAllowance_24());	// ^x24^Cg
		setValue_chk( odsBean, Column +  0, Line +  25, dto.getTitlePayAllowance_25());	// ^x25^Cg
		setValue_chk( odsBean, Column +  0, Line +  26, dto.getTitlePayAllowance_26());	// ^x26^Cg
		setValue_chk( odsBean, Column +  0, Line +  27, dto.getTitlePayAllowance_27());	// ^x27^Cg
		setValue_chk( odsBean, Column +  0, Line +  28, dto.getTitlePayAllowance_28());	// ^x28^Cg
		setValue_chk( odsBean, Column +  0, Line +  29, dto.getTitlePayAllowance_29());	// ^x29^Cg
		setValue_chk( odsBean, Column +  0, Line +  30, dto.getTitlePayAllowance_30());	// ^x30^Cg
		setValue_chk( odsBean, Column +  0, Line +  31, dto.getTitleAllowanceTotal());	// xz^Cg		

		Line   =  40;
		setValue_chk( odsBean, Column +  0, Line +   0, "" + dto.getTitleDeductionItem() + "");	// Tڃ^Cg  
		setValue_chk( odsBean, Column +  0, Line +   1, dto.getTitlePayDeduction_01());	// ^T01^Cg
		setValue_chk( odsBean, Column +  0, Line +   2, dto.getTitlePayDeduction_02());	// ^T02^Cg
		setValue_chk( odsBean, Column +  0, Line +   3, dto.getTitlePayDeduction_03());	// ^T03^Cg
		setValue_chk( odsBean, Column +  0, Line +   4, dto.getTitlePayDeduction_04());	// ^T04^Cg
		setValue_chk( odsBean, Column +  0, Line +   5, dto.getTitlePayDeduction_05());	// ^T05^Cg
		setValue_chk( odsBean, Column +  0, Line +   6, dto.getTitlePayDeduction_06());	// ^T06^Cg
		setValue_chk( odsBean, Column +  0, Line +   7, dto.getTitlePayDeduction_07());	// ^T07^Cg
		setValue_chk( odsBean, Column +  0, Line +   8, dto.getTitlePayDeduction_08());	// ^T08^Cg
		setValue_chk( odsBean, Column +  0, Line +   9, dto.getTitlePayDeduction_09());	// ^T09^Cg
		setValue_chk( odsBean, Column +  0, Line +  10, dto.getTitlePayDeduction_10());	// ^T10^Cg
		setValue_chk( odsBean, Column +  0, Line +  11, dto.getTitlePayDeduction_11());	// ^T11^Cg
		setValue_chk( odsBean, Column +  0, Line +  12, dto.getTitlePayDeduction_12());	// ^T12^Cg
		setValue_chk( odsBean, Column +  0, Line +  13, dto.getTitlePayDeduction_14());	// ^T14^Cg
		setValue_chk( odsBean, Column +  0, Line +  14, dto.getTitlePayDeduction_15());	// ^T15^Cg
		setValue_chk( odsBean, Column +  0, Line +  15, dto.getTitlePayDeduction_16());	// ^T16^Cg
		setValue_chk( odsBean, Column +  0, Line +  16, dto.getTitlePayDeduction_17());	// ^T17^Cg
		setValue_chk( odsBean, Column +  0, Line +  17, dto.getTitlePayDeduction_18());	// ^T18^Cg
		setValue_chk( odsBean, Column +  0, Line +  18, dto.getTitlePayDeduction_19());	// ^T19^Cg
		setValue_chk( odsBean, Column +  0, Line +  19, dto.getTitlePayDeduction_20());	// ^T20^Cg
		setValue_chk( odsBean, Column +  0, Line +  20, dto.getTitlePayDeduction_21());	// ^T21^Cg
		setValue_chk( odsBean, Column +  0, Line +  21, dto.getTitlePayDeduction_22());	// ^T22^Cg
		setValue_chk( odsBean, Column +  0, Line +  22, dto.getTitlePayDeduction_23());	// ^T23^Cg
		setValue_chk( odsBean, Column +  0, Line +  23, dto.getTitlePayDeduction_24());	// ^T24^Cg
		setValue_chk( odsBean, Column +  0, Line +  24, dto.getTitlePayDeduction_25());	// ^T25^Cg
		setValue_chk( odsBean, Column +  0, Line +  25, dto.getTitleDeductionTotal());    // Tz^Cg
		setValue_chk( odsBean, Column +  0, Line +  26, dto.getTitlePayDeduction_26());	// ^T26^Cg
		setValue_chk( odsBean, Column +  0, Line +  27, dto.getTitlePaymentTotal());		// xz^Cg
		setValue_chk( odsBean, Column +  0, Line +  28, dto.getTitleBank1PayAmount());	// s1Uz
		setValue_chk( odsBean, Column +  0, Line +  29, dto.getTitleBank2PayAmount());	// s2Uz
		setValue_chk( odsBean, Column +  0, Line +  30, dto.getTitleCashPayAmount());		// xz
		setValue_chk( odsBean, Column +  0, Line +  31, dto.getTitlePayDeduction_27());	// ^T27^Cg

		// ^׏o
		Line   =  8;
		Column =  3; // 1
		if( null != dto.getPayPayday_01())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_01());	 	// ^x_01
		if( null != dto.getPayAllowance_01_01())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_01()); 	// ^x01_01
		if( null != dto.getPayAllowance_02_01())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_01()); 	// ^x02_01
		if( null != dto.getPayAllowance_03_01())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_01()); 	// ^x03_01
		if( null != dto.getPayAllowance_04_01())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_01()); 	// ^x04_01
		if( null != dto.getPayAllowance_05_01())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_01()); 	// ^x05_01
		if( null != dto.getPayAllowance_06_01())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_01()); 	// ^x06_01
		if( null != dto.getPayAllowance_07_01())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_01()); 	// ^x07_01
		if( null != dto.getPayAllowance_08_01())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_01()); 	// ^x08_01
		if( null != dto.getPayAllowance_09_01())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_01()); 	// ^x09_01
		if( null != dto.getPayAllowance_10_01())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_01()); 	// ^x10_01
		if( null != dto.getPayAllowance_11_01())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_01()); 	// ^x11_01
		if( null != dto.getPayAllowance_12_01())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_01()); 	// ^x12_01
		if( null != dto.getPayAllowance_13_01())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_01()); 	// ^x13_01
		if( null != dto.getPayAllowance_14_01())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_01()); 	// ^x14_01
		if( null != dto.getPayAllowance_15_01())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_01()); 	// ^x15_01
		if( null != dto.getPayAllowance_16_01())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_01()); 	// ^x16_01
		if( null != dto.getPayAllowance_17_01())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_01()); 	// ^x17_01
		if( null != dto.getPayAllowance_18_01())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_01()); 	// ^x18_01
		if( null != dto.getPayAllowance_19_01())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_01()); 	// ^x19_01
		if( null != dto.getPayAllowance_20_01())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_01()); 	// ^x20_01
		if( null != dto.getPayAllowance_21_01())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_01()); 	// ^x21_01
		if( null != dto.getPayAllowance_22_01())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_01()); 	// ^x22_01
		if( null != dto.getPayAllowance_23_01())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_01()); 	// ^x23_01
		if( null != dto.getPayAllowance_24_01())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_01()); 	// ^x24_01
		if( null != dto.getPayAllowance_25_01())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_01()); 	// ^x25_01
		if( null != dto.getPayAllowance_26_01())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_01()); 	// ^x26_01
		if( null != dto.getPayAllowance_27_01())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_01()); 	// ^x27_01
		if( null != dto.getPayAllowance_28_01())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_01()); 	// ^x28_01
		if( null != dto.getPayAllowance_29_01())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_01()); 	// ^x29_01
		if( null != dto.getPayAllowance_30_01())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_01()); 	// ^x30_01
		if( null != dto.getPayAllowanceTotal_01()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_01()); // ^xz_01
		Line   =  40;
		if( null != dto.getPayDeduction_01_01())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_01()); 	// ^T01_01
		if( null != dto.getPayDeduction_02_01())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_01()); 	// ^T02_01
		if( null != dto.getPayDeduction_03_01())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_01()); 	// ^T03_01
		if( null != dto.getPayDeduction_04_01())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_01()); 	// ^T04_01
		if( null != dto.getPayDeduction_05_01())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_01()); 	// ^T05_01
		if( null != dto.getPayDeduction_06_01())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_01()); 	// ^T06_01
		if( null != dto.getPayDeduction_07_01())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_01()); 	// ^T07_01
		if( null != dto.getPayDeduction_08_01())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_01()); 	// ^T08_01
		if( null != dto.getPayDeduction_09_01())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_01()); 	// ^T09_01
		if( null != dto.getPayDeduction_10_01())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_01()); 	// ^T10_01
		if( null != dto.getPayDeduction_11_01())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_01()); 	// ^T11_01
		if( null != dto.getPayDeduction_12_01())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_01()); 	// ^T12_01
		if( null != dto.getPayDeduction_14_01())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_01()); 	// ^T14_01
		if( null != dto.getPayDeduction_15_01())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_01()); 	// ^T15_01
		if( null != dto.getPayDeduction_16_01())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_01()); 	// ^T16_01
		if( null != dto.getPayDeduction_17_01())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_01()); 	// ^T17_01
		if( null != dto.getPayDeduction_18_01())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_01()); 	// ^T18_01
		if( null != dto.getPayDeduction_19_01())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_01()); 	// ^T19_01
		if( null != dto.getPayDeduction_20_01())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_01()); 	// ^T20_01
		if( null != dto.getPayDeduction_21_01())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_01()); 	// ^T21_01
		if( null != dto.getPayDeduction_22_01())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_01()); 	// ^T22_01
		if( null != dto.getPayDeduction_23_01())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_01()); 	// ^T23_01
		if( null != dto.getPayDeduction_24_01())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_01()); 	// ^T24_01
		if( null != dto.getPayDeduction_25_01())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_01()); 	// ^T25_01
		if( null != dto.getPayDeductionTotal_01()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_01()); // ^Tz_01
		if( null != dto.getPayDeduction_26_01())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_01()); 	// ^T26_01
		if( null != dto.getPayPaymentTotal_01())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_01()); 	// ^xz_01
		if( null != dto.getPayBank1PayAmount_01()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_01());	// ^s1Uz_01
		if( null != dto.getPayBank2PayAmount_01()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_01());	// ^s2Uz_01
		if( null != dto.getPayCashPayAmount_01())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_01());		// xz_01
		if( null != dto.getPayDeduction_27_01())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_01());		// ^T27_01

		Line   =  8;
		Column =  6; // 2
		if( null != dto.getPayPayday_02())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_02()); 		// ^x_02
		if( null != dto.getPayAllowance_01_02())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_02()); 	// ^x01_02
		if( null != dto.getPayAllowance_02_02())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_02()); 	// ^x02_02
		if( null != dto.getPayAllowance_03_02())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_02()); 	// ^x03_02
		if( null != dto.getPayAllowance_04_02())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_02()); 	// ^x04_02
		if( null != dto.getPayAllowance_05_02())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_02()); 	// ^x05_02
		if( null != dto.getPayAllowance_06_02())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_02()); 	// ^x06_02
		if( null != dto.getPayAllowance_07_02())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_02()); 	// ^x07_02
		if( null != dto.getPayAllowance_08_02())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_02()); 	// ^x08_02
		if( null != dto.getPayAllowance_09_02())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_02()); 	// ^x09_02
		if( null != dto.getPayAllowance_10_02())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_02()); 	// ^x10_02
		if( null != dto.getPayAllowance_11_02())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_02()); 	// ^x11_02
		if( null != dto.getPayAllowance_12_02())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_02()); 	// ^x12_02
		if( null != dto.getPayAllowance_13_02())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_02()); 	// ^x13_02
		if( null != dto.getPayAllowance_14_02())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_02()); 	// ^x14_02
		if( null != dto.getPayAllowance_15_02())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_02()); 	// ^x15_02
		if( null != dto.getPayAllowance_16_02())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_02()); 	// ^x16_02
		if( null != dto.getPayAllowance_17_02())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_02()); 	// ^x17_02
		if( null != dto.getPayAllowance_18_02())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_02()); 	// ^x18_02
		if( null != dto.getPayAllowance_19_02())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_02()); 	// ^x19_02
		if( null != dto.getPayAllowance_20_02())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_02()); 	// ^x20_02
		if( null != dto.getPayAllowance_21_02())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_02()); 	// ^x21_02
		if( null != dto.getPayAllowance_22_02())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_02()); 	// ^x22_02
		if( null != dto.getPayAllowance_23_02())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_02()); 	// ^x23_02
		if( null != dto.getPayAllowance_24_02())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_02()); 	// ^x24_02
		if( null != dto.getPayAllowance_25_02())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_02()); 	// ^x25_02
		if( null != dto.getPayAllowance_26_02())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_02()); 	// ^x26_02
		if( null != dto.getPayAllowance_27_02())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_02()); 	// ^x27_02
		if( null != dto.getPayAllowance_28_02())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_02()); 	// ^x28_02
		if( null != dto.getPayAllowance_29_02())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_02()); 	// ^x29_02
		if( null != dto.getPayAllowance_30_02())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_02()); 	// ^x30_02
		if( null != dto.getPayAllowanceTotal_02()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_02()); // ^xz_02
		Line   =  40;
		if( null != dto.getPayDeduction_01_02())   setValue_chk( odsBean, Column, Line +   1,dto.getPayDeduction_01_02()); 	// ^T01_02
		if( null != dto.getPayDeduction_02_02())   setValue_chk( odsBean, Column, Line +   2,dto.getPayDeduction_02_02()); 	// ^T02_02
		if( null != dto.getPayDeduction_03_02())   setValue_chk( odsBean, Column, Line +   3,dto.getPayDeduction_03_02()); 	// ^T03_02
		if( null != dto.getPayDeduction_04_02())   setValue_chk( odsBean, Column, Line +   4,dto.getPayDeduction_04_02()); 	// ^T04_02
		if( null != dto.getPayDeduction_05_02())   setValue_chk( odsBean, Column, Line +   5,dto.getPayDeduction_05_02()); 	// ^T05_02
		if( null != dto.getPayDeduction_06_02())   setValue_chk( odsBean, Column, Line +   6,dto.getPayDeduction_06_02()); 	// ^T06_02
		if( null != dto.getPayDeduction_07_02())   setValue_chk( odsBean, Column, Line +   7,dto.getPayDeduction_07_02()); 	// ^T07_02
		if( null != dto.getPayDeduction_08_02())   setValue_chk( odsBean, Column, Line +   8,dto.getPayDeduction_08_02()); 	// ^T08_02
		if( null != dto.getPayDeduction_09_02())   setValue_chk( odsBean, Column, Line +   9,dto.getPayDeduction_09_02()); 	// ^T09_02
		if( null != dto.getPayDeduction_10_02())   setValue_chk( odsBean, Column, Line +  10,dto.getPayDeduction_10_02()); 	// ^T10_02
		if( null != dto.getPayDeduction_11_02())   setValue_chk( odsBean, Column, Line +  11,dto.getPayDeduction_11_02()); 	// ^T11_02
		if( null != dto.getPayDeduction_12_02())   setValue_chk( odsBean, Column, Line +  12,dto.getPayDeduction_12_02()); 	// ^T12_02
		if( null != dto.getPayDeduction_14_02())   setValue_chk( odsBean, Column, Line +  13,dto.getPayDeduction_14_02()); 	// ^T14_02
		if( null != dto.getPayDeduction_15_02())   setValue_chk( odsBean, Column, Line +  14,dto.getPayDeduction_15_02()); 	// ^T15_02
		if( null != dto.getPayDeduction_16_02())   setValue_chk( odsBean, Column, Line +  15,dto.getPayDeduction_16_02()); 	// ^T16_02
		if( null != dto.getPayDeduction_17_02())   setValue_chk( odsBean, Column, Line +  16,dto.getPayDeduction_17_02()); 	// ^T17_02
		if( null != dto.getPayDeduction_18_02())   setValue_chk( odsBean, Column, Line +  17,dto.getPayDeduction_18_02()); 	// ^T18_02
		if( null != dto.getPayDeduction_19_02())   setValue_chk( odsBean, Column, Line +  18,dto.getPayDeduction_19_02()); 	// ^T19_02
		if( null != dto.getPayDeduction_20_02())   setValue_chk( odsBean, Column, Line +  19,dto.getPayDeduction_20_02()); 	// ^T20_02
		if( null != dto.getPayDeduction_21_02())   setValue_chk( odsBean, Column, Line +  20,dto.getPayDeduction_21_02()); 	// ^T21_02
		if( null != dto.getPayDeduction_22_02())   setValue_chk( odsBean, Column, Line +  21,dto.getPayDeduction_22_02()); 	// ^T22_02
		if( null != dto.getPayDeduction_23_02())   setValue_chk( odsBean, Column, Line +  22,dto.getPayDeduction_23_02()); 	// ^T23_02
		if( null != dto.getPayDeduction_24_02())   setValue_chk( odsBean, Column, Line +  23,dto.getPayDeduction_24_02()); 	// ^T24_02
		if( null != dto.getPayDeduction_25_02())   setValue_chk( odsBean, Column, Line +  24,dto.getPayDeduction_25_02()); 	// ^T25_02
		if( null != dto.getPayDeductionTotal_02()) setValue_chk( odsBean, Column, Line +  25,dto.getPayDeductionTotal_02());	// ^Tz_02
		if( null != dto.getPayDeduction_26_02())   setValue_chk( odsBean, Column, Line +  26,dto.getPayDeduction_26_02()); 	// ^T26_02
		if( null != dto.getPayPaymentTotal_02())   setValue_chk( odsBean, Column, Line +  27,dto.getPayPaymentTotal_02()); 	// ^xz_02
		if( null != dto.getPayBank1PayAmount_02()) setValue_chk( odsBean, Column, Line +  28,dto.getPayBank1PayAmount_02());	// ^s1Uz_02
		if( null != dto.getPayBank2PayAmount_02()) setValue_chk( odsBean, Column, Line +  29,dto.getPayBank2PayAmount_02());	// ^s2Uz_02
		if( null != dto.getPayCashPayAmount_02())  setValue_chk( odsBean, Column, Line +  30,dto.getPayCashPayAmount_02());	// xz_02
		if( null != dto.getPayDeduction_27_02())   setValue_chk( odsBean, Column, Line +  31,dto.getPayDeduction_27_02());	// ^T27_02

		Line   =  8;
		Column =  9; // 3
		if( null != dto.getPayPayday_03())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_03()); 		// ^x_03
		if( null != dto.getPayAllowance_01_03())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_03()); 	// ^x01_03
		if( null != dto.getPayAllowance_02_03())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_03()); 	// ^x02_03
		if( null != dto.getPayAllowance_03_03())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_03()); 	// ^x03_03
		if( null != dto.getPayAllowance_04_03())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_03()); 	// ^x04_03
		if( null != dto.getPayAllowance_05_03())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_03()); 	// ^x05_03
		if( null != dto.getPayAllowance_06_03())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_03()); 	// ^x06_03
		if( null != dto.getPayAllowance_07_03())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_03()); 	// ^x07_03
		if( null != dto.getPayAllowance_08_03())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_03()); 	// ^x08_03
		if( null != dto.getPayAllowance_09_03())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_03()); 	// ^x09_03
		if( null != dto.getPayAllowance_10_03())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_03()); 	// ^x10_03
		if( null != dto.getPayAllowance_11_03())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_03()); 	// ^x11_03
		if( null != dto.getPayAllowance_12_03())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_03()); 	// ^x12_03
		if( null != dto.getPayAllowance_13_03())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_03()); 	// ^x13_03
		if( null != dto.getPayAllowance_14_03())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_03()); 	// ^x14_03
		if( null != dto.getPayAllowance_15_03())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_03()); 	// ^x15_03
		if( null != dto.getPayAllowance_16_03())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_03()); 	// ^x16_03
		if( null != dto.getPayAllowance_17_03())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_03()); 	// ^x17_03
		if( null != dto.getPayAllowance_18_03())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_03()); 	// ^x18_03
		if( null != dto.getPayAllowance_19_03())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_03()); 	// ^x19_03
		if( null != dto.getPayAllowance_20_03())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_03()); 	// ^x20_03
		if( null != dto.getPayAllowance_21_03())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_03()); 	// ^x21_03
		if( null != dto.getPayAllowance_22_03())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_03()); 	// ^x22_03
		if( null != dto.getPayAllowance_23_03())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_03()); 	// ^x23_03
		if( null != dto.getPayAllowance_24_03())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_03()); 	// ^x24_03
		if( null != dto.getPayAllowance_25_03())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_03()); 	// ^x25_03
		if( null != dto.getPayAllowance_26_03())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_03()); 	// ^x26_03
		if( null != dto.getPayAllowance_27_03())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_03()); 	// ^x27_03
		if( null != dto.getPayAllowance_28_03())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_03()); 	// ^x28_03
		if( null != dto.getPayAllowance_29_03())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_03()); 	// ^x29_03
		if( null != dto.getPayAllowance_30_03())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_03()); 	// ^x30_03
		if( null != dto.getPayAllowanceTotal_03()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_03()); // ^xz_03
		Line   =  40;
		if( null != dto.getPayDeduction_01_03())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_03());	// ^T01_03
		if( null != dto.getPayDeduction_02_03())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_03());	// ^T02_03
		if( null != dto.getPayDeduction_03_03())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_03());	// ^T03_03
		if( null != dto.getPayDeduction_04_03())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_03());	// ^T04_03
		if( null != dto.getPayDeduction_05_03())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_03());	// ^T05_03
		if( null != dto.getPayDeduction_06_03())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_03());	// ^T06_03
		if( null != dto.getPayDeduction_07_03())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_03());	// ^T07_03
		if( null != dto.getPayDeduction_08_03())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_03());	// ^T08_03
		if( null != dto.getPayDeduction_09_03())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_03());	// ^T09_03
		if( null != dto.getPayDeduction_10_03())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_03());	// ^T10_03
		if( null != dto.getPayDeduction_11_03())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_03());	// ^T11_03
		if( null != dto.getPayDeduction_12_03())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_03());	// ^T12_03
		if( null != dto.getPayDeduction_14_03())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_03());	// ^T14_03
		if( null != dto.getPayDeduction_15_03())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_03());	// ^T15_03
		if( null != dto.getPayDeduction_16_03())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_03());	// ^T16_03
		if( null != dto.getPayDeduction_17_03())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_03());	// ^T17_03
		if( null != dto.getPayDeduction_18_03())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_03());	// ^T18_03
		if( null != dto.getPayDeduction_19_03())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_03());	// ^T19_03
		if( null != dto.getPayDeduction_20_03())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_03());	// ^T20_03
		if( null != dto.getPayDeduction_21_03())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_03());	// ^T21_03
		if( null != dto.getPayDeduction_22_03())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_03());	// ^T22_03
		if( null != dto.getPayDeduction_23_03())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_03());	// ^T23_03
		if( null != dto.getPayDeduction_24_03())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_03());	// ^T24_03
		if( null != dto.getPayDeduction_25_03())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_03());	// ^T25_03
		if( null != dto.getPayDeductionTotal_03()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_03());	// ^Tz_03
		if( null != dto.getPayDeduction_26_03())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_03());	// ^T26_03
		if( null != dto.getPayPaymentTotal_03())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_03());	// ^xz_03
		if( null != dto.getPayBank1PayAmount_03()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_03());	// ^s1Uz_03
		if( null != dto.getPayBank2PayAmount_03()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_03());	// ^s2Uz_03
		if( null != dto.getPayCashPayAmount_03())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_03());	// xz_03
		if( null != dto.getPayDeduction_27_03())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_03());	// ^T27_03

		Line   =  8;
		Column =  12; // 4
		if( null != dto.getPayPayday_04())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_04()); 		// ^x_04
		if( null != dto.getPayAllowance_01_04())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_04()); 	// ^x01_04
		if( null != dto.getPayAllowance_02_04())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_04()); 	// ^x02_04
		if( null != dto.getPayAllowance_03_04())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_04()); 	// ^x03_04
		if( null != dto.getPayAllowance_04_04())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_04()); 	// ^x04_04
		if( null != dto.getPayAllowance_05_04())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_04()); 	// ^x05_04
		if( null != dto.getPayAllowance_06_04())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_04()); 	// ^x06_04
		if( null != dto.getPayAllowance_07_04())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_04()); 	// ^x07_04
		if( null != dto.getPayAllowance_08_04())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_04()); 	// ^x08_04
		if( null != dto.getPayAllowance_09_04())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_04()); 	// ^x09_04
		if( null != dto.getPayAllowance_10_04())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_04()); 	// ^x10_04
		if( null != dto.getPayAllowance_11_04())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_04()); 	// ^x11_04
		if( null != dto.getPayAllowance_12_04())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_04()); 	// ^x12_04
		if( null != dto.getPayAllowance_13_04())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_04()); 	// ^x13_04
		if( null != dto.getPayAllowance_14_04())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_04()); 	// ^x14_04
		if( null != dto.getPayAllowance_15_04())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_04()); 	// ^x15_04
		if( null != dto.getPayAllowance_16_04())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_04()); 	// ^x16_04
		if( null != dto.getPayAllowance_17_04())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_04()); 	// ^x17_04
		if( null != dto.getPayAllowance_18_04())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_04()); 	// ^x18_04
		if( null != dto.getPayAllowance_19_04())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_04()); 	// ^x19_04
		if( null != dto.getPayAllowance_20_04())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_04()); 	// ^x20_04
		if( null != dto.getPayAllowance_21_04())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_04()); 	// ^x21_04
		if( null != dto.getPayAllowance_22_04())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_04()); 	// ^x22_04
		if( null != dto.getPayAllowance_23_04())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_04()); 	// ^x23_04
		if( null != dto.getPayAllowance_24_04())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_04()); 	// ^x24_04
		if( null != dto.getPayAllowance_25_04())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_04()); 	// ^x25_04
		if( null != dto.getPayAllowance_26_04())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_04()); 	// ^x26_04
		if( null != dto.getPayAllowance_27_04())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_04()); 	// ^x27_04
		if( null != dto.getPayAllowance_28_04())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_04()); 	// ^x28_04
		if( null != dto.getPayAllowance_29_04())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_04()); 	// ^x29_04
		if( null != dto.getPayAllowance_30_04())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_04()); 	// ^x30_04
		if( null != dto.getPayAllowanceTotal_04()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_04()); // ^xz_04
		Line   =  40;
		if( null != dto.getPayDeduction_01_04())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_04()); 	// ^T01_04
		if( null != dto.getPayDeduction_02_04())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_04()); 	// ^T02_04
		if( null != dto.getPayDeduction_03_04())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_04()); 	// ^T03_04
		if( null != dto.getPayDeduction_04_04())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_04()); 	// ^T04_04
		if( null != dto.getPayDeduction_05_04())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_04()); 	// ^T05_04
		if( null != dto.getPayDeduction_06_04())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_04()); 	// ^T06_04
		if( null != dto.getPayDeduction_07_04())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_04()); 	// ^T07_04
		if( null != dto.getPayDeduction_08_04())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_04()); 	// ^T08_04
		if( null != dto.getPayDeduction_09_04())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_04()); 	// ^T09_04
		if( null != dto.getPayDeduction_10_04())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_04()); 	// ^T10_04
		if( null != dto.getPayDeduction_11_04())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_04()); 	// ^T11_04
		if( null != dto.getPayDeduction_12_04())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_04()); 	// ^T12_04
		if( null != dto.getPayDeduction_14_04())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_04()); 	// ^T14_04
		if( null != dto.getPayDeduction_15_04())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_04()); 	// ^T15_04
		if( null != dto.getPayDeduction_16_04())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_04()); 	// ^T16_04
		if( null != dto.getPayDeduction_17_04())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_04()); 	// ^T17_04
		if( null != dto.getPayDeduction_18_04())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_04()); 	// ^T18_04
		if( null != dto.getPayDeduction_19_04())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_04()); 	// ^T19_04
		if( null != dto.getPayDeduction_20_04())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_04()); 	// ^T20_04
		if( null != dto.getPayDeduction_21_04())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_04()); 	// ^T21_04
		if( null != dto.getPayDeduction_22_04())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_04()); 	// ^T22_04
		if( null != dto.getPayDeduction_23_04())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_04()); 	// ^T23_04
		if( null != dto.getPayDeduction_24_04())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_04()); 	// ^T24_04
		if( null != dto.getPayDeduction_25_04())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_04()); 	// ^T25_04
		if( null != dto.getPayDeductionTotal_04()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_04()); // ^Tz_04
		if( null != dto.getPayDeduction_26_04())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_04()); 	// ^T26_04
		if( null != dto.getPayPaymentTotal_04())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_04()); 	// ^xz_04
		if( null != dto.getPayBank1PayAmount_04()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_04()); // ^s1Uz_04
		if( null != dto.getPayBank2PayAmount_04()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_04()); // ^s2Uz_04
		if( null != dto.getPayCashPayAmount_04())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_04());	// xz_04
		if( null != dto.getPayDeduction_27_04())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_04()); 	// ^T27_04

		Line   =  8;
		Column =  15; // 5
		if( null != dto.getPayPayday_05())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_05()); 		// ^x_05
		if( null != dto.getPayAllowance_01_05())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_05()); 	// ^x01_05
		if( null != dto.getPayAllowance_02_05())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_05()); 	// ^x02_05
		if( null != dto.getPayAllowance_03_05())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_05()); 	// ^x03_05
		if( null != dto.getPayAllowance_04_05())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_05()); 	// ^x04_05
		if( null != dto.getPayAllowance_05_05())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_05()); 	// ^x05_05
		if( null != dto.getPayAllowance_06_05())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_05()); 	// ^x06_05
		if( null != dto.getPayAllowance_07_05())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_05()); 	// ^x07_05
		if( null != dto.getPayAllowance_08_05())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_05()); 	// ^x08_05
		if( null != dto.getPayAllowance_09_05())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_05()); 	// ^x09_05
		if( null != dto.getPayAllowance_10_05())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_05()); 	// ^x10_05
		if( null != dto.getPayAllowance_11_05())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_05()); 	// ^x11_05
		if( null != dto.getPayAllowance_12_05())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_05()); 	// ^x12_05
		if( null != dto.getPayAllowance_13_05())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_05()); 	// ^x13_05
		if( null != dto.getPayAllowance_14_05())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_05()); 	// ^x14_05
		if( null != dto.getPayAllowance_15_05())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_05()); 	// ^x15_05
		if( null != dto.getPayAllowance_16_05())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_05()); 	// ^x16_05
		if( null != dto.getPayAllowance_17_05())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_05()); 	// ^x17_05
		if( null != dto.getPayAllowance_18_05())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_05()); 	// ^x18_05
		if( null != dto.getPayAllowance_19_05())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_05()); 	// ^x19_05
		if( null != dto.getPayAllowance_20_05())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_05()); 	// ^x20_05
		if( null != dto.getPayAllowance_21_05())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_05()); 	// ^x21_05
		if( null != dto.getPayAllowance_22_05())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_05()); 	// ^x22_05
		if( null != dto.getPayAllowance_23_05())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_05()); 	// ^x23_05
		if( null != dto.getPayAllowance_24_05())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_05()); 	// ^x24_05
		if( null != dto.getPayAllowance_25_05())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_05()); 	// ^x25_05
		if( null != dto.getPayAllowance_26_05())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_05()); 	// ^x26_05
		if( null != dto.getPayAllowance_27_05())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_05()); 	// ^x27_05
		if( null != dto.getPayAllowance_28_05())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_05()); 	// ^x28_05
		if( null != dto.getPayAllowance_29_05())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_05()); 	// ^x29_05
		if( null != dto.getPayAllowance_30_05())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_05()); 	// ^x30_05
		if( null != dto.getPayAllowanceTotal_05()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_05()); // ^xz_05
		Line   =  40;
		if( null != dto.getPayDeduction_01_05())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_05()); 	// ^T01_05
		if( null != dto.getPayDeduction_02_05())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_05()); 	// ^T02_05
		if( null != dto.getPayDeduction_03_05())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_05()); 	// ^T03_05
		if( null != dto.getPayDeduction_04_05())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_05()); 	// ^T04_05
		if( null != dto.getPayDeduction_05_05())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_05()); 	// ^T05_05
		if( null != dto.getPayDeduction_06_05())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_05()); 	// ^T06_05
		if( null != dto.getPayDeduction_07_05())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_05()); 	// ^T07_05
		if( null != dto.getPayDeduction_08_05())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_05()); 	// ^T08_05
		if( null != dto.getPayDeduction_09_05())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_05()); 	// ^T09_05
		if( null != dto.getPayDeduction_10_05())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_05()); 	// ^T10_05
		if( null != dto.getPayDeduction_11_05())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_05()); 	// ^T11_05
		if( null != dto.getPayDeduction_12_05())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_05()); 	// ^T12_05
		if( null != dto.getPayDeduction_14_05())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_05()); 	// ^T14_05
		if( null != dto.getPayDeduction_15_05())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_05()); 	// ^T15_05
		if( null != dto.getPayDeduction_16_05())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_05()); 	// ^T16_05
		if( null != dto.getPayDeduction_17_05())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_05()); 	// ^T17_05
		if( null != dto.getPayDeduction_18_05())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_05()); 	// ^T18_05
		if( null != dto.getPayDeduction_19_05())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_05()); 	// ^T19_05
		if( null != dto.getPayDeduction_20_05())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_05()); 	// ^T20_05
		if( null != dto.getPayDeduction_21_05())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_05()); 	// ^T21_05
		if( null != dto.getPayDeduction_22_05())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_05()); 	// ^T22_05
		if( null != dto.getPayDeduction_23_05())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_05()); 	// ^T23_05
		if( null != dto.getPayDeduction_24_05())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_05()); 	// ^T24_05
		if( null != dto.getPayDeduction_25_05())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_05()); 	// ^T25_05
		if( null != dto.getPayDeductionTotal_05()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_05()); // ^Tz_05
		if( null != dto.getPayDeduction_26_05())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_05()); 	// ^T26_05
		if( null != dto.getPayPaymentTotal_05())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_05()); 	// ^xz_05
		if( null != dto.getPayBank1PayAmount_05()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_05()); // ^s1Uz_05
		if( null != dto.getPayBank2PayAmount_05()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_05()); // ^s2Uz_05
		if( null != dto.getPayCashPayAmount_05())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_05());	// xz_05
		if( null != dto.getPayDeduction_27_05())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_05()); 	// ^T27_05

		Line   =  8;
		Column =  18; // 6
		if( null != dto.getPayPayday_06())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_06()); 		// ^x_06
		if( null != dto.getPayAllowance_01_06())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_06()); 	// ^x01_06
		if( null != dto.getPayAllowance_02_06())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_06()); 	// ^x02_06
		if( null != dto.getPayAllowance_03_06())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_06()); 	// ^x03_06
		if( null != dto.getPayAllowance_04_06())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_06()); 	// ^x04_06
		if( null != dto.getPayAllowance_05_06())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_06()); 	// ^x05_06
		if( null != dto.getPayAllowance_06_06())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_06()); 	// ^x06_06
		if( null != dto.getPayAllowance_07_06())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_06()); 	// ^x07_06
		if( null != dto.getPayAllowance_08_06())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_06()); 	// ^x08_06
		if( null != dto.getPayAllowance_09_06())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_06()); 	// ^x09_06
		if( null != dto.getPayAllowance_10_06())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_06()); 	// ^x10_06
		if( null != dto.getPayAllowance_11_06())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_06()); 	// ^x11_06
		if( null != dto.getPayAllowance_12_06())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_06()); 	// ^x12_06
		if( null != dto.getPayAllowance_13_06())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_06()); 	// ^x13_06
		if( null != dto.getPayAllowance_14_06())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_06()); 	// ^x14_06
		if( null != dto.getPayAllowance_15_06())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_06()); 	// ^x15_06
		if( null != dto.getPayAllowance_16_06())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_06()); 	// ^x16_06
		if( null != dto.getPayAllowance_17_06())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_06()); 	// ^x17_06
		if( null != dto.getPayAllowance_18_06())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_06()); 	// ^x18_06
		if( null != dto.getPayAllowance_19_06())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_06()); 	// ^x19_06
		if( null != dto.getPayAllowance_20_06())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_06()); 	// ^x20_06
		if( null != dto.getPayAllowance_21_06())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_06()); 	// ^x21_06
		if( null != dto.getPayAllowance_22_06())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_06()); 	// ^x22_06
		if( null != dto.getPayAllowance_23_06())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_06()); 	// ^x23_06
		if( null != dto.getPayAllowance_24_06())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_06()); 	// ^x24_06
		if( null != dto.getPayAllowance_25_06())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_06()); 	// ^x25_06
		if( null != dto.getPayAllowance_26_06())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_06()); 	// ^x26_06
		if( null != dto.getPayAllowance_27_06())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_06()); 	// ^x27_06
		if( null != dto.getPayAllowance_28_06())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_06()); 	// ^x28_06
		if( null != dto.getPayAllowance_29_06())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_06()); 	// ^x29_06
		if( null != dto.getPayAllowance_30_06())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_06()); 	// ^x30_06
		if( null != dto.getPayAllowanceTotal_06()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_06()); // ^xz_06
		Line   =  40;
		if( null != dto.getPayDeduction_01_06())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_06()); 	// ^T01_06
		if( null != dto.getPayDeduction_02_06())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_06()); 	// ^T02_06
		if( null != dto.getPayDeduction_03_06())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_06()); 	// ^T03_06
		if( null != dto.getPayDeduction_04_06())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_06()); 	// ^T04_06
		if( null != dto.getPayDeduction_05_06())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_06()); 	// ^T05_06
		if( null != dto.getPayDeduction_06_06())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_06()); 	// ^T06_06
		if( null != dto.getPayDeduction_07_06())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_06()); 	// ^T07_06
		if( null != dto.getPayDeduction_08_06())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_06()); 	// ^T08_06
		if( null != dto.getPayDeduction_09_06())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_06()); 	// ^T09_06
		if( null != dto.getPayDeduction_10_06())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_06()); 	// ^T10_06
		if( null != dto.getPayDeduction_11_06())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_06()); 	// ^T11_06
		if( null != dto.getPayDeduction_12_06())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_06()); 	// ^T12_06
		if( null != dto.getPayDeduction_14_06())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_06()); 	// ^T14_06
		if( null != dto.getPayDeduction_15_06())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_06()); 	// ^T15_06
		if( null != dto.getPayDeduction_16_06())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_06()); 	// ^T16_06
		if( null != dto.getPayDeduction_17_06())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_06()); 	// ^T17_06
		if( null != dto.getPayDeduction_18_06())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_06()); 	// ^T18_06
		if( null != dto.getPayDeduction_19_06())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_06()); 	// ^T19_06
		if( null != dto.getPayDeduction_20_06())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_06()); 	// ^T20_06
		if( null != dto.getPayDeduction_21_06())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_06()); 	// ^T21_06
		if( null != dto.getPayDeduction_22_06())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_06()); 	// ^T22_06
		if( null != dto.getPayDeduction_23_06())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_06()); 	// ^T23_06
		if( null != dto.getPayDeduction_24_06())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_06()); 	// ^T24_06
		if( null != dto.getPayDeduction_25_06())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_06()); 	// ^T25_06
		if( null != dto.getPayDeductionTotal_06()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_06()); // ^Tz_06
		if( null != dto.getPayDeduction_26_06())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_06()); 	// ^T26_06
		if( null != dto.getPayPaymentTotal_06())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_06()); 	// ^xz_06
		if( null != dto.getPayBank1PayAmount_06()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_06()); // ^s1Uz_06
		if( null != dto.getPayBank2PayAmount_06()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_06()); // ^s2Uz_06
		if( null != dto.getPayCashPayAmount_06())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_06());	// xz_06
		if( null != dto.getPayDeduction_27_06())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_06()); 	// ^T27_06

		Line   =  8;
		Column =  21; // 7
		if( null != dto.getPayPayday_07())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_07()); 		// ^x_07
		if( null != dto.getPayAllowance_01_07())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_07()); 	// ^x01_07
		if( null != dto.getPayAllowance_02_07())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_07()); 	// ^x02_07
		if( null != dto.getPayAllowance_03_07())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_07()); 	// ^x03_07
		if( null != dto.getPayAllowance_04_07())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_07()); 	// ^x04_07
		if( null != dto.getPayAllowance_05_07())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_07()); 	// ^x05_07
		if( null != dto.getPayAllowance_06_07())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_07()); 	// ^x06_07
		if( null != dto.getPayAllowance_07_07())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_07()); 	// ^x07_07
		if( null != dto.getPayAllowance_08_07())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_07()); 	// ^x08_07
		if( null != dto.getPayAllowance_09_07())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_07()); 	// ^x09_07
		if( null != dto.getPayAllowance_10_07())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_07()); 	// ^x10_07
		if( null != dto.getPayAllowance_11_07())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_07()); 	// ^x11_07
		if( null != dto.getPayAllowance_12_07())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_07()); 	// ^x12_07
		if( null != dto.getPayAllowance_13_07())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_07()); 	// ^x13_07
		if( null != dto.getPayAllowance_14_07())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_07()); 	// ^x14_07
		if( null != dto.getPayAllowance_15_07())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_07()); 	// ^x15_07
		if( null != dto.getPayAllowance_16_07())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_07()); 	// ^x16_07
		if( null != dto.getPayAllowance_17_07())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_07()); 	// ^x17_07
		if( null != dto.getPayAllowance_18_07())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_07()); 	// ^x18_07
		if( null != dto.getPayAllowance_19_07())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_07()); 	// ^x19_07
		if( null != dto.getPayAllowance_20_07())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_07()); 	// ^x20_07
		if( null != dto.getPayAllowance_21_07())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_07()); 	// ^x21_07
		if( null != dto.getPayAllowance_22_07())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_07()); 	// ^x22_07
		if( null != dto.getPayAllowance_23_07())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_07()); 	// ^x23_07
		if( null != dto.getPayAllowance_24_07())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_07()); 	// ^x24_07
		if( null != dto.getPayAllowance_25_07())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_07()); 	// ^x25_07
		if( null != dto.getPayAllowance_26_07())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_07()); 	// ^x26_07
		if( null != dto.getPayAllowance_27_07())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_07()); 	// ^x27_07
		if( null != dto.getPayAllowance_28_07())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_07()); 	// ^x28_07
		if( null != dto.getPayAllowance_29_07())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_07()); 	// ^x29_07
		if( null != dto.getPayAllowance_30_07())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_07()); 	// ^x30_07
		if( null != dto.getPayAllowanceTotal_07()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_07()); // ^xz_07
		Line   =  40;
		if( null != dto.getPayDeduction_01_07())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_07()); 	// ^T01_07
		if( null != dto.getPayDeduction_02_07())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_07()); 	// ^T02_07
		if( null != dto.getPayDeduction_03_07())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_07()); 	// ^T03_07
		if( null != dto.getPayDeduction_04_07())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_07()); 	// ^T04_07
		if( null != dto.getPayDeduction_05_07())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_07()); 	// ^T05_07
		if( null != dto.getPayDeduction_06_07())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_07()); 	// ^T06_07
		if( null != dto.getPayDeduction_07_07())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_07()); 	// ^T07_07
		if( null != dto.getPayDeduction_08_07())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_07()); 	// ^T08_07
		if( null != dto.getPayDeduction_09_07())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_07()); 	// ^T09_07
		if( null != dto.getPayDeduction_10_07())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_07()); 	// ^T10_07
		if( null != dto.getPayDeduction_11_07())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_07()); 	// ^T11_07
		if( null != dto.getPayDeduction_12_07())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_07()); 	// ^T12_07
		if( null != dto.getPayDeduction_14_07())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_07()); 	// ^T14_07
		if( null != dto.getPayDeduction_15_07())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_07()); 	// ^T15_07
		if( null != dto.getPayDeduction_16_07())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_07()); 	// ^T16_07
		if( null != dto.getPayDeduction_17_07())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_07()); 	// ^T17_07
		if( null != dto.getPayDeduction_18_07())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_07()); 	// ^T18_07
		if( null != dto.getPayDeduction_19_07())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_07()); 	// ^T19_07
		if( null != dto.getPayDeduction_20_07())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_07()); 	// ^T20_07
		if( null != dto.getPayDeduction_21_07())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_07()); 	// ^T21_07
		if( null != dto.getPayDeduction_22_07())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_07()); 	// ^T22_07
		if( null != dto.getPayDeduction_23_07())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_07()); 	// ^T23_07
		if( null != dto.getPayDeduction_24_07())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_07()); 	// ^T24_07
		if( null != dto.getPayDeduction_25_07())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_07()); 	// ^T25_07
		if( null != dto.getPayDeductionTotal_07()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_07()); // ^Tz_07
		if( null != dto.getPayDeduction_26_07())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_07()); 	// ^T26_07
		if( null != dto.getPayPaymentTotal_07())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_07()); 	// ^xz_07
		if( null != dto.getPayBank1PayAmount_07()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_07()); // ^s1Uz_07
		if( null != dto.getPayBank2PayAmount_07()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_07()); // ^s2Uz_07
		if( null != dto.getPayCashPayAmount_07())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_07());	// xz_07
		if( null != dto.getPayDeduction_27_07())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_07()); 	// ^T27_07

		Line   =  8;
		Column =  24; // 8
		if( null != dto.getPayPayday_08())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_08()); 		// ^x_08
		if( null != dto.getPayAllowance_01_08())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_08()); 	// ^x01_08
		if( null != dto.getPayAllowance_02_08())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_08()); 	// ^x02_08
		if( null != dto.getPayAllowance_03_08())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_08()); 	// ^x03_08
		if( null != dto.getPayAllowance_04_08())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_08()); 	// ^x04_08
		if( null != dto.getPayAllowance_05_08())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_08()); 	// ^x05_08
		if( null != dto.getPayAllowance_06_08())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_08()); 	// ^x06_08
		if( null != dto.getPayAllowance_07_08())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_08()); 	// ^x07_08
		if( null != dto.getPayAllowance_08_08())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_08()); 	// ^x08_08
		if( null != dto.getPayAllowance_09_08())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_08()); 	// ^x09_08
		if( null != dto.getPayAllowance_10_08())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_08()); 	// ^x10_08
		if( null != dto.getPayAllowance_11_08())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_08()); 	// ^x11_08
		if( null != dto.getPayAllowance_12_08())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_08()); 	// ^x12_08
		if( null != dto.getPayAllowance_13_08())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_08()); 	// ^x13_08
		if( null != dto.getPayAllowance_14_08())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_08()); 	// ^x14_08
		if( null != dto.getPayAllowance_15_08())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_08()); 	// ^x15_08
		if( null != dto.getPayAllowance_16_08())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_08()); 	// ^x16_08
		if( null != dto.getPayAllowance_17_08())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_08()); 	// ^x17_08
		if( null != dto.getPayAllowance_18_08())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_08()); 	// ^x18_08
		if( null != dto.getPayAllowance_19_08())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_08()); 	// ^x19_08
		if( null != dto.getPayAllowance_20_08())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_08()); 	// ^x20_08
		if( null != dto.getPayAllowance_21_08())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_08()); 	// ^x21_08
		if( null != dto.getPayAllowance_22_08())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_08()); 	// ^x22_08
		if( null != dto.getPayAllowance_23_08())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_08()); 	// ^x23_08
		if( null != dto.getPayAllowance_24_08())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_08()); 	// ^x24_08
		if( null != dto.getPayAllowance_25_08())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_08()); 	// ^x25_08
		if( null != dto.getPayAllowance_26_08())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_08()); 	// ^x26_08
		if( null != dto.getPayAllowance_27_08())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_08()); 	// ^x27_08
		if( null != dto.getPayAllowance_28_08())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_08()); 	// ^x28_08
		if( null != dto.getPayAllowance_29_08())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_08()); 	// ^x29_08
		if( null != dto.getPayAllowance_30_08())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_08()); 	// ^x30_08
		if( null != dto.getPayAllowanceTotal_08()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_08()); // ^xz_08
		Line   =  40;
		if( null != dto.getPayDeduction_01_08())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_08()); 	// ^T01_08
		if( null != dto.getPayDeduction_02_08())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_08()); 	// ^T02_08
		if( null != dto.getPayDeduction_03_08())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_08()); 	// ^T03_08
		if( null != dto.getPayDeduction_04_08())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_08()); 	// ^T04_08
		if( null != dto.getPayDeduction_05_08())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_08()); 	// ^T05_08
		if( null != dto.getPayDeduction_06_08())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_08()); 	// ^T06_08
		if( null != dto.getPayDeduction_07_08())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_08()); 	// ^T07_08
		if( null != dto.getPayDeduction_08_08())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_08()); 	// ^T08_08
		if( null != dto.getPayDeduction_09_08())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_08()); 	// ^T09_08
		if( null != dto.getPayDeduction_10_08())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_08()); 	// ^T10_08
		if( null != dto.getPayDeduction_11_08())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_08()); 	// ^T11_08
		if( null != dto.getPayDeduction_12_08())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_08()); 	// ^T12_08
		if( null != dto.getPayDeduction_14_08())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_08()); 	// ^T14_08
		if( null != dto.getPayDeduction_15_08())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_08()); 	// ^T15_08
		if( null != dto.getPayDeduction_16_08())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_08()); 	// ^T16_08
		if( null != dto.getPayDeduction_17_08())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_08()); 	// ^T17_08
		if( null != dto.getPayDeduction_18_08())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_08()); 	// ^T18_08
		if( null != dto.getPayDeduction_19_08())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_08()); 	// ^T19_08
		if( null != dto.getPayDeduction_20_08())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_08()); 	// ^T20_08
		if( null != dto.getPayDeduction_21_08())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_08()); 	// ^T21_08
		if( null != dto.getPayDeduction_22_08())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_08()); 	// ^T22_08
		if( null != dto.getPayDeduction_23_08())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_08()); 	// ^T23_08
		if( null != dto.getPayDeduction_24_08())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_08()); 	// ^T24_08
		if( null != dto.getPayDeduction_25_08())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_08()); 	// ^T25_08
		if( null != dto.getPayDeductionTotal_08()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_08()); // ^Tz_08
		if( null != dto.getPayDeduction_26_08())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_08()); 	// ^T26_08
		if( null != dto.getPayPaymentTotal_08())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_08()); 	// ^xz_08
		if( null != dto.getPayBank1PayAmount_08()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_08()); // ^s1Uz_08
		if( null != dto.getPayBank2PayAmount_08()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_08()); // ^s2Uz_08
		if( null != dto.getPayCashPayAmount_08())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_08());	// xz_08
		if( null != dto.getPayDeduction_27_08())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_08()); 	// ^T27_08

		Line   =  8;
		Column =  27; // 9
		if( null != dto.getPayPayday_09())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_09()); 		// ^x_09
		if( null != dto.getPayAllowance_01_09())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_09()); 	// ^x01_09
		if( null != dto.getPayAllowance_02_09())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_09()); 	// ^x02_09
		if( null != dto.getPayAllowance_03_09())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_09()); 	// ^x03_09
		if( null != dto.getPayAllowance_04_09())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_09()); 	// ^x04_09
		if( null != dto.getPayAllowance_05_09())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_09()); 	// ^x05_09
		if( null != dto.getPayAllowance_06_09())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_09()); 	// ^x06_09
		if( null != dto.getPayAllowance_07_09())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_09()); 	// ^x07_09
		if( null != dto.getPayAllowance_08_09())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_09()); 	// ^x08_09
		if( null != dto.getPayAllowance_09_09())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_09()); 	// ^x09_09
		if( null != dto.getPayAllowance_10_09())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_09()); 	// ^x10_09
		if( null != dto.getPayAllowance_11_09())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_09()); 	// ^x11_09
		if( null != dto.getPayAllowance_12_09())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_09()); 	// ^x12_09
		if( null != dto.getPayAllowance_13_09())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_09()); 	// ^x13_09
		if( null != dto.getPayAllowance_14_09())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_09()); 	// ^x14_09
		if( null != dto.getPayAllowance_15_09())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_09()); 	// ^x15_09
		if( null != dto.getPayAllowance_16_09())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_09()); 	// ^x16_09
		if( null != dto.getPayAllowance_17_09())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_09()); 	// ^x17_09
		if( null != dto.getPayAllowance_18_09())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_09()); 	// ^x18_09
		if( null != dto.getPayAllowance_19_09())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_09()); 	// ^x19_09
		if( null != dto.getPayAllowance_20_09())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_09()); 	// ^x20_09
		if( null != dto.getPayAllowance_21_09())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_09()); 	// ^x21_09
		if( null != dto.getPayAllowance_22_09())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_09()); 	// ^x22_09
		if( null != dto.getPayAllowance_23_09())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_09()); 	// ^x23_09
		if( null != dto.getPayAllowance_24_09())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_09()); 	// ^x24_09
		if( null != dto.getPayAllowance_25_09())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_09()); 	// ^x25_09
		if( null != dto.getPayAllowance_26_09())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_09()); 	// ^x26_09
		if( null != dto.getPayAllowance_27_09())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_09()); 	// ^x27_09
		if( null != dto.getPayAllowance_28_09())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_09()); 	// ^x28_09
		if( null != dto.getPayAllowance_29_09())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_09()); 	// ^x29_09
		if( null != dto.getPayAllowance_30_09())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_09()); 	// ^x30_09
		if( null != dto.getPayAllowanceTotal_09()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_09()); // ^xz_09
		Line   =  40;
		if( null != dto.getPayDeduction_01_09())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_09()); 	// ^T01_09
		if( null != dto.getPayDeduction_02_09())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_09()); 	// ^T02_09
		if( null != dto.getPayDeduction_03_09())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_09()); 	// ^T03_09
		if( null != dto.getPayDeduction_04_09())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_09()); 	// ^T04_09
		if( null != dto.getPayDeduction_05_09())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_09()); 	// ^T05_09
		if( null != dto.getPayDeduction_06_09())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_09()); 	// ^T06_09
		if( null != dto.getPayDeduction_07_09())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_09()); 	// ^T07_09
		if( null != dto.getPayDeduction_08_09())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_09()); 	// ^T08_09
		if( null != dto.getPayDeduction_09_09())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_09()); 	// ^T09_09
		if( null != dto.getPayDeduction_10_09())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_09()); 	// ^T10_09
		if( null != dto.getPayDeduction_11_09())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_09()); 	// ^T11_09
		if( null != dto.getPayDeduction_12_09())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_09()); 	// ^T12_09
		if( null != dto.getPayDeduction_14_09())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_09()); 	// ^T14_09
		if( null != dto.getPayDeduction_15_09())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_09()); 	// ^T15_09
		if( null != dto.getPayDeduction_16_09())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_09()); 	// ^T16_09
		if( null != dto.getPayDeduction_17_09())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_09()); 	// ^T17_09
		if( null != dto.getPayDeduction_18_09())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_09()); 	// ^T18_09
		if( null != dto.getPayDeduction_19_09())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_09()); 	// ^T19_09
		if( null != dto.getPayDeduction_20_09())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_09()); 	// ^T20_09
		if( null != dto.getPayDeduction_21_09())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_09()); 	// ^T21_09
		if( null != dto.getPayDeduction_22_09())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_09()); 	// ^T22_09
		if( null != dto.getPayDeduction_23_09())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_09()); 	// ^T23_09
		if( null != dto.getPayDeduction_24_09())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_09()); 	// ^T24_09
		if( null != dto.getPayDeduction_25_09())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_09()); 	// ^T25_09
		if( null != dto.getPayDeductionTotal_09()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_09()); // ^Tz_09
		if( null != dto.getPayDeduction_26_09())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_09()); 	// ^T26_09
		if( null != dto.getPayPaymentTotal_09())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_09()); 	// ^xz_09
		if( null != dto.getPayBank1PayAmount_09()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_09()); // ^s1Uz_09
		if( null != dto.getPayBank2PayAmount_09()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_09()); // ^s2Uz_09
		if( null != dto.getPayCashPayAmount_09())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_09());	// xz_09
		if( null != dto.getPayDeduction_27_09())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_09()); 	// ^T27_09

		Line   =  8;
		Column =  30; // 10
		if( null != dto.getPayPayday_10())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_10()); 		// ^x_10
		if( null != dto.getPayAllowance_01_10())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_10()); 	// ^x01_10
		if( null != dto.getPayAllowance_02_10())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_10()); 	// ^x02_10
		if( null != dto.getPayAllowance_03_10())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_10()); 	// ^x03_10
		if( null != dto.getPayAllowance_04_10())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_10()); 	// ^x04_10
		if( null != dto.getPayAllowance_05_10())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_10()); 	// ^x05_10
		if( null != dto.getPayAllowance_06_10())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_10()); 	// ^x06_10
		if( null != dto.getPayAllowance_07_10())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_10()); 	// ^x07_10
		if( null != dto.getPayAllowance_08_10())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_10()); 	// ^x08_10
		if( null != dto.getPayAllowance_09_10())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_10()); 	// ^x09_10
		if( null != dto.getPayAllowance_10_10())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_10()); 	// ^x10_10
		if( null != dto.getPayAllowance_11_10())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_10()); 	// ^x11_10
		if( null != dto.getPayAllowance_12_10())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_10()); 	// ^x12_10
		if( null != dto.getPayAllowance_13_10())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_10()); 	// ^x13_10
		if( null != dto.getPayAllowance_14_10())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_10()); 	// ^x14_10
		if( null != dto.getPayAllowance_15_10())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_10()); 	// ^x15_10
		if( null != dto.getPayAllowance_16_10())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_10()); 	// ^x16_10
		if( null != dto.getPayAllowance_17_10())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_10()); 	// ^x17_10
		if( null != dto.getPayAllowance_18_10())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_10()); 	// ^x18_10
		if( null != dto.getPayAllowance_19_10())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_10()); 	// ^x19_10
		if( null != dto.getPayAllowance_20_10())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_10()); 	// ^x20_10
		if( null != dto.getPayAllowance_21_10())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_10()); 	// ^x21_10
		if( null != dto.getPayAllowance_22_10())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_10()); 	// ^x22_10
		if( null != dto.getPayAllowance_23_10())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_10()); 	// ^x23_10
		if( null != dto.getPayAllowance_24_10())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_10()); 	// ^x24_10
		if( null != dto.getPayAllowance_25_10())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_10()); 	// ^x25_10
		if( null != dto.getPayAllowance_26_10())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_10()); 	// ^x26_10
		if( null != dto.getPayAllowance_27_10())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_10()); 	// ^x27_10
		if( null != dto.getPayAllowance_28_10())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_10()); 	// ^x28_10
		if( null != dto.getPayAllowance_29_10())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_10()); 	// ^x29_10
		if( null != dto.getPayAllowance_30_10())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_10()); 	// ^x30_10
		if( null != dto.getPayAllowanceTotal_10()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_10()); // ^xz_10
		Line   =  40;
		if( null != dto.getPayDeduction_01_10())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_10()); 	// ^T01_10
		if( null != dto.getPayDeduction_02_10())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_10()); 	// ^T02_10
		if( null != dto.getPayDeduction_03_10())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_10()); 	// ^T03_10
		if( null != dto.getPayDeduction_04_10())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_10()); 	// ^T04_10
		if( null != dto.getPayDeduction_05_10())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_10()); 	// ^T05_10
		if( null != dto.getPayDeduction_06_10())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_10()); 	// ^T06_10
		if( null != dto.getPayDeduction_07_10())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_10()); 	// ^T07_10
		if( null != dto.getPayDeduction_08_10())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_10()); 	// ^T08_10
		if( null != dto.getPayDeduction_09_10())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_10()); 	// ^T09_10
		if( null != dto.getPayDeduction_10_10())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_10()); 	// ^T10_10
		if( null != dto.getPayDeduction_11_10())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_10()); 	// ^T11_10
		if( null != dto.getPayDeduction_12_10())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_10()); 	// ^T12_10
		if( null != dto.getPayDeduction_14_10())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_10()); 	// ^T14_10
		if( null != dto.getPayDeduction_15_10())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_10()); 	// ^T15_10
		if( null != dto.getPayDeduction_16_10())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_10()); 	// ^T16_10
		if( null != dto.getPayDeduction_17_10())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_10()); 	// ^T17_10
		if( null != dto.getPayDeduction_18_10())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_10()); 	// ^T18_10
		if( null != dto.getPayDeduction_19_10())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_10()); 	// ^T19_10
		if( null != dto.getPayDeduction_20_10())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_10()); 	// ^T20_10
		if( null != dto.getPayDeduction_21_10())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_10()); 	// ^T21_10
		if( null != dto.getPayDeduction_22_10())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_10()); 	// ^T22_10
		if( null != dto.getPayDeduction_23_10())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_10()); 	// ^T23_10
		if( null != dto.getPayDeduction_24_10())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_10()); 	// ^T24_10
		if( null != dto.getPayDeduction_25_10())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_10()); 	// ^T25_10
		if( null != dto.getPayDeductionTotal_10()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_10()); // ^Tz_10
		if( null != dto.getPayDeduction_26_10())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_10()); 	// ^T26_10
		if( null != dto.getPayPaymentTotal_10())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_10()); 	// ^xz_10
		if( null != dto.getPayBank1PayAmount_10()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_10()); // ^s1Uz_10
		if( null != dto.getPayBank2PayAmount_10()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_10()); // ^s2Uz_10
		if( null != dto.getPayCashPayAmount_10())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_10());	// xz_10
		if( null != dto.getPayDeduction_27_10())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_10()); 	// ^T27_10

		Line   =  8;
		Column =  33; // 11
		if( null != dto.getPayPayday_11())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_11()); 		// ^x_11
		if( null != dto.getPayAllowance_01_11())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_11()); 	// ^x01_11
		if( null != dto.getPayAllowance_02_11())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_11()); 	// ^x02_11
		if( null != dto.getPayAllowance_03_11())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_11()); 	// ^x03_11
		if( null != dto.getPayAllowance_04_11())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_11()); 	// ^x04_11
		if( null != dto.getPayAllowance_05_11())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_11()); 	// ^x05_11
		if( null != dto.getPayAllowance_06_11())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_11()); 	// ^x06_11
		if( null != dto.getPayAllowance_07_11())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_11()); 	// ^x07_11
		if( null != dto.getPayAllowance_08_11())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_11()); 	// ^x08_11
		if( null != dto.getPayAllowance_09_11())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_11()); 	// ^x09_11
		if( null != dto.getPayAllowance_10_11())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_11()); 	// ^x10_11
		if( null != dto.getPayAllowance_11_11())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_11()); 	// ^x11_11
		if( null != dto.getPayAllowance_12_11())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_11()); 	// ^x12_11
		if( null != dto.getPayAllowance_13_11())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_11()); 	// ^x13_11
		if( null != dto.getPayAllowance_14_11())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_11()); 	// ^x14_11
		if( null != dto.getPayAllowance_15_11())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_11()); 	// ^x15_11
		if( null != dto.getPayAllowance_16_11())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_11()); 	// ^x16_11
		if( null != dto.getPayAllowance_17_11())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_11()); 	// ^x17_11
		if( null != dto.getPayAllowance_18_11())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_11()); 	// ^x18_11
		if( null != dto.getPayAllowance_19_11())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_11()); 	// ^x19_11
		if( null != dto.getPayAllowance_20_11())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_11()); 	// ^x20_11
		if( null != dto.getPayAllowance_21_11())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_11()); 	// ^x21_11
		if( null != dto.getPayAllowance_22_11())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_11()); 	// ^x22_11
		if( null != dto.getPayAllowance_23_11())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_11()); 	// ^x23_11
		if( null != dto.getPayAllowance_24_11())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_11()); 	// ^x24_11
		if( null != dto.getPayAllowance_25_11())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_11()); 	// ^x25_11
		if( null != dto.getPayAllowance_26_11())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_11()); 	// ^x26_11
		if( null != dto.getPayAllowance_27_11())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_11()); 	// ^x27_11
		if( null != dto.getPayAllowance_28_11())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_11()); 	// ^x28_11
		if( null != dto.getPayAllowance_29_11())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_11()); 	// ^x29_11
		if( null != dto.getPayAllowance_30_11())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_11()); 	// ^x30_11
		if( null != dto.getPayAllowanceTotal_11()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_11()); // ^xz_11
		Line   =  40;
		if( null != dto.getPayDeduction_01_11())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_11()); 	// ^T01_11
		if( null != dto.getPayDeduction_02_11())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_11()); 	// ^T02_11
		if( null != dto.getPayDeduction_03_11())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_11()); 	// ^T03_11
		if( null != dto.getPayDeduction_04_11())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_11()); 	// ^T04_11
		if( null != dto.getPayDeduction_05_11())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_11()); 	// ^T05_11
		if( null != dto.getPayDeduction_06_11())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_11()); 	// ^T06_11
		if( null != dto.getPayDeduction_07_11())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_11()); 	// ^T07_11
		if( null != dto.getPayDeduction_08_11())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_11()); 	// ^T08_11
		if( null != dto.getPayDeduction_09_11())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_11()); 	// ^T09_11
		if( null != dto.getPayDeduction_10_11())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_11()); 	// ^T10_11
		if( null != dto.getPayDeduction_11_11())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_11()); 	// ^T11_11
		if( null != dto.getPayDeduction_12_11())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_11()); 	// ^T12_11
		if( null != dto.getPayDeduction_14_11())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_11()); 	// ^T14_11
		if( null != dto.getPayDeduction_15_11())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_11()); 	// ^T15_11
		if( null != dto.getPayDeduction_16_11())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_11()); 	// ^T16_11
		if( null != dto.getPayDeduction_17_11())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_11()); 	// ^T17_11
		if( null != dto.getPayDeduction_18_11())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_11()); 	// ^T18_11
		if( null != dto.getPayDeduction_19_11())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_11()); 	// ^T19_11
		if( null != dto.getPayDeduction_20_11())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_11()); 	// ^T20_11
		if( null != dto.getPayDeduction_21_11())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_11()); 	// ^T21_11
		if( null != dto.getPayDeduction_22_11())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_11()); 	// ^T22_11
		if( null != dto.getPayDeduction_23_11())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_11()); 	// ^T23_11
		if( null != dto.getPayDeduction_24_11())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_11()); 	// ^T24_11
		if( null != dto.getPayDeduction_25_11())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_11()); 	// ^T25_11
		if( null != dto.getPayDeductionTotal_11()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_11()); // ^Tz_11
		if( null != dto.getPayDeduction_26_11())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_11()); 	// ^T26_11
		if( null != dto.getPayPaymentTotal_11())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_11()); 	// ^xz_11
		if( null != dto.getPayBank1PayAmount_11()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_11()); // ^s1Uz_11
		if( null != dto.getPayBank2PayAmount_11()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_11()); // ^s2Uz_11
		if( null != dto.getPayCashPayAmount_11())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_11());	// xz_11
		if( null != dto.getPayDeduction_27_11())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_11()); 	// ^T27_11

		Line   =  8;
		Column =  36; // 12
		if( null != dto.getPayPayday_12())         setValue_chk( odsBean, Column, Line -   1, dto.getPayPayday_12()); 		// ^x_12
		if( null != dto.getPayAllowance_01_12())   setValue_chk( odsBean, Column, Line +   1, dto.getPayAllowance_01_12()); 	// ^x01_12
		if( null != dto.getPayAllowance_02_12())   setValue_chk( odsBean, Column, Line +   2, dto.getPayAllowance_02_12()); 	// ^x02_12
		if( null != dto.getPayAllowance_03_12())   setValue_chk( odsBean, Column, Line +   3, dto.getPayAllowance_03_12()); 	// ^x03_12
		if( null != dto.getPayAllowance_04_12())   setValue_chk( odsBean, Column, Line +   4, dto.getPayAllowance_04_12()); 	// ^x04_12
		if( null != dto.getPayAllowance_05_12())   setValue_chk( odsBean, Column, Line +   5, dto.getPayAllowance_05_12()); 	// ^x05_12
		if( null != dto.getPayAllowance_06_12())   setValue_chk( odsBean, Column, Line +   6, dto.getPayAllowance_06_12()); 	// ^x06_12
		if( null != dto.getPayAllowance_07_12())   setValue_chk( odsBean, Column, Line +   7, dto.getPayAllowance_07_12()); 	// ^x07_12
		if( null != dto.getPayAllowance_08_12())   setValue_chk( odsBean, Column, Line +   8, dto.getPayAllowance_08_12()); 	// ^x08_12
		if( null != dto.getPayAllowance_09_12())   setValue_chk( odsBean, Column, Line +   9, dto.getPayAllowance_09_12()); 	// ^x09_12
		if( null != dto.getPayAllowance_10_12())   setValue_chk( odsBean, Column, Line +  10, dto.getPayAllowance_10_12()); 	// ^x10_12
		if( null != dto.getPayAllowance_11_12())   setValue_chk( odsBean, Column, Line +  11, dto.getPayAllowance_11_12()); 	// ^x11_12
		if( null != dto.getPayAllowance_12_12())   setValue_chk( odsBean, Column, Line +  12, dto.getPayAllowance_12_12()); 	// ^x12_12
		if( null != dto.getPayAllowance_13_12())   setValue_chk( odsBean, Column, Line +  13, dto.getPayAllowance_13_12()); 	// ^x13_12
		if( null != dto.getPayAllowance_14_12())   setValue_chk( odsBean, Column, Line +  14, dto.getPayAllowance_14_12()); 	// ^x14_12
		if( null != dto.getPayAllowance_15_12())   setValue_chk( odsBean, Column, Line +  15, dto.getPayAllowance_15_12()); 	// ^x15_12
		if( null != dto.getPayAllowance_16_12())   setValue_chk( odsBean, Column, Line +  16, dto.getPayAllowance_16_12()); 	// ^x16_12
		if( null != dto.getPayAllowance_17_12())   setValue_chk( odsBean, Column, Line +  17, dto.getPayAllowance_17_12()); 	// ^x17_12
		if( null != dto.getPayAllowance_18_12())   setValue_chk( odsBean, Column, Line +  18, dto.getPayAllowance_18_12()); 	// ^x18_12
		if( null != dto.getPayAllowance_19_12())   setValue_chk( odsBean, Column, Line +  19, dto.getPayAllowance_19_12()); 	// ^x19_12
		if( null != dto.getPayAllowance_20_12())   setValue_chk( odsBean, Column, Line +  20, dto.getPayAllowance_20_12()); 	// ^x20_12
		if( null != dto.getPayAllowance_21_12())   setValue_chk( odsBean, Column, Line +  21, dto.getPayAllowance_21_12()); 	// ^x21_12
		if( null != dto.getPayAllowance_22_12())   setValue_chk( odsBean, Column, Line +  22, dto.getPayAllowance_22_12()); 	// ^x22_12
		if( null != dto.getPayAllowance_23_12())   setValue_chk( odsBean, Column, Line +  23, dto.getPayAllowance_23_12()); 	// ^x23_12
		if( null != dto.getPayAllowance_24_12())   setValue_chk( odsBean, Column, Line +  24, dto.getPayAllowance_24_12()); 	// ^x24_12
		if( null != dto.getPayAllowance_25_12())   setValue_chk( odsBean, Column, Line +  25, dto.getPayAllowance_25_12()); 	// ^x25_12
		if( null != dto.getPayAllowance_26_12())   setValue_chk( odsBean, Column, Line +  26, dto.getPayAllowance_26_12()); 	// ^x26_12
		if( null != dto.getPayAllowance_27_12())   setValue_chk( odsBean, Column, Line +  27, dto.getPayAllowance_27_12()); 	// ^x27_12
		if( null != dto.getPayAllowance_28_12())   setValue_chk( odsBean, Column, Line +  28, dto.getPayAllowance_28_12()); 	// ^x28_12
		if( null != dto.getPayAllowance_29_12())   setValue_chk( odsBean, Column, Line +  29, dto.getPayAllowance_29_12()); 	// ^x29_12
		if( null != dto.getPayAllowance_30_12())   setValue_chk( odsBean, Column, Line +  30, dto.getPayAllowance_30_12()); 	// ^x30_12
		if( null != dto.getPayAllowanceTotal_12()) setValue_chk( odsBean, Column, Line +  31, dto.getPayAllowanceTotal_12()); // ^xz_12
		Line   =  40;
		if( null != dto.getPayDeduction_01_12())   setValue_chk( odsBean, Column, Line +   1, dto.getPayDeduction_01_12()); 	// ^T01_12
		if( null != dto.getPayDeduction_02_12())   setValue_chk( odsBean, Column, Line +   2, dto.getPayDeduction_02_12()); 	// ^T02_12
		if( null != dto.getPayDeduction_03_12())   setValue_chk( odsBean, Column, Line +   3, dto.getPayDeduction_03_12()); 	// ^T03_12
		if( null != dto.getPayDeduction_04_12())   setValue_chk( odsBean, Column, Line +   4, dto.getPayDeduction_04_12()); 	// ^T04_12
		if( null != dto.getPayDeduction_05_12())   setValue_chk( odsBean, Column, Line +   5, dto.getPayDeduction_05_12()); 	// ^T05_12
		if( null != dto.getPayDeduction_06_12())   setValue_chk( odsBean, Column, Line +   6, dto.getPayDeduction_06_12()); 	// ^T06_12
		if( null != dto.getPayDeduction_07_12())   setValue_chk( odsBean, Column, Line +   7, dto.getPayDeduction_07_12()); 	// ^T07_12
		if( null != dto.getPayDeduction_08_12())   setValue_chk( odsBean, Column, Line +   8, dto.getPayDeduction_08_12()); 	// ^T08_12
		if( null != dto.getPayDeduction_09_12())   setValue_chk( odsBean, Column, Line +   9, dto.getPayDeduction_09_12()); 	// ^T09_12
		if( null != dto.getPayDeduction_10_12())   setValue_chk( odsBean, Column, Line +  10, dto.getPayDeduction_10_12()); 	// ^T10_12
		if( null != dto.getPayDeduction_11_12())   setValue_chk( odsBean, Column, Line +  11, dto.getPayDeduction_11_12()); 	// ^T11_12
		if( null != dto.getPayDeduction_12_12())   setValue_chk( odsBean, Column, Line +  12, dto.getPayDeduction_12_12()); 	// ^T12_12
		if( null != dto.getPayDeduction_14_12())   setValue_chk( odsBean, Column, Line +  13, dto.getPayDeduction_14_12()); 	// ^T14_12
		if( null != dto.getPayDeduction_15_12())   setValue_chk( odsBean, Column, Line +  14, dto.getPayDeduction_15_12()); 	// ^T15_12
		if( null != dto.getPayDeduction_16_12())   setValue_chk( odsBean, Column, Line +  15, dto.getPayDeduction_16_12()); 	// ^T16_12
		if( null != dto.getPayDeduction_17_12())   setValue_chk( odsBean, Column, Line +  16, dto.getPayDeduction_17_12()); 	// ^T17_12
		if( null != dto.getPayDeduction_18_12())   setValue_chk( odsBean, Column, Line +  17, dto.getPayDeduction_18_12()); 	// ^T18_12
		if( null != dto.getPayDeduction_19_12())   setValue_chk( odsBean, Column, Line +  18, dto.getPayDeduction_19_12()); 	// ^T19_12
		if( null != dto.getPayDeduction_20_12())   setValue_chk( odsBean, Column, Line +  19, dto.getPayDeduction_20_12()); 	// ^T20_12
		if( null != dto.getPayDeduction_21_12())   setValue_chk( odsBean, Column, Line +  20, dto.getPayDeduction_21_12()); 	// ^T21_12
		if( null != dto.getPayDeduction_22_12())   setValue_chk( odsBean, Column, Line +  21, dto.getPayDeduction_22_12()); 	// ^T22_12
		if( null != dto.getPayDeduction_23_12())   setValue_chk( odsBean, Column, Line +  22, dto.getPayDeduction_23_12()); 	// ^T23_12
		if( null != dto.getPayDeduction_24_12())   setValue_chk( odsBean, Column, Line +  23, dto.getPayDeduction_24_12()); 	// ^T24_12
		if( null != dto.getPayDeduction_25_12())   setValue_chk( odsBean, Column, Line +  24, dto.getPayDeduction_25_12()); 	// ^T25_12
		if( null != dto.getPayDeductionTotal_12()) setValue_chk( odsBean, Column, Line +  25, dto.getPayDeductionTotal_12()); // ^Tz_12
		if( null != dto.getPayDeduction_26_12())   setValue_chk( odsBean, Column, Line +  26, dto.getPayDeduction_26_12()); 	// ^T26_12
		if( null != dto.getPayPaymentTotal_12())   setValue_chk( odsBean, Column, Line +  27, dto.getPayPaymentTotal_12()); 	// ^xz_12
		if( null != dto.getPayBank1PayAmount_12()) setValue_chk( odsBean, Column, Line +  28, dto.getPayBank1PayAmount_12()); // ^s1Uz_12
		if( null != dto.getPayBank2PayAmount_12()) setValue_chk( odsBean, Column, Line +  29, dto.getPayBank2PayAmount_12()); // ^s2Uz_12
		if( null != dto.getPayCashPayAmount_12())  setValue_chk( odsBean, Column, Line +  30, dto.getPayCashPayAmount_12());	// xz_12
		if( null != dto.getPayDeduction_27_12())   setValue_chk( odsBean, Column, Line +  31, dto.getPayDeduction_27_12()); 	// ^T27_12
		
		Line   =  8;
		Column =  39; // Nԍv
		if( null != dto.getPayTotalAllowance_01())   setValue_chk( odsBean, Column, Line +   1, dto.getPayTotalAllowance_01()); 	// ^x01v
		if( null != dto.getPayTotalAllowance_02())   setValue_chk( odsBean, Column, Line +   2, dto.getPayTotalAllowance_02()); 	// ^x02v
		if( null != dto.getPayTotalAllowance_03())   setValue_chk( odsBean, Column, Line +   3, dto.getPayTotalAllowance_03()); 	// ^x03v
		if( null != dto.getPayTotalAllowance_04())   setValue_chk( odsBean, Column, Line +   4, dto.getPayTotalAllowance_04()); 	// ^x04v
		if( null != dto.getPayTotalAllowance_05())   setValue_chk( odsBean, Column, Line +   5, dto.getPayTotalAllowance_05()); 	// ^x05v
		if( null != dto.getPayTotalAllowance_06())   setValue_chk( odsBean, Column, Line +   6, dto.getPayTotalAllowance_06()); 	// ^x06v
		if( null != dto.getPayTotalAllowance_07())   setValue_chk( odsBean, Column, Line +   7, dto.getPayTotalAllowance_07()); 	// ^x07v
		if( null != dto.getPayTotalAllowance_08())   setValue_chk( odsBean, Column, Line +   8, dto.getPayTotalAllowance_08()); 	// ^x08v
		if( null != dto.getPayTotalAllowance_09())   setValue_chk( odsBean, Column, Line +   9, dto.getPayTotalAllowance_09()); 	// ^x09v
		if( null != dto.getPayTotalAllowance_10())   setValue_chk( odsBean, Column, Line +  10, dto.getPayTotalAllowance_10()); 	// ^x10v
		if( null != dto.getPayTotalAllowance_11())   setValue_chk( odsBean, Column, Line +  11, dto.getPayTotalAllowance_11()); 	// ^x11v
		if( null != dto.getPayTotalAllowance_12())   setValue_chk( odsBean, Column, Line +  12, dto.getPayTotalAllowance_12()); 	// ^x12v
		if( null != dto.getPayTotalAllowance_13())   setValue_chk( odsBean, Column, Line +  13, dto.getPayTotalAllowance_13()); 	// ^x13v
		if( null != dto.getPayTotalAllowance_14())   setValue_chk( odsBean, Column, Line +  14, dto.getPayTotalAllowance_14()); 	// ^x14v
		if( null != dto.getPayTotalAllowance_15())   setValue_chk( odsBean, Column, Line +  15, dto.getPayTotalAllowance_15()); 	// ^x15v
		if( null != dto.getPayTotalAllowance_16())   setValue_chk( odsBean, Column, Line +  16, dto.getPayTotalAllowance_16()); 	// ^x16v
		if( null != dto.getPayTotalAllowance_17())   setValue_chk( odsBean, Column, Line +  17, dto.getPayTotalAllowance_17()); 	// ^x17v
		if( null != dto.getPayTotalAllowance_18())   setValue_chk( odsBean, Column, Line +  18, dto.getPayTotalAllowance_18()); 	// ^x18v
		if( null != dto.getPayTotalAllowance_19())   setValue_chk( odsBean, Column, Line +  19, dto.getPayTotalAllowance_19()); 	// ^x19v
		if( null != dto.getPayTotalAllowance_20())   setValue_chk( odsBean, Column, Line +  20, dto.getPayTotalAllowance_20()); 	// ^x20v
		if( null != dto.getPayTotalAllowance_21())   setValue_chk( odsBean, Column, Line +  21, dto.getPayTotalAllowance_21()); 	// ^x21v
		if( null != dto.getPayTotalAllowance_22())   setValue_chk( odsBean, Column, Line +  22, dto.getPayTotalAllowance_22()); 	// ^x22v
		if( null != dto.getPayTotalAllowance_23())   setValue_chk( odsBean, Column, Line +  23, dto.getPayTotalAllowance_23()); 	// ^x23v
		if( null != dto.getPayTotalAllowance_24())   setValue_chk( odsBean, Column, Line +  24, dto.getPayTotalAllowance_24()); 	// ^x24v
		if( null != dto.getPayTotalAllowance_25())   setValue_chk( odsBean, Column, Line +  25, dto.getPayTotalAllowance_25()); 	// ^x25v
		if( null != dto.getPayTotalAllowance_26())   setValue_chk( odsBean, Column, Line +  26, dto.getPayTotalAllowance_26()); 	// ^x26v
		if( null != dto.getPayTotalAllowance_27())   setValue_chk( odsBean, Column, Line +  27, dto.getPayTotalAllowance_27()); 	// ^x27v
		if( null != dto.getPayTotalAllowance_28())   setValue_chk( odsBean, Column, Line +  28, dto.getPayTotalAllowance_28()); 	// ^x28v
		if( null != dto.getPayTotalAllowance_29())   setValue_chk( odsBean, Column, Line +  29, dto.getPayTotalAllowance_29()); 	// ^x29v
		if( null != dto.getPayTotalAllowance_30())   setValue_chk( odsBean, Column, Line +  30, dto.getPayTotalAllowance_30()); 	// ^x30v
		if( null != dto.getPayTotalAllowanceTotal()) setValue_chk( odsBean, Column, Line +  31, dto.getPayTotalAllowanceTotal()); // ^xzv
		Line   =  40;
		if( null != dto.getPayTotalDeduction_01())   setValue_chk( odsBean, Column, Line +   1, dto.getPayTotalDeduction_01()); 	// ^T01v
		if( null != dto.getPayTotalDeduction_02())   setValue_chk( odsBean, Column, Line +   2, dto.getPayTotalDeduction_02()); 	// ^T02v
		if( null != dto.getPayTotalDeduction_03())   setValue_chk( odsBean, Column, Line +   3, dto.getPayTotalDeduction_03()); 	// ^T03v
		if( null != dto.getPayTotalDeduction_04())   setValue_chk( odsBean, Column, Line +   4, dto.getPayTotalDeduction_04()); 	// ^T04v
		if( null != dto.getPayTotalDeduction_05())   setValue_chk( odsBean, Column, Line +   5, dto.getPayTotalDeduction_05()); 	// ^T05v
		if( null != dto.getPayTotalDeduction_06())   setValue_chk( odsBean, Column, Line +   6, dto.getPayTotalDeduction_06()); 	// ^T06v
		if( null != dto.getPayTotalDeduction_07())   setValue_chk( odsBean, Column, Line +   7, dto.getPayTotalDeduction_07()); 	// ^T07v
		if( null != dto.getPayTotalDeduction_08())   setValue_chk( odsBean, Column, Line +   8, dto.getPayTotalDeduction_08()); 	// ^T08v
		if( null != dto.getPayTotalDeduction_09())   setValue_chk( odsBean, Column, Line +   9, dto.getPayTotalDeduction_09()); 	// ^T09v
		if( null != dto.getPayTotalDeduction_10())   setValue_chk( odsBean, Column, Line +  10, dto.getPayTotalDeduction_10()); 	// ^T10v
		if( null != dto.getPayTotalDeduction_11())   setValue_chk( odsBean, Column, Line +  11, dto.getPayTotalDeduction_11()); 	// ^T11v
		if( null != dto.getPayTotalDeduction_12())   setValue_chk( odsBean, Column, Line +  12, dto.getPayTotalDeduction_12()); 	// ^T12v
		if( null != dto.getPayTotalDeduction_14())   setValue_chk( odsBean, Column, Line +  13, dto.getPayTotalDeduction_14()); 	// ^T14v
		if( null != dto.getPayTotalDeduction_15())   setValue_chk( odsBean, Column, Line +  14, dto.getPayTotalDeduction_15()); 	// ^T15v
		if( null != dto.getPayTotalDeduction_16())   setValue_chk( odsBean, Column, Line +  15, dto.getPayTotalDeduction_16()); 	// ^T16v
		if( null != dto.getPayTotalDeduction_17())   setValue_chk( odsBean, Column, Line +  16, dto.getPayTotalDeduction_17()); 	// ^T17v
		if( null != dto.getPayTotalDeduction_18())   setValue_chk( odsBean, Column, Line +  17, dto.getPayTotalDeduction_18()); 	// ^T18v
		if( null != dto.getPayTotalDeduction_19())   setValue_chk( odsBean, Column, Line +  18, dto.getPayTotalDeduction_19()); 	// ^T19v
		if( null != dto.getPayTotalDeduction_20())   setValue_chk( odsBean, Column, Line +  19, dto.getPayTotalDeduction_20()); 	// ^T20v
		if( null != dto.getPayTotalDeduction_21())   setValue_chk( odsBean, Column, Line +  20, dto.getPayTotalDeduction_21()); 	// ^T21v
		if( null != dto.getPayTotalDeduction_22())   setValue_chk( odsBean, Column, Line +  21, dto.getPayTotalDeduction_22()); 	// ^T22v
		if( null != dto.getPayTotalDeduction_23())   setValue_chk( odsBean, Column, Line +  22, dto.getPayTotalDeduction_23()); 	// ^T23v
		if( null != dto.getPayTotalDeduction_24())   setValue_chk( odsBean, Column, Line +  23, dto.getPayTotalDeduction_24()); 	// ^T24v
		if( null != dto.getPayTotalDeduction_25())   setValue_chk( odsBean, Column, Line +  24, dto.getPayTotalDeduction_25()); 	// ^T25v
		if( null != dto.getPayTotalDeductionTotal()) setValue_chk( odsBean, Column, Line +  25, dto.getPayTotalDeductionTotal()); // ^Tzv
		if( null != dto.getPayTotalDeduction_26())   setValue_chk( odsBean, Column, Line +  26, dto.getPayTotalDeduction_26()); 	// ^T26v
		if( null != dto.getPayTotalPaymentTotal())   setValue_chk( odsBean, Column, Line +  27, dto.getPayTotalPaymentTotal()); 	// ^xzv
		if( null != dto.getPayTotalBank1PayAmount()) setValue_chk( odsBean, Column, Line +  28, dto.getPayTotalBank1PayAmount()); // ^s1Uzv
		if( null != dto.getPayTotalBank2PayAmount()) setValue_chk( odsBean, Column, Line +  29, dto.getPayTotalBank2PayAmount()); // ^s2Uzv
		if( null != dto.getPayTotalCashPayAmount())  setValue_chk( odsBean, Column, Line +  30, dto.getPayTotalCashPayAmount());	// xzv
		if( null != dto.getPayTotalDeduction_27())   setValue_chk( odsBean, Column, Line +  31, dto.getPayTotalDeduction_27()); 	// ^T27v
		
		/** ΑӍڏo **/
		// ږo
		Line   =  80;
		Column =  0;
		setValue_chk( odsBean, Column +  0, Line +   1, dto.getTitleAttendance_01());		// ΑӍ01^Cg
		setValue_chk( odsBean, Column +  0, Line +   2, dto.getTitleAttendance_02());		// ΑӍ02^Cg
		setValue_chk( odsBean, Column +  0, Line +   3, dto.getTitleAttendance_03());		// ΑӍ03^Cg
		setValue_chk( odsBean, Column +  0, Line +   4, dto.getTitleAttendance_04());		// ΑӍ04^Cg
		setValue_chk( odsBean, Column +  0, Line +   5, dto.getTitleAttendance_05());		// ΑӍ05^Cg
		setValue_chk( odsBean, Column +  0, Line +   6, dto.getTitleAttendance_06());		// ΑӍ06^Cg
		setValue_chk( odsBean, Column +  0, Line +   7, dto.getTitleAttendance_07());		// ΑӍ07^Cg
		setValue_chk( odsBean, Column +  0, Line +   8, dto.getTitleAttendance_08());		// ΑӍ08^Cg
		setValue_chk( odsBean, Column +  0, Line +   9, dto.getTitleAttendance_09());		// ΑӍ09^Cg
		setValue_chk( odsBean, Column +  0, Line +  10, dto.getTitleAttendance_10());		// ΑӍ10^Cg

		// ΑӖ׏o
		Line   =  80;
		Column =  3; // 1
		if( null != dto.getPayPayday_01())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_01());	 		// ^x_01
		if( null != dto.getAttendance_01_01()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_01()); 	// ΑӍ01_01
		if( null != dto.getAttendance_02_01()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_01()); 	// ΑӍ02_01
		if( null != dto.getAttendance_03_01()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_01()); 	// ΑӍ03_01
		if( null != dto.getAttendance_04_01()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_01()); 	// ΑӍ04_01
		if( null != dto.getAttendance_05_01()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_01()); 	// ΑӍ05_01
		if( null != dto.getAttendance_06_01()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_01()); 	// ΑӍ06_01
		if( null != dto.getAttendance_07_01()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_01()); 	// ΑӍ07_01
		if( null != dto.getAttendance_08_01()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_01()); 	// ΑӍ08_01
		if( null != dto.getAttendance_09_01()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_01()); 	// ΑӍ09_01
		if( null != dto.getAttendance_10_01()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_01()); 	// ΑӍ00_01
		if( null != dto.getAttendance_11_01()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_01()); 	// ΑӍ01_01
		if( null != dto.getAttendance_12_01()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_01()); 	// ΑӍ02_01
		if( null != dto.getAttendance_13_01()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_01()); 	// ΑӍ03_01
		if( null != dto.getAttendance_14_01()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_01()); 	// ΑӍ04_01

		Line   =  80;
		Column =  6; // 2
		if( null != dto.getPayPayday_02())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_02());	 		// ^x_02
		if( null != dto.getAttendance_01_02()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_02()); 	// ΑӍ01_02
		if( null != dto.getAttendance_02_02()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_02()); 	// ΑӍ02_02
		if( null != dto.getAttendance_03_02()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_02()); 	// ΑӍ03_02
		if( null != dto.getAttendance_04_02()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_02()); 	// ΑӍ04_02
		if( null != dto.getAttendance_05_02()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_02()); 	// ΑӍ05_02
		if( null != dto.getAttendance_06_02()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_02()); 	// ΑӍ06_02
		if( null != dto.getAttendance_07_02()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_02()); 	// ΑӍ07_02
		if( null != dto.getAttendance_08_02()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_02()); 	// ΑӍ08_02
		if( null != dto.getAttendance_09_02()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_02()); 	// ΑӍ09_02
		if( null != dto.getAttendance_10_02()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_02()); 	// ΑӍ00_02
		if( null != dto.getAttendance_11_02()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_02()); 	// ΑӍ01_02
		if( null != dto.getAttendance_12_02()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_02()); 	// ΑӍ02_02
		if( null != dto.getAttendance_13_02()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_02()); 	// ΑӍ03_02
		if( null != dto.getAttendance_14_02()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_02()); 	// ΑӍ04_02

		Line   =  80;
		Column =  9; // 3
		if( null != dto.getPayPayday_03())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_03());	 		// ^x_03
		if( null != dto.getAttendance_01_03()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_03()); 	// ΑӍ01_03
		if( null != dto.getAttendance_02_03()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_03()); 	// ΑӍ02_03
		if( null != dto.getAttendance_03_03()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_03()); 	// ΑӍ03_03
		if( null != dto.getAttendance_04_03()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_03()); 	// ΑӍ04_03
		if( null != dto.getAttendance_05_03()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_03()); 	// ΑӍ05_03
		if( null != dto.getAttendance_06_03()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_03()); 	// ΑӍ06_03
		if( null != dto.getAttendance_07_03()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_03()); 	// ΑӍ07_03
		if( null != dto.getAttendance_08_03()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_03()); 	// ΑӍ08_03
		if( null != dto.getAttendance_09_03()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_03()); 	// ΑӍ09_03
		if( null != dto.getAttendance_10_03()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_03()); 	// ΑӍ00_03
		if( null != dto.getAttendance_11_03()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_03()); 	// ΑӍ01_03
		if( null != dto.getAttendance_12_03()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_03()); 	// ΑӍ02_03
		if( null != dto.getAttendance_13_03()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_03()); 	// ΑӍ03_03
		if( null != dto.getAttendance_14_03()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_03()); 	// ΑӍ04_03


		Line   =  80;
		Column =  12; // 4
		if( null != dto.getPayPayday_04())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_04());	 		// ^x_04
		if( null != dto.getAttendance_01_04()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_04()); 	// ΑӍ01_04
		if( null != dto.getAttendance_02_04()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_04()); 	// ΑӍ02_04
		if( null != dto.getAttendance_03_04()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_04()); 	// ΑӍ03_04
		if( null != dto.getAttendance_04_04()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_04()); 	// ΑӍ04_04
		if( null != dto.getAttendance_05_04()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_04()); 	// ΑӍ05_04
		if( null != dto.getAttendance_06_04()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_04()); 	// ΑӍ06_04
		if( null != dto.getAttendance_07_04()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_04()); 	// ΑӍ07_04
		if( null != dto.getAttendance_08_04()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_04()); 	// ΑӍ08_04
		if( null != dto.getAttendance_09_04()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_04()); 	// ΑӍ09_04
		if( null != dto.getAttendance_10_04()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_04()); 	// ΑӍ00_04
		if( null != dto.getAttendance_11_04()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_04()); 	// ΑӍ01_04
		if( null != dto.getAttendance_12_04()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_04()); 	// ΑӍ02_04
		if( null != dto.getAttendance_13_04()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_04()); 	// ΑӍ03_04
		if( null != dto.getAttendance_14_04()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_04()); 	// ΑӍ04_04

		Line   =  80;
		Column =  15; // 5
		if( null != dto.getPayPayday_05())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_05());	 		// ^x_05
		if( null != dto.getAttendance_01_05()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_05()); 	// ΑӍ01_05
		if( null != dto.getAttendance_02_05()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_05()); 	// ΑӍ02_05
		if( null != dto.getAttendance_03_05()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_05()); 	// ΑӍ03_05
		if( null != dto.getAttendance_04_05()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_05()); 	// ΑӍ04_05
		if( null != dto.getAttendance_05_05()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_05()); 	// ΑӍ05_05
		if( null != dto.getAttendance_06_05()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_05()); 	// ΑӍ06_05
		if( null != dto.getAttendance_07_05()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_05()); 	// ΑӍ07_05
		if( null != dto.getAttendance_08_05()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_05()); 	// ΑӍ08_05
		if( null != dto.getAttendance_09_05()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_05()); 	// ΑӍ09_05
		if( null != dto.getAttendance_10_05()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_05()); 	// ΑӍ00_05
		if( null != dto.getAttendance_11_05()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_05()); 	// ΑӍ01_05
		if( null != dto.getAttendance_12_05()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_05()); 	// ΑӍ02_05
		if( null != dto.getAttendance_13_05()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_05()); 	// ΑӍ03_05
		if( null != dto.getAttendance_14_05()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_05()); 	// ΑӍ04_05

		Line   =  80;
		Column =  18; // 6
		if( null != dto.getPayPayday_06())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_06());	 		// ^x_06
		if( null != dto.getAttendance_01_06()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_06()); 	// ΑӍ01_06
		if( null != dto.getAttendance_02_06()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_06()); 	// ΑӍ02_06
		if( null != dto.getAttendance_03_06()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_06()); 	// ΑӍ03_06
		if( null != dto.getAttendance_04_06()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_06()); 	// ΑӍ04_06
		if( null != dto.getAttendance_05_06()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_06()); 	// ΑӍ05_06
		if( null != dto.getAttendance_06_06()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_06()); 	// ΑӍ06_06
		if( null != dto.getAttendance_07_06()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_06()); 	// ΑӍ07_06
		if( null != dto.getAttendance_08_06()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_06()); 	// ΑӍ08_06
		if( null != dto.getAttendance_09_06()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_06()); 	// ΑӍ09_06
		if( null != dto.getAttendance_10_06()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_06()); 	// ΑӍ00_06
		if( null != dto.getAttendance_11_06()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_06()); 	// ΑӍ01_06
		if( null != dto.getAttendance_12_06()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_06()); 	// ΑӍ02_06
		if( null != dto.getAttendance_13_06()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_06()); 	// ΑӍ03_06
		if( null != dto.getAttendance_14_06()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_06()); 	// ΑӍ04_06

		Line   =  80;
		Column =  21; // 7
		if( null != dto.getPayPayday_07())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_07());	 		// ^x_07
		if( null != dto.getAttendance_01_07()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_07()); 	// ΑӍ01_07
		if( null != dto.getAttendance_02_07()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_07()); 	// ΑӍ02_07
		if( null != dto.getAttendance_03_07()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_07()); 	// ΑӍ03_07
		if( null != dto.getAttendance_04_07()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_07()); 	// ΑӍ04_07
		if( null != dto.getAttendance_05_07()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_07()); 	// ΑӍ05_07
		if( null != dto.getAttendance_06_07()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_07()); 	// ΑӍ06_07
		if( null != dto.getAttendance_07_07()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_07()); 	// ΑӍ07_07
		if( null != dto.getAttendance_08_07()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_07()); 	// ΑӍ08_07
		if( null != dto.getAttendance_09_07()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_07()); 	// ΑӍ09_07
		if( null != dto.getAttendance_10_07()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_07()); 	// ΑӍ00_07
		if( null != dto.getAttendance_11_07()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_07()); 	// ΑӍ01_07
		if( null != dto.getAttendance_12_07()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_07()); 	// ΑӍ02_07
		if( null != dto.getAttendance_13_07()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_07()); 	// ΑӍ03_07
		if( null != dto.getAttendance_14_07()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_07()); 	// ΑӍ04_07

		Line   =  80;
		Column =  24; // 8
		if( null != dto.getPayPayday_08())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_08());	 		// ^x_08
		if( null != dto.getAttendance_01_08()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_08()); 	// ΑӍ01_08
		if( null != dto.getAttendance_02_08()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_08()); 	// ΑӍ02_08
		if( null != dto.getAttendance_03_08()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_08()); 	// ΑӍ03_08
		if( null != dto.getAttendance_04_08()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_08()); 	// ΑӍ04_08
		if( null != dto.getAttendance_05_08()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_08()); 	// ΑӍ05_08
		if( null != dto.getAttendance_06_08()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_08()); 	// ΑӍ06_08
		if( null != dto.getAttendance_07_08()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_08()); 	// ΑӍ07_08
		if( null != dto.getAttendance_08_08()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_08()); 	// ΑӍ08_08
		if( null != dto.getAttendance_09_08()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_08()); 	// ΑӍ09_08
		if( null != dto.getAttendance_10_08()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_08()); 	// ΑӍ00_08
		if( null != dto.getAttendance_11_08()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_08()); 	// ΑӍ01_08
		if( null != dto.getAttendance_12_08()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_08()); 	// ΑӍ02_08
		if( null != dto.getAttendance_13_08()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_08()); 	// ΑӍ03_08
		if( null != dto.getAttendance_14_08()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_08()); 	// ΑӍ04_08

		Line   =  80;
		Column =  27; // 9
		if( null != dto.getPayPayday_09())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_09());	 		// ^x_09
		if( null != dto.getAttendance_01_09()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_09()); 	// ΑӍ01_09
		if( null != dto.getAttendance_02_09()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_09()); 	// ΑӍ02_09
		if( null != dto.getAttendance_03_09()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_09()); 	// ΑӍ03_09
		if( null != dto.getAttendance_04_09()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_09()); 	// ΑӍ04_09
		if( null != dto.getAttendance_05_09()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_09()); 	// ΑӍ05_09
		if( null != dto.getAttendance_06_09()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_09()); 	// ΑӍ06_09
		if( null != dto.getAttendance_07_09()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_09()); 	// ΑӍ07_09
		if( null != dto.getAttendance_08_09()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_09()); 	// ΑӍ08_09
		if( null != dto.getAttendance_09_09()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_09()); 	// ΑӍ09_09
		if( null != dto.getAttendance_10_09()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_09()); 	// ΑӍ00_09
		if( null != dto.getAttendance_11_09()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_09()); 	// ΑӍ01_09
		if( null != dto.getAttendance_12_09()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_09()); 	// ΑӍ02_09
		if( null != dto.getAttendance_13_09()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_09()); 	// ΑӍ03_09
		if( null != dto.getAttendance_14_09()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_09()); 	// ΑӍ04_09

		Line   =  80;
		Column =  30; //10
		if( null != dto.getPayPayday_10())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_10());	 		// ^x_10
		if( null != dto.getAttendance_01_10()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_10()); 	// ΑӍ01_10
		if( null != dto.getAttendance_02_10()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_10()); 	// ΑӍ02_10
		if( null != dto.getAttendance_03_10()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_10()); 	// ΑӍ03_10
		if( null != dto.getAttendance_04_10()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_10()); 	// ΑӍ04_10
		if( null != dto.getAttendance_05_10()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_10()); 	// ΑӍ05_10
		if( null != dto.getAttendance_06_10()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_10()); 	// ΑӍ06_10
		if( null != dto.getAttendance_07_10()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_10()); 	// ΑӍ07_10
		if( null != dto.getAttendance_08_10()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_10()); 	// ΑӍ08_10
		if( null != dto.getAttendance_09_10()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_10()); 	// ΑӍ09_10
		if( null != dto.getAttendance_10_10()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_10()); 	// ΑӍ00_10
		if( null != dto.getAttendance_11_10()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_10()); 	// ΑӍ01_10
		if( null != dto.getAttendance_12_10()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_10()); 	// ΑӍ02_10
		if( null != dto.getAttendance_13_10()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_10()); 	// ΑӍ03_10
		if( null != dto.getAttendance_14_10()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_10()); 	// ΑӍ04_10

		Line   =  80;
		Column =  33; // 11
		if( null != dto.getPayPayday_11())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_11());	 		// ^x_11
		if( null != dto.getAttendance_01_11()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_11()); 	// ΑӍ01_11
		if( null != dto.getAttendance_02_11()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_11()); 	// ΑӍ02_11
		if( null != dto.getAttendance_03_11()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_11()); 	// ΑӍ03_11
		if( null != dto.getAttendance_04_11()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_11()); 	// ΑӍ04_11
		if( null != dto.getAttendance_05_11()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_11()); 	// ΑӍ05_11
		if( null != dto.getAttendance_06_11()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_11()); 	// ΑӍ06_11
		if( null != dto.getAttendance_07_11()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_11()); 	// ΑӍ07_11
		if( null != dto.getAttendance_08_11()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_11()); 	// ΑӍ08_11
		if( null != dto.getAttendance_09_11()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_11()); 	// ΑӍ09_11
		if( null != dto.getAttendance_10_11()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_11()); 	// ΑӍ00_11
		if( null != dto.getAttendance_11_11()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_11()); 	// ΑӍ01_11
		if( null != dto.getAttendance_12_11()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_11()); 	// ΑӍ02_11
		if( null != dto.getAttendance_13_11()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_11()); 	// ΑӍ03_11
		if( null != dto.getAttendance_14_11()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_11()); 	// ΑӍ04_11

		Line   =  80;
		Column =  36; // 12
		if( null != dto.getPayPayday_12())     setValue_chk( odsBean, Column, Line +   0, dto.getPayPayday_12());	 		// ^x_12
		if( null != dto.getAttendance_01_12()) setValue_chk( odsBean, Column, Line +   1, dto.getAttendance_01_12()); 	// ΑӍ01_12
		if( null != dto.getAttendance_02_12()) setValue_chk( odsBean, Column, Line +   2, dto.getAttendance_02_12()); 	// ΑӍ02_12
		if( null != dto.getAttendance_03_12()) setValue_chk( odsBean, Column, Line +   3, dto.getAttendance_03_12()); 	// ΑӍ03_12
		if( null != dto.getAttendance_04_12()) setValue_chk( odsBean, Column, Line +   4, dto.getAttendance_04_12()); 	// ΑӍ04_12
		if( null != dto.getAttendance_05_12()) setValue_chk( odsBean, Column, Line +   5, dto.getAttendance_05_12()); 	// ΑӍ05_12
		if( null != dto.getAttendance_06_12()) setValue_chk( odsBean, Column, Line +   6, dto.getAttendance_06_12()); 	// ΑӍ06_12
		if( null != dto.getAttendance_07_12()) setValue_chk( odsBean, Column, Line +   7, dto.getAttendance_07_12()); 	// ΑӍ07_12
		if( null != dto.getAttendance_08_12()) setValue_chk( odsBean, Column, Line +   8, dto.getAttendance_08_12()); 	// ΑӍ08_12
		if( null != dto.getAttendance_09_12()) setValue_chk( odsBean, Column, Line +   9, dto.getAttendance_09_12()); 	// ΑӍ09_12
		if( null != dto.getAttendance_10_12()) setValue_chk( odsBean, Column, Line +  10, dto.getAttendance_10_12()); 	// ΑӍ00_12
		if( null != dto.getAttendance_11_12()) setValue_chk( odsBean, Column, Line +  11, dto.getAttendance_11_12()); 	// ΑӍ01_12
		if( null != dto.getAttendance_12_12()) setValue_chk( odsBean, Column, Line +  12, dto.getAttendance_12_12()); 	// ΑӍ02_12
		if( null != dto.getAttendance_13_12()) setValue_chk( odsBean, Column, Line +  13, dto.getAttendance_13_12()); 	// ΑӍ03_12
		if( null != dto.getAttendance_14_12()) setValue_chk( odsBean, Column, Line +  14, dto.getAttendance_14_12()); 	// ΑӍ04_12
		
		Line   =  80;
		Column =  39; // Nԍv
		if( null != dto.getTotalAttendance_01()) setValue_chk( odsBean, Column, Line +   1, dto.getTotalAttendance_01()); 	// ΑӍ01v
		if( null != dto.getTotalAttendance_02()) setValue_chk( odsBean, Column, Line +   2, dto.getTotalAttendance_02()); 	// ΑӍ02v
		if( null != dto.getTotalAttendance_03()) setValue_chk( odsBean, Column, Line +   3, dto.getTotalAttendance_03()); 	// ΑӍ03v
		if( null != dto.getTotalAttendance_04()) setValue_chk( odsBean, Column, Line +   4, dto.getTotalAttendance_04()); 	// ΑӍ04v
		if( null != dto.getTotalAttendance_05()) setValue_chk( odsBean, Column, Line +   5, dto.getTotalAttendance_05()); 	// ΑӍ05v
		if( null != dto.getTotalAttendance_06()) setValue_chk( odsBean, Column, Line +   6, dto.getTotalAttendance_06()); 	// ΑӍ06v
		if( null != dto.getTotalAttendance_07()) setValue_chk( odsBean, Column, Line +   7, dto.getTotalAttendance_07()); 	// ΑӍ07v
		if( null != dto.getTotalAttendance_08()) setValue_chk( odsBean, Column, Line +   8, dto.getTotalAttendance_08()); 	// ΑӍ08v
		if( null != dto.getTotalAttendance_09()) setValue_chk( odsBean, Column, Line +   9, dto.getTotalAttendance_09()); 	// ΑӍ09v
		if( null != dto.getTotalAttendance_10()) setValue_chk( odsBean, Column, Line +  10, dto.getTotalAttendance_10()); 	// ΑӍ00v
		if( null != dto.getTotalAttendance_11()) setValue_chk( odsBean, Column, Line +  11, dto.getTotalAttendance_11()); 	// ΑӍ01v
		if( null != dto.getTotalAttendance_12()) setValue_chk( odsBean, Column, Line +  12, dto.getTotalAttendance_12()); 	// ΑӍ02v
		if( null != dto.getTotalAttendance_13()) setValue_chk( odsBean, Column, Line +  13, dto.getTotalAttendance_13()); 	// ΑӍ03v
		if( null != dto.getTotalAttendance_14()) setValue_chk( odsBean, Column, Line +  14, dto.getTotalAttendance_14()); 	// ΑӍ04v
		
		/** ܗ^ڏo **/
		// ږo
		Line   =  98;
		Column =  0;
		setValue_chk( odsBean, Column +  0, Line +   0, dto.getTitleAllowanceItem());		// xږ^Cg
		setValue_chk( odsBean, Column +  0, Line +   1, dto.getTitleBonAllowance_01());	// ܗ^x01^Cg
		setValue_chk( odsBean, Column +  0, Line +   2, dto.getTitleBonAllowance_02());	// ܗ^x02^Cg
		setValue_chk( odsBean, Column +  0, Line +   3, dto.getTitleBonAllowance_03());	// ܗ^x03^Cg
		setValue_chk( odsBean, Column +  0, Line +   4, dto.getTitleBonAllowance_04());	// ܗ^x04^Cg
		setValue_chk( odsBean, Column +  0, Line +   5, dto.getTitleBonAllowance_05());	// ܗ^x05^Cg
		setValue_chk( odsBean, Column +  0, Line +   6, dto.getTitleBonAllowance_06());	// ܗ^x06^Cg
		setValue_chk( odsBean, Column +  0, Line +   7, dto.getTitleBonAllowance_07());	// ܗ^x07^Cg
		setValue_chk( odsBean, Column +  0, Line +   8, dto.getTitleBonAllowance_08());	// ܗ^x08^Cg
		setValue_chk( odsBean, Column +  0, Line +   9, dto.getTitleBonAllowance_09());	// ܗ^x09^Cg
		setValue_chk( odsBean, Column +  0, Line +  10, dto.getTitleBonAllowance_10());	// ܗ^x10^Cg
		setValue_chk( odsBean, Column +  0, Line +  11, dto.getTitleAllowanceTotal());	// xz^Cg		
		setValue_chk( odsBean, Column +  0, Line +  12, "" + dto.getTitleDeductionItem() + "");	// Tڃ^Cg  
		setValue_chk( odsBean, Column +  0, Line +  13, dto.getTitleBonDeduction_01());	// ܗ^T01^Cg
		setValue_chk( odsBean, Column +  0, Line +  14, dto.getTitleBonDeduction_02());	// ܗ^T02^Cg
		setValue_chk( odsBean, Column +  0, Line +  15, dto.getTitleBonDeduction_03());	// ܗ^T03^Cg
		setValue_chk( odsBean, Column +  0, Line +  16, dto.getTitleBonDeduction_04());	// ܗ^T04^Cg
		setValue_chk( odsBean, Column +  0, Line +  17, dto.getTitleBonDeduction_05());	// ܗ^T05^Cg
		setValue_chk( odsBean, Column +  0, Line +  18, dto.getTitleBonDeduction_06());	// ܗ^T06^Cg
		setValue_chk( odsBean, Column +  0, Line +  19, dto.getTitleBonDeduction_07());	// ܗ^T07^Cg
		setValue_chk( odsBean, Column +  0, Line +  20, dto.getTitleBonDeduction_08());	// ܗ^T08^Cg
		setValue_chk( odsBean, Column +  0, Line +  21, dto.getTitleBonDeduction_09());	// ܗ^T09^Cg
		setValue_chk( odsBean, Column +  0, Line +  22, dto.getTitleBonDeduction_10());	// ܗ^T10^Cg
		setValue_chk( odsBean, Column +  0, Line +  23, dto.getTitleBonDeduction_11());	// ܗ^T11^Cg
		setValue_chk( odsBean, Column +  0, Line +  24, dto.getTitleBonDeduction_12());	// ܗ^T12^Cg
		setValue_chk( odsBean, Column +  0, Line +  25, dto.getTitleBonDeduction_14());	// ܗ^T14^Cg
		setValue_chk( odsBean, Column +  0, Line +  26, dto.getTitleBonDeduction_15());	// ܗ^T15^Cg
		setValue_chk( odsBean, Column +  0, Line +  27, dto.getTitleBonDeduction_16());	// ܗ^T16^Cg
		setValue_chk( odsBean, Column +  0, Line +  28, dto.getTitleDeductionTotal());    // Tz^Cg
		setValue_chk( odsBean, Column +  0, Line +  29, dto.getTitlePaymentTotal());		// xz^Cg
		setValue_chk( odsBean, Column +  0, Line +  30, dto.getTitleBank1PayAmount());	// s1Uz
		setValue_chk( odsBean, Column +  0, Line +  31, dto.getTitleBank2PayAmount());	// s2Uz
		setValue_chk( odsBean, Column +  0, Line +  32, dto.getTitleCashPayAmount());		// xz
		setValue_chk( odsBean, Column +  0, Line +  33, dto.getTitleBonDeduction_17());	// ܗ^T17^Cg

		// ܗ^x׏o
		Line   = 97;
		Column =  3; // 1
		if( null != dto.getBonPayday_01())          setValue_chk( odsBean, Column, Line +   0, dto.getBonPayday_01());	 		// ܗ^x_01
		if( null != dto.getBonAllowance_01_01())    setValue_chk( odsBean, Column, Line +   1, dto.getBonAllowance_01_01()); 	// ܗ^x01_01
		if( null != dto.getBonAllowance_02_01())    setValue_chk( odsBean, Column, Line +   2, dto.getBonAllowance_02_01()); 	// ܗ^x02_01
		if( null != dto.getBonAllowance_03_01())    setValue_chk( odsBean, Column, Line +   3, dto.getBonAllowance_03_01()); 	// ܗ^x03_01
		if( null != dto.getBonAllowance_04_01())    setValue_chk( odsBean, Column, Line +   4, dto.getBonAllowance_04_01()); 	// ܗ^x04_01
		if( null != dto.getBonAllowance_05_01())    setValue_chk( odsBean, Column, Line +   5, dto.getBonAllowance_05_01()); 	// ܗ^x05_01
		if( null != dto.getBonAllowance_06_01())    setValue_chk( odsBean, Column, Line +   6, dto.getBonAllowance_06_01()); 	// ܗ^x06_01
		if( null != dto.getBonAllowance_07_01())    setValue_chk( odsBean, Column, Line +   7, dto.getBonAllowance_07_01()); 	// ܗ^x07_01
		if( null != dto.getBonAllowance_08_01())    setValue_chk( odsBean, Column, Line +   8, dto.getBonAllowance_08_01()); 	// ܗ^x08_01
		if( null != dto.getBonAllowance_09_01())    setValue_chk( odsBean, Column, Line +   9, dto.getBonAllowance_09_01()); 	// ܗ^x09_01
		if( null != dto.getBonAllowance_10_01())    setValue_chk( odsBean, Column, Line +  10, dto.getBonAllowance_10_01()); 	// ܗ^x10_01
		if( null != dto. getBonAllowanceTotal_01()) setValue_chk( odsBean, Column, Line +  11, dto. getBonAllowanceTotal_01()); 	// ܗ^x1ڌv

		Line   = 97;
		Column =  6; // 2
		if( null != dto.getBonPayday_02())          setValue_chk( odsBean, Column, Line +   0, dto.getBonPayday_02());	 		// ܗ^x_02
		if( null != dto.getBonAllowance_01_02())    setValue_chk( odsBean, Column, Line +   1, dto.getBonAllowance_01_02()); 	// ܗ^x01_02
		if( null != dto.getBonAllowance_02_02())    setValue_chk( odsBean, Column, Line +   2, dto.getBonAllowance_02_02()); 	// ܗ^x02_02
		if( null != dto.getBonAllowance_03_02())    setValue_chk( odsBean, Column, Line +   3, dto.getBonAllowance_03_02()); 	// ܗ^x03_02
		if( null != dto.getBonAllowance_04_02())    setValue_chk( odsBean, Column, Line +   4, dto.getBonAllowance_04_02()); 	// ܗ^x04_02
		if( null != dto.getBonAllowance_05_02())    setValue_chk( odsBean, Column, Line +   5, dto.getBonAllowance_05_02()); 	// ܗ^x05_02
		if( null != dto.getBonAllowance_06_02())    setValue_chk( odsBean, Column, Line +   6, dto.getBonAllowance_06_02()); 	// ܗ^x06_02
		if( null != dto.getBonAllowance_07_02())    setValue_chk( odsBean, Column, Line +   7, dto.getBonAllowance_07_02()); 	// ܗ^x07_02
		if( null != dto.getBonAllowance_08_02())    setValue_chk( odsBean, Column, Line +   8, dto.getBonAllowance_08_02()); 	// ܗ^x08_02
		if( null != dto.getBonAllowance_09_02())    setValue_chk( odsBean, Column, Line +   9, dto.getBonAllowance_09_02()); 	// ܗ^x09_02
		if( null != dto.getBonAllowance_10_02())    setValue_chk( odsBean, Column, Line +  10, dto.getBonAllowance_10_02()); 	// ܗ^x10_02
		if( null != dto. getBonAllowanceTotal_02()) setValue_chk( odsBean, Column, Line +  11, dto. getBonAllowanceTotal_02()); 	// ܗ^x2ڌv

		
		Line   = 97;
		Column =  9; // 3
		if( null != dto.getBonPayday_03())          setValue_chk( odsBean, Column, Line +   0, dto.getBonPayday_03());			// ܗ^x_03
		if( null != dto.getBonAllowance_01_03())    setValue_chk( odsBean, Column, Line +   1, dto.getBonAllowance_01_03()); 	// ܗ^x01_03
		if( null != dto.getBonAllowance_02_03())    setValue_chk( odsBean, Column, Line +   2, dto.getBonAllowance_02_03()); 	// ܗ^x02_03
		if( null != dto.getBonAllowance_03_03())    setValue_chk( odsBean, Column, Line +   3, dto.getBonAllowance_03_03()); 	// ܗ^x03_03
		if( null != dto.getBonAllowance_04_03())    setValue_chk( odsBean, Column, Line +   4, dto.getBonAllowance_04_03()); 	// ܗ^x04_03
		if( null != dto.getBonAllowance_05_03())    setValue_chk( odsBean, Column, Line +   5, dto.getBonAllowance_05_03()); 	// ܗ^x05_03
		if( null != dto.getBonAllowance_06_03())    setValue_chk( odsBean, Column, Line +   6, dto.getBonAllowance_06_03()); 	// ܗ^x06_03
		if( null != dto.getBonAllowance_07_03())    setValue_chk( odsBean, Column, Line +   7, dto.getBonAllowance_07_03()); 	// ܗ^x07_03
		if( null != dto.getBonAllowance_08_03())    setValue_chk( odsBean, Column, Line +   8, dto.getBonAllowance_08_03()); 	// ܗ^x08_03
		if( null != dto.getBonAllowance_09_03())    setValue_chk( odsBean, Column, Line +   9, dto.getBonAllowance_09_03()); 	// ܗ^x09_03
		if( null != dto.getBonAllowance_10_03())    setValue_chk( odsBean, Column, Line +  10, dto.getBonAllowance_10_03()); 	// ܗ^x10_03
		if( null != dto. getBonAllowanceTotal_03()) setValue_chk( odsBean, Column, Line +  11, dto. getBonAllowanceTotal_03()); 	// ܗ^x3ڌv

		Line   = 97;
		Column = 12; // 4
		if( null != dto.getBonPayday_04())          setValue_chk( odsBean, Column, Line +   0, dto.getBonPayday_04());		 	// ܗ^x_04
		if( null != dto.getBonAllowance_01_04())    setValue_chk( odsBean, Column, Line +   1, dto.getBonAllowance_01_04()); 	// ܗ^x01_04
		if( null != dto.getBonAllowance_02_04())    setValue_chk( odsBean, Column, Line +   2, dto.getBonAllowance_02_04()); 	// ܗ^x02_04
		if( null != dto.getBonAllowance_03_04())    setValue_chk( odsBean, Column, Line +   3, dto.getBonAllowance_03_04()); 	// ܗ^x03_04
		if( null != dto.getBonAllowance_04_04())    setValue_chk( odsBean, Column, Line +   4, dto.getBonAllowance_04_04()); 	// ܗ^x04_04
		if( null != dto.getBonAllowance_05_04())    setValue_chk( odsBean, Column, Line +   5, dto.getBonAllowance_05_04()); 	// ܗ^x05_04
		if( null != dto.getBonAllowance_06_04())    setValue_chk( odsBean, Column, Line +   6, dto.getBonAllowance_06_04()); 	// ܗ^x06_04
		if( null != dto.getBonAllowance_07_04())    setValue_chk( odsBean, Column, Line +   7, dto.getBonAllowance_07_04()); 	// ܗ^x07_04
		if( null != dto.getBonAllowance_08_04())    setValue_chk( odsBean, Column, Line +   8, dto.getBonAllowance_08_04()); 	// ܗ^x08_04
		if( null != dto.getBonAllowance_09_04())    setValue_chk( odsBean, Column, Line +   9, dto.getBonAllowance_09_04()); 	// ܗ^x09_04
		if( null != dto.getBonAllowance_10_04())    setValue_chk( odsBean, Column, Line +  10, dto.getBonAllowance_10_04()); 	// ܗ^x10_04
		if( null != dto. getBonAllowanceTotal_04()) setValue_chk( odsBean, Column, Line +  11, dto. getBonAllowanceTotal_04()); 	// ܗ^x4ڌv

		
		Line   = 97;
		Column = 15; // 5
		if( null != dto.getBonPayday_05())          setValue_chk( odsBean, Column, Line +   0, dto.getBonPayday_05());	 		// ܗ^x_05
		if( null != dto.getBonAllowance_01_05())    setValue_chk( odsBean, Column, Line +   1, dto.getBonAllowance_01_05()); 	// ܗ^x01_05
		if( null != dto.getBonAllowance_02_05())    setValue_chk( odsBean, Column, Line +   2, dto.getBonAllowance_02_05()); 	// ܗ^x02_05
		if( null != dto.getBonAllowance_03_05())    setValue_chk( odsBean, Column, Line +   3, dto.getBonAllowance_03_05()); 	// ܗ^x03_05
		if( null != dto.getBonAllowance_04_05())    setValue_chk( odsBean, Column, Line +   4, dto.getBonAllowance_04_05()); 	// ܗ^x04_05
		if( null != dto.getBonAllowance_05_05())    setValue_chk( odsBean, Column, Line +   5, dto.getBonAllowance_05_05()); 	// ܗ^x05_05
		if( null != dto.getBonAllowance_06_05())    setValue_chk( odsBean, Column, Line +   6, dto.getBonAllowance_06_05()); 	// ܗ^x06_05
		if( null != dto.getBonAllowance_07_05())    setValue_chk( odsBean, Column, Line +   7, dto.getBonAllowance_07_05()); 	// ܗ^x07_05
		if( null != dto.getBonAllowance_08_05())    setValue_chk( odsBean, Column, Line +   8, dto.getBonAllowance_08_05()); 	// ܗ^x08_05
		if( null != dto.getBonAllowance_09_05())    setValue_chk( odsBean, Column, Line +   9, dto.getBonAllowance_09_05()); 	// ܗ^x09_05
		if( null != dto.getBonAllowance_10_05())    setValue_chk( odsBean, Column, Line +  10, dto.getBonAllowance_10_05()); 	// ܗ^x10_05
		if( null != dto. getBonAllowanceTotal_05()) setValue_chk( odsBean, Column, Line +  11, dto. getBonAllowanceTotal_05()); 	// ܗ^x5ڌv

		Line   = 97;
		Column = 18; // 6
		if( null != dto.getBonPayday_06())          setValue_chk( odsBean, Column, Line +   0, dto.getBonPayday_06());	 		// ܗ^x_06
		if( null != dto.getBonAllowance_01_06())    setValue_chk( odsBean, Column, Line +   1, dto.getBonAllowance_01_06()); 	// ܗ^x01_06
		if( null != dto.getBonAllowance_02_06())    setValue_chk( odsBean, Column, Line +   2, dto.getBonAllowance_02_06()); 	// ܗ^x02_06
		if( null != dto.getBonAllowance_03_06())    setValue_chk( odsBean, Column, Line +   3, dto.getBonAllowance_03_06()); 	// ܗ^x03_06
		if( null != dto.getBonAllowance_04_06())    setValue_chk( odsBean, Column, Line +   4, dto.getBonAllowance_04_06()); 	// ܗ^x04_06
		if( null != dto.getBonAllowance_05_06())    setValue_chk( odsBean, Column, Line +   5, dto.getBonAllowance_05_06()); 	// ܗ^x05_06
		if( null != dto.getBonAllowance_06_06())    setValue_chk( odsBean, Column, Line +   6, dto.getBonAllowance_06_06()); 	// ܗ^x06_06
		if( null != dto.getBonAllowance_07_06())    setValue_chk( odsBean, Column, Line +   7, dto.getBonAllowance_07_06()); 	// ܗ^x07_06
		if( null != dto.getBonAllowance_08_06())    setValue_chk( odsBean, Column, Line +   8, dto.getBonAllowance_08_06()); 	// ܗ^x08_06
		if( null != dto.getBonAllowance_09_06())    setValue_chk( odsBean, Column, Line +   9, dto.getBonAllowance_09_06()); 	// ܗ^x09_06
		if( null != dto.getBonAllowance_10_06())    setValue_chk( odsBean, Column, Line +  10, dto.getBonAllowance_10_06()); 	// ܗ^x10_06
		if( null != dto. getBonAllowanceTotal_06()) setValue_chk( odsBean, Column, Line +  11, dto. getBonAllowanceTotal_06()); 	// ܗ^x6ڌv

		
		Line   = 97;
		Column = 21; // Nԍv
		if( null != dto.getBonTotalAllowance_01())   setValue_chk( odsBean, Column, Line +   1, dto.getBonTotalAllowance_01()); 	// ܗ^x01v
		if( null != dto.getBonTotalAllowance_02())   setValue_chk( odsBean, Column, Line +   2, dto.getBonTotalAllowance_02()); 	// ܗ^x02v
		if( null != dto.getBonTotalAllowance_03())   setValue_chk( odsBean, Column, Line +   3, dto.getBonTotalAllowance_03()); 	// ܗ^x03v
		if( null != dto.getBonTotalAllowance_04())   setValue_chk( odsBean, Column, Line +   4, dto.getBonTotalAllowance_04()); 	// ܗ^x04v
		if( null != dto.getBonTotalAllowance_05())   setValue_chk( odsBean, Column, Line +   5, dto.getBonTotalAllowance_05()); 	// ܗ^x05v
		if( null != dto.getBonTotalAllowance_06())   setValue_chk( odsBean, Column, Line +   6, dto.getBonTotalAllowance_06()); 	// ܗ^x06v
		if( null != dto.getBonTotalAllowance_07())   setValue_chk( odsBean, Column, Line +   7, dto.getBonTotalAllowance_07()); 	// ܗ^x07v
		if( null != dto.getBonTotalAllowance_08())   setValue_chk( odsBean, Column, Line +   8, dto.getBonTotalAllowance_08()); 	// ܗ^x08v
		if( null != dto.getBonTotalAllowance_09())   setValue_chk( odsBean, Column, Line +   9, dto.getBonTotalAllowance_09()); 	// ܗ^x09v
		if( null != dto.getBonTotalAllowance_10())   setValue_chk( odsBean, Column, Line +  10, dto.getBonTotalAllowance_10()); 	// ܗ^x10v
		if( null != dto.getBonTotalAllowanceTotal()) setValue_chk( odsBean, Column, Line +  11, dto.getBonTotalAllowanceTotal()); 	// ܗ^xڍv

		// ܗ^T׏o
		Line   = 110;
		Column =   3; // 1
		if( null != dto.getBonDeduction_01_01())   setValue_chk( odsBean, Column, Line +   1, dto.getBonDeduction_01_01());	// ܗ^T01_01
		if( null != dto.getBonDeduction_02_01())   setValue_chk( odsBean, Column, Line +   2, dto.getBonDeduction_02_01());	// ܗ^T02_01
		if( null != dto.getBonDeduction_03_01())   setValue_chk( odsBean, Column, Line +   3, dto.getBonDeduction_03_01());	// ܗ^T03_01
		if( null != dto.getBonDeduction_04_01())   setValue_chk( odsBean, Column, Line +   4, dto.getBonDeduction_04_01());	// ܗ^T04_01
		if( null != dto.getBonDeduction_05_01())   setValue_chk( odsBean, Column, Line +   5, dto.getBonDeduction_05_01());	// ܗ^T05_01
		if( null != dto.getBonDeduction_06_01())   setValue_chk( odsBean, Column, Line +   6, dto.getBonDeduction_06_01());	// ܗ^T06_01
		if( null != dto.getBonDeduction_07_01())   setValue_chk( odsBean, Column, Line +   7, dto.getBonDeduction_07_01());	// ܗ^T07_01
		if( null != dto.getBonDeduction_08_01())   setValue_chk( odsBean, Column, Line +   8, dto.getBonDeduction_08_01());	// ܗ^T08_01
		if( null != dto.getBonDeduction_09_01())   setValue_chk( odsBean, Column, Line +   9, dto.getBonDeduction_09_01());	// ܗ^T09_01
		if( null != dto.getBonDeduction_10_01())   setValue_chk( odsBean, Column, Line +  10, dto.getBonDeduction_10_01());	// ܗ^T10_01
		if( null != dto.getBonDeduction_11_01())   setValue_chk( odsBean, Column, Line +  11, dto.getBonDeduction_11_01());	// ܗ^T11_01
		if( null != dto.getBonDeduction_12_01())   setValue_chk( odsBean, Column, Line +  12, dto.getBonDeduction_12_01());	// ܗ^T12_01
		if( null != dto.getBonDeduction_14_01())   setValue_chk( odsBean, Column, Line +  13, dto.getBonDeduction_14_01());	// ܗ^T14_01
		if( null != dto.getBonDeduction_15_01())   setValue_chk( odsBean, Column, Line +  14, dto.getBonDeduction_15_01());	// ܗ^T15_01
		if( null != dto.getBonDeduction_16_01())   setValue_chk( odsBean, Column, Line +  15, dto.getBonDeduction_16_01());	// ܗ^T16_01
		if( null != dto.getBonDeduction_17_01())   setValue_chk( odsBean, Column, Line +  16, dto.getBonDeduction_17_01());	// ܗ^T17_01
		if( null != dto.getBonDeductionTotal_01()) setValue_chk( odsBean, Column, Line +  17, dto.getBonDeductionTotal_01());	// ܗ^1ڍTڌv
		if( null != dto.getBonPaymentTotal_01())   setValue_chk( odsBean, Column, Line +  18, dto.getBonPaymentTotal_01());	// ܗ^1ڍxzv
		if( null != dto.getBonBank1PayAmount_01()) setValue_chk( odsBean, Column, Line +  19, dto.getBonBank1PayAmount_01());	// ܗ^1ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_01()) setValue_chk( odsBean, Column, Line +  20, dto.getBonBank2PayAmount_01());	// ܗ^1ڋs2Uzv
		if( null != dto.getBonCashPayAmount_01())  setValue_chk( odsBean, Column, Line +  21, dto.getBonCashPayAmount_01());	// ܗ^1ڌxzv

		Line   = 110;
		Column =   6; // 2
		if( null != dto.getBonDeduction_01_02())   setValue_chk( odsBean, Column, Line +   1, dto.getBonDeduction_01_02());	// ܗ^T01_02
		if( null != dto.getBonDeduction_02_02())   setValue_chk( odsBean, Column, Line +   2, dto.getBonDeduction_02_02());	// ܗ^T02_02
		if( null != dto.getBonDeduction_03_02())   setValue_chk( odsBean, Column, Line +   3, dto.getBonDeduction_03_02());	// ܗ^T03_02
		if( null != dto.getBonDeduction_04_02())   setValue_chk( odsBean, Column, Line +   4, dto.getBonDeduction_04_02());	// ܗ^T04_02
		if( null != dto.getBonDeduction_05_02())   setValue_chk( odsBean, Column, Line +   5, dto.getBonDeduction_05_02());	// ܗ^T05_02
		if( null != dto.getBonDeduction_06_02())   setValue_chk( odsBean, Column, Line +   6, dto.getBonDeduction_06_02());	// ܗ^T06_02
		if( null != dto.getBonDeduction_07_02())   setValue_chk( odsBean, Column, Line +   7, dto.getBonDeduction_07_02());	// ܗ^T07_02
		if( null != dto.getBonDeduction_08_02())   setValue_chk( odsBean, Column, Line +   8, dto.getBonDeduction_08_02());	// ܗ^T08_02
		if( null != dto.getBonDeduction_09_02())   setValue_chk( odsBean, Column, Line +   9, dto.getBonDeduction_09_02());	// ܗ^T09_02
		if( null != dto.getBonDeduction_10_02())   setValue_chk( odsBean, Column, Line +  10, dto.getBonDeduction_10_02());	// ܗ^T10_02
		if( null != dto.getBonDeduction_11_02())   setValue_chk( odsBean, Column, Line +  11, dto.getBonDeduction_11_02());	// ܗ^T11_02
		if( null != dto.getBonDeduction_12_02())   setValue_chk( odsBean, Column, Line +  12, dto.getBonDeduction_12_02());	// ܗ^T12_02
		if( null != dto.getBonDeduction_14_02())   setValue_chk( odsBean, Column, Line +  13, dto.getBonDeduction_14_02());	// ܗ^T14_02
		if( null != dto.getBonDeduction_15_02())   setValue_chk( odsBean, Column, Line +  14, dto.getBonDeduction_15_02());	// ܗ^T15_02
		if( null != dto.getBonDeduction_16_02())   setValue_chk( odsBean, Column, Line +  15, dto.getBonDeduction_16_02());	// ܗ^T16_02
		if( null != dto.getBonDeduction_17_02())   setValue_chk( odsBean, Column, Line +  16, dto.getBonDeduction_17_02());	// ܗ^T17_02
		if( null != dto.getBonDeductionTotal_02()) setValue_chk( odsBean, Column, Line +  17, dto.getBonDeductionTotal_02());	// ܗ^2ڍTڌv
		if( null != dto.getBonPaymentTotal_02())   setValue_chk( odsBean, Column, Line +  18, dto.getBonPaymentTotal_02());	// ܗ^2ڍxzv
		if( null != dto.getBonBank1PayAmount_02()) setValue_chk( odsBean, Column, Line +  19, dto.getBonBank1PayAmount_02());	// ܗ^2ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_02()) setValue_chk( odsBean, Column, Line +  20, dto.getBonBank2PayAmount_02());	// ܗ^2ڋs2Uzv
		if( null != dto.getBonCashPayAmount_02())  setValue_chk( odsBean, Column, Line +  21, dto.getBonCashPayAmount_02());	// ܗ^2ڌxzv

		Line   = 110;
		Column =   9; // 3
		if( null != dto.getBonDeduction_01_03())   setValue_chk( odsBean, Column, Line +   1, dto.getBonDeduction_01_03());	// ܗ^T01_03
		if( null != dto.getBonDeduction_02_03())   setValue_chk( odsBean, Column, Line +   2, dto.getBonDeduction_02_03());	// ܗ^T02_03
		if( null != dto.getBonDeduction_03_03())   setValue_chk( odsBean, Column, Line +   3, dto.getBonDeduction_03_03());	// ܗ^T03_03
		if( null != dto.getBonDeduction_04_03())   setValue_chk( odsBean, Column, Line +   4, dto.getBonDeduction_04_03());	// ܗ^T04_03
		if( null != dto.getBonDeduction_05_03())   setValue_chk( odsBean, Column, Line +   5, dto.getBonDeduction_05_03());	// ܗ^T05_03
		if( null != dto.getBonDeduction_06_03())   setValue_chk( odsBean, Column, Line +   6, dto.getBonDeduction_06_03());	// ܗ^T06_03
		if( null != dto.getBonDeduction_07_03())   setValue_chk( odsBean, Column, Line +   7, dto.getBonDeduction_07_03());	// ܗ^T07_03
		if( null != dto.getBonDeduction_08_03())   setValue_chk( odsBean, Column, Line +   8, dto.getBonDeduction_08_03());	// ܗ^T08_03
		if( null != dto.getBonDeduction_09_03())   setValue_chk( odsBean, Column, Line +   9, dto.getBonDeduction_09_03());	// ܗ^T09_03
		if( null != dto.getBonDeduction_10_03())   setValue_chk( odsBean, Column, Line +  10, dto.getBonDeduction_10_03());	// ܗ^T10_03
		if( null != dto.getBonDeduction_11_03())   setValue_chk( odsBean, Column, Line +  11, dto.getBonDeduction_11_03());	// ܗ^T11_03
		if( null != dto.getBonDeduction_12_03())   setValue_chk( odsBean, Column, Line +  12, dto.getBonDeduction_12_03());	// ܗ^T12_03
		if( null != dto.getBonDeduction_14_03())   setValue_chk( odsBean, Column, Line +  13, dto.getBonDeduction_14_03());	// ܗ^T14_03
		if( null != dto.getBonDeduction_15_03())   setValue_chk( odsBean, Column, Line +  14, dto.getBonDeduction_15_03());	// ܗ^T15_03
		if( null != dto.getBonDeduction_16_03())   setValue_chk( odsBean, Column, Line +  15, dto.getBonDeduction_16_03());	// ܗ^T16_03
		if( null != dto.getBonDeduction_17_03())   setValue_chk( odsBean, Column, Line +  16, dto.getBonDeduction_17_03());	// ܗ^T17_03
		if( null != dto.getBonDeductionTotal_03()) setValue_chk( odsBean, Column, Line +  17, dto.getBonDeductionTotal_03());	// ܗ^3ڍTڌv
		if( null != dto.getBonPaymentTotal_03())   setValue_chk( odsBean, Column, Line +  18, dto.getBonPaymentTotal_03());	// ܗ^3ڍxzv
		if( null != dto.getBonBank1PayAmount_03()) setValue_chk( odsBean, Column, Line +  19, dto.getBonBank1PayAmount_03());	// ܗ^3ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_03()) setValue_chk( odsBean, Column, Line +  20, dto.getBonBank2PayAmount_03());	// ܗ^3ڋs2Uzv
		if( null != dto.getBonCashPayAmount_03())  setValue_chk( odsBean, Column, Line +  21, dto.getBonCashPayAmount_03());	// ܗ^3ڌxzv

		Line   = 110;
		Column =  12; // 4
		if( null != dto.getBonDeduction_01_04())   setValue_chk( odsBean, Column, Line +   1, dto.getBonDeduction_01_04());	// ܗ^T01_04
		if( null != dto.getBonDeduction_02_04())   setValue_chk( odsBean, Column, Line +   2, dto.getBonDeduction_02_04());	// ܗ^T02_04
		if( null != dto.getBonDeduction_03_04())   setValue_chk( odsBean, Column, Line +   3, dto.getBonDeduction_03_04());	// ܗ^T03_04
		if( null != dto.getBonDeduction_04_04())   setValue_chk( odsBean, Column, Line +   4, dto.getBonDeduction_04_04());	// ܗ^T04_04
		if( null != dto.getBonDeduction_05_04())   setValue_chk( odsBean, Column, Line +   5, dto.getBonDeduction_05_04());	// ܗ^T05_04
		if( null != dto.getBonDeduction_06_04())   setValue_chk( odsBean, Column, Line +   6, dto.getBonDeduction_06_04());	// ܗ^T06_04
		if( null != dto.getBonDeduction_07_04())   setValue_chk( odsBean, Column, Line +   7, dto.getBonDeduction_07_04());	// ܗ^T07_04
		if( null != dto.getBonDeduction_08_04())   setValue_chk( odsBean, Column, Line +   8, dto.getBonDeduction_08_04());	// ܗ^T08_04
		if( null != dto.getBonDeduction_09_04())   setValue_chk( odsBean, Column, Line +   9, dto.getBonDeduction_09_04());	// ܗ^T09_04
		if( null != dto.getBonDeduction_10_04())   setValue_chk( odsBean, Column, Line +  10, dto.getBonDeduction_10_04());	// ܗ^T10_04
		if( null != dto.getBonDeduction_11_04())   setValue_chk( odsBean, Column, Line +  11, dto.getBonDeduction_11_04());	// ܗ^T11_04
		if( null != dto.getBonDeduction_12_04())   setValue_chk( odsBean, Column, Line +  12, dto.getBonDeduction_12_04());	// ܗ^T12_04
		if( null != dto.getBonDeduction_14_04())   setValue_chk( odsBean, Column, Line +  13, dto.getBonDeduction_14_04());	// ܗ^T14_04
		if( null != dto.getBonDeduction_15_04())   setValue_chk( odsBean, Column, Line +  14, dto.getBonDeduction_15_04());	// ܗ^T15_04
		if( null != dto.getBonDeduction_16_04())   setValue_chk( odsBean, Column, Line +  15, dto.getBonDeduction_16_04());	// ܗ^T16_04
		if( null != dto.getBonDeduction_17_04())   setValue_chk( odsBean, Column, Line +  16, dto.getBonDeduction_17_04());	// ܗ^T17_04
		if( null != dto.getBonDeductionTotal_04()) setValue_chk( odsBean, Column, Line +  17, dto.getBonDeductionTotal_04());	// ܗ^4ڍTڌv
		if( null != dto.getBonPaymentTotal_04())   setValue_chk( odsBean, Column, Line +  18, dto.getBonPaymentTotal_04());	// ܗ^4ڍxzv
		if( null != dto.getBonBank1PayAmount_04()) setValue_chk( odsBean, Column, Line +  19, dto.getBonBank1PayAmount_04());	// ܗ^4ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_04()) setValue_chk( odsBean, Column, Line +  20, dto.getBonBank2PayAmount_04());	// ܗ^4ڋs2Uzv
		if( null != dto.getBonCashPayAmount_04())  setValue_chk( odsBean, Column, Line +  21, dto.getBonCashPayAmount_04());	// ܗ^4ڌxzv

		Line   = 110;
		Column =  15; // 5
		if( null != dto.getBonDeduction_01_05())   setValue_chk( odsBean, Column, Line +   1, dto.getBonDeduction_01_05());	// ܗ^T01_05
		if( null != dto.getBonDeduction_02_05())   setValue_chk( odsBean, Column, Line +   2, dto.getBonDeduction_02_05());	// ܗ^T02_05
		if( null != dto.getBonDeduction_03_05())   setValue_chk( odsBean, Column, Line +   3, dto.getBonDeduction_03_05());	// ܗ^T03_05
		if( null != dto.getBonDeduction_04_05())   setValue_chk( odsBean, Column, Line +   4, dto.getBonDeduction_04_05());	// ܗ^T04_05
		if( null != dto.getBonDeduction_05_05())   setValue_chk( odsBean, Column, Line +   5, dto.getBonDeduction_05_05());	// ܗ^T05_05
		if( null != dto.getBonDeduction_06_05())   setValue_chk( odsBean, Column, Line +   6, dto.getBonDeduction_06_05());	// ܗ^T06_05
		if( null != dto.getBonDeduction_07_05())   setValue_chk( odsBean, Column, Line +   7, dto.getBonDeduction_07_05());	// ܗ^T07_05
		if( null != dto.getBonDeduction_08_05())   setValue_chk( odsBean, Column, Line +   8, dto.getBonDeduction_08_05());	// ܗ^T08_05
		if( null != dto.getBonDeduction_09_05())   setValue_chk( odsBean, Column, Line +   9, dto.getBonDeduction_09_05());	// ܗ^T09_05
		if( null != dto.getBonDeduction_10_05())   setValue_chk( odsBean, Column, Line +  10, dto.getBonDeduction_10_05());	// ܗ^T10_05
		if( null != dto.getBonDeduction_11_05())   setValue_chk( odsBean, Column, Line +  11, dto.getBonDeduction_11_05());	// ܗ^T11_05
		if( null != dto.getBonDeduction_12_05())   setValue_chk( odsBean, Column, Line +  12, dto.getBonDeduction_12_05());	// ܗ^T12_05
		if( null != dto.getBonDeduction_14_05())   setValue_chk( odsBean, Column, Line +  13, dto.getBonDeduction_14_05());	// ܗ^T14_05
		if( null != dto.getBonDeduction_15_05())   setValue_chk( odsBean, Column, Line +  14, dto.getBonDeduction_15_05());	// ܗ^T15_05
		if( null != dto.getBonDeduction_16_05())   setValue_chk( odsBean, Column, Line +  15, dto.getBonDeduction_16_05());	// ܗ^T16_05
		if( null != dto.getBonDeduction_17_05())   setValue_chk( odsBean, Column, Line +  16, dto.getBonDeduction_17_05());	// ܗ^T17_05
		if( null != dto.getBonDeductionTotal_05()) setValue_chk( odsBean, Column, Line +  17, dto.getBonDeductionTotal_05());	// ܗ^5ڍTڌv
		if( null != dto.getBonPaymentTotal_05())   setValue_chk( odsBean, Column, Line +  18, dto.getBonPaymentTotal_05());	// ܗ^5ڍxzv
		if( null != dto.getBonBank1PayAmount_05()) setValue_chk( odsBean, Column, Line +  19, dto.getBonBank1PayAmount_05());	// ܗ^5ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_05()) setValue_chk( odsBean, Column, Line +  20, dto.getBonBank2PayAmount_05());	// ܗ^5ڋs2Uzv
		if( null != dto.getBonCashPayAmount_05())  setValue_chk( odsBean, Column, Line +  21, dto.getBonCashPayAmount_05());	// ܗ^5ڌxzv

		Line   = 110;
		Column =  18; // 6
		if( null != dto.getBonDeduction_01_06())   setValue_chk( odsBean, Column, Line +   1, dto.getBonDeduction_01_06());	// ܗ^T01_06
		if( null != dto.getBonDeduction_02_06())   setValue_chk( odsBean, Column, Line +   2, dto.getBonDeduction_02_06());	// ܗ^T02_06
		if( null != dto.getBonDeduction_03_06())   setValue_chk( odsBean, Column, Line +   3, dto.getBonDeduction_03_06());	// ܗ^T03_06
		if( null != dto.getBonDeduction_04_06())   setValue_chk( odsBean, Column, Line +   4, dto.getBonDeduction_04_06());	// ܗ^T04_06
		if( null != dto.getBonDeduction_05_06())   setValue_chk( odsBean, Column, Line +   5, dto.getBonDeduction_05_06());	// ܗ^T05_06
		if( null != dto.getBonDeduction_06_06())   setValue_chk( odsBean, Column, Line +   6, dto.getBonDeduction_06_06());	// ܗ^T06_06
		if( null != dto.getBonDeduction_07_06())   setValue_chk( odsBean, Column, Line +   7, dto.getBonDeduction_07_06());	// ܗ^T07_06
		if( null != dto.getBonDeduction_08_06())   setValue_chk( odsBean, Column, Line +   8, dto.getBonDeduction_08_06());	// ܗ^T08_06
		if( null != dto.getBonDeduction_09_06())   setValue_chk( odsBean, Column, Line +   9, dto.getBonDeduction_09_06());	// ܗ^T09_06
		if( null != dto.getBonDeduction_10_06())   setValue_chk( odsBean, Column, Line +  10, dto.getBonDeduction_10_06());	// ܗ^T10_06
		if( null != dto.getBonDeduction_11_06())   setValue_chk( odsBean, Column, Line +  11, dto.getBonDeduction_11_06());	// ܗ^T11_06
		if( null != dto.getBonDeduction_12_06())   setValue_chk( odsBean, Column, Line +  12, dto.getBonDeduction_12_06());	// ܗ^T12_06
		if( null != dto.getBonDeduction_14_06())   setValue_chk( odsBean, Column, Line +  13, dto.getBonDeduction_14_06());	// ܗ^T14_06
		if( null != dto.getBonDeduction_15_06())   setValue_chk( odsBean, Column, Line +  14, dto.getBonDeduction_15_06());	// ܗ^T15_06
		if( null != dto.getBonDeduction_16_06())   setValue_chk( odsBean, Column, Line +  15, dto.getBonDeduction_16_06());	// ܗ^T16_06
		if( null != dto.getBonDeduction_17_06())   setValue_chk( odsBean, Column, Line +  16, dto.getBonDeduction_17_06());	// ܗ^T17_06
		if( null != dto.getBonDeductionTotal_06()) setValue_chk( odsBean, Column, Line +  17, dto.getBonDeductionTotal_06());	// ܗ^6ڍTڌv
		if( null != dto.getBonPaymentTotal_06())   setValue_chk( odsBean, Column, Line +  18, dto.getBonPaymentTotal_06());	// ܗ^6ڍxzv
		if( null != dto.getBonBank1PayAmount_06()) setValue_chk( odsBean, Column, Line +  19, dto.getBonBank1PayAmount_06());	// ܗ^6ڋs1Uzv
		if( null != dto.getBonBank2PayAmount_06()) setValue_chk( odsBean, Column, Line +  20, dto.getBonBank2PayAmount_06());	// ܗ^6ڋs2Uzv
		if( null != dto.getBonCashPayAmount_06())  setValue_chk( odsBean, Column, Line +  21, dto.getBonCashPayAmount_06());	// ܗ^6ڌxzv

		Line   = 110;
		Column =  21; // Nԍv
		if( null != dto.getBonTotalDeduction_01())   setValue_chk( odsBean, Column, Line +   1, dto.getBonTotalDeduction_01());	// ܗ^T01NԌv
		if( null != dto.getBonTotalDeduction_02())   setValue_chk( odsBean, Column, Line +   2, dto.getBonTotalDeduction_02());	// ܗ^T02NԌv
		if( null != dto.getBonTotalDeduction_03())   setValue_chk( odsBean, Column, Line +   3, dto.getBonTotalDeduction_03());	// ܗ^T03NԌv
		if( null != dto.getBonTotalDeduction_04())   setValue_chk( odsBean, Column, Line +   4, dto.getBonTotalDeduction_04());	// ܗ^T04NԌv
		if( null != dto.getBonTotalDeduction_05())   setValue_chk( odsBean, Column, Line +   5, dto.getBonTotalDeduction_05());	// ܗ^T05NԌv
		if( null != dto.getBonTotalDeduction_06())   setValue_chk( odsBean, Column, Line +   6, dto.getBonTotalDeduction_06());	// ܗ^T06NԌv
		if( null != dto.getBonTotalDeduction_07())   setValue_chk( odsBean, Column, Line +   7, dto.getBonTotalDeduction_07());	// ܗ^T07NԌv
		if( null != dto.getBonTotalDeduction_08())   setValue_chk( odsBean, Column, Line +   8, dto.getBonTotalDeduction_08());	// ܗ^T08NԌv
		if( null != dto.getBonTotalDeduction_09())   setValue_chk( odsBean, Column, Line +   9, dto.getBonTotalDeduction_09());	// ܗ^T09NԌv
		if( null != dto.getBonTotalDeduction_10())   setValue_chk( odsBean, Column, Line +  10, dto.getBonTotalDeduction_10());	// ܗ^T10NԌv
		if( null != dto.getBonTotalDeduction_11())   setValue_chk( odsBean, Column, Line +  11, dto.getBonTotalDeduction_11());	// ܗ^T11NԌv
		if( null != dto.getBonTotalDeduction_12())   setValue_chk( odsBean, Column, Line +  12, dto.getBonTotalDeduction_12());	// ܗ^T12NԌv
		if( null != dto.getBonTotalDeduction_14())   setValue_chk( odsBean, Column, Line +  13, dto.getBonTotalDeduction_14());	// ܗ^T14NԌv
		if( null != dto.getBonTotalDeduction_15())   setValue_chk( odsBean, Column, Line +  14, dto.getBonTotalDeduction_15());	// ܗ^T15NԌv
		if( null != dto.getBonTotalDeduction_16())   setValue_chk( odsBean, Column, Line +  15, dto.getBonTotalDeduction_16());	// ܗ^T16NԌv
		if( null != dto.getBonTotalDeduction_17())   setValue_chk( odsBean, Column, Line +  16, dto.getBonTotalDeduction_17());	// ܗ^T17NԌv
		if( null != dto.getBonTotalDeductionTotal()) setValue_chk( odsBean, Column, Line +  17, dto.getBonTotalDeductionTotal());	// ܗ^Tڍv
		if( null != dto.getBonTotalPaymentTotal())   setValue_chk( odsBean, Column, Line +  18, dto.getBonTotalPaymentTotal());	// ܗ^xzvv
		if( null != dto.getBonTotalBank1PayAmount()) setValue_chk( odsBean, Column, Line +  19, dto.getBonTotalBank1PayAmount());	// ܗ^s1Uzvv
		if( null != dto.getBonTotalBank2PayAmount()) setValue_chk( odsBean, Column, Line +  20, dto.getBonTotalBank2PayAmount());	// ܗ^s2Uzvv
		if( null != dto.getBonTotalCashPayAmount())  setValue_chk( odsBean, Column, Line +  21, dto.getBonTotalCashPayAmount());	// ܗ^xzvv

		// }{T\
		Line   = 126;
		Column =  28;
		if( null != dto.getIncomeTaxType())     setValue_chk( odsBean, Column +   0, Line +   0, dto.getIncomeTaxType());	// ېŋ敪
		if( null != dto.getAdjustmentType())    setValue_chk( odsBean, Column +   0, Line +   1, dto.getAdjustmentType());	// N敪
		if( null != dto.getSelfWidowType())     setValue_chk( odsBean, Column +   0, Line +   2, dto.getSelfWidowType());	// {l敪PF{lǕw敪
		if( null != dto.getSelfHandicapType())  setValue_chk( odsBean, Column +   0, Line +   3, dto.getSelfHandicapType());	// {l敪QF{lQ敪
		if( null != dto.getSelfStudentType())   setValue_chk( odsBean, Column +   0, Line +   4, dto.getSelfStudentType());	// {l敪RF{lw敪
		if( null != dto.getSpouseIntendType())  setValue_chk( odsBean, Column +   0, Line +   5, dto.getSpouseIntendType());	// zҋ敪
		if( null != dto.getGeneralDependent())  setValue_chk( odsBean, Column +   6, Line +   0, dto.getGeneralDependent());	// ʕ}{e
		if( null != dto.getSpecificDependent()) setValue_chk( odsBean, Column +   6, Line +   1, dto.getSpecificDependent());	// }{e
		if( null != dto.getElderlyDependent())  setValue_chk( odsBean, Column +   6, Line +   2, dto.getElderlyDependent());	// Vl}{e
		if( null != dto.getLiveWithEldRel())    setValue_chk( odsBean, Column +   6, Line +   3, dto.getLiveWithEldRel());	// Vle
		if( null != dto.getGeneralHandicap())   setValue_chk( odsBean, Column +   6, Line +   5, dto.getGeneralHandicap());	// ʏQ
		if( null != dto.getLiveWithHandiGe())   setValue_chk( odsBean, Column +  12, Line +   0, dto.getLiveWithHandiGe());	// 
		if( null != dto.getLiveWithHandiSp())   setValue_chk( odsBean, Column +  12, Line +   1, dto.getLiveWithHandiSp());	// 
		if( null != dto.getLiveWithHandiEl())   setValue_chk( odsBean, Column +  12, Line +   2, dto.getLiveWithHandiEl());	// Vl
		if( null != dto.getLiveWithHandiEr())   setValue_chk( odsBean, Column +  12, Line +   3, dto.getLiveWithHandiEr());	// Ve
		if( null != dto.getSpecificHandicap())  setValue_chk( odsBean, Column +  12, Line +   5, dto.getSpecificHandicap());	// ʏQ

		// l
		if((null != dto.getGender()) && (dto.getGender().equals("2"))){
			setValue_chk( odsBean, 13, 134, "");									// 
		}else{
			setValue_chk( odsBean, 13, 134, "j");									// 
		}
		Line   = 135;
		Column =  13;
		setValue_chk( odsBean, Column + 0, Line +   0, dto.getBirthDate());			// N		
		setValue_chk( odsBean, Column + 0, Line +   1, dto.getEntranceDate());		// Г		
		setValue_chk( odsBean, Column + 0, Line +   2, dto.getRetirementDate());		// ގГ		

		
		Line   = 134;
		Column =  21;
		setValue_chk( odsBean, Column + 0, Line +   0, dto.getPostalCode());			// ZiX֔ԍj
		setValue_chk( odsBean, Column + 0, Line +   1, dto.getAddress());				// Z
		setValue_chk( odsBean, Column + 0, Line +   3, dto.getPhoneNumber());			// dbԍ		

		Line   = 134;
		Column =  32;
		setValue_chk( odsBean, Column + 0, Line +   0, dto.getHealthNo());			// Nیԍ
		setValue_chk( odsBean, Column + 6, Line +   0, dto.getFundNo());				// ԍ
		setValue_chk( odsBean, Column + 0, Line +   2, dto.getPensionNo());			// bNԍ
		setValue_chk( odsBean, Column + 6, Line +   2, dto.getUnemployNo());			// ٗpیԍ
		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + 
										PayrollConst.FILE_NAME_SEPARATOR +
										dto.getKCode()	+
										PayrollConst.FILE_NAME_SEPARATOR +
										PayrollConst.FILE_PAYMENTLEDGER_ODS;

		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}
	
	
	
	
	
	
	


}
