/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class ResidenceTaxDto extends BaseDto {
	
	private static final long serialVersionUID = 1958389383485471274L;
	//tB[h
	protected String kCode              = "";// ЈR[h
	protected Date   calcDate               ;// vZN
	protected Date   payday                 ;// ^x
	protected String calcStatus         = "";// vZXe[^X
	protected String kName              = "";// Ј
	protected int residenceTax         = 0;// Z
	protected String cityCode           = "";// sR[h
	protected String cityName           = "";// s
	protected String paymentCityCode    = "";// [tsR[h
	
	/**
	 * RXgN^
	 */
	public ResidenceTaxDto(){
		super();
	}
	
	//ANZT\bh
	public String getKCode             () { return kCode                 ; }	// ЈR[h
	public Date   getCalcDate          () { return getDateField(calcDate); }	// vZN
	public Date   getPayday            () { return getDateField(payday  ); }	// ^x
	public String getCalcStatus        () { return calcStatus            ; }	// vZXe[^X
	public String getKName             () { return kName                 ; }	// Ј
	public int getResidenceTax      () { return residenceTax          ; }	// Z
	public String getCityCode          () { return cityCode              ; }	// sR[h
	public String getCityName          () { return cityName              ; }	// s
	public String getPaymentCityCode   () { return paymentCityCode                 ; }	// [tsR[h
	
	public void setKCode             (String kCode             ) { this.kCode              = kCode                 ; }	// ЈR[h
	public void setCalcDate          (Date   calcDate          ) { this.calcDate           = getDateField(calcDate); }	// vZN
	public void setPayday            (Date   payday            ) { this.payday             = getDateField(payday)  ; }	// ^x
	public void setCalcStatus        (String calcStatus        ) { this.calcStatus         = calcStatus            ; }	// vZXe[^X
	public void setKName             (String kName             ) { this.kName              = kName                 ; }	// Ј
	public void setResidenceTax      (int residenceTax         ) { this.residenceTax          = residenceTax             ; }	// Z
	public void setCityCode          (String cityCode             ) { this.cityCode              = cityCode                 ; }	// sR[h
	public void setCityName          (String cityName             ) { this.cityName              = cityName                 ; }	// s
	public void setPaymentCityCode   (String paymentCityCode      ) { this.paymentCityCode       = paymentCityCode          ; }	// [tsR[h
	
}
