/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class CtRetireDetailDto extends BaseDto {
	
	private static final long serialVersionUID = -4544512011191536993L;
	
	// tB[h
	private String cityCode   ;	//sR[h
	private Date detailMonth  ;	//ސEהN
	private String cityChanges;	//ٓL
	private int retireCount  ;	//ސEl
	private long cityPayAmount;	//xz
	private int cityTax      ;	//s
	private int prefectureTax;	//{

	
	
	/**
	 * RXgN^
	 */
	public CtRetireDetailDto() {
		super();
	}
	
	// ANZT\bh
	public String getCityCode     () { return cityCode     ; }	// sR[h
	public Date getDetailMonth    () { return getDateField(detailMonth)  ; }	// ސEהN
	public String getCityChanges  () { return cityChanges  ; }	// ٓL
	public int getRetireCount    () { return retireCount  ; }	// ސEl
	public long getCityPayAmount () { return cityPayAmount; }	// xz
	public int getCityTax       () { return cityTax      ; }	// s
	public int getPrefectureTax () { return prefectureTax; }	// {
	
	public void setCityCode     (String cityCode     ) { this.cityCode      = cityCode                   ; }	// sR[h
	public void setDetailMonth  (Date   detailMonth  ) { this.detailMonth   = getDateField(detailMonth)  ; }	// ސEהN
	public void setCityChanges  (String cityChanges  ) { this.cityChanges   = cityChanges                ; }	// ٓL
	public void setRetireCount  (int retireCount  ) { this.retireCount   = retireCount  ; }	// ސEl
	public void setCityPayAmount(long cityPayAmount) { this.cityPayAmount = cityPayAmount; }	// xz
	public void setCityTax      (int cityTax      ) { this.cityTax       = cityTax      ; }	// s
	public void setPrefectureTax(int prefectureTax) { this.prefectureTax = prefectureTax; }	// {	
}
