/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.dto.DetailTimeDto;

public class PdPayTimeDao extends DetailTimeDao {
	
	/**
	 *  e[uB<br>
	 */
	public static final String TABLE = "PD_PAY_TIME";
	
	/**
	 * {@link DetailTimeDao#DetailTimeDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PdPayTimeDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private DetailTimeDto mapping() throws SQLException {
		DetailTimeDto dto = new DetailTimeDto();
		dto.setKCode     (rs.getString(COL_KCODE       ));
		dto.setCalcDate  (rs.getDate  (COL_CALC_DATE   ));
		dto.setDetailCode(rs.getString(COL_DETAIL_CODE ));
		dto.setAmount    (rs.getFloat (COL_AMOUNT      ));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ɂf[^擾B(ЈR[hAvZNA׃R[h)<br>
	 * @param kCode     ЈR[h
	 * @param calcDate vZN
	 * @return (DTOList)
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public DetailTimeDto find_detailCode(
			String kCode, Date calcDate, String detailCode 
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_DATE + " = ? ");
		sb.append("AND ");
		sb.append(COL_DETAIL_CODE + " = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam    (index++, kCode    );
			setDateParam(index++, calcDate);
			setParam    (index++, detailCode);
			executeQuery();
			DetailTimeDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

}
