/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.csv.CSVParser;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.AttendanceTotalAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.part.KintaiCommonPart;
import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.kintai.dao.MSyukkinboDao;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.TimeRecordImportCardVo;
import jp.mosp.payroll.dao.MImportFieldDao;
import jp.mosp.payroll.dto.MImportFieldDto;
import jp.mosp.system.dto.MWorkTypeDto;

public class TimeRecordImportCardAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_SHOW		= "P9060";
	private static final String CMD_IMPORT	= "P9061";

	// tB[h
	protected MKihonDao					mKihonDao;
	protected MKihonDto					mKihonDto;

	protected MSyukkinboDao				mSyukkinboDao;

	protected int		late = 0;
	protected int		work = 0;
	protected int		leave = 0;
	protected int		over = 0;
	protected int 		overPremium		= 0;
	protected int 		overNonPremium	= 0;
	protected int		interval = 0;
	protected int		latenight = 0;
	protected int		holidaywork = 0;

	protected int		startTime		= 0;
	protected int		quitTime 		= 0;
	protected int		workTime 		= 0;
	protected int		breakTime 		= 0;
	protected int		overStart	 	= 0;
	protected int		overBreak	 	= 0;
	protected int		allHoliday	 	= 0;
	protected int		halfHoliday	 	= 0;
	protected double	hoursPerDay		= 0;

	
	/**
	 * wb_
	 */
	private String[] aryImportHeaderItem;

	/**
	 * RXgN^
	 */
	public TimeRecordImportCardAction() {
		super();
		setNeedProcSeq(false);

	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new TimeRecordImportCardVo();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VO擾yѐݒ
		prepareVo();
		// e\ڎ擾
		setPulldownList();
		// R}h̏
		if (cmd.equals(CMD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_IMPORT)) {
			importFile();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	private void show() throws Exception {
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		vo.setSelectICode(key1);
		aryImportHeaderItem = getTemplateItemArray();
		vo.setLblHeader(makeTemplateCSV().toString());
	}

	/**
	 * C|[g
	 * @throws Exception
	 */
	private void importFile() throws Exception {
		aryImportHeaderItem = getTemplateItemArray();
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		// t@Cݒ
		vo.setImportFile(multipartFieldList);
		// C|[g
		importData();
		vo.initListInfo();
	}

	/**
	 * \pf[^z
	 * @throws Exception
	 */
	private void setPulldownList() throws Exception {
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		vo.aryWorkType			= getWorkTypeArrayNotDeleted();
		vo.aryHolidayReason		= getReasonCodeArray(CommonConst.TID_LEAVE_REASON);
		vo.aryLateReason		= getReasonCodeArray(CommonConst.TID_LATE_REASON);
		vo.aryLeaveEarlyReason	= getReasonCodeArray(CommonConst.TID_LEAVE_EARLY_REASON);
	}

	/**
	 * ev[gڔz
	 * @return aryItem
	 * @throws Exception
	 */
	private String[] getTemplateItemArray() throws Exception {
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		// DAȌ
		MImportFieldDao dao = new MImportFieldDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<MImportFieldDto> list = dao.findForCondition(vo.getSelectICode());
		String[] aryItem = new String[list.size()];
		for (int i = 0; i < list.size(); i++) {
			aryItem[i] = util.getCodeName(list.get(i).getIField(), getImportFieldArray());
		}
		return aryItem;
	}

	/**
	 * C|[g
	 * @throws Exception
	 */
	private void importData() throws Exception {
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		// t@C擾
		File file = getUploadFile(vo.getFilImportFile());
		String[] aryHeader;
		String[][] aryImportData = new String[0][0];
		// CSVt@C
		if (vo.getFilImportFile().getName().matches(".*" + ".csv" + ".*")) {
			// CSVp[Xt@C擾
			CSVParser csvp = parseCSVData(file);
			aryHeader = getCSVHeadData(csvp);
			aryImportData = csvp.getAllValues();
			br.close();
		} else {
			vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_NO_CSV_DATA, ""));
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		// ؍ς݃Xg̍쐬
		List<MSyukkinboDto> listImportData = getImportDataList(aryHeader, aryImportData);
		// vZ
		runAutoCalc(listImportData);
		// o^
		int count = registImportData(listImportData);
		// R~bg
		commit();
		// bZ[W̐ݒ
		vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_NUMBER_OF_UPDATES, String.valueOf(count)));
		// VOɒlZbg
		vo.setFields(listImportData);
	}

	/**
	 * ev[gCSVo͓e
	 * @return sb ev[gCSV
	 */
	private StringBuffer makeTemplateCSV() {
		// [쐬
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		for (int i = 0; i < aryImportHeaderItem.length; i++) {
			// wb_[ݒ
			sb.append(getCsvData(aryImportHeaderItem[i]));
			// Zp[^ݒ
			if (i == aryImportHeaderItem.length - 1) {
				sb.append(CommonConst.STR_CSV_NEW_LINE);
			} else {
				sb.append(CommonConst.STR_CSV_SEPARATOR);
			}
		}
		return sb;
	}

	/**
	 * ؍ς݃C|[g񃊃Xg쐬
	 * @param aryHeader				wb_[z
	 * @param aryImportData			C|[gz
	 * @return listData				؍ςݏoΕ񃊃Xg
	 * @throws Exception
	 */
	private List<MSyukkinboDto> getImportDataList(
			String[] aryHeader,
			String[][] aryImportData
	) throws Exception {
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		if(aryImportData == null){
			vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_NO_CSV_DATA, ""));
			aryImportData = new String[0][0];
		}

		List<MSyukkinboDto> listData = new ArrayList<MSyukkinboDto>();
		// wb_mF
		if (util.checkArraysEquals(aryHeader, aryImportHeaderItem)) {
			for (int i = 0; i < aryImportData.length; i++) {
				MSyukkinboDto dto = new MSyukkinboDto();
				for (int j = 0; j < aryImportHeaderItem.length; j++) {
					if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KCODE)) {
						// ЈR[h𔼊p֓
						dto.setKCode(util.toHankakuKana(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_HIZUKE)) {
						String[] aryHizuke = getDateArray(aryImportData[i][j]);
						// t`FbN
						if (
							ValidateUtility.chkDate(
									vo.getIntParam(aryHizuke[0]),
									vo.getIntParam(aryHizuke[1]) - 1,
									vo.getIntParam(aryHizuke[2])
							)
						) {
							dto.setHizuke(util.convStringDateFormatted(aryHizuke[0], aryHizuke[1], aryHizuke[2]));
						} else {
							dto.setHizuke("");
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SYJIKOKU)) {
						dto.setSyJikoku(convStringTimeFormatted(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KINMU)) {
						dto.setKinmu(aryImportData[i][j]);
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SHANKYUKB)) {
						if (aryImportData[i][j].equals("")
								|| aryImportData[i][j].equals(CommonConst.NUM_START_HALF_HOLIDAY_FLAG_OFF)
								|| aryImportData[i][j].equals(CommonConst.NUM_START_HALF_HOLIDAY_FLAG_ON)
						) {
							dto.setSHankyuKb(aryImportData[i][j]);
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KYUSYUKB)) {
						if (aryImportData[i][j].equals("")
								|| aryImportData[i][j].equals(CommonConst.NUM_WORK_ON_HOLIDAY_FLAG_OFF)
								|| aryImportData[i][j].equals(CommonConst.NUM_WORK_ON_HOLIDAY_FLAG_ON)
						) {
							dto.setKyusyuKb(aryImportData[i][j]);
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_TIRIYUU)) {
						dto.setTiRiyuu(aryImportData[i][j]);
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_TICOMENT)) {
						dto.setTiComent(aryImportData[i][j]);
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_TISYOUMEI)) {
						if (aryImportData[i][j].equals("")
								|| aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setTiSyoumei(aryImportData[i][j]);
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_TIJIKAN)) {
						dto.setTiJikan(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_TAJIKOKU)) {
						dto.setTaJikoku(convStringTimeFormatted(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KINMUJI)) {
						dto.setKinmuJi(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KYUKEIJI)) {
						dto.setKyukeiJi(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_THANKYUKB)) {
						if (aryImportData[i][j].equals("")
								|| aryImportData[i][j].equals(CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_OFF)
								|| aryImportData[i][j].equals(CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_ON)
						) {
							dto.setTHankyuKb(aryImportData[i][j]);
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SORIYUU)) {
						dto.setSoRiyuu(aryImportData[i][j]);
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SOCOMENT)) {
						dto.setSoComent(aryImportData[i][j]);
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SOSYOUMEI)) {
						if (aryImportData[i][j].equals("")
								|| aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setSoSyoumei(aryImportData[i][j]);
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SOJIKAN)) {
						dto.setSoJikan(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_ZAJIKAN)) {
						dto.setZaJikan(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KSJIKAN)) {
						dto.setKsJikan(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SNJIKAN)) {
						dto.setSnJikan(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_SYOKJI)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setSyokuji(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_CYOKU1)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setCyoku1(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_CYOKU2)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setCyoku2(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_CYOKU3)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setCyoku3(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_HOKA1)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setHoka1(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_HOKA2)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setHoka2(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_HOKA3)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setHoka3(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_HOKA4)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setHoka4(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_HOKA5)) {
						if (aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setHoka5(vo.getIntParam(aryImportData[i][j]));
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KKRIYUU)) {
						dto.setKKRiyuu(aryImportData[i][j]);
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_DAIKYUJYU)) {
						String[] aryDaiKyuJyu = getDateArray(aryImportData[i][j]);
						// t`FbN
						if (!aryImportData[i][j].equals("")
								&& ValidateUtility.chkDate(
										vo.getIntParam(aryDaiKyuJyu[0]),
										vo.getIntParam(aryDaiKyuJyu[1]) - 1,
										vo.getIntParam(aryDaiKyuJyu[2])
								)
						) {
							dto.setDaiKyuJyu(util.convStringDateFormatted(aryDaiKyuJyu[0], aryDaiKyuJyu[1], aryDaiKyuJyu[2]));
						} else {
							dto.setDaiKyuJyu("");
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KKCOMENT)) {
						dto.setKKComent(aryImportData[i][j]);
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KKSYOUMEI)) {
						if (aryImportData[i][j].equals("")
								|| aryImportData[i][j].equals("0")
								|| aryImportData[i][j].equals("1")
						) {
							dto.setKKSyoumei(aryImportData[i][j]);
						}
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_KKJIKAN)) {
						dto.setKKJikan(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_NIJIKYU)) {
						dto.setNijiKyu(convStringTimeToIntegerTime(aryImportData[i][j]));
					} else if (aryImportHeaderItem[j].equals(PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN)) {
						dto.setWarimasi1(convStringTimeToIntegerTime(aryImportData[i][j]));
					}
				}
				listData.add(dto);
			}
			if (aryImportData.length == 0) {
				vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_NO_CSV_DATA, ""));
			}
		} else {
			vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_INVALID_HEAD_TYPE, ""));
		}
		// C|[gf[^̌
		listData = getVerifiedList(listData);
		return listData;
	}

	/**
	 * C|[gf[^̌
	 * @param listData C|[gf[^
	 * @return verifiedList ؍ς݃Xg
	 * @throws Exception 
	 */
	private List<MSyukkinboDto> getVerifiedList(
			List<MSyukkinboDto> listData
	) throws Exception {
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		// DAO
		MSyukkinboDao dao = new MSyukkinboDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ؍ς݃Xg
		List<MSyukkinboDto> verifiedList = new ArrayList<MSyukkinboDto>();
		Iterator<MSyukkinboDto> it = listData.iterator();
		while (it.hasNext()) {
			MSyukkinboDto dto = (MSyukkinboDto) it.next();
			StringBuffer code = new StringBuffer();
			// l񌟍
			findHumanBasisInfo(dto.getKCode(), false);
			if (!chkExistDto(mKihonDto)) {
				code.append(1);
			}
			// t`FbN
			if (dto.getHizuke().equals("")) {
				code.append(2);
			}
			// oΕ񌟍
			if (chkExistDto(dao.findForKey(dto.getKCode(), dto.getHizuke()))) {
				code.append(3);
			}
			// Ζ`ԃ`FbN
			if (util.checkNameExist(dto.getKinmu(), vo.aryWorkType)) {
				// Ζ`ԂΖ`Ԃłꍇ
				if (dto.getSyJikoku().equals("")
						|| dto.getTaJikoku().equals("")
				) {
					code.append(4);
				}
			} else if (dto.getKinmu().equals(CommonConst.ATTENDANCE_TYPE_HOLIDAY)) {
				// Ζ`Ԃxɂłꍇ
				if (!util.checkNameExist(dto.getKKRiyuu(), vo.aryHolidayReason)) {
					code.append(5);
				}
			} else if (!dto.getKinmu().equals(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY)) {
				// Ζ`ԂTxłȂꍇ
				code.append(6);
			}
			// xR`FbN
			if (!dto.getTiRiyuu().equals("")
					&& !util.checkNameExist(dto.getTiRiyuu(), vo.aryLateReason)
			) {
				code.append(7);
			}
			// xRg`FbN
			if (!ValidateUtility.chkRegex(".{0,50}", dto.getTiComent())) {
				code.append(8);
			}
			// ޗR`FbN
			if (!dto.getSoRiyuu().equals("")
					&& !util.checkNameExist(dto.getSoRiyuu(), vo.aryLeaveEarlyReason)
			) {
				code.append(9);
			}
			// ރRg`FbN
			if (!ValidateUtility.chkRegex(".{0,50}", dto.getSoComent())) {
				code.append("a");
			}
			// xɃRg`FbN
			if (!ValidateUtility.chkRegex(".{0,50}", dto.getKKComent())) {
				code.append("b");
			}
			// t@Cd`FbN
			for (int i = 0; i < verifiedList.size(); i++) {
				if (verifiedList.get(i).getKCode().equals(dto.getKCode())
						&& verifiedList.get(i).getHizuke().equals(dto.getHizuke())
				) {
					code.append("c");
					break;
				}
			}
			// ،ʂ炻ꂼꔻfB
			if (code.length() == 0) {
				String nowDate = util.getDateTime(util.getNowDate());
				// ȏꍇAKvȏڂZbgB
				dto.setNen		(MospUtility.getYear	(util.convStringDateToDate(dto.getHizuke())));
				dto.setTuki		(MospUtility.getMonth	(util.convStringDateToDate(dto.getHizuke())));
				dto.setHi		(MospUtility.getDay		(util.convStringDateToDate(dto.getHizuke())));
				dto.setSyozoku	(getBelongSectionCode(dto.getKCode()));
				if (!dto.getSyJikoku().equals("")) {
					dto.setSyTimes(nowDate);
				}
				if (!dto.getTaJikoku().equals("")) {
					dto.setTaTimes(nowDate);
				}
				if (dto.getKinmu().equals(CommonConst.ATTENDANCE_TYPE_HOLIDAY)) {
					dto.setKKTimes(nowDate);
				}
				dto.setUpdtTimes(nowDate);
				dto.setSnRiyuu("0");
				// ؍ς݃Xg֒ǉ
				verifiedList.add(dto);
			}
		}
		return verifiedList;
	}

	/**
	 * o^
	 * @param listImportData	؍ς݃Xg
	 * @return insertCount		o^
	 * @throws Exception
	 */
	private int registImportData(List<MSyukkinboDto> listImportData) throws Exception {
		// DAȌ
		MSyukkinboDao dao = new MSyukkinboDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// o^
		int timeRecordCount = 0;
		// 񂷉
		int rev = 0;
		// 
		int div = 100;
		if (listImportData.size() % div == 0) {
			rev = listImportData.size() / div;
		} else {
			rev = listImportData.size() / div + 1;
		}
		for (int i = 0; i < rev; i++) {
			List<MSyukkinboDto> currentList = new ArrayList<MSyukkinboDto>();
			// XgdivƕB
			for (int k = 0; k < div; k++) {
				int count = k + i * div;
				if (count >= listImportData.size()) {
					break;
				}
				MSyukkinboDto dto = listImportData.get(count);
				if (chkExistDto(dto)) {
					currentList.add(dto);
				} else {
					break;
				}
			}
			// XgzɃZbgB
			MSyukkinboDto[] aryTimeRecordData = new MSyukkinboDto[currentList.size()];
			for (int j = 0; j < currentList.size(); j++) {
				aryTimeRecordData[j] = currentList.get(j);
			}
			// o^
			timeRecordCount += dao.insert(aryTimeRecordData);
		}
		return timeRecordCount;
	}

	/**
	 * C|[gtB[hv_E擾
	 * @param table C|[ge[uR[h
	 * @return C|[gtB[hv_Epz
	 */
	private String[][] getImportFieldArray() {
		String[][] aryImportField	= new String[37][2];
		aryImportField[0]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KCODE;
		aryImportField[1]	[0]		= PayrollConst.CODE_IMPORT_FIELD_HIZUKE;
		aryImportField[2]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SYJIKOKU;
		aryImportField[3]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KINMU;
		aryImportField[4]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SHANKYUKB;
		aryImportField[5]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KYUSYUKB;
		aryImportField[6]	[0]		= PayrollConst.CODE_IMPORT_FIELD_TIRIYUU;
		aryImportField[7]	[0]		= PayrollConst.CODE_IMPORT_FIELD_TICOMENT;
		aryImportField[8]	[0]		= PayrollConst.CODE_IMPORT_FIELD_TISYOUMEI;
		aryImportField[9]	[0]		= PayrollConst.CODE_IMPORT_FIELD_TIJIKAN;
		aryImportField[10]	[0]		= PayrollConst.CODE_IMPORT_FIELD_TAJIKOKU;
		aryImportField[11]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KINMUJI;
		aryImportField[12]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KYUKEIJI;
		aryImportField[13]	[0]		= PayrollConst.CODE_IMPORT_FIELD_THANKYUKB;
		aryImportField[14]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SORIYUU;
		aryImportField[15]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SOCOMENT;
		aryImportField[16]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SOSYOUMEI;
		aryImportField[17]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SOJIKAN;
		aryImportField[18]	[0]		= PayrollConst.CODE_IMPORT_FIELD_ZAJIKAN;
		aryImportField[19]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KSJIKAN;
		aryImportField[20]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SNJIKAN;
		aryImportField[21]	[0]		= PayrollConst.CODE_IMPORT_FIELD_SYOKJI;
		aryImportField[22]	[0]		= PayrollConst.CODE_IMPORT_FIELD_CYOKU1;
		aryImportField[23]	[0]		= PayrollConst.CODE_IMPORT_FIELD_CYOKU2;
		aryImportField[24]	[0]		= PayrollConst.CODE_IMPORT_FIELD_CYOKU3;
		aryImportField[25]	[0]		= PayrollConst.CODE_IMPORT_FIELD_HOKA1;
		aryImportField[26]	[0]		= PayrollConst.CODE_IMPORT_FIELD_HOKA2;
		aryImportField[27]	[0]		= PayrollConst.CODE_IMPORT_FIELD_HOKA3;
		aryImportField[28]	[0]		= PayrollConst.CODE_IMPORT_FIELD_HOKA4;
		aryImportField[29]	[0]		= PayrollConst.CODE_IMPORT_FIELD_HOKA5;
		aryImportField[30]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KKRIYUU;
		aryImportField[31]	[0]		= PayrollConst.CODE_IMPORT_FIELD_DAIKYUJYU;
		aryImportField[32]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KKCOMENT;
		aryImportField[33]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KKSYOUMEI;
		aryImportField[34]	[0]		= PayrollConst.CODE_IMPORT_FIELD_KKJIKAN;
		aryImportField[35]	[0]		= PayrollConst.CODE_IMPORT_FIELD_NIJIKYU;
		aryImportField[36]	[0]		= PayrollConst.CODE_IMPORT_FIELD_NZAJIKAN;
		aryImportField[0]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KCODE;
		aryImportField[1]	[1]		= PayrollConst.NAM_IMPORT_FIELD_HIZUKE;
		aryImportField[2]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SYJIKOKU;
		aryImportField[3]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KINMU;
		aryImportField[4]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SHANKYUKB;
		aryImportField[5]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KYUSYUKB;
		aryImportField[6]	[1]		= PayrollConst.NAM_IMPORT_FIELD_TIRIYUU;
		aryImportField[7]	[1]		= PayrollConst.NAM_IMPORT_FIELD_TICOMENT;
		aryImportField[8]	[1]		= PayrollConst.NAM_IMPORT_FIELD_TISYOUMEI;
		aryImportField[9]	[1]		= PayrollConst.NAM_IMPORT_FIELD_TIJIKAN;
		aryImportField[10]	[1]		= PayrollConst.NAM_IMPORT_FIELD_TAJIKOKU;
		aryImportField[11]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KINMUJI;
		aryImportField[12]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KYUKEIJI;
		aryImportField[13]	[1]		= PayrollConst.NAM_IMPORT_FIELD_THANKYUKB;
		aryImportField[14]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SORIYUU;
		aryImportField[15]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SOCOMENT;
		aryImportField[16]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SOSYOUMEI;
		aryImportField[17]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SOJIKAN;
		aryImportField[18]	[1]		= PayrollConst.NAM_IMPORT_FIELD_ZAJIKAN;
		aryImportField[19]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KSJIKAN;
		aryImportField[20]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SNJIKAN;
		aryImportField[21]	[1]		= PayrollConst.NAM_IMPORT_FIELD_SYOKJI;
		aryImportField[22]	[1]		= PayrollConst.NAM_IMPORT_FIELD_CYOKU1;
		aryImportField[23]	[1]		= PayrollConst.NAM_IMPORT_FIELD_CYOKU2;
		aryImportField[24]	[1]		= PayrollConst.NAM_IMPORT_FIELD_CYOKU3;
		aryImportField[25]	[1]		= PayrollConst.NAM_IMPORT_FIELD_HOKA1;
		aryImportField[26]	[1]		= PayrollConst.NAM_IMPORT_FIELD_HOKA2;
		aryImportField[27]	[1]		= PayrollConst.NAM_IMPORT_FIELD_HOKA3;
		aryImportField[28]	[1]		= PayrollConst.NAM_IMPORT_FIELD_HOKA4;
		aryImportField[29]	[1]		= PayrollConst.NAM_IMPORT_FIELD_HOKA5;
		aryImportField[30]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KKRIYUU;
		aryImportField[31]	[1]		= PayrollConst.NAM_IMPORT_FIELD_DAIKYUJYU;
		aryImportField[32]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KKCOMENT;
		aryImportField[33]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KKSYOUMEI;
		aryImportField[34]	[1]		= PayrollConst.NAM_IMPORT_FIELD_KKJIKAN;
		aryImportField[35]	[1]		= PayrollConst.NAM_IMPORT_FIELD_NIJIKYU;
		aryImportField[36]	[1]		= PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN;
		return aryImportField;
	}

	/**
	 * l{pDAO
	 */
	protected void prepareHumanBasisDao() {
		// DAO
		if (mKihonDao != null) {
			return;
		}
		mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * l{擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 */
	protected void findHumanBasisInfo(
			String kCode,
			boolean isForUpdate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// l{pDAO
		prepareHumanBasisDao();
		// ݂̏擾
		if (isForUpdate) {
			mKihonDto      = mKihonDao.findForUpdate(kCode);
		} else {
			mKihonDto      = mKihonDao.findForKey(kCode);
		}
	}

	/**
	 * t擾
	 * @param date Ώۓt
	 * @return tz
	 */
	private String[] getDateArray(String date) {
		String[] aryDate = new String[3];
		if (date.indexOf("/") != -1) {
			// dateyyyy/mm/ddłꍇ
			aryDate = date.split("/", 3);
		} else if (date.indexOf("-") != -1) {
			// dateyyyy-mm-ddłꍇ
			aryDate = date.split("-", 3);
		} else if (date.length() == 8) {
			// dateyyyymmddłꍇ
			aryDate[0] = date.substring(0, 4);
			aryDate[1] = date.substring(4, 6);
			aryDate[2] = date.substring(6, date.length());
		}
		return aryDate;
	}

	/**
	 * ϊ
	 * @param time (HH:MM)
	 * @return HH:MM
	 */
	private String convStringTimeFormatted(String time) {
		String formattedTime = "";
		if (time.indexOf(CommonConst.STR_TIME_SEPARATOR) != -1) {
			formattedTime = util.convIntegerTimeToStringTime(util.convStringTimeToIntegerTime(time));
		}
		return formattedTime;
	}

	/**
	 * ԕϊ
	 * @param time Ώێ
	 * @return oߕ
	 */
	private int convStringTimeToIntegerTime(String time) {
		// VO擾
		TimeRecordImportCardVo vo = (TimeRecordImportCardVo)getVo();
		int intTime = 0;
		if (time.indexOf(CommonConst.STR_TIME_SEPARATOR) != -1) {
			// timeHH:MMłꍇ
			intTime = util.convStringTimeToIntegerTime(time);
		} else {
			// timePʂłꍇ
			intTime = vo.getIntParam(time);
		}
		return intTime;
	}

	/**
	 * vZ\bh
	 * @param list
	 * @throws Exception
	 */
	private void runAutoCalc(List<MSyukkinboDto> list) throws Exception {
		// vZtOL̂
		if (getMosPCode(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_AUTOMATIC_CALCULATION)[2].equals("0")) {
			Iterator it = list.iterator();
			while (it.hasNext()) {
				MSyukkinboDto dto = (MSyukkinboDto) it.next();
				// Ώۓ擾
				Date targetDay = util.convStringDateToDate(dto.getHizuke());
				// Αӓf[^擾
				getAttendanceDay(dto.getKCode(), targetDay);
				if (KintaiCommonPart.isHoliday(dto)) {
					// SxxɎ
					dto.setKKJikan(allHoliday);
				} else {
					// 
					late			= 0;
					work			= 0;
					leave			= 0;
					over			= 0;
					overPremium		= 0;
					overNonPremium	= 0;
					interval		= 0;
					latenight		= 0;
					holidaywork		= 0;
					// TxȊO
					if (!KintaiCommonPart.isWeekHoliday(dto)) {
						// xeԂɓ͂ꂽlZbg
						interval = dto.getKyukeiJi();
						// Ζ`ԂK莞擾
						getWork_TypeInfo(dto.getKinmu());
						// oΎZo
						int start = util.convStringTimeToIntegerTime(dto.getSyJikoku());
						// ދΎZo
						int quit = util.convStringTimeToIntegerTime(dto.getTaJikoku());
						boolean shankyukbn = KintaiCommonPart.isStartHalfHoliday(dto.getSHankyuKb());
						boolean kyusyukbn = KintaiCommonPart.isWorkOnHoliday(dto.getKyusyuKb());
						boolean thankyukbn = KintaiCommonPart.isQuitHalfHoliday(dto.getTHankyuKb());
						// o΍ڂ̌vZ
						getCalcStartTime(start, shankyukbn, kyusyukbn);
						// xԃZbg
						dto.setTiJikan(late);
						// ދ΍ڂ̌vZ
						getCalcQuitTime(start, quit, (shankyukbn || thankyukbn));
						// ΖԃZbg
						dto.setKinmuJi(work);
						// ގԃZbg
						dto.setSoJikan(leave);
						// cƎԃZbg
						dto.setZaJikan(over);
						dto.setWarimasi1(overNonPremium);
						// xeԃZbg
						dto.setKyukeiJi(interval);
						// [鎞ԃZbg
						dto.setSnJikan(latenight);
						// xoԃZbg
						if (kyusyukbn) {
							dto.setKsJikan(holidaywork);
						} else {
							dto.setKsJikan(0);
						}
					}
				}
			}
		}
	}

	/**
	 * Αӓf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetDay Ώۓ
	 * @throws Exception
	 */
	protected void getAttendanceDay(String kCode, Date targetDay) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ͈͎擾
		String attendanceDate = MospUtility.getDateString(targetDay, CommonConst.FORMAT_DATE);
		// oΕpDAO 
		prepareMTimeRecordDao();
		// ꗗ̎擾
		attendanceList	= mSyukkinboDao.findForCondition(kCode, attendanceDate);
		// Αӏݒ
		setHours();	
	}

	/**
	 * o΍ڂ̌vZ
	 * @param start oΎ(int)
	 * @param isStartHalf oΎx̏ꍇ true
	 * @param isHolidayWork xȍꍇtrue
	 */
	protected void getCalcStartTime(int start, boolean isStartHalf, boolean isHolidayWork) {
		if (isStartHalf | isHolidayWork) {
			late = 0;
		} else {
			late = setLateTimes(start);
		}
	}

	/**
	 * ދ΍ڂ̌vZ
	 * @param start oΎ
	 * @param quit ދΎ
	 * @param isHalf oΎxAދΎx̏ꍇtrue
	 */
	protected void getCalcQuitTime(int start, int quit, boolean isHalf) {
		// Ζ
		work 		= setWorkTimes(start, quit);
		leave 		= setLeaveEarlyTimes(quit);
		if (isHalf) {
			leave = 0;
		}
		over 		= setOverTimes(isHalf);
		interval 	= setIntervalTimes();
		latenight	= setLateNightTimes(quit);
		holidaywork	= setHolidayWork();

		overNonPremium	= setOverNonPremiumTimes();
		overPremium		= setOverPremiumTimes();
	}

	/**
	 * oΕpDAO
	 * @throws Exception
	 */
	protected void prepareMTimeRecordDao() throws Exception {
		// DAO
		if (mSyukkinboDao !=null) {
			return;
		}
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		mSyukkinboDao = new MSyukkinboDao();
		mSyukkinboDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * Wvf[^Ԑݒ
	 * @throws Exception 
	 */
	protected void setHours() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Αӏݒ
		setCalcParam();
		// JԐݒ
		setPrescribedHours();
		// Ζ`ԃ}X^ݒ
		setWorkTypeMap();
	}

	/**
	 * xԌvZ
	 * @param start oΎ
	 * @return	int	x
	 */
	private int setLateTimes(int start) {
		// oΎ - WoΎ
		int latemin = start - startTime;
		// x̂Ƃ͒vZ(PʎԂZ)5̏ꍇvZʂ0ɂȂ̂ōŒłPʎԂƂ
		if ((latemin < inputUnit) && (startTime < start)) {
			latemin = inputUnit;
		}
		if (latemin > 0) {
			// ۂ
			latemin -= latemin%inputUnit;
		}
		if (latemin < 0) {
			latemin = 0;
		}
		return latemin;
	}
	
	/**
	 * ΖԌvZ
	 * @param start
	 * @param quit
	 * @return	workmin
	 */
	private int setWorkTimes(int start, int quit) {
		// ގЎ - oΎ		
		int workmin = quit - start;
		// ۂ
		workmin -= workmin%inputUnit;
		return workmin;
	}

	/**
	 * ގԌvZ
	 * @return	leavemin
	 */
	private int setLeaveEarlyTimes(int quit) {
		// WގЎ - ގЎ
		int leavemin = quitTime - quit;
		// Ζ < WΖ
		if (work < workTime) {
			// ۂ
			leavemin -= leavemin%inputUnit;
		}
		if (leavemin < 0) {
			leavemin = 0;
		}
		return leavemin;
	}

	/**
	 * cƎԌvZ
	 * @param isHalf oΎxAދΎx̏ꍇtrue
	 * @return	overmin
	 */
	private int setOverTimes(boolean isHalf) {
		// x + Ζ
		int worktimes = late + work;
		// cƎ
		int overmin = 0;
		// x
		if (isHalf) {
			worktimes -= halfHoliday;
		}
		// ΖΏێ > WcƌvZJn
		if (worktimes > overStart) {
			// ΖΏێ - WΖ - cƋxe
			overmin = worktimes - workTime - overBreak;
			if (overmin < 0) {
				overmin = 0;
			}
		}
		return overmin;
	}

	/**
	 * xeԌvZ
	 * @return	intervalmin
	 */
	private int setIntervalTimes() {
		int intervalmin = 0;
		// Wxe  5Ԉȏ
		if (work > 300) {
			intervalmin = breakTime;
		}
		// cƋxe
		if (over > 0) {
			intervalmin += overBreak;
		}
		return intervalmin;
	}

	/**
	 * [鎞ԌvZ
	 * @return	latenightmin
	 */
	private int setLateNightTimes(int quit) {
		// ގЎ - W[Jn
		int latenightmin = quit - lateNightStart;
		// ۂ
		latenightmin -= latenightmin%inputUnit;
		// x
		if (latenightmin > (lateNightEnd - lateNightStart)) {
			latenightmin = lateNightEnd - lateNightStart;
		}
		if (latenightmin < 0) {
			latenightmin = 0;
		}
		return latenightmin;
	}

	/**
	 * xoԌvZ
	 * @return	holiwork
	 */
	private int setHolidayWork() {
		int holiwork = work - interval;
		return holiwork;
	}

	/**
	 * ȂcƎԌvZ
	 * @return overNonPremiumMin
	 */
	private int setOverNonPremiumTimes() {
		// ȂcƎ
		int overNonPremiumMin = 0;
		// cƎԂ0蒷ꍇ
		if (over > 0) {
			// ȂcƎ = J + Wxe - WΖ
//			overNonPremiumMin = hoursPerDay + breakTime - workTime;
			// ȂcƎ = J + xe - cƋxe - WΖ
			overNonPremiumMin = (int) (hoursPerDay + interval - overBreak - workTime);
			if (overNonPremiumMin > over) {
				overNonPremiumMin = over;
			} else if (overNonPremiumMin < 0) {
				overNonPremiumMin = 0;
			}
		}
		return overNonPremiumMin;
	}

	/**
	 * cƎԌvZ
	 * @return overPremiumMin
	 */
	private int setOverPremiumTimes() {
		// cƎ = cƎ - ȂcƎ
		int overPremiumMin = over - overNonPremium;
		return overPremiumMin;
	}
	
	/**
	 * 1JԎ擾
	 * @throws Exception 
	 */
	protected void setPrescribedHours() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// 擾ϊmF
		if (hoursPerDay != 0) {
			return;
		}
		// M_CODEl擾
		String[] aryConf = getMosPCode(CommonConst.TID_STATUTORY, CommonConst.TCD_STATUTORY_HOUR);
		// l̐ݒ
		hoursPerDay = Double.parseDouble(aryConf[2]);
	}

	/**
	 * Ζ`ԕʏݒ
	 * @param shiftcode
	 * @throws Exception 
	 */
	protected void getWork_TypeInfo(String shiftcode) throws Exception {
		// Xg
		Map<String, MWorkTypeDto> workTypeMap;
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		workTypeMap = getWorkTypeMap();
		// Ζ`ԏ擾
		MWorkTypeDto dto = workTypeMap.get(shiftcode);
		startTime 	= dto.getStartTime();
		quitTime 	= dto.getQuitTime();
		workTime 	= dto.getWorkTime();
		breakTime	= dto.getBreakTime();
		overStart	= dto.getOverStart();
		overBreak	= dto.getOverBreak();
	}

}
