/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.DatePart;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.InsuranceConfSetVo;

public class InsuranceConfSetAction extends AdjustmentAction {

	/**
	 * ʕ\R}h
	 */
//	public static final String CMD_SHOW	= "P4001";
//	public static final String CMD_SET	= "P4002";

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public InsuranceConfSetAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new InsuranceConfSetVo();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// ZbVێ̏
		initStoredData();
		// DBRlNV擾
		getConnection();
		// VO̎擾
		InsuranceConfSetVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof InsuranceConfSetVo) {
			vo = (InsuranceConfSetVo)obj;
		} else {
			vo = new InsuranceConfSetVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(PayrollConst.VO_INSURANCECONF_SET, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());

		vo.aryEra	= getCodeArray(PayrollConst.TID_JAPANESE);				// NR[he[u擾  
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);			// ae[uݒ擾

		Date  date_tmp = DatePart.convIntegerDateToDate(
				(MospUtility.getYear(util.getSystemDate()) *  10000) + 401) ;
		vo.setSyoukyuTuki(date_tmp);						// i~jNlݒ
		vo.setSyoukyuTukiJp( getJapaneseDate(date_tmp) );	// i~jN(a)ݒ

		// KpNlݒ
		date_tmp = DatePart.convIntegerDateToDate(
				(MospUtility.getYear(util.getSystemDate()) *  10000) + 901) ;
		vo.setTekiyouNenGetu(date_tmp);			// KpN(a)ݒ
		// Jnlݒ
		date_tmp = DatePart.convIntegerDateToDate(
				(MospUtility.getYear(util.getSystemDate()) *  10000) + 1001) ;
		vo.setChousyuKaisiTukiStr(date_tmp);	// Jniajݒ
		vo.initFields(); 						// VOtB[hݒ		
	}

}
