/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.sql.SQLException;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.DatePart;
import jp.mosp.human.action.HumanCalcAction;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.AdjustmentCardVo;
import jp.mosp.payroll.dto.CdAdjustmentDto;

public class AdjustmentCardAction extends AdjustmentAction {
	
	// R}h
	private static final String CMD_ADJUSTMENT_CARD_SHOW    = "P3021"; // Q
	private static final String CMD_ADJUSTMENT_CARD_SELECT  = "P3022"; // I
	private static final String CMD_ADJUSTMENT_CARD_REGIST  = "P3023"; // o^
	private static final String CMD_ADJUSTMENT_CARD_REG_CAL = "P3024"; // o^vZ
	private static final String CMD_ADJUSTMENT_CARD_MOVE    = "P3025"; // ړ
	public  static final String CMD_ADJUSTMENT_CARD_BACK    = "P3026"; // ߂
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		// VO̎擾
		
		// VO̎擾yѐݒ
		AdjustmentCardVo vo =  new AdjustmentCardVo();
		vo = (AdjustmentCardVo)getStoredVo(vo.getClassName());
		if (vo == null || cmd.equals(CMD_ADJUSTMENT_CARD_SHOW)) {
			vo = new AdjustmentCardVo();
			storeVo(vo.getClassName(), vo);
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// ̎擾pz擾
		setNameArray(vo);
		// R}h̏
		if (cmd.equals(CMD_ADJUSTMENT_CARD_SHOW)) {
			// \
			show(vo);
		} else if (cmd.equals(CMD_ADJUSTMENT_CARD_SELECT)) {
			// I\
			// p[^擾
			vo.setParams(request);
			// IЈR[h擾
			kCode = "";
			if (vo.getTxtChangeKCode() != null && !vo.getTxtChangeKCode().equals("") ) {
				kCode = vo.getTxtChangeKCode();
			} else if (key1 != null && !key1.equals("")) {
				kCode = key1;
			} else {
				kCode = vo.getHidKCode();
			}
			// NmF
			confirmAdjustYear(vo.getHidAdjustYear());
			// Nf[^ݒ
			select(vo);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// ^f[^ݒ
			setTargetPaymentData();

			// N敪mF
			confirmAdjustType();
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, cdAdjustmentDto);
		} else if (cmd.equals(CMD_ADJUSTMENT_CARD_REGIST)) {
			// o^
			// p[^擾
			vo.setParamsAll(request);
			// ΏێЈR[h擾
			kCode = vo.getHidKCode();
			// NmF
			confirmAdjustYear(vo.getHidAdjustYear());
			// o^
			regist(vo, (CdAdjustmentDto)session.getAttribute(MospConst.ATT_DTO));
			// Nf[^Ď擾
			vo.setTxtChangeKCode(vo.getHidKCode());
			select(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, cdAdjustmentDto);
		} else if (cmd.equals(CMD_ADJUSTMENT_CARD_REG_CAL)) {
			// o^yьvZ
			// p[^擾
			vo.setParamsAll(request);
			// ΏێЈR[h擾
			kCode = vo.getHidKCode();
			// NmF
			confirmAdjustYear(vo.getHidAdjustYear());
			// o^
			regist(vo, (CdAdjustmentDto)session.getAttribute(MospConst.ATT_DTO));
			// NvZ
			calculate(vo);
			// Nf[^Ď擾
			vo.setTxtChangeKCode(vo.getHidKCode());
			select(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, cdAdjustmentDto);
		} else if (cmd.equals(CMD_ADJUSTMENT_CARD_MOVE)) {
			// p[^擾
			vo.setParamsAll(request);
			// ΏێЈR[h擾
			kCode = vo.getHidKCode();
			// NmF
			confirmAdjustYear(vo.getHidAdjustYear());
			// DAO
			prepareDao();
			// lݒ
			setHumanInfo(vo);
			// R}hݒ
			setNextCmd(HumanCalcAction.CMD_HUMAN_CALC_TAB);
			setUrl(MospConst.URL_SRV);
		} else if (cmd.equals(CMD_ADJUSTMENT_CARD_BACK)) {
			// l^񂩂̖߂
			// DAO
			prepareDao();
			// IЈR[h擾
			kCode = vo.getHidKCode();
			// NmF
			confirmAdjustYear(vo.getHidAdjustYear());
			// lݒ
			setHumanInfo(vo);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// ^f[^ݒ
			setTargetPaymentData();
			// N敪mF
			confirmAdjustType();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * Nʕ\
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	private void show(
			AdjustmentCardVo vo
	) throws SQLException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
		// DBRlNV擾
		getConnection();
		// VO
		vo.initAllFields();
		// N擾
		vo.setHidAdjustYear(getAdjustYear());
	}
	
	/**
	 * Nf[^ݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 * @throws ClassNotFoundException 
	 * @throws MospException
	 */
	private void select(
			AdjustmentCardVo vo
	) throws SQLException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException, MospException {
		// VO
		vo.initFields();
		// DAO
		prepareDao();
		// lݒ
		setHumanInfo(vo);
		// Nf[^擾
		cdAdjustmentDto = cdAdjustmentDao.findForKey(kCode, adjustYear);
		// VOɐݒ
		vo.setFields(cdAdjustmentDto);
	}
	
	/**
	 * Nf[^o^
	 * @param vo       o^ΏVO
	 * @param storedVo ZbVۑDTO
	 * @throws Exception 
	 */
	private void regist(AdjustmentCardVo vo, CdAdjustmentDto storedDto) throws Exception  {
		// DAO
		prepareDao();
		// lݒ
		setHumanInfo(vo);
		// Nf[^擾
		CdAdjustmentDto currentDto = cdAdjustmentDao.findForUpdate(kCode, adjustYear);
		// Ώ۔NAΏۃf[^ݒ
		setTargetData();
		// ^f[^ݒ
		setTargetPaymentData();
		// o^DTȌ
		cdAdjustmentDto = new CdAdjustmentDto();
		vo.setDtoFields(cdAdjustmentDto, kCode, adjustYear);
		// Nf[^쐬ΏێҊmF
		if(!checkCreateAdjustData(true)) {
			return;
		}
		if (storedDto == null) {
			// VKo^
			// ݃`FbN
			chkDuplicate(currentDto, vo);
			// f[^̑}
			cdAdjustmentDao.insert(cdAdjustmentDto);
			// f[^}mF
			chkInsert(cdAdjustmentDao.findForKey(kCode, adjustYear));
			// R~bg
			commit();
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		} else {
			// XVo^
			// rmF
			chkExclusive(storedDto, currentDto, vo);
			// f[^̍XV
			cdAdjustmentDao.update(cdAdjustmentDto);
			// f[^XVmF
			chkUpdate(cdAdjustmentDao.findForKey(kCode, adjustYear));
			// R~bg
			commit();
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		}
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 * @throws MospException 
	 */
	private void setHumanInfo(
			AdjustmentCardVo vo
	) throws SQLException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException, MospException {
		// l{擾
		mKihonDto = mKihonPayrollDao.findForDate(kCode, DatePart.convDateToInteger(lastDate));
		if (mKihonDto == null) {
			// l{񂪖ꍇ
			show(vo);
			vo.setTxtChangeKCode(kCode);
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_BEFORE_ENTRANCE, errMessage);
		}
		// l^擾
		cmIncomeTaxDto   = cmIncomeTaxDao  .findForEmployeeDate(kCode, lastDate);
		cmMidwayEnterDto = cmMidwayEnterDao.findForKey         (kCode          );
		// Ƒ擾
//		listFamily = cmFamilyDao.findForAdjustment(kCode);
		// VOݒ
//		vo.setFields(mKihonDto, cmIncomeTaxDto, cmMidwayEnterDto, listFamily);
		vo.setFields(mKihonDto, cmIncomeTaxDto, cmMidwayEnterDto);
	}
	

	
	/**
	 * ̎擾pz擾
	 * @param vo ݒΏVO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	private void setNameArray(
			AdjustmentCardVo vo
	) throws SQLException, NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
		// DBRlNV擾
		getConnection();
		// 擾ϊmF
		if (vo.aryStation != null) {
			return;
		}
		// z擾
		vo.aryStation  = getStationArrayAll() ;
		vo.aryPosition = getPositionArrayAll();
		vo.aryEra      = getCodeArray(PayrollConst.TID_JAPANESE);
		vo.aryRelation = getCodeArray(PayrollConst.TID_RELATION);
		// aݒ擾
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
	}
	
	/**
	 * NvZ
	 * @param vo
	 * @throws Exception 
	 */
	private void calculate(AdjustmentCardVo vo) throws Exception {
		// vZmF
		boolean isCreateData = true;
		// DAO
		prepareDao();
		// Ώ۔NAΏۃf[^ݒ
		setTargetData();
		// ^f[^ݒ
		setTargetPaymentData();
		// ΏۊOf[^폜
		cdAdjustmentDao.deleteAdjustYear(adjustYear, startAdjDate, lastDate);
		// lݒ
		setHumanInfo(vo);
		// Nf[^쐬ΏێҊmF
		if(!checkCreateAdjustData(false)) {
			return;
		}
		// NvZΏێҊmF
		if (!confirmAdjustType()) {
			isCreateData = false;
		}
		// L̊mFŃG[ȂЈ͔NvZ
		if (isCreateData) {
			// Ώۃf[^ŌvZ
			calcTargetIncomeTax(true);
			// NɕKvȍڂ̌vZ
			calcNeedAdjust();
			// NvZ
			adjustIncomeTax();
		} else {
			// NɕKvȍڂ̌vZ(ސE҂̎xz擾p)
			calcNeedAdjust();
			// Nf[^͍쐬邪vZΏۊO̎Ј
			setAdjustOotStatus();
		}
		// Nf[^擾
		CdAdjustmentDto currentDto = cdAdjustmentDao.findForKey(kCode, adjustYear);
		// o^
		if (currentDto == null) {
			// VKo^
			cdAdjustmentDao.insert(cdAdjustmentDto);
		} else {
			// XV
			cdAdjustmentDao.update(cdAdjustmentDto);
		}
		// R~bg
		commit();
	}
	
	
}
