/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.AttendanceTotalAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.KintaiApprovalPart;
import jp.mosp.common.part.KintaiCommonPart;

import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceCheckCardVo;

public class AttendanceCheckCardAction extends AttendanceTotalAction {

	// R}h
	public static final String CMD_CHECK_CARD_SELECT		= "K1121";
	private static final String CMD_CHECK_CARD_REGIST		= "K1122";
	private static final String CMD_CHECK_CARD_DELETE		= "K1123";

	/**
	 * RXgN^
	 */
	public AttendanceCheckCardAction() {
		super();
	}

	public void action() throws Exception {
		// VO̎擾
		AttendanceCheckCardVo vo;
		vo = (AttendanceCheckCardVo)getStoredVo(CommonConst.VO_ATTENDANCE_CHECK_CARD);
		if (vo == null) {
			vo = new AttendanceCheckCardVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_ATTENDANCE_CHECK_CARD, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		MSyukkinboDto dto;
		Object objDto = session.getAttribute(MospConst.ATT_DTO);
		dto = objDto instanceof MSyukkinboDto ? (MSyukkinboDto)objDto : null;
		// DBRlNV擾
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// 蓖ꗗ
		vo.aryAllowance = getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME);
		// Ζ`ԃv_E
		vo.aryPltWorkType = getWorkTypeArrayWithWeekHoliday();
		// xo敪v_E
		vo.aryPltWorkOnHoliday = getMosPCodeArray(CommonConst.TID_WORK_ON_HOLIDAY_TYPE);
		// oΎx敪v_E
		vo.aryPltStartHalfHoliday = getMosPCodeArray(CommonConst.TID_HALF_HOLIDAY_TYPE);
		// xRv_E
		vo.aryPltLateReason = getReasonCodeArray(CommonConst.TID_LATE_REASON);
		// xؖv_E
		vo.aryPltLateCertificate = getMosPCodeArray(CommonConst.TID_LATE_CERTIFICATE);
		// ދΎx敪v_E
		vo.aryPltQuitHalfHoliday = getMosPCodeArray(CommonConst.TID_HALF_HOLIDAY_TYPE);
		// ޗRv_E
		vo.aryPltLeaveEarlyReason = getReasonCodeArray(CommonConst.TID_LEAVE_EARLY_REASON);
		// ޏؖv_E
		vo.aryPltLeaveEarlyCertificate = getMosPCodeArray(CommonConst.TID_LEAVE_EARLY_CERTIFICATE);
		// ΑӊǗR}h
		setSubTitleMenu(vo);
		// R}h̏
		if (cmd.equals(CMD_CHECK_CARD_SELECT)) {
			// \̏
			setAttendanceInfo(vo);
			// oΌ
			dto = searchAttendance(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else if (cmd.equals(CMD_CHECK_CARD_REGIST)) {
			vo.setParams(request);
			// o^
			dto = registAttendance(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
			// Αӈꗗ֑J
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));			
		} else if (cmd.equals(CMD_CHECK_CARD_DELETE)) {
			vo.setParams(request);
			// 폜
			dto = delete(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
			// Αӈꗗ֑J
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		// ČpMenuVo̕ۑ
		setStoreAttendanceMenuVo(vo);
	}

	/**
	 * oΌ
	 * @param vo VoCX^X
	 * @return 擾DtoCX^X
	 * @throws Exception
	 */
	private MSyukkinboDto searchAttendance(AttendanceCheckCardVo vo) throws Exception {
		// Αӌ
		MSyukkinboDto dto = getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate());
		// VOɏݒ
		vo.setFields(dto);
		// \[h̃Zbg
		setMode(vo, dto);
		// x\̃Zbg
		vo.setLabelInfo(dto);
		return dto;
	}

	/**
	 * Αӓo^
	 * @param vo  VoCX^X
	 * @param dto DtoCX^X
	 * @return o^Ď擾DtoCX^X
	 * @throws Exception
	 */
	private MSyukkinboDto registAttendance(	AttendanceCheckCardVo vo, MSyukkinboDto dto) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		if (!chkExistDto(dto)) {
			// Αӈꗗ֖߂(ΑӃf[^ꍇ)
			String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_NO_ATTENDANCE, "");
			addErrMessage(errMessage);
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			throw new MospException(CommonConst.EX_NO_ATTENDANCE, errMessage);
		} else {
			// Fς݂̏ꍇ̓bZ[W\Ao^s
			if (KintaiApprovalPart.isApproved(dto)) {
				// bZ[Wݒ
				request.setAttribute(MospConst.ATT_MESSAGE, 
						MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_APPROVED, 
								getMessageDate(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay())		
						)
				);
			} else {
				// UPDATE(ZbVۑDTO݂ꍇ)
				// rmF
				chkExclusive(dto, getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true), vo);
				// VO̒lZbg
				vo.setDtoFields(dto);
				// vZ
				runAutoCheckCalc(dto);
				// XViSځj
				syukkinboDao().update(dto);
			}
		}
		// DTO̍Ď擾
		MSyukkinboDto retDto = getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
		chkUpdate(retDto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * ΑӍڍ폜
	 * @param dto
	 * @throws Exception
	 */
	private MSyukkinboDto delete(AttendanceCheckCardVo vo, MSyukkinboDto dto) throws Exception {
		// f[^݊mF
		chkExist(dto);
		// Fς݂̏ꍇ̓bZ[W\A폜s
		if (KintaiApprovalPart.isApproved(dto)) {
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, 
					MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_APPROVED, 
							getMessageDate(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay())
					)
			);
		} else {
			// 폜
			syukkinboDao().delete(dto);
		}
		// DTO̍Ď擾
		MSyukkinboDto retDto = getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
		// R~bg
		commit();
		return retDto;
	}

	/**
	 * vZ\bh
	 * @param dto
	 * @throws Exception
	 */
	private void runAutoCheckCalc(MSyukkinboDto dto) throws Exception {
		// Αӏݒ
		setCalcParam();
		// vZtOL芎TxȊÔ
		if (isAutoCalc && !KintaiCommonPart.isWeekHoliday(dto)) {
			// ΑӍڌvZ 
			getCalculatedInfo(dto);
		}
	}

}
