/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.vo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.legal.LegalReportUtility;
import jp.mosp.legal.LegalUtility;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.CmCommutationDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.CmResidenceTaxDto;
import jp.mosp.payroll.dto.CmSocInsuranceDto;
import jp.mosp.payroll.dto.CmUnitAmountDto;

public class HumanCalcVo extends PayrollHumanCardVo {
	
	private static final long serialVersionUID = -8026371175662931865L;
	
	// p[^(Ƒ()
	public static final String PRM_HID_FAMILY_INS_SEQUENCE = "hidFamilyInsSequence";
	public static final String PRM_HID_FAMILY_TAX_SEQUENCE = "hidFamilyTaxSequence";
	// p[^(Љی)
	public static final String PRM_PLT_PENSION_TYPE        = "pltPensionType"      ;
	public static final String PRM_PLT_PARTTIME_TYPE       = "pltParttimeType"     ;
	public static final String PRM_PLT_EMPLOYEE_TYPE       = "pltEmployeeType"     ;
	public static final String PRM_PLT_CALC_INS_TYPE       = "pltCalcInsType"      ;
	public static final String PRM_PLT_NURSING_INS_TYPE    = "pltNursingInsType"   ;
	public static final String PRM_PLT_CALC_UNEMPLOY_TYPE  = "pltCalcUnemployType" ;
	public static final String PRM_PLT_BONUS_HEALTH_TYPE   = "pltBonusHealthType"  ;
	public static final String PRM_PLT_BONUS_PENSION_TYPE  = "pltBonusPensionType" ;
	public static final String PRM_TXT_HEALTH_NO           = "txtHealthNo"         ;
	public static final String PRM_TXT_HEALTH_PAYMENT      = "txtHealthPayment"    ;
	public static final String PRM_PLT_HEALTH_GET_ERA      = "pltHealthGetEra"     ;
	public static final String PRM_PLT_HEALTH_GET_YEAR     = "pltHealthGetYear"    ;
	public static final String PRM_PLT_HEALTH_GET_MONTH    = "pltHealthGetMonth"   ;
	public static final String PRM_PLT_HEALTH_GET_DAY      = "pltHealthGetDay"     ;
	public static final String PRM_PLT_HEALTH_LOST_TYPE    = "pltHealthLostType"   ;
	public static final String PRM_PLT_HEALTH_LOST_ERA     = "pltHealthLostEra"    ;
	public static final String PRM_PLT_HEALTH_LOST_YEAR    = "pltHealthLostYear"   ;
	public static final String PRM_PLT_HEALTH_LOST_MONTH   = "pltHealthLostMonth"  ;
	public static final String PRM_PLT_HEALTH_LOST_DAY     = "pltHealthLostDay"    ;
	public static final String PRM_TXT_PENSION_NO          = "txtPensionNo"        ;
	public static final String PRM_TXT_PENSION_PAYMENT     = "txtPensionPayment"   ;
	public static final String PRM_PLT_PENSION_GET_ERA     = "pltPensionGetEra"    ;
	public static final String PRM_PLT_PENSION_GET_YEAR    = "pltPensionGetYear"   ;
	public static final String PRM_PLT_PENSION_GET_MONTH   = "pltPensionGetMonth"  ;
	public static final String PRM_PLT_PENSION_GET_DAY     = "pltPensionGetDay"    ;
	public static final String PRM_PLT_PENSION_LOST_TYPE   = "pltPensionLostType"  ;
	public static final String PRM_PLT_PENSION_LOST_ERA    = "pltPensionLostEra"   ;
	public static final String PRM_PLT_PENSION_LOST_YEAR   = "pltPensionLostYear"  ;
	public static final String PRM_PLT_PENSION_LOST_MONTH  = "pltPensionLostMonth" ;
	public static final String PRM_PLT_PENSION_LOST_DAY    = "pltPensionLostDay"   ;
	public static final String PRM_TXT_FUND_NO             = "txtFundNo"           ;
	public static final String PRM_PLT_FUND_GET_ERA        = "pltFundGetEra"       ;
	public static final String PRM_PLT_FUND_GET_YEAR       = "pltFundGetYear"      ;
	public static final String PRM_PLT_FUND_GET_MONTH      = "pltFundGetMonth"     ;
	public static final String PRM_PLT_FUND_GET_DAY        = "pltFundGetDay"       ;
	public static final String PRM_TXT_UNEMPLOY_NO         = "txtUnemployNo"       ;
	public static final String PRM_PLT_UNEMPLOY_GET_ERA    = "pltUnemployGetEra"   ;
	public static final String PRM_PLT_UNEMPLOY_GET_YEAR   = "pltUnemployGetYear"  ;
	public static final String PRM_PLT_UNEMPLOY_GET_MONTH  = "pltUnemployGetMonth" ;
	public static final String PRM_PLT_UNEMPLOY_GET_DAY    = "pltUnemployGetDay"   ;
	public static final String PRM_PLT_UNEMPLOY_LOST_TYPE  = "pltUnemployLostType" ;
	public static final String PRM_PLT_UNEMPLOY_LOST_ERA   = "pltUnemployLostEra"  ;
	public static final String PRM_PLT_UNEMPLOY_LOST_YEAR  = "pltUnemployLostYear" ;
	public static final String PRM_PLT_UNEMPLOY_LOST_MONTH = "pltUnemployLostMonth";
	public static final String PRM_PLT_UNEMPLOY_LOST_DAY   = "pltUnemployLostDay"  ;
	// p[^(Ƒ(ی))
	public static final String PRM_PLT_INS_FAMILY          = "pltInsFamily"        ;
	public static final String PRM_PLT_HEA_QUALIFIED_ERA   = "pltHeaQualifiedEra"  ;
	public static final String PRM_PLT_HEA_QUALIFIED_YEAR  = "pltHeaQualifiedYear" ;
	public static final String PRM_PLT_HEA_QUALIFIED_MONTH = "pltHeaQualifiedMonth";
	public static final String PRM_PLT_HEA_QUALIFIED_DAY   = "pltHeaQualifiedDay"  ;
	public static final String PRM_PLT_DISQUALIFIED_ERA    = "pltDisqualifiedEra"  ;
	public static final String PRM_PLT_DISQUALIFIED_YEAR   = "pltDisqualifiedYear" ;
	public static final String PRM_PLT_DISQUALIFIED_MONTH  = "pltDisqualifiedMonth";
	public static final String PRM_PLT_DISQUALIFIED_DAY    = "pltDisqualifiedDay"  ;
	public static final String PRM_TXT_FAMILY_PENSION_NO   = "txtFamilyPensionNo"  ;
	public static final String PRM_TXT_FAMILY_INS_REMARKS  = "txtFamilyInsRemarks" ;
	// p[^(Z)
	public static final String PRM_TXT_PAYMENT_CITY_CODE   = "txtPaymentCityCode"  ;
	public static final String PRM_TXT_SUBMIT_CITY_CODE    = "txtSubmitCityCode"   ;
	public static final String PRM_TXT_JUNE_AMOUNT         = "txtJuneAmount"       ;
	public static final String PRM_TXT_JULY_AMOUNT         = "txtJulyAmount"       ;
	public static final String PRM_TXT_AUGUST_AMOUNT       = "txtAugustAmount"     ;
	public static final String PRM_TXT_SEPTEMBER_AMOUNT    = "txtSeptemberAmount"  ;
	public static final String PRM_TXT_OCTOBER_AMOUNT      = "txtOctoberAmount"    ;
	public static final String PRM_TXT_NOVEMBER_AMOUNT     = "txtNovemberAmount"   ;
	public static final String PRM_TXT_DECEMBER_AMOUNT     = "txtDecemberAmount"   ;
	public static final String PRM_TXT_JANUARY_AMOUNT      = "txtJanuaryAmount"    ;
	public static final String PRM_TXT_FEBRUARY_AMOUNT     = "txtFebruaryAmount"   ;
	public static final String PRM_TXT_MARCH_AMOUNT        = "txtMarchAmount"      ;
	public static final String PRM_TXT_APRIL_AMOUNT        = "txtAprilAmount"      ;
	public static final String PRM_TXT_MAY_AMOUNT          = "txtMayAmount"        ;
	// p[^()
	public static final String PRM_PLT_INCOME_TAX_TYPE     = "pltIncomeTaxType"    ;
	public static final String PRM_PLT_ADJUSTMENT_TYPE     = "pltAdjustmentType"   ;
	public static final String PRM_PLT_SELF_WIDOW_TYPE     = "pltSelfWidowType"    ;
	public static final String PRM_PLT_SELF_HANDICAP_TYPE  = "pltSelfHandicapType" ;
	public static final String PRM_PLT_SELF_STUDENT_TYPE   = "pltSelfStudentType"  ;
	public static final String PRM_PLT_SPOUSE_INTEND_TYPE  = "pltSpouseIntendType" ;
	public static final String PRM_TXT_GENERAL_DEPENDENT   = "txtGeneralDependent" ;
	public static final String PRM_TXT_SPECIFIC_DEPENDENT  = "txtSpecificDependent";
	public static final String PRM_TXT_ELDERLY_DEPENDENT   = "txtElderlyDependent" ;
	public static final String PRM_TXT_LIVE_WITH_ELD_REL   = "txtLiveWithEldRel"   ;
	public static final String PRM_TXT_LIVE_WITH_HANDI_GE  = "txtLiveWithHandiGe"  ;
	public static final String PRM_TXT_LIVE_WITH_HANDI_SP  = "txtLiveWithHandiSp"  ;
	public static final String PRM_TXT_LIVE_WITH_HANDI_EL  = "txtLiveWithHandiEl"  ;
	public static final String PRM_TXT_LIVE_WITH_HANDI_ER  = "txtLiveWithHandiEr"  ;
	public static final String PRM_TXT_GENERAL_HANDICAP    = "txtGeneralHandicap"  ;
	public static final String PRM_TXT_SPECIFIC_HANDICAP   = "txtSpecificHandicap" ;
	public static final String PRM_HID_DEPENDENT_COUNT     = "hidDependentCount"   ;
	// p[^(Ƒ())
	public static final String PRM_PLT_LIVE_WITH_TYPE      = "pltLiveWithType"     ;
	public static final String PRM_PLT_SPOUSE_TYPE         = "pltSpouseType"       ;
	public static final String PRM_PLT_DEPENDENT_TYPE      = "pltDependentType"    ;
	public static final String PRM_PLT_HANDICAP_TYPE       = "pltHandicapType"     ;
	// p[^(ʋΎ蓖)
	public static final String PRM_PLT_PAYMENT_INTERVAL    = "pltPaymentInterval"  ;
	public static final String PRM_PLT_LUMP_MONTHLY_TYPE   = "pltLumpMonthlyType"  ;
	public static final String PRM_PLT_PAY_START_MONTH     = "pltPayStartMonth"    ;
	public static final String PRM_TXT_COMMUTE_DISTANCE    = "txtCommuteDistance"  ;
	public static final String PRM_TXT_COMMUTE_AMOUNT      = "txtCommuteAmount"    ;
	public static final String PRM_TXT_COMMUTE_TAXED       = "txtCommuteTaxed"     ;
	// p[^(x@)
	public static final String PRM_PLT_CO_BANK_CODE        = "pltCoBankCode"       ;
	public static final String PRM_TXT_PAID_BANK_CODE      = "txtPaidBankCode"     ;
	public static final String PRM_TXT_PAID_BRANCH_CODE    = "txtPaidBranchCode"   ;
	public static final String PRM_LBL_PAID_BANK_NAME      = "lblPaidBankName"     ;
	public static final String PRM_LBL_PAID_BRANCH_NAME    = "lblPaidBranchName"   ;
	public static final String PRM_PLT_ACCOUNT_TYPE        = "pltAccountType"      ;
	public static final String PRM_TXT_ACCOUNT_NO          = "txtAccountNo"        ;
	public static final String PRM_TXT_HOLDER_NAME         = "txtHolderName"       ;
	public static final String PRM_TXT_HOLDER_KANA         = "txtHolderKana"       ;
	public static final String PRM_PLT_PAYMENT_MEANS       = "pltPaymentMeans"     ;
	public static final String PRM_PLT_AMOUNT_TYPE         = "pltAmountType"       ;
	public static final String PRM_TXT_FIXED_AMOUNT        = "txtFixedAmount"      ;
	// p[^(vZP)
	public static final String PRM_HID_UNIT_TYPE           = "hidUnitType"         ;
	public static final String PRM_TXT_UNIT_AMOUNT         = "txtUnitAmount"       ;
	// p[^(r)
	public static final String PRM_PLT_MIDWAY_TYPE         = "pltMidwayType"       ;
	public static final String PRM_TXT_FORMER_INCOME       = "txtFormerIncome"     ;
	public static final String PRM_TXT_FORMER_INSURANCE    = "txtFormerInsurance"  ;
	public static final String PRM_TXT_FORMER_TAX          = "txtFormerTax"        ;
	// p[^(̑)
	public static final String PRM_HID_CALC_CURRENT_TAB    = "hidCalcCurrentTab"   ;
	
	// tB[hyѐ
	// Љی
	public static String NAM_HEALTH_NO;
	public static String NAM_HEALTH_PAYMENT;
	public static String NAM_UNEMPLOY_NO;
	public static String NAM_PENSION_NO;
	public static String NAM_PENSION_PAYMENT;
	public static String NAM_FUND_NO;
	// Z
	public static String NAM_PAYMENT_CITY_CODE;
	public static String NAM_SUBMIT_CITY_CODE;
	public static String NAM_JUNE_AMOUNT;
	public static String NAM_JULY_AMOUNT;
	public static String NAM_AUGUST_AMOUNT;
	public static String NAM_SEPTEMBER_AMOUNT;
	public static String NAM_OCTOBER_AMOUNT;
	public static String NAM_NOVEMBER_AMOUNT;
	public static String NAM_DECEMBER_AMOUNT;
	public static String NAM_JANUARY_AMOUNT;
	public static String NAM_FEBRUARY_AMOUNT;
	public static String NAM_MARCH_AMOUNT;
	public static String NAM_APRIL_AMOUNT;
	public static String NAM_MAY_AMOUNT;
	// x@
	public static String NAM_CO_BANK_CODE;
	public static String NAM_PAID_BANK_CODE;
	public static String NAM_PAID_BRANCH_CODE;
	public static String NAM_ACCOUNT_NO;
	public static String NAM_HOLDER_KANA;
	public static String NAM_HOLDER_NAME;
	public static String NAM_FIXED_AMOUNT;
	// ʋΎ蓖
	public static String NAM_PAYMENT_INTERVAL;
	public static String NAM_LUMP_MONTHLY_TYPE;
	public static String NAM_PAY_START_MONTH;
	public static String NAM_COMMUTE_DISTANCE;
	public static String NAM_COMMUTE_AMOUNT;
	public static String NAM_COMMUTE_TAXED;
	// 
	public static String NAM_GENERAL_DEPENDENT;
	public static String NAM_SPECIFIC_DEPENDENT;
	public static String NAM_ELDERLY_DEPENDENT;
	public static String NAM_LIVE_WITH_ELD_REL;
	public static String NAM_LIVE_WITH_HANDI_GE;
	public static String NAM_LIVE_WITH_HANDI_SP;
	public static String NAM_LIVE_WITH_HANDI_EL;
	public static String NAM_LIVE_WITH_HANDI_ER;
	public static String NAM_GENERAL_HANDICAP;
	public static String NAM_SPECIFIC_HANDICAP;
	// vZP
	public static String NAM_UNIT_AMOUNT;
	
	public static final int LEN_K_NAME               = PayrollConst.LEN_K_NAME          ;
	public static final int LEN_MONEY_AMOUNT         = PayrollConst.LEN_MONEY_AMOUNT    ;
	public static final int LEN_BANK_CODE            = PayrollConst.LEN_BANK_CODE       ;
	public static final int LEN_BRANCH_CODE          = PayrollConst.LEN_BRANCH_CODE     ;
	public static final int LEN_ACCOUNT_NO           = PayrollConst.LEN_ACCOUNT_NO      ;
	public static final int LEN_PAYMENT_MEANS_COUNT  = PayrollConst.PAYMENT_MEANS_COUNT ;
	public static final int LEN_COMMUTATION_COUNT    = PayrollConst.COMMUTATION_COUNT   ;
	public static final int LEN_COMMUTE_DISTANCE_INT = PayrollConst.LEN_DISTANCE_INT    ;
	public static final int LEN_COMMUTE_DISTANCE_DEC = PayrollConst.LEN_DISTANCE_DEC    ;
	public static final int LEN_DEPENDENT_COUNT      = LegalConst.LEN_DEPENDENT_COUNT;
	public static final int LEN_CITY_CODE            = LegalConst.LEN_CITY_CODE      ;
	public static final int LEN_HEALTH_NO            = LegalConst.LEN_HEALTH_NO      ;
	public static final int LEN_PENSION_NO           = LegalConst.LEN_PENSION_NO     ;
	public static final int LEN_FUND_NO              = LegalConst.LEN_FUND_NO        ;
	public static final int LEN_UNEMPLOY_NO          = LegalConst.LEN_UNEMPLOY_NO    ;
	public static final int LEN_BASE_PENSION_NO      = LegalConst.LEN_BASE_PENSION_NO;
	public static final int LEN_UNIT_AMOUNT_COUNT    = PayrollConst.UNIT_AMOUNT_COUNT   ;
	public static final int LEN_UNIT_AMOUNT_INT      = PayrollConst.LEN_UNIT_AMOUNT_INT ;
	public static final int LEN_UNIT_AMOUNT_DEC      = PayrollConst.LEN_UNIT_AMOUNT_DEC ;
	
	// 萔
	public static final int MODE_INSERT  = 0;
	public static final int MODE_UPDATE  = 1;

	public static final String REG_SPOUSE_UNINTEND       = LegalConst.SPOUSE_UNINTEND      ;	// z敪(ΏۊO)
	public static final String REG_SPOUSE_INTEND_GENERAL = LegalConst.SPOUSE_INTEND_GENERAL;	// zҋ敪(ʔz)
	public static final String REG_SPOUSE_INTEND_ELDERLY = LegalConst.SPOUSE_INTEND_ELDERLY;	// zҋ敪(Vlz)
	public static final String REG_SPOUSE_INTEND_LWSH    = LegalConst.SPOUSE_INTEND_LWSH   ;	// zҋ敪()
	public static final String REG_SPOUSE_INTEND_LWSH_EL = LegalConst.SPOUSE_INTEND_LWSH_EL;	// zҋ敪(Vl)
	
	public static final String REG_HANDICAP_GENERAL      = LegalConst.HANDICAP_GENERAL     ;	// Qҋ敪(ʏQ)
	public static final String REG_HANDICAP_SPECIAL      = LegalConst.HANDICAP_SPECIAL     ;	// Qҋ敪(ʏQ)
	public static final String REG_LIVE_WITH             = LegalConst.LIVE_WITH            ;	// 敪()
	public static final String REG_SPOUSE_GENERAL        = LegalConst.SPOUSE_GENERAL       ;	// z敪()
	public static final String REG_SPOUSE_ELDERLY        = LegalConst.SPOUSE_ELDERLY       ;	// z敪(Vl)
	public static final String REG_DEPENDENT_GENERAL     = LegalConst.DEPENDENT_GENERAL    ;	// }{敪(ʕ}{)
	public static final String REG_DEPENDENT_SPECIAL     = LegalConst.DEPENDENT_SPECIAL    ;	// }{敪(}{)
	public static final String REG_DEPENDENT_ELDERLY     = LegalConst.DEPENDENT_ELDERLY    ;	// }{敪(Vl}{)
	public static final String REG_DEPENDENT_ELD_REL     = LegalConst.DEPENDENT_ELD_REL    ;	// }{敪(Ve)
	
	// tB[h(Љی)
	private String   pltPensionType      ;
	private String   pltParttimeType     ;
	private String   pltEmployeeType     ;
	private String   pltCalcInsType      ;
	private String   pltNursingInsType   ;
	private String   pltCalcUnemployType ;
	private String   pltBonusHealthType  ;
	private String   pltBonusPensionType ;
	private String   txtHealthNo         ;
	private String   txtHealthPayment    ;
	private String   lblHealthPremium    ;
	private String   lblNursingPremium   ;
	private String   pltHealthGetEra     ;
	private String   pltHealthGetYear    ;
	private String   pltHealthGetMonth   ;
	private String   pltHealthGetDay     ;
	private String   pltHealthLostType   ;
	private String   pltHealthLostEra    ;
	private String   pltHealthLostYear   ;
	private String   pltHealthLostMonth  ;
	private String   pltHealthLostDay    ;
	private String   txtPensionNo        ;
	private String   txtPensionPayment   ;
	private String   lblPensionPremium   ;
	private String   pltPensionGetEra    ;
	private String   pltPensionGetYear   ;
	private String   pltPensionGetMonth  ;
	private String   pltPensionGetDay    ;
	private String   pltPensionLostType  ;
	private String   pltPensionLostEra   ;
	private String   pltPensionLostYear  ;
	private String   pltPensionLostMonth ;
	private String   pltPensionLostDay   ;
	private String   txtFundNo           ;
	private String   txtFundPremium      ;
	private String   pltFundGetEra       ;
	private String   pltFundGetYear      ;
	private String   pltFundGetMonth     ;
	private String   pltFundGetDay       ;
	private String   txtUnemployNo       ;
	private String   pltUnemployGetEra   ;
	private String   pltUnemployGetYear  ;
	private String   pltUnemployGetMonth ;
	private String   pltUnemployGetDay   ;
	private String   pltUnemployLostType ;
	private String   pltUnemployLostEra  ;
	private String   pltUnemployLostYear ;
	private String   pltUnemployLostMonth;
	private String   pltUnemployLostDay  ;
	// tB[h(Ƒ(ی))
	private String[] pltInsFamily        ;
	private String[] pltHeaQualifiedEra  ;
	private String[] pltHeaQualifiedYear ;
	private String[] pltHeaQualifiedMonth;
	private String[] pltHeaQualifiedDay  ;
	private String[] pltDisqualifiedEra  ;
	private String[] pltDisqualifiedYear ;
	private String[] pltDisqualifiedMonth;
	private String[] pltDisqualifiedDay  ;
	private String[] txtFamilyPensionNo ;
	private String[] txtFamilyInsRemarks ;
	// tB[h(Z)
	private String   txtPaymentCityCode  ;
	private String   txtSubmitCityCode   ;
	private String   txtJuneAmount       ;
	private String   txtJulyAmount       ;
	private String   txtAugustAmount     ;
	private String   txtSeptemberAmount  ;
	private String   txtOctoberAmount    ;
	private String   txtNovemberAmount   ;
	private String   txtDecemberAmount   ;
	private String   txtJanuaryAmount    ;
	private String   txtFebruaryAmount   ;
	private String   txtMarchAmount      ;
	private String   txtAprilAmount      ;
	private String   txtMayAmount        ;
	// tB[h()
	private String   pltIncomeTaxType    ;
	private String   pltAdjustmentType   ;
	private String   pltSelfWidowType    ;
	private String   pltSelfHandicapType ;
	private String   pltSelfStudentType  ;
	private String   pltSpouseIntendType ;
	private String   txtGeneralDependent ;
	private String   txtSpecificDependent;
	private String   txtElderlyDependent ;
	private String   txtLiveWithEldRel   ;
	private String   txtLiveWithHandiGe  ;
	private String   txtLiveWithHandiSp  ;
	private String   txtLiveWithHandiEl  ;
	private String   txtLiveWithHandiEr  ;
	private String   txtGeneralHandicap  ;
	private String   txtSpecificHandicap ;
	private String   hidDependentCount   ;
	// tB[h(Ƒ())
	private String[] pltLiveWithType     ;
	private String[] pltSpouseType       ;
	private String[] pltDependentType    ;
	private String[] pltHandicapType     ;
	// tB[h(ʋΎ蓖)
	private String[] pltPaymentInterval  ;
	private String[] pltLumpMonthlyType  ;
	private String[] pltPayStartMonth    ;
	private String[] txtCommuteDistance  ;
	private String[] txtCommuteAmount    ;
	private String[] txtCommuteTaxed     ;
	// tB[h(x@)
	private String[] pltCoBankCode       ;
	private String[] txtPaidBankCode     ;
	private String[] txtPaidBranchCode   ;
	public  String[] lblPaidBankName     ;
	public  String[] lblPaidBranchName   ;
	private String[] pltAccountType      ;
	private String[] txtAccountNo        ;
	private String[] txtHolderName       ;
	private String[] txtHolderKana       ;
	private String[] pltPaymentMeans     ;
	private String[] pltAmountType       ;
	private String[] txtFixedAmount      ;
	// tB[h(vZP)
	private int      countUnitType       ;
	private String[] hidUnitType         ;
	private String[] txtUnitAmount       ;
	// tB[h(r)
	private String   pltMidwayType       ;
	private String   txtFormerIncome     ;
	private String   txtFormerInsurance  ;
	private String   txtFormerTax        ;
	// ̑
	private String   hidCalcCurrentTab   ;
	// ی
	private float    healthPremiumRatio  ;
	private float    nursingPremiumRatio ;
	private float    pensionPremiumRatio ;
	
	private int      countInsFamily      ;
	private int      countIncomeFamily   ;
	private String[] hidFamilyInsSequence;
	private String[] hidFamilyTaxSequence;
	private String[] lblFamilyTaxName    ;
	private String[] lblUnitName         ;
	private Date     healthGetDate       ;
	private Date     healthLostDate      ;
	private Date     pensionGetDate      ;
	private Date     pensionLostDate     ;
	private Date     fundGetDate         ;
	private Date     unemployGetDate     ;
	private Date     unemployLostDate    ;
	private Date     insExpectedDate     ;
	private Date     finExpectedDate     ;
	private Date     resExpectedDate     ;
	private Date     incExpectedDate     ;
	
	// ҏW[h(0FVKo^A1FXV)
	private int mode;
	
	// v_EXg
	public String[][] aryPltEra;
	public String[][] aryPltShortYear;
	public String[][] aryPltYear;
	public String[][] aryPltMonth;
	public String[][] aryPltDay;
	public String[][] aryPltCoBank;
	public String[][] aryPltPaidBankName;
	public String[][] aryPltPaidBranchName;
	public String[][] aryPltAccountType;
	public String[][] aryPltPaymentMeans;
	public String[][] aryPltAmountType;
	public String[][] aryPltAmountTypeForRest;
	public String[][] aryPltPaymentInterval;
	public String[][] aryPltLumpMonthlyType;
	public String[][] aryPltPenDependentType;
	public String[][] aryPltIncomeTaxType;
	public String[][] aryPltAdjustmentType;
	public String[][] aryPltHandicapType;
	public String[][] aryPltWidowType;
	public String[][] aryPltStudentType;
	public String[][] aryPltSpouseIntendType;
	public String[][] aryPltLiveWithType;
	public String[][] aryPltSpouseType;
	public String[][] aryPltDependentType;
	public String[][] aryPltPensionType;
	public String[][] aryPltParttimeType;
	public String[][] aryPltEmployeeType;
	public String[][] aryPltCalcInsType;
	public String[][] aryPltNursingInsType;
	public String[][] aryPltCalcUnemployType;
	public String[][] aryPltBonusHealthType;
	public String[][] aryPltBounsPensionType;
	public String[][] aryPltHealthLostType;
	public String[][] aryPltPensionLostType;
	public String[][] aryPltUnemployLostType;
	public String[][] aryPltMidwayType;
	public String[][] aryPltInsFamily;
	
	// ݒ
	public List<MosPConfDto> listConf;
	
	/**
	 * RXgN^
	 */
	public HumanCalcVo() {
		super();
	}

	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYMENT") + getName("P_INFORMATION") + getName("P_EDIT");
	}

	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		// Љی
		NAM_HEALTH_NO		= getName("P_HEALTH_NO");
		NAM_HEALTH_PAYMENT	= getName("P_HEALTH_PAYMENT");
		NAM_UNEMPLOY_NO		= getName("P_UNEMPLOY_NO");
		NAM_PENSION_NO		= getName("P_PENSION_NO");
		NAM_PENSION_PAYMENT	= getName("P_PENSION_PAYMENT");
		NAM_FUND_NO			= getName("P_FUND_NO");
		// Z
		NAM_PAYMENT_CITY_CODE	= getName("P_PAYMENT_CITY_CODE");
		NAM_SUBMIT_CITY_CODE	= getName("P_SUBMIT_CITY_CODE");
		NAM_JUNE_AMOUNT			= getName("P_JUNE_AMOUNT");
		NAM_JULY_AMOUNT			= getName("P_JULY_AMOUNT");
		NAM_AUGUST_AMOUNT		= getName("P_AUGUST_AMOUNT");
		NAM_SEPTEMBER_AMOUNT	= getName("P_SEPTEMBER_AMOUNT");
		NAM_OCTOBER_AMOUNT		= getName("P_OCTOBER_AMOUNT");
		NAM_NOVEMBER_AMOUNT		= getName("P_NOVEMBER_AMOUNT");
		NAM_DECEMBER_AMOUNT		= getName("P_DECEMBER_AMOUNT");
		NAM_JANUARY_AMOUNT		= getName("P_JANUARY_AMOUNT");
		NAM_FEBRUARY_AMOUNT		= getName("P_FEBRUARY_AMOUNT");
		NAM_MARCH_AMOUNT		= getName("P_MARCH_AMOUNT");
		NAM_APRIL_AMOUNT		= getName("P_APRIL_AMOUNT");
		NAM_MAY_AMOUNT			= getName("P_MAY_AMOUNT");
		// ʋΎ蓖
		NAM_PAYMENT_INTERVAL	= getName("P_PAY_INTERVAL");
		NAM_LUMP_MONTHLY_TYPE	= getName("P_LUMP_TYPE");
		NAM_PAY_START_MONTH		= getName("P_PAY_START_MONTH");
		NAM_COMMUTE_DISTANCE	= getName("P_COMMUTE_DISTANCE");
		NAM_COMMUTE_AMOUNT		= getName("P_COMMUTE_AMOUNT");
		NAM_COMMUTE_TAXED		= getName("P_COMMUTE_TAXED");
		// 
		NAM_GENERAL_DEPENDENT	= getName("P_GENERAL_DEPENDENT");
		NAM_SPECIFIC_DEPENDENT	= getName("P_SPECIFIC_DEPENDENT");
		NAM_ELDERLY_DEPENDENT	= getName("P_ELDERLY_DEPENDENT");
		NAM_LIVE_WITH_ELD_REL	= getName("P_LIVE_WITH_ELD_REL");
		NAM_LIVE_WITH_HANDI_GE	= getName("P_LIVE_WITH_HANDI_GE");
		NAM_LIVE_WITH_HANDI_SP	= getName("P_LIVE_WITH_HANDI_SP");
		NAM_LIVE_WITH_HANDI_EL	= getName("P_LIVE_WITH_HANDI_EL");
		NAM_LIVE_WITH_HANDI_ER	= getName("P_LIVE_WITH_HANDI_ER");
		NAM_GENERAL_HANDICAP	= getName("P_GENERAL_HANDICAP");
		NAM_SPECIFIC_HANDICAP	= getName("P_SPECIFIC_HANDICAP");
		// x@
		NAM_CO_BANK_CODE		= getName("P_CO_BANK_CODE");
		NAM_PAID_BANK_CODE		= getName("P_PAID_BANK_CODE");
		NAM_PAID_BRANCH_CODE	= getName("P_PAID_BRANCH_CODE");
		NAM_ACCOUNT_NO			= getName("P_ACCOUNT_NO");
		NAM_HOLDER_KANA			= getName("P_HOLDER_KANA");
		NAM_HOLDER_NAME			= getName("P_HOLDER_NAME");
		NAM_FIXED_AMOUNT		= getName("P_FIXED_AMOUNT");
		// vZP
		NAM_UNIT_AMOUNT = getName("P_UNIT_AMOUNT");
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		// Ƒ()
		hidFamilyInsSequence = request.getParameterValues(PRM_HID_FAMILY_INS_SEQUENCE);
		hidFamilyTaxSequence = request.getParameterValues(PRM_HID_FAMILY_TAX_SEQUENCE);
		hidFamilyInsSequence = hidFamilyInsSequence == null ? new String[0] : hidFamilyInsSequence;
		countInsFamily       = hidFamilyInsSequence.length;
		hidFamilyTaxSequence = hidFamilyTaxSequence == null ? new String[0] : hidFamilyTaxSequence;
		countIncomeFamily    = hidFamilyTaxSequence.length;
		// Љی
		pltPensionType       = request.getParameter      (PRM_PLT_PENSION_TYPE       );
		pltParttimeType      = request.getParameter      (PRM_PLT_PARTTIME_TYPE      );
		pltEmployeeType      = request.getParameter      (PRM_PLT_EMPLOYEE_TYPE      );
		pltCalcInsType       = request.getParameter      (PRM_PLT_CALC_INS_TYPE      );
		pltNursingInsType    = request.getParameter      (PRM_PLT_NURSING_INS_TYPE   );
		pltCalcUnemployType  = request.getParameter      (PRM_PLT_CALC_UNEMPLOY_TYPE );
		pltBonusHealthType   = request.getParameter      (PRM_PLT_BONUS_HEALTH_TYPE  );
		pltBonusPensionType  = request.getParameter      (PRM_PLT_BONUS_PENSION_TYPE );
		txtHealthNo          = request.getParameter      (PRM_TXT_HEALTH_NO          );
		txtHealthPayment     = request.getParameter      (PRM_TXT_HEALTH_PAYMENT     );
		pltHealthGetEra      = request.getParameter      (PRM_PLT_HEALTH_GET_ERA     );
		pltHealthGetYear     = request.getParameter      (PRM_PLT_HEALTH_GET_YEAR    );
		pltHealthGetMonth    = request.getParameter      (PRM_PLT_HEALTH_GET_MONTH   );
		pltHealthGetDay      = request.getParameter      (PRM_PLT_HEALTH_GET_DAY     );
		pltHealthLostType    = request.getParameter      (PRM_PLT_HEALTH_LOST_TYPE   );
		pltHealthLostEra     = request.getParameter      (PRM_PLT_HEALTH_LOST_ERA    );
		pltHealthLostYear    = request.getParameter      (PRM_PLT_HEALTH_LOST_YEAR   );
		pltHealthLostMonth   = request.getParameter      (PRM_PLT_HEALTH_LOST_MONTH  );
		pltHealthLostDay     = request.getParameter      (PRM_PLT_HEALTH_LOST_DAY    );
		txtPensionNo         = request.getParameter      (PRM_TXT_PENSION_NO         );
		txtPensionPayment    = request.getParameter      (PRM_TXT_PENSION_PAYMENT    );
		pltPensionGetEra     = request.getParameter      (PRM_PLT_PENSION_GET_ERA    );
		pltPensionGetYear    = request.getParameter      (PRM_PLT_PENSION_GET_YEAR   );
		pltPensionGetMonth   = request.getParameter      (PRM_PLT_PENSION_GET_MONTH  );
		pltPensionGetDay     = request.getParameter      (PRM_PLT_PENSION_GET_DAY    );
		pltPensionLostType   = request.getParameter      (PRM_PLT_PENSION_LOST_TYPE  );
		pltPensionLostEra    = request.getParameter      (PRM_PLT_PENSION_LOST_ERA   );
		pltPensionLostYear   = request.getParameter      (PRM_PLT_PENSION_LOST_YEAR  );
		pltPensionLostMonth  = request.getParameter      (PRM_PLT_PENSION_LOST_MONTH );
		pltPensionLostDay    = request.getParameter      (PRM_PLT_PENSION_LOST_DAY   );
		txtFundNo            = request.getParameter      (PRM_TXT_FUND_NO            );
		pltFundGetEra        = request.getParameter      (PRM_PLT_FUND_GET_ERA       );
		pltFundGetYear       = request.getParameter      (PRM_PLT_FUND_GET_YEAR      );
		pltFundGetMonth      = request.getParameter      (PRM_PLT_FUND_GET_MONTH     );
		pltFundGetDay        = request.getParameter      (PRM_PLT_FUND_GET_DAY       );
		txtUnemployNo        = request.getParameter      (PRM_TXT_UNEMPLOY_NO        );
		pltUnemployGetEra    = request.getParameter      (PRM_PLT_UNEMPLOY_GET_ERA   );
		pltUnemployGetYear   = request.getParameter      (PRM_PLT_UNEMPLOY_GET_YEAR  );
		pltUnemployGetMonth  = request.getParameter      (PRM_PLT_UNEMPLOY_GET_MONTH );
		pltUnemployGetDay    = request.getParameter      (PRM_PLT_UNEMPLOY_GET_DAY   );
		pltUnemployLostType  = request.getParameter      (PRM_PLT_UNEMPLOY_LOST_TYPE );
		pltUnemployLostEra   = request.getParameter      (PRM_PLT_UNEMPLOY_LOST_ERA  );
		pltUnemployLostYear  = request.getParameter      (PRM_PLT_UNEMPLOY_LOST_YEAR );
		pltUnemployLostMonth = request.getParameter      (PRM_PLT_UNEMPLOY_LOST_MONTH);
		pltUnemployLostDay   = request.getParameter      (PRM_PLT_UNEMPLOY_LOST_DAY  );
		// Ƒ(ی)
		pltInsFamily         = request.getParameterValues(PRM_PLT_INS_FAMILY         );
		pltHeaQualifiedEra   = request.getParameterValues(PRM_PLT_HEA_QUALIFIED_ERA  );
		pltHeaQualifiedYear  = request.getParameterValues(PRM_PLT_HEA_QUALIFIED_YEAR );
		pltHeaQualifiedMonth = request.getParameterValues(PRM_PLT_HEA_QUALIFIED_MONTH);
		pltHeaQualifiedDay   = request.getParameterValues(PRM_PLT_HEA_QUALIFIED_DAY  );
		pltDisqualifiedEra   = request.getParameterValues(PRM_PLT_DISQUALIFIED_ERA   );
		pltDisqualifiedYear  = request.getParameterValues(PRM_PLT_DISQUALIFIED_YEAR  );
		pltDisqualifiedMonth = request.getParameterValues(PRM_PLT_DISQUALIFIED_MONTH );
		pltDisqualifiedDay   = request.getParameterValues(PRM_PLT_DISQUALIFIED_DAY   );
		txtFamilyPensionNo   = request.getParameterValues(PRM_TXT_FAMILY_PENSION_NO  );
		txtFamilyInsRemarks  = request.getParameterValues(PRM_TXT_FAMILY_INS_REMARKS );
		// Z
		txtPaymentCityCode   = request.getParameter      (PRM_TXT_PAYMENT_CITY_CODE  );
		txtSubmitCityCode    = request.getParameter      (PRM_TXT_SUBMIT_CITY_CODE   );
		txtJuneAmount        = request.getParameter      (PRM_TXT_JUNE_AMOUNT        );
		txtJulyAmount        = request.getParameter      (PRM_TXT_JULY_AMOUNT        );
		txtAugustAmount      = request.getParameter      (PRM_TXT_AUGUST_AMOUNT      );
		txtSeptemberAmount   = request.getParameter      (PRM_TXT_SEPTEMBER_AMOUNT   );
		txtOctoberAmount     = request.getParameter      (PRM_TXT_OCTOBER_AMOUNT     );
		txtNovemberAmount    = request.getParameter      (PRM_TXT_NOVEMBER_AMOUNT    );
		txtDecemberAmount    = request.getParameter      (PRM_TXT_DECEMBER_AMOUNT    );
		txtJanuaryAmount     = request.getParameter      (PRM_TXT_JANUARY_AMOUNT     );
		txtFebruaryAmount    = request.getParameter      (PRM_TXT_FEBRUARY_AMOUNT    );
		txtMarchAmount       = request.getParameter      (PRM_TXT_MARCH_AMOUNT       );
		txtAprilAmount       = request.getParameter      (PRM_TXT_APRIL_AMOUNT       );
		txtMayAmount         = request.getParameter      (PRM_TXT_MAY_AMOUNT         );
		// 
		pltIncomeTaxType     = request.getParameter      (PRM_PLT_INCOME_TAX_TYPE    );
		pltAdjustmentType    = request.getParameter      (PRM_PLT_ADJUSTMENT_TYPE    );
		pltSelfWidowType     = request.getParameter      (PRM_PLT_SELF_WIDOW_TYPE    );
		pltSelfHandicapType  = request.getParameter      (PRM_PLT_SELF_HANDICAP_TYPE );
		pltSelfStudentType   = request.getParameter      (PRM_PLT_SELF_STUDENT_TYPE  );
		pltSpouseIntendType  = request.getParameter      (PRM_PLT_SPOUSE_INTEND_TYPE );
		txtGeneralDependent  = request.getParameter      (PRM_TXT_GENERAL_DEPENDENT  );
		txtSpecificDependent = request.getParameter      (PRM_TXT_SPECIFIC_DEPENDENT );
		txtElderlyDependent  = request.getParameter      (PRM_TXT_ELDERLY_DEPENDENT  );
		txtLiveWithEldRel    = request.getParameter      (PRM_TXT_LIVE_WITH_ELD_REL  );
		txtLiveWithHandiGe   = request.getParameter      (PRM_TXT_LIVE_WITH_HANDI_GE );
		txtLiveWithHandiSp   = request.getParameter      (PRM_TXT_LIVE_WITH_HANDI_SP );
		txtLiveWithHandiEl   = request.getParameter      (PRM_TXT_LIVE_WITH_HANDI_EL );
		txtLiveWithHandiEr   = request.getParameter      (PRM_TXT_LIVE_WITH_HANDI_ER );
		txtGeneralHandicap   = request.getParameter      (PRM_TXT_GENERAL_HANDICAP   );
		txtSpecificHandicap  = request.getParameter      (PRM_TXT_SPECIFIC_HANDICAP  );
		hidDependentCount    = request.getParameter      (PRM_HID_DEPENDENT_COUNT    );
		// Ƒ()
		pltLiveWithType      = request.getParameterValues(PRM_PLT_LIVE_WITH_TYPE     );
		pltSpouseType        = request.getParameterValues(PRM_PLT_SPOUSE_TYPE        );
		pltDependentType     = request.getParameterValues(PRM_PLT_DEPENDENT_TYPE     );
		pltHandicapType      = request.getParameterValues(PRM_PLT_HANDICAP_TYPE      );
		// ʋΎ蓖
		pltPaymentInterval   = request.getParameterValues(PRM_PLT_PAYMENT_INTERVAL   );
		pltLumpMonthlyType   = request.getParameterValues(PRM_PLT_LUMP_MONTHLY_TYPE  );
		pltPayStartMonth     = request.getParameterValues(PRM_PLT_PAY_START_MONTH    );
		txtCommuteDistance   = request.getParameterValues(PRM_TXT_COMMUTE_DISTANCE   );
		txtCommuteAmount     = request.getParameterValues(PRM_TXT_COMMUTE_AMOUNT     );
		txtCommuteTaxed      = request.getParameterValues(PRM_TXT_COMMUTE_TAXED      );
		// x@
		pltCoBankCode        = request.getParameterValues(PRM_PLT_CO_BANK_CODE       );
		txtPaidBankCode      = request.getParameterValues(PRM_TXT_PAID_BANK_CODE     );
		txtPaidBranchCode    = request.getParameterValues(PRM_TXT_PAID_BRANCH_CODE   );
		pltAccountType       = request.getParameterValues(PRM_PLT_ACCOUNT_TYPE       );
		txtAccountNo         = request.getParameterValues(PRM_TXT_ACCOUNT_NO         );
		txtHolderName        = request.getParameterValues(PRM_TXT_HOLDER_NAME        );
		txtHolderKana        = request.getParameterValues(PRM_TXT_HOLDER_KANA        );
		pltPaymentMeans      = request.getParameterValues(PRM_PLT_PAYMENT_MEANS      );
		pltAmountType        = request.getParameterValues(PRM_PLT_AMOUNT_TYPE        );
		txtFixedAmount       = request.getParameterValues(PRM_TXT_FIXED_AMOUNT       );
		// vZP
		hidUnitType          = request.getParameterValues(PRM_HID_UNIT_TYPE          );
		txtUnitAmount        = request.getParameterValues(PRM_TXT_UNIT_AMOUNT        );
		// r                                      
		pltMidwayType        = request.getParameter      (PRM_PLT_MIDWAY_TYPE        );
		txtFormerIncome      = request.getParameter      (PRM_TXT_FORMER_INCOME      );
		txtFormerInsurance   = request.getParameter      (PRM_TXT_FORMER_INSURANCE   );
		txtFormerTax         = request.getParameter      (PRM_TXT_FORMER_TAX         );
		// ̑
		hidCalcCurrentTab    = request.getParameter      (PRM_HID_CALC_CURRENT_TAB   );
	}
	
	/**
	 * tB[hݒ
	 * @param listPaymentMeans
	 * @throws MospException
	 */
	public void setFields(
			CmSocInsuranceDto       cmSocInsuranceDto,
			CmResidenceTaxDto       cmResidenceTaxDto, 
			CmIncomeTaxDto          cmIncomeTaxDto   ,
			CmMidwayEnterDto        cmMidwayEnterDto ,
			List<CmPaymentMeansDto> listPaymentMeans ,
			List<CmCommutationDto > listCommutation  ,
			List<CmUnitAmountDto>   listUnitAmount   ,
			String[][]              aryUnitType
	) throws MospException {
		// tB[h
		initCalcFields();
		// Љی
		if (cmSocInsuranceDto != null) {
			String[] strHealthGetDate    = getJpImperialCal(listConf, cmSocInsuranceDto.getHealthGetDate   ());
			String[] strHealthLostDate   = getJpImperialCal(listConf, cmSocInsuranceDto.getHealthLostDate  ());
			String[] strPensionGetDate   = getJpImperialCal(listConf, cmSocInsuranceDto.getPensionGetDate  ());
			String[] strPensionLostDate  = getJpImperialCal(listConf, cmSocInsuranceDto.getPensionLostDate ());
			String[] strFundGetDate      = getJpImperialCal(listConf, cmSocInsuranceDto.getFundGetDate     ());
			String[] strUnemployGetDate  = getJpImperialCal(listConf, cmSocInsuranceDto.getUnemployGetDate ());
			String[] strUnemployLostDate = getJpImperialCal(listConf, cmSocInsuranceDto.getUnemployLostDate());
			pltPensionType       = cmSocInsuranceDto.getPensionType      ();
			pltParttimeType      = cmSocInsuranceDto.getParttimeType     ();
			pltEmployeeType      = cmSocInsuranceDto.getEmployeeType     ();
			pltCalcInsType       = cmSocInsuranceDto.getCalcInsType      ();
			pltNursingInsType    = cmSocInsuranceDto.getNursingInsType   ();
			pltCalcUnemployType  = cmSocInsuranceDto.getCalcUnemployType ();
			pltBonusHealthType   = cmSocInsuranceDto.getBonusHealthType  ();
			pltBonusPensionType  = cmSocInsuranceDto.getBonusPensionType ();
			txtHealthNo          = cmSocInsuranceDto.getHealthNo         ();
			txtHealthPayment     = String.valueOf(cmSocInsuranceDto.getHealthPayment    ());
			pltHealthGetEra      = strHealthGetDate[0];
			pltHealthGetYear     = strHealthGetDate[1];
			pltHealthGetMonth    = strHealthGetDate[2];
			pltHealthGetDay      = strHealthGetDate[3];
			pltHealthLostType    = cmSocInsuranceDto.getHealthLostType   ();
			pltHealthLostEra     = strHealthLostDate[0];
			pltHealthLostYear    = strHealthLostDate[1];
			pltHealthLostMonth   = strHealthLostDate[2];
			pltHealthLostDay     = strHealthLostDate[3];
			txtPensionNo         = cmSocInsuranceDto.getPensionNo        ();
			txtPensionPayment    = String.valueOf(cmSocInsuranceDto.getPensionPayment   ());
			pltPensionGetEra     = strPensionGetDate[0];
			pltPensionGetYear    = strPensionGetDate[1];
			pltPensionGetMonth   = strPensionGetDate[2];
			pltPensionGetDay     = strPensionGetDate[3];
			pltPensionLostType   = cmSocInsuranceDto.getPensionLostType  ();
			pltPensionLostEra    = strPensionLostDate[0];
			pltPensionLostYear   = strPensionLostDate[1];
			pltPensionLostMonth  = strPensionLostDate[2];
			pltPensionLostDay    = strPensionLostDate[3];
			txtFundNo            = cmSocInsuranceDto.getFundNo           ();
			pltFundGetEra        = strFundGetDate[0];
			pltFundGetYear       = strFundGetDate[1];
			pltFundGetMonth      = strFundGetDate[2];
			pltFundGetDay        = strFundGetDate[3];
			txtUnemployNo        = cmSocInsuranceDto.getUnemployNo       ();
			pltUnemployGetEra    = strUnemployGetDate[0];
			pltUnemployGetYear   = strUnemployGetDate[1];
			pltUnemployGetMonth  = strUnemployGetDate[2];
			pltUnemployGetDay    = strUnemployGetDate[3];
			pltUnemployLostType  = cmSocInsuranceDto.getUnemployLostType ();
			pltUnemployLostEra   = strUnemployLostDate[0];
			pltUnemployLostYear  = strUnemployLostDate[1];
			pltUnemployLostMonth = strUnemployLostDate[2];
			pltUnemployLostDay   = strUnemployLostDate[3];
			lblHealthPremium     = String.valueOf(LegalUtility.calcPremium(cmSocInsuranceDto.getHealthPayment(), healthPremiumRatio , BigDecimal.ROUND_HALF_UP)) + getName("P_YEN");
			lblPensionPremium    = String.valueOf(LegalUtility.calcPremium(cmSocInsuranceDto.getPensionPayment(), pensionPremiumRatio, BigDecimal.ROUND_HALF_UP)) + getName("P_YEN");
			if (cmSocInsuranceDto.getNursingInsType().equals(LegalConst.NURSING_INS_AUTO)) {
				lblNursingPremium    = String.valueOf(getName("P_NURSING_PREMIUM") + getName("C_SEPARATOR") +
						LegalUtility.calcPremium(cmSocInsuranceDto.getHealthPayment(), nursingPremiumRatio, BigDecimal.ROUND_HALF_UP)) + getName("P_YEN");
			}
		}
		// Z
		if (cmResidenceTaxDto != null) {
			txtPaymentCityCode   = cmResidenceTaxDto.getPaymentCityCode ();
			txtSubmitCityCode    = cmResidenceTaxDto.getSubmitCityCode  ();
			txtJuneAmount        = String.valueOf(cmResidenceTaxDto.getJuneAmount      ());
			txtJulyAmount        = String.valueOf(cmResidenceTaxDto.getJulyAmount      ());
			txtAugustAmount      = String.valueOf(cmResidenceTaxDto.getAugustAmount    ());
			txtSeptemberAmount   = String.valueOf(cmResidenceTaxDto.getSeptemberAmount ());
			txtOctoberAmount     = String.valueOf(cmResidenceTaxDto.getOctoberAmount   ());
			txtNovemberAmount    = String.valueOf(cmResidenceTaxDto.getNovemberAmount  ());
			txtDecemberAmount    = String.valueOf(cmResidenceTaxDto.getDecemberAmount  ());
			txtJanuaryAmount     = String.valueOf(cmResidenceTaxDto.getJanuaryAmount   ());
			txtFebruaryAmount    = String.valueOf(cmResidenceTaxDto.getFebruaryAmount  ());
			txtMarchAmount       = String.valueOf(cmResidenceTaxDto.getMarchAmount     ());
			txtAprilAmount       = String.valueOf(cmResidenceTaxDto.getAprilAmount     ());
			txtMayAmount         = String.valueOf(cmResidenceTaxDto.getMayAmount       ());
		}
		// 
		if (cmIncomeTaxDto != null) {
			pltIncomeTaxType     = cmIncomeTaxDto.getIncomeTaxType   ();
			pltAdjustmentType    = cmIncomeTaxDto.getAdjustmentType  ();
			pltSelfWidowType     = cmIncomeTaxDto.getSelfWidowType   ();
			pltSelfHandicapType  = cmIncomeTaxDto.getSelfHandicapType();
			pltSelfStudentType   = cmIncomeTaxDto.getSelfStudentType ();
			pltSpouseIntendType  = cmIncomeTaxDto.getSpouseIntendType();
			txtGeneralDependent  = String.valueOf(cmIncomeTaxDto.getGeneralDependent ());
			txtSpecificDependent = String.valueOf(cmIncomeTaxDto.getSpecificDependent());
			txtElderlyDependent  = String.valueOf(cmIncomeTaxDto.getElderlyDependent ());
			txtLiveWithEldRel    = String.valueOf(cmIncomeTaxDto.getLiveWithEldRel   ());
			txtLiveWithHandiGe   = String.valueOf(cmIncomeTaxDto.getLiveWithHandiGe  ());
			txtLiveWithHandiSp   = String.valueOf(cmIncomeTaxDto.getLiveWithHandiSp  ());
			txtLiveWithHandiEl   = String.valueOf(cmIncomeTaxDto.getLiveWithHandiEl  ());
			txtLiveWithHandiEr   = String.valueOf(cmIncomeTaxDto.getLiveWithHandiEr  ());
			txtGeneralHandicap   = String.valueOf(cmIncomeTaxDto.getGeneralHandicap  ());
			txtSpecificHandicap  = String.valueOf(cmIncomeTaxDto.getSpecificHandicap ());
			hidDependentCount    = String.valueOf(cmIncomeTaxDto.getDependentCount   ());
		}
		// ʋΎ蓖
		for (int i = 0; i < PayrollConst.COMMUTATION_COUNT; i++) {
			for (int j = 0; j < listCommutation.size(); j++) {
				CmCommutationDto dto = listCommutation.get(j);
				if (dto.getCommuteSequence() == i) {
					pltPaymentInterval[i] = dto.getPaymentInterval();
					pltLumpMonthlyType[i] = dto.getLumpMonthlyType();
					pltPayStartMonth  [i] = String.valueOf(MospUtility.getMonth(dto.getPayStartMonth()));
					txtCommuteDistance[i] = String.valueOf(dto.getCommuteDistance());
					txtCommuteAmount  [i] = String.valueOf(dto.getCommuteAmount  ());
					txtCommuteTaxed   [i] = String.valueOf(dto.getCommuteTaxed   ());
				}
			}
		}
		// x@
		for (int i = 0; i < PayrollConst.PAYMENT_MEANS_COUNT; i++) {
			for (int j = 0; j < listPaymentMeans.size(); j++) {
				CmPaymentMeansDto dto = listPaymentMeans.get(j);
				if (dto.getMeansSequence() == i) {
					pltCoBankCode    [i] = dto.getCoBankCode    ();
					txtPaidBankCode  [i] = dto.getPaidBankCode  ();
					txtPaidBranchCode[i] = dto.getPaidBranchCode();
					pltAccountType   [i] = dto.getAccountType   ();
					txtAccountNo     [i] = dto.getAccountNo     ();
					txtHolderName    [i] = dto.getHolderName    ();
					txtHolderKana    [i] = dto.getHolderKana    ();
					pltPaymentMeans  [i] = dto.getPaymentMeans  ();
					pltAmountType    [i] = dto.getAmountType    ();
					txtFixedAmount   [i] = String.valueOf(dto.getFixedAmount());
/*					// sAxX擾B
					lblPaidBankName  [i] = getCodeName(dto.getPaidBankCode  (), aryPltPaidBankName  ); 
					lblPaidBranchName[i] = getCodeNameCondition(dto.getPaidBankCode(), dto.getPaidBranchCode(), aryPltPaidBranchName); 
*/					break;
				}
			}
		}
		// vZP
		countUnitType = aryUnitType.length;
		hidUnitType   = new String[countUnitType];
		lblUnitName   = new String[countUnitType];
		txtUnitAmount = new String[countUnitType];
		for (int i = 0; i < countUnitType; i++) {
			hidUnitType[i] = aryUnitType[i][0];
			lblUnitName[i] = aryUnitType[i][1];
			for (Iterator<CmUnitAmountDto> it = listUnitAmount.iterator(); it.hasNext();) {
				CmUnitAmountDto dto = it.next();
				if (aryUnitType[i][0].equals(dto.getUnitType())) {
					txtUnitAmount[i] = getFormatNumber(dto.getUnitAmount(), PayrollConst.FORMAT_UNIT_AMOUNT);
					break;
				}
			}
		}

		if(cmMidwayEnterDto != null){
			pltMidwayType       = cmMidwayEnterDto.getMidwayType();
			txtFormerIncome     = String.valueOf(cmMidwayEnterDto.getFormerIncome());
			txtFormerInsurance  = String.valueOf(cmMidwayEnterDto.getFormerInsurance());
			txtFormerTax        = String.valueOf(cmMidwayEnterDto.getFormerTax());
		}
	
	}
	
	/**
	 * tB[hݒ
	 * @param dto ЏDTO
	 */
	public void setPremiumRatio(CmCompanyDto dto) {
		if (dto == null) {
			healthPremiumRatio  = 0F;
			nursingPremiumRatio = 0F;
			pensionPremiumRatio = 0F;
		} else {
			healthPremiumRatio  = dto.getHealthPremiumRate ();
			nursingPremiumRatio = dto.getNursingPremiumRate();
			pensionPremiumRatio = dto.getPensionPremiumRate();
		}
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// Nی
		healthGetDate = checkDateParam(
				listConf, pltHealthGetEra, pltHealthGetYear, pltHealthGetMonth, pltHealthGetDay, getName("P_HEALTH_GET_DATE"),
				PRM_PLT_HEALTH_GET_ERA, PRM_PLT_HEALTH_GET_YEAR, PRM_PLT_HEALTH_GET_MONTH, PRM_PLT_HEALTH_GET_DAY ,false, 0
		);
		healthLostDate = checkDateParam(
				listConf, pltHealthLostEra, pltHealthLostYear, pltHealthLostMonth, pltHealthLostDay, getName("P_HEALTH_LOST_DATE"),
				PRM_PLT_HEALTH_LOST_ERA, PRM_PLT_HEALTH_LOST_YEAR, PRM_PLT_HEALTH_LOST_MONTH, PRM_PLT_HEALTH_LOST_DAY ,false, 0
		);
		pensionGetDate = checkDateParam(
				listConf, pltPensionGetEra, pltPensionGetYear, pltPensionGetMonth, pltPensionGetDay, getName("P_PENSION_GET_DATE"),
				PRM_PLT_PENSION_GET_ERA, PRM_PLT_PENSION_GET_YEAR, PRM_PLT_PENSION_GET_MONTH, PRM_PLT_PENSION_GET_DAY ,false, 0
		);
		pensionLostDate = checkDateParam(
				listConf, pltPensionLostEra, pltPensionLostYear, pltPensionLostMonth, pltPensionLostDay, getName("NAM_PENSION_LOST_DATE"),
				PRM_PLT_PENSION_LOST_ERA, PRM_PLT_PENSION_LOST_YEAR, PRM_PLT_PENSION_LOST_MONTH, PRM_PLT_PENSION_LOST_DAY ,false, 0
		);
		fundGetDate = checkDateParam(
				listConf, pltFundGetEra, pltFundGetYear, pltFundGetMonth, pltFundGetDay, getName("P_FUND_GET_DATE"),
				PRM_PLT_FUND_GET_ERA, PRM_PLT_FUND_GET_YEAR, PRM_PLT_FUND_GET_MONTH, PRM_PLT_FUND_GET_DAY ,false, 0
		);
		unemployGetDate = checkDateParam(
				listConf, pltUnemployGetEra, pltUnemployGetYear, pltUnemployGetMonth, pltUnemployGetDay, getName("P_UNEMPLOY_GET_DATE"),
				PRM_PLT_UNEMPLOY_GET_ERA, PRM_PLT_UNEMPLOY_GET_YEAR, PRM_PLT_UNEMPLOY_GET_MONTH, PRM_PLT_UNEMPLOY_GET_DAY ,false, 0
		);
		unemployLostDate = checkDateParam(
				listConf, pltUnemployLostEra, pltUnemployLostYear, pltUnemployLostMonth, pltUnemployLostDay, getName("P_UNEMPLOY_LOST_DATE"),
				PRM_PLT_UNEMPLOY_LOST_ERA, PRM_PLT_UNEMPLOY_LOST_YEAR, PRM_PLT_UNEMPLOY_LOST_MONTH, PRM_PLT_UNEMPLOY_LOST_DAY ,false, 0
		);
		insExpectedDate   = getDate("1901", "1", String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		
		checkNumber(txtHealthNo      , NAM_HEALTH_NO      , PRM_TXT_HEALTH_NO      );
		checkNumber(txtHealthPayment , NAM_HEALTH_PAYMENT , PRM_TXT_HEALTH_PAYMENT );
		checkNumber(txtPensionNo     , NAM_PENSION_NO     , PRM_TXT_PENSION_NO     );
		checkNumber(txtPensionPayment, NAM_PENSION_PAYMENT, PRM_TXT_PENSION_PAYMENT);
		checkNumber(txtFundNo        , NAM_FUND_NO        , PRM_TXT_FUND_NO        );
		checkPhone (txtUnemployNo    , NAM_UNEMPLOY_NO    , PRM_TXT_UNEMPLOY_NO    );
		
		// Z
		resExpectedDate = getDate("1901", "1", String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		checkNumber(txtPaymentCityCode , NAM_PAYMENT_CITY_CODE, PRM_TXT_PAYMENT_CITY_CODE);
		checkNumber(txtSubmitCityCode  , NAM_SUBMIT_CITY_CODE , PRM_TXT_SUBMIT_CITY_CODE );
		checkInteger(txtJuneAmount     , NAM_JUNE_AMOUNT      , PRM_TXT_JUNE_AMOUNT      );
		checkInteger(txtJulyAmount     , NAM_JULY_AMOUNT      , PRM_TXT_JULY_AMOUNT      );
		checkInteger(txtAugustAmount   , NAM_AUGUST_AMOUNT    , PRM_TXT_AUGUST_AMOUNT    );
		checkInteger(txtSeptemberAmount, NAM_SEPTEMBER_AMOUNT , PRM_TXT_SEPTEMBER_AMOUNT );
		checkInteger(txtOctoberAmount  , NAM_OCTOBER_AMOUNT   , PRM_TXT_OCTOBER_AMOUNT   );
		checkInteger(txtNovemberAmount , NAM_NOVEMBER_AMOUNT  , PRM_TXT_NOVEMBER_AMOUNT  );
		checkInteger(txtDecemberAmount , NAM_DECEMBER_AMOUNT  , PRM_TXT_DECEMBER_AMOUNT  );
		checkInteger(txtJanuaryAmount  , NAM_JANUARY_AMOUNT   , PRM_TXT_JANUARY_AMOUNT   );
		checkInteger(txtFebruaryAmount , NAM_FEBRUARY_AMOUNT  , PRM_TXT_FEBRUARY_AMOUNT  );
		checkInteger(txtMarchAmount    , NAM_MARCH_AMOUNT     , PRM_TXT_MARCH_AMOUNT     );
		checkInteger(txtAprilAmount    , NAM_APRIL_AMOUNT     , PRM_TXT_APRIL_AMOUNT     );
		checkInteger(txtMayAmount      , NAM_MAY_AMOUNT       , PRM_TXT_MAY_AMOUNT       );
		// 
		incExpectedDate = getDate("1901", "1", String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		// ʋΎ蓖
		for (int i = 0; i < PayrollConst.COMMUTATION_COUNT; i++) {
			if (isCommutationAllBlank(i)) {
				continue;
			}
			checkRequired(pltPaymentInterval[i], NAM_PAYMENT_INTERVAL , i, PRM_PLT_PAYMENT_INTERVAL );
			checkRequired(pltLumpMonthlyType[i], NAM_LUMP_MONTHLY_TYPE, i, PRM_PLT_LUMP_MONTHLY_TYPE);
			checkRequired(pltPayStartMonth  [i], NAM_PAY_START_MONTH  , i, PRM_PLT_PAY_START_MONTH  );
			checkRequired(txtCommuteAmount  [i], NAM_COMMUTE_AMOUNT   , i, PRM_TXT_COMMUTE_AMOUNT   );
			checkNumber  (txtCommuteAmount  [i], NAM_COMMUTE_AMOUNT   , i, PRM_TXT_COMMUTE_AMOUNT   );
			checkNumber  (txtCommuteTaxed   [i], NAM_COMMUTE_TAXED    , i, PRM_TXT_COMMUTE_TAXED    );
			checkDecimal (txtCommuteDistance[i], LEN_COMMUTE_DISTANCE_INT, LEN_COMMUTE_DISTANCE_DEC, NAM_COMMUTE_DISTANCE, PRM_TXT_COMMUTE_DISTANCE, true, i);
			checkLength  (txtCommuteAmount  [i], LEN_MONEY_AMOUNT, NAM_COMMUTE_AMOUNT  , i, PRM_TXT_COMMUTE_AMOUNT  );
			checkLength  (txtCommuteTaxed   [i], LEN_MONEY_AMOUNT, NAM_COMMUTE_TAXED   , i, PRM_TXT_COMMUTE_TAXED   );
		}
		// x@
		for (int i = 0; i < PayrollConst.PAYMENT_MEANS_COUNT; i++) {
			if (isPaymentMeansAllBlank(i)) {
				continue;
			}
			if (pltPaymentMeans[i] != null && pltPaymentMeans[i].equals(PayrollConst.PAYMENT_MEANS_ACCOUNT)) {
				checkRequired(pltCoBankCode    [i], NAM_CO_BANK_CODE    , i, PRM_PLT_CO_BANK_CODE    );
				checkRequired(txtPaidBankCode  [i], NAM_PAID_BANK_CODE  , i, PRM_TXT_PAID_BANK_CODE  );
				checkRequired(txtPaidBranchCode[i], NAM_PAID_BRANCH_CODE, i, PRM_TXT_PAID_BRANCH_CODE);
				checkRequired(txtAccountNo     [i], NAM_ACCOUNT_NO      , i, PRM_TXT_ACCOUNT_NO      );
				checkRequired(txtHolderName    [i], NAM_HOLDER_NAME     , i, PRM_TXT_HOLDER_NAME     );
				checkRequired(txtHolderKana    [i], NAM_HOLDER_KANA     , i, PRM_TXT_HOLDER_KANA     );
			}
			checkNumber (txtPaidBankCode  [i], NAM_PAID_BANK_CODE  , i, PRM_TXT_PAID_BANK_CODE  );
			checkNumber (txtPaidBranchCode[i], NAM_PAID_BRANCH_CODE, i, PRM_TXT_PAID_BRANCH_CODE);
			checkNumber (txtAccountNo     [i], NAM_ACCOUNT_NO      , i, PRM_TXT_ACCOUNT_NO      );
			checkNumber (txtFixedAmount   [i], NAM_FIXED_AMOUNT    , i, PRM_TXT_FIXED_AMOUNT    );
			checkLength (txtPaidBankCode  [i], LEN_BANK_CODE   , NAM_PAID_BANK_CODE   , i, PRM_TXT_PAID_BANK_CODE  );
			checkLength (txtPaidBranchCode[i], LEN_BRANCH_CODE , NAM_PAID_BRANCH_CODE , i, PRM_TXT_PAID_BRANCH_CODE);
			checkLength (txtAccountNo     [i], LEN_ACCOUNT_NO  , NAM_ACCOUNT_NO       , i, PRM_TXT_ACCOUNT_NO      );
			checkLength (txtHolderName    [i], LEN_K_NAME      , NAM_HOLDER_NAME      , i, PRM_TXT_HOLDER_NAME     );
			checkLength (txtHolderKana    [i], LEN_K_NAME      , NAM_HOLDER_KANA      , i, PRM_TXT_HOLDER_KANA     );
			checkLength (txtFixedAmount   [i], LEN_MONEY_AMOUNT, NAM_FIXED_AMOUNT     , i, PRM_TXT_FIXED_AMOUNT    );
		}
		// vZP
		for (int i = 0; i < countUnitType; i++) {
			if (txtUnitAmount[i] == null || txtUnitAmount[i].equals("")) {
				continue;
			}
			checkDecimal(txtUnitAmount[i], LEN_UNIT_AMOUNT_INT, LEN_UNIT_AMOUNT_DEC, NAM_UNIT_AMOUNT, PRM_TXT_UNIT_AMOUNT, true, i);
		}
		// ÓmFI
		endValidation();
	}
	
	/**
	 * ^CvmF()B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	private void checkInteger(String value, String name, String id) throws MospException {
		if (value != null && !value.equals("")) {
			checkRegex(value, PayrollConst.REG_INTEGER, name, id);
		}
	}
	
	/**
	 * o^x@ݒ
	 * @param listUpPaymentMeans
	 * @return o^x@񃊃Xg
	 */
	public ArrayList<CmPaymentMeansDto> chkRegistPaymentData(ArrayList<CmPaymentMeansDto> listUpPaymentMeans) {
		ArrayList<CmPaymentMeansDto> listRevPaymentMeans = new ArrayList<CmPaymentMeansDto>();
		for (int i = 0; i < listUpPaymentMeans.size(); i++) {
			CmPaymentMeansDto cmPaymentMeansDto = listUpPaymentMeans.get(i);
			// ̂ł
			if (cmPaymentMeansDto.getHolderName            ().equals(lblKName)) {
				// tKił
				if(cmPaymentMeansDto.getHolderKana         ().equals(lblKKana)) {
					// ڐ
					int cntPram = 9;
					// ق̐
					int cntSame = 0;
					if (cmPaymentMeansDto.getAccountNo     ().equals("")) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getAccountType   ().equals("")) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getAmountType    ().equals("")) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getCoBankCode    ().equals("")) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getFixedAmount   () == 0) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getPaidBankCode  ().equals("")) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getPaidBranchCode().equals("")) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getPaymentMeans  ().equals("")) {
						cntSame ++;
					}
					if (cmPaymentMeansDto.getPaymentMeans  ().equals("")) {
						cntSame ++;
					}
					// ڐƂ̈vmF
					if (cntSame != cntPram) {
						// Xg֒ǉ
						listRevPaymentMeans.add(cmPaymentMeansDto);
					}
				} else {
					// Xg֒ǉ
					listRevPaymentMeans.add(cmPaymentMeansDto);
				}
			} else {
				// Xg֒ǉ
				listRevPaymentMeans.add(cmPaymentMeansDto);

			}
		}
		return listRevPaymentMeans;

	}		

	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param listPaymentMeans
	 * @throws MospException
	 */
	public void setDtoFields(
			CmSocInsuranceDto       cmSocInsuranceDto,
			CmResidenceTaxDto       cmResidenceTaxDto, 
			CmIncomeTaxDto          cmIncomeTaxDto   ,
			CmMidwayEnterDto        cmMidwayEnterDto ,
			List<CmPaymentMeansDto> listPaymentMeans ,
			List<CmCommutationDto > listCommutation  ,
			List<CmUnitAmountDto>   listUnitAmount
	) throws MospException {
		// Љی
		cmSocInsuranceDto.setKCode            (lblKCode                      );
		cmSocInsuranceDto.setPensionType      (pltPensionType                );
		cmSocInsuranceDto.setParttimeType     (pltParttimeType               );
		cmSocInsuranceDto.setEmployeeType     (pltEmployeeType               );
		cmSocInsuranceDto.setCalcInsType      (pltCalcInsType                );
		cmSocInsuranceDto.setNursingInsType   (pltNursingInsType             );
		cmSocInsuranceDto.setCalcUnemployType (pltCalcUnemployType           );
		cmSocInsuranceDto.setBonusHealthType  (pltBonusHealthType            );
		cmSocInsuranceDto.setBonusPensionType (pltBonusPensionType           );
		cmSocInsuranceDto.setHealthNo         (txtHealthNo                   );
		cmSocInsuranceDto.setHealthPayment    (getIntParam(txtHealthPayment ));
		cmSocInsuranceDto.setHealthGetDate    (healthGetDate                 );
		cmSocInsuranceDto.setHealthLostType   (pltHealthLostType             );
		cmSocInsuranceDto.setHealthLostDate   (healthLostDate                );
		cmSocInsuranceDto.setPensionNo        (txtPensionNo                  );
		cmSocInsuranceDto.setPensionPayment   (getIntParam(txtPensionPayment));
		cmSocInsuranceDto.setPensionGetDate   (pensionGetDate                );
		cmSocInsuranceDto.setPensionLostType  (pltPensionLostType            );
		cmSocInsuranceDto.setPensionLostDate  (pensionLostDate               );
		cmSocInsuranceDto.setFundNo           (txtFundNo                     );
		cmSocInsuranceDto.setFundGetDate      (fundGetDate                   );
		cmSocInsuranceDto.setUnemployNo       (txtUnemployNo                 );
		cmSocInsuranceDto.setUnemployGetDate  (unemployGetDate               );
		cmSocInsuranceDto.setUnemployLostType (pltUnemployLostType           );
		cmSocInsuranceDto.setUnemployLostDate (unemployLostDate              );
		cmSocInsuranceDto.setInsExpectedDate  (insExpectedDate               );
		// Z
		cmResidenceTaxDto.setKCode           (lblKCode                       );
		cmResidenceTaxDto.setPaymentCityCode (txtPaymentCityCode             );
		cmResidenceTaxDto.setSubmitCityCode  (txtSubmitCityCode              );
		cmResidenceTaxDto.setJuneAmount      (getIntParam(txtJuneAmount     ));
		cmResidenceTaxDto.setJulyAmount      (getIntParam(txtJulyAmount     ));
		cmResidenceTaxDto.setAugustAmount    (getIntParam(txtAugustAmount   ));
		cmResidenceTaxDto.setSeptemberAmount (getIntParam(txtSeptemberAmount));
		cmResidenceTaxDto.setOctoberAmount   (getIntParam(txtOctoberAmount  ));
		cmResidenceTaxDto.setNovemberAmount  (getIntParam(txtNovemberAmount ));
		cmResidenceTaxDto.setDecemberAmount  (getIntParam(txtDecemberAmount ));
		cmResidenceTaxDto.setJanuaryAmount   (getIntParam(txtJanuaryAmount  ));
		cmResidenceTaxDto.setFebruaryAmount  (getIntParam(txtFebruaryAmount ));
		cmResidenceTaxDto.setMarchAmount     (getIntParam(txtMarchAmount    ));
		cmResidenceTaxDto.setAprilAmount     (getIntParam(txtAprilAmount    ));
		cmResidenceTaxDto.setMayAmount       (getIntParam(txtMayAmount      ));
		cmResidenceTaxDto.setResExpectedDate (resExpectedDate                );
		// 
		cmIncomeTaxDto.setKCode            (lblKCode                         );
		cmIncomeTaxDto.setIncExpectedDate  (incExpectedDate                  );
		cmIncomeTaxDto.setIncomeTaxType    (pltIncomeTaxType                 );
		cmIncomeTaxDto.setAdjustmentType   (pltAdjustmentType                );
		cmIncomeTaxDto.setSelfWidowType    (pltSelfWidowType                 );
		cmIncomeTaxDto.setSelfHandicapType (pltSelfHandicapType              );
		cmIncomeTaxDto.setSelfStudentType  (pltSelfStudentType               );
		cmIncomeTaxDto.setSpouseIntendType (pltSpouseIntendType              );
		cmIncomeTaxDto.setGeneralDependent (getIntParam(txtGeneralDependent ));
		cmIncomeTaxDto.setSpecificDependent(getIntParam(txtSpecificDependent));
		cmIncomeTaxDto.setElderlyDependent (getIntParam(txtElderlyDependent ));
		cmIncomeTaxDto.setLiveWithEldRel   (getIntParam(txtLiveWithEldRel   ));
		cmIncomeTaxDto.setLiveWithHandiGe  (getIntParam(txtLiveWithHandiGe  ));
		cmIncomeTaxDto.setLiveWithHandiSp  (getIntParam(txtLiveWithHandiSp  ));
		cmIncomeTaxDto.setLiveWithHandiEl  (getIntParam(txtLiveWithHandiEl  ));
		cmIncomeTaxDto.setLiveWithHandiEr  (getIntParam(txtLiveWithHandiEr  ));
		cmIncomeTaxDto.setGeneralHandicap  (getIntParam(txtGeneralHandicap  ));
		cmIncomeTaxDto.setDependentCount   (getIntParam(hidDependentCount   ));
		cmIncomeTaxDto.setSpecificHandicap (getIntParam(txtSpecificHandicap ));
		cmIncomeTaxDto.setIncExpectedDate  (incExpectedDate                  );
		// x@
		for (int i = 0; i < PayrollConst.PAYMENT_MEANS_COUNT; i++) {
			if (isPaymentMeansAllBlank(i)) {
				continue;
			}
			CmPaymentMeansDto dto = new CmPaymentMeansDto();
			dto.setKCode        (lblKCode);
			dto.setMeansSequence(i);
			switch (i) {
				case PayrollConst.PAYMENT_MEANS_SEQ_1:
				case PayrollConst.PAYMENT_MEANS_SEQ_2:
					dto.setAllowanceType(PayrollConst.ALLOWANCE_TYPE_SALARY);
					break;
				case PayrollConst.PAYMENT_MEANS_SEQ_3:
				case PayrollConst.PAYMENT_MEANS_SEQ_4:
					dto.setAllowanceType(PayrollConst.ALLOWANCE_TYPE_BONUS);
					break;
				default:
					break;
			}
			
			// O[ݒ荀
			// UsAUxXAԍ͋ȊOAw蕶ɂȂ܂őOu0vŖ߂B
			String paidBankCode   = setBeforeZero(txtPaidBankCode  [i], LEN_BANK_CODE  );
			String paidBranchCode = setBeforeZero(txtPaidBranchCode[i], LEN_BRANCH_CODE);
			String accountNo      = setBeforeZero(txtAccountNo     [i], LEN_ACCOUNT_NO );
			dto.setCoBankCode    (pltCoBankCode    [i]);
			dto.setPaidBankCode  (paidBankCode);
			dto.setPaidBranchCode(paidBranchCode);
			dto.setAccountType   (pltAccountType   [i]);
			dto.setAccountNo     (accountNo);
			// `ƃtKiɂ͑IЈ݂̂B
			dto.setHolderName    (txtHolderName[i]);
			dto.setHolderKana    (txtHolderKana[i]);
			dto.setPaymentMeans  (pltPaymentMeans  [i]);
			dto.setAmountType    (pltAmountType    [i]);
			dto.setFixedAmount   (getIntParam(txtFixedAmount[i]));
			dto.setDeleteFlag    (MospConst.DELETE_FLAG_OFF);
			listPaymentMeans.add(dto);
		}
		// ʋΎ蓖
		for (int i = 0; i < PayrollConst.COMMUTATION_COUNT; i++) {
			if (isCommutationAllBlank(i)) {
				continue;
			}
			CmCommutationDto dto = new CmCommutationDto();
			dto.setKCode          (lblKCode);
			dto.setCommuteSequence(i       );
			switch (i) {
				case PayrollConst.COMMUTE_SEQ_1:
					dto.setCommuteType(PayrollConst.COMMUTE_TYPE_FACILITY);
					break;
				case PayrollConst.COMMUTE_SEQ_2:
					dto.setCommuteType(PayrollConst.COMMUTE_TYPE_CAR);
					break;
				default:
					break;
			}
			dto.setPaymentInterval(pltPaymentInterval[i]);
			dto.setLumpMonthlyType(pltLumpMonthlyType[i]);
			dto.setPayStartMonth  (getDateForMonth(pltPayStartMonth  [i]));
			dto.setCommuteDistance(getFloatParam  (txtCommuteDistance[i]));
			dto.setCommuteAmount  (getIntParam    (txtCommuteAmount  [i]));
			dto.setCommuteTaxed   (getIntParam    (txtCommuteTaxed   [i]));
			dto.setDeleteFlag     (MospConst.DELETE_FLAG_OFF);
			listCommutation.add(dto);
		}
		// vZP
		for (int i = 0; i < countUnitType; i++) {
			if (txtUnitAmount[i] == null || txtUnitAmount[i].equals("")) {
				continue;
			}
			CmUnitAmountDto dto = new CmUnitAmountDto();
			dto.setKCode     (lblKCode                     );
			dto.setUnitType  (hidUnitType[i]               );
			dto.setUnitAmount(getDoubleParam(txtUnitAmount[i]));
			listUnitAmount.add(dto);
		}
		// r
		cmMidwayEnterDto.setKCode          (lblKCode                       );
		cmMidwayEnterDto.setMidwayType     (pltMidwayType                  );
		cmMidwayEnterDto.setFormerIncome   (getIntParam(txtFormerIncome   ));
		cmMidwayEnterDto.setFormerInsurance(getIntParam(txtFormerInsurance));
		cmMidwayEnterDto.setFormerTax      (getIntParam(txtFormerTax      ));
	}

	/**
	 * o^eك`FbN(Љی)
	 * @param forCmSocInsuranceDto
	 * @param upCmSocInsuranceDto
	 */
	public boolean checkInsuranceDtoFields(
			CmSocInsuranceDto forCmSocInsuranceDto,
			CmSocInsuranceDto upCmSocInsuranceDto
	) throws MospException {
		String[] strForHealthGetDate    = getJpImperialCal(listConf, forCmSocInsuranceDto.getHealthGetDate   ());
		String[] strForHealthLostDate   = getJpImperialCal(listConf, forCmSocInsuranceDto.getHealthLostDate  ());
		String[] strForPensionGetDate   = getJpImperialCal(listConf, forCmSocInsuranceDto.getPensionGetDate  ());
		String[] strForPensionLostDate  = getJpImperialCal(listConf, forCmSocInsuranceDto.getPensionLostDate ());
		String[] strForFundGetDate      = getJpImperialCal(listConf, forCmSocInsuranceDto.getFundGetDate     ());
		String[] strForUnemployGetDate  = getJpImperialCal(listConf, forCmSocInsuranceDto.getUnemployGetDate ());
		String[] strForUnemployLostDate = getJpImperialCal(listConf, forCmSocInsuranceDto.getUnemployLostDate());
		
		String[] strUpHealthGetDate    = getJpImperialCal(listConf, upCmSocInsuranceDto.getHealthGetDate   ());
		String[] strUpHealthLostDate   = getJpImperialCal(listConf, upCmSocInsuranceDto.getHealthLostDate  ());
		String[] strUpPensionGetDate   = getJpImperialCal(listConf, upCmSocInsuranceDto.getPensionGetDate  ());
		String[] strUpPensionLostDate  = getJpImperialCal(listConf, upCmSocInsuranceDto.getPensionLostDate ());
		String[] strUpFundGetDate      = getJpImperialCal(listConf, upCmSocInsuranceDto.getFundGetDate     ());
		String[] strUpUnemployGetDate  = getJpImperialCal(listConf, upCmSocInsuranceDto.getUnemployGetDate ());
		String[] strUpUnemployLostDate = getJpImperialCal(listConf, upCmSocInsuranceDto.getUnemployLostDate());
		
		int retInt = 0;
		// Љی
		retInt += forCmSocInsuranceDto.getKCode            ().equals(upCmSocInsuranceDto.getKCode            ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getPensionType      ().equals(upCmSocInsuranceDto.getPensionType      ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getParttimeType     ().equals(upCmSocInsuranceDto.getParttimeType     ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getEmployeeType     ().equals(upCmSocInsuranceDto.getEmployeeType     ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getCalcInsType      ().equals(upCmSocInsuranceDto.getCalcInsType      ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getNursingInsType   ().equals(upCmSocInsuranceDto.getNursingInsType   ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getCalcUnemployType ().equals(upCmSocInsuranceDto.getCalcUnemployType ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getBonusHealthType  ().equals(upCmSocInsuranceDto.getBonusHealthType  ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getBonusPensionType ().equals(upCmSocInsuranceDto.getBonusPensionType ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getHealthNo         ().equals(upCmSocInsuranceDto.getHealthNo         ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getHealthPayment    () == upCmSocInsuranceDto.getHealthPayment         () ? 0:1;
		retInt += checkDateDtoFields(strForHealthGetDate, strUpHealthGetDate);
		retInt += forCmSocInsuranceDto.getHealthLostType   ().equals(upCmSocInsuranceDto.getHealthLostType   ()) ? 0:1;
		retInt += checkDateDtoFields(strForHealthLostDate, strUpHealthLostDate);
		retInt += forCmSocInsuranceDto.getPensionNo        ().equals(upCmSocInsuranceDto.getPensionNo        ()) ? 0:1;
		retInt += forCmSocInsuranceDto.getPensionPayment   () == upCmSocInsuranceDto.getPensionPayment        () ? 0:1;
		retInt += checkDateDtoFields(strForPensionGetDate, strUpPensionGetDate);
		retInt += forCmSocInsuranceDto.getPensionLostType  ().equals(upCmSocInsuranceDto.getPensionLostType  ()) ? 0:1;
		retInt += checkDateDtoFields(strForPensionLostDate, strUpPensionLostDate);
		retInt += forCmSocInsuranceDto.getFundNo           ().equals(upCmSocInsuranceDto.getFundNo           ()) ? 0:1;
		retInt += checkDateDtoFields(strForFundGetDate, strUpFundGetDate);
		retInt += forCmSocInsuranceDto.getUnemployNo       ().equals(upCmSocInsuranceDto.getUnemployNo       ()) ? 0:1;
		retInt += checkDateDtoFields(strForUnemployGetDate, strUpUnemployGetDate);
		retInt += forCmSocInsuranceDto.getUnemployLostType ().equals(upCmSocInsuranceDto.getUnemployLostType ()) ? 0:1;
		retInt += checkDateDtoFields(strForUnemployLostDate, strUpUnemployLostDate);
		retInt += forCmSocInsuranceDto.getInsExpectedDate  ().equals(upCmSocInsuranceDto.getInsExpectedDate  ()) ? 0:1;
		if (0 < retInt) {
			return true;
		}
		return false;
	}
	
	/**
	 * o^eك`FbN(Z)
	 * @param forCmResidenceTaxDto
	 * @param upCmResidenceTaxDto
	 * @return boolean
	 */
	public boolean checkResidenceTaxDtoFields(
			CmResidenceTaxDto forCmResidenceTaxDto,
			CmResidenceTaxDto upCmResidenceTaxDto
	) {
		int retInt = 0;
		// Z
		retInt += forCmResidenceTaxDto.getKCode           ().equals(upCmResidenceTaxDto.getKCode           	()) ? 0:1;
		retInt += forCmResidenceTaxDto.getPaymentCityCode ().equals(upCmResidenceTaxDto.getPaymentCityCode 	()) ? 0:1;
		retInt += forCmResidenceTaxDto.getSubmitCityCode  ().equals(upCmResidenceTaxDto.getSubmitCityCode  	()) ? 0:1;
		retInt += forCmResidenceTaxDto.getJuneAmount      () == upCmResidenceTaxDto.getJuneAmount      	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getJulyAmount      () == upCmResidenceTaxDto.getJulyAmount        	 () ? 0:1;
		retInt += forCmResidenceTaxDto.getAugustAmount    () == upCmResidenceTaxDto.getAugustAmount    	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getSeptemberAmount () == upCmResidenceTaxDto.getSeptemberAmount 	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getOctoberAmount   () == upCmResidenceTaxDto.getOctoberAmount   	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getNovemberAmount  () == upCmResidenceTaxDto.getNovemberAmount    	 () ? 0:1;
		retInt += forCmResidenceTaxDto.getDecemberAmount  () == upCmResidenceTaxDto.getDecemberAmount  	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getJanuaryAmount   () == upCmResidenceTaxDto.getJanuaryAmount   	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getFebruaryAmount  () == upCmResidenceTaxDto.getFebruaryAmount  	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getMarchAmount     () == upCmResidenceTaxDto.getMarchAmount      	 () ? 0:1;
		retInt += forCmResidenceTaxDto.getAprilAmount     () == upCmResidenceTaxDto.getAprilAmount     	     () ? 0:1;
		retInt += forCmResidenceTaxDto.getMayAmount       () == upCmResidenceTaxDto.getMayAmount        	 () ? 0:1;
		retInt += forCmResidenceTaxDto.getResExpectedDate ().equals(upCmResidenceTaxDto.getResExpectedDate  ()) ? 0:1;
		if (0 < retInt) {
			return true;
		}
		return false;
	}
	
	/**
	 * o^eك`FbN()
	 * @param forCmIncomeTaxDto
	 * @param upCmIncomeTaxDto
	 * @return boolean
	 */
	public boolean checkIncomeTaxDtoFields(
			CmIncomeTaxDto forCmIncomeTaxDto,
			CmIncomeTaxDto upCmIncomeTaxDto
	) {
		int retInt = 0;
		// 
		retInt += forCmIncomeTaxDto.getKCode            ().equals(upCmIncomeTaxDto.getKCode            	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getIncExpectedDate  ().equals(upCmIncomeTaxDto.getIncExpectedDate  	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getIncomeTaxType    ().equals(upCmIncomeTaxDto.getIncomeTaxType    	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getAdjustmentType   ().equals(upCmIncomeTaxDto.getAdjustmentType   	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getSelfWidowType    ().equals(upCmIncomeTaxDto.getSelfWidowType    	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getSelfHandicapType ().equals(upCmIncomeTaxDto.getSelfHandicapType 	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getSelfStudentType  ().equals(upCmIncomeTaxDto.getSelfStudentType  	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getSpouseIntendType ().equals(upCmIncomeTaxDto.getSpouseIntendType 	()) ? 0:1;
		retInt += forCmIncomeTaxDto.getGeneralDependent () == upCmIncomeTaxDto.getGeneralDependent 	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getSpecificDependent() == upCmIncomeTaxDto.getSpecificDependent	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getElderlyDependent () == upCmIncomeTaxDto.getElderlyDependent 	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getLiveWithEldRel   () == upCmIncomeTaxDto.getLiveWithEldRel   	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getLiveWithHandiGe  () == upCmIncomeTaxDto.getLiveWithHandiGe  	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getLiveWithHandiSp  () == upCmIncomeTaxDto.getLiveWithHandiSp  	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getLiveWithHandiEl  () == upCmIncomeTaxDto.getLiveWithHandiEl  	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getLiveWithHandiEr  () == upCmIncomeTaxDto.getLiveWithHandiEr  	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getGeneralHandicap  () == upCmIncomeTaxDto.getGeneralHandicap  	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getDependentCount   () == upCmIncomeTaxDto.getDependentCount   	     () ? 0:1;
		retInt += forCmIncomeTaxDto.getSpecificHandicap () == upCmIncomeTaxDto.getSpecificHandicap 	     () ? 0:1;
		if (0 < retInt) {
			return true;
		}
		return false;
	}
	
	/**
	 * o^eك`FbN(x@)
	 * @param listForPaymentMeans
	 * @param listUpPaymentMeans
	 * @return boolean
	 */
	public boolean checkPaymentMeansDtoFields(
			List<CmPaymentMeansDto> listForPaymentMeans,
			List<CmPaymentMeansDto> listUpPaymentMeans
	) {
		int retInt = 0;
		if (listForPaymentMeans.size() == listUpPaymentMeans.size()) {
			// x@
			for (int i = 0; i < listForPaymentMeans.size(); i++) {
				CmPaymentMeansDto forCmPaymentMeansDto;
				CmPaymentMeansDto upCmPaymentMeansDto;
				forCmPaymentMeansDto = listForPaymentMeans.get(i);
				upCmPaymentMeansDto  = listUpPaymentMeans.get(i);
				retInt += forCmPaymentMeansDto.getCoBankCode    ().equals(upCmPaymentMeansDto.getCoBankCode    	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getPaidBankCode  ().equals(upCmPaymentMeansDto.getPaidBankCode  	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getPaidBranchCode().equals(upCmPaymentMeansDto.getPaidBranchCode	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getAccountType   ().equals(upCmPaymentMeansDto.getAccountType   	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getAccountNo     ().equals(upCmPaymentMeansDto.getAccountNo     	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getHolderName    ().equals(upCmPaymentMeansDto.getHolderName    	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getHolderKana    ().equals(upCmPaymentMeansDto.getHolderKana    	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getPaymentMeans  ().equals(upCmPaymentMeansDto.getPaymentMeans  	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getAmountType    ().equals(upCmPaymentMeansDto.getAmountType    	()) ? 0:1;
				retInt += forCmPaymentMeansDto.getFixedAmount   () == upCmPaymentMeansDto.getFixedAmount   	     () ? 0:1;
				retInt += forCmPaymentMeansDto.getDeleteFlag    () == upCmPaymentMeansDto.getDeleteFlag        	 () ? 0:1;
			}
		} else {
			return true;
		}
		if (0 < retInt) {
			return true;
		}
		return false;
	}

	/**
	 * o^eك`FbN(ʋΎ蓖)
	 * @param listForCommutation
	 * @param listUpCommutation
	 * @return boolean
	 */
	public boolean checkCommutationDtoFields(
			List<CmCommutationDto> listForCommutation,
			List<CmCommutationDto> listUpCommutation
	) {
		int retInt = 0;
		// ʋΎ蓖
		if (listForCommutation.size() == listUpCommutation.size()) {
			for (int i = 0; i < listForCommutation.size(); i++) {
				CmCommutationDto forCmCommutationDto;
				CmCommutationDto upCmCommutationDto;
				forCmCommutationDto = listForCommutation.get(i);
				upCmCommutationDto  = listUpCommutation.get(i);
				retInt += forCmCommutationDto.getPaymentInterval().equals(upCmCommutationDto.getPaymentInterval	()) ? 0:1;
				retInt += forCmCommutationDto.getLumpMonthlyType().equals(upCmCommutationDto.getLumpMonthlyType	()) ? 0:1;
				retInt += forCmCommutationDto.getPayStartMonth  ().equals(upCmCommutationDto.getPayStartMonth  	()) ? 0:1;
				retInt += forCmCommutationDto.getCommuteDistance() == upCmCommutationDto.getCommuteDistance	     () ? 0:1;
				retInt += forCmCommutationDto.getCommuteAmount  () == upCmCommutationDto.getCommuteAmount  	     () ? 0:1;
				retInt += forCmCommutationDto.getCommuteTaxed   () == upCmCommutationDto.getCommuteTaxed   	     () ? 0:1;
				retInt += forCmCommutationDto.getDeleteFlag     () == upCmCommutationDto.getDeleteFlag     	     () ? 0:1;
			}
		} else {
			return true;
		}
		if (0 < retInt) {
			return true;
		}
		return false;
	}
	
	/**
	 * o^eك`FbN(vZ@)
	 * @param listForUnitAmount
	 * @param listUpUnitAmount
	 * @return boolean
	 */
	public boolean checkUnitAmountDtoFields(
			List<CmUnitAmountDto> listForUnitAmount,
			List<CmUnitAmountDto> listUpUnitAmount
	) {
		// rmF(قȂF0قFق̐)
		int retInt = 0;
		// XgTCYɍق獷ق
		if (listForUnitAmount.size() == listUpUnitAmount.size()) {
			for (int i = 0; i < listForUnitAmount.size(); i++) {
				CmUnitAmountDto forCmUnitAmountDto;
				CmUnitAmountDto upCmUnitAmountDto = new CmUnitAmountDto();
				forCmUnitAmountDto = listForUnitAmount.get(i);
				for (int j = 0; j < listUpUnitAmount.size(); j++) {
					upCmUnitAmountDto  = listUpUnitAmount.get(j);
					// P敪vlmF
					if (forCmUnitAmountDto.getUnitType  ().equals(upCmUnitAmountDto.getUnitType  ())) {
						if (forCmUnitAmountDto.getUnitAmount() == upCmUnitAmountDto.getUnitAmount     ()) {
							retInt += 0;
							break;
						}
						// svȂ+1
						retInt += 1;
						break;
					}
					// Ō܂ňvȂꍇ͐VKɓo^P
					if (j == listUpUnitAmount.size() - 1) {
						// svȂ+1
						retInt += 1;
					}
				}
				forCmUnitAmountDto = listForUnitAmount.get(i);
				retInt += forCmUnitAmountDto.getKCode     ().equals(upCmUnitAmountDto.getKCode     ()) ? 0:1;
			}
		} else {
			return true;
		}
		if (0 < retInt) {
			return true;
		}
		return false;
	}

	/**
	 * o^eك`FbN(r)
	 * @param cmMidwayEnterDto
	 * @param upCmMidwayEnterDto
	 * @return boolean
	 */
	public boolean checkCmMidwayEnterDtoFields(
			CmMidwayEnterDto cmMidwayEnterDto,
			CmMidwayEnterDto upCmMidwayEnterDto
	) {
		int retInt = 0;
		// r
//		retInt += cmMidwayEnterDto.getKCode               ().equals(upCmMidwayEnterDto.getKCode       ()) ? 0:1;
		retInt += cmMidwayEnterDto.getMidwayType          ().equals(upCmMidwayEnterDto.getMidwayType  ()) ? 0:1;
		retInt += cmMidwayEnterDto.getFormerIncome        () == upCmMidwayEnterDto.getFormerIncome    ()  ? 0:1;
		retInt += cmMidwayEnterDto.getFormerInsurance     () == upCmMidwayEnterDto.getFormerInsurance ()  ? 0:1;
		retInt += cmMidwayEnterDto.getFormerTax           () == upCmMidwayEnterDto.getFormerTax       ()  ? 0:1;
		if (0 < retInt) {
			return true;
		}
		return false;
	}
	
	/**
	 * Ƒ(ی)AԐݒ
	 */
	public void setFamilyInsSequence() {
		int max = 0;
		for (int i = 0; i < hidFamilyInsSequence.length; i++) {
			if (getIntParam(hidFamilyInsSequence[i]) > max) {
				max = getIntParam(hidFamilyInsSequence[i]);
			}
		}
		for (int i = 0; i < hidFamilyInsSequence.length; i++) {
			if (hidFamilyInsSequence[i] == null || hidFamilyInsSequence[i].equals("")) {
				hidFamilyInsSequence[i] = String.valueOf(++max);
			}
		}
	}
	
	/**
	 * ttB[hDTOr(o^)
	 * @param aryForDate
	 * @param aryUpDate
	 */
	public int checkDateDtoFields (
		String[] aryForDate,
		String[] aryUpDate
	) {
		for (int i = 0; i < aryForDate.length; i++) {
			if (aryForDate[i] == null && aryUpDate[i] == null) {
				return 0;
			} else if (aryForDate[i] == null && aryUpDate[i] != null) {
				return 1;
			}
			if (!aryForDate[i].equals(aryUpDate[i])) {
				return 1;
			}
		}
		return 0;
	}
	
	/**
	 * tB[h
	 */
	@Override
	public void initFields() {
		super.initFields();
		initCalcFields();
	}
	
	/**
	 * tB[h
	 */
	private void initCalcFields() {
		// Ƒ
		countInsFamily       = 0;
		countIncomeFamily    = 0;
		hidFamilyInsSequence = new String[0];
		hidFamilyTaxSequence = new String[0];
		lblFamilyTaxName     = new String[0];
		// Љی
		pltPensionType       = "";
		pltParttimeType      = "";
		pltEmployeeType      = "";
		pltCalcInsType       = "";
		pltNursingInsType    = "";
		pltCalcUnemployType  = "";
		pltBonusHealthType   = "";
		pltBonusPensionType  = "";
		txtHealthNo          = "";
		txtHealthPayment     = "";
		lblHealthPremium     = "";
		lblNursingPremium    = "";
		pltHealthGetEra      = "";
		pltHealthGetYear     = "";
		pltHealthGetMonth    = "";
		pltHealthGetDay      = "";
		pltHealthLostType    = "";
		pltHealthLostEra     = "";
		pltHealthLostYear    = "";
		pltHealthLostMonth   = "";
		pltHealthLostDay     = "";
		txtPensionNo         = "";
		txtPensionPayment    = "";
		lblPensionPremium    = "";
		pltPensionGetEra     = "";
		pltPensionGetYear    = "";
		pltPensionGetMonth   = "";
		pltPensionGetDay     = "";
		pltPensionLostType   = "";
		pltPensionLostEra    = "";
		pltPensionLostYear   = "";
		pltPensionLostMonth  = "";
		pltPensionLostDay    = "";
		txtFundNo            = "";
		txtFundPremium       = "";
		pltFundGetEra        = "";
		pltFundGetYear       = "";
		pltFundGetMonth      = "";
		pltFundGetDay        = "";
		txtUnemployNo        = "";
		pltUnemployGetEra    = "";
		pltUnemployGetYear   = "";
		pltUnemployGetMonth  = "";
		pltUnemployGetDay    = "";
		pltUnemployLostType  = "";
		pltUnemployLostEra   = "";
		pltUnemployLostYear  = "";
		pltUnemployLostMonth = "";
		pltUnemployLostDay   = "";
		// Z
		txtPaymentCityCode   = "";
		txtSubmitCityCode    = "";
		txtJuneAmount        = "";
		txtJulyAmount        = "";
		txtAugustAmount      = "";
		txtSeptemberAmount   = "";
		txtOctoberAmount     = "";
		txtNovemberAmount    = "";
		txtDecemberAmount    = "";
		txtJanuaryAmount     = "";
		txtFebruaryAmount    = "";
		txtMarchAmount       = "";
		txtAprilAmount       = "";
		txtMayAmount         = "";
		// 
		pltIncomeTaxType     = "";
		pltAdjustmentType    = "";
		pltSelfWidowType     = "";
		pltSelfHandicapType  = "";
		pltSelfStudentType   = "";
		pltSpouseIntendType  = "";
		txtGeneralDependent  = "";
		txtSpecificDependent = "";
		txtElderlyDependent  = "";
		txtLiveWithEldRel    = "";
		txtLiveWithHandiGe   = "";
		txtLiveWithHandiSp   = "";
		txtLiveWithHandiEl   = "";
		txtLiveWithHandiEr   = "";
		txtGeneralHandicap   = "";
		txtSpecificHandicap  = "";
		hidDependentCount    = "";
		// ʋΎ蓖
		pltPaymentInterval   = new String[PayrollConst.COMMUTATION_COUNT  ];
		pltLumpMonthlyType   = new String[PayrollConst.COMMUTATION_COUNT  ];
		pltPayStartMonth     = new String[PayrollConst.COMMUTATION_COUNT  ];
		txtCommuteDistance   = new String[PayrollConst.COMMUTATION_COUNT  ];
		txtCommuteAmount     = new String[PayrollConst.COMMUTATION_COUNT  ];
		txtCommuteTaxed      = new String[PayrollConst.COMMUTATION_COUNT  ];
		// x@
		pltCoBankCode        = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		txtPaidBankCode      = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		txtPaidBranchCode    = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		lblPaidBankName      = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		lblPaidBranchName    = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		pltAccountType       = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		txtAccountNo         = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		txtHolderName        = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		txtHolderKana        = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		pltPaymentMeans      = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		pltAmountType        = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		txtFixedAmount       = new String[PayrollConst.PAYMENT_MEANS_COUNT];
		// vZP
		countUnitType        = 0;
		hidUnitType          = new String[0];
		lblUnitName          = new String[0];
		txtUnitAmount        = new String[0];
	}
	
	/**
	 * Ƒ()S󔒊mF
	 * @param idx CfbNX
	 * @return mF(trueFS󔒁AfalseF͗L)
	 */
/*	private boolean isFamilyTaxAllBlank(int idx) {
		if (
				(pltLiveWithType [idx] == null || pltLiveWithType [idx].equals("")) &&
				(pltSpouseType   [idx] == null || pltSpouseType   [idx].equals("")) &&
				(pltDependentType[idx] == null || pltDependentType[idx].equals("")) &&
				(pltHandicapType [idx] == null || pltHandicapType [idx].equals(""))
		) {
			return true;
		}
		return false;
	}
*/	
	/**
	 * x@S󔒊mF
	 * @param idx CfbNX
	 * @return mF(trueFS󔒁AfalseF͗L)
	 */
	private boolean isPaymentMeansAllBlank(int idx) {
		if (
				(pltCoBankCode    [idx] == null || pltCoBankCode    [idx].equals("")) &&
				(txtPaidBankCode  [idx] == null || txtPaidBankCode  [idx].equals("")) &&
				(txtPaidBranchCode[idx] == null || txtPaidBranchCode[idx].equals("")) &&
				(pltAccountType   [idx] == null || pltAccountType   [idx].equals("")) &&
				(txtAccountNo     [idx] == null || txtAccountNo     [idx].equals("")) &&
				(txtHolderName    [idx] == null || txtHolderName    [idx].equals("")) &&
				(txtHolderKana    [idx] == null || txtHolderKana    [idx].equals("")) &&
				(pltPaymentMeans  [idx] == null || pltPaymentMeans  [idx].equals("")) &&
				(pltAmountType    [idx] == null || pltAmountType    [idx].equals("")) &&
				(txtFixedAmount   [idx] == null || txtFixedAmount   [idx].equals("") || txtFixedAmount[idx].equals("0"))
		) {
			return true;
		}
		return false;
	}
	
	/**
	 * ʋΎ蓖S󔒊mF
	 * @param idx CfbNX
	 * @return mF(trueFS󔒁AfalseF͗L)
	 */
	private boolean isCommutationAllBlank(int idx) {
		if (
				(pltPaymentInterval[idx] == null || pltPaymentInterval[idx].equals("")) &&
				(pltLumpMonthlyType[idx] == null || pltLumpMonthlyType[idx].equals("")) &&
				(pltPayStartMonth  [idx] == null || pltPayStartMonth  [idx].equals("")) &&
				(txtCommuteDistance[idx] == null || txtCommuteDistance[idx].equals("")) &&
				(txtCommuteAmount  [idx] == null || txtCommuteAmount  [idx].equals("")) &&
				(txtCommuteTaxed   [idx] == null || txtCommuteTaxed   [idx].equals(""))
		) {
			return true;
		}
		return false;
	}
	
	/**
	 * O[t^
	 * @param targetNo@@Ώە
	 * @param targetLength@ڒ
	 * @return
	 */
	private String setBeforeZero(String targetNo, int targetLength) {
		// ݒ菀
		String retString = "";
		// Ώۂ󂶂ȂΑO[ݒ
		if (!targetNo.equals("")) {
			retString = LegalReportUtility.getZero(targetNo, targetLength);
		}
		return retString;
		
	}
	
	/**
	 * Z@JSݒ
	 * @param sb
	 */
	protected void setFinanceData(StringBuffer sb) {
		sb.append("</script>");
		sb.append("<script type=\"text/javascript\" src=\"..");
		sb.append(PayrollConst.JS_FINANCE);
		sb.append("\"></script>");
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		// sJSݒ
		setFinanceData(sb);
		return sb.toString();
	}
	
	// ANZT\bh
	// Ƒ()
	public String getEscHidFamilyInsSequence(int i) { return escapeHTML(hidFamilyInsSequence[i]); }
	public String getEscHidFamilyTaxSequence(int i) { return escapeHTML(hidFamilyTaxSequence[i]); }
	public String getEscLblFamilyTaxName (int i) { return escapeHTML(lblFamilyTaxName [i]); }
	
	public int getCountInsFamily   () { return countInsFamily   ; }
	public int getCountIncomeFamily() { return countIncomeFamily; }
	
	// Љی
	public String getPltPensionType      () { return pltPensionType      ; }
	public String getPltParttimeType     () { return pltParttimeType     ; }
	public String getPltEmployeeType     () { return pltEmployeeType     ; }
	public String getPltCalcInsType      () { return pltCalcInsType      ; }
	public String getPltNursingInsType   () { return pltNursingInsType   ; }
	public String getPltCalcUnemployType () { return pltCalcUnemployType ; }
	public String getPltBonusHealthType  () { return pltBonusHealthType  ; }
	public String getPltBonusPensionType () { return pltBonusPensionType ; }
	public String getTxtHealthNo         () { return txtHealthNo         ; }
	public String getTxtHealthPayment    () { return txtHealthPayment    ; }
	public String getLblHealthPremium    () { return lblHealthPremium    ; }
	public String getLblNursingPremium   () { return lblNursingPremium   ; }
	public String getPltHealthGetEra     () { return pltHealthGetEra     ; }
	public String getPltHealthGetYear    () { return pltHealthGetYear    ; }
	public String getPltHealthGetMonth   () { return pltHealthGetMonth   ; }
	public String getPltHealthGetDay     () { return pltHealthGetDay     ; }
	public String getPltHealthLostType   () { return pltHealthLostType   ; }
	public String getPltHealthLostEra    () { return pltHealthLostEra    ; }
	public String getPltHealthLostYear   () { return pltHealthLostYear   ; }
	public String getPltHealthLostMonth  () { return pltHealthLostMonth  ; }
	public String getPltHealthLostDay    () { return pltHealthLostDay    ; }
	public String getTxtPensionNo        () { return txtPensionNo        ; }
	public String getTxtPensionPayment   () { return txtPensionPayment   ; }
	public String getLblPensionPremium   () { return lblPensionPremium   ; }
	public String getPltPensionGetEra    () { return pltPensionGetEra    ; }
	public String getPltPensionGetYear   () { return pltPensionGetYear   ; }
	public String getPltPensionGetMonth  () { return pltPensionGetMonth  ; }
	public String getPltPensionGetDay    () { return pltPensionGetDay    ; }
	public String getPltPensionLostType  () { return pltPensionLostType  ; }
	public String getPltPensionLostEra   () { return pltPensionLostEra   ; }
	public String getPltPensionLostYear  () { return pltPensionLostYear  ; }
	public String getPltPensionLostMonth () { return pltPensionLostMonth ; }
	public String getPltPensionLostDay   () { return pltPensionLostDay   ; }
	public String getTxtFundNo           () { return txtFundNo           ; }
	public String getTxtFundPremium      () { return txtFundPremium      ; }
	public String getPltFundGetEra       () { return pltFundGetEra       ; }
	public String getPltFundGetYear      () { return pltFundGetYear      ; }
	public String getPltFundGetMonth     () { return pltFundGetMonth     ; }
	public String getPltFundGetDay       () { return pltFundGetDay       ; }
	public String getTxtUnemployNo       () { return txtUnemployNo       ; }
	public String getPltUnemployGetEra   () { return pltUnemployGetEra   ; }
	public String getPltUnemployGetYear  () { return pltUnemployGetYear  ; }
	public String getPltUnemployGetMonth () { return pltUnemployGetMonth ; }
	public String getPltUnemployGetDay   () { return pltUnemployGetDay   ; }
	public String getPltUnemployLostType () { return pltUnemployLostType ; }
	public String getPltUnemployLostEra  () { return pltUnemployLostEra  ; }
	public String getPltUnemployLostYear () { return pltUnemployLostYear ; }
	public String getPltUnemployLostMonth() { return pltUnemployLostMonth; }
	public String getPltUnemployLostDay  () { return pltUnemployLostDay  ; }
	public String getEscTxtHealthNo         () { return escapeHTML(txtHealthNo         ); }
	public String getEscTxtHealthPayment    () { return escapeHTML(txtHealthPayment    ); }
	public String getEscLblHealthPremium    () { return escapeHTML(lblHealthPremium    ); }
	public String getEscLblNursingPremium   () { return escapeHTML(lblNursingPremium   ); }
	public String getEscTxtPensionNo        () { return escapeHTML(txtPensionNo        ); }
	public String getEscTxtPensionPayment   () { return escapeHTML(txtPensionPayment   ); }
	public String getEscLblPensionPremium   () { return escapeHTML(lblPensionPremium   ); }
	public String getEscTxtFundNo           () { return escapeHTML(txtFundNo           ); }
	public String getEscTxtFundPremium      () { return escapeHTML(txtFundPremium      ); }
	public String getEscTxtUnemployNo       () { return escapeHTML(txtUnemployNo       ); }
	
	// Ƒ(ی)
	public String getPltInsFamily        (int i) { return pltInsFamily        [i]; }
	public String getPltHeaQualifiedEra  (int i) { return pltHeaQualifiedEra  [i]; }
	public String getPltHeaQualifiedYear (int i) { return pltHeaQualifiedYear [i]; }
	public String getPltHeaQualifiedMonth(int i) { return pltHeaQualifiedMonth[i]; }
	public String getPltHeaQualifiedDay  (int i) { return pltHeaQualifiedDay  [i]; }
	public String getPltDisqualifiedEra  (int i) { return pltDisqualifiedEra  [i]; }
	public String getPltDisqualifiedYear (int i) { return pltDisqualifiedYear [i]; }
	public String getPltDisqualifiedMonth(int i) { return pltDisqualifiedMonth[i]; }
	public String getPltDisqualifiedDay  (int i) { return pltDisqualifiedDay  [i]; }
	public String getTxtFamilyPensionNo  (int i) { return txtFamilyPensionNo  [i]; }
	public String getTxtFamilyInsRemarks (int i) { return txtFamilyInsRemarks [i]; }
	public String getEscTxtFamilyPensionNo (int i) { return escapeHTML(txtFamilyPensionNo [i]); }
	public String getEscTxtFamilyInsRemarks(int i) { return escapeHTML(txtFamilyInsRemarks[i]); }
	
	// Z
	public String getTxtPaymentCityCode  () { return txtPaymentCityCode  ; }
	public String getTxtSubmitCityCode   () { return txtSubmitCityCode   ; }
	public String getTxtJuneAmount       () { return txtJuneAmount       ; }
	public String getTxtJulyAmount       () { return txtJulyAmount       ; }
	public String getTxtAugustAmount     () { return txtAugustAmount     ; }
	public String getTxtSeptemberAmount  () { return txtSeptemberAmount  ; }
	public String getTxtOctoberAmount    () { return txtOctoberAmount    ; }
	public String getTxtNovemberAmount   () { return txtNovemberAmount   ; }
	public String getTxtDecemberAmount   () { return txtDecemberAmount   ; }
	public String getTxtJanuaryAmount    () { return txtJanuaryAmount    ; }
	public String getTxtFebruaryAmount   () { return txtFebruaryAmount   ; }
	public String getTxtMarchAmount      () { return txtMarchAmount      ; }
	public String getTxtAprilAmount      () { return txtAprilAmount      ; }
	public String getTxtMayAmount        () { return txtMayAmount        ; }
	public String getEscTxtPaymentCityCode  () { return  escapeHTML(txtPaymentCityCode  ); }
	public String getEscTxtSubmitCityCode   () { return  escapeHTML(txtSubmitCityCode   ); }
	public String getEscTxtJuneAmount       () { return  escapeHTML(txtJuneAmount       ); }
	public String getEscTxtJulyAmount       () { return  escapeHTML(txtJulyAmount       ); }
	public String getEscTxtAugustAmount     () { return  escapeHTML(txtAugustAmount     ); }
	public String getEscTxtSeptemberAmount  () { return  escapeHTML(txtSeptemberAmount  ); }
	public String getEscTxtOctoberAmount    () { return  escapeHTML(txtOctoberAmount    ); }
	public String getEscTxtNovemberAmount   () { return  escapeHTML(txtNovemberAmount   ); }
	public String getEscTxtDecemberAmount   () { return  escapeHTML(txtDecemberAmount   ); }
	public String getEscTxtJanuaryAmount    () { return  escapeHTML(txtJanuaryAmount    ); }
	public String getEscTxtFebruaryAmount   () { return  escapeHTML(txtFebruaryAmount   ); }
	public String getEscTxtMarchAmount      () { return  escapeHTML(txtMarchAmount      ); }
	public String getEscTxtAprilAmount      () { return  escapeHTML(txtAprilAmount      ); }
	public String getEscTxtMayAmount        () { return  escapeHTML(txtMayAmount        ); }
	
	// 
	public String getPltIncomeTaxType    () { return pltIncomeTaxType    ; }
	public String getPltAdjustmentType   () { return pltAdjustmentType   ; }
	public String getPltSelfWidowType    () { return pltSelfWidowType    ; }
	public String getPltSelfHandicapType () { return pltSelfHandicapType ; }
	public String getPltSelfStudentType  () { return pltSelfStudentType  ; }
	public String getPltSpouseIntendType () { return pltSpouseIntendType ; }
	public String getTxtGeneralDependent () { return txtGeneralDependent ; }
	public String getTxtSpecificDependent() { return txtSpecificDependent; }
	public String getTxtElderlyDependent () { return txtElderlyDependent ; }
	public String getTxtLiveWithEldRel   () { return txtLiveWithEldRel   ; }
	public String getTxtLiveWithHandiGe  () { return txtLiveWithHandiGe  ; }
	public String getTxtLiveWithHandiSp  () { return txtLiveWithHandiSp  ; }
	public String getTxtLiveWithHandiEl  () { return txtLiveWithHandiEl  ; }
	public String getTxtLiveWithHandiEr  () { return txtLiveWithHandiEr  ; }
	public String getTxtGeneralHandicap  () { return txtGeneralHandicap  ; }
	public String getTxtSpecificHandicap () { return txtSpecificHandicap ; }
	public String getEscTxtGeneralDependent () { return  escapeHTML(txtGeneralDependent ); }
	public String getEscTxtSpecificDependent() { return  escapeHTML(txtSpecificDependent); }
	public String getEscTxtElderlyDependent () { return  escapeHTML(txtElderlyDependent ); }
	public String getEscTxtLiveWithEldRel   () { return  escapeHTML(txtLiveWithEldRel   ); }
	public String getEscTxtLiveWithHandiGe  () { return  escapeHTML(txtLiveWithHandiGe  ); }
	public String getEscTxtLiveWithHandiSp  () { return  escapeHTML(txtLiveWithHandiSp  ); }
	public String getEscTxtLiveWithHandiEl  () { return  escapeHTML(txtLiveWithHandiEl  ); }
	public String getEscTxtLiveWithHandiEr  () { return  escapeHTML(txtLiveWithHandiEr  ); }
	public String getEscTxtGeneralHandicap  () { return  escapeHTML(txtGeneralHandicap  ); }
	public String getEscTxtSpecificHandicap () { return  escapeHTML(txtSpecificHandicap ); }
	public String getEscHidDependentCount   () { return  escapeHTML(hidDependentCount   ); }
	
	// Ƒ()
	public String getPltLiveWithType     (int i) { return pltLiveWithType     [i]; }
	public String getPltSpouseType       (int i) { return pltSpouseType       [i]; }
	public String getPltDependentType    (int i) { return pltDependentType    [i]; }
	public String getPltHandicapType     (int i) { return pltHandicapType     [i]; }
	
	// ʋΎ蓖
	public String getPltPaymentInterval(int i) { return pltPaymentInterval[i]; }
	public String getPltLumpMonthlyType(int i) { return pltLumpMonthlyType[i]; }
	public String getPltPayStartMonth  (int i) { return pltPayStartMonth  [i]; }
	public String getTxtCommuteDistance(int i) { return txtCommuteDistance[i]; }
	public String getTxtCommuteAmount  (int i) { return txtCommuteAmount  [i]; }
	public String getTxtCommuteTaxed   (int i) { return txtCommuteTaxed   [i]; }
	public String getEscTxtCommuteDistance(int i) { return escapeHTML(txtCommuteDistance[i]); }
	public String getEscTxtCommuteAmount  (int i) { return escapeHTML(txtCommuteAmount  [i]); }
	public String getEscTxtCommuteTaxed   (int i) { return escapeHTML(txtCommuteTaxed   [i]); }
	
	// x@
	public String getPltCoBankCode    (int i) { return pltCoBankCode    [i]; }
	public String getTxtPaidBankCode  (int i) { return txtPaidBankCode  [i]; }
	public String getTxtPaidBranchCode(int i) { return txtPaidBranchCode[i]; }
	public String getLblPaidBankName  (int i) { return lblPaidBankName  [i]; }
	public String getLblPaidBranchName(int i) { return lblPaidBranchName[i]; }
	public String getPltAccountType   (int i) { return pltAccountType   [i]; }
	public String getTxtAccountNo     (int i) { return txtAccountNo     [i]; }
	public String getTxtHolderName    (int i) { return txtHolderName    [i]; }
	public String getTxtHolderKana    (int i) { return txtHolderKana    [i]; }
	public String getPltPaymentMeans  (int i) { return pltPaymentMeans  [i]; }
	public String getPltAmountType    (int i) { return pltAmountType    [i]; }
	public String getTxtFixedAmount   (int i) { return txtFixedAmount   [i]; }
	public String getEscTxtPaidBankCode  (int i) { return escapeHTML(txtPaidBankCode  [i]); }
	public String getEscTxtPaidBranchCode(int i) { return escapeHTML(txtPaidBranchCode[i]); }
	public String getEscLblPaidBankName  (int i) { return escapeHTML(lblPaidBankName  [i]); }
	public String getEscLblPaidBranchName(int i) { return escapeHTML(lblPaidBranchName[i]); }
	public String getEscTxtAccountNo     (int i) { return escapeHTML(txtAccountNo     [i]); }
	public String getEscTxtHolderName    (int i) { return escapeHTML(txtHolderName    [i]); }
	public String getEscTxtHolderKana    (int i) { return escapeHTML(txtHolderKana    [i]); }
	public String getEscTxtFixedAmount   (int i) { return escapeHTML(txtFixedAmount   [i]); }
	
	// vZP
	public int    getCountUnitType  ()      { return countUnitType ; }
	public String getHidUnitType    (int i) { return hidUnitType  [i]; }
	public String getLblUnitName    (int i) { return lblUnitName  [i]; }
	public String getTxtUnitAmount  (int i) { return txtUnitAmount[i]; }
	public String getEscHidUnitType    (int i) { return escapeHTML(hidUnitType  [i]); }
	public String getEscLblUnitName    (int i) { return escapeHTML(lblUnitName  [i]); }
	public String getEscTxtUnitAmount  (int i) { return escapeHTML(txtUnitAmount[i]); }
	
	// r
	public String getPltMidwayType     () { return pltMidwayType       ; }
	public String getTxtFormerIncome   () { return txtFormerIncome     ; }
	public String getTxtFormerInsurance() { return txtFormerInsurance  ; }
	public String getTxtFormerTax      () { return txtFormerTax        ; }
	public String getEscTxtFormerIncome   () { return escapeHTML(txtFormerIncome     ); }
	public String getEscTxtFormerInsurance() { return escapeHTML(txtFormerInsurance  ); }
	public String getEscTxtFormerTax      () { return escapeHTML(txtFormerTax        ); }
	
	// ̑
	public String getEscHidCalcCurrentTab () { return escapeHTML(hidCalcCurrentTab   ); }
	public void setHidCalcCurrentTab(String hidCalcCurrentTab) { this.hidCalcCurrentTab = hidCalcCurrentTab; }
	
	public Date   getInsExpectedDate () { return getDateField(insExpectedDate); }
	public Date   getFinExpectedDate () { return getDateField(finExpectedDate); }
	public Date   getIncExpectedDate () { return getDateField(incExpectedDate); }
	
	public void setMode(int mode) { this.mode = mode; }
	public int getMode() {return mode; }
	



}
