/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dao.MosPUserDao;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.system.dao.MSyozokuDao;

public class MKihonDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE	= "M_KIHON";
	public static final String KEY_1	= "KCODE";	//ЈR[h

	// 
	public static final String COL_KCODE  	= "KCODE";		//ЈR[h
	public static final String COL_SIMEI  	= "SIMEI";		//
	public static final String COL_FURIGANA  	= "FURIGANA";	//ӂ肪
	public static final String COL_SCODE  	= "SCODE";		//R[h
	public static final String COL_YCODE  	= "YCODE";		//ER[h
	public static final String COL_TOKYU  	= "TOKYU";		//
	public static final String COL_JCODE  	= "JCODE";		//ƏR[h
	public static final String COL_NYDATE 	= "NYDATE";		//Г
	public static final String COL_TSDATE  	= "TSDATE";		//ސE
	public static final String COL_KNKUBUN 	= "KNKUBUN";	//xސE敪
	public static final String COL_KYKUBUN  	= "KYKUBUN";	//^敪
	public static final String COL_TXKUBUN  	= "TXKUBUN";	//ŋ敪
	public static final String COL_TXKUBUNX  	= "TXKUBUNX";	//̑ŋ敪
	public static final String COL_KMKUBUN  	= "KMKUBUN";	//g敪
	public static final String COL_PTKUBUN  	= "PTKUBUN";	//p[g敪
	public static final String COL_SHKUBUN  	= "SHKUBUN";	//x敪
	public static final String COL_SIWAKECD  	= "SIWAKECD";	//dWvR[h
	public static final String COL_HAIGUSYA  	= "HAIGUSYA";	//}{z
	public static final String COL_FUYOSU  	= "FUYOSU";		//}{Ƒ
	public static final String COL_YUKYU  	= "YUKYU";		//Lc
	public static final String COL_NENREI  	= "NENREI";		//N
	public static final String COL_KINZOKU  	= "KINZOKU";	//ΑN
	public static final String COL_KENPONO  	= "KENPONO";	//۔ԍ
	public static final String COL_KOHONO  	= "KOHONO";		//۔ԍ
	public static final String COL_KUSER  	= "KUSER";		//[U
	public static final String COL_PASSW  	= "PASSW";		//pX[h
	public static final String COL_EMAIL  	= "EMAIL";		//email
	public static final String COL_NINSYO  	= "NINSYO";		//F؎
	public static final String COL_DATALVL  	= "DATALVL";	//f[^x
	public static final String COL_PROGLEVEL	= "PROGLEVEL";	//vOgp

	/**
	 * RXgN^
	 */
	public MKihonDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	protected List<MKihonDto> mappingAll() throws SQLException {
		List<MKihonDto> all = new ArrayList<MKihonDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_kihonDto m_kihonR[h
	 * @throws SQLException
	 */
	private MKihonDto mapping() throws SQLException {
		MKihonDto dto = new MKihonDto();
		dto.setKCode		(rs.getString (COL_KCODE));		//ЈR[h
		dto.setSimei 		(rs.getString (COL_SIMEI));		//
		dto.setFurigana 	(rs.getString (COL_FURIGANA));	//ӂ肪
		dto.setSCode 		(rs.getString (COL_SCODE));		//R[h
		dto.setYCode 		(rs.getString (COL_YCODE));		//ER[h
		dto.setTokyu 		(rs.getString (COL_TOKYU));		//
		dto.setJCode 		(rs.getString (COL_JCODE));		//ƏR[h
		dto.setNyDate 		(rs.getInt    (COL_NYDATE));	//Г
		dto.setTsDate 		(rs.getInt    (COL_TSDATE));	//ސE
		dto.setKnKubun 		(rs.getString (COL_KNKUBUN));	//xސE敪
		dto.setKyKubun 		(rs.getString (COL_KYKUBUN));	//^敪
		dto.setTxKubun 		(rs.getString (COL_TXKUBUN));	//ŋ敪
		dto.setTxKubunx 	(rs.getString (COL_TXKUBUNX));	//̑ŋ敪
		dto.setKmKubun 		(rs.getString (COL_KMKUBUN));	//g敪
		dto.setPtKubun 		(rs.getString (COL_PTKUBUN));	//p[g敪
		dto.setShKubun 		(rs.getString (COL_SHKUBUN));	//x敪
		dto.setSiwakeCd 	(rs.getString (COL_SIWAKECD));	//dWvR[h
		dto.setHaigusya 	(rs.getString (COL_HAIGUSYA));	//}{z
		dto.setFuyosu 		(rs.getInt    (COL_FUYOSU));	//}{Ƒ
		dto.setYukyu 		(rs.getDouble (COL_YUKYU));		//Lc
		dto.setNenrei 		(rs.getInt    (COL_NENREI));	//N
		dto.setKinzoku 		(rs.getInt    (COL_KINZOKU));	//ΑN
		dto.setKenpoNo 		(rs.getString (COL_KENPONO));	//۔ԍ
		dto.setKohoNo 		(rs.getString (COL_KOHONO));	//۔ԍ
		dto.setKUser 		(rs.getString (COL_KUSER));		//[U
		dto.setPassw 		(rs.getString (COL_PASSW));		//pX[h
		dto.setEmail 		(rs.getString (COL_EMAIL));		//email
		dto.setNinsyo 		(rs.getString (COL_NINSYO));	//F؎
		dto.setDataLvl 		(rs.getInt    (COL_DATALVL));	//f[^x
		dto.setProgLevel 	(rs.getInt    (COL_PROGLEVEL));	//vOgp
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<MKihonDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kihonDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKihonDto findForKey(
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kihonDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKihonDto findForUpdate(
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kcode  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param simei
	 * @param sCode
	 * @param selfKCode
	 * @param dataLevel
	 * @param startDate
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findForCondition(
			String	kcode,
			String	simei,
			String	sCode,
			String	selfJCode,
			String 	selfKCode,
			int		dataLevel,
			int		startDate,
			int		endDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(" ( ");
		sb.append(		COL_KCODE + " LIKE ? ");
		sb.append(		" AND ");		
		sb.append(		COL_SIMEI + " LIKE ? ");
		sb.append(		" AND ");
		// Ə
		sb.append(		COL_JCODE + " = ? ");
		// I
		if (!sCode.equals("")) {
			sb.append(	" AND ");
			sb.append(	COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		}
		sb.append(		" AND ");
		// f[^xȉ̐l
		sb.append(		COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(		" AND ");
		// WvJnɍݐEĂl		
		//sb.append(getSearchEmployeeStatement());
		sb.append(		getSearchEmployeeStatementPeriod(false));
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++		, kcode + "%");
			setParam(index++		, "%" + simei + "%");
			// Ə
			setParam(index++		, selfJCode);
			// 
			if (!sCode.equals("")) {
				setParam(index++	, sCode);
			}
			// f[^x
			setParam(index++		, dataLevel);
			// WvJn
			setParam(index++		, startDate);
			setParam(index++		, endDate);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param sCode			R[h
	 * @param selfJCode		[UƏR[h
	 * @param selfKCode		[UЈR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findForCondition(
			String	sCode,
			String	selfJCode,
			String 	selfKCode,
			int		dataLevel,
			int		startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// 
		sb.append(COL_KCODE + " = ? ");
		sb.append(" OR ");
		sb.append(" ( ");
		// Ə
		sb.append(		COL_JCODE + " = ? ");
		sb.append(		" AND ");
		sb.append(		COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		sb.append(		" AND ");
		// f[^xȉ̐l
		sb.append(		COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(		" AND ");
		// WvJnɍݐEĂl		
		sb.append(		getSearchEmployeeStatement());
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// 
			setParam(index++	, selfKCode);
			// Ə
			setParam(index++	, selfJCode);
			// 
			setParam(index++	, sCode);
			// f[^x
			setParam(index++	, dataLevel);
			// WvJn
			setParam(index++	, startDate);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param tsdate t
	 * @param kcode ЈR[h
	 * @param kname Ј
	 * @param scode R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findForCondition(
			int		tsdate,
			String	kcode,
			String	kname,
			String	scode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(getSearchEmployeeStatement());
		if (!kcode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" LIKE ? ");
		}
		if (!kname.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SIMEI);
			sb.append(" LIKE ? ");
		}
		if (!scode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE);
			sb.append(" IN( ");
			sb.append(MSyozokuDao.getSectionQuery());
			sb.append(") ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tsdate);
			if (!kcode.equals("")) {
				setParam(index++, kcode + "%");
			}
			if (!kname.equals("")) {
				setParam(index++, "%" + kname + "%");
			}
			if (!scode.equals("")) {
				setParam(index++, scode);
			}
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾(R[h)
	 * @param stationCode R[h
	 * @param tsdate ގДN
	 * @param nydate ДN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findForSection(
			String stationCode,
			int tsdate,
			int nydate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SCODE + " IN (");
		sb.append(MSyozokuDao.getSectionQuery());
		sb.append(") ");
		sb.append("AND ");
		//sb.append(getSearchEmployeeStatement());
		sb.append(getSearchEmployeeStatementPeriod(true));
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForPosition());
			setParam(index++, stationCode	);
			setParam(index++, tsdate		);
			setParam(index++, nydate		);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾(l}X^ێ-Јꗗp)
	 * @param kCode          ЈR[h
	 * @param simei          Ј
	 * @param officeCode    ƏR[h
	 * @param sectionCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<MKihonDto> findForHumanList(
			String kCode,
			String simei,
			String officeCode,
			String sectionCode,
			String positionCode,
			String retirementFlag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_KCODE + " LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_SIMEI + " LIKE ? ");
		if (officeCode != null && !officeCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_JCODE + " =  ? ");
		}
		if (sectionCode != null && !sectionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE + " =  ? ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_YCODE + " = ? ");
		}
		if (retirementFlag != null && retirementFlag.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_OFF))) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN + " = '" + CommonConst.RETIREMENT_FLAG_OFF + "' ");
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE))) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN + " = '" + CommonConst.RETIREMENT_FLAG_LEAVE + "' ");
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_ON))) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN + " = '" + CommonConst.RETIREMENT_FLAG_ON + "' ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode + "%");
			setParam(index++, "%" + simei + "%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			// s
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾(R[h)
	 * @param authCode1 R[h1
	 * @param authCode2 R[h2
	 * @param date N
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findForAuth(
			String authCode1,
			String authCode2,
			int date
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_KCODE + " IN ( " + MosPUserDao.getSearchApprovalSubQuery() + " ) ");
		sb.append(" AND ");
		sb.append(getSearchEmployeeStatement());
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, authCode1	);
			setParam(index++, authCode2	);
			setParam(index++, date		);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param sCode			R[h
	 * @param selfKCode		[UЈR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findForApproval(
			String	sCode,
			String	selfJCode,
			String 	selfKCode,
			int		dataLevel,
			int		startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// O
		sb.append(COL_KCODE + " != ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		// Ə
		sb.append(		COL_JCODE + " = ? ");
		// I
		sb.append(		" AND ");
		sb.append(		COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		sb.append(		" AND ");
		// f[^xȉ̐l
		sb.append(		COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(		" AND ");
		// WvJnɍݐEĂl		
		sb.append(		getSearchEmployeeStatement());
		sb.append(") ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// 
			setParam(index++	, selfKCode);
			// Ə
			setParam(index++	, selfJCode);
			// 
			setParam(index++	, sCode);
			// f[^x
			setParam(index++	, dataLevel);
			// WvJn
			setParam(index++	, startDate);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kCode			ЈR[h
	 * @param sCode			R[h
	 * @param selfJCode		[UƏR[h
	 * @param selfKCode		[UЈR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKihonDto findForApproval(
			String  kCode,
			String	sCode,
			String	selfJCode,
			String 	selfKCode,
			int		dataLevel,
			int		startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// Ώێ
		sb.append(COL_KCODE + " = ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		// Ə
		sb.append(		COL_JCODE + " = ? ");
		// I
		sb.append(		" AND ");
		sb.append(		COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		sb.append(		" AND ");
		// f[^xȉ̐l
		sb.append(		COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(		" AND ");
		// WvJnɍݐEĂl		
		sb.append(		getSearchEmployeeStatement());
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// Ώێ
			setParam(index++	, kCode);
			// Ə
			setParam(index++	, selfJCode);
			// 
			setParam(index++	, sCode);
			// f[^x
			setParam(index++	, dataLevel);
			// WvJn
			setParam(index++	, startDate);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kCode 		ЈR[h
	 * @param selfJCode		[UƏR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKihonDto findForApprovalKCode(
			String  kCode,
			String	selfJCode,
			int		dataLevel,
			int		startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// Ώێ
		sb.append(COL_KCODE + " = ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		// Ə
		sb.append(		COL_JCODE + " = ? ");
		sb.append(		" AND ");
		// f[^xȉ̐l
		sb.append(		COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(		" AND ");
		// WvJnɍݐEĂl		
		sb.append(		getSearchEmployeeStatement());
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// Ώێ
			setParam(index++	, kCode);
			// Ə
			setParam(index++	, selfJCode);
			// f[^x
			setParam(index++	, dataLevel);
			// WvJn
			setParam(index++	, startDate);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param tsdate t
	 * @param kcode ЈR[h
	 * @param kname Ј
	 * @param scode R[h
	 * @param limit 
	 * @param offset
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> findForEmployeeWithLimit(
			int		tsdate,
			String	kcode,
			String	kname,
			String	scode,
			int		limit,
			int		offset
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(getSearchEmployeeStatement());
		if (!kcode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" LIKE ? ");
		}
		if (!kname.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SIMEI);
			sb.append(" LIKE ? ");
		}
		if (!scode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE);
			sb.append(" IN( ");
			sb.append(MSyozokuDao.getSectionQuery());
			sb.append(") ");
		}
		sb.append(" ORDER BY ");
		sb.append(KEY_1);
		sb.append(" LIMIT ? OFFSET ?");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, tsdate);
			if (!kcode.equals("")) {
				setParam(index++, kcode + "%");
			}
			if (!kname.equals("")) {
				setParam(index++, "%" + kname + "%");
			}
			if (!scode.equals("")) {
				setParam(index++, scode);
			}
			setParam(index++, limit);
			setParam(index++, offset);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * countl擾
	 * @param tsdate t
	 * @param kcode ЈR[h
	 * @param kname Ј
	 * @param scode R[h
	 * @return count
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public int findForCount(
			int		tsdate,
			String	kcode,
			String	kname,
			String	scode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		int count = 0;
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT COUNT(");
		sb.append(COL_KCODE);
		sb.append(") FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(getSearchEmployeeStatement());
		if (!kcode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" LIKE ? ");
		}
		if (!kname.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SIMEI);
			sb.append(" LIKE ? ");
		}
		if (!scode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE);
			sb.append(" IN( ");
			sb.append(MSyozokuDao.getSectionQuery());
			sb.append(") ");
		}
		try {
			prepareStatement(sb.toString());
			setParam(index++, tsdate);
			if (!kcode.equals("")) {
				setParam(index++, kcode + "%");
			}
			if (!kname.equals("")) {
				setParam(index++, "%" + kname + "%");
			}
			if (!scode.equals("")) {
				setParam(index++, scode);
			}
			executeQuery();
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKihonDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MKihonDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MKihonDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MKihonDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());		//ЈR[h
		setParam(index++, dto.getSimei());		//
		setParam(index++, dto.getFurigana());	//ӂ肪
		setParam(index++, dto.getSCode());		//R[h
		setParam(index++, dto.getYCode());		//ER[h
		setParam(index++, dto.getTokyu());		//
		setParam(index++, dto.getJCode());		//ƏR[h
		setParam(index++, dto.getNyDate());		//Г
		setParam(index++, dto.getTsDate());		//ސE
		setParam(index++, dto.getKnKubun());	//xސE敪
		setParam(index++, dto.getKyKubun());	//^敪
		setParam(index++, dto.getTxKubun());	//ŋ敪
		setParam(index++, dto.getTxKubunx());	//̑ŋ敪
		setParam(index++, dto.getKmKubun());	//g敪
		setParam(index++, dto.getPtKubun());	//p[g敪
		setParam(index++, dto.getShKubun());	//x敪
		setParam(index++, dto.getSiwakeCd());	//dWvR[h
		setParam(index++, dto.getHaigusya());	//}{z
		setParam(index++, dto.getFuyosu());		//}{Ƒ
		setParam(index++, dto.getYukyu());		//Lc
		setParam(index++, dto.getNenrei());		//N
		setParam(index++, dto.getKinzoku());	//ΑN
		setParam(index++, dto.getKenpoNo());	//۔ԍ
		setParam(index++, dto.getKohoNo());		//۔ԍ
		setParam(index++, dto.getKUser());		//[U
		setParam(index++, dto.getPassw());		//pX[h
		setParam(index++, dto.getEmail());		//email
		setParam(index++, dto.getNinsyo());		//F؎
		setParam(index++, dto.getDataLvl());	//f[^x
		setParam(index++, dto.getProgLevel());	//vOgp
		setCommonParams(isInsert);
	}

	/**
	 * ݐEҎ擾pSQL擾
	 * @return ݐEҎ擾pSQL
	 */
	protected String getSearchEmployeeStatement() {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(COL_TSDATE + " = 0 ");
		sb.append(" OR ");
		sb.append(COL_TSDATE + " >= ? ");
		sb.append(") ");
		sb.append(" AND ");
		sb.append(COL_KNKUBUN);		
		sb.append(" = '" + CommonConst.RETIREMENT_FLAG_OFF + "' ");
		return sb.toString();
	}

	/**
	 * ݐEҎ擾pSQL擾
	 * <p>	2009/06/08	m.yoshida	ސEҕ\Ή	</p>
	 * @return ݐEҎ擾pSQL
	 */
	public static String getSearchEmployeeStatementPeriod(boolean useKnKubun) {
		StringBuffer sb = new StringBuffer();
		sb.append(" (");
		sb.append(		COL_TSDATE + " = 0 ");
		sb.append(		" OR ");
		sb.append(		COL_TSDATE + " >= ? ");
		sb.append(") ");
		sb.append(" AND ");
		sb.append(COL_NYDATE + " <= ? ");
		if (useKnKubun) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN);		
			sb.append(" = '" + CommonConst.RETIREMENT_FLAG_OFF + "' ");
		}
		return sb.toString();
	}

	/**
	 * EʂɂבւSQL擾
	 * @return EʂɂבւSQL
	 */
	private String getOrderForPosition() {
		StringBuffer sb = new StringBuffer();
		sb.append("ORDER BY ");
		sb.append(COL_YCODE + ", ");
		sb.append(COL_PTKUBUN + ", ");
		sb.append(COL_SCODE + ", ");
		sb.append(COL_KCODE + " ");
		return sb.toString();
	}

	/**
	 * ЈR[hpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKCodeSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ? ");
		return sb.toString();
	}

	/**
	 * ЈR[hpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKCodeEqualSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		return sb.toString();
	}

	/**
	 * ЈpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKNameSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_SIMEI);
		sb.append(" LIKE ? ");
		return sb.toString();
	}

	/**
	 * pTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchAuthoritySubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_PROGLEVEL);
		sb.append(" = ? ");
		return sb.toString();
	}

	/**
	 * pTuNG[
	 * @return@sb	TuNG
	 */
	public static String getSearchSectionSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_SCODE);
		sb.append(" = ? ");
		return sb.toString();
	}

}
