/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

import jp.mosp.human.dto.MEmergencyDto;

public class MEmergencyDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  = "M_EMERGENCY"	;
	public static final String KEY_1 	= "EMCODE"		;	//A

	// 
	public static final String COL_EMCODE  		= "EMCODE"		;	//A
	public static final String COL_KCODE  		= "KCODE"		;	//ЈR[h
	public static final String COL_NAME  			= "NAME"		;	//A掁
	public static final String COL_PHONE  		= "PHONE"		;	//dbԍ
	public static final String COL_CELL  			= "CELL"		;	//gєԍ
	public static final String COL_POSTALCODE  	= "POSTALCODE"	;	//X֔ԍ
	public static final String COL_PREFECTURES  	= "PREFECTURES"	;	//s{R[h
	public static final String COL_JYUUSYO1  		= "JYUUSYO1"	;	//ZP
	public static final String COL_JYUUSYO2  		= "JYUUSYO2"	;	//ZQ
	public static final String COL_JYUUSYO3  		= "JYUUSYO3"	;	//ZR
	public static final String COL_DELETE_FLAG  	= "DELETEFLAG"	;	//폜tO

	/**
	 * RXgN^
	 */
	public MEmergencyDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List mappingAll() throws SQLException {
		List<MEmergencyDto> all = new ArrayList<MEmergencyDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_emergencyDto m_emergencyR[h
	 * @throws SQLException
	 */
	private MEmergencyDto mapping() throws SQLException {
		MEmergencyDto dto = new MEmergencyDto();
		dto.setEmCode 		(rs.getInt    (COL_EMCODE		));	//A
		dto.setKCode 		(rs.getString (COL_KCODE		));	//ЈR[h
		dto.setName 		(rs.getString (COL_NAME			));	//A掁
		dto.setPhone 		(rs.getString (COL_PHONE		));	//dbԍ
		dto.setCell 		(rs.getString (COL_CELL			));	//gєԍ
		dto.setPostalCode 	(rs.getString (COL_POSTALCODE	));	//X֔ԍ
		dto.setPrefectures 	(rs.getInt    (COL_PREFECTURES	));	//s{R[h
		dto.setJyuusyo1 	(rs.getString (COL_JYUUSYO1		));	//ZP
		dto.setJyuusyo2 	(rs.getString (COL_JYUUSYO2		));	//ZQ
		dto.setJyuusyo3 	(rs.getString (COL_JYUUSYO3		));	//ZR
		dto.setDeleteFlag 	(rs.getInt    (COL_DELETE_FLAG	));	//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param emcode A(L[)
	 * @return m_emergencyDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MEmergencyDto findForKey(
			String emcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, emcode);
			executeQuery();
			MEmergencyDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param emcode A(L[)
	 * @return m_emergencyDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MEmergencyDto findForUpdate(
			String emcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, Integer.parseInt(emcode));
			executeQuery();
			MEmergencyDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂsbN擾
	 * @param EmCode	R[h
	 * @param KCode		ЈR[h
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MEmergencyDto findForConditionUp(
			String EmCode,
			String KCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_EMCODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ?  ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass())+ getForUpdate());
			setParam(index++, EmCode + "%");
			setParam(index++, "%" + KCode + "%" );
			executeQuery();
			MEmergencyDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}		
	}

	/**
	 * ɂf[^擾
	 * @param EmCode	R[h
	 * @param KCode		ЈR[h
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public MEmergencyDto findForCondition(
			String EmCode,
			String KCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_EMCODE);
		sb.append(" = ? AND ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ?  ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, Integer.parseInt(EmCode));
			setParam(index++, "%" + KCode + "%" );
			executeQuery();
			MEmergencyDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}		
	}

	/**
	 * ɂf[^擾
	 * @param KCode		ЈR[h
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public MEmergencyDto findForConditionUpdate(
			String KCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ?  ");
		sb.append(" AND ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = 0 ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, KCode);
			executeQuery();
			MEmergencyDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}		
	}

	/**
	 * ɂf[^擾
	 * @param emcode A
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			int emcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_EMCODE);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   emcode  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MEmergencyDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MEmergencyDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getEmCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * maxl擾
	 * @param  Kcode ЈR[h(L[)
	 * @return String@őA
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public String findForMax(String Kcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxEno = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_EMCODE);
			sb.append(") FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_KCODE);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, Kcode);
			executeQuery();
			if (rs.next()) {
				maxEno = String.valueOf(rs.getInt(1));
			}
			return maxEno;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxEno = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_EMCODE);
			sb.append(") FROM ");
			sb.append(TABLE);
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				maxEno = String.valueOf(rs.getInt(1));
			}
			return maxEno;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAllDelflag() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {

			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = 0 ");
			prepareStatement(getSelectQuery(getClass()) + sb + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MEmergencyDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getEmCode		());	//A
		setParam(index++, dto.getKCode		());	//ЈR[h
		setParam(index++, dto.getName		());	//A掁
		setParam(index++, dto.getPhone		());	//dbԍ
		setParam(index++, dto.getCell		());	//gєԍ
		setParam(index++, dto.getPostalCode	());	//X֔ԍ
		setParam(index++, dto.getPrefectures());	//s{R[h
		setParam(index++, dto.getJyuusyo1	());	//ZP
		setParam(index++, dto.getJyuusyo2	());	//ZQ
		setParam(index++, dto.getJyuusyo3	());	//ZR
		setParam(index++, dto.getDeleteFlag	());	//폜tO
		setCommonParams(isInsert);
	}

}
