/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.common.MospUtility;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.payroll.dao.MKintaiDao;
import jp.mosp.payroll.dao.MKintaiKinmuDao;
import jp.mosp.payroll.dto.KintaiCompileDto;
import jp.mosp.payroll.dto.MKintaiDto;

/**
 * ΑӏWvpPartNX
 * @author yoshida
 *	@version	0.0.4
 */
public class KintaiCompilePart extends BasePart {

	/**
	 * RXgN^
	 */
	public KintaiCompilePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public KintaiCompilePart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * ΑӏWve[upDAO̎擾
	 * @since	0.0.3
	 * @return	ςMKintaiDaoCX^X
	 * @throws Exception
	 */
	public MKintaiDao getMKintaiDao() throws Exception {
		return (MKintaiDao) getPreparedDao(MKintaiDao.class.getCanonicalName());
	}

	/**
	 * Ζ`ԕʋΑӏWve[upDAO̎擾
	 * @since	0.0.3
	 * @return	ςMKintaiKinmuDaoCX^X
	 * @throws Exception
	 */
	public MKintaiKinmuDao getMKintaiKinmuDao() throws Exception {
		return (MKintaiKinmuDao) getPreparedDao(MKintaiKinmuDao.class.getCanonicalName());
	}

	/**
	 * Ώ۔NΑӏWv擾
	 * @param kCode				ΏێЈR[h
	 * @param targetMonth		Ώ۔N
	 * @param attendanceList	Ώ۔NoΕ냊Xg
	 * @return	Ώ۔NΑӏWv
	 * @throws Exception
	 */
	public KintaiCompileDto getCompiledInfo(
			String kCode,
			List<MSyukkinboDto> attendanceList
	) throws Exception {
		// DTȌ
		KintaiCompileDto compileDto = new KintaiCompileDto();
		// ϐ錾Aϐ̏
		// ΖԌv
		int totalWork = 0;
		// xeԌv
		int totalInterbal = 0;
		// xԌv
		int totalLate = 0;
		// ގԌv
		int totalLeave = 0;
		// cƎԌv
		int totalOver = 0;
		// xoԌv
		int totalHolidayWork = 0;
		// [鎞Ԍv
		int totalLateNight = 0;
		// oΓv
		double totalWorkDays = 0;
		// oΉ񐔌v
		int totalWorkNumber = 0;
		// Lxv
		double totalPaidHoliday = 0;
		// ʋxɌv
		int totalParticularHoliday = 0;
		// Γv
		int totalAbsence = 0;
		// axɌv
		int totalMedicalLeave = 0;
		// xv
		int totalCompensationDay = 0;
		// U֋xɌv
		int totalTransfer = 0;
		// xɌv
		int totalOther = 0;
		// xސ
		int leaveAndLate = 0;
		// 蓖
		int syokuji = 0;
		int cyoku1 = 0;
		int cyoku2 = 0;
		int cyoku3 = 0;
		int hoka1 = 0;
		int hoka2 = 0;
		int hoka3 = 0;
		int hoka4 = 0;
		int hoka5 = 0;
		// ԒPʗLx
		int unitHourHoliday = 0;
		/*						
		 *  	2009/08/18	m.yoshida	1.00Ή
		 */
		// 1.00
		int warimasi1 = 0;
		String[][] aryHolidayReason = mospcode().getHolidayReasonArray();
		// Wvf[^擾
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		// WvJn
		while (it.hasNext()) {
			MSyukkinboDto dto = it.next();
			// ΑӍ
			if (KintaiCommonPart.isAvailableWorkType(dto)) {
				// Ζ
				totalWork += dto.getKinmuJi();
				// xe
				totalInterbal += dto.getKyukeiJi();
				// x
				totalLate += dto.getTiJikan();
				// ގ
				totalLeave += dto.getSoJikan();
				// cƎ
				totalOver += dto.getZaJikan();
				// xo
				totalHolidayWork += dto.getKsJikan();
				// [鎞
				totalLateNight += dto.getSnJikan();
				// oΓ
				if (dto.getKinmuJi() > 0) {
					totalWorkDays++;
					totalWorkNumber++;
				}
				// xސ
				if (dto.getTiJikan() > 0 || dto.getSoJikan() > 0) {
					leaveAndLate++;
				}
				// 蓖
				syokuji += dto.getSyokuji();
				cyoku1 += dto.getCyoku1();
				cyoku2 += dto.getCyoku2();
				cyoku3 += dto.getCyoku3();
				hoka1 += dto.getHoka1();
				hoka2 += dto.getHoka2();
				hoka3 += dto.getHoka3();
				hoka4 += dto.getHoka4();
				hoka5 += dto.getHoka5();
				// x
				if (KintaiCommonPart.isStartHalfHoliday(dto) 
						|| KintaiCommonPart.isQuitHalfHoliday(dto)
				) {
					totalPaidHoliday += 0.5;
					totalWorkDays -= 0.5;
				}
				// 񎞊ԔNx
				unitHourHoliday += dto.getNijiKyu();
				/*						
				 *  	2009/08/18	m.yoshida	1.00Ή
				 */
				// 1.00
				warimasi1 += dto.getWarimasi1();
			} else {
				// xɍ
				if (KintaiCommonPart.isHoliday(dto)) {
					if (KintaiCommonPart.isAllHoliday(dto, aryHolidayReason)) {
						// LxɁim_code, xɗR, tcode="0"j
						totalPaidHoliday++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[1][0])) {
						// ʋxɁim_code, xɗR, tcode="1"j
						totalParticularHoliday++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[2][0])) {
						// Γim_code, xɗR, tcode="2"j
						totalAbsence++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[3][0])) {
						// axɁim_code, xɗR, tcode="3"j
						totalMedicalLeave++;
					} else if (KintaiCommonPart.isSubstituteHoliday(dto, aryHolidayReason)) {
						// xim_code, xɗR, tcode="4"j
						totalCompensationDay++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[5][0])) {
						// U֋xɁim_code, xɗR, tcode="5"j
						totalTransfer++;
					} else {
						// xɁim_code, xɗR, tcode="6"j
						totalOther++;
					}
				}
			}
		}
		// oΓ
		compileDto.setTotalWorkDays(totalWorkDays);
		// oΉ
		compileDto.setTotalWorkNumber(totalWorkNumber);
		// Ζԍv
		compileDto.setTotalWork(totalWork);
		// xeԍv
		compileDto.setTotalInterbal(totalInterbal);
		// Lxɓ
		compileDto.setTotalPaidHoliday(totalPaidHoliday);
		// ʋxɓ
		compileDto.setTotalParticularHoliday(totalParticularHoliday);
		// ΋xɓ
		compileDto.setTotalAbsence(totalAbsence);
		// axɓ
		compileDto.setTotalMedicalLeave(totalMedicalLeave);
		// x
		compileDto.setTotalCompensationDay(totalCompensationDay);
		// U֋xɓ
		compileDto.setTotalTransfer(totalTransfer);
		// xɓ
		compileDto.setTotalOther(totalOther);
		// xސ
		compileDto.setLeaveAndLate(leaveAndLate);
		// x
		compileDto.setTotalLate(totalLate);
		// ގ
		compileDto.setTotalLeave(totalLeave);
		// cƎԍv
		compileDto.setTotalOver(totalOver);
		// xoԍv
		compileDto.setTotalHolidayWork(totalHolidayWork);
		// [鎞ԍv
		compileDto.setTotalLateNight(totalLateNight);
		// F΁i΁AʋxɁAaAxސ̍vj
		if ((totalAbsence + totalParticularHoliday + totalMedicalLeave + leaveAndLate) == 0
				&& totalWorkDays != 0
		) {
			compileDto.setApplyAttendanceAllowance(true);
		}
		// Eɂ蓖xݒ
		if (!PartManager.position(partInfo()).isApplyAttendanceAllowance(kCode)) {
			compileDto.setApplyAttendanceAllowance(false);
		}
		// 蓖
		// H蓖v
		compileDto.setSyokuji(syokuji);
		// P蓖v
		compileDto.setCyoku1(cyoku1);
		// Q蓖v
		compileDto.setCyoku2(cyoku2);
		// R蓖v
		compileDto.setCyoku3(cyoku3);
		// ̑蓖Pv
		compileDto.setHoka1(hoka1);
		// ̑蓖Qv
		compileDto.setHoka2(hoka2);
		// ̑蓖Rv
		compileDto.setHoka3(hoka3);
		// ̑蓖Sv
		compileDto.setHoka4(hoka4);
		// ̑蓖Tv
		compileDto.setHoka5(hoka5);
		// ԒPʔNxv
		compileDto.setUnitHourHoliday(unitHourHoliday);
		/*						
		 *  	2009/08/18	m.yoshida	1.00Ή
		 */
		// 1.00ԍv
		compileDto.setWarimasi1(warimasi1);
		return compileDto;
	}

	/**
	 * Ώ۔NΑӏWvϊ
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param dto			Ώ۔NΑӏWvDTO
	 * @return	ΑӏWv
	 * @throws Exception
	 */
	public MKintaiDto convCompileToKintai(
			String kCode,
			Date targetMonth,
			KintaiCompileDto dto
	) throws Exception {
		// DTȌ
		MKintaiDto mKintaiDto = new MKintaiDto();
		// DTOɒlZbg
		mKintaiDto.setKCode(kCode);
		// xN
		Date calcPaymentDate = calculate().getCalcPayment(targetMonth);
		// xN
		mKintaiDto.setSikyuYM(DatePart.convDateToStringYearMonthShort(targetMonth));
		// xN
		mKintaiDto.setSNen(MospUtility.getYear(calcPaymentDate));
		// x
		mKintaiDto.setSTuki(MospUtility.getMonth(calcPaymentDate));
		// x
		mKintaiDto.setSHi(MospUtility.getDay(calcPaymentDate));
		if (VariousPart.chkExistDto(dto)) {
			// oΓ
			mKintaiDto.setSNissu(dto.getTotalWorkDays());
			// oΉ
			mKintaiDto.setSKaisu(dto.getTotalWorkNumber());
			// Ζԍv
			mKintaiDto.setKinmuJi(dto.getTotalWork());
			// xeԍv
			mKintaiDto.setKyukeiJi(dto.getTotalInterbal());
			// Lxɓ
			mKintaiDto.setYukyu(dto.getTotalPaidHoliday());
			// ʋxɓ
			mKintaiDto.setTokuKyu(dto.getTotalParticularHoliday());
			// ΋xɓ
			mKintaiDto.setKekkin(dto.getTotalAbsence());
			// axɓ
			mKintaiDto.setSKekkin(dto.getTotalMedicalLeave());
			// x
			mKintaiDto.setDaiKyu(dto.getTotalCompensationDay());
			// U֋xɓ
			mKintaiDto.setFurikae(dto.getTotalTransfer());
			// xɓ
			mKintaiDto.setSonota(dto.getTotalOther());
			// xސ
			mKintaiDto.setTiSoKai(dto.getLeaveAndLate());
			// xގԍv
			mKintaiDto.setTiJikan(dto.getTotalLate() + dto.getTotalLeave());
			// cƎԍv
			mKintaiDto.setZaJikan(dto.getTotalOver());
			// xoԍv
			mKintaiDto.setKsJikan(dto.getTotalHolidayWork());
			// [鎞ԍv
			mKintaiDto.setSnJikan(dto.getTotalLateNight());
			// F
			if (dto.isApplyAttendanceAllowance()) {
				mKintaiDto.setKaikin(1);
			}
			// 蓖
			// H蓖v
			mKintaiDto.setSyokujiKaisu(dto.getSyokuji());
			// P蓖v
			mKintaiDto.setCyokuKaisu1(dto.getCyoku1());
			// Q蓖v
			mKintaiDto.setCyokuKaisu2(dto.getCyoku2());
			// R蓖v
			mKintaiDto.setCyokuKaisu3(dto.getCyoku3());
			// ̑蓖Pv
			mKintaiDto.setHokaKaisu1(dto.getHoka1());
			// ̑蓖Qv
			mKintaiDto.setHokaKaisu2(dto.getHoka2());
			// ̑蓖Rv
			mKintaiDto.setHokaKaisu3(dto.getHoka3());
			// ̑蓖Sv
			mKintaiDto.setHokaKaisu4(dto.getHoka4());
			// ̑蓖Tv
			mKintaiDto.setHokaKaisu5(dto.getHoka5());
			// 񎞊ԔNxv
			mKintaiDto.setNijiKyu(dto.getUnitHourHoliday());
			/*						
			 *  	2009/08/18	m.yoshida	1.00Ή
			 */
			// 1.00
			mKintaiDto.setWarimasi1(dto.getWarimasi1());
		}
		return mKintaiDto;
	}

	/**
	 * ΑӌWv
	 * @param kCode				ΏێЈR[h
	 * @param targetMonth		Ώ۔N
	 * @return	ΑӌWv
	 * @throws Exception
	 */
	public MKintaiDto getCompiledInfo(
			String kCode,
			Date targetMonth,
			List<MSyukkinboDto> attendanceList
	) throws Exception {
		// Ώ۔NΑӏWv
		return convCompileToKintai(kCode, targetMonth, getCompiledInfo(kCode, attendanceList));
	}

	/**
	 * FEF쐬
	 * @since	0.0.2
	 * @return [0]cFA[1]cFA[2]coΌ
	 * @throws Exception
	 */
	public static int[] makeApprovalNumber(List<MSyukkinboDto> attendanceList) {
		// z񏉊
		int number[] = {0, 0, 0};
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		// oΌ
		number[2] = attendanceList.size();
		while (it.hasNext()) {
			MSyukkinboDto dto = it.next();
			// ꎟFA񎟏F
			if (KintaiApprovalPart.is2ndApproved(dto)) {
				number[0]++;
			} else {
				number[1]++;
			}
			break;
		}
		return number;
	}

}
