/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

/**
 * ΑӍڌvZ@
 * @author yoshida
 *	@version	0.0.1
 */
public class KintaiCalcPart {

	/**
	 * KoΎ
	 */
	protected int regStartTime		= 0;
	/**
	 * KދΎ
	 */
	protected int regQuitTime 		= 0;
	/**
	 * KΖ
	 */
	protected int regWorkTime 		= 0;
	/**
	 * Kxe
	 */
	protected int regBreakTime 	= 0;
	/**
	 * KcƊJn
	 */
	protected int regOverStart		= 0;
	/**
	 * KcƋxe
	 */
	protected int regOverBreak		= 0;

	/**
	 * x
	 */
	protected int lateTime 		= 0;
	/**
	 * Ζ
	 */
	protected int workTime 		= 0;
	/**
	 * ގ
	 */
	protected int leaveTime 		= 0;
	/**
	 * cƎ
	 */
	protected int overTime 		= 0;
	/**
	 * xe
	 */
	protected int intervalTime 	= 0;
	/**
	 * [鎞
	 */
	protected int lateNightTime 	= 0;
	/**
	 * xo
	 */
	protected int holidayWorkTime 	= 0;

	/**
	 * [鎞ԊJn
	 */
	protected int lateNightStart 	= 0;
	/**
	 * [鎞ԏI
	 */
	protected int lateNightEnd 	= 0;
	/**
	 * x
	 */
	protected int halfHoliday		= 0;
	/**
	 * ͒Pʁij
	 */
	protected int inputUnit 		= 1;

	/**
	 * RXgN^
	 */
	public KintaiCalcPart() {

	}

	/**
	 * RXgN^
	 * @param regStartTime		KoΎ
	 * @param regQuitTime		KދΎ
	 * @param regWorkTime		KΖ
	 * @param regBreakTime		Kxe
	 * @param regOverStart		KcƊJn
	 * @param regOverBreak		KcƋxe
	 * @param lateNightStart	[鎞ԊJniji48Ԑj
	 * @param lateNightEnd		[鎞ԏIiji48Ԑj
	 * @param halfHoliday		xԁij	
	 * @param inputUnit			Pʎԁij
	 */
	public KintaiCalcPart(
			int regStartTime,
			int regQuitTime,
			int regWorkTime,
			int regBreakTime,
			int regOverStart,
			int regOverBreak,
			int lateNightStart,
			int lateNightEnd,
			int halfHoliday,
			int inputUnit
	) {
		// eK莞Ԑݒ
		setWorkTypeInfo(regStartTime, regQuitTime, regWorkTime, regBreakTime, regOverStart, regOverBreak);
		// Ԑݒ
		setHours(lateNightStart, lateNightEnd, halfHoliday, inputUnit);
	}

	/**
	 * Ԑݒ
	 * @param lateNightStart	[鎞ԊJniji48Ԑj
	 * @param lateNightEnd		[鎞ԏIiji48Ԑj
	 * @param halfHoliday		xԁij	
	 * @param inputUnit			Pʎԁij
	 */
	public void setHours(
			int lateNightStart,
			int lateNightEnd,
			int halfHoliday,
			int inputUnit
	) {
		setLateNightInfo(lateNightStart, lateNightEnd);
		this.halfHoliday = halfHoliday;
		if (inputUnit > 1) {
			this.inputUnit = inputUnit;
		}
	}

	/**
	 * [鎞Ԑݒ
	 * @param lateNightStart	[鎞ԊJniji48Ԑj
	 * @param lateNightEnd		[鎞ԏIiji48Ԑj
	 */
	public void setLateNightInfo(int lateNightStart, int lateNightEnd) {
		this.lateNightStart = lateNightStart;
		this.lateNightEnd = lateNightEnd;
	}

	/**
	 * eK莞Ԑݒ
	 * @param regStartTime		KoΎ
	 * @param regQuitTime		KދΎ
	 * @param regWorkTime		KΖ
	 * @param regBreakTime		Kxe
	 * @param regOverStart		KcƊJn
	 * @param regOverBreak		KcƋxe
	 */
	public void setWorkTypeInfo(
			int regStartTime,
			int regQuitTime,
			int regWorkTime,
			int regBreakTime,
			int regOverStart,
			int regOverBreak
	) {
		this.regStartTime = regStartTime;
		this.regQuitTime = regQuitTime;
		this.regWorkTime = regWorkTime;
		this.regBreakTime = regBreakTime;
		this.regOverStart = regOverStart;
		this.regOverBreak = regOverBreak;
	}

	/**
	 * ΑӌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 * @param isStartHalf		oΔx敪
	 * @param isQuitHalf		ދΔx敪
	 * @param isWorkOnHoliday	xof
	 */
	public void runCalculate(
			int inputStart,
			int inputQuit,
			boolean isStartHalf,
			boolean isQuitHalf,
			boolean isWorkOnHoliday
	) {
		runCalcStartTime(inputStart, isStartHalf, isWorkOnHoliday);
		runCalcQuitTime(inputStart, inputQuit, (isStartHalf || isQuitHalf), isWorkOnHoliday);
	}

	/**
	 * o΋敪ԌvZ
	 * @param inputStart		oΎ
	 * @param isStartHalf		oΔx敪
	 * @param isWorkOnHoliday	xof
	 */
	public void runCalcStartTime(int inputStart, boolean isStartHalf, boolean isWorkOnHoliday) {
		if (isStartHalf | isWorkOnHoliday) {
			lateTime = 0;
		} else {
			lateTime = getLateTimes(inputStart);
		}
	}

	/**
	 * ދ΋敪ԌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 * @param isHalf			x敪
	 * @param isWorkOnHoliday	xof
	 */
	public void runCalcQuitTime(
			int inputStart,
			int inputQuit,
			boolean isHalf,
			boolean isWorkOnHoliday
	) {
		// ދΎ0ɂȂ邱Ƃ͖
		if (inputQuit == 0) {
			inputQuit = regQuitTime;
		}
		// Ζ
		workTime 			= getWorkTimes(inputStart, inputQuit);
		leaveTime 			= 0;
		if (!isHalf) {
			leaveTime 		= getLeaveEarlyTimes(inputQuit);
		}
		overTime 			= getOverTimes(isHalf);
		intervalTime 		= getIntervalTimes(inputQuit);
		lateNightTime		= getLateNightTimes(inputStart, inputQuit);
		holidayWorkTime		= getHolidayWork(isWorkOnHoliday);
	}

	/**
	 * xԌvZ
	 * @param inputStart		oΎ
	 * @return	x
	 */
	protected int getLateTimes(int inputStart) {
		return getLateTimes(inputStart, regStartTime, inputUnit);
	}

	/**
	 * xԌvZ
	 * @param inputStart		oΎ
	 * @param regStartTime		KoΎ
	 * @param inputUnit			Pʎ
	 * @return	x
	 */
	public static int getLateTimes(int inputStart, int regStartTime, int inputUnit) {
		// x = oΎ - WoΎ
		int latemin = inputStart - regStartTime;
		if (latemin > 0) {
			if (latemin % inputUnit > 0) {
				// xԂPʎԂŊ]肪0傫ꍇ͒xԂɒPʎԂ𑫂
				latemin += inputUnit;
			}
			// ۂ
			latemin -= latemin%inputUnit;
		}
		if (latemin < 0) {
			latemin = 0;
		}
		return latemin;
	}

	/**
	 * ΖԌvZ
	 * @param inputStart	oΎ
	 * @param inputQuit		ދΎ
	 * @return	Ζ
	 */
	protected int getWorkTimes(int inputStart, int inputQuit) {
		return getWorkTimes(inputStart, inputQuit, inputUnit);
	}

	/**
	 * ΖԌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 * @param inputUnit			Pʎ
	 * @return	Ζ
	 */
	public static int getWorkTimes(int inputStart, int inputQuit, int inputUnit) {
		// PʎԖ̏oΎ
		int remainderStart = inputStart % inputUnit;
		// ۂ߂oΎ
		int roundStart = inputStart - remainderStart;
		if (remainderStart > 0) {
			// PʎԖ̏oΎԂ0傫ꍇ͊ۂ߂oΎɒPʎԂ𑫂
			roundStart += inputUnit;
		}
		// PʎԖ̑ދΎ
		int remainderQuit = inputQuit % inputUnit;
		// ۂ߂ދΎ
		int roundQuit = inputQuit - remainderQuit;
		// ދΎ - oΎ
		int workmin = roundQuit - roundStart;
		// ΖԂ}CiX̏ꍇA0Ƃ
		if (workmin < 0){
			workmin = 0;
		}
		return workmin;
	}

	/**
	 * ގԌvZ
	 * @param inputQuit		ދΎ
	 * @return ގ
	 */
	protected int getLeaveEarlyTimes(int inputQuit) {
		return getLeaveEarlyTimes(inputQuit, regQuitTime, workTime, regWorkTime, inputUnit);
	}

	/**
	 * ގԌvZ
	 * @param inputQuit			ދΎ
	 * @param regQuitTime		KދΎ
	 * @param workTime			Ζ
	 * @param regWorkTime		KΖ
	 * @param inputUnit			Pʎ
	 * @return	ގ
	 */
	public static int getLeaveEarlyTimes(
			int inputQuit,
			int regQuitTime,
			int workTime,
			int regWorkTime,
			int inputUnit
	) {
		// ގ = WގЎ - ގЎ
		int leavemin = regQuitTime - inputQuit;
		if (leavemin % inputUnit > 0) {
			// ގԂPʎԂŊ]肪0傫ꍇ͑ގԂɒPʎԂ𑫂
			leavemin += inputUnit;
			// ۂ
			leavemin -= leavemin%inputUnit;
		}
		if (leavemin < 0) {
			leavemin = 0;
		}
		return leavemin;
	}

	/**
	 * xoԌvZ
	 * @param isWorkOnHoliday	xof
	 * @return	xo
	 */
	protected int getHolidayWork(boolean isWorkOnHoliday) {
		return getHolidayWork(workTime, intervalTime, isWorkOnHoliday);
	}

	/**
	 * xoԌvZ
	 * @param workTime			Ζ
	 * @param intervalTime		xe
	 * @param isWorkOnHoliday	xof
	 * @return
	 */
	public static int getHolidayWork(int workTime, int intervalTime, boolean isWorkOnHoliday) {
		if (isWorkOnHoliday) {
			return workTime - intervalTime;
		}
		return 0;
	}

	/**
	 * [鎞ԌvZ
 	 * @param inputStart	oΎ
	 * @param inputQuit		ދΎ
	 * @return	[鎞
	 */
	protected int getLateNightTimes(int inputStart, int inputQuit) {
		return getLateNightTimes(inputQuit, lateNightStart, lateNightEnd, inputUnit, inputStart);
	}

	/**
	 * [鎞ԌvZ
	 * @param inputQuit			ދΎ
	 * @param lateNightStart	[鎞ԊJn
	 * @param lateNightEnd		[鎞ԏI
	 * @param inputUnit			Pʎ
	 * @param inputStart		oΎ
	 * @return	[鎞ԌvZ
	 */
	public static int getLateNightTimes(
			int inputQuit,
			int lateNightStart,
			int lateNightEnd,
			int inputUnit,
			int inputStart
	) {
		// [鎞ԌvZ
		int latenightmin = 0;
		// oΎ[鎞JnԈȏ̏ꍇ
		if (inputStart >= lateNightStart) {
			// ދΎ - oΎ
			latenightmin = inputQuit - inputStart;
		} else {
			// ދΎ - [鎞ԊJn
			latenightmin = inputQuit - lateNightStart;
		}
		// ۂ
		latenightmin -= latenightmin%inputUnit;
		// x
		// [鎞ԊJnoΎȏ̏ꍇ
		if (inputStart >= lateNightStart) {
			// [鎞ԌvZ[鎞ԊJn - oΎ傫ꍇ
			if (latenightmin > (lateNightEnd - inputStart)) {
				latenightmin = lateNightEnd - inputStart;
			}
		} else {
			// [鎞ԌvZ[鎞ԊJn - [鎞ԏI傫ꍇ
			if (latenightmin > (lateNightEnd - lateNightStart)) {
				latenightmin = lateNightEnd - lateNightStart;
			}
		}
		// [鎞Ԃ}CiX̏ꍇA0Ƃ
		if (latenightmin < 0) {
			latenightmin = 0;
		}
		return latenightmin;
	}

	/**
	 * xeԌvZ
	 * @return	xe
	 */
	protected int getIntervalTimes(int inputQuit) {
		return getIntervalTimes(workTime, regBreakTime, overTime, regOverBreak, inputUnit,inputQuit,regQuitTime);
	}

	/**
	 * xeԌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 * @param inputUnit			Pʎ
	 * @param halfHoliday		x
	 * @param isHalf			x敪
	 * @param regStartTime		KoΎ
	 * @param regOverStart		KcƊJn
	 * @param regWorkTime		KΖ
	 * @param regBreakTime		Kxe
	 * @param regOverBreak		KcƋxe
	 * @param regQuitTime		KދΎ
	 * @return
	 */
	public static int getIntervalTimes(
			int inputStart,
			int inputQuit,
			int inputUnit,
			int halfHoliday,
			boolean isHalf,
			int regStartTime,
			int regOverStart,
			int regWorkTime,
			int regBreakTime,
			int regOverBreak,
			int regQuitTime
	) {
		return getIntervalTimes(
				getWorkTimes(inputStart, inputQuit, inputUnit),
				regBreakTime,
				getOverTimes(
						inputStart,
						inputQuit,
						inputUnit,
						halfHoliday,
						isHalf,
						regStartTime,
						regOverStart,
						regWorkTime,
						regOverBreak
				),
				regOverBreak,inputUnit,inputQuit,regQuitTime
			);
	}

	/**
	 * xeԌvZ
	 * @param workTime			Ζ
	 * @param regBreakTime		Kxe
	 * @param overTime			cƎ
	 * @param regOverBreak		KcƋxe
	 * @param inputUnit			͒Pʁij
	 * @param inputQuit			ދΎ
	 * @param regQuitTime		KދΎ
	 * @return	xe
	 */
	
	public static int getIntervalTimes(
			int workTime,
			int regBreakTime,
			int overTime,
			int regOverBreak,
			int inputUnit,
			int inputQuit,
			int regQuitTime
	) {
		// ދΎ + KދΎ
		int difQuit = inputQuit - regQuitTime;
		// cƋxe
		int overIntervalTime = 0;
		// xe
		int intervalmin = 0;
		// Wxe  5Ԉȏ
		if (workTime > 300) {
			intervalmin = regBreakTime;
		}
		// ދΎ > KދΎ
		if (inputQuit > regQuitTime) {
			overIntervalTime = difQuit;
			overIntervalTime -= overIntervalTime%inputUnit;
		}
		// cƎԂPȏ  KcƋxeԂދΎ̍傫ꍇ
		if (overTime > 0 || difQuit > regOverBreak) {
			overIntervalTime = regOverBreak;
		}
		// xe += cƋxe
		intervalmin += overIntervalTime;
		return intervalmin;
	}

	/**
	 * cƎԌvZ
	 * @param isHalf	x敪
	 * @return	cƎ
	 */
	protected int getOverTimes(boolean isHalf) {
		return getOverTimes(lateTime, workTime, halfHoliday, regOverStart, regWorkTime, regOverBreak, isHalf);
	}

	/**
	 * cƎԌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 * @param inputUnit			Pʎ
	 * @param halfHoliday		x
	 * @param isHalf			x敪
	 * @param regStartTime		KoΎ
	 * @param regOverStart		KcƎԊJn
	 * @param regWorkTime		KΖ
	 * @param regOverBreak		KcƋxe
	 * @return	cƎ
	 */
	public static int getOverTimes(
			int inputStart,
			int inputQuit,
			int inputUnit,
			int halfHoliday,
			boolean isHalf,
			int regStartTime,
			int regOverStart,
			int regWorkTime,
			int regOverBreak
	) {
		return getOverTimes(
				getLateTimes(inputStart, regStartTime, inputUnit),
				getWorkTimes(inputStart, inputQuit, inputUnit),
				halfHoliday,
				regOverStart,
				regWorkTime,
				regOverBreak,
				isHalf
		);
	}

	/**
	 * cƎԌvZ
	 * @param lateTime			x
	 * @param workTime			Ζ
	 * @param halfHoliday		x
	 * @param regOverStart		KcƊJn
	 * @param regWorkTime		KΖ
	 * @param regOverBreak		KcƋxe
	 * @param isHalf			x敪
	 * @return
	 */
	public static int getOverTimes(
			int lateTime,
			int workTime,
			int halfHoliday,
			int regOverStart,
			int regWorkTime,
			int regOverBreak,
			boolean isHalf
	) {
		// x + Ζ
		int worktimes = lateTime + workTime;
		// cƎ
		int overmin = 0;
		// x
		if (isHalf) {
			worktimes -= halfHoliday;
		}
		// ΖΏێ > WcƌvZJn
		if (worktimes > regOverStart) {
			// ΖΏێ - WΖ - cƋxe
			overmin = worktimes - regWorkTime - regOverBreak;
			if (overmin < 0) {
				overmin = 0;
			}
		}
		return overmin;
	}

	/**
	 * Ζ
	 * @return	ΖԌvZl
	 */
	public int getWorkTime() 			{ return workTime			; }

	/**
	 * xe
	 * @return	xeԌvZl
	 */
	public int getIntervalTime() 		{ return intervalTime		; }

	/**
	 * x
	 * @return	xԌvZl
	 */
	public int getLateTime() 			{ return lateTime			; }

	/**
	 * ގ
	 * @return	ގԌvZl
	 */
	public int getLeaveTime() 			{ return leaveTime			; }

	/**
	 * cƎ
	 * @return	cƎԌvZl
	 */
	public int getOverTime() 			{ return overTime			; }

	/**
	 * [鎞
	 * @return	[鎞ԌvZl
	 */
	public int getLateNightTime() 		{ return lateNightTime		; }

	/**
	 * xo
	 * @return	xoԌvZl
	 */
	public int getHolidayWorkTime() 	{ return holidayWorkTime	; }

}
