/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

import jp.mosp.common.CommonConst;
import jp.mosp.common.JapanHolidayUtility;
import jp.mosp.common.common.MospUtility;

/**
 * jՓɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class HolidayPart extends BasePart {

	/**
	 * RXgN^
	 */
	public HolidayPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public HolidayPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * j̎擾
	 * <p>	2009/02/25	m.yoshida	j\bhC </p>
	 * @param targetDate		Ώ۔N
	 * @return	Ώ۔Nj
	 * @throws Exception
	 */
	public String getPublicHolidayName(Date targetDate) throws Exception {
		String holidayName = "";
		// Ώۓj̎擾
		String targetName = getHolidayMap(MospUtility.getYear(targetDate)).get(targetDate);
		if (targetName != null) {
			holidayName = targetName;
		}
		return holidayName;
	}

	/**
	 * j̃}bv
	 * @param year			Ώ۔N
	 * @throws Exception
	 */
	private Map<Date, String> getHolidayMap(int year) throws Exception {
		Map<Date, String> holidayMap = new TreeMap<Date, String>();
		// jՓAxݒ
		String[][] aryCodeHoliday = mospcode().getMosPCodeArray(CommonConst.TID_HOLIDAY);
		Date holiday = null;
		for (int k = 0; k < aryCodeHoliday.length; k++) {
			// MM/DDn܂xւ̑Ή
			if (aryCodeHoliday[k][0].startsWith("0")
					|| aryCodeHoliday[k][0].startsWith("1")
			) {
				StringBuffer date = new StringBuffer();
				date.append(String.valueOf(year));
				date.append(CommonConst.SEPARATOR_DATE);
				date.append(aryCodeHoliday[k][0].split(CommonConst.SEPARATOR_DATE)[0]);
				date.append(CommonConst.SEPARATOR_DATE);
				date.append(aryCodeHoliday[k][0].split(CommonConst.SEPARATOR_DATE)[1]);
				holiday = MospUtility.getDate(date.toString());
			} else {
				holiday = MospUtility.getDate(aryCodeHoliday[k][0]);
			}
			holidayMap.put(holiday, aryCodeHoliday[k][1]);
		}
		// nbs[}f[ݒ
		String[][] aryJapanHoliday = getAryHolidaySingleYear(year);
		for (int i = 0; i < aryJapanHoliday.length; i++) {
			holiday = MospUtility.getDate(aryJapanHoliday[i][0]);
			if (holidayMap.get(holiday) == null) {
				holidayMap.put(holiday, aryJapanHoliday[i][1]);
			}
		}
		return holidayMap;
	}

	/**
	 * PNjՓz擾
	 * @param year
	 * @return	result
	 */
	private String[][] getAryHolidaySingleYear(int year) {
		String[][] result = new JapanHolidayUtility(year).getArySyuku();
		return result;
	}

}
