/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.sql.Connection;
import java.util.Properties;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * ePartNX̊{ƂȂNX
 * @author yoshida
 *	@version	0.0.2
 */
public abstract class BasePart {

	protected Properties 		cfg;
	protected String 			cmd;
	protected CmAspUserDto 	aspUser;
	protected CmUserDto 		user;
	protected Connection 		conn;

	/**
	 * RXgN^
	 */
	public BasePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public BasePart(PartInfo partInfo) {
		this();
		init(partInfo);
	}

	/**
	 * 
	 * @param partInfo
	 */
	public void init(PartInfo partInfo) {
		init(
				partInfo.getCfg(),
				partInfo.getCmd(),
				partInfo.getAspUser(),
				partInfo.getUser(),
				partInfo.getConn()
		);
	}

	/**
	 * 
	 * @param cfg
	 * @param cmd
	 * @param aspUser
	 * @param user
	 */
	public void init(
			Properties cfg,
			String cmd,
			CmAspUserDto aspUser,
			CmUserDto user,
			Connection conn
	) {
		this.cfg = cfg;
		this.cmd = cmd;
		this.aspUser = aspUser;
		this.user = user;
		this.conn = conn;
	}

	/**
	 * DAOtB[h
	 */
	private BaseDao dao;

	/**
	 * ςDAO
	 * @param className		ΏDAONX
	 * @return				ΏۏςDAOCX^X
	 * @throws Exception
	 */
	protected BaseDao getPreparedDao(String className) throws Exception {
		// DAO
		if (dao == null || !dao.getClass().getName().equals(className)) {
			Object obj = PartFactory.getInstance(className);
			if (obj instanceof BaseDao) {
				dao = (BaseDao) obj;
				dao.initDao(cfg, cmd, aspUser, user, conn);
			} else {
				throw new MospException(5014,
						className + " is not instanceof BaseDao class."
				);
			}
		}
		return dao;
	}

	/**
	 * PartInfo
	 * @return	PartInfoCX^X
	 */
	protected PartInfo partInfo() {
		return PartManager.createPartInfo(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * MosPCodePartCX^X擾 
	 * @return	MosPCodePartCX^X
	 * @throws MospException
	 */
	protected MosPCodePart mospcode() throws MospException {
		return PartManager.mospcode(partInfo());
	}

	/**
	 * CalculatePartCX^X擾 
	 * @return	CalculatePartCX^X
	 * @throws MospException
	 */
	protected CalculatePart calculate() throws MospException {
		return PartManager.calculate(partInfo());
	}

	/**
	 * MosPUserPartCX^X擾 
	 * @return	MosPUserPartCX^X
	 * @throws MospException
	 */
	protected MosPUserPart mospuser() throws MospException {
		return PartManager.mospuser(partInfo());
	}

	/**
	 * HumanPartCX^X擾
	 * @return	HumanPartCX^X
	 * @throws MospException
	 */
	protected HumanPart human() throws MospException {
		return PartManager.human(partInfo());
	}

	/**
	 * AuthorityPartCX^X擾
	 * @return	AuthorityPartCX^X
	 * @throws MospException
	 */
	protected AuthorityPart authority() throws MospException {
		return PartManager.authority(partInfo());
	}

	/**
	 * ComponentPartCX^X擾
	 * @return	ComponentPartCX^X
	 * @throws MospException
	 */
	protected ComponentPart component() throws MospException {
		return PartManager.component(partInfo());
	}

	/**
	 * SectionPartCX^X擾
	 * @return	SectionPartCX^X
	 * @throws MospException
	 */
	protected SectionPart section() throws MospException {
		return PartManager.section(partInfo());
	}

	/**
	 * CmCodePartCX^X擾
	 * @return	CmCodePartCX^X
	 * @throws MospException
	 */
	protected CmCodePart cmcode() throws MospException {
		return PartManager.cmcode(partInfo());
	}

	/**
	 * MosPConfPartCX^X擾
	 * @return	MosPConfPartCX^X
	 * @throws MospException
	 */
	protected MosPConfPart mospconf() throws MospException {
		return PartManager.mospconf(partInfo());
	}

	/**
	 * KintaiCommonPartCX^X擾
	 * @return	KintaiCommonPartCX^X
	 * @throws MospException
	 */
	protected KintaiCommonPart kintai() throws MospException {
		return PartManager.kintai(partInfo());
	}

	/**
	 * OfficePartCX^X擾
	 * @since 	0.0.2
	 * @return	OfficePartCX^X
	 * @throws MospException
	 */
	protected OfficePart office() throws MospException {
		return PartManager.office(partInfo());
	}

}
