/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmComponentDto;

public class CmComponentDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  = "CM_COMPONENT"	;
	public static final String KEY_1 	= "COMPCODE"		;	//R}hjbgR[h

	// 
	public static final String COL_COMP_CODE  	= "COMPCODE"	;	//R}hjbgR[h
	public static final String COL_DIVISION  		= "DIVISION"	;	//
	public static final String COL_COMP_NAME  	= "COMPNAME"	;	//R}hjbgl[
	public static final String COL_COMPONENT  	= "COMPONENT"	;	//R}h
	public static final String COL_MANAGE  		= "MANAGE"		;	//{
	public static final String COL_DELETE_FLAG  	= "DELETEFLAG"	;	//폜tO

	/**
	 * RXgN^
	 */
	public CmComponentDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmComponentDto> mappingAll() throws SQLException {
		List<CmComponentDto> all = new ArrayList<CmComponentDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return cm_componentDto cm_componentR[h
	 * @throws SQLException
	 */
	private CmComponentDto mapping() throws SQLException {
		CmComponentDto dto = new CmComponentDto();
		dto.setCompCode	 	(rs.getString (COL_COMP_CODE	));	//R}hjbgR[h
		dto.setDivision 	(rs.getString (COL_DIVISION		));	//
		dto.setCompName 	(rs.getString (COL_COMP_NAME	));	//R}hjbgl[
		dto.setComponent 	(rs.getString (COL_COMPONENT	));	//R}h
		dto.setManage 		(rs.getInt    (COL_MANAGE		));	//{
		dto.setDeleteFlag 	(rs.getInt    (COL_DELETE_FLAG	));	//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param compcode R}hjbgR[h(L[)
	 * @return cm_componentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmComponentDto findForKey(
			String compcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, compcode);
			executeQuery();
			CmComponentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param compcode R}hjbgR[h(L[)
	 * @return cm_componentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmComponentDto findForUpdate(
			String compcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, compcode);
			executeQuery();
			CmComponentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param compcode R}hjbgR[h
	 * @param division 
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String compcode,
			String division
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_COMP_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_DIVISION);
		sb.append(" LIKE ?  ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   compcode  );
			setParam(index++,   division   + "%");
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param compcode R}hjbgR[h
	 * @param division 
	 * @param compname R}hjbgl[
	 * @param manage {
	 * @param deleteFlag	폜tO
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String compcode,
			String division,
			String compname,
			String manage,
			String deleteFlag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_COMP_CODE);
		sb.append(" LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_DIVISION);
		sb.append(" LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_COMP_NAME);
		sb.append(" LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_MANAGE);
		sb.append(" LIKE ? ");
		if (!deleteFlag.equals("")) {
			sb.append(" AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, compcode + "%");
			setParam(index++, "%" + division + "%");
			setParam(index++, "%" + compname + "%");
			setParam(index++, "%" + manage + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param division 
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmComponentDto> findForCondition(
			String division
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DIVISION);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   division);
			executeQuery();
			List<CmComponentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param compcode R[h
	 * @param division 敪
	 * @return dto DTO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmComponentDto findForDto(
			String compcode,
			String division
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_COMP_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_DIVISION);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   compcode	);
			setParam(index++,   division	);
			executeQuery();
			CmComponentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param division 
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmComponentDto> findForAvailable(
			String division
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_DIVISION);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   division);
			executeQuery();
			List<CmComponentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param compcode R[h
	 * @param division 敪
	 * @return dto DTO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmComponentDto findForComponent(
			String compcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_COMP_CODE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   compcode  );
			executeQuery();
			CmComponentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmComponentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto , true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}	

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmComponentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto , false);
			setParam(index++, dto.getCompCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(CmComponentDto dto ,boolean isInsert) throws SQLException {
		setParam(index++, dto.getCompCode());	//R}hjbgR[h
		setParam(index++, dto.getDivision());	//
		setParam(index++, dto.getCompName());	//R}hjbgl[
		setParam(index++, dto.getComponent());	//R}h
		setParam(index++, dto.getManage());		//{
		setParam(index++, dto.getDeleteFlag());	//폜tO
		setCommonParams(isInsert);
	}

}
