/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

import java.sql.Connection;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * e[ubN[eBeB
 * @author yoshida
 *	@version	0.0.1
 */
public class TableLockUtility {

	private static final String FLD_TABLE = "TABLE";

	private LockTableDao tableLock;
	private List<String> tableList;

	/**
	 * RXgN^
	 */
	public TableLockUtility() {

	}

	/**
	 * RXgN^()
	 */
	public TableLockUtility(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		init(cfg, cmd, aspUser, user, conn);
		setTableList(getTableInitList());
	}

	/**
	 * 
	 * @param cfg
	 * @param cmd
	 * @param aspUser
	 * @param user
	 * @param conn
	 */
	public void init(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		tableLock = new LockTableDao();
		tableLock.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * e[ubN(WRITE)
	 * @throws Exception
	 */
	public void lockTables() throws Exception {
		tableLock.lockTables(tableList);
	}

	/**
	 * e[ubN
	 * @param tableList		Ώۃe[uDAOꗗ
	 * @throws Exception
	 */
	public void lockTables(List<String> tableList) throws Exception {
		setTableList(tableList);
		lockTables();
	}

	/**
	 * e[ubN
	 * @throws Exception
	 */
	public void unLockTables() throws Exception {
		tableLock.unLockTables();
	}

	/**
	 * Ώۃe[uDAOꗗ
	 * @return
	 */
	public List<String> getTableInitList() {
		return new ArrayList<String>();
	}

	/**
	 * Ώۃe[uDAOꗗݒ
	 * @param tableSet
	 */
	public void setTableList(List<String> tableList) {
		this.tableList = tableList;
	}

	/**
	 * Ώۃe[uDaoǉ
	 * @param dao
	 */
	public void addTargetTable(BaseDao dao, boolean isWrite) {
		this.tableList = this.tableList == null ? this.tableList = getTableInitList() : this.tableList;
		StringBuffer sb = new StringBuffer();
		sb.append(getTableName(dao));
		sb.append(CommonConst.STR_UNDER_SEPARATOR);
		sb.append(isWrite);		
		tableList.add(sb.toString());
	}

	/**
	 * Ώۃe[uDaoǉ
	 * @param dao
	 */
	public void addTargetTable(String tableName, boolean isWrite) {
		this.tableList = this.tableList == null ? this.tableList = getTableInitList() : this.tableList;
		StringBuffer sb = new StringBuffer();
		sb.append(tableName);
		sb.append(CommonConst.STR_UNDER_SEPARATOR);
		sb.append(isWrite);		
		tableList.add(sb.toString());
	}

	/**
	 * Ώۃe[u擾
	 * @param dao		ΏDAO
	 * @return	Ώۃe[u
	 */
	public String getTableName(BaseDao dao) {
		String tableName = "";
		try {
			tableName = (String)dao.getClass().getField(FLD_TABLE).get(null);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		}
		return tableName;
	}

	/**
	 * Ώۃe[u擾
	 * @param dao		ΏDAO
	 * @param fieldName
	 * @return
	 */
	public String getTableName(BaseDao dao, String fieldName) {
		String tableName = "";
		try {
			tableName = (String)dao.getClass().getField(fieldName).get(null);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		}
		return tableName;
	}

	/**
	 * e[ubNpDAO
	 * @author yoshida
	 * @version 0.0.2
	 */
	private static class LockTableDao extends BaseDao {

		/**
		 * RXgN^
		 */
		public LockTableDao() {
			super();
		}

		/**
		 * e[ubN
		 * @param tableList			Ώۃe[uꗗ
		 * @throws SQLException
		 * @throws SecurityException
		 * @throws IllegalArgumentException
		 * @throws IllegalAccessException
		 * @throws NoSuchFieldException
		 * @throws MospException
		 */
		public void lockTables(
				List<String> tableList
		) throws SQLException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, MospException {
			try {
				prepareStatement(getLockTableSQL(tableList));
				executeUpdate();
			} catch (SQLException e) {
				throw e ;
			} finally {
				releaseResultSet();
				releasePreparedStatement();
			}
		}

		/**
		 * e[ubN
		 * @throws SQLException
		 * @throws MospException 
		 */
		public void unLockTables() throws SQLException, MospException{
			if (getRdbmsType() == 1) {
				try {
					prepareStatement("UNLOCK TABLES ");
					executeUpdate();
				} catch (SQLException e) {
					throw e ;
				} finally {
					releaseResultSet();
					releasePreparedStatement();
				}
			}
		}

		/**
		 * e[ubNpSQL
		 * @param tableList		Ώۃe[uꗗ
		 * @return
		 * @throws MospException
		 */
		private String getLockTableSQL(List<String> tableList) throws MospException {
			StringBuffer sb = new StringBuffer();
			switch (getRdbmsType()) {
			case 1:
				// MySQL̏ꍇ
				sb.append("LOCK TABLES ");
				for (String table : tableList) {
					String[] code = table.split(CommonConst.STR_UNDER_SEPARATOR);
					sb.append(code[0]);
					if (Boolean.parseBoolean(code[1])) {
						sb.append(" WRITE ");
					} else {
						sb.append(" READ ");
					}
					sb.append(CommonConst.STR_UNDER_SEPARATOR);
				}
				sb.delete(sb.lastIndexOf(CommonConst.STR_UNDER_SEPARATOR), sb.length());
				break;
			case 2:
				// PostgreSQL̏ꍇ
				sb.append("LOCK TABLE ");
				for (String table : tableList) {
					String[] code = table.split(CommonConst.STR_UNDER_SEPARATOR);
					if (Boolean.parseBoolean(code[1])) {
						sb.append(code[0]);
						sb.append(CommonConst.STR_UNDER_SEPARATOR);
					}
				}
				sb.delete(sb.lastIndexOf(CommonConst.STR_UNDER_SEPARATOR), sb.length());
				break;
			default:
				break;
			}
			return sb.toString();
		}

	}

}
