/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospUtility;

import jp.mosp.workflow.dto.AmUnitDto;

public class ApprovalUnitListVo extends ApprovalMenuVo {

	private static final long serialVersionUID = 4781254088593017966L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/workflow/approvalUnitList.jsp";
	private static final String EXTRA_JS   = "/pub/workflow/js/approvalUnitList.js";
	private static final String EXTRA_CSS  = "/pub/workflow/css/approvalUnitList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_APPROVAL_UNIT;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^
	public static final String PRM_TXT_K_CODE		= "txtKCode";
	public static final String PRM_TXT_K_NAME		= "txtKName";
	public static final String PRM_TXT_UNIT_CODE	= "txtUnitCode";

	// tB[h
	public String[][] aryUnit;
	public String[][] aryPltUser;

	private String   txtKCode;
	private String   txtKName;
	private String   txtUnitCode;

	// tB[hyѐ
	public static final String NAM_K_CODE		= CommonConst.NAM_K_CODE;
	public static final String NAM_K_NAME		= CommonConst.NAM_K_NAME;
	public static final String NAM_UNIT_CODE	= CommonConst.NAM_COMMON_CODE;
	public static final String NAM_MAIN		= CommonConst.NAM_APPROVED + CommonConst.NAM_PERSON;
	public static final String NAM_AGENT		= CommonConst.NAM_AGENT;
	public static final String NAM_START_DATE	= CommonConst.NAM_START_DATE;
	public static final int    LEN_CODE		= CommonConst.LEN_K_CODE;
	public static final int    LEN_NAME		= CommonConst.LEN_K_NAME;

	// \[gL[
	public final String KEY_UNIT_CODE	= "keyUnitCode";
	public final String KEY_MAIN		= "keyMain";
	public final String KEY_AGENT		= "keyAgent";
	public final String KEY_START_DATE	= "keyStartDate";

	// [h(0FȂA1F)
	private int searchmode;

	/**
	 * RXgN^
	 */
	public ApprovalUnitListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtKCode	= "";
		txtKName	= "";
		txtUnitCode	= "";
		aryUnit		= new String[0][0];
		setFormerKey(KEY_UNIT_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtKCode	= request.getParameter(PRM_TXT_K_CODE);
		txtKName	= request.getParameter(PRM_TXT_K_NAME);
		txtUnitCode = request.getParameter(PRM_TXT_UNIT_CODE);
	}

	/**
	 * tB[hݒ
	 * @param listUnit jbgXg
	 */
	public void setFields(List listUnit) {
		// Xg̐ݒ
		list = listUnit;
		// f[^̎擾
		count = listUnit.size();
		// z̏
		aryUnit    = new String[count][5];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listUnit.iterator();
		while (it.hasNext()) {
			AmUnitDto dto = (AmUnitDto)it.next();
			aryUnit[i][0] = escapeHTML(dto.getUnitCode());
			aryUnit[i][1] = escapeHTML(getCodeName(dto.getMain(), aryPltUser));
			aryUnit[i][2] = escapeHTML(getCodeName(dto.getAgent(), aryPltUser));
			String[] arDate = util.divideByHyphen(dto.getStartDate(), 2); 
			aryUnit[i][3] = escapeHTML(
					MospUtility.getDateString(util.getDate(arDate[0], arDate[1], arDate[2]),
							CommonConst.FORMAT_DATE_JP_SHORT)
			);
			aryUnit[i][4] = escapeHTML(dto.getStartDate());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[][] getEscAryUnit() { return aryUnit.clone(); }

	public String getTxtKCode()		{ return txtKCode		; }
	public String getTxtKName()		{ return txtKName		; }
	public String getTxtUnitCode()	{ return txtUnitCode	; }

	public String getEscTxtKCode() 		{ return escapeHTML(txtKCode)		; }
	public String getEscTxtKName()		{ return escapeHTML(txtKName)		; }
	public String getEscTxtUnitCode()	{ return escapeHTML(txtUnitCode)	; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
