/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.system.dto.MSyozokuDto;

public class SyozokuMasterListVo extends MosPVo {

	private static final long serialVersionUID = 4493692660345609747L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/system/syozokuMasterList.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/syozokuMasterList.js";
	private static final String EXTRA_CSS  = "/pub/system/css/syozokuMasterList.css";

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_UNIT_MASTER;

	// p[^[
	public static final String PRM_TXT_S_CODE  = "txtSCode";
	public static final String PRM_TXT_S_NAME  = "txtSName";

	// tB[h
	private String[]	arySCode;
	private String[]	arySName;
	private String 	txtSCode;
	private String 	txtSName;

	// tB[hyѐ
	public static final String NAM_S_CODE = CommonConst.NAM_STATION + CommonConst.NAM_COMMON_CODE;
	public static final String NAM_S_NAME = CommonConst.NAM_COMMON_MEISYO;

	public static final int LEN_S_CODE = 6;	
	public static final int LEN_S_NAME = 20;

	// \[gL[
	public final String KEY_S_CODE ="keySCode";
	public final String KEY_S_NAME ="keySName";

	// [h(0FȂA1F)
	private int searchmode;

	public SyozokuMasterListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		arySCode = new String[0];		
		arySName  = new String[0];
		txtSCode = "";		
		txtSName  = "";
		setFormerKey(KEY_S_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtSCode = request.getParameter(PRM_TXT_S_CODE);
		txtSName  = request.getParameter(PRM_TXT_S_NAME);	
	}

	/**
	 * tB[hݒ
	 * @param syozokuList Xg
	 */
	public void setFields(List syozokuList) {
		//Xg̐ݒ
		list = syozokuList;
		//f[^̎擾
		count = syozokuList.size();
		//z̏
		arySCode = new String[count];
		arySName = new String[count];
		//f[^̐ݒ
		int i = 0;
		Iterator it = syozokuList.iterator();
		while (it.hasNext()){
			MSyozokuDto dto = (MSyozokuDto)it.next();
			arySCode[i] = escapeHTML(dto.getSCode());
			arySName[i] = escapeHTML(dto.getSName());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscArySCode() { return arySCode.clone();}
	public String[] getEscArySName (){ return arySName.clone();}

	public String getEscTxtSCode() {return escapeHTML(txtSCode);}
	public String getEscTxtSName() {return escapeHTML(txtSName);}	
	public String getTxtSCode() {return txtSCode;}
	public String getTxtSName() {return txtSName;}	

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
