/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MYakusyokuDao;
import jp.mosp.system.dto.MYakusyokuDto;
import jp.mosp.system.vo.YakusyokuMasterListVo;

public class YakusyokuMasterListAction extends MosPAction {

	private static final String CMD_YAKUSYOKU_MASTER_LIST_SHOW       = "S2200";
	private static final String CMD_YAKUSYOKU_MASTER_LIST_SEARCH     = "S2201";
	private static final String CMD_YAKUSYOKU_MASTER_LIST_RE_SEARCH  = "S2202";
	private static final String CMD_YAKUSYOKU_MASTER_LIST_SORT       = "S2203";

	/**
	 * RXgN^
	 */
	public YakusyokuMasterListAction() {
		super();
	}

	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		// VO̎擾
		YakusyokuMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof YakusyokuMasterListVo) {
			vo = (YakusyokuMasterListVo)obj;
		} else {
			vo = new YakusyokuMasterListVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏		
		if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_SHOW)) {		
			// 敪v_EXg쐬
			vo.aryPltTokyu = util.addArrayFirstRowSpace(getMosPCodeArray(CommonConst.TID_GRADE));
			// lɃZbg	
			vo.setSearchmode(YakusyokuMasterListVo.SEARCH_OFF);			
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_SEARCH)) {
			// 
			vo.setParams(request);
			searchPositionList(vo);
			vo.setFormerKey(vo.KEY_YCODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(YakusyokuMasterListVo.SEARCH_ON);			
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_RE_SEARCH)) {
			// Č
			if (vo.getSearchmode() == YakusyokuMasterListVo.SEARCH_ON) {
				session.removeAttribute(MospConst.ATT_DTO);
				searchPositionList(vo);
				vo.setPageButton();
				sortList(vo);	
			}			
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1, vo);			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * EXg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchPositionList(YakusyokuMasterListVo vo) throws Exception {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(vo.getTxtYCode(), vo.getPltTokyu(), vo.getTxtYName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryYCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}	

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, YakusyokuMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(YakusyokuMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, YakusyokuMasterListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_YCODE)) {
			comp = new CompYCode();
		} else if (key.equals(vo.KEY_YNAME)) {
			comp = new CompYName();
		} else if (key.equals(vo.KEY_TOKYU)) {
			comp = new CompTokyu();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ER[hɂrNX
	 */
	protected static class CompYCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5729849389393964036L;
		public int compare(Object obj1, Object obj2) {
			MYakusyokuDto dto1 = (MYakusyokuDto)obj1;
			MYakusyokuDto dto2 = (MYakusyokuDto)obj2;
			return dto1.getYCode().compareTo(dto2.getYCode());
		}
	}

	/**
	 * ÊɂrNX
	 */
	protected static class CompYName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1765058312562701593L;
		public int compare(Object obj1, Object obj2) {
			MYakusyokuDto dto1 = (MYakusyokuDto)obj1;
			MYakusyokuDto dto2 = (MYakusyokuDto)obj2;
			return dto1.getYName().compareTo(dto2.getYName());
		}
	}

	/**
	 * ɂrNX
	 */
	protected static class CompTokyu implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -3586842444641043500L;
		public int compare(Object obj1, Object obj2) {
			MYakusyokuDto dto1 = (MYakusyokuDto)obj1;
			MYakusyokuDto dto2 = (MYakusyokuDto)obj2;
			return dto1.getTokyu().compareTo(dto2.getTokyu());
		}
	}

}
