/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MYakusyokuDao;
import jp.mosp.system.dto.MYakusyokuDto;
import jp.mosp.system.vo.YakusyokuMasterCardVo;

public class YakusyokuMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_YAKUSYOKU_MASTER_CARD_SHOW   = "S2205";	// \(ǉ)
	private static final String CMD_YAKUSYOKU_MASTER_CARD_SELECT = "S2206";	// \(I)
	private static final String CMD_YAKUSYOKU_MASTER_CARD_INSERT = "S2207";	// o^
	private static final String CMD_YAKUSYOKU_MASTER_CARD_UPDATE = "S2208";	// XV
	private static final String CMD_YAKUSYOKU_MASTER_CARD_DELETE = "S2209";	// 폜

	/**
	 * RXgN^
	 */
	public YakusyokuMasterCardAction() {
		super();
	}

	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		YakusyokuMasterCardVo vo = new YakusyokuMasterCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DAȌ
		MYakusyokuDao dao;
		dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// 敪v_EXg쐬
		vo.aryPltTokyu = getMosPCodeArray(CommonConst.TID_GRADE);
		// E蓖敪v_EXgiL{^Pj쐬
		vo.aryPltExistence1 = getPositionAllowanceType1();
		// E蓖敪v_EXgiL{ŒPj쐬
		vo.aryPltExistence2 = getPositionAllowanceType2();
		// E蓖敪v_EXgiL{^P{ŒPj쐬
		vo.aryPltExistence3 = getPositionAllowanceType3();
		// 蓖̃Xg쐬
		vo.aryAllowance = getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME);
		// DTO̎擾
		MYakusyokuDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MYakusyokuDto ? (MYakusyokuDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_SHOW)) {
			vo.setDefaultValues();
			vo.setMode(YakusyokuMasterCardVo.MODE_INSERT);
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = dao.findForKey(key1, key2);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			setMode(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_UPDATE)) {	
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_DELETE)) {
			// 폜
			delete(vo,dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MYakusyokuDto insert(YakusyokuMasterCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtYCode(), vo.getPltTokyu()), vo);
		// DTȌ
		MYakusyokuDto dto = new MYakusyokuDto();
		vo.setDtoFields(dto);
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		MYakusyokuDto retDto = dao.findForKey(dto.getYCode(), dto.getTokyu());
		chkInsert(retDto);
		// ݂̑mF
		if (!chkExistDto(dao.findForKey(vo.getTxtYCode(), CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE))) {
			MYakusyokuDto nonGradeDto = dto;
			nonGradeDto.setTokyu(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
			// f[^̑}		
			dao.insert(nonGradeDto);
			// DTO̍Ď擾
			nonGradeDto = dao.findForKey(nonGradeDto.getYCode(), nonGradeDto.getTokyu());
			chkInsert(nonGradeDto);
		}
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return retDto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MYakusyokuDto update(YakusyokuMasterCardVo vo, MYakusyokuDto dto) throws Exception {
		// 敪擾
		vo.setPltTokyu(dto.getTokyu());
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtYCode(), vo.getPltTokyu()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MYakusyokuDto retDto = dao.findForKey(dto.getYCode(), dto.getTokyu());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * f[^폜
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @throws Exception
	 */
	private void delete(YakusyokuMasterCardVo vo, MYakusyokuDto dto) throws Exception {
		// 敪擾
		vo.setPltTokyu(dto.getTokyu());
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̍XV
		dao.delete(dto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(YakusyokuMasterCardVo vo) throws Exception {
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(YakusyokuMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(YakusyokuMasterCardVo.MODE_UPDATE);
		}
	}

}
