/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.system.dao.MWorkTypeDao;
import jp.mosp.system.dto.MWorkTypeDto;
import jp.mosp.system.vo.WorkTypeMasterListVo;

public class WorkTypeMasterListAction extends MosPAction {

	// R}h
	private static final String CMD_WORK_TYPE_MASTER_LIST_SHOW      = "S2600";	// \
	private static final String CMD_WORK_TYPE_MASTER_LIST_SELECT    = "S2601";	// 
	private static final String CMD_WORK_TYPE_MASTER_LIST_RE_SEARCH = "S2602";	// Č
	private static final String CMD_WORK_TYPE_MASTER_LIST_SORT      = "S2603";	// \[g

	/**
	 * RXgN^
	 */
	public WorkTypeMasterListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		WorkTypeMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof WorkTypeMasterListVo) {
			vo = (WorkTypeMasterListVo)obj;
		} else {
			vo = new WorkTypeMasterListVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏
		if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_SHOW)) {
			// lɃZbg
			vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
			vo.setSearchmode(WorkTypeMasterListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_SELECT)) {
			// 
			vo.setParams(request);
			searchWorkTypeList(vo);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(WorkTypeMasterListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_RE_SEARCH)) {
			// Č
			if (vo.getSearchmode() == WorkTypeMasterListVo.SEARCH_ON) {
				session.removeAttribute(MospConst.ATT_DTO);
				searchWorkTypeList(vo);
				vo.setPageButton();
				sortList(vo);
			}
		} else if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}		
	}

	/**
	 * Ζ`ԃXg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchWorkTypeList(WorkTypeMasterListVo vo) throws Exception {
		// 
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(vo.getTxtShiftCode(), vo.getTxtShiftName(), vo.getPltDelete()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryShiftCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, WorkTypeMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(WorkTypeMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, WorkTypeMasterListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_SHIFT_CODE)) {
			comp = new CompShiftCode();
		} else if (key.equals(vo.KEY_SHIFT_NAME)) {
			comp = new CompShiftName();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * Ζ`ԂɂrNX
	 */
	protected static class CompShiftName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5911228170558115815L;
		public int compare(Object obj1, Object obj2) {
			MWorkTypeDto dto1 = (MWorkTypeDto)obj1;
			MWorkTypeDto dto2 = (MWorkTypeDto)obj2;
			return dto1.getShiftName().compareTo(dto2.getShiftName());
		}
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompShiftCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 433797660366561035L;
		public int compare(Object obj1, Object obj2) {
			MWorkTypeDto dto1 = (MWorkTypeDto)obj1;
			MWorkTypeDto dto2 = (MWorkTypeDto)obj2;
			return dto1.getShiftCode().compareTo(dto2.getShiftCode());
		}
	}

	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDeleteFlag implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -3859584542003582185L;
		public int compare(Object obj1, Object obj2) {
			MWorkTypeDto dto1 = (MWorkTypeDto)obj1;
			MWorkTypeDto dto2 = (MWorkTypeDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}

}
