/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;

public class AttendanceExportCardVo extends AttendanceCalculateMenuVo {

	private static final long serialVersionUID = -3557453835533294516L;

	// URL
	private static final String RETURN_URL = "/jsp/payroll/attendanceExportCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/js/attendanceExportCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/css/attendanceExportCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.NAM_OUTPUT_ATTENDANCE_LIST;

	// p[^[
	public static final String PRM_PLT_YEAR		= "pltYear";
	public static final String PRM_PLT_MONTH		= "pltMonth";
	public static final String PRM_PLT_SECTION		= "pltSection";

	// tB[h
	private		String	pltYear ;
	private 	String	pltMonth;
	private 	String	pltSection;

	// tB[hyѐ
	public static final String NAM_ATTENDANCE_INFO 	= CommonConst.NAM_ATTENDANCE_TYPE + CommonConst.NAM_INFORMATION;
	public static final String NAM_ATTENDANCE_DATE		= CommonConst.NAM_TARGET_MONTH ;
	public static final String NAM_PLT_SECTION			= CommonConst.NAM_STATION ;

	//v_EXg
	public String[][] aryPltYear ;
	public String[][] aryPltMonth;
	public String[][] aryPltSection;

	/**
	 * RXgN^
	 */
	public AttendanceExportCardVo() {
		super();
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		pltYear		= "";
		pltMonth	= "";
		pltSection	= "";
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		pltYear		= request.getParameter(PRM_PLT_YEAR 	);
		pltMonth	= request.getParameter(PRM_PLT_MONTH 	);
		pltSection	= request.getParameter(PRM_PLT_SECTION	);
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	//ANZTb\h
	public String getPltYear	() { return pltYear		; }
	public String getPltMonth	() { return pltMonth	; }
	public String getPltSection	() { return pltSection	; }

	public void setPltYear		(String pltYear		){ this.pltYear		= pltYear	; }
	public void setPltMonth	(String pltMonth	){ this.pltMonth	= pltMonth	; }	
	public void setPltSection	(String pltSection	){ this.pltSection	= pltSection; }

}
