/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.payment.vo.CompanyCardVo;

public class CompanyCardAction extends PayrollAction {

	// R}h
	private static final String CMD_COMPANY_CARD_SHOW   = "U5248";
	private static final String CMD_COMPANY_CARD_INSERT = "U5249";
	private static final String CMD_COMPANY_CARD_UPDATE = "U5250";

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public CompanyCardAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new CompanyCardVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO擾yѐݒ
		prepareVo();
		CompanyCardVo vo = (CompanyCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// NLv_E쐬
		vo.aryPltFundParticipation = LegalConst.FUND_PARTICIPATION_ARRAY;
		// DTO̎擾
		CmCompanyDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof CmCompanyDto ? (CmCompanyDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_COMPANY_CARD_SHOW)) {
			vo.setTxtComHealthPremiumRate  ("0.0");
			vo.setTxtComNursingPremiumRate ("0.0");
			vo.setTxtComPensionPremiumRate ("0.0");
			vo.setTxtComFundPremiumRate    ("0.0");
			vo.setTxtComUnemployPremiumRate("0.0");
			vo.setTxtHealthPremiumRate  ("0.0");
			vo.setTxtNursingPremiumRate ("0.0");
			vo.setTxtPensionPremiumRate ("0.0");
			vo.setTxtFundPremiumRate    ("0.0");
			vo.setTxtUnemployPremiumRate("0.0");

			// Џ񌟍
			dto = select(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_COMPANY_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_COMPANY_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * f[^
	 * @param vo ΏVO
	 * @return DTO
	 * @throws Exception
	 */
	public CmCompanyDto select(CompanyCardVo vo) throws Exception {
		// DAO
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto dto;
		dto = dao.findAll();
		if (dto == null) {
			// [hݒ
			vo.setMode(CompanyCardVo.MODE_INSERT);	
		} else {
			// f[^̐ݒ
			vo.setFields(dto);
			// [hݒ
			vo.setMode(CompanyCardVo.MODE_UPDATE);	
		}
		return dto;
	}
	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	public CmCompanyDto insert(CompanyCardVo vo) throws Exception {
		// RlNV̎擾yDAȌ
		getConnection();
		// DAO
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto dto = new CmCompanyDto();
		vo.setDtoFields(dto);
		// p[^̑ÓmF
		if (vo.validate()) {
			// ݃`FbN
			chkDuplicate(dao.findForKey(vo.getTxtCompanyCode()), vo);
			vo.setDtoFields(dto);
			// f[^̑}
			dao.insert(dto);
			// DTO̍Ď擾
			dto = dao.findForKey(dto.getCompanyCode());
			// R~bg
			commit();
			// [hݒ
			vo.setMode(CompanyCardVo.MODE_UPDATE);
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		}
		return dto;
	}
	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	public CmCompanyDto update(CompanyCardVo vo, CmCompanyDto dto) throws Exception {
		// RlNV̎擾yDAȌ
		getConnection();
		// DAO
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto retDto = new CmCompanyDto();
		// p[^̑ÓmF
		if (vo.validate()) {
			// rmF
			chkExclusive(dto, dao.findForUpdate(vo.getTxtCompanyCode()), vo);
			// DTȌ
			vo.setDtoFields(dto);
			// f[^̍XV
			dao.update(dto);
			// DTO̍Ď擾
			retDto = dao.findForKey(dto.getCompanyCode());
			// R~bg
			commit();
			// [hݒ
			vo.setMode(CompanyCardVo.MODE_UPDATE);
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
			
		}
		return retDto;
	}
	
}
