/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

import jp.mosp.payroll.dto.MKintaiKinmuDto;

public class MKintaiKinmuDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  = "M_KINTAIKINMU";
	public static final String KEY_1 	= "KCODE";		//ЈR[h
	public static final String KEY_2 	= "SIKYUYM";	//xN
	public static final String KEY_3 	= "KINMU";		//Ζ`

	// 
	public static final String COL_KCODE  	= "KCODE";		//ЈR[h
	public static final String COL_SIKYUYM  	= "SIKYUYM";	//xN
	public static final String COL_KINMU  	= "KINMU";		//Ζ`
	public static final String COL_SNISSU  	= "SNISSU";		//oΓ
	public static final String COL_ZAJIKAN  	= "ZAJIKAN";	//ʎcƎ
	public static final String COL_SZJIKAN  	= "SZJIKAN";	//[cƎ
	public static final String COL_HSJIKAN  	= "HSJIKAN";	//@xoΎ
	public static final String COL_TSJIKAN  	= "TSJIKAN";	//ʏoΎ
	public static final String COL_SYOKUJI  	= "SYOKUJI";	//H蓖x
	public static final String COL_CYOKU1  	= "CYOKU1";		//1蓖x
	public static final String COL_CYOKU2  	= "CYOKU2";		//2蓖x
	public static final String COL_CYOKU3  	= "CYOKU3";		//3蓖x
	public static final String COL_HOKA1  	= "HOKA1";		//̑x1
	public static final String COL_HOKA2  	= "HOKA2";		//̑x2
	public static final String COL_HOKA3 		= "HOKA3";		//̑x3
	public static final String COL_HOKA4  	= "HOKA4";		//̑x4
	public static final String COL_HOKA5  	= "HOKA5";		//̑x5

	/**
	 * RXgN^
	 */
	public MKintaiKinmuDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MKintaiKinmuDto> mappingAll() throws SQLException {
		List<MKintaiKinmuDto> all = new ArrayList<MKintaiKinmuDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_kintaikinmuDto m_kintaikinmuR[h
	 * @throws SQLException
	 */
	private MKintaiKinmuDto mapping() throws SQLException {
		MKintaiKinmuDto dto = new MKintaiKinmuDto();
		dto.setKCode 	(rs.getString (COL_KCODE  	));	//ЈR[h
		dto.setSikyuYM 	(rs.getString (COL_SIKYUYM  ));	//xN
		dto.setKinmu 	(rs.getString (COL_KINMU  	));	//Ζ`
		dto.setSNissu 	(rs.getDouble (COL_SNISSU  	));	//oΓ
		dto.setZaJikan 	(rs.getInt    (COL_ZAJIKAN  ));	//ʎcƎ
		dto.setSZJikan 	(rs.getInt    (COL_SZJIKAN  ));	//[cƎ
		dto.setHSJikan 	(rs.getInt    (COL_HSJIKAN  ));	//@xoΎ
		dto.setTSJikan 	(rs.getInt    (COL_TSJIKAN  ));	//ʏoΎ
		dto.setSyokuji 	(rs.getInt    (COL_SYOKUJI  ));	//H蓖x
		dto.setCyoku1 	(rs.getInt    (COL_CYOKU1  	));	//1蓖x
		dto.setCyoku2 	(rs.getInt    (COL_CYOKU2  	));	//2蓖x
		dto.setCyoku3 	(rs.getInt    (COL_CYOKU3  	));	//3蓖x
		dto.setHoka1 	(rs.getInt    (COL_HOKA1  	));	//̑x1
		dto.setHoka2 	(rs.getInt    (COL_HOKA2  	));	//̑x2
		dto.setHoka3 	(rs.getInt    (COL_HOKA3  	));	//̑x3
		dto.setHoka4 	(rs.getInt    (COL_HOKA4  	));	//̑x4
		dto.setHoka5 	(rs.getInt    (COL_HOKA5  	));	//̑x5

		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @param kinmu Ζ`(L[)
	 * @return m_kintaikinmuDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKintaiKinmuDto findForKey(
			String kcode,
			String sikyuym,
			String kinmu
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			setParam(index++, kinmu);
			executeQuery();
			MKintaiKinmuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @param kinmu Ζ`(L[)
	 * @return m_kintaikinmuDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKintaiKinmuDto findForUpdate(
			String kcode,
			String sikyuym,
			String kinmu
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			setParam(index++, kinmu);
			executeQuery();
			MKintaiKinmuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void findForUpdate(
			String kcode,
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_KCODE  );
			sb.append(" = ? AND ");
			sb.append(COL_SIKYUYM  );
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param sikyuym xN(L[)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void findForUpdate(
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, sikyuym);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param sikyuym xN
	 * @param kinmu Ζ`
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String kcode,
			String sikyuym,
			String kinmu
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE  );
		sb.append(" = ? AND ");
		sb.append(COL_SIKYUYM  );
		sb.append(" = ? AND ");
		sb.append(COL_KINMU  );
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kcode  );
			setParam(index++,   sikyuym   + "%");
			setParam(index++, "%" +   kinmu   + "%");
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}	

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param sikyuym xN
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String kcode,
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE  );
		sb.append(" = ? AND ");
		sb.append(COL_SIKYUYM  );
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kcode  );
			setParam(index++,   sikyuym);
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param sikyuym xN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SIKYUYM);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   sikyuym);
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKintaiKinmuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param aryDto	}ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKintaiKinmuDto[] aryDto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append("(");
			Field[] fields = getClass().getFields();
			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				String name = field.getName();
				if (name.indexOf("COL_") == 0) {
					sb.append(field.get(null));
					sb.append(", ");
				}
			}
			if (!INSERT_DATE.equals("")) {
				sb.append(INSERT_DATE + ", ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append(INSERT_USER + ", ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + ", ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + ", ");
			}
			sb.delete(sb.length() - 2, sb.length() - 1);
			sb.append(") VALUES");
			for (int a = 0; a < aryDto.length; a++) {
				sb.append("(");
				for (int i = 0; i < fields.length; i++) {
					Field field = fields[i];
					String name = field.getName();
					if (name.indexOf("COL_") == 0) {
						sb.append("?, ");
					}
				}
				if (!INSERT_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!INSERT_USER.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_USER.equals("")) {
					sb.append("?, ");
				}
				sb.delete(sb.length() - 2, sb.length());
				sb.append("),");
			}
			sb.delete(sb.length() - 1, sb.length());
			prepareStatement(sb.toString());
			for (int d = 0; d < aryDto.length; d++) {
				setParams(aryDto[d],true);
			}
			executeUpdate();
			chkInsert(aryDto.length);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MKintaiKinmuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			setParam(index++, dto.getKinmu());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MKintaiKinmuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			setParam(index++, dto.getKinmu());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param aryKcode XVΏKcode
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(String[] aryKcode, String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE (");
			for (int i = 0; i < aryKcode.length; i++) {
				sb.append(COL_KCODE);
				sb.append(" = ? OR ");
			}
			sb.delete(sb.length() - 4, sb.length());
			sb.append(") AND ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ?");
			prepareStatement(sb.toString());
			for (int d = 0; d < aryKcode.length; d++) {
				setParam(index++, aryKcode[d]);
			}
			setParam(index++, sikyuYM);
			executeUpdate();
//			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param sikyuYM	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" ");
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM  );
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, sikyuYM);
			executeUpdate();
			//chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param kCode XVЈR[h
	 * @param sikyuYM	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(String kCode, String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" ");
			sb.append("WHERE ");
			sb.append(COL_KCODE  );
			sb.append(" = ? AND ");
			sb.append(COL_SIKYUYM  );
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			setParam(index++, sikyuYM);
			executeUpdate();
			//chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MKintaiKinmuDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());		//ЈR[h
		setParam(index++, dto.getSikyuYM());	//xN
		setParam(index++, dto.getKinmu());		//Ζ`
		setParam(index++, dto.getSNissu());		//oΓ
		setParam(index++, dto.getZaJikan());	//ʎcƎ
		setParam(index++, dto.getSZJikan());	//[cƎ
		setParam(index++, dto.getHSJikan());	//@xoΎ
		setParam(index++, dto.getTSJikan());	//ʏoΎ
		setParam(index++, dto.getSyokuji());	//H蓖x
		setParam(index++, dto.getCyoku1());		//1蓖x
		setParam(index++, dto.getCyoku2());		//2蓖x
		setParam(index++, dto.getCyoku3());		//3蓖x
		setParam(index++, dto.getHoka1());		//̑x1
		setParam(index++, dto.getHoka2());		//̑x2
		setParam(index++, dto.getHoka3());		//̑x3
		setParam(index++, dto.getHoka4());		//̑x4
		setParam(index++, dto.getHoka5());		//̑x5
		setCommonParams(isInsert);
	}

	/**
	 * e[ubN
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void tableLock(String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * e[ubN
	 * @param	kCode	ЈR[h
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void tableLock(String kCode, String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(kCode, sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * e[ubN
	 * @param	aryKCode	ЈR[h
	 * @param 	sikyuYM		XVΏ۔N
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void tableLock(String[] aryKCode, String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				for (int i = 0; i < aryKCode.length; i++) {
					findForUpdate(aryKCode[i], sikyuYM);
				}
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
}
