/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;


import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.CalculateAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.PhPaymentDto;

public class AdjustmentReferVo extends AdjustmentListVo  {
	
	private static final long serialVersionUID = 8773622645784195759L;
	
	// URLACSS
	private static final String RETURN_URL = "/jsp/payroll/common/adjustmentRefer.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/common/js/adjustmentRefer.js";
	private static final String EXTRA_CSS  = "/pub/payroll/common/css/adjustmentRefer.css";
	
	// ʃTu^Cg
	public final String SUB_TITLE = PayrollConst.NAM_WITHHOLD_BOOK;

 	public final String CMD_MENU_PAYROLL = "P1910";	
	
	// tB[hyѐ
	public static final String PRM_TXT_CHANGE_K_CODE    = "txtChangeKCode";
	public static final String PRM_LBL_CHANGE_K_CODE    = "lblChangeKCode";
	public static final String PRM_HID_ADJUST_YEAR      = "hidAdjustYear" ;
	public static final String PRM_HID_K_CODE           = "hidKCode"      ;
	public static final String PRM_HID_FAMILY_INFO      = "hidFamilyInfo" ;

	
	// ̎擾pz
	public String[][] aryStation ;
	public String[][] aryPosition;
	public String[][] aryEra;
	public String[][] aryRelation;
	public String[][] aryGender  ;

	// ݒe[u
	public List<MosPConfDto> listConf;

	private int    cntPayment         ;
	private int    cntBonus           ;

	// tB[h
	private String lblChangeKCode        ;
	private int    hidAdjustYear         ;
	private String hidKCode              ;
	private String lblKName              ;
	private String lblStationCode        ;
	private String lblStationName        ;
	private String lblPositionCode       ;
	private String lblPositionName       ;
	private String lblEntranceDate       ;
	private String lblAdjustStatus       ;
	
	private String lblSelfSpHandi;
	private String lblSelfHandicap;
	private String lblSelfSpWidow;
	private String lblSelfWidow;
	private String lblSelfStudentType  ;
	


	/* }{T{l */
	private String lblSpHandicap;
	private String lblGeHandicap;
	private String lblGeWidow;
	private String lblSpWidow;
	private String lblWidow;
	private String lblStudentGeneral;
	/* }{Tzҍ */
	private String lblLwSpHandiEl;
	private String lblLwSpHandicap;
	private String lblSpouseEl;
	private String lblSpouseGe;
	
		

	
	private String lblGeneralDependent ;
	private String lblSpecificDependent;
	private String lblElderlyDependent ;
	private String lblLiveWithEldRel   ;
	private String lblLiveWithHandiGe  ;
	private String lblLiveWithHandiSp  ;
	private String lblLiveWithHandiEl  ;
	private String lblLiveWithHandiEr  ;
	private String lblGeneralHandicap  ;
	private String lblSpecificHandicap ;
	
	private String lblMidwayType       ;
	private String lblFormerIncome     ;
	private String lblFormerInsurance  ;
	private String lblFormerTax        ;

	private String[] lblPaymentMonth     ;
	private String[] lblPaymentPayDay    ;
	private String[] lblPayTotalAllowance;
	private String[] lblPayTaxFree; 
	private String[] lblPayTaxation;				// ېŎxz
	private String[] lblPaySocInsDeduction;
	private String[] lblPayPayInsDeduction;
	private String[] lblPayIncomeTax;
	private String[] lblPayAdjCalcGap         ;	// Nɂߕs
	private String[] lblPayVariousDeduction;
	private String[] lblPayPaymentTotal;
	private String[] lblPayDependentCount;
	private String[] lblBonusMonth       ;
	private String[] lblBonusPayDay      ;
	private String[] lblBonTotalAllowance;
	private String[] lblBonTaxFree;
	private String[] lblBonTaxation;
	private String[] lblBonSocInsDeduction;
	private String[] lblBonPayInsDeduction;
	private String[] lblBonIncomeTax;
	private String[] lblBonVariousDeduction;
	private String[] lblBonPaymentTotal;
	private String[] lblBonDependentCount;
	private String[] lblBonAdjCalcGap         ;	// Nɂߕs


	private String lblTotalAllowance;
	private String lblTaxFree;
	private String lblTaxation;
	private String lblSocInsDeduction;
	private String lblTotalPayInsDeduction;
	private String lblIncomeTax;
	private String lblVariousDeduction;
	private String lblPaymentTotal;
	
	
	private String    lblGeneralLifeIns     ;	// ʂ̐ی
	private String    lblPrivatePension     ;	// lNی
	private String    lblLifeInsDeduction   ;	// یTz
	private String    lbLearthquakeIns      ;	// nkی
	private String    lblLongTermDamageIns  ;	// Qی
	private String    lblDamageInsDeduction ;	// QیTz
	private String    lblSocialInsDeduction ;	// ЉیTz
	private String    lblMutualAidDeduction ;	// K͊Ƌϓ|Tz
	private String    lblSpouseSumIncome    ;	// z҂̖{N̍vžϊz
	private String    lblSpouseSpDeduction  ;	// zғʍTz
	private String    lblHouseLoanDeduction ;	// ZؓʍTz
	private String    lblAllowanceAdjustment;	// xz
	private String    lblTaxFreeAdjustment  ;	// ېŒz
	private String    lblSocInsAdjustment   ;	// Љیz
	private String    lblTaxIncAdjustment   ;	// Œz
	private String   lblWithholdSlipNotes  ;	// 򒥎[Ev
	private String    lblPaymentAllowance   ;	// ^A蓖z
	private String    lblPaymentIncomeTax   ;	// ^A蓖Ŋz
	private String    lblBonusAllowance     ;	// ܗ^z
	private String    lblBonusIncomeTax     ;	// ܗ^Ŋz
	private String    lblMidwayAdjustIncome ;	// rAz
	private String    lblMidwayAdjustTax    ;	// rAŊz
	private String    lblAfterDeductIncome  ;	// ^T̋^̋z
	private String    lblPayInsDeduction    ;	// Љی^̍T
	private String    lblDependentsDeduction;	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	private String    lblCalcTaxedIncome    ;	// ېŋ^z
	private String    lblCalcIncomeTax      ;	// ZoNŊz
	private String    lblAdjustedIncomeTax  ;	// NNŊz
	private String    lblDeductedIncomeTax  ;	// N藦TzŊz
	private String    lblFinalIncomeTax     ;	// NŊz
	private String    lblIncomeDeductSum    ;	// Tzv
	private String    lblTaxGap    		 ;	// Ŋz擾
	
	private String    lblAdjTotalAllowance  ;	// xzv
	private String    lblAdjTotalIncome     ;	// Ŋzv
	
	private String lblIncomeTaxType    ;
	private String lblAdjustmentType   ;
	
	private String lblPostalCode     ;			// X֔ԍ
	private String lblAddress        ;			// Z
	private String lblBirthDate      ;			// N
	
	/**
	 * RXgN^
	 */
	public AdjustmentReferVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		lblPaymentMonth        = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPaymentPayDay       = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayTotalAllowance   = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayTaxFree          = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayTaxation         = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPaySocInsDeduction  = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayPayInsDeduction  = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayIncomeTax        = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayAdjCalcGap       = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayVariousDeduction = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayPaymentTotal     = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblPayDependentCount   = new String[PayrollConst.CNT_ADJ_PAYMENT_MONTH];
		lblBonusMonth          = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonusPayDay         = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonTotalAllowance   = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonTaxFree          = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonTaxation         = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonSocInsDeduction  = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonPayInsDeduction  = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonIncomeTax        = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonAdjCalcGap       = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonVariousDeduction = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonPaymentTotal     = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
		lblBonDependentCount   = new String[PayrollConst.CNT_ADJ_BONUS_MONTH];
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	/*
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = SUB_TITLE;
		addAryMenu("P1001", getName("P_PAYMENT") +
				getName("P_CALCULATE") + getName("C_MENU") + getName("C_TO"));
	}
*/	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		lblChangeKCode = request.getParameter(PRM_TXT_CHANGE_K_CODE);
		hidAdjustYear  = getIntParam(request.getParameter(PRM_HID_ADJUST_YEAR));
		hidKCode       = request.getParameter(PRM_HID_K_CODE);
	}
	
	/**
	 * tB[hݒ(Nf[^)
	 * @param uhBasisDto       tB[h擾ΏDTO
	 * @param cmIncomeTaxDto   tB[h擾ΏDTO
	 * @param cmMidwayEnterDto tB[h擾ΏDTO
	 * @param listFamily       tB[h擾ΏۃXg
	 * @throws MospException 
	 */
	public void setFields(CdAdjustmentDto cdAdjustmentDto) {
		if (cdAdjustmentDto != null) {
			lblAdjustStatus = getCodeName(cdAdjustmentDto.getAdjustStatus(), PayrollConst.getAdjuStatusArray());
		    lblGeneralLifeIns    = insertComma(String.valueOf(cdAdjustmentDto.getGeneralLifeIns     ()));
		    lblPrivatePension    = insertComma( String.valueOf(cdAdjustmentDto.getPrivatePension     ()));
		    lblLifeInsDeduction  = insertComma( String.valueOf(cdAdjustmentDto.getLifeInsDeduction   ()));
		    lbLearthquakeIns     = insertComma( String.valueOf(cdAdjustmentDto.getEarthquakeIns      ()));
		    lblLongTermDamageIns = insertComma( String.valueOf(cdAdjustmentDto.getLongTermDamageIns  ()));
		    lblDamageInsDeduction= insertComma( String.valueOf(cdAdjustmentDto.getDamageInsDeduction ()));
		    lblSocialInsDeduction= insertComma( String.valueOf(cdAdjustmentDto.getSocialInsDeduction ()));
		    lblMutualAidDeduction= insertComma( String.valueOf(cdAdjustmentDto.getMutualAidDeduction ()));
		    lblSpouseSumIncome   = insertComma( String.valueOf(cdAdjustmentDto.getSpouseSumIncome    ()));
		    lblSpouseSpDeduction = insertComma( String.valueOf(cdAdjustmentDto.getSpouseSpDeduction  ()));
		    lblHouseLoanDeduction= insertComma( String.valueOf(cdAdjustmentDto.getHouseLoanDeduction ()));
		    lblAllowanceAdjustment= insertComma( String.valueOf(cdAdjustmentDto.getAllowanceAdjustment()));
		    lblTaxFreeAdjustment = insertComma( String.valueOf(cdAdjustmentDto.getTaxFreeAdjustment  ()));
		    lblSocInsAdjustment  = insertComma( String.valueOf(cdAdjustmentDto.getSocInsAdjustment   ()));
		    lblTaxIncAdjustment  = insertComma( String.valueOf(cdAdjustmentDto.getTaxIncAdjustment   ()));
		    lblWithholdSlipNotes = insertComma( String.valueOf(cdAdjustmentDto.getWithholdSlipNotes  ()));
		    lblPaymentAllowance  = insertComma( String.valueOf(cdAdjustmentDto.getPaymentAllowance   ()));
		    lblPaymentIncomeTax  = insertComma( String.valueOf(cdAdjustmentDto.getPaymentIncomeTax   ()));
		    lblBonusAllowance    = insertComma( String.valueOf(cdAdjustmentDto.getBonusAllowance     ()));
		    lblBonusIncomeTax    = insertComma( String.valueOf(cdAdjustmentDto.getBonusIncomeTax     ()));
		    lblMidwayAdjustIncome= insertComma( String.valueOf(cdAdjustmentDto.getMidwayAdjustIncome ()));
		    lblMidwayAdjustTax   = insertComma( String.valueOf(cdAdjustmentDto.getMidwayAdjustTax    ()));
		    lblAfterDeductIncome = insertComma( String.valueOf(cdAdjustmentDto.getAfterDeductIncome  ()));
		    lblPayInsDeduction   = insertComma( String.valueOf(cdAdjustmentDto.getPayInsDeduction    ()));
		    lblDependentsDeduction= insertComma( String.valueOf(cdAdjustmentDto.getDependentsDeduction()));
		    lblCalcTaxedIncome   = insertComma( String.valueOf(cdAdjustmentDto.getCalcTaxedIncome    ()));
		    lblCalcIncomeTax     = insertComma( String.valueOf(cdAdjustmentDto.getCalcIncomeTax      ()));
		    lblAdjustedIncomeTax = insertComma( String.valueOf(cdAdjustmentDto.getAdjustedIncomeTax  ()));
		    lblDeductedIncomeTax = insertComma( String.valueOf(cdAdjustmentDto.getDeductedIncomeTax  ()));
		    lblFinalIncomeTax    = insertComma( String.valueOf(cdAdjustmentDto.getFinalIncomeTax     ()));
		    lblIncomeDeductSum    = insertComma( String.valueOf(cdAdjustmentDto.getIncomeDeductSum    ()));
		    lblTaxGap    = insertComma( String.valueOf(cdAdjustmentDto.getTaxGap()));
		    lblAdjTotalAllowance = insertComma( String.valueOf(cdAdjustmentDto.getTaxedPaymentSum()));
		    lblAdjTotalIncome    = insertComma( String.valueOf(cdAdjustmentDto.getIncomeTaxSum   ()));
		} else {
			// Nf[^݂Ȃꍇ̓f[^쐬
			lblAdjustStatus = PayrollConst.ADJU_STATUS_NON_NAME;
		}

	}
	
	/**
	 * tB[hݒ(^Aܗ^)
	 * @param listPaymentData	tB[h擾Ώۋ^DTOXg
	 * @param pdPayDeductionDao	tB[hZŎ擾pDAOi^׃f[^j
	 * @param listBonusData		tB[h擾Ώۏܗ^DTOXg
	 * @param currentPayDto		tB[h擾Ώۋ^DTO
	 * @param currentBonDto		tB[h擾Ώۏܗ^DTO
	 * @param cdAdjustmentDto	tB[h擾Ώ۔NDTO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	public void setFields(
			List<PhPaymentDto> listPaymentData,
			List<PhBounsDto> listBonusData,
			PdPayDeductionDao pdPayDeductionDao, 
			PhPaymentDto   currentPayDto,
			PhBounsDto     currentBonDto,
			CdAdjustmentDto cdAdjustmentDto
	) throws SQLException, NoSuchFieldException, IllegalAccessException {

		DetailMoneyDto pdPayDeductionDto;		
		cntPayment = listPaymentData.size();
		cntBonus   = listBonusData.size();
		
		int totalAllowance		= 0;
		int taxFree				= 0;
		int taxation			= 0;
		int socInsDeduction		= 0;
		int payInsDeduction		= 0;
		int incomeTax			= 0;
		int variousDeduction	= 0;
		int paymentTotal		= 0;
		int restax_tmp			= 0; // ZŎ擾p
		
		for (int i = 0; i < PayrollConst.CNT_ADJ_PAYMENT_MONTH; i++) {
			if (i < listPaymentData.size()) {
				PhPaymentDto phPaymentDto =	listPaymentData.get(i);
				lblPaymentMonth       [i] = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
				lblPaymentPayDay      [i] = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
				lblPayTotalAllowance  [i] = String.valueOf(phPaymentDto.getAllowanceTotal   ());
				lblPayTaxFree         [i] = String.valueOf(phPaymentDto.getTaxExempt        ());
				lblPayTaxation        [i] = String.valueOf(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
				lblPaySocInsDeduction [i] = String.valueOf(phPaymentDto.getSocInsTotal ());
				lblPayPayInsDeduction [i] = String.valueOf(phPaymentDto.getAmountToTaxation ());
				lblPayDependentCount  [i] = String.valueOf(phPaymentDto.getDependent   ());
				
				// Őݒ
				lblPayIncomeTax           [i] = String.valueOf(phPaymentDto.getIncomeTax        ());
				lblPayAdjCalcGap          [i] = "";
				if (currentPayDto != null) {
					if (currentPayDto.getCalcMonth().compareTo(phPaymentDto.getCalcMonth()) == 0) {
						if (cdAdjustmentDto != null) {
							lblPayAdjCalcGap  [i] = String.valueOf(cdAdjustmentDto.getTaxGap ());
						} else {
							lblPayAdjCalcGap  [i] = "";
						}
					}
				}

				//ZŎ擾
				restax_tmp = 0; 
					pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
							phPaymentDto.getKCode(),
							phPaymentDto.getCalcMonth(),
							PayrollConst.DTL_RESIDENCE_TAX);
					if(pdPayDeductionDto != null){
						restax_tmp = pdPayDeductionDto.getAmount();
					}
				lblPayVariousDeduction[i] = String.valueOf(
						// Tz = Tz|Ŋz|ZŁ|Љی
						phPaymentDto.getDeductionTotal() - 	phPaymentDto.getIncomeTax() - restax_tmp  - phPaymentDto.getSocInsTotal());
				lblPayPaymentTotal    [i] = String.valueOf(phPaymentDto.getPaymentTotal     ());
				
				// vlݒ
				totalAllowance   += getIntParam(lblPayTotalAllowance  [i]);
				taxFree          += getIntParam(lblPayTaxFree         [i]);
				taxation         += getIntParam(lblPayTaxation        [i]);
				socInsDeduction  += getIntParam(lblPaySocInsDeduction [i]);
				payInsDeduction  += getIntParam(lblPayPayInsDeduction [i]);
				incomeTax        += getIntParam(lblPayIncomeTax       [i]);
				variousDeduction += getIntParam(lblPayVariousDeduction[i]);
				paymentTotal     += getIntParam(lblPayPaymentTotal    [i]);
			} else {
				lblPaymentMonth       [i] = "";
				lblPaymentPayDay      [i] = "";
				lblPayTotalAllowance  [i] = "";
				lblPayTaxFree         [i] = "";
				lblPayTaxation        [i] = "";
				lblPaySocInsDeduction [i] = "";
				lblPayPayInsDeduction [i] = "";
				lblPayDependentCount  [i] = ""; 
				lblPayIncomeTax       [i] = "";
				lblPayAdjCalcGap      [i] = "";
				lblPayVariousDeduction[i] = "";
				lblPayPaymentTotal    [i] = "";
			}
		}

		for (int i = 0; i < PayrollConst.CNT_ADJ_BONUS_MONTH; i++) {
			if (i < listBonusData.size()) {
				PhBounsDto udBonusDto =	listBonusData.get(i);
				lblBonusMonth         [i] = String.valueOf(MospUtility.getMonth(udBonusDto.getPayDate()));
				lblBonusPayDay        [i] = String.valueOf(MospUtility.getDay  (udBonusDto.getPayDate()));
				lblBonTotalAllowance  [i] = String.valueOf(udBonusDto.getAllowanceTotal             ());
				lblBonTaxFree         [i] = String.valueOf(0                                          );
				lblBonTaxation        [i] = String.valueOf(udBonusDto.getAllowanceTotal             ());
				lblBonSocInsDeduction [i] = String.valueOf(udBonusDto.getSocInsTotal());
				//lblBonPayInsDeduction [i] = String.valueOf(udBonusDto.getAllowanceTotal() - udBonusDto.calcBonusSocialInsurance());
				lblBonPayInsDeduction [i] = String.valueOf(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
				lblBonDependentCount  [i] = String.valueOf(udBonusDto.getDependent());
				
				// Őݒ
				lblBonIncomeTax       [i] = String.valueOf(udBonusDto.getIncomeTax         ());
				lblBonAdjCalcGap      [i] = "";
				if (currentBonDto != null) {
					if (currentBonDto.getPayDate().compareTo(udBonusDto.getPayDate()) == 0) {
						lblBonIncomeTax [i] = String.valueOf(currentBonDto.getIncomeTax());
						if (cdAdjustmentDto != null) {
							lblBonAdjCalcGap[i] = String.valueOf(cdAdjustmentDto.getTaxGap ());
						} else {
							lblBonAdjCalcGap[i] = "";
						}
					}
				}
//				lblBonVariousDeduction[i] = String.valueOf(udBonusDto.   .  calcBonusGenaralDeduction());
				// Tz = Tz|Ŋz|ZŁ|Љی
				lblBonVariousDeduction[i] = String.valueOf(
						udBonusDto.getDeductionTotal() - udBonusDto.getIncomeTax()  - udBonusDto.getSocInsTotal());
				
				lblBonPaymentTotal    [i] = String.valueOf(udBonusDto.getPaymentTotal          ());
				
				// vlݒ
				totalAllowance   += getIntParam(lblBonTotalAllowance  [i]);
				taxFree          += 0;
				taxation         += getIntParam(lblBonTaxation        [i]);
				socInsDeduction  += getIntParam(lblBonSocInsDeduction [i]);
				payInsDeduction  += getIntParam(lblBonPayInsDeduction [i]);
				incomeTax        += getIntParam(lblBonIncomeTax       [i]);
				variousDeduction += getIntParam(lblBonVariousDeduction[i]);
				paymentTotal     += getIntParam(lblBonPaymentTotal    [i]);
			} else {
				lblBonusMonth         [i] = "";
				lblBonusPayDay        [i] = "";
				lblBonTotalAllowance  [i] = "";
				lblBonTaxFree         [i] = "";
				lblBonTaxation        [i] = "";
				lblBonSocInsDeduction [i] = "";
				lblBonPayInsDeduction [i] = "";
				lblBonDependentCount  [i] = ""; 
				lblBonIncomeTax       [i] = "";
				lblBonAdjCalcGap      [i] = "";
				lblBonVariousDeduction[i] = "";
				lblBonPaymentTotal    [i] = "";
			}
		}
		
		 lblTotalAllowance   = String.valueOf(totalAllowance);
		 lblTaxFree          = String.valueOf(taxFree);
		 lblTaxation         = String.valueOf(taxation);
		 lblSocInsDeduction  = String.valueOf(socInsDeduction);
		 lblTotalPayInsDeduction  = String.valueOf(payInsDeduction);
		 lblIncomeTax        = String.valueOf(incomeTax);
		 lblVariousDeduction = String.valueOf(variousDeduction);
		 lblPaymentTotal     = String.valueOf(paymentTotal);

	}
	
	/**
	 * tB[hݒ
	 * @param uhBasisDto       tB[h擾ΏDTO
	 * @param cmIncomeTaxDto   tB[h擾ΏDTO
	 * @param cmMidwayEnterDto tB[h擾ΏDTO
	 * @param listFamily       tB[h擾ΏۃXg
	 * @throws MospException 
	 */
	public void setFields(
			MKihonDto			mKihonDto      ,
			CmIncomeTaxDto		cmIncomeTaxDto  ,
			CmMidwayEnterDto	cmMidwayEnterDto,
			MKojinDto			mKojinDto      
	) throws MospException {
		// f[^̐ݒ
		if (mKihonDto != null) {
			lblChangeKCode  = mKihonDto.getKCode       ();
			hidKCode        = mKihonDto.getKCode       ();
			lblKName        = mKihonDto.getSimei();
			lblStationCode  = mKihonDto.getSCode();
			lblStationName  = getCodeName(lblStationCode, aryStation);
			lblPositionCode = mKihonDto.getYCode();
			lblPositionName = getCodeName(lblPositionCode, aryPosition);
			lblEntranceDate = getDateString(listConf, aryEra, 
					DatePart.convIntegerDateToDate(mKihonDto.getNyDate()));
		}
		
		// {l敪ĔfAX^XNݒ		
		if (cmIncomeTaxDto != null) {
			String handicapType     = cmIncomeTaxDto.getSelfHandicapType();
			String widowType   = cmIncomeTaxDto.getSelfWidowType();
			String studentType = cmIncomeTaxDto.getSelfStudentType();

			if (handicapType.equals(LegalConst.HANDICAP_GENERAL)) {
				// ʏQ
				lblGeHandicap = PayrollConst.ADJ_APPLICABLE;
			} else if (handicapType.equals(LegalConst.HANDICAP_SPECIAL)) {
				// ʏQ
				lblSpHandicap = PayrollConst.ADJ_APPLICABLE;
			}
			// Ǖw(v)̏ꍇ͐ʂŔfĐݒAݒȂ̏ꍇ͈ʉǕw
			if (widowType.equals(LegalConst.WIDOW_GENERAL)) {
				lblWidow = PayrollConst.ADJ_APPLICABLE; // ݂͉Ǖvivĵ
				/* 
					// DTOmF
				   	if (mKojinDto != null) {
				  		String gender = mKojinDto.getGender();
				  		// Ǖv
						if (gender.equals(aryGender[0][0])) {
							lblWidow = PayrollConst.ADJ_APPLICABLE;
						}
						// ʉǕw
						if (gender.equals(aryGender[1][0])) {
							lblGeWidow = PayrollConst.ADJ_APPLICABLE;
						
						} else {
						// ʂ̐ݒ肪Ȃꍇ͈ʉǕwɐݒ
						lblGeWidow = PayrollConst.ADJ_APPLICABLE; 
					}
				*/
			} else if (widowType.equals(LegalConst.WIDOW_SPECIAL)) {
				// ʉǕw
				lblSpWidow = PayrollConst.ADJ_APPLICABLE;
			}
			// {l敪ΘJw
			if (studentType.equals(LegalConst.STUDENT_GENERAL)) {
				lblStudentGeneral = PayrollConst.ADJ_APPLICABLE;
			}
			lblIncomeTaxType     = getCodeName(cmIncomeTaxDto.getIncomeTaxType   (), LegalConst.INCOME_TAX_ARRAY   );
			lblAdjustmentType    = getCodeName(cmIncomeTaxDto.getAdjustmentType  (), LegalConst.ADJUSTMENT_ARRAY   );

			String spouseType = cmIncomeTaxDto.getSpouseIntendType();
			// zҋ敪ʏQҘVl
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_LWSH_EL)) {
				lblLwSpHandiEl = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪ʏQ
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_LWSH)) {
				lblLwSpHandicap = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪Vlz
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_ELDERLY)) {
				lblSpouseEl = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪Vlz
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_GENERAL)) {
				lblSpouseGe = PayrollConst.ADJ_APPLICABLE;
			}
			
			lblSelfStudentType   = getCodeName(cmIncomeTaxDto.getSelfStudentType (), LegalConst.STUDENT_ARRAY      );
			lblGeneralDependent  = cmIncomeTaxDto.getGeneralDependent () + PayrollConst.NAM_COMMON_CNT1;
			lblSpecificDependent = cmIncomeTaxDto.getSpecificDependent() + PayrollConst.NAM_COMMON_CNT1;
			lblElderlyDependent  = cmIncomeTaxDto.getElderlyDependent () + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithEldRel    = cmIncomeTaxDto.getLiveWithEldRel   () + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiGe   = cmIncomeTaxDto.getLiveWithHandiGe  () + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiSp   = cmIncomeTaxDto.getLiveWithHandiSp  () + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiEl   = cmIncomeTaxDto.getLiveWithHandiEl  () + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiEr   = cmIncomeTaxDto.getLiveWithHandiEr  () + PayrollConst.NAM_COMMON_CNT1;
			lblGeneralHandicap   = cmIncomeTaxDto.getGeneralHandicap  () + PayrollConst.NAM_COMMON_CNT1;
			lblSpecificHandicap  = cmIncomeTaxDto.getSpecificHandicap () + PayrollConst.NAM_COMMON_CNT1;
		}
		lblMidwayType      = "";
		lblFormerIncome    = "";
		lblFormerInsurance = "";
		lblFormerTax       = "";
		if (cmMidwayEnterDto != null) {
			if (mKihonDto != null) {
				if (mKihonDto.getNyDate() != 0) {
					// ГΏ۔N
					if (MospUtility.getYear(DatePart.convIntegerDateToDate(mKihonDto.getNyDate())) == hidAdjustYear) {
						// rЋ敪urЁvłꍇAzݒ
						if (cmMidwayEnterDto.getMidwayType().equals(LegalConst.MIDWAY_ENTER)) {
							lblMidwayType      = getCodeName(cmMidwayEnterDto.getMidwayType(), LegalConst.MIDWAY_ENTER_ARRAY);
							lblFormerIncome    = String.valueOf(cmMidwayEnterDto.getFormerIncome   ());
							lblFormerInsurance = String.valueOf(cmMidwayEnterDto.getFormerInsurance());
							lblFormerTax       = String.valueOf(cmMidwayEnterDto.getFormerTax      ());
						}
					}
				}
			}
		}
		if (mKojinDto != null) {
			lblAddress    = CalculateAction.getPrefecture(mKojinDto.getPrefectures()) + mKojinDto.getJyuusyo1() + mKojinDto.getJyuusyo2() + mKojinDto.getJyuusyo3();
			lblBirthDate  = getDateString(listConf, aryEra, DatePart.convIntegerDateToDate(mKojinDto.getSeinenbi()));
			lblPostalCode = mKojinDto.getYubinban();
		}
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	/**
	 * t擾(a)
	 * @param list a񃊃Xg
	 * @param date 
	 * @return t
	 * @throws MospException
	 */
	protected String getDateString(List<MosPConfDto> list, String[][] aryEra, Date date) throws MospException {
		if (date == null || list == null) {
			return "";
		}
		String[] strDate = getJpImperialCal(list, date);
		strDate[0] = getCodeName(strDate[0], aryEra);
		for (int i = 1; i < strDate.length; i++) {
			strDate[i] = strDate[i].length() < 2 ? PayrollConst.SUPPRESS_DATE + strDate[i] : strDate[i];
		}
		return strDate[0] + strDate[1] + PayrollConst.NAM_YEAR +
				strDate[2] + PayrollConst.NAM_MONTH + strDate[3] + PayrollConst.NAM_DAY;
	}
	
	// ANZT\bh
	public String getLblChangeKCode    () { return escapeHTML(lblChangeKCode ); }
	public int    getHidAdjustYear     () { return hidAdjustYear ; }
	public String getHidKCode          () { return escapeHTML(hidKCode       ); }
	public String getEscLblChangeKCode () { return escapeHTML(lblChangeKCode ); }
	public String getEscHidKCode       () { return escapeHTML(hidKCode       ); }
	public String getEscLblKName       () { return escapeHTML(lblKName       ); }
	public String getEscLblStationCode () { return escapeHTML(lblStationCode ); }
	public String getEscLblStationName () { return escapeHTML(lblStationName ); }
	public String getEscLblPositionCode() { return escapeHTML(lblPositionCode); }
	public String getEscLblPositionName() { return escapeHTML(lblPositionName); }
	public String getEsclblEntranceDate() { return escapeHTML(lblEntranceDate); }
	public String getEscLblAdjustStatus() { return escapeHTML(lblAdjustStatus); }
	
	public String getLblPaymentMonth        (int i) { return  escapeHTML(lblPaymentMonth       [i] ); }
	public String getLblPaymentPayDay       (int i) { return  escapeHTML(lblPaymentPayDay      [i] ); }
	public String getLblPayTotalAllowance   (int i) { return  escapeHTML(insertComma(lblPayTotalAllowance  [i] )); }
	public String getLblPayTaxFree          (int i) { return  escapeHTML(insertComma(lblPayTaxFree         [i] )); }
	public String getLblPayTaxation         (int i) { return  escapeHTML(insertComma(lblPayTaxation        [i] )); }
	public String getLblPaySocInsDeduction  (int i) { return  escapeHTML(insertComma(lblPaySocInsDeduction [i] )); }
	public String getLblPayPayInsDeduction  (int i) { return  escapeHTML(insertComma(lblPayPayInsDeduction [i] )); }
	public String getLblPayIncomeTax        (int i) { return  escapeHTML(insertComma(lblPayIncomeTax       [i] )); }
	public String getLblPayVariousDeduction (int i) { return  escapeHTML(insertComma(lblPayVariousDeduction[i] )); }
	public String getLblPayPaymentTotal     (int i) { return  escapeHTML(insertComma(lblPayPaymentTotal    [i] )); }
	public String getLblPayDependentCount   (int i) { return  escapeHTML(insertComma(lblPayDependentCount  [i] )); }
	public String getLblBonusMonth          (int i) { return  escapeHTML(insertComma(lblBonusMonth         [i] )); }
	public String getLblBonusPayDay         (int i) { return  escapeHTML(insertComma(lblBonusPayDay        [i] )); }
	public String getLblBonTotalAllowance   (int i) { return  escapeHTML(insertComma(lblBonTotalAllowance  [i] )); }
	public String getLblBonTaxFree          (int i) { return  escapeHTML(insertComma(lblBonTaxFree         [i] )); }
	public String getLblBonTaxation         (int i) { return  escapeHTML(insertComma(lblBonTaxation        [i] )); }
	public String getLblBonSocInsDeduction  (int i) { return  escapeHTML(insertComma(lblBonSocInsDeduction [i] )); }
	public String getLblBonPayInsDeduction  (int i) { return  escapeHTML(insertComma(lblBonPayInsDeduction [i] )); }
	public String getLblBonIncomeTax        (int i) { return  escapeHTML(insertComma(lblBonIncomeTax       [i] )); }
	public String getLblBonVariousDeduction (int i) { return  escapeHTML(insertComma(lblBonVariousDeduction[i] )); }
	public String getLblBonPaymentTotal     (int i) { return  escapeHTML(insertComma(lblBonPaymentTotal    [i] )); }
	public String getLblBonDependentCount   (int i) { return  escapeHTML(insertComma(lblBonDependentCount  [i] )); }
	
	public String getLblPayAdjCalcGap   (int i) { return  escapeHTML(lblPayAdjCalcGap  [i] ); }
	public String getLblBonAdjCalcGap   (int i) { return  escapeHTML(lblBonAdjCalcGap  [i] ); }
	
	
	public String getEscLblGeneralLifeIns    () { return  escapeHTML(  lblGeneralLifeIns    );}
	public String getEscLblPrivatePension    () { return  escapeHTML(  lblPrivatePension    );}
	public String getEscLblLifeInsDeduction  () { return  escapeHTML(  lblLifeInsDeduction  );}
	public String getEscLblearthquakeIns     () { return  escapeHTML(  lbLearthquakeIns     );}
	public String getEscLblLongTermDamageIns () { return  escapeHTML(  lblLongTermDamageIns );}
	public String getEscLblDamageInsDeduction() { return  escapeHTML(  lblDamageInsDeduction);}
	public String getEscLblSocialInsDeduction() { return  escapeHTML(  lblSocialInsDeduction);}
	public String getEscLblMutualAidDeduction() { return  escapeHTML(  lblMutualAidDeduction);}
	public String getEscLblSpouseSumIncome   () { return  escapeHTML(  lblSpouseSumIncome   );}
	public String getEscLblSpouseSpDeduction () { return  escapeHTML(  lblSpouseSpDeduction );}
	public String getEscLblHouseLoanDeduction() { return  escapeHTML(  lblHouseLoanDeduction);}
	public String getEscLblAllowanceAdjustment() { return  escapeHTML(  lblAllowanceAdjustment);}
	public String getEscLblTaxFreeAdjustment () { return  escapeHTML(  lblTaxFreeAdjustment );}
	public String getEscLblSocInsAdjustment  () { return  escapeHTML(  lblSocInsAdjustment  );}
	public String getEscLblTaxIncAdjustment  () { return  escapeHTML(  lblTaxIncAdjustment  );}
	public String getEscLblWithholdSlipNotes () { return  escapeHTML( lblWithholdSlipNotes );}
	public String getEscLblPaymentAllowance  () { return  escapeHTML(  lblPaymentAllowance  );}
	public String getEscLblPaymentIncomeTax  () { return  escapeHTML(  lblPaymentIncomeTax  );}
	public String getEscLblBonusAllowance    () { return  escapeHTML(  lblBonusAllowance    );}
	public String getEscLblBonusIncomeTax    () { return  escapeHTML(  lblBonusIncomeTax    );}
	public String getEscLblMidwayAdjustIncome() { return  escapeHTML(  lblMidwayAdjustIncome);}
	public String getEscLblMidwayAdjustTax   () { return  escapeHTML(  lblMidwayAdjustTax   );}
	public String getEscLblAfterDeductIncome () { return  escapeHTML(  lblAfterDeductIncome );}
	public String getEscLblPayInsDeduction   () { return  escapeHTML(  lblPayInsDeduction   );}
	public String getEscLblDependentsDeduction() { return  escapeHTML(  lblDependentsDeduction);}
	public String getEscLblCalcTaxedIncome   () { return  escapeHTML(  lblCalcTaxedIncome   );}
	public String getEscLblCalcIncomeTax     () { return  escapeHTML(  lblCalcIncomeTax     );}
	public String getEscLblAdjustedIncomeTax () { return  escapeHTML(  lblAdjustedIncomeTax );}
	public String getEscLblDeductedIncomeTax () { return  escapeHTML(  lblDeductedIncomeTax );}
	public String getEscLblFinalIncomeTax    () { return  escapeHTML(  lblFinalIncomeTax    );}
	public String getEscLblTaxGap    () { return  escapeHTML(  lblTaxGap    );}
	public String getEscLblAdjTotalAllowance    () { return  escapeHTML(  lblAdjTotalAllowance    );}
	public String getEscLblAdjTotalIncome       () { return  escapeHTML(  lblAdjTotalIncome    );}

	public String getEscLblSpHandicap    () { return escapeHTML(lblSpHandicap)    ; }
	public String getEscLblGeHandicap    () { return escapeHTML(lblGeHandicap)    ; }
	public String getEscLblGeWidow       () { return escapeHTML(lblGeWidow)       ; }
	public String getEscLblSpWidow       () { return escapeHTML(lblSpWidow)       ; }
	public String getEscLblWidow         () { return escapeHTML(lblWidow)         ; }
	public String getEscLblStudentGeneral() { return escapeHTML(lblStudentGeneral); }
	
	
	public String getEscLblTotalAllowance  () { return escapeHTML(insertComma( lblTotalAllowance  )); }
	public String getEscLblTaxFree         () { return escapeHTML(insertComma( lblTaxFree         )); }
	public String getEscLblTaxation        () { return escapeHTML(insertComma( lblTaxation        )); }
	public String getEscLblSocInsDeduction () { return escapeHTML(insertComma( lblSocInsDeduction )); }
	public String getEscLblTotalPayInsDeduction () { return escapeHTML(insertComma( lblTotalPayInsDeduction )); }
	public String getEscLblIncomeTax       () { return escapeHTML(insertComma( lblIncomeTax       )); }
	public String getEscLblIncomeDeductSum       () { return escapeHTML(insertComma( lblIncomeDeductSum       )); }
	public String getEscLblVariousDeduction() { return escapeHTML(insertComma( lblVariousDeduction)); }
	public String getEscLblPaymentTotal    () { return escapeHTML(insertComma( lblPaymentTotal    )); }
	
	public String getEscLblSelfSpHandi    () { return escapeHTML(lblSelfSpHandi    ); }
	public String getEscLblSelfHandicap    () { return escapeHTML(lblSelfHandicap    ); }
	public String getEscLblSelfSpWidow    () { return escapeHTML(lblSelfSpWidow    ); }
	public String getEscLblSelfWidow    () { return escapeHTML(lblSelfWidow    ); }
	public String getEscLblSelfStudentType    () { return escapeHTML(lblSelfStudentType    ); }

	public String getEscLblLwSpHandiEl () { return escapeHTML(lblLwSpHandiEl  ); }
	public String getEscLblLwSpHandicap() { return escapeHTML(lblLwSpHandicap ); }
	public String getEscLblSpouseEl    () { return escapeHTML(lblSpouseEl     ); }
	public String getEscLblSpouseGe    () { return escapeHTML(lblSpouseGe     ); }
	
	public String getEscLblGeneralDependent () { return escapeHTML(lblGeneralDependent ); }
	public String getEscLblSpecificDependent() { return escapeHTML(lblSpecificDependent); }
	public String getEscLblElderlyDependent () { return escapeHTML(lblElderlyDependent ); }
	public String getEscLblLiveWithEldRel   () { return escapeHTML(lblLiveWithEldRel   ); }
	public String getEscLblLiveWithHandiGe  () { return escapeHTML(lblLiveWithHandiGe  ); }
	public String getEscLblLiveWithHandiSp  () { return escapeHTML(lblLiveWithHandiSp  ); }
	public String getEscLblLiveWithHandiEl  () { return escapeHTML(lblLiveWithHandiEl  ); }
	public String getEscLblLiveWithHandiEr  () { return escapeHTML(lblLiveWithHandiEr  ); }
	public String getEscLblGeneralHandicap  () { return escapeHTML(lblGeneralHandicap  ); }
	public String getEscLblSpecificHandicap () { return escapeHTML(lblSpecificHandicap ); }
	
	public String getEscLblMidwayType     () { return escapeHTML(lblMidwayType       ); }
	public String getEscLblFormerIncome   () { return escapeHTML(insertComma(lblFormerIncome     )); }
	public String getEscLblFormerInsurance() { return escapeHTML(insertComma(lblFormerInsurance  )); }
	public String getEscLblFormerTax      () { return escapeHTML(insertComma(lblFormerTax        )); }


	
	public String getEscLblPostalCode       () { return escapeHTML(lblPostalCode       ); }	// X֔ԍ
	public String getEscLblAddress          () { return escapeHTML(lblAddress          ); }	// Z
	public String getEscLblBirthDate        () { return escapeHTML(lblBirthDate        ); }	// N
	public String getEscLblIncomeTaxType    () { return escapeHTML(lblIncomeTaxType    ); }
	public String getEscLblAdjustmentType   () { return escapeHTML(lblAdjustmentType   ); }
	
	public void setLblChangeKCode (String lblChangeKCode ) { this.lblChangeKCode  = lblChangeKCode ; }
	public void setHidAdjustYear  (int    hidAdjustYear  ) { this.hidAdjustYear   = hidAdjustYear  ; }

	public int getCntPayment  () { return  cntPayment ; }
	public int getCntBonus  () { return  cntBonus ; }
	
}
