/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;

import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;

import jp.mosp.payroll.vo.YukyuManagementListVo;

public class YukyuManagementListAction extends MosPAction {

	// R}h
	private static final String CMD_YUKYU_MANAGEMENT_LIST_SHOW 		= "P1110";
	private static final String CMD_YUKYU_MANAGEMENT_LIST_SEARCH 		= "P1111";
	private static final String CMD_YUKYU_MANAGEMENT_LIST_RE_SEARCH 	= "P1112";
	private static final String CMD_YUKYU_MANAGEMENT_LIST_SORT 		= "P1113";

	/**
	 * RXgN^
	 */
	public YukyuManagementListAction() {
		super();
	}

	public void action() throws Exception {
		// RlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		YukyuManagementListVo vo;
		vo = (YukyuManagementListVo)getStoredVo(CommonConst.VO_EMPLOYEE_ATTENDANCE_LIST);
		if (vo == null) {
			vo = new YukyuManagementListVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_EMPLOYEE_ATTENDANCE_LIST, vo);
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		vo.aryPltSectionAll   = getSectionArrayAll();
		vo.aryPltSection      = getSectionArrayForHuman();
		vo.aryPltPosition     = getPositionArray();
		// R}h̏
		if (cmd.equals(CMD_YUKYU_MANAGEMENT_LIST_SHOW)) {
			// \
			vo.setPltSection(getBelongSectionCode(mKihon.getKCode()));
		} else if (cmd.equals(CMD_YUKYU_MANAGEMENT_LIST_SEARCH)) {
			// 
			vo.setParams(request);
			searchEmployeeList(vo);
			vo.setFormerKey(vo.KEY_K_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();			
		} else if (cmd.equals(CMD_YUKYU_MANAGEMENT_LIST_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			if (!vo.getPltSection().equals("")) {
				searchEmployeeList(vo);
				vo.setPageButton();
				sortList(vo);
			} else {
				vo.setPltSection(getBelongSectionCode(mKihon.getKCode()));
			}
		} else if (cmd.equals(CMD_YUKYU_MANAGEMENT_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ЈXg
	 * @param vo EmployeeListVoCX^X
	 * @throws Exception
	 */
	private void searchEmployeeList(YukyuManagementListVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// Wv擾
		Date current = getCalcAttendance();
		// ͈͎擾
		int startDate = util.convDateToInteger(getStartDate(current));
		// ͈͎擾
		int endDate = util.convDateToInteger(getEndDate(current));
		// 
		MKihonDao mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
		List<MKihonDto> mKihonList = mKihonDao.findForCondition(
				vo.getTxtKCode(),
				vo.getTxtKName(),
				vo.getPltSection(),
				mKihon.getJCode(),
				mKihon.getKCode(),
				user.getDataLevel(),
				startDate,
				endDate
		);
		// VOݒ
		vo.setFields(mKihonList);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryKCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, YukyuManagementListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(YukyuManagementListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, YukyuManagementListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_POSITION)) {
			comp = new CompPosition();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {		
		private static final long serialVersionUID = -1233050839249572581L;

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}

	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5301067020345798854L;

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}

	/**
	 * ɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -1783273816527143665L;
		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}

	/**
	 * EʂɂrNX
	 */
	protected static class CompPosition implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -485908349343472522L;
		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			//EꍇAŔr
			if (dto1.getYCode().equals(dto2.getYCode())) {
				return dto1.getTokyu().compareTo(dto2.getTokyu());
			} else {
				return dto1.getYCode().compareTo(dto2.getYCode());
			}
		}
	}

}
