/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.util.Date;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.PartManager;

import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.MKintaiKeisanDto;
import jp.mosp.payroll.vo.AttendanceCalculateStartCardVo;

public class AttendanceCalculateStartCardAction extends MosPAction {

	// R}h
	private static final String CMD_START_CARD_SHOW 	= "P1020";
	private static final String CMD_START_CARD_UPDATE = "P1021";

	// tB[h
	private MKintaiKeisanDto dto;

	/**
	 * RXgN^
	 */
	public AttendanceCalculateStartCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		AttendanceCalculateStartCardVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_START_CARD_SHOW)) {
			vo.setDefaultValues();
			// \
			show(vo);
		} else if (cmd.equals(CMD_START_CARD_UPDATE)) {
			vo.setParams(request);
			// XV
			update(vo);
			// \
			show(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	protected AttendanceCalculateStartCardVo getInitVo() {
		return new AttendanceCalculateStartCardVo();
	}

	/**
	 * 
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void init(AttendanceCalculateStartCardVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// ΑӌvZΏ۔N擾
		Date current = getCalcMonth();
		// NxXg擾
		vo.aryPltKTnen = util.getYearArray(MospUtility.getYear(current), 1, 1);
		// Xg擾
		vo.aryPltKTtuki = util.getMonthArray();
		// DTO̎擾
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MKintaiKeisanDto ? (MKintaiKeisanDto)obj : null;
	}

	/**
	 * ݒ荀ڌ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	protected void show(AttendanceCalculateStartCardVo vo) throws Exception {
		dto = PartManager.calculate(partInfo()).findForCalc();
		if (chkExistDto(dto)) {
			// vZΏ۔NZbg
			vo.setPltKTnen(String.valueOf(dto.getKTNen()));
			vo.setPltKTtuki(String.valueOf(dto.getKTTuki()));
		} else {
			// ݂̔NZbg
			vo.setPltKTnen(String.valueOf(MospUtility.getYear(util.getSystemDate())));
			vo.setPltKTtuki(String.valueOf(MospUtility.getMonth(util.getSystemDate())));
		}
		// [hݒ
		vo.setMode(AttendanceCalculateStartCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}	

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void update(AttendanceCalculateStartCardVo vo) throws Exception {
		// DAȌ
		MKintaiKeisanDao dao = new MKintaiKeisanDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		if (dto == null) {
			dto = new MKintaiKeisanDto();
		}
		// XVOf[^fds
		MKintaiKeisanDto formerDto = dao.findForUpdate();
		// VO̒lDTOɃZbg
		// ͓t
		Date change = util.getFirstDateOfMonth(vo.getPltKTnen(), vo.getPltKTtuki());
		vo.setPltKTnen(String.valueOf(MospUtility.getYear(change)));
		vo.setPltKTtuki(String.valueOf(MospUtility.getMonth(change)));
		// XVOdto݂邩ǂ`FbN
		if (chkExistDto(formerDto)) {
			// Wvt
			Date current = util.getFirstDateOfMonth(formerDto.getKTNen(), formerDto.getKTTuki());
			// p[^̑ÓmF
			vo.validate(formerDto, current, change);
			// 폜
			dao.delete(formerDto);
		}
		// ύXlDTOɃZbg
		vo.setDtoFields(dto);
		// ^vZZbg
		dto.setKSNen(MospUtility.getYear(getCalcPayment(change)));
		dto.setKSTuki(MospUtility.getMonth(getCalcPayment(change)));
		dto.setKShi(MospUtility.getDay(getCalcPayment(change)));
		// o^	
		dao.insert(dto);
		// DTO̍Ď擾
		MKintaiKeisanDto retDto = dao.findForKey(String.valueOf(dto.getKTNen()));
		chkUpdate(retDto);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// R~bg
		commit();
	}	

}
