/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

import jp.mosp.kintai.dto.MSyukkinboDto;

public class AttendanceHolidayCardVo extends AttendanceMenuVo {

	private static final long serialVersionUID = -4666690261405185923L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/attendanceHolidayCard.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/attendanceHolidayCard.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/attendanceHolidayCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.NAM_INPUT_HOLIDAY;

	// p[^
	public static final String PRM_PLT_HOLIDAY_REASON			= "pltHolidayReason"		;
	public static final String PRM_PLT_HOLIDAY_CERTIFICATE 	= "pltHolidayCertificate"	;
	public static final String PRM_TXT_HOLIDAY_COMMENT 		= "txtHolidayComment"		;

	public static final String PRM_PLT_SUBSTITUTE_YEAR		= "pltSubstituteYear"		;
	public static final String PRM_PLT_SUBSTITUTE_MONTH		= "pltSubstituteMonth"		;
	public static final String PRM_PLT_SUBSTITUTE_DAY			= "pltSubstituteDay"		;

	// tB[hyѐ
	public static final String NAM_HOLIDAY_REASON			= CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_REASON;
	public static final String NAM_HOLIDAY_CERTIFICATE	= CommonConst.NAM_CERTIFICATE;
	public static final String NAM_HOLIDAY_COMMENT 		= CommonConst.NAM_COMMENT;
	public static final String NAM_SUBSTITUTE_HOLIDAY		= CommonConst.NAM_SUBSTITUTE_HOLIDAY;

	public static final int	LEN_COMMENT		= 50;

	// tB[h
	private String pltHolidayReason;
	private String pltHolidayCertificate;
	private String txtHolidayComment;
	private String pltSubstituteYear;
	private String pltSubstituteMonth;
	private String pltSubstituteDay;

	private int holidayTimes;

	// v_EXg
	public String[][] aryPltHolidayReason;
	public String[][] aryPltHolidayCertificate;
	public String[][] aryPltSubstituteYear;
	public String[][] aryPltSubstituteMonth;
	public String[][] aryPltSubstituteDay;

	/**
	 * RXgN^
	 */	
	public AttendanceHolidayCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		mode = MODE_EDIT;
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		pltHolidayReason		= request.getParameter(PRM_PLT_HOLIDAY_REASON);
		pltHolidayCertificate	= request.getParameter(PRM_PLT_HOLIDAY_CERTIFICATE);
		txtHolidayComment		= request.getParameter(PRM_TXT_HOLIDAY_COMMENT);
		pltSubstituteYear 		= request.getParameter(PRM_PLT_SUBSTITUTE_YEAR);
		pltSubstituteMonth 		= request.getParameter(PRM_PLT_SUBSTITUTE_MONTH);
		pltSubstituteDay 		= request.getParameter(PRM_PLT_SUBSTITUTE_DAY);
	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MSyukkinboDto dto) {
		pltHolidayReason 		= dto.getKKRiyuu();
		pltHolidayCertificate 	= dto.getKKSyoumei();
		txtHolidayComment 		= dto.getKKComent();
		pltSubstituteYear  		= util.convStringDateToArray(dto.getDaiKyuJyu())[0];
		pltSubstituteMonth 		= util.convStringDateToArray(dto.getDaiKyuJyu())[1];
		pltSubstituteDay  		= util.convStringDateToArray(dto.getDaiKyuJyu())[2];
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	@Override
	public void setDtoFields(MSyukkinboDto dto) {
		super.setDtoFields(dto);
		dto.setKinmu(CommonConst.ATTENDANCE_TYPE_HOLIDAY);
		dto.setKKRiyuu(pltHolidayReason);
		// [
		if (pltSubstituteYear.length() != 0
				&& pltSubstituteMonth.length() != 0
				&& pltSubstituteDay.length() != 0
		) {
			dto.setDaiKyuJyu(util.convStringDateFormatted(
					pltSubstituteYear, pltSubstituteMonth, pltSubstituteDay)
			);
		}
		dto.setKKComent(txtHolidayComment);
		dto.setKKSyoumei(pltHolidayCertificate);
		dto.setKKJikan(holidayTimes);
		dto.setKKTimes(util.getDateTime(util.getNowDate()));
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(util.getDateTime(util.getNowDate()));
	}

	/**
	 * tB[h
	 */
	public void initFields() {
		pltHolidayReason 		= "";
		pltHolidayCertificate 	= "";
		txtHolidayComment 		= "";
		pltSubstituteYear 		= "";
		pltSubstituteMonth 		= "";
		pltSubstituteDay 		= "";
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// [`FbN
		if (!pltSubstituteYear.equals("") || !pltSubstituteMonth.equals("") || !pltSubstituteDay.equals("")) {
			checkDate(getIntParam(pltSubstituteYear), getIntParam(pltSubstituteMonth), getIntParam(pltSubstituteDay),
					NAM_SUBSTITUTE_HOLIDAY, PRM_PLT_SUBSTITUTE_YEAR);			
		}
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getPltHolidayReason		() { return pltHolidayReason		; }
	public String getPltHolidayCertificate	() { return pltHolidayCertificate	; }
	public String getTxtHolidayComment		() { return txtHolidayComment		; }
	public String getPltSubstituteYear		() { return pltSubstituteYear		; }
	public String getPltSubstituteMonth		() { return pltSubstituteMonth		; }
	public String getPltSubstituteDay		() { return pltSubstituteDay		; }

	public String getEscPltHolidayReason		() { return escapeHTML(pltHolidayReason			); }
	public String getEscPltHolidayCertificate	() { return escapeHTML(pltHolidayCertificate	); }
	public String getEscTxtHolidayComment		() { return escapeHTML(txtHolidayComment		); }
	public String getEscPltSubstituteYear		() { return escapeHTML(pltSubstituteYear		); }
	public String getEscPltSubstituteMonth		() { return escapeHTML(pltSubstituteMonth		); }
	public String getEscPltSubstituteDay		() { return escapeHTML(pltSubstituteDay			); }

	public void setHolidayTimes(int holidayTimes) { this.holidayTimes = holidayTimes; }

}
