/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.action.MosPHumanAction;

import jp.mosp.human.dto.MEmergencyDto;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.human.vo.HumanPersonalCardVo;

public class HumanPersonalCardAction extends MosPHumanAction {

	// R}h
	private static final String CMD_HUMAN_PERSONAL_SELECT    = "H1030";
	private static final String CMD_HUMAN_PERSONAL_UPDATE    = "H1033";	

	// tB[h
	private MKojinDto 		storedmKojinDto;
	private MEmergencyDto 	storedmEmergencyDto;

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// HUMANmF
		confirmHumanAuth();
		// VO̎擾
		HumanPersonalCardVo vo = getInitVo();
		// 
		init(vo);
		// v_Eݒ 
		setPulldownList(vo);
		// R}h̏
		if (cmd.equals(CMD_HUMAN_PERSONAL_SELECT)) {
			// \(ЈR[hŏ)
			select(vo);
		}  else if (cmd.equals(CMD_HUMAN_PERSONAL_UPDATE)) {
			// XV
			update(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	protected HumanPersonalCardVo getInitVo() {
		return new HumanPersonalCardVo();
	}

	/**
	 * 
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void init(HumanPersonalCardVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// p[^擾
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// ʃXg擾
		vo.aryPltGender = getMosPCodeArray(CommonConst.TID_SEIBETSU);
		// NXg擾
		Date date = util.getSystemDate();
		vo.aryPltBirthYear = util.getYearArray(MospUtility.getYear (date), 50, 1);
		vo.aryPltBirthMonth = util.getMonthArray();
		vo.aryPltBirthDay = util.getDayArray();
		// {^eݒ
		setListButton(vo);
	}

	/**
	 * v_Eݒ
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void setPulldownList(HumanPersonalCardVo vo) throws Exception {
		// Xg擾
		vo.aryPltPrefecture = CommonConst.getPrefectureArray(); 
		// t^Xg
		vo.aryPltBloodType = getMosPCodeArray(CommonConst.TID_BLOOD_TYPE);
		// ^敪
		vo.aryPltSalaryKb = getMosPCodeArray(CommonConst.TID_SALARY);
		// ŋ敪
		vo.aryPltTaxKb = getMosPCodeArray(CommonConst.TID_TAX);
		// g敪
		vo.aryPltUnionKb = getMosPCodeArray(CommonConst.TID_UNION);
		// x敪
		vo.aryPltPaymentKb = getMosPCodeArray(CommonConst.TID_PAYMENT);
		// p[g敪
		vo.aryPltPartKb = getMosPCodeArray(CommonConst.TID_PARTTIME);
	}

	/**
	 * f[^\
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void select(HumanPersonalCardVo vo) throws Exception {
		// IЈR[h擾
		String kCode = "";
		if (vo.getTxtChangeKCode() != null && !vo.getTxtChangeKCode().equals("") ) {
			kCode = vo.getTxtChangeKCode();
		} else if (key1 != null && !key1.equals("")) {
			kCode = key1;
		}
		// l{擾
		getHumanKihonInfo(kCode, vo);
		// l擾
		getHumanKojinInfo(kCode, vo);
		// ً}A擾
		getHumanmEmergencyInfo(kCode, vo);
		// \pl{ݒ
		vo.setLblKCode(kCode);
		vo.setLblKName(mKihonDto.getSimei());
		vo.setLblKKana(mKihonDto.getFurigana());
		// ZbVDTOZbg
		setStoredDto();
	}

	/**
	 * XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void update(HumanPersonalCardVo vo) throws Exception {
		// ZbVێDTO擾
		getStoredDto();
		// p[^̑ÓmF
		vo.validate();
		// DAO
		prepareHumanBasisDao();
		prepareKojinBasisDao();
		prepareEmergencyBasisDao();
		// o^
		String message = regist(vo);
		// R~bg
		commit();
		// l{擾
		getHumanKihonInfo(vo.getTxtChangeKCode(), vo);
		getHumanKojinInfo(vo.getTxtChangeKCode(), vo);
		getHumanmEmergencyInfo(vo.getTxtChangeKCode(), vo);
		// bZ[Wݒ
		vo.setMessage(message);
		// \pl{ݒ
		vo.setLblKCode(vo.getTxtChangeKCode());
		vo.setLblKName(mKihonDto.getSimei());
		vo.setLblKKana(mKihonDto.getFurigana());
		// ZbVDTOZbg
		setStoredDto();
	}

	/**
	 * 擾
	 * @param kCode 擾ΏێЈR[h
	 * @param vo    ݒΏVO
	 * @throws Exception
	 */
	private void getHumanKihonInfo(String kCode, HumanPersonalCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// l{擾
		findHumanBasisInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mKihonDto == null) {
			addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_NO_HUMAN_DATA, ""));
			vo.setTxtChangeKCode(kCode);
			return;
		}
		// VOɏݒ
		vo.setFields(mKihonDto);
		vo.setMode(HumanPersonalCardVo.MODE_UPDATE);				
		// ZbVێpDTOݒ
		storedmKihonDto = mKihonDto;
		// rݒ
		String editor = setExclusive(CommonConst.EXC_HUMAN_BASIS, user.getUserId(), kCode);
		if (editor != null) {
			addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_EXCLUSIVE, editor));
		}
		setNeedExclusive(true);
	}

	/**
	 * l擾
	 * @param kCode 擾ΏێЈR[h
	 * @param vo    ݒΏVO
	 * @throws Exception
	 */
	private void getHumanKojinInfo(String kCode, HumanPersonalCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// l擾
		findHumanPersonnelInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mKojinDto == null) {
			mKojinDto = new MKojinDto();
			vo.setTxtChangeKCode(kCode);
			return;
		}
		// VOɏݒ
		vo.setFields(mKojinDto);
		vo.setMode(HumanPersonalCardVo.MODE_UPDATE);		
		// ZbVێpDTOݒ
		storedmKojinDto = mKojinDto;			
	}

	/**
	 * ً}A擾
	 * @param kCode 擾ΏێЈR[h
	 * @param vo    ݒΏVO
	 * @throws Exception
	 */
	private void getHumanmEmergencyInfo(String kCode, HumanPersonalCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ً}A擾
		findHumanEmergencyInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mEmergencyDto == null) {
			mEmergencyDto = new MEmergencyDto();
			vo.setTxtChangeKCode(kCode);
			return;
		}
		// VOɏݒ
		vo.setFields(mEmergencyDto);
		vo.setMode(HumanPersonalCardVo.MODE_UPDATE);
		// ZbVێpDTOݒ
		storedmEmergencyDto = mEmergencyDto;
	}

	/**
	 * ZbVێDTO擾
	 */
	protected void getStoredDto() {
		super.getStoredDto();
		storedmKojinDto = (MKojinDto)session.getAttribute("mKojinDto");
		storedmEmergencyDto = (MEmergencyDto)session.getAttribute("mEmergencyDto");
	}

	/**
	 * ZbVێDTOݒ
	 */
	protected void setStoredDto() {
		super.setStoredDto();
		session.setAttribute("mKojinDto", storedmKojinDto);
		session.setAttribute("mEmergencyDto", storedmEmergencyDto);
	}

	/**
	 * o^
	 * @param vo ΏVO
	 * @return bZ[W
	 * @throws Exception
	 */
	private String regist(
			HumanPersonalCardVo vo		
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DTȌ
		if (mKihonDto == null) {
			mKihonDto = storedmKihonDto;
		}
		vo.setDtoFields(mKihonDto);

		if (mKojinDto == null) {
			mKojinDto = new MKojinDto();
		}
		vo.setDtoFields(mKojinDto);

		if (mEmergencyDto == null) {
			mEmergencyDto = new MEmergencyDto();
		}
		vo.setDtoFields(mEmergencyDto);	
		mKojinDto.setKCode(mKihonDto.getKCode());
		// l{񑶍݊mF
		String message = "";
		// l{XV
		chkExclusive(mKihonDto, mKihonDao.findForUpdate(mKihonDto.getKCode()), vo);
		// XV
		mKihonDao.update(mKihonDto);
		// l擾
		MKojinDto chkMKojinDto = mKojinDao.findForUpdate(vo.getTxtChangeKCode());		
		if (chkMKojinDto == null) {
			// lo^	
			mKojinDao.insert(mKojinDto);
		} else {
			// lXV
			mKojinDao.update(mKojinDto);
		}
		// ً}A擾		
		String maxEno =	mEmergencyDao.findForMax();
		if(maxEno == null || maxEno.equals("")){
			maxEno = "-1";
		} else {
			mEmergencyDao.findForUpdate(maxEno);
		}
		if (mEmergencyDao.findForConditionUpdate(mKihonDto.getKCode()) != null) {
			storedmEmergencyDto.setDeleteFlag(1);
			// ً}AXV
			mEmergencyDao.update(storedmEmergencyDto);
		}
		// őlZbg
		mEmergencyDto.setEmCode(Integer.parseInt(maxEno) + 1);					
		// ً}Ao^	
		mEmergencyDao.insert(mEmergencyDto);
		message = MospUtility.getMessage(msg, MospConst.MSG_UPDATE, "");
		return message;
	}

}
