/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;


import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.CmAuthorityDao;
import jp.mosp.common.dao.CmComponentDao;
import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.part.VariousPart;
import jp.mosp.common.vo.MosPMenuArrangeVo;

public abstract class MosPMenuArrangeAction extends MosPAction {

	protected static final String CONF_ID_EMPLOYEE 	= CommonConst.CONF_ID_EMPLOYEE;
	protected static final String CONF_ID_MANAGER 	= CommonConst.CONF_ID_MANAGER;
	protected static final String CONF_ID_HUMAN 		= CommonConst.CONF_ID_HUMAN;
	protected static final String CONF_ID_PAYROLL 	= CommonConst.CONF_ID_PAYROLL;

	/*j[ԍ*/
	protected static final int AUTH_EMPLOYEE_MENU 	= 0;
	protected static final int AUTH_MANAGER_MENU 		= 1;
	protected static final int AUTH_HUMAN_MENU 		= 2;
	protected static final int AUTH_PAYROLL_MENU 		= 3;
	protected static final int AUTH_CALCULATE_MENU 	= 4;
	protected static final int AUTH_SYSTEM_MENU 		= 5;

	/*DAO*/
	protected CmComponentDao cmCompoDao;
	protected CmAuthorityDao cmAuthDao;

	/*DTO*/
	protected CmComponentDto cmCompoDto;

	/**
	 * j[\pDAȌ
	 * @throws Exception 
	 * @throws MospException 
	 */
	protected void prepareCmComponentDao() throws MospException, Exception {
		if (cmCompoDao != null) {
			return;
		}
		// DAȌ
		cmCompoDao = PartManager.component(partInfo()).getCmComponentDao();
	}

	/**
	 * pDAȌ
	 * @throws Exception 
	 * @throws MospException 
	 */
	protected void prepareCmAuthorityDao() throws MospException, Exception {
		if (cmAuthDao != null) {
			return;
		}
		// DAȌ
		cmAuthDao = PartManager.authority(partInfo()).getCmAuthorityDao();
	}

	/**
	 * ޕʌ敪擾(CM_COMPONENT)
	 * @param division 
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception
	 */
	protected String[][] getDivisionAuthArray(String division) throws Exception {
		return PartManager.component(partInfo()).getDivisionAuthArray(division);
	}

	/**
	 * ޕʌ敪擾(CM_COMPONENT)
	 * @param division 
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception
	 */
	protected String[][] getDivisionAuthAllArray(String division) throws Exception {
		return PartManager.component(partInfo()).getDivisionAuthAllArray(division);
	}

	/**
	 * ftHgj[Xg쐬(Authority)
	 * @return map
	 */
	protected Map<String, CmAuthorityDto> getDefaultAuthMap() {
		Map<String, CmAuthorityDto> map = new HashMap<String, CmAuthorityDto>();
		for (int i = 0; i < getDefaultAuthArray().length; i++) {
			CmAuthorityDto dto = getDefaultAuthDto(i);
			map.put(dto.getAuthCode(), dto);
		}
		return map;
	}

	/**
	 * ftHǧ擾
	 * @return	ftHǧ
	 */
	protected CmAuthorityDto getDefaultAuthDto() {
		return getDefaultAuthMap().get(user.getMospAuthority());
	}

	/**
	 * @param title
	 * @param command
	 * @return
	 */
	protected String[] getMenuUnit(String title, String command) {
		return util.createArray(title, command);
	}

	/**
	 * ftHgDTO쐬iCmComponentj
	 * <p>j[ԍ</p>
	 * 0AΑӓ
	 * 1AΑӊǗ
	 * 2AlǗ
	 * 3A^Ǘ
	 * 4AvZ
	 * @param menu			j[ԍ
	 * @return dto			
	 * @throws Exception
	 */
	protected CmComponentDto getDefaultCompoDto(int i) {
		CmComponentDto dto = new CmComponentDto();
		dto.setDivision		(getDefaultCompArray()[i][0]);
		dto.setCompCode		(getDefaultCompArray()[i][0]);
		dto.setCompName		(getDefaultCompArray()[i][1]);
		dto.setManage		(Integer.parseInt(getDefaultCompArray()[i][2]));
		dto.setComponent	(getDefaultCompArray()[i][3]);
		return dto;
	}

	/**
	 * ftHgDTO쐬iCmAuthorityj
	 * @return dto			
	 * @throws Exception
	 */
	private CmAuthorityDto getDefaultAuthDto(int i) {
		CmAuthorityDto dto = new CmAuthorityDto();
		dto.setAuthCode(getDefaultAuthArray()[i][0]);
		dto.setAuthName(getDefaultAuthArray()[i][1]);
		dto.setEmployee(getDefaultAuthArray()[i][2]);
		dto.setManager(getDefaultAuthArray()[i][3]);
		dto.setPayroll(getDefaultAuthArray()[i][4]);
		dto.setHuman(getDefaultAuthArray()[i][5]);
		return dto;
	}

	/**
	 * eftHg{̔z쐬 {division/code,name,manage,component}
	 * @return array
	 */
	private String[][] getDefaultCompArray() {
		String[][] array = {
				{ CommonConst.CONF_ID_EMPLOYEE	, CommonConst.NAM_AUTH_EMPLOYEE	+ CommonConst.NAM_NEW_DATA_M_KIHON , "0" , convAryToComponent(getEmployeeCmdArray())		},
				{ CommonConst.CONF_ID_MANAGER  	, CommonConst.NAM_AUTH_MANAGER	+ CommonConst.NAM_NEW_DATA_M_KIHON , "1" , convAryToComponent(getManagerCmdArray())			},
				{ CommonConst.CONF_ID_HUMAN 	, CommonConst.NAM_AUTH_HUMAN 	+ CommonConst.NAM_NEW_DATA_M_KIHON , "2" , convAryToComponent(getHumanCmdArray())			},
				{ CommonConst.CONF_ID_PAYROLL 	, CommonConst.NAM_AUTH_PAYROLL 	+ CommonConst.NAM_NEW_DATA_M_KIHON , "2" , convAryToComponent(getPayrollRestrictCalcArray())},
				{ CommonConst.CONF_ID_CALCULATE , CommonConst.NAM_AUTH_CALCULATE+ CommonConst.NAM_NEW_DATA_M_KIHON , "2" , convAryToComponent(getPayrollCmdArray())			}
		};
		return array;
	}

	/**
	 * ftHgR[h̔z쐬 {code,name,Employee,Manager,Payroll,Human}
	 * @return array
	 */
	private String[][] getDefaultAuthArray() {
		String[][] array = {
				{ CommonConst.AUTH_DEFAULT_USER 	, CommonConst.NAM_AUTH_EMPLOYEE 	, CommonConst.CONF_ID_EMPLOYEE ,""  							,""  							,""  						},
				{ CommonConst.AUTHORITY_MANAGER 	, CommonConst.NAM_AUTH_MANAGER  	, CommonConst.CONF_ID_EMPLOYEE ,CommonConst.CONF_ID_MANAGER 	,""  							,""  						},
				{ CommonConst.AUTHORITY_PAYROLL 	, CommonConst.NAM_AUTH_PAYROLL  	, CommonConst.CONF_ID_EMPLOYEE ,""  							,CommonConst.CONF_ID_PAYROLL 	,""  						},
				{ CommonConst.AUTHORITY_HUMAN 		, CommonConst.NAM_AUTH_HUMAN  		, CommonConst.CONF_ID_EMPLOYEE ,""  							,""  							,CommonConst.CONF_ID_HUMAN 	},
				{ CommonConst.AUTHORITY_CALCULATE	, CommonConst.NAM_AUTH_CALCULATE 	, CommonConst.CONF_ID_EMPLOYEE ,""  							,CommonConst.CONF_ID_CALCULATE  ,"" 						},
				{ CommonConst.AUTHORITY_SENIORS 	, CommonConst.NAM_AUTH_SENIORS  	, CommonConst.CONF_ID_EMPLOYEE ,CommonConst.CONF_ID_MANAGER 	,CommonConst.CONF_ID_PAYROLL 	,CommonConst.CONF_ID_HUMAN 	}
		};
		return array;
	}

	/**
	 * 񎟔zf[^o\bh
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	protected String convAryToComponent(String[][] array) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append(array[i][0]);
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
		}			
		return sb.toString();
	}

	/**
	 * DTO擾
	 * @return DTO
	 * @throws Exception
	 */
	protected CmAuthorityDto getUserAuthDto() throws Exception {
		// pDAȌ
		prepareCmAuthorityDao();
		return cmAuthDao.findForAuth(user.getMospAuthority());
	}

	/**
	 * j[ԍɂR}hԍz񐶐
	 * @param menuno
	 * @return
	 */
	protected String[][] getMenuCmdArray(int menuno) {
		String[][] array = {{"", ""}};
		switch (menuno) {
		case AUTH_EMPLOYEE_MENU:
			array = getEmployeeCmdArray();
			break;
		case AUTH_MANAGER_MENU:
			array = getManagerCmdArray();
			break;
		case AUTH_HUMAN_MENU:
			array = getHumanCmdArray();
			break;
		case AUTH_PAYROLL_MENU:
		case AUTH_CALCULATE_MENU:
			array = getPayrollCmdArray();
			break;
		case AUTH_SYSTEM_MENU:
			array = getSystemCmdArray();
			break;
		default:
			break;
		}
		return array;
	}

	/**
	 * j[\DTO擾
	 * @param authDto		ΏDTO
	 * @param menuno		j[ԍ
	 * @return	j[\DTO
	 * @throws Exception
	 */
	protected CmComponentDto getMenuComponent(CmAuthorityDto authDto, int menuno) throws Exception {
		CmComponentDto dto = null;
		String findKey = "";
		if (authDto != null) {
			switch (menuno) {
			case AUTH_EMPLOYEE_MENU:
				findKey = authDto.getEmployee();
				break;
			case AUTH_MANAGER_MENU:
				findKey = authDto.getManager();
				break;
			case AUTH_HUMAN_MENU:
				findKey = authDto.getHuman();
				break;
			case AUTH_PAYROLL_MENU:
			case AUTH_CALCULATE_MENU:
				findKey = authDto.getPayroll();
				break;
			default:
				break;
			}
			// j[\pDAȌ
			dto = PartManager.component(partInfo()).findForKey(findKey);
		}
		return dto;
	}

	/**
	 * j[\擾
	 * @param dto	ΏDTO
	 * @return	j[R}h
	 */
	protected String getComponent(CmComponentDto dto) {
		if (VariousPart.chkExistDto(dto)) {
			return dto.getComponent();
		}
		return "";
	}

	/**
	 * j[\擾
	 * @param dto	ΏDTO
	 * @param menuno	Ώۃj[ԍ
	 * @return	j[R}h
	 * @throws Exception
	 */
	protected String getComponent(CmAuthorityDto dto, int menuno) throws Exception {
		if (VariousPart.chkExistDto(dto)) {
			return getComponent(getMenuComponent(dto, menuno));
		}
		return "";
	}

	/**
	 * ]ƈR}hDTO擾
	 * @param CmAuthorityDto 
	 * @return DTO
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getEmployeeComponent(CmAuthorityDto cmAuthorityDto) throws Exception {
		CmComponentDto dto = getMenuComponent(cmAuthorityDto, AUTH_EMPLOYEE_MENU);
		// ftHgR[h̐ݒ
		if (!VariousPart.chkExistDto(dto)) {
			dto = getDefaultCompoDto(AUTH_EMPLOYEE_MENU);	
		}
		return dto.getComponent();
	}

	/**
	 * }l[W[R}hDTO擾
	 * @param CmAuthorityDto 
	 * @return DTO
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getManagerComponent(CmAuthorityDto cmAuthorityDto) throws Exception {
		CmComponentDto dto = getMenuComponent(cmAuthorityDto, AUTH_MANAGER_MENU);
		// ftHgR[h̐ݒ
		if (!VariousPart.chkExistDto(dto)) {
			dto = getDefaultCompoDto(AUTH_MANAGER_MENU);
		}
		return dto.getComponent();
	}

	/**
	 * ^R}hDTO擾
	 * @param CmAuthorityDto 
	 * @return DTO
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getPayrollComponent(CmAuthorityDto cmAuthorityDto) throws Exception {
		CmComponentDto dto = getMenuComponent(cmAuthorityDto, AUTH_PAYROLL_MENU);	
		// ftHgR[h̐ݒ
		if (!VariousPart.chkExistDto(dto)) {		
			if (user.getMospAuthority().equals(CommonConst.AUTHORITY_CALCULATE)) {
				dto = getDefaultCompoDto(AUTH_CALCULATE_MENU);
			} else {
				dto = getDefaultCompoDto(AUTH_PAYROLL_MENU);
			}
		}
		// ΑӌvZ{^\ݒ
		return getCalcButton(dto);
	}

	/**
	 * ΑӌvZ{^\\bh
	 * @param dto		ΏDTO
	 * @param isMenu	j[
	 * @return@
	 */
	protected String getCalcButton(CmComponentDto dto, boolean isMenu) {
		return getMenuButton(dto, isMenu, getCalcCmdArray());
	}

	/**
	 * ΑӌvZ{^\\bh
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	protected String getCalcButton(CmComponentDto dto) {
		String[] aryCommand = util.divideByComma(dto.getComponent());
		int count = 0;
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < aryCommand.length; i++) {
			for (int k = 0; k < getCalcCmdArray().length; k++) {
				if (aryCommand[i].equals(getCalcCmdArray()[k])) {
					count++;
					aryCommand[i] = CommonConst.NAM_COMMON_STRING_INITIAL_VALUE;
				}
			}
		}
		if (count > 0) {
			sb.append(getCalcCmdArray()[0]);
			sb.append(CommonConst.STR_UNDER_SEPARATOR);	
		}
		for (int i = 0; i < aryCommand.length; i++) {
			if (aryCommand[i].length() != 0) {
				sb.append(aryCommand[i]);
				sb.append(CommonConst.STR_UNDER_SEPARATOR);	
			}
		}
		return sb.toString();
	}
	
	/**
	 * ΑӌvZ{^\\bh
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	protected String getMenuButton(CmComponentDto dto, boolean isMenu, String[] aryMenuCommand) {
		String[] aryCommand = util.divideByComma(dto.getComponent());
		StringBuffer sb = new StringBuffer();
		List<String> list = util.arrayToList(aryCommand);
		List<String> listMenu = util.arrayToList(aryMenuCommand);
		String menuCmd = aryMenuCommand[0];
		while (list.contains(menuCmd)) {
			list.remove(menuCmd);
		}
		if (isMenu) {
			list.add(menuCmd);
		}
		if (list.containsAll(listMenu) && isMenu) {
			sb.append(menuCmd);
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
		}
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			String select = (String) iter.next();
			if (isMenu && !listMenu.contains(select)) {
				sb.append(select);
				sb.append(CommonConst.STR_UNDER_SEPARATOR);	
			}
			if (!isMenu && listMenu.contains(select)) {
				sb.append(select);
				sb.append(CommonConst.STR_UNDER_SEPARATOR);	
			}
		}
		return sb.toString();
	}

	/**
	 * lR}hDTO擾
	 * @param CmAuthorityDto 
	 * @return DTO
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getHumanComponent(CmAuthorityDto cmAuthorityDto) throws Exception {
		CmComponentDto dto = getMenuComponent(cmAuthorityDto, AUTH_HUMAN_MENU);
		// ftHgR[h̐ݒ
		if (!VariousPart.chkExistDto(dto)) {
			dto = getDefaultCompoDto(AUTH_HUMAN_MENU);
		}
		return dto.getComponent();
	}

	/**
	 * tB[hpzݒ
	 * @param component R}hݒ
	 */
	protected List<String[]> getMenuList(String component) {
		String[] aryCommand = util.divideByComma(component);
		String[] aryMenu = new String[aryCommand.length];
		String[][] aryAllCommand = combineAllCmdArray();
		for (int i = 0 ; i < aryCommand.length ; i++) {
			aryMenu[i] = "";
			String cmdNo = aryCommand[i];
			String cmdName = util.getCodeName(cmdNo, aryAllCommand);
			if (!cmdNo.equals(cmdName)) {
				aryMenu[i] = cmdName;
			}
		}
		List<String[]> list = new ArrayList<String[]>();
		list.add(aryCommand);
		list.add(aryMenu);
		return list;
	}

	/**
	 * 
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void initCardAction(MosPMenuArrangeVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		vo.setCardParams(request);
		// DAȌ
		prepareCmComponentDao();
		// DTO̎擾
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		cmCompoDto = obj instanceof CmComponentDto ? (CmComponentDto)obj : null;
		vo.aryPltManage = getManageArray();
	}

	/**
	 * 
	 * @param vo		ΏVO
	 */
	protected void initListAction(MosPMenuArrangeVo vo) {
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		vo.aryPltManage = getManageArray();
	}

	/**
	 * j[AWCardVoݒ
	 * @param targetCmdArray		ΏۃR}hz
	 * @param division				Ώۃj[
	 * @param vo					ΏVO
	 */
	protected void setCardVoInfo(
			String[][] targetCmdArray,
			String division,
			MosPMenuArrangeVo vo
	) {
		// ڐݒ
		vo.aryPltCmdItem = targetCmdArray;
		vo.setHidDivision(division);
	}

	/**
	 * j[AWListVoݒ
	 * @param targetCmdArray		ΏۃR}hz
	 * @param division				Ώۃj[
	 * @param vo					ΏVO
	 */
	protected void setListVoInfo(
			String[][] targetCmdArray,
			String division,
			MosPMenuArrangeVo vo
	) {
		vo.aryPltCmdItem = targetCmdArray;
		vo.setHidDivision(division);
	}

	/**
	 * \
	 * @param vo	ΏVO
	 */
	protected void show(MosPMenuArrangeVo vo) {
		vo.arySelectedCmdItem = new String[0][2];
		vo.setMode(MosPMenuArrangeVo.MODE_INSERT);
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, cmCompoDto);
	}

	/**
	 * I
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void select(MosPMenuArrangeVo vo) throws Exception {
		cmCompoDto = PartManager.component(partInfo()).findForDto(key1, vo.getHidDivision());
		chkExist(cmCompoDto);
		vo.setFields(cmCompoDto);
		// [hݒ
		vo.setMode(MosPMenuArrangeVo.MODE_UPDATE);
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, cmCompoDto);
	}

	/**
	 * 
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void search(MosPMenuArrangeVo vo) throws Exception {
		vo.setListParams(request);
		searchList(vo);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(MosPMenuArrangeVo.SEARCH_ON);
	}

	/**
	 * Č
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void research(MosPMenuArrangeVo vo) throws Exception {
		if (vo.getSearchmode() == MosPMenuArrangeVo.SEARCH_ON) {
			session.removeAttribute(MospConst.ATT_DTO);
			searchList(vo);
			vo.setPageButton();
			sortList(vo);
		}
	}

	/**
	 * Xg
	 * @param vo ΏVoCX^X
	 * @throws Exception
	 */
	private void searchList(MosPMenuArrangeVo vo) throws Exception {
		// 
		prepareCmComponentDao();
		vo.setFields(cmCompoDao.findForCondition(
				vo.getTxtCompCode(),
				vo.getHidDivision(),
				vo.getTxtCompName(),
				vo.getPltManage(),
				vo.getPltDelete())								
		);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryCompCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	protected void sortList(String key, MosPMenuArrangeVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	protected void sortList(MosPMenuArrangeVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, MosPMenuArrangeVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_COMP_CODE)) {
			comp = new CmComponentCode();
		} else if (key.equals(vo.KEY_COMP_NAME)) {
			comp = new CmComponentName();
		} else if (key.equals(vo.KEY_MANAGE)) {
			comp = new CmComponentManage();
		} else if (key.equals(vo.KEY_COMPONENT)) {
			comp = new CmComponent();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompOutPutDelete();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ΏۃR[hɂrNX
	 */
	protected static class CmComponentCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -1478623163300375391L;
		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return dto1.getCompCode().compareTo(dto2.getCompCode());
		}
	}

	/**
	 * Ώۖ̂ɂrNX
	 */
	protected static class CmComponentName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -2713846748281480319L;
		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return dto1.getCompName().compareTo(dto2.getCompName());
		}
	}

	/**
	 * {ɂrNX
	 */
	protected static class CmComponentManage implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -1445454210063675079L;
		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return String.valueOf(dto1.getManage()).compareTo(String.valueOf(dto2.getManage()));
		}
	}

	/**
	 * {\@\ɂrNX
	 */
	protected static class CmComponent implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 4168257683510439452L;
		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return String.valueOf(dto1.getComponent()).compareTo(String.valueOf(dto2.getComponent()));
		}
	}

	/**
	 * 폜tOɂrNX
	 */
	protected static class CompOutPutDelete implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -1608954783023296757L;
		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}

	/**
	 * Io͍ڔz
	 * @param array		Ώarray
	 * @return	arySelectedItem
	 */
	protected String[][] setSelectedItemArray(String[] array) throws Exception {
		String[][] arySelectedItem = new String[1][2];
		arySelectedItem[0][0] = "";
		arySelectedItem[0][1] = "";
		if (chkExistObject(array)) {
			arySelectedItem = new String[array.length][2];
			for (int i = 0; i < arySelectedItem.length; i++) {
				arySelectedItem[i][0] = String.valueOf(i);
				arySelectedItem[i][1] = array[i];
			}
		}
		return arySelectedItem;
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @throws Exception
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	protected void insert(MosPMenuArrangeVo vo) throws Exception {
		// DTȌ
		CmComponentDto dto = new CmComponentDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		prepareCmComponentDao();
		cmCompoDao.initDao(cfg, cmd, aspUser, user, conn);
		chkDuplicate(cmCompoDao.findForKey(vo.getEscTxtCompCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		cmCompoDao.insert(dto);
		// DTO̍Ď擾
		CmComponentDto retDto = cmCompoDao.findForDto(dto.getCompCode(), dto.getDivision());
		chkInsert(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(MosPMenuArrangeVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, retDto);		
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	protected void update(MosPMenuArrangeVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		prepareCmComponentDao();
		// rmF
		chkExclusive(cmCompoDto, cmCompoDao.findForUpdate(vo.getEscTxtCompCode()), vo);
		// DTȌ
		vo.setDtoFields(cmCompoDto);
		// f[^̍XV
		cmCompoDao.update(cmCompoDto);
		// DTO̍Ď擾
		CmComponentDto retDto = cmCompoDao.findForDto(cmCompoDto.getCompCode(), cmCompoDto.getDivision());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(MosPMenuArrangeVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, retDto);			
	}	

	// ANZT\bh
	/**
	 * ]ƈpR}h̔z
	 * @return array
	 */
	protected String[][] getEmployeeCmdArray() {
		return MosPMenuConst.getEmployeeCmdArray();
	}

	/**
	 * }l[W[pR}h̔z
	 * @return array
	 */
	protected String[][] getManagerCmdArray() {
		return MosPMenuConst.getManagerCmdArray();
	}

	/**
	 * ^pR}h̔z
	 * @return array
	 */
	protected String[][] getPayrollCmdArray() {
		return MosPMenuConst.getPayrollCmdArray();
	}

	/**
	 * lpR}h̔z
	 * @return array
	 */
	protected String[][] getHumanCmdArray() {
		return MosPMenuConst.getHumanCmdArray();
	}

	/**
	 * VXepR}h̔z
	 * @return array
	 */
	protected String[][] getSystemCmdArray() {
		return MosPMenuConst.getSystemCmdArray();
	}

	/**
	 * ΑӌvZpR}h̔z
	 * @return array
	 */
	protected String[] getCalcCmdArray() {
		return MosPMenuConst.getCalcCmdArray();
	}

	/**
	 * ^(vZ@\)pR}h̔z쐬 cmd,name
	 * @return array
	 */
	private String[][] getPayrollRestrictCalcArray() {
		return MosPMenuConst.getPayrollRestrictCalcArray();
	}

	/**
	 * ^o^ʕ\pR}h̔z쐬 cmd,name
	 * @return array
	 */
	protected String[][] getViewPayrollCmdArray() {
		return MosPMenuConst.getViewPayrollCmdArray();
	}

	/**
	 * R}hž
	 * @return	String[][]	z
	 */
	protected String[][] combineAllCmdArray() {
		return util.combineArray(getAllCmdArrayList());
	}

	/**
	 * SR}hXg
	 * @return
	 */
	protected List<String[][]> getAllCmdArrayList() {
		List<String[][]> list = new ArrayList<String[][]>();
		list.add(getEmployeeCmdArray());
		list.add(getManagerCmdArray());
		list.add(getHumanCmdArray());
		list.add(getPayrollCmdArray());
		list.add(getSystemCmdArray());	
		return list;
	}

}
