<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "64kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.bonus.BonusConst"
import = "jp.mosp.payroll.bonus.vo.BonusListVo"
%><%
BonusListVo vo  = (BonusListVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.CMD_MENU_PAYROLL) %>
<div class="Body">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table id="tabCondition">
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_OFFICE") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= BonusListVo.PRM_PLT_OFFICE %>" name="<%= BonusListVo.PRM_PLT_OFFICE %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.getPitOffice(), vo.getPltOffice()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_SECTION") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= BonusListVo.PRM_PLT_SECTION %>" name="<%= BonusListVo.PRM_PLT_SECTION %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.getPitSection(), vo.getPltSection()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_POSITION") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= BonusListVo.PRM_PLT_POSITION %>" name="<%= BonusListVo.PRM_PLT_POSITION %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.getPitPosition(), vo.getPltPosition()) %>
					</select>
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="submitForm(document.form, 'P2022')"><%= vo.getName("C_SEARCH") %></button>
				</td>
			</tr>
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_EMPLOYEE") + vo.getName("C_CODE") + vo.getName("C_SEPARATOR") %></span>
					<input type="text" class="UserIdText" id="<%= BonusListVo.PRM_TXT_K_CODE %>" name="<%= BonusListVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>" />
				</td>
				<td colspan="2">
					<span class="TitleLabel"><%= vo.getName("C_KANA") + vo.getName("C_SEPARATOR") %></span>
					<input type="text" class="TextBox" id="<%= BonusListVo.PRM_TXT_K_KANA %>" name="<%= BonusListVo.PRM_TXT_K_KANA %>" value="<%= vo.getEscTxtKKana() %>" />
				</td>
			</tr>
		</table>
		<table id="tabConfirmMonth">
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_BONUS") %><%= vo.getName("P_ALLOWANCE") %><%= vo.getName("C_DAY") %><%= vo.getName("C_SEPARATOR") %></span>
					<select id="<%= BonusListVo.PRM_PLT_YEAR %>" name="<%= BonusListVo.PRM_PLT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.getPitYear(), String.valueOf(vo.getPltYear())) %>
					</select><%= vo.getName("C_YEAR") %>
					<select id="<%= BonusListVo.PRM_PLT_MONTH %>" name="<%= BonusListVo.PRM_PLT_MONTH %>">
						<%= HtmlUtility.getSelectOption(vo.getPitMonth(), String.valueOf(vo.getPltMonth())) %>
					</select><%= vo.getName("C_MONTH") %>
					<select id="<%= BonusListVo.PRM_PLT_DAY %>" name="<%= BonusListVo.PRM_PLT_DAY %>">
						<%= HtmlUtility.getSelectOption(vo.getPitDay(), String.valueOf(vo.getPltDay())) %>
					</select><%= vo.getName("C_DAY") %>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfoFlex(vo) %>
	<div class="List">
		<table id="tabList">
			<thead>
				<tr>
					<th class="ButtonTh"></th>
					<th class="ButtonTh"></th>
					<th id="thKCode"    onclick="doSubmitKey(document.form, 'P2024', '1', '')">&nbsp;<%= vo.getName("P_EMPLOYEE" ) + vo.getName("C_CODE") %>&nbsp;<%= vo.getSortMark("1") %></th>
					<th id="thKName"    onclick="doSubmitKey(document.form, 'P2024', '2', '')">&nbsp;<%= vo.getName("P_EMPLOYEE" ) + vo.getName("C_NAME") %>&nbsp;<%= vo.getSortMark("2") %></th>
					<th id="thOffice"   onclick="doSubmitKey(document.form, 'P2024', '3', '')">&nbsp;<%= vo.getName("P_OFFICE"   )                        %>&nbsp;<%= vo.getSortMark("3") %></th>
					<th id="thSection"  onclick="doSubmitKey(document.form, 'P2024', '4', '')">&nbsp;<%= vo.getName("P_SECTION"  )                        %>&nbsp;<%= vo.getSortMark("4") %></th>
					<th id="thPosition" onclick="doSubmitKey(document.form, 'P2024', '5', '')">&nbsp;<%= vo.getName("P_POSITION" )                        %>&nbsp;<%= vo.getSortMark("5") %></th>
					<th id="thPayTotal" onclick="doSubmitKey(document.form, 'P2024', '6', '')">&nbsp;<%= vo.getName("P_PAY_TOTAL")                        %>&nbsp;<%= vo.getSortMark("6") %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = 0; i < vo.getCount(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'P2013', '<%= vo.getAryKCode(i) %>', '<%= vo.getLblTargetMonth() %>')">
							<%= vo.getName("C_SELECT") %>
						</button>
					</td>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitFileKey(document.form, 'P2026', '<%= vo.getAryKCode(i) %>', '<%= vo.getLblTargetMonth() %>')">
							<%= vo.getName("C_EXPORT") %>
						</button>
					</td>
					<td                ><%= vo.getAryKCode   (i) %></td>
					<td                ><%= vo.getAryKName   (i) %></td>
					<td                ><%= vo.getAryOffice  (i) %></td>
					<td                ><%= vo.getArySection (i) %></td>
					<td                ><%= vo.getAryPosition(i) %></td>
					<td class="RightTd"><%= vo.getAryPayTotal(i) %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
