<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * テンプレートを操作するためのクラスです。
 * Smartyを利用して実装されています。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_View
{
    /** @var object Smartyのインスタンス */
    var $smarty;

    /**
     * コンストラクタです。
     * Smartyの動作に必要な設定を行います。
     *
     * @access public
     */
    function Moony_View()
    {
        // Smarty設定
        $this->smarty = new Smarty();
        $this->smarty->template_dir = MOONY_TEMPLATE_DIR;
        $this->smarty->config_dir = MOONY_TEMPLATE_DIR;
        $this->smarty->compile_dir = MOONY_WORK_DIR;
        $this->smarty->cache_dir = MOONY_WORK_DIR;
        $this->smarty->left_delimiter = MOONY_TEMPLATE_LEFT_DELIMITER;
        $this->smarty->right_delimiter = MOONY_TEMPLATE_RIGHT_DELIMITER;

        // エンコーディングが異なっている場合にフィルタ
        if (MOONY_TEMPLATE_ENCODING != MOONY_INTERNAL_ENCODING) {
            $this->smarty->register_prefilter(array('Moony_View', 'prefilter'));
        }
        if (MOONY_OUTPUT_ENCODING != MOONY_INTERNAL_ENCODING) {
            // mb_output_handlerで変換する場合は何もしない
            $handlers = ob_list_handlers();
            if (!in_array('mb_output_handler', $handlers)) {
              $this->smarty->register_outputfilter(array('Moony_View', 'outputfilter'));
            }
        }
    }

    /**
     * 画面描画処理を行います。
     * 
     * @access public
     * @param object $response Moony_Responseのインスタンス
     */
    function render(&$response)
    {
        // テンプレートファイル名取得、存在チェック
        if (($template = $this->getTemplate($response->getTemplate())) === false) {

            // /fooの場合、/foo/にリダイレクトしてみる
            $path_info = Moony_Utils::getEnvVar('PATH_INFO', '');
            $path_info = Moony_Utils::removeFileExtension($path_info);
            if (strlen($path_info) > 0
                    && substr($path_info, -1, 1) != '/'
                    && count(explode('/', trim($path_info, '/'))) < MOONY_EVAL_AS_ACTION_SETTING) {
                $request_uri = Moony_Utils::getEnvVar('REQUEST_URI', '');
                Moony_Utils::redirect($request_uri . '/');
            }

            Moony_Logger::warn('Template file not found: ' . $template, __FILE__, __LINE__);
            Moony_Error::notFound();
        }

        // 値の設定
        $attributes = $response->getAll();
        $this->smarty->assign($attributes);

        // エンコーディングヘッダ出力
        if (MOONY_SENDING_HEADER_ABOUT_ENCODING) {
            $encoding = MOONY_OUTPUT_ENCODING;
            if (MOONY_OUTPUT_ENCODING == 'SJIS') {
                $encoding = 'Shift_JIS';
            }
            if (MOONY_USE_XHTML_HEADER) {
                header("Content-Type: application/xhtml+xml; charset=${encoding}");
            } else {
                header("Content-Type: text/html; charset=${encoding}");
            }
        }

        $this->smarty->display($template);
    }

    /**
     * Smartyのインスタンスを取得します。
     *
     * @access public
     * @return object Smartyのインスタンス
     */
    function &getSmarty()
    {
        return $this->smarty;
    }

    /**
     * 指定されたテンプレート名に拡張子を付加してテンプレートファイル名を取得します。
     * 該当のテンプレートファイルが存在しない場合、無条件にfalseを返します。
     *
     * @access public
     * @param string $template 拡張子を除いたテンプレート名称
     * @return string|boolean テンプレートファイル名（存在しない場合、false）
     */
    function getTemplate($template)
    {
        $template = Moony_Utils::buildPath('', $template, MOONY_TEMPLATE_EXTENSION);
        if (!$this->smarty->template_exists($template)) {
            return false;
        }
        return $template;
    }

    /**
     * Smartyで使用されるプリフィルタです。
     *
     * @access public
     * @static
     * @param string $src テンプレートファイルの内容
     * @param object $smarty Smartyのインスタンス
     */
    function prefilter($src, &$smarty)
    {
        return mb_convert_encoding($src, MOONY_INTERNAL_ENCODING, MOONY_TEMPLATE_ENCODING);
    }

    /**
     * Smartyで使用される出力フィルタです。
     *
     * @access public
     * @static
     * @param string $src テンプレートファイルの内容
     * @param object $smarty Smartyのインスタンス
     */
    function outputfilter($src, &$smarty)
    {
        return mb_convert_encoding($src, MOONY_OUTPUT_ENCODING, MOONY_INTERNAL_ENCODING);
    }
}
?>
