<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * PATH_INFOを元にアクション名を決定するためのクラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Router
{
    /** @var string アクション名称 */
    var $action_name;

    /**
     * コンストラクタです。
     *
     * @access public
     */
    function Moony_Router()
    {
        $this->action_name = '';
    }

    /**
     * PATH_INFOを元にアクション名を決定します。
     *
     * @access public
     */
    function route()
    {
        // PATH_INFO取得
        $path_info = Moony_Utils::getEnvVar('PATH_INFO', '');

        // ディレクトリを指している場合、'index'を付加
        if (substr($path_info, -1) == '/') {
            $path_info .= 'index';
        }

        // スラッシュ区切りで分割
        $path_info_array = explode('/', trim($path_info, '/'));

        // 最後の要素から拡張子を除去
        $count = count($path_info_array);
        if ($count > 0) {
            $path_info_array[$count - 1] = Moony_Utils::removeFileExtension($path_info_array[$count - 1]);
        }

        // アクション名称組み立て
        // /app/reg_user の場合、 AppRegUser
        for ($i = 0; $i < MOONY_EVAL_AS_ACTION_SETTING; $i++) {
            if (isset($path_info_array[$i])) {
                $this->action_name .= Moony_Utils::camelize($path_info_array[$i]);
            } else {
                break;
            }
        }

        // 設定されていない場合、デフォルトアクション
        if (strlen($this->action_name) == 0) {
            $this->action_name = 'Index';
        }
    }

    /**
     * アクション名称を返します。
     * routeメソッドの実行後に設定されます。
     *
     * @access public
     * @return string アクション名称
     */
    function getActionName()
    {
        return $this->action_name;
    }
}
?>
