<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * アクションのフィルタ処理で使用されるクラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Filter
{
    /** @var object Moony_Requestのインスタンス */
    var $request;

    /**
     * コンストラクタです。
     * 通常はgetInstanceを使用してください。
     *
     * @access private
     */
    function Moony_Filter()
    {
    }

    /**
     * このクラスのシングルトンインスタンスを取得します。
     *
     * @access public
     * @param object $request Moony_Requestのインスタンス
     * @return object シングルトンインスタンス
     */
    function &getInstance(&$request)
    {
        static $instance = null;
        if (is_null($instance)) {
            $instance =& new Moony_Filter();
        }
        $instance->request = &$request;
        return $instance;
    }

    /**
     * 内部でmb_convert_kanaを使用してパラメータ値変換を行います。
     * $optionにはmb_convert_kanaで使用できるオプションを指定してください。
     *
     * @access public
     * @param string $name パラメータ名称
     * @param string $option 変換オプション（mb_convert_kanaで使用できるオプション）
     */
    function convertKana($name, $option)
    {
        $value = $this->request->get($name);
        if (is_array($value)) {
            $result = array();
            foreach ($value as $each) {
                $result[] = mb_convert_kana($each, $option);
            }
            $this->request->replace($name, $result);
        } else {
            $this->request->replace($name, mb_convert_kana($value, $option));
        }
    }

    /**
     * かなを全て全角カタカナに変換します。
     *
     * @access public
     * @param string $name パラメータ名称
     */
    function toKatakana($name)
    {
        $this->convertKana($name, 'KVC');
    }

    /**
     * かなを全て全角ひらがなに変換します。
     *
     * @access public
     * @param string $name パラメータ名称
     */
    function toHiragana($name)
    {
        $this->convertKana($name, 'HVc');
    }

    /**
     * 全角の英数字を半角に変換します。
     *
     * @access public
     * @param string $name パラメータ名称
     */
    function toHalfWidthAlnum($name)
    {
        $this->convertKana($name, 'a');
    }
}
?>
