<?php
// ログ出力フォーマットの定義
define('MOONY_LOG_FORMAT_LINES', "%s %s - %s(L:%s)\n");
define('MOONY_LOG_FORMAT_CALLER', "%s %s - %s\n");
define('MOONY_LOG_FORMAT_NORMAL', "%s %s\n");

/**
 * ログ出力のためのクラスです。
 * 
 * @package Moony
 * @subpackage util
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_Logger
{
    /**
     * テキストファイルにログを出力します。
     * 
     * @access public
     * @static
     * @param string $message メッセージ
     * @param string $caller 呼び出し元に関する情報（指定は任意）
     * @param integer $line 呼び出し元の行に関する情報（指定は任意）
     */
    function log($message, $caller = null, $line = null)
    {
        $system_date = date(MOONY_LOG_DATE_FORMAT);

        $log_file = MOONY_LOG_DIR . DIRECTORY_SEPARATOR . MOONY_LOG_FILE;
        if (MOONY_LOG_ROTATE) {
            $log_file .= '.' . date('Ymd');
        }

        if (strlen($caller) > 0) {
            if (strlen($line) > 0) {
                $message = sprintf(MOONY_LOG_FORMAT_LINES, $system_date, $message, $caller, $line);
            } else {
                $message = sprintf(MOONY_LOG_FORMAT_CALLER, $system_date, $message, $caller);
            }
        } else {
            $message = sprintf(MOONY_LOG_FORMAT_NORMAL, $system_date, $message);
        }

        @error_log($message, 3, $log_file);
    }
}
?>
