<?php
/**
 * リクエスト情報を格納するクラスです。
 * 
 * @package Moony
 * @subpackage core
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_Request
{
    /** @var array 実際のパラメータを格納する配列 */
    var $_params;

    /**
     * コンストラクタです。
     * 
     * @access public
     */
    function Moony_Request()
    {
        $this->_params = ($_SERVER['REQUEST_METHOD'] == 'POST') ? $_POST : $_GET;
        $this->_params = $this->_filter($this->_params);
    }

    /**
     * パラメータ値を取得します。
     * 
     * @access public
     * @param string $name パラメータキー
     * @param mixed $alt パラメータが存在しない場合の代替値（（デフォルト<code>null</code>））
     * @return mixed パラメータ値
     */
    function get($name, $alt = null)
    {
        if (!$this->exists($name)) {
            return $alt;
        }
        return $this->_params[$name];
    }

    /**
     * 全てのパラメータを連想配列として返します。
     *
     * @access public
     * @return array 全てのパラメータの連想配列
     */
    function getAll()
    {
        return $this->_params;
    }

    /**
     * 指定された名称のリクエストパラメータが
     * 存在するかどうかを返します。
     *
     * @access public
     * @param string $name パラメータキー
     * @return boolean 存在する場合<code>true</code>
     */
    function exists($name)
    {
        return isset($this->_params[$name]);
    }

    /**
     * リクエストパラメータを処理します。
     * magic_quotes_gpcがONの場合、エスケープ文字を除去します。
     * <code>MOONY_REQUEST_PARAMETER_TRANS_ENCODING</code>がtrueに設定されている場合、
     * エンコーディングの変換を行います。
     * また、NULLバイト文字列を除去します。
     *
     * @access private
     * @param mixed $data 処理対象のデータ
     * @return string 処理済の文字列
     */
    function _filter($data)
    {
        if (is_array($data)) {
            return array_map(array(&$this, '_filter'), $data);
        }
        if (get_magic_quotes_gpc()) {
            $data = stripslashes($data);
        }
        if (MOONY_REQUEST_PARAMETER_TRANS_ENCODING &&
            MOONY_OUTPUT_ENCODING != MOONY_INTERNAL_ENCODING) {
            $data = mb_convert_encoding($data, MOONY_INTERNAL_ENCODING, MOONY_OUTPUT_ENCODING);
        }
        return str_replace("\0", '', $data);
    }
}
?>
