<?php
/**
 * エラーを処理するクラスです。
 * スタティックなメソッドで構成されます。
 * 
 * @package Moony
 * @subpackage util
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_Error
{
    /**
     * 発生したエラーのハンドリングを行います。
     * エラーログを出力、HTTPのステータス500を返し、処理を終了します。
     * 
     * @access public
     * @static
     * @param integer $code エラーコード
     * @param string $message メッセージ
     * @param string $file 呼び出し元のファイル名
     * @param integer $line 呼び出し元の行番号
     */
    function handle($code, $message, $file, $line)
    {
        Moony_Logger::log($message, $file, $line);

        switch ($code) {
            case E_ERROR:
            case E_PARSE:
            case E_NOTICE:
            case E_USER_ERROR:
            case E_USER_WARNING:
            case E_USER_NOTICE:

                header('HTTP/1.0 500 Internal Server Error');
                exit(1);
        }
    }

    /**
     * エラーを発生させます。
     * エラーコードにはE_USER_ERRORを使用します。
     *
     * @access public
     * @static
     * @param string $message メッセージ
     * @param string $file 呼び出し元のファイル名
     * @param integer $line 呼び出し元の行番号
     */
    function raise($message, $file, $line)
    {
        Moony_Error::handle(E_USER_ERROR, $message, $file, $line);
    }
}
?>
