<?php
/**
 * コントローラクラスです。
 * アクションの設定・起動を行います。
 * 
 * @package Moony
 * @subpackage core
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_Controller
{
    /**
     * コンストラクタです。
     * 
     * @access public
     */
    function Moony_Controller()
    {
    }

    /**
     * 実際の処理を行います。アクションを起動します。
     * また、指定されたアクションに対応するクラスが存在しない場合は、
     * 無条件にアクション名に紐付くテンプレートを表示させます。
     * 
     * @access public
     * @param string $action_name アクション名称
     * @param array $path_info PATH_INFOの値の配列
     */
    function process($action_name, $path_info)
    {
        // HTTPヘッダ出力
        header('X-Framework: Moony/' . MOONY_VERSION);

        // コンテキストの生成
        $context = new Moony_Context();
        $context->generate($path_info);

        // Viewのインスタンス取得、テンプレート名称初期値設定
        $view =& Moony_View::getInstance();
        $view->setTemplate($action_name . '.' . MOONY_SMARTY_TEMPLATE_EXT);

        // アクションクラスに関する情報組み立て
        $action_class_name = $action_name . 'Action';
        $action_class_path = MOONY_ACTION_DIR . DIRECTORY_SEPARATOR . $action_class_name . '.' . MOONY_ACTION_EXT;

        if (file_exists($action_class_path)) {
            // アクション実行
            include_once $action_class_path;
            $action =& new $action_class_name;
            $action->execute(&$context, &$view);
        } else {
            // アクションクラスが存在しない場合、設定に応じてキャッシュ
            if (MOONY_SMARTY_USE_CACHE_WITHOUT_ACTION) {
                $view->caching = 1;
            }
        }

        // 画面表示
        if (!$view->isDisabled()) {
            $view->render();
        }
    }
}
?>
