<?php
/**
 * 処理に付随するデータを格納するクラスです。
 *
 * @package Moony
 * @subpackage core
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_Context
{
    /** @var object HTTPリクエスト情報 */
    var $_request;

    /** @var object HTTPセッション情報 */
    var $_session;

    /** @var array PATH_INFOの値の配列 */
    var $_path_info;

    /**
     * コンストラクタです。
     *
     * @access public
     */
    function Moony_Context()
    {
    }

    /**
     * 実行されているアクションのコンテキストを生成します。
     * Moony_Request、Moony_Sessionの各クラスのインスタンスを生成し、
     * 設定に応じてセッションを開始します。
     *
     * @access public
     * @param array $path_info PATH_INFOの値の配列
     */
    function generate($path_info)
    {
        // Requestクラス生成
        $this->_request =& new Moony_Request();

        // Sessionクラス生成
        $this->_session =& new Moony_Session();
        if (MOONY_SESSION_AUTO_START) {
            // セッション開始
            $this->_session->start();
        }

        $this->_path_info = $path_info;
    }

    /**
     * HTTPリクエスト情報を取得します。
     *
     * @access public
     * @return object $request HTTPリクエスト情報
     */
    function getRequest()
    {
        return $this->_request;
    }

    /**
     * HTTPセッション情報を取得します。
     *
     * @access public
     * @return object $session HTTPセッション情報
     */
    function getSession()
    {
        return $this->_session;
    }

    /**
     * 指定されたインデックスのPATH_INFOの値を返します。
     * 例えば、PATH_INFOが/foo/bar.htmlの場合、
     * getPathInfo(0)の戻り値は'foo'、
     * getPathInfo(1)の戻り値は'bar'になります。
     *
     * @access public
     * @param integer $index PATH_INFOの値の配列のインデックス
     * @param string $alt 該当のインデックスが存在しない場合の代替値
     */
    function getPathInfo($index, $alt = null)
    {
        if (isset($this->_path_info[$index])) {
            return $this->_path_info[$index];
        }
        return $alt;
    }
}
?>
