/* 
    saa6752hs.h - definition for saa6752hs MPEG encoder

    Copyright (C) 2003 Andrew de Quincey <adq@lidskialf.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _SAA6752HS_H
#define _SAA6752HS_H

enum saa6752hs_streamtype {
	SAA6752HS_STREAMTYPE_VES = 0, /* Video elementary stream only */
    	SAA6752HS_STREAMTYPE_AES = 1, /* Audio elementary stream only */
    	SAA6752HS_STREAMTYPE_PES_DVD = 2, /* DVD-compliant PES stream */
    	SAA6752HS_STREAMTYPE_PES_TS = 3, /* TS-compliant PES stream */
    	SAA6752HS_STREAMTYPE_PS_DVD = 4, /* DVD-compliant Program stream */
    	SAA6752HS_STREAMTYPE_TS = 5, /* Transport stream */
    	SAA6752HS_STREAMTYPE_PACK = 6, /* non-MPEG compliant pack stream */

	SAA6752HS_STREAMTYPE_MAX
};

enum saa6752hs_bitrate_mode {
	SAA6752HS_BITRATE_MODE_VBR = 0, /* Variable bitrate */
	SAA6752HS_BITRATE_MODE_CBR = 1, /* Constant bitrate */
    
	SAA6752HS_BITRATE_MODE_MAX
};

enum saa6752hs_audio_bitrate {
	SAA6752HS_AUDIO_BITRATE_256 = 0, /* 256 kBit/sec */
	SAA6752HS_AUDIO_BITRATE_384 = 1, /* 384 kBit/sec */
    
	SAA6752HS_AUDIO_BITRATE_MAX
};

#define SAA6752HS_VIDEO_BITRATE_MAX 27000
#define SAA6752HS_TOTAL_BITRATE_MAX 27000

struct saa6752hs_bitrate {
	enum saa6752hs_bitrate_mode bitrate_mode;
	unsigned int video_target_bitrate;
	unsigned int video_max_bitrate;
	enum saa6752hs_audio_bitrate audio_bitrate;
	unsigned int total_bitrate;
};

#define MPEG_ENC_RESET                _IO('6',1)				/* reset encoder */
#define MPEG_ENC_START                _IO('6',2)				/* start the encoder */
#define MPEG_ENC_STOP                 _IO('6',3)				/* stop the encoder */

#define SAA6752HSIOC_SETBITRATE       _IOW('6',100,struct saa6752hs_bitrate)	/* set bitrate parameters */
#define SAA6752HSIOC_GETBITRATE       _IOR('6',101,struct saa6752hs_bitrate)	/* get bitrate parameters */
#define SAA6752HSIOC_SETSTREAMTYPE    _IOW('6',102,enum saa6752hs_streamtype)	/* set stream type */
#define SAA6752HSIOC_GETSTREAMTYPE    _IOR('6',103,enum saa6752hs_streamtype)	/* get stream type */

#endif // _SAA6752HS_H

/*
 * Local variables:
 * c-basic-offset: 8
 * End:
 */
