package monalipse.bookmark;

import java.net.URL;

import org.eclipse.core.runtime.IAdaptable;

public interface IBookmarkTreeNode extends IAdaptable
{
	public static final int LOCATION_BEFORE = 1;
	public static final int LOCATION_AFTER = 2;
	public static final int LOCATION_ON = 3;

	public IBookmarkTreeNode createLink(String name, URL href, int location);
	public IBookmarkTreeNode createFolder(String name, int location);
	public void remove();
	public void setName(String name);
	public String getName();
	public boolean hasChildren();
	public IBookmarkTreeNode[] getChildren();
	public IBookmarkTreeNode getParent();
	public IBookmarkTreeNode getRoot();
	public IBookmarkTreeNode findItem(URL url);
	public boolean isAncestorOf(IBookmarkTreeNode node);
	public boolean hasNewResponses();
}
