/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.TransformerException;
import monalipse.MonalipsePlugin;
import monalipse.server.AbstractBBSServer;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSServer;
import monalipse.server.IBoardTreeNode;
import monalipse.server.giko.Board;
import monalipse.server.giko.ThreadReference;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class GikoServer
extends AbstractBBSServer {
    public static final String PREF_BBSMENU_URL = "bbsmenu.url";
    private static final String DEFAULT_BBSMENU_URL = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
    public static final String PREF_OYSTER_ID = "oyster.id";
    private static final String DEFAULT_OYSTER_ID = "";
    public static final String PREF_OYSTER_PASSWORD = "oyster.password";
    private static final String DEFAULT_OYSTER_PASSWORD = "";
    private static final long LOGIN_INTERVAL = 3600000L;
    private static final String USER_AGENT;
    private static String userAgentPrefix;
    private static HttpClient httpClient;
    private static String sessionID;
    private static long loginTime;
    private static final Logger logger;
    private Category boardTree;
    private int nextLogNumber;
    static /* synthetic */ Class class$0;

    static {
        userAgentPrefix = "Monazilla/1.00";
        httpClient = new HttpClient();
        logger = MonalipsePlugin.getLogger();
        PluginVersionIdentifier versionID = Platform.getPluginRegistry().getPluginDescriptor("monalipse").getVersionIdentifier();
        USER_AGENT = "monalipse/" + versionID;
        IPreferenceStore store = MonalipsePlugin.getDefault().getPreferenceStore();
        store.setDefault(PREF_BBSMENU_URL, DEFAULT_BBSMENU_URL);
        store.setDefault(PREF_OYSTER_ID, "");
        store.setDefault(PREF_OYSTER_PASSWORD, "");
        MonalipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(GikoServer.PREF_OYSTER_ID) || event.getProperty().equals(GikoServer.PREF_OYSTER_PASSWORD)) {
                    loginTime = 0L;
                }
            }
        });
    }

    public static HttpClient createHttpClient() {
        HttpClient client = new HttpClient();
        client.setTimeout(10000);
        return client;
    }

    public static GetMethod createGetMethod() {
        return (GetMethod)GikoServer.setMethodOptions((HttpMethod)new GetMethod(){

            public String getRequestCharSet() {
                return "Windows-31J";
            }

            public String getResponseCharSet() {
                return "Windows-31J";
            }
        });
    }

    public static PostMethod createPostMethod() {
        return (PostMethod)GikoServer.setMethodOptions((HttpMethod)new PostMethod(){

            public String getRequestCharSet() {
                return "Windows-31J";
            }

            public String getResponseCharSet() {
                return "Windows-31J";
            }
        });
    }

    private static HttpMethod setMethodOptions(HttpMethod method) {
        method.setFollowRedirects(false);
        method.setRequestHeader("User-Agent", String.valueOf(userAgentPrefix) + " (" + USER_AGENT + ")");
        return method;
    }

    public static InputStream getResponseBodyAsStream(HttpMethod get) throws IOException {
        InputStream in = get.getResponseBodyAsStream();
        Header h = get.getResponseHeader("Content-Encoding");
        if (h != null && h.getValue().equals("gzip")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String getOysterSessionID(IProgressMonitor monitor) {
        block8: {
            String string;
            block11: {
                String string2;
                block9: {
                    monitor.beginTask("Oyster", 10);
                    IPreferenceStore store = MonalipsePlugin.getDefault().getPreferenceStore();
                    String id = store.getString(PREF_OYSTER_ID);
                    String password = store.getString(PREF_OYSTER_PASSWORD);
                    try {
                        if (id.length() == 0 || password.length() == 0) break block8;
                        if (System.currentTimeMillis() - loginTime < 3600000L) {
                            string2 = sessionID;
                            Object var12_5 = null;
                            break block9;
                        }
                        try {
                            PostMethod post;
                            block10: {
                                monitor.subTask("Loggin in...");
                                HttpClient hc = GikoServer.createHttpClient();
                                URL url = new URL("https://tiger2.he.net/~tora3n2c/futen.cgi");
                                post = GikoServer.createPostMethod();
                                post.setPath(url.getFile());
                                post.setRequestHeader("User-Agent", "DOLIB/1.00");
                                post.setRequestHeader("X-2ch-UA", USER_AGENT);
                                post.setRequestBody("ID=" + id + "&PW=" + password);
                                monitor.worked(5);
                                BBSServerManager.configureHttpClient(hc, url);
                                hc.executeMethod((HttpMethod)post);
                                try {
                                    String res = post.getResponseBodyAsString().trim();
                                    res = res.substring("SESSION-ID=".length(), res.length());
                                    String ua = res.substring(0, res.indexOf(58));
                                    if (ua.equals("ERROR")) break block10;
                                    monitor.worked(5);
                                    userAgentPrefix = ua;
                                    sessionID = res;
                                    loginTime = System.currentTimeMillis();
                                    string = sessionID;
                                    Object var9_15 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_16 = null;
                                    post.releaseConnection();
                                    throw throwable;
                                }
                                post.releaseConnection();
                                break block11;
                            }
                            Object var9_17 = null;
                            post.releaseConnection();
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (IOException iOException) {}
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var12_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return string2;
            }
            Object var12_6 = null;
            monitor.done();
            return string;
        }
        Object var12_8 = null;
        monitor.done();
        return null;
    }

    public void initialize(IFolder folder) {
        super.initialize(folder);
        IPreferenceStore pref = MonalipsePlugin.getDefault().getPreferenceStore();
        pref.setDefault(PREF_BBSMENU_URL, DEFAULT_BBSMENU_URL);
        pref.setDefault(PREF_OYSTER_ID, "");
        pref.setDefault(PREF_OYSTER_PASSWORD, "");
    }

    public boolean boardListChanged(IResourceChangeEvent event) {
        return MonalipsePlugin.resourceModified(7, event.getDelta(), (IResource)this.getServerFolder().getFile(".bbsmenu"));
    }

    public IBoardTreeNode getBoardTree() {
        this.ensureBoardListLoaded();
        return this.boardTree;
    }

    private synchronized void ensureBoardListLoaded() {
        block10: {
            if (this.boardTree == null) {
                this.boardTree = new Category(this, null, "<root>");
                IFile bbsmenu = this.getServerFolder().getFile(".bbsmenu");
                try {
                    MonalipsePlugin.ensureSynchronized(bbsmenu);
                    if (!bbsmenu.exists()) break block10;
                    BoardListCacheFile cache = null;
                    try {
                        cache = BoardListCacheFile.of(new DataInputStream(bbsmenu.getContents()));
                        if (cache != null) {
                            cache.read(this, this.boardTree);
                            this.nextLogNumber = cache.nextLogNumber;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        if (cache != null) {
                            cache.close();
                        }
                        throw throwable;
                    }
                    Object var3_8 = null;
                    if (cache != null) {
                        cache.close();
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void updateBoardList() {
        HttpClient hc = GikoServer.createHttpClient();
        GetMethod get = GikoServer.createGetMethod();
        try {
            try {
                URL url = new URL(MonalipsePlugin.getDefault().getPreferenceStore().getString(PREF_BBSMENU_URL));
                get.setPath(url.getFile());
                BBSServerManager.configureHttpClient(hc, url);
                hc.executeMethod((HttpMethod)get);
                MonalipsePlugin.log(logger, (HttpMethod)get);
                if (get.getStatusLine().getStatusCode() == 200) {
                    Category root = new Category(this, null, "<root>");
                    Tidy tidy = new Tidy();
                    tidy.setCharEncoding(3);
                    tidy.setQuiet(true);
                    tidy.setShowWarnings(true);
                    Document document = tidy.parseDOM((InputStream)new ByteArrayInputStream(get.getResponseBodyAsString().getBytes("UTF-8")), null);
                    this.parseBBSMenu(document.getDocumentElement(), root, null);
                    if (root.getChildren().length > 0) {
                        this.boardTree = root;
                        this.saveCachedMenu();
                    }
                }
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            get.releaseConnection();
            throw throwable;
        }
        Object var7_12 = null;
        get.releaseConnection();
    }

    public String getTargetName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.server.giko.GikoServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public IBBSBoard getBoardOf(URL url) {
        this.ensureBoardListLoaded();
        Board board = GikoServer.getBoardOf(url, this.boardTree);
        if (board != null) {
            return board;
        }
        ThreadReference ref = ThreadReference.of(url);
        if (ref != null) {
            String dir = ref.getBoardURL().getFile();
            IBoardTreeNode[] categories = this.boardTree.getChildren();
            int i = 0;
            while (i < categories.length) {
                IBoardTreeNode[] boards = categories[i].getChildren();
                int j = 0;
                while (j < boards.length) {
                    board = (Board)boards[j];
                    if (board.getURL().toExternalForm().indexOf(dir) != -1) {
                        board.addObsoleteURL(ref.getBoardURL().toExternalForm());
                        return board;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private static Board getBoardOf(URL url, IBoardTreeNode root) {
        ThreadReference ref = ThreadReference.of(url);
        if (ref != null) {
            String boardURL = ref.getBoardURL().toExternalForm();
            IBoardTreeNode[] categories = root.getChildren();
            int i = 0;
            while (i < categories.length) {
                IBoardTreeNode[] boards = categories[i].getChildren();
                int j = 0;
                while (j < boards.length) {
                    Board board = (Board)boards[j];
                    if (board.matches(boardURL)) {
                        return board;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public URL getURLOf(IFile file) {
        IContainer log = file.getParent();
        IContainer srv = log.getParent();
        while (srv != null && !srv.equals((Object)this.getServerFolder())) {
            log = srv;
            srv = srv.getParent();
        }
        if (srv != null) {
            String dir = log.getName();
            IBoardTreeNode[] categories = this.boardTree.getChildren();
            int i = 0;
            while (i < categories.length) {
                IBoardTreeNode[] boards = categories[i].getChildren();
                int j = 0;
                while (j < boards.length) {
                    Board board = (Board)boards[j];
                    if (board.getLogFolder().getName().equals(dir)) {
                        return board.getURLOf(file);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public void createServerFolder(IProgressMonitor monitor) throws CoreException {
        if (!this.getServerFolder().exists()) {
            this.getServerFolder().create(true, true, monitor);
        }
    }

    public void saveCachedMenu() throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        BoardListCacheFile.writeCache(dout, this.boardTree, this.nextLogNumber);
        dout.close();
        final byte[] bytes = bout.toByteArray();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    GikoServer.this.createServerFolder((IProgressMonitor)monitor);
                    IFile cache = GikoServer.this.getServerFolder().getFile(".bbsmenu");
                    MonalipsePlugin.ensureSynchronized(cache);
                    if (cache.exists()) {
                        cache.setContents((InputStream)new ByteArrayInputStream(bytes), false, true, (IProgressMonitor)monitor);
                    } else {
                        cache.create((InputStream)new ByteArrayInputStream(bytes), false, (IProgressMonitor)monitor);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void parseBBSMenu(Element element, Category root, Category category) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                Element child = (Element)children.item(i);
                if (child.getTagName().equals("a") && category != null && child.getFirstChild() != null) {
                    try {
                        ThreadReference ref;
                        Category cat;
                        Board exists;
                        String url = child.getAttribute("href");
                        String name = child.getFirstChild().getNodeValue();
                        URL href = new URL(url);
                        Board board = GikoServer.getBoardOf(href, root);
                        if (board == null && (exists = GikoServer.getBoardOf(href, this.boardTree)) != null) {
                            board = new Board(this, category, exists.getLogFolder(), exists.getName(), exists.getURL(), exists.getObsoleteURLs());
                        }
                        if (board == null && (cat = (Category)this.boardTree.getChild(category.getName())) != null) {
                            board = (Board)cat.getChild(name);
                        }
                        if (board == null && (ref = ThreadReference.of(href)) != null && ref.getReferenceType() == 1) {
                            board = new Board(this, category, this.getServerFolder().getFolder("log" + this.nextLogNumber), name, href, new String[0]);
                            ++this.nextLogNumber;
                        }
                        if (board != null) {
                            if (board.getURL().getHost().equals("ime.nu")) {
                                String u = board.getURL().toExternalForm();
                                String[] s = board.getObsoleteURLs();
                                if (s.length != 0) {
                                    board.setURL(new URL(s[0]));
                                    board.removeObsoleteURL(s[0]);
                                    board.removeObsoleteURL(u);
                                }
                            }
                            board.setURL(href);
                            if (!category.hasChildren()) {
                                root.addChild(category);
                            }
                            category.addChild(board);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (child.getTagName().equals("b")) {
                    String s = child.getFirstChild().getNodeValue();
                    if (s.length() > 0) {
                        category = new Category(this, root, s);
                    }
                } else {
                    this.parseBBSMenu(child, root, category);
                }
            }
            ++i;
        }
    }

    private static class BoardListCacheFile {
        private static final int BOARD_LIST_CACHE_VERSION = 3;
        private DataInputStream din;
        public int nextLogNumber;

        public static BoardListCacheFile of(DataInputStream din) throws IOException {
            BoardListCacheFile res;
            block4: {
                res = null;
                try {
                    int version = din.readInt();
                    if (version == 3) {
                        res = new BoardListCacheFile(din);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    if (res == null) {
                        din.close();
                    }
                    throw throwable;
                }
                Object var3_5 = null;
                if (res != null) break block4;
                din.close();
            }
            return res;
        }

        BoardListCacheFile(DataInputStream din) throws IOException {
            this.din = din;
            this.nextLogNumber = din.readInt();
        }

        public void read(GikoServer server, Category root) throws IOException {
            int categoryCount = this.din.readInt();
            int i = 0;
            while (i < categoryCount) {
                Category cat = new Category(server, root, this.din.readUTF());
                root.addChild(cat);
                int boardCount = this.din.readInt();
                int j = 0;
                while (j < boardCount) {
                    String logFolder = this.din.readUTF();
                    String name = this.din.readUTF();
                    URL url = new URL(this.din.readUTF());
                    String[] obs = new String[this.din.readInt()];
                    int k = 0;
                    while (k < obs.length) {
                        obs[k] = this.din.readUTF();
                        ++k;
                    }
                    cat.addChild(new Board(server, cat, server.getServerFolder().getFolder(logFolder), name, url, obs));
                    ++j;
                }
                ++i;
            }
        }

        public void close() {
            try {
                if (this.din != null) {
                    this.din.close();
                }
                this.din = null;
            }
            catch (IOException iOException) {}
        }

        public static void writeCache(DataOutputStream dout, Category root, int nextLogNumber) throws IOException {
            dout.writeInt(3);
            dout.writeInt(nextLogNumber);
            IBoardTreeNode[] categories = root.getChildren();
            dout.writeInt(categories.length);
            int i = 0;
            while (i < categories.length) {
                IBoardTreeNode category = categories[i];
                dout.writeUTF(category.getName());
                IBoardTreeNode[] boards = category.getChildren();
                dout.writeInt(boards.length);
                int j = 0;
                while (j < boards.length) {
                    Board board = (Board)boards[j];
                    dout.writeUTF(board.getLogFolder().getName());
                    dout.writeUTF(board.getName());
                    dout.writeUTF(board.getURL().toExternalForm());
                    String[] obs = board.getObsoleteURLs();
                    dout.writeInt(obs.length);
                    int k = 0;
                    while (k < obs.length) {
                        dout.writeUTF(obs[k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static class Category
    implements IAdaptable,
    IBoardTreeNode {
        private GikoServer server;
        private IBoardTreeNode parent;
        private String name;
        private List children = new ArrayList();
        private IBoardTreeNode[] childrenArray;

        public Category(GikoServer server, IBoardTreeNode parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Category) {
                return ((Category)obj).getName().equals(this.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public IBBSServer getServer() {
            return this.server;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public IBoardTreeNode[] getChildren() {
            if (this.childrenArray == null) {
                this.childrenArray = new IBoardTreeNode[this.children.size()];
                this.children.toArray(this.childrenArray);
            }
            return this.childrenArray;
        }

        public IBoardTreeNode getParent() {
            return this.parent;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public void addChild(IBoardTreeNode child) {
            this.children.add(child);
            this.childrenArray = null;
        }

        public IBoardTreeNode getChild(String name) {
            int i = 0;
            while (i < this.children.size()) {
                IBoardTreeNode e = (IBoardTreeNode)this.children.get(i);
                if (e.getName().equals(name)) {
                    return e;
                }
                ++i;
            }
            return null;
        }
    }
}

