/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import monalipse.MonalipsePlugin;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSServer;
import monalipse.server.IBoardTreeNode;
import monalipse.server.IThreadContentProvider;
import monalipse.server.giko.GikoServer;
import monalipse.server.giko.ThreadContentProvider;
import monalipse.server.giko.ThreadReference;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.widgets.Display;

class Board
implements IAdaptable,
IBBSBoard,
IBoardTreeNode {
    private static final Logger logger = MonalipsePlugin.getLogger();
    private IBoardTreeNode parent;
    private String name;
    private String primaryURLString;
    private URL primaryURL;
    private List obsoleteURLs;
    private GikoServer server;
    private IFolder logFolder;
    private List threadList;
    private Map cacheMap = new HashMap();
    static /* synthetic */ Class class$0;

    public Board(GikoServer server, IBoardTreeNode parent, IFolder logFolder, String name, URL primaryURL, String[] obsoleteURLs) {
        this.server = server;
        this.parent = parent;
        this.logFolder = logFolder;
        this.name = name;
        this.primaryURL = primaryURL;
        this.primaryURLString = primaryURL.toExternalForm();
        this.obsoleteURLs = new ArrayList<String>(Arrays.asList(obsoleteURLs));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Board) {
            return ((Board)obj).primaryURLString.equals(this.primaryURLString);
        }
        return false;
    }

    public int hashCode() {
        return this.primaryURLString.hashCode();
    }

    public IBBSServer getServer() {
        return this.server;
    }

    public IFolder getLogFolder() {
        return this.logFolder;
    }

    public String getName() {
        return this.name;
    }

    public URL getURL() {
        return this.primaryURL;
    }

    public int getResponseNumber() {
        return -1;
    }

    public String[] getObsoleteURLs() {
        String[] obs = new String[this.obsoleteURLs.size()];
        this.obsoleteURLs.toArray(obs);
        return obs;
    }

    public boolean matches(String url) {
        if (this.primaryURLString.equals(url)) {
            return true;
        }
        int i = 0;
        while (i < this.obsoleteURLs.size()) {
            if (this.obsoleteURLs.get(i).equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IBoardTreeNode[] getChildren() {
        return new IBoardTreeNode[0];
    }

    public IBoardTreeNode getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return false;
    }

    public IThreadContentProvider[] getThreadList(String constraint) {
        ArrayList<ThreadContentProvider> list;
        this.ensureCacheLoaded();
        if (constraint != null && constraint.length() > 0) {
            constraint = this.toRegularForm(constraint);
            list = new ArrayList<ThreadContentProvider>();
            int i = 0;
            while (i < this.threadList.size()) {
                ThreadContentProvider cp = (ThreadContentProvider)this.threadList.get(i);
                if (this.isVisible(cp.getName(), constraint)) {
                    list.add(cp);
                }
                ++i;
            }
        } else {
            list = this.threadList;
        }
        IThreadContentProvider[] res = new IThreadContentProvider[list.size()];
        list.toArray(res);
        return res;
    }

    boolean containsID(String id) {
        return this.cacheMap.isEmpty() || this.cacheMap.containsKey(id);
    }

    public IThreadContentProvider getThreadOf(URL url) {
        this.ensureCacheLoaded();
        ThreadReference ref = ThreadReference.of(url);
        ThreadContentProvider cp = (ThreadContentProvider)this.cacheMap.get(ref.getID());
        if (cp != null) {
            return cp;
        }
        if (ref.getReferenceType() == 2) {
            return new ThreadContentProvider(this, ref.getBoardURL(), ref.getID(), 0, null, 0);
        }
        return null;
    }

    public URL getURLOf(IFile file) {
        ThreadContentProvider cp = (ThreadContentProvider)this.cacheMap.get(file.getName());
        if (cp != null) {
            return cp.getURL();
        }
        return this.getURL();
    }

    public boolean threadListChanged(IResourceChangeEvent event) {
        return MonalipsePlugin.resourceModified(7, event.getDelta(), (IResource)this.logFolder.getFile(".subject"));
    }

    public void updateThreadList() {
        block33: {
            try {
                BufferedReader r;
                HttpClient hc = GikoServer.createHttpClient();
                GetMethod get = GikoServer.createGetMethod();
                URL url = new URL(this.getURL(), "subject.txt");
                get.setRequestHeader("Accept-Encoding", "gzip");
                get.setPath(url.getFile());
                try {
                    String lastModified;
                    IFolder iFolder = this.getLogFolder();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("monalipse.server.giko.Board");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((lastModified = iFolder.getPersistentProperty(new QualifiedName(clazz.getName(), "Last-Modified"))) != null) {
                        get.setRequestHeader("If-Modified-Since", lastModified);
                    }
                }
                catch (CoreException coreException) {}
                BBSServerManager.configureHttpClient(hc, url);
                hc.executeMethod((HttpMethod)get);
                MonalipsePlugin.log(logger, (HttpMethod)get);
                if (get.getStatusLine().getStatusCode() == 302) {
                    get.releaseConnection();
                    BBSServerManager.configureHttpClient(hc, this.getURL());
                    get = GikoServer.createGetMethod();
                    get.setPath(this.getURL().getFile());
                    hc.executeMethod((HttpMethod)get);
                    if (get.getStatusLine().getStatusCode() == 200) {
                        String line;
                        r = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "Windows-31J"));
                        Pattern p = Pattern.compile("http.*" + this.getURL().getFile());
                        while ((line = r.readLine()) != null) {
                            Matcher m = p.matcher(line);
                            if (!m.find() || line.indexOf("ime.nu") != -1) continue;
                            this.setURL(new URL(m.group()));
                            this.server.saveCachedMenu();
                            get.releaseConnection();
                            get = GikoServer.createGetMethod();
                            get.setPath(this.getURL().getFile());
                            get.setRequestHeader("Accept-Encoding", "gzip");
                            BBSServerManager.configureHttpClient(hc, new URL(this.getURL(), "subject.txt"));
                            hc.executeMethod((HttpMethod)get);
                            break;
                        }
                    }
                }
                if (get.getStatusLine().getStatusCode() != 200) break block33;
                r = new BufferedReader(new InputStreamReader(GikoServer.getResponseBodyAsStream((HttpMethod)get), "Windows-31J"));
                try {
                    String line;
                    ArrayList<ThreadContentProvider> threadList = new ArrayList<ThreadContentProvider>();
                    HashMap<String, ThreadContentProvider> cacheMap = new HashMap<String, ThreadContentProvider>();
                    String delim = null;
                    String br = null;
                    while ((line = r.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        if (delim == null) {
                            int c = line.indexOf(",");
                            int b = line.indexOf("<>");
                            if (c == -1) {
                                if (b == -1) break;
                                delim = "<>";
                            } else if (b == -1) {
                                delim = ",";
                            } else if (c < b) {
                                delim = "b";
                            } else if (b < c) {
                                delim = "<>";
                            }
                            if (line.endsWith(")")) {
                                br = "(";
                            } else if (line.endsWith(">")) {
                                br = "<";
                            } else {
                                if (!line.endsWith("\uff09")) break;
                                br = "\uff08";
                            }
                        }
                        String id = line.substring(0, line.indexOf(delim)).trim();
                        String name = line.substring(id.length() + delim.length(), line.lastIndexOf(br)).trim();
                        int count = Integer.parseInt(line.substring(line.lastIndexOf(br) + 1, line.length() - 1).trim());
                        ThreadContentProvider thread = new ThreadContentProvider(this, this.getURL(), id, threadList.size(), name, count);
                        threadList.add(thread);
                        cacheMap.put(thread.getID(), thread);
                    }
                    Board board = this;
                    synchronized (board) {
                        this.threadList = threadList;
                        this.cacheMap = cacheMap;
                        Header h = get.getResponseHeader("Last-Modified");
                        this.saveCachedSubject(h == null ? null : h.getValue());
                    }
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    r.close();
                    get.releaseConnection();
                    throw throwable;
                }
                Object var14_23 = null;
                r.close();
                get.releaseConnection();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    public void setURL(URL url) {
        if (!this.primaryURLString.equals(url.toExternalForm())) {
            this.addObsoleteURL(this.primaryURLString);
            this.primaryURL = url;
            this.primaryURLString = url.toExternalForm();
            this.obsoleteURLs.remove(this.primaryURLString);
        }
    }

    public void addObsoleteURL(String url) {
        if (!this.obsoleteURLs.contains(url)) {
            this.obsoleteURLs.add(url);
        }
    }

    public void removeObsoleteURL(String url) {
        this.obsoleteURLs.remove(url);
    }

    public Object[] getChangedItems(IResourceChangeEvent event) {
        ArrayList list = new ArrayList();
        this.getModifiedThread(event.getDelta(), list);
        if (list.size() > 0) {
            return list.toArray();
        }
        return null;
    }

    private void getModifiedThread(IResourceDelta delta, List list) {
        if (delta != null) {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(7);
            int i = 0;
            while (i < affectedChildren.length) {
                IResource res = affectedChildren[i].getResource();
                if (this.cacheMap.containsKey(res.getName())) {
                    list.add(this.cacheMap.get(res.getName()));
                }
                this.getModifiedThread(affectedChildren[i], list);
                ++i;
            }
        }
    }

    public void createLogFolder(IProgressMonitor monitor) throws CoreException {
        if (!this.getLogFolder().exists()) {
            this.getLogFolder().create(true, true, monitor);
        }
    }

    private void saveCachedSubject(final String lastModified) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        SubjectCacheFile.writeCache(dout, this.threadList);
        dout.close();
        final byte[] bytes = bout.toByteArray();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                block7: {
                    try {
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        Board.this.server.createServerFolder((IProgressMonitor)monitor);
                        Board.this.createLogFolder((IProgressMonitor)monitor);
                        IFile cache = Board.this.logFolder.getFile(".subject");
                        MonalipsePlugin.ensureSynchronized(cache);
                        if (cache.exists()) {
                            cache.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, (IProgressMonitor)monitor);
                        } else {
                            cache.create((InputStream)new ByteArrayInputStream(bytes), false, (IProgressMonitor)monitor);
                        }
                        if (lastModified == null) break block7;
                        IFolder iFolder = Board.this.getLogFolder();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.server.giko.Board");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFolder.setPersistentProperty(new QualifiedName(clazz.getName(), "Last-Modified"), lastModified);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public synchronized void ensureCacheLoaded() {
        block11: {
            if (this.threadList == null) {
                this.threadList = new ArrayList();
                this.cacheMap = new HashMap();
                IFile subject = this.logFolder.getFile(".subject");
                try {
                    MonalipsePlugin.ensureSynchronized(subject);
                    if (!subject.exists()) break block11;
                    SubjectCacheFile subj = null;
                    try {
                        subj = SubjectCacheFile.of(new DataInputStream(subject.getContents()));
                        if (subj != null) {
                            this.getURL();
                            int i = 0;
                            while (i < subj.count) {
                                ThreadContentProvider thread = subj.readSubject(this, i);
                                this.threadList.add(thread);
                                this.cacheMap.put(thread.getID(), thread);
                                ++i;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        if (subj != null) {
                            subj.close();
                        }
                        throw throwable;
                    }
                    Object var5_10 = null;
                    if (subj != null) {
                        subj.close();
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isVisible(String title, String constraint) {
        if (constraint == null || constraint.length() == 0) {
            return true;
        }
        return this.toRegularForm(title).indexOf(constraint) != -1;
    }

    private String toRegularForm(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ('\uff41' <= ch && ch <= '\uff5a') {
                ch = (char)(97 + (ch - 65345));
            } else if ('\uff21' <= ch && ch <= '\uff3a') {
                ch = (char)(97 + (ch - 65313));
            } else if ('A' <= ch && ch <= 'Z') {
                ch = (char)(97 + (ch - 65));
            } else if ('\uff10' <= ch && ch <= '\uff19') {
                ch = (char)(48 + (ch - 65296));
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    private static class SubjectCacheFile {
        private static final int SUBJECT_CACHE_VERSION = 1;
        private DataInputStream din;
        private int count;

        public static SubjectCacheFile of(DataInputStream din) throws IOException {
            SubjectCacheFile res;
            block4: {
                res = null;
                try {
                    int version = din.readInt();
                    if (version == 1) {
                        res = new SubjectCacheFile(din);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    if (res == null) {
                        din.close();
                    }
                    throw throwable;
                }
                Object var3_5 = null;
                if (res != null) break block4;
                din.close();
            }
            return res;
        }

        SubjectCacheFile(DataInputStream din) throws IOException {
            this.din = din;
            this.count = din.readInt();
        }

        public ThreadContentProvider readSubject(Board board, int index) throws IOException {
            String id = this.din.readUTF();
            String name = this.din.readUTF();
            int responseCount = this.din.readInt();
            return new ThreadContentProvider(board, board.getURL(), id, index, name, responseCount);
        }

        public void close() {
            try {
                if (this.din != null) {
                    this.din.close();
                }
                this.din = null;
            }
            catch (IOException iOException) {}
        }

        public static void writeCache(DataOutputStream dout, List list) throws IOException {
            dout.writeInt(1);
            dout.writeInt(list.size());
            int i = 0;
            while (i < list.size()) {
                ThreadContentProvider thread = (ThreadContentProvider)list.get(i);
                dout.writeUTF(thread.getID());
                dout.writeUTF(thread.getName());
                dout.writeInt(thread.getResponseCountHint());
                ++i;
            }
        }
    }
}

