/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class Protocol {
    private static Map protocols = Collections.synchronizedMap(new HashMap());
    private String scheme;
    private ProtocolSocketFactory socketFactory;
    private int defaultPort;
    private boolean secure;

    public static void registerProtocol(String id, Protocol protocol) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        protocols.put(id, protocol);
    }

    public static void unregisterProtocol(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        protocols.remove(id);
    }

    public static Protocol getProtocol(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        Protocol protocol = (Protocol)protocols.get(id);
        if (protocol == null) {
            protocol = Protocol.lazyRegisterProtocol(id);
        }
        return protocol;
    }

    private static Protocol lazyRegisterProtocol(String id) {
        if ("http".equals(id)) {
            Protocol HTTP = new Protocol("http", new DefaultProtocolSocketFactory(), 80);
            Protocol.registerProtocol("http", HTTP);
            return HTTP;
        }
        if ("https".equals(id)) {
            Protocol HTTPS = new Protocol("https", new SSLProtocolSocketFactory(), 443);
            Protocol.registerProtocol("https", HTTPS);
            return HTTPS;
        }
        throw new IllegalStateException("unsupported protocol: '" + id + "'");
    }

    public Protocol(String scheme, ProtocolSocketFactory factory, int defaultPort) {
        if (scheme == null) {
            throw new IllegalArgumentException("scheme is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("socketFactory is null");
        }
        if (defaultPort <= 0) {
            throw new IllegalArgumentException("port is invalid: " + defaultPort);
        }
        this.scheme = scheme;
        this.socketFactory = factory;
        this.defaultPort = defaultPort;
        this.secure = false;
    }

    public Protocol(String scheme, SecureProtocolSocketFactory factory, int defaultPort) {
        if (scheme == null) {
            throw new IllegalArgumentException("scheme is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("socketFactory is null");
        }
        if (defaultPort <= 0) {
            throw new IllegalArgumentException("port is invalid: " + defaultPort);
        }
        this.scheme = scheme;
        this.socketFactory = factory;
        this.defaultPort = defaultPort;
        this.secure = true;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public ProtocolSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int resolvePort(int port) {
        return port <= 0 ? this.getDefaultPort() : port;
    }

    public String toString() {
        return String.valueOf(this.scheme) + ":" + this.defaultPort;
    }
}

