/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.methods.multipart.PartSource;

public class FilePartSource
implements PartSource {
    private File file;
    private String fileName = null;

    public FilePartSource(File file) throws FileNotFoundException {
        if (!file.isFile()) {
            throw new FileNotFoundException("File is not a normal file.");
        }
        if (!file.canRead()) {
            throw new FileNotFoundException("File is not readable.");
        }
        this.file = file;
    }

    public FilePartSource(String fileName, File file) throws FileNotFoundException {
        if (!file.isFile()) {
            throw new FileNotFoundException("File is not a normal file.");
        }
        if (!file.canRead()) {
            throw new FileNotFoundException("File is not readable.");
        }
        this.file = file;
        this.fileName = fileName;
    }

    public long getLength() {
        return this.file.length();
    }

    public String getFileName() {
        if (this.fileName == null) {
            return this.file.getName();
        }
        return this.fileName;
    }

    public InputStream createInputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

