/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.MalformedCookieException;

public class RFC2109Spec
extends CookieSpecBase {
    public void parseAttribute(NameValuePair attribute, Cookie cookie) throws MalformedCookieException {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null.");
        }
        String param_name = attribute.getName().toLowerCase();
        String param_value = attribute.getValue();
        if (param_name.equals("version")) {
            if (param_value == null) {
                throw new MalformedCookieException("Missing value for version attribute");
            }
            try {
                cookie.setVersion(Integer.parseInt(param_value));
            }
            catch (NumberFormatException e) {
                throw new MalformedCookieException("Invalid version attribute: " + e.getMessage());
            }
        } else {
            super.parseAttribute(attribute, cookie);
        }
    }

    public void validate(String host, int port, String path, boolean secure, Cookie cookie) throws MalformedCookieException {
        CookieSpecBase.log.trace((Object)"enter RFC2109Spec.validate(String, int, String, boolean, Cookie)");
        super.validate(host, port, path, secure, cookie);
        if (cookie.isDomainAttributeSpecified() && !cookie.getDomain().equals(host)) {
            if (!cookie.getDomain().startsWith(".")) {
                throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: domain must start with a dot");
            }
            int dotIndex = cookie.getDomain().indexOf(46, 1);
            if (dotIndex < 0 || dotIndex == cookie.getDomain().length() - 1) {
                throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: domain must contain an embedded dot");
            }
            if (host.substring(0, host.length() - cookie.getDomain().length()).indexOf(46) != -1) {
                throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: host minus domain may not contain any dots");
            }
        }
    }

    private String formatNameValuePair(String name, String value, int version) {
        StringBuffer buffer = new StringBuffer();
        if (version < 1) {
            buffer.append(name).append("=").append(value);
        } else {
            buffer.append(name).append("=\"").append(value).append("\"");
        }
        return buffer.toString();
    }

    private String formatCookieAsVer(Cookie cookie, int version) {
        CookieSpecBase.log.trace((Object)"enter RFC2109Spec.formatCookieAsVer(Cookie)");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.formatNameValuePair(cookie.getName(), cookie.getValue(), version));
        if (cookie.getDomain() != null && cookie.isDomainAttributeSpecified()) {
            buf.append("; ");
            buf.append(this.formatNameValuePair("$Domain", cookie.getDomain(), version));
        }
        if (cookie.getPath() != null && cookie.isPathAttributeSpecified()) {
            buf.append("; ");
            buf.append(this.formatNameValuePair("$Path", cookie.getPath(), version));
        }
        return buf.toString();
    }

    public String formatCookie(Cookie cookie) {
        CookieSpecBase.log.trace((Object)"enter RFC2109Spec.formatCookie(Cookie)");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        return this.formatCookieAsVer(cookie, cookie.getVersion());
    }

    public String formatCookies(Cookie[] cookies) {
        CookieSpecBase.log.trace((Object)"enter RFC2109Spec.formatCookieHeader(Cookie[])");
        int version = Integer.MAX_VALUE;
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            if (cookie.getVersion() < version) {
                version = cookie.getVersion();
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < cookies.length) {
            if (i2 > 0) {
                buffer.append("; ");
            }
            buffer.append(this.formatCookieAsVer(cookies[i2], version));
            ++i2;
        }
        return buffer.toString();
    }

    public Header formatCookieHeader(Cookie cookie) {
        CookieSpecBase.log.trace((Object)"enter RFC2109Spec.formatCookieHeader(Cookie)");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.formatNameValuePair("$Version", Integer.toString(cookie.getVersion()), cookie.getVersion()));
        buffer.append("; ");
        buffer.append(this.formatCookie(cookie));
        return new Header("Cookie", buffer.toString());
    }
}

