/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieSpecBase
implements CookieSpec {
    protected static final Log log;
    private static final DateFormat[] expiryFormats;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.cookie.CookieSpec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        expiryFormats = new DateFormat[]{new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd-MMM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH-mm-ss z", Locale.US), new SimpleDateFormat("EEE dd-MMM-yyyy HH-mm-ss z", Locale.US)};
    }

    public Cookie[] parse(String host, int port, String path, boolean secure, String header) throws MalformedCookieException {
        log.trace((Object)"enter CookieSpecBase.parse(String, port, path, boolean, Header)");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        HeaderElement[] headerElements = null;
        try {
            headerElements = HeaderElement.parse(header);
        }
        catch (HttpException e) {
            throw new MalformedCookieException(e.getMessage());
        }
        String defaultPath = path;
        int lastSlashIndex = defaultPath.lastIndexOf("/");
        if (lastSlashIndex > 0) {
            defaultPath = defaultPath.substring(0, lastSlashIndex);
        }
        Cookie[] cookies = new Cookie[headerElements.length];
        int i = 0;
        while (i < headerElements.length) {
            HeaderElement headerelement = headerElements[i];
            Cookie cookie = new Cookie(host, headerelement.getName(), headerelement.getValue(), defaultPath, null, false);
            NameValuePair[] parameters = headerelement.getParameters();
            if (parameters != null) {
                int j = 0;
                while (j < parameters.length) {
                    this.parseAttribute(parameters[j], cookie);
                    ++j;
                }
            }
            cookies[i] = cookie;
            ++i;
        }
        return cookies;
    }

    public Cookie[] parse(String host, int port, String path, boolean secure, Header header) throws MalformedCookieException {
        log.trace((Object)"enter CookieSpecBase.parse(String, port, path, boolean, String)");
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        return this.parse(host, port, path, secure, header.getValue());
    }

    public void parseAttribute(NameValuePair attribute, Cookie cookie) throws MalformedCookieException {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null.");
        }
        String param_name = attribute.getName().toLowerCase();
        String param_value = attribute.getValue();
        if (param_name.equals("path")) {
            if (param_value == null) {
                throw new MalformedCookieException("Missing value for path attribute");
            }
            if (param_value.trim().equals("")) {
                throw new MalformedCookieException("Blank value for path attribute");
            }
            cookie.setPath(param_value);
            cookie.setPathAttributeSpecified(true);
        } else if (param_name.equals("domain")) {
            if (param_value == null) {
                throw new MalformedCookieException("Missing value for domain attribute");
            }
            if (param_value.trim().equals("")) {
                throw new MalformedCookieException("Blank value for domain attribute");
            }
            cookie.setDomain(param_value);
            cookie.setDomainAttributeSpecified(true);
        } else if (param_name.equals("max-age")) {
            int age;
            if (param_value == null) {
                throw new MalformedCookieException("Missing value for max-age attribute");
            }
            try {
                age = Integer.parseInt(param_value);
            }
            catch (NumberFormatException e) {
                throw new MalformedCookieException("Invalid max-age attribute: " + e.getMessage());
            }
            cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
        } else if (param_name.equals("secure")) {
            cookie.setSecure(true);
        } else if (param_name.equals("comment")) {
            cookie.setComment(param_value);
        } else if (param_name.equals("expires")) {
            if (param_value == null) {
                throw new MalformedCookieException("Missing value for expires attribute");
            }
            boolean set = false;
            if (param_value.length() > 1 && param_value.startsWith("'") && param_value.endsWith("'")) {
                param_value = param_value.substring(1, param_value.length() - 1);
            }
            int k = 0;
            while (k < expiryFormats.length) {
                try {
                    Date date = expiryFormats[k].parse(param_value);
                    cookie.setExpiryDate(date);
                    set = true;
                    break;
                }
                catch (ParseException parseException) {
                    ++k;
                }
            }
            if (!set) {
                throw new MalformedCookieException("Unable to parse expiration date parameter: " + param_value);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Unrecognized cookie attribute: " + attribute.toString()));
        }
    }

    public void validate(String host, int port, String path, boolean secure, Cookie cookie) throws MalformedCookieException {
        log.trace((Object)"enter CookieSpecBase.validate(String, port, path, boolean, Cookie)");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        if (cookie.getVersion() < 0) {
            throw new MalformedCookieException("Illegal version number " + cookie.getValue());
        }
        if (host.indexOf(".") >= 0 && !host.endsWith(cookie.getDomain())) {
            throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + host + "\"");
        }
        if (!path.startsWith(cookie.getPath())) {
            throw new MalformedCookieException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + path + "\"");
        }
    }

    public boolean match(String host, int port, String path, boolean secure, Cookie cookie) {
        log.trace((Object)"enter CookieSpecBase.match(String, int, String, boolean, Cookie");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        if (cookie.getDomain() == null) {
            log.warn((Object)"Invalid cookie state: domain not specified");
            return false;
        }
        if (cookie.getPath() == null) {
            log.warn((Object)"Invalid cookie state: path not specified");
            return false;
        }
        return !(cookie.getExpiryDate() != null && !cookie.getExpiryDate().after(new Date()) || !CookieSpecBase.domainMatch(host, cookie.getDomain()) || !CookieSpecBase.pathMatch(path, cookie.getPath()) || cookie.getSecure() && !secure);
    }

    private static boolean domainMatch(String host, String domain) {
        boolean match = host.equals(domain) || domain.startsWith(".") && host.endsWith(domain);
        return match;
    }

    private static boolean pathMatch(String path, String topmostPath) {
        boolean match = path.startsWith(topmostPath);
        if (match && path.length() != topmostPath.length() && !topmostPath.endsWith("/")) {
            match = path.charAt(topmostPath.length()) == CookieSpec.PATH_DELIM_CHAR;
        }
        return match;
    }

    public Cookie[] match(String host, int port, String path, boolean secure, Cookie[] cookies) {
        log.trace((Object)"enter CookieSpecBase.match(String, int, String, boolean, Cookie[])");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (cookies == null) {
            throw new IllegalArgumentException("Cookie array may not be null");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        StringBuffer value = new StringBuffer();
        if (cookies.length <= 0) {
            return null;
        }
        LinkedList matching = new LinkedList();
        int i = 0;
        while (i < cookies.length) {
            if (this.match(host, port, path, secure, cookies[i])) {
                CookieSpecBase.addInPathOrder(matching, cookies[i]);
            }
            ++i;
        }
        return matching.toArray(new Cookie[matching.size()]);
    }

    private static void addInPathOrder(List list, Cookie addCookie) {
        int i = 0;
        i = 0;
        while (i < list.size()) {
            Cookie c = (Cookie)list.get(i);
            if (addCookie.compare(addCookie, c) > 0) break;
            ++i;
        }
        list.add(i, addCookie);
    }

    public String formatCookie(Cookie cookie) {
        log.trace((Object)"enter CookieSpecBase.formatCookie(Cookie)");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(cookie.getName()).append("=").append(cookie.getValue());
        return buf.toString();
    }

    public String formatCookies(Cookie[] cookies) throws IllegalArgumentException {
        log.trace((Object)"enter CookieSpecBase.formatCookies(Cookie[])");
        if (cookies == null) {
            throw new IllegalArgumentException("Cookie array may not be null");
        }
        if (cookies.length == 0) {
            throw new IllegalArgumentException("Cookie array may not be empty");
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < cookies.length) {
            if (i > 0) {
                buffer.append("; ");
            }
            buffer.append(this.formatCookie(cookies[i]));
            ++i;
        }
        return buffer.toString();
    }

    public Header formatCookieHeader(Cookie[] cookies) {
        log.trace((Object)"enter CookieSpecBase.formatCookieHeader(Cookie[])");
        return new Header("Cookie", this.formatCookies(cookies));
    }

    public Header formatCookieHeader(Cookie cookie) {
        log.trace((Object)"enter CookieSpecBase.formatCookieHeader(Cookie)");
        return new Header("Cookie", this.formatCookie(cookie));
    }
}

